/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.industryinfo.excel;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.els.common.excel.service.BaseExportService;
import com.els.common.utils.TimeTranslateUtil;
import com.els.modules.industryinfo.dto.GoodsTopmanItemQueryDTO;
import com.els.modules.industryinfo.entity.GoodsItem;
import com.els.modules.industryinfo.service.GoodsHeadService;
import com.els.modules.industryinfo.service.GoodsItemService;
import com.els.modules.industryinfo.vo.GoodsHeadStatisticsVO;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="goodsHeadStatisticsExportServiceImpl")
public class GoodsHeadStatisticsExportServiceImpl
extends BaseExportService<GoodsItem, GoodsHeadStatisticsVO, GoodsItem> {
    @Autowired
    private GoodsHeadService goodsHeadService;
    @Autowired
    private GoodsItemService goodsItemService;

    public List<GoodsHeadStatisticsVO> queryExportData(QueryWrapper<GoodsItem> queryWrapper, GoodsItem param, Map<String, String[]> paramMap) {
        String[] goodsIds = paramMap.get("goodsId");
        String[] topmanTimeSelects = paramMap.get("topmanTimeSelect");
        GoodsTopmanItemQueryDTO queryDTO = new GoodsTopmanItemQueryDTO();
        if (goodsIds != null && goodsIds.length > 0) {
            String goodsId = goodsIds[0];
            queryDTO.setGoodsId(goodsId);
        }
        if (topmanTimeSelects != null && topmanTimeSelects.length > 0) {
            String timeSelect = topmanTimeSelects[0];
            queryDTO.setTopmanTimeSelect(timeSelect);
        }
        Date[] dates = TimeTranslateUtil.dayToDate((String)queryDTO.getTopmanTimeSelect());
        queryDTO.setStartTime(TimeTranslateUtil.dateToLineTime((Date)dates[0]));
        queryDTO.setEndTime(TimeTranslateUtil.dateToLineTime((Date)dates[1]));
        queryWrapper.lambda().ge(GoodsItem::getSaleDate, (Object)dates[0]);
        queryWrapper.lambda().lt(GoodsItem::getSaleDate, (Object)dates[1]);
        List list = this.goodsItemService.list(queryWrapper);
        return this.goodsHeadService.replenishNew(queryDTO, list);
    }
}

