/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.industryinfo.excel;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.modules.base.api.dto.ExcelImportDTO;
import com.els.modules.base.api.service.ExcelImportRpcService;
import com.els.modules.industryinfo.entity.PromotionalDataHead;
import com.els.modules.industryinfo.service.PromotionalDataHeadService;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.compress.utils.Lists;
import org.assertj.core.util.Sets;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service(value="promotionalDataHeadImportExcelHandler")
public class PromotionalDataHeadImportExcelHandler
implements ExcelImportRpcService {
    @Autowired
    private PromotionalDataHeadService promotionalDataHeadService;

    @SrmTransaction(rollbackFor={Exception.class})
    public List<Map<String, Object>> importExcel(ExcelImportDTO var1) {
        List dataList = var1.getDataList();
        ArrayList adds = Lists.newArrayList();
        StringBuffer stringBuffer = new StringBuffer();
        int index = 1;
        HashSet uniqueSet = Sets.newHashSet();
        for (Map data : dataList) {
            PromotionalDataHead entity = (PromotionalDataHead)JSON.parseObject((String)JSON.toJSONString((Object)data), PromotionalDataHead.class);
            this.check(index, entity, stringBuffer, uniqueSet);
            ++index;
            if (ObjectUtil.isNotEmpty((Object)entity.getPopManNum()) && ObjectUtil.isNotEmpty((Object)entity.getCoopManNum())) {
                double pNum = entity.getPopManNum().intValue();
                double cNum = entity.getCoopManNum().intValue();
                double popManRate = pNum / cNum * 100.0;
                entity.setPopManRate(Double.valueOf(popManRate));
            }
            Calendar date = Calendar.getInstance();
            date.setTime(entity.getStartTime());
            entity.setCountYear(Integer.valueOf(date.get(1)));
            entity.setCountMonth(Integer.valueOf(date.get(2) + 1));
            this.handleRemoveParams(entity);
            adds.add(entity);
        }
        if (StrUtil.isNotBlank((CharSequence)stringBuffer.toString())) {
            Assert.isTrue((boolean)false, (String)stringBuffer.toString());
        }
        if (CollUtil.isNotEmpty((Collection)adds)) {
            this.promotionalDataHeadService.saveBatch((Collection)adds);
        }
        return dataList;
    }

    private void check(int index, PromotionalDataHead entity, StringBuffer stringBuffer, Set<String> uniqueSet) {
        String key;
        Calendar date = Calendar.getInstance();
        date.setTime(entity.getStartTime());
        int startYear = date.get(1);
        int startMonth = date.get(2) + 1;
        Calendar endDate = Calendar.getInstance();
        endDate.setTime(entity.getEndTime());
        int endYear = endDate.get(1);
        int endMonth = endDate.get(2) + 1;
        if (startYear != endYear || startMonth != endMonth) {
            this.getIndexTips(index, stringBuffer);
            stringBuffer.append("\u7edf\u8ba1\u5f00\u59cb\u65f6\u95f4\u548c\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u8de8\u6708;");
        }
        if (entity.getStartTime().getTime() > entity.getEndTime().getTime()) {
            this.getIndexTips(index, stringBuffer);
            stringBuffer.append("\u7edf\u8ba1\u5f00\u59cb\u65f6\u95f4\u5c0f\u4e8e\u7ed3\u675f\u65f6\u95f4;");
        }
        if (uniqueSet.contains(key = entity.getSubAccount() + startYear + startMonth)) {
            this.getIndexTips(index, stringBuffer);
            stringBuffer.append("\u5458\u5de5+\u7edf\u8ba1\u5e74\u6708\u91cd\u590d;");
        }
        uniqueSet.add(key);
    }

    private void getIndexTips(int index, StringBuffer stringBuffer) {
        String indexStr = "\u7b2c[" + index + "]\u6761\u6570\u636e\u9519\u8bef:";
        if (!stringBuffer.toString().contains(indexStr)) {
            stringBuffer.append("\u7b2c[");
            stringBuffer.append(index);
            stringBuffer.append("]\u6761\u6570\u636e\u9519\u8bef:");
        }
    }

    private void handleRemoveParams(PromotionalDataHead promotionalDataHead) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"sub_account", (Object)promotionalDataHead.getSubAccount());
        queryWrapper.eq((Object)"count_year", (Object)promotionalDataHead.getCountYear());
        queryWrapper.eq((Object)"count_month", (Object)promotionalDataHead.getCountMonth());
        this.promotionalDataHeadService.remove((Wrapper)queryWrapper);
    }
}

