/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.industryinfo.service.impl;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.I18nUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.industryinfo.dto.RewardRuleDTO;
import com.els.modules.industryinfo.entity.CommRewardRuleHead;
import com.els.modules.industryinfo.enumerate.RuleStatusEnum;
import com.els.modules.industryinfo.mapper.CommRewardRuleHeadMapper;
import com.els.modules.industryinfo.service.CommRewardRuleHeadService;
import java.io.Serializable;
import java.util.List;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class CommRewardRuleHeadServiceImpl
extends BaseServiceImpl<CommRewardRuleHeadMapper, CommRewardRuleHead>
implements CommRewardRuleHeadService {
    public void add(CommRewardRuleHead commRewardRuleHead) {
        commRewardRuleHead.setRuleStatus(RuleStatusEnum.NEW.getCode());
        ((CommRewardRuleHeadMapper)this.baseMapper).insert(commRewardRuleHead);
    }

    private void checkStatus(CommRewardRuleHead commRewardRuleHead) {
        if (ObjectUtil.isNotEmpty((Object)commRewardRuleHead.getCommRatio()) && StrUtil.isNotBlank((CharSequence)commRewardRuleHead.getPromotionType()) && StrUtil.isNotBlank((CharSequence)commRewardRuleHead.getRewardRatioJson())) {
            long count;
            if (StrUtil.equals((CharSequence)"null", (CharSequence)commRewardRuleHead.getRewardRatioJson())) {
                Assert.isTrue((boolean)false, (String)"\u5956\u52b1\u6bd4\u4f8b\u4e0d\u80fd\u4e3a\u7a7a");
            }
            Assert.isTrue(((count = (long)this.count((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(CommRewardRuleHead::getRuleStatus, (Object)RuleStatusEnum.PUBLISHED.getCode())).eq(BaseEntity::getDeleted, (Object)"0")).eq(BaseEntity::getElsAccount, (Object)TenantContext.getTenant())).eq(CommRewardRuleHead::getPromotionType, (Object)commRewardRuleHead.getPromotionType())).ne(StrUtil.isNotBlank((CharSequence)commRewardRuleHead.getId()), BaseEntity::getId, (Object)commRewardRuleHead.getId()))) == 0L ? 1 : 0) != 0, (String)"\u5df2\u5b58\u5728\u76f8\u540c\u63a8\u5e7f\u7c7b\u578b\u7684\u63d0\u6210\u5956\u52b1\u89c4\u5219");
            commRewardRuleHead.setRuleStatus(RuleStatusEnum.PUBLISHED.getCode());
        } else {
            Assert.isTrue((boolean)false, (String)"\u7f3a\u5c11\u5fc5\u586b\u53c2\u6570");
        }
    }

    public void edit(CommRewardRuleHead commRewardRuleHead) {
        int count = ((CommRewardRuleHeadMapper)this.baseMapper).updateById(commRewardRuleHead);
        Assert.isTrue((count != 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
    }

    public void delete(String id) {
        ((CommRewardRuleHeadMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    public void deleteBatch(List<String> idList) {
        ((CommRewardRuleHeadMapper)this.baseMapper).deleteBatchIds(idList);
    }

    public List<CommRewardRuleHead> getRuleByElsAccount(String elsAccount) {
        return this.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(BaseEntity::getElsAccount, (Object)elsAccount)).eq(BaseEntity::getDeleted, (Object)"0")).eq(CommRewardRuleHead::getRuleStatus, (Object)RuleStatusEnum.PUBLISHED.getCode()));
    }

    public String handleRewardShow(String json) {
        List rewardRuleDTOS = JSONArray.parseArray((String)json, RewardRuleDTO.class);
        StringBuffer stringBuffer = new StringBuffer();
        for (RewardRuleDTO rewardRuleDTO : rewardRuleDTOS) {
            stringBuffer.append("\u5956\u52b1\u533a\u95f4\uff1a\u3010");
            stringBuffer.append(rewardRuleDTO.getSaleStart());
            stringBuffer.append("\u3011");
            stringBuffer.append(" \u5956\u52b1\u6bd4\u4f8b\u4e3a\uff1a");
            stringBuffer.append(rewardRuleDTO.getRewardRatio());
            stringBuffer.append("\uff1b");
        }
        return stringBuffer.toString();
    }

    public void publish(CommRewardRuleHead ruleHead) {
        this.checkStatus(ruleHead);
        if (StrUtil.isNotBlank((CharSequence)ruleHead.getId())) {
            this.edit(ruleHead);
        } else {
            this.save(ruleHead);
        }
    }
}

