/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.industryinfo.service.impl;

import cn.hutool.core.util.StrUtil;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.I18nUtil;
import com.els.common.util.RedisUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.industryinfo.entity.GoodsCategory;
import com.els.modules.industryinfo.mapper.GoodsCategoryMapper;
import com.els.modules.industryinfo.service.GoodsCategoryService;
import com.els.modules.industryinfo.vo.GoodsCategoryVo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class GoodsCategoryServiceImpl
extends BaseServiceImpl<GoodsCategoryMapper, GoodsCategory>
implements GoodsCategoryService {
    private static final Logger log = Logger.getLogger(GoodsCategoryServiceImpl.class);
    @Autowired
    private GoodsCategoryMapper categoryMapper;
    @Autowired
    private RedisUtil redisUtil;
    private static final String CATALOGUE = "good:category:cache";
    private static final String COLON = ":";

    public List<GoodsCategoryVo> queryCategoryList() {
        StringBuilder redisKey;
        List goodsCategories;
        String language = I18nUtil.getCurrentLanguage();
        if (StrUtil.isBlank((CharSequence)language)) {
            language = "zh";
        }
        if ((goodsCategories = (List)this.redisUtil.get((redisKey = new StringBuilder(CATALOGUE).append(TenantContext.getTenant()).append(COLON).append(COLON).append(language)).toString())) == null) {
            log.info((Object)"\u65e0\u7f13\u5b58goodsCategories\u7684\u65f6\u5019\u8c03\u7528\u8fd9\u91cc\uff01");
            goodsCategories = this.categoryMapper.selectList();
            HashMap<String, GoodsCategoryVo> map = new HashMap<String, GoodsCategoryVo>(goodsCategories.size());
            GoodsCategoryVo goodsCategoryVo = (GoodsCategoryVo)goodsCategories.get(goodsCategories.size() - 1);
            String level = goodsCategoryVo.getLevel();
            for (int i = 0; i < goodsCategories.size(); ++i) {
                GoodsCategoryVo gc = (GoodsCategoryVo)goodsCategories.get(i);
                String parentId = gc.getParentId();
                GoodsCategoryVo pgc = (GoodsCategoryVo)map.get(parentId);
                if (pgc != null) {
                    ArrayList<GoodsCategoryVo> children = pgc.getChildren();
                    if (children == null) {
                        children = new ArrayList<GoodsCategoryVo>();
                        pgc.setChildren(children);
                    }
                    children.add(gc);
                }
                if (level.equals(gc.getLevel())) continue;
                map.put(gc.getCategoryId(), gc);
            }
            if (CollectionUtils.isNotEmpty((Collection)goodsCategories)) {
                this.redisUtil.set(redisKey.toString(), (Object)goodsCategories, 7200L);
            }
        }
        return goodsCategories.subList(0, 1);
    }

    @Transactional
    public void insertBatch(List<List<GoodsCategory>> goodsCategorys) {
        this.delete();
        goodsCategorys.stream().filter(a -> a.size() > 0).forEach(arg_0 -> ((GoodsCategoryMapper)((GoodsCategoryMapper)this.baseMapper)).insertBatch(arg_0));
    }

    public void delete() {
        ((GoodsCategoryMapper)this.baseMapper).delete();
    }

    public void cleanCache() {
        String language = I18nUtil.getCurrentLanguage();
        if (StrUtil.isBlank((CharSequence)language)) {
            language = "zh";
        }
        StringBuilder redisKey = new StringBuilder(CATALOGUE).append(TenantContext.getTenant()).append(COLON).append(COLON).append(language);
        this.redisUtil.del(new String[]{redisKey.toString()});
    }
}

