/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.industryinfo.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.text.StrBuilder;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.constant.CommonConstant;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.I18nUtil;
import com.els.common.util.SysUtil;
import com.els.modules.industryinfo.dto.TopManMsgReplyDto;
import com.els.modules.industryinfo.dto.TopManMsgTurnRq;
import com.els.modules.industryinfo.dto.TopmanMsgRqDto;
import com.els.modules.industryinfo.entity.TopManMsgConfig;
import com.els.modules.industryinfo.entity.TopManMsgRecord;
import com.els.modules.industryinfo.entity.TopManMsgRecordHis;
import com.els.modules.industryinfo.entity.TopManMsgTask;
import com.els.modules.industryinfo.enumerate.MsgTopManSourceEnum;
import com.els.modules.industryinfo.mapper.TopManMsgRecordMapper;
import com.els.modules.industryinfo.service.TopManMsgConfigService;
import com.els.modules.industryinfo.service.TopManMsgRecordHisService;
import com.els.modules.industryinfo.service.TopManMsgRecordService;
import com.els.modules.industryinfo.service.TopManMsgTaskService;
import com.els.modules.industryinfo.utils.MsgConvertUtil;
import com.els.modules.industryinfo.utils.spider.entity.DyIDList;
import com.els.modules.industryinfo.utils.spider.entity.DyTopManDetailBaseInfoEntity;
import com.els.modules.industryinfo.utils.spider.entity.DyTopManIndexListPage;
import com.els.modules.industryinfo.utils.spider.entity.DyTopManInfoEntity;
import com.els.modules.industryinfo.utils.spider.properties.SpiderMethodType;
import com.els.modules.industryinfo.utils.spider.spiderApi.SpiderApiUtil;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.compress.utils.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class TopManMsgRecordServiceImpl
extends BaseServiceImpl<TopManMsgRecordMapper, TopManMsgRecord>
implements TopManMsgRecordService {
    private static final Logger log = LoggerFactory.getLogger(TopManMsgRecordServiceImpl.class);
    @Lazy
    @Autowired
    private TopManMsgRecordHisService recordHisService;
    @Autowired
    @Lazy
    private TopManMsgConfigService topManMsgConfigService;
    @Autowired
    @Lazy
    private TopManMsgRecordService topManMsgRecordService;
    @Autowired
    @Lazy
    private TopManMsgTaskService topManMsgTaskService;
    @Autowired
    private SpiderApiUtil spiderApiUtil;

    @Override
    public void add(TopManMsgRecord topManMsgRecord) {
        LoginUser loginUser = SysUtil.getLoginUser();
        Assert.isTrue((this.count((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(TopManMsgRecord::getTopmanName, (Object)topManMsgRecord.getTopmanName())).eq(TopManMsgRecord::getSubAccount, (Object)loginUser.getSubAccount())).eq(BaseEntity::getElsAccount, (Object)loginUser.getElsAccount())).eq(TopManMsgRecord::getSubAdd, (Object)MsgTopManSourceEnum.MANUALLY_ADDED.getCode())) == 0 ? 1 : 0) != 0, (String)"\u8be5\u8fbe\u4eba\u5df2\u5b58\u5728\u81ea\u52a8\u5efa\u8054\u5217\u8868\uff0c\u8bf7\u52ff\u91cd\u590d\u6dfb\u52a0");
        Assert.isTrue((this.count((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(TopManMsgRecord::getTopmanName, (Object)topManMsgRecord.getTopmanName())).eq(BaseEntity::getElsAccount, (Object)loginUser.getElsAccount())).eq(TopManMsgRecord::getSubAccount, (Object)loginUser.getSubAccount())).eq(TopManMsgRecord::getSendStatus, (Object)CommonConstant.STATUS_NO)) == 0 ? 1 : 0) != 0, (String)"\u6b64\u8fbe\u4eba\u8be5\u8d26\u53f7\u5df2\u6709\u6210\u529f\u89e6\u8fbe\u7684\u8bb0\u5f55");
        if (StrUtil.isNotBlank((CharSequence)topManMsgRecord.getTopmanLevel())) {
            topManMsgRecord.setTopmanLevel(topManMsgRecord.getTopmanLevelId());
        }
        if (StrUtil.isNotBlank((CharSequence)topManMsgRecord.getAvatar())) {
            topManMsgRecord.setAvatar(topManMsgRecord.getAvatar().replaceAll("-sign", ""));
        }
        topManMsgRecord.setTopmanSex(topManMsgRecord.getTopmanGenderId());
        topManMsgRecord.setSubAdd(MsgTopManSourceEnum.MANUALLY_ADDED.getCode());
        topManMsgRecord.setSubAccount(loginUser.getSubAccount());
        topManMsgRecord.setSendStatus("0");
        topManMsgRecord.setPush("0");
        topManMsgRecord.setReplyStatus("0");
        topManMsgRecord.setDeleted(CommonConstant.STATUS_NO);
        topManMsgRecord.setId(null);
        ((TopManMsgRecordMapper)this.baseMapper).insert(topManMsgRecord);
    }

    @Override
    public void edit(TopManMsgRecord topManMsgRecord) {
        int count = ((TopManMsgRecordMapper)this.baseMapper).updateById(topManMsgRecord);
        Assert.isTrue((count != 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
    }

    @Override
    public void delete(String id) {
        ((TopManMsgRecordMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    public void deleteBatch(List<String> idList) {
        ((TopManMsgRecordMapper)this.baseMapper).deleteBatchIds(idList);
    }

    @Override
    public void handleMsg(TopmanMsgRqDto msg) {
        TopManMsgRecordHis his = (TopManMsgRecordHis)((Object)this.recordHisService.getById((Serializable)((Object)msg.getTaskId())));
        if (ObjectUtil.isEmpty((Object)((Object)his))) {
            return;
        }
        TopManMsgRecord record = (TopManMsgRecord)this.getById((Serializable)((Object)his.getTaskId()));
        if (ObjectUtil.isEmpty((Object)record)) {
            return;
        }
        if ("200".equals(msg.getCode())) {
            record.setSendStatus("1");
            record.setSendCount(Integer.valueOf(record.getSendCount() + 1));
            if (ObjectUtil.isEmpty((Object)record.getSendTime())) {
                record.setSendTime(new Date());
            }
            record.setLateSendTime(new Date());
            his.setSendMsgId(record.getMsgId());
            his.setSendMsgContent(record.getMsgContent());
            TopManMsgConfig config = (TopManMsgConfig)this.topManMsgConfigService.getById((Serializable)((Object)record.getMsgId()));
            his.setMsgType(config.getMsgType());
            his.setTaskId(record.getId());
            his.setSortNum(config.getSortNum());
            his.setReplyStatus("0");
            his.setSendTime(DateUtil.formatDateTime((Date)new Date()));
            his.setCreateBy(record.getCreateBy());
            his.setCreateTime(new Date());
            his.setUpdateBy(record.getCreateBy());
            his.setUpdateTime(new Date());
            his.setElsAccount(record.getElsAccount());
            this.recordHisService.updateById((Object)his);
        } else {
            record.setSendStatus("0");
        }
        this.updateById(record);
    }

    @Override
    public void turn(TopManMsgTurnRq rq) {
        List records = this.listByIds(rq.getTaskIds());
        records.forEach(x -> {
            x.setSubAccount(rq.getSubAccount());
            x.setTurn("1");
            x.setSendStatus("0");
        });
        this.updateBatchById(records);
    }

    @Override
    @SrmTransaction(rollbackFor={Exception.class})
    public void handleReplyMsg(TopManMsgReplyDto msg) {
        if (StrUtil.isBlank((CharSequence)msg.getPlatform())) {
            return;
        }
        TopManMsgTask task = (TopManMsgTask)this.topManMsgTaskService.getOne((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(TopManMsgTask::getPlatform, (Object)msg.getPlatform())).eq(TopManMsgTask::getPlatformAccount, (Object)msg.getUserName()), false);
        if (ObjectUtil.isEmpty((Object)task)) {
            log.error("\u5904\u7406\u8fbe\u4eba\u6d88\u606f\u8d26\u53f7[{}]\u5e73\u53f0[{}]\u672a\u627e\u5230\u5bf9\u5e94\u7684\u4efb\u52a1", (Object)task.getPlatformAccount(), (Object)task.getPlatform());
            return;
        }
        List<TopManMsgReplyDto.Msg> msgs = msg.getMsgList();
        if (CollUtil.isEmpty(msgs)) {
            log.error("\u5904\u7406\u8fbe\u4eba\u6d88\u606f\u8d26\u53f7[{}]\u5e73\u53f0[{}]\u5bf9\u5e94\u7684\u6d88\u606f\u4e3a\u7a7a", (Object)task.getPlatformAccount(), (Object)task.getPlatform());
            return;
        }
        if (StrUtil.isNotBlank((CharSequence)msg.getTaskId())) {
            TopManMsgRecordHis his = (TopManMsgRecordHis)((Object)this.recordHisService.getById((Serializable)((Object)msg.getTaskId())));
            if (ObjectUtil.isEmpty((Object)((Object)his))) {
                return;
            }
            TopManMsgRecord record = (TopManMsgRecord)this.getById((Serializable)((Object)his.getTaskId()));
            if (ObjectUtil.isEmpty((Object)record)) {
                return;
            }
            ArrayList replys = Lists.newArrayList();
            boolean flag = false;
            for (TopManMsgReplyDto.Msg msg1 : msgs) {
                if (flag) {
                    replys.add(msg1);
                }
                if (!msg1.getMsg().equals(his.getSendMsgContent()) || !msg1.getChatUserType().equals("2")) continue;
                flag = true;
            }
            if (CollUtil.isNotEmpty((Collection)replys)) {
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                TopManMsgReplyDto.Msg r = replys.stream().filter(x -> StrUtil.isNotBlank((CharSequence)x.getTime())).findFirst().orElse(null);
                String replyTime = Optional.ofNullable(r.getTime()).orElse(sdf.format(new Date()));
                String replyContent = replys.stream().map(x -> x.getMsg()).collect(Collectors.joining(","));
                his.setReplyContent(replyContent);
                his.setReplyTime(replyTime);
                his.setReplyStatus("1");
                record.setReplyCount(Integer.valueOf(record.getReplyCount() + 1));
                record.setReplyTime(replyTime);
                record.setReplyContent(replyContent);
                record.setReplyStatus("1");
                this.recordHisService.updateById((Object)his);
                this.updateById(record);
            }
        } else {
            Map<String, List<TopManMsgReplyDto.Msg>> msgTypes = msg.getMsgList().stream().collect(Collectors.groupingBy(x -> x.getChatUserType()));
            if (ObjectUtil.isEmpty(msgTypes) || CollUtil.isEmpty((Collection)msgTypes.get("1"))) {
                return;
            }
            if (StrUtil.isBlank((CharSequence)msg.getNew_man_id())) {
                log.info("\u5904\u7406\u4e0d\u662f\u81ea\u52a8\u89e6\u8fbe\u8fbe\u4eba\u65f6,topmanName:{}\uff0cpy\u672a\u4f20uid", (Object)msg.getTopmanName());
                return;
            }
            TopManMsgRecord topManMsgRecord = this.getRecordByUid(msg.getNew_man_id(), msg.getAvatar_url(), msg.getTopmanName(), task);
            if (ObjectUtil.isEmpty((Object)topManMsgRecord)) {
                return;
            }
            TopManMsgRecord dbRecord = (TopManMsgRecord)this.topManMsgRecordService.getOne((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(TopManMsgRecord::getTaskId, (Object)task.getId())).eq(TopManMsgRecord::getUid, (Object)msg.getNew_man_id()), false);
            String taskId = null;
            if (ObjectUtil.isEmpty((Object)dbRecord)) {
                topManMsgRecord.setUid(msg.getNew_man_id());
                topManMsgRecord.setTaskId(task.getId());
                topManMsgRecord.setPush("0");
                topManMsgRecord.setId(IdWorker.getIdStr());
                topManMsgRecord.setSubAdd(CollUtil.isNotEmpty((Collection)msgTypes.get("2")) ? MsgTopManSourceEnum.PRO_CONTACTS.getCode() : MsgTopManSourceEnum.INITIATIVE_RETRIEVAL.getCode());
                this.topManMsgRecordService.save(topManMsgRecord);
                taskId = topManMsgRecord.getId();
            } else {
                taskId = dbRecord.getId();
            }
            ArrayList dbHis = Lists.newArrayList();
            if (CollUtil.isNotEmpty((Collection)msgTypes.get("2"))) {
                for (int i = 0; i < msgs.size(); ++i) {
                    if (!"2".equals(msgs.get(i).getChatUserType()) || i != msgs.size() - 1 && "2".equals(msgs.get(i + 1).getChatUserType()) || !this.checkHisRepeat(msgs.get(i).getMsg(), msgs.get(i).getTime(), null, null, taskId)) continue;
                    TopManMsgRecordHis topManMsgRecordHis = new TopManMsgRecordHis();
                    topManMsgRecordHis.setSendMsgContent(msgs.get(i).getMsg());
                    topManMsgRecordHis.setElsAccount(task.getElsAccount());
                    topManMsgRecordHis.setSubAccount(task.getSubAccount());
                    topManMsgRecordHis.setPlatform(task.getPlatform());
                    topManMsgRecordHis.setTaskId(taskId);
                    topManMsgRecordHis.setSendTime(msgs.get(i).getTime());
                    boolean flag = false;
                    StrBuilder strBuilder = new StrBuilder();
                    for (int j = i + 1; !(j >= msgs.size() || flag && "2".equals(msgs.get(j).getChatUserType())); ++j) {
                        if (strBuilder.length() > 0) {
                            strBuilder.append((CharSequence)";");
                        }
                        if (!"1".equals(msgs.get(j).getChatUserType())) continue;
                        topManMsgRecordHis.setReplyTime(msgs.get(j).getTime());
                        strBuilder.append((CharSequence)msgs.get(j).getMsg());
                        flag = true;
                    }
                    topManMsgRecordHis.setReplyContent(strBuilder.toString());
                    dbHis.add(topManMsgRecordHis);
                }
            } else {
                for (TopManMsgReplyDto.Msg msg1 : msg.getMsgList()) {
                    if (!this.checkHisRepeat(null, null, msg1.getMsg(), msg1.getTime(), taskId)) continue;
                    TopManMsgRecordHis his = new TopManMsgRecordHis();
                    his.setReplyContent(msg1.getMsg());
                    his.setTaskId(taskId);
                    his.setElsAccount(task.getElsAccount());
                    his.setSubAccount(task.getSubAccount());
                    his.setPlatform(task.getPlatform());
                    his.setReplyTime(msg1.getTime());
                    dbHis.add(his);
                }
            }
            if (CollUtil.isNotEmpty((Collection)dbHis)) {
                this.recordHisService.saveBatch(dbHis);
            }
        }
    }

    @Override
    public String checkIsAdded(TopManMsgRecord x) {
        return ((TopManMsgRecordMapper)this.baseMapper).checkIsAdded(x);
    }

    private boolean checkHisRepeat(String sendMsg, String sengTime, String replyMsg, String replyTime, String recordId) {
        return this.recordHisService.count((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(TopManMsgRecordHis::getTaskId, (Object)recordId)).eq(StrUtil.isNotBlank((CharSequence)sendMsg), TopManMsgRecordHis::getSendMsgContent, (Object)sendMsg)).eq(StrUtil.isNotBlank((CharSequence)sengTime), TopManMsgRecordHis::getSendTime, (Object)sengTime)).eq(StrUtil.isNotBlank((CharSequence)replyMsg), TopManMsgRecordHis::getReplyContent, (Object)replyMsg)).eq(StrUtil.isNotBlank((CharSequence)replyTime), TopManMsgRecordHis::getReplyTime, (Object)replyTime)) == 0;
    }

    public TopManMsgRecord getRecordByUid(String uid, String avatar, String topManName, TopManMsgTask topManMsgTask) {
        String accountDouYin;
        TopManMsgRecord record;
        block12: {
            record = null;
            DyTopManDetailBaseInfoEntity baseInfo = null;
            accountDouYin = null;
            try {
                baseInfo = (DyTopManDetailBaseInfoEntity)this.spiderApiUtil.getForEntity(SpiderMethodType.DOU_YIN_BASE_INFO, Collections.singletonMap("uid", uid), DyTopManDetailBaseInfoEntity.class);
                accountDouYin = baseInfo.getAccountDouyin();
            }
            catch (Exception e) {
                log.error("name:{}uid:{}\u83b7\u53d6\u6296\u97f3id\u5f02\u5e38{}", new Object[]{topManName, uid, e.getMessage()});
                if ("\u6682\u672a\u5165\u9a7b\u8fbe\u4eba\u5e7f\u573a\uff0c\u65e0\u6cd5\u67e5\u770b\u8fbe\u4eba\u4fe1\u606f".equals(e.getMessage())) {
                    return null;
                }
                log.error("getRecordByUid error", (Throwable)e);
            }
            if (ObjectUtil.isEmpty((Object)baseInfo) || StrUtil.isEmpty((CharSequence)accountDouYin)) {
                try {
                    if (StrUtil.isEmpty((CharSequence)avatar)) {
                        log.error("topManName:{}uid:{}\u5934\u50cf\u53c2\u6570\u4e3a\u7a7a", (Object)topManName, (Object)uid);
                        return null;
                    }
                    DyIDList response = (DyIDList)((Object)this.spiderApiUtil.getForEntity(SpiderMethodType.DOU_YIN_GET_DOU_YIN_ID, Collections.singletonMap("topman_name", topManName), DyIDList.class));
                    if (!ObjectUtil.isNotEmpty((Object)((Object)response))) break block12;
                    List<DyIDList.DyIDResult> dyIDResults = response.getResult();
                    for (DyIDList.DyIDResult dyIDResult : dyIDResults) {
                        String uri = dyIDResult.getUser_info().getAvatar_thumb().getUri();
                        String[] uris = uri.split("/");
                        String endUri = uris[uris.length - 1];
                        if (!avatar.contains(endUri)) continue;
                        accountDouYin = dyIDResult.getUser_info().getUnique_id();
                        break;
                    }
                }
                catch (Exception e) {
                    log.error("DOU_YIN_GET_DOU_YIN_ID error", (Throwable)e);
                }
            }
        }
        if (StrUtil.isNotBlank((CharSequence)accountDouYin)) {
            HashMap apiParam = Maps.newHashMap();
            apiParam.put("type", "1");
            apiParam.put("page", "1");
            apiParam.put("refresh", "true");
            apiParam.put("req_source", "0");
            apiParam.put("options", Maps.newHashMap());
            apiParam.put("search_id", "");
            apiParam.put("search_source", "");
            apiParam.put("query", accountDouYin);
            DyTopManIndexListPage apiResult = null;
            try {
                apiResult = (DyTopManIndexListPage)this.spiderApiUtil.postForEntity(SpiderMethodType.DOU_YIN_INDEX_LIST, (Map)apiParam, DyTopManIndexListPage.class);
            }
            catch (Exception e) {
                log.error("DOU_YIN_INDEX_LIST error", (Throwable)e);
            }
            if (ObjectUtil.isNotEmpty((Object)apiResult) && CollUtil.isNotEmpty(apiResult.getList())) {
                record = MsgConvertUtil.convertDyList((TopManMsgTask)topManMsgTask, null, (DyTopManInfoEntity)apiResult.getList().get(0));
            }
            System.out.println("accountDouYin:" + apiResult);
        }
        return record;
    }
}

