/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.industryinfo.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.system.query.QueryGenerator;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.I18nUtil;
import com.els.common.util.RedisUtil;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.account.api.service.AccountRpcService;
import com.els.modules.industryInfo.api.dto.SimplePostRequestParam;
import com.els.modules.industryInfo.api.weboption.TopManOptionsEntity;
import com.els.modules.industryinfo.dto.ZhiHuTopManCollectDTO;
import com.els.modules.industryinfo.dto.ZhiHuTopManDetailDTO;
import com.els.modules.industryinfo.dto.ZhiHuTopManInformationDTO;
import com.els.modules.industryinfo.entity.TopManCollectBean;
import com.els.modules.industryinfo.entity.ZhiHuTopManInformation;
import com.els.modules.industryinfo.enumerate.MarkYn;
import com.els.modules.industryinfo.enumerate.ZhiHuOptionsType;
import com.els.modules.industryinfo.enumerate.ZhiHuOptionsTypeGroup;
import com.els.modules.industryinfo.mapper.ZhiHuTopManInformationMapper;
import com.els.modules.industryinfo.service.TopManCollectService;
import com.els.modules.industryinfo.service.ZhiHuTopManInformationService;
import com.els.modules.industryinfo.utils.spider.entity.ZhiHuTopManEntity;
import com.els.modules.industryinfo.utils.spider.entity.ZhiHuTopManPage;
import com.els.modules.industryinfo.utils.spider.entity.ZhuHuManDetailHeadEntity;
import com.els.modules.industryinfo.utils.spider.properties.SpiderMethodType;
import com.els.modules.industryinfo.utils.spider.spiderApi.SpiderApiUtil;
import com.els.modules.industryinfo.utils.spider.vo.ZhuHuManDetailHeadVO;
import com.els.modules.industryinfo.weboption.OptionFactory;
import com.els.modules.industryinfo.weboption.function.DocHandler;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.bson.Document;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ZhiHuTopManInformationServiceImpl
extends BaseServiceImpl<ZhiHuTopManInformationMapper, ZhiHuTopManInformation>
implements ZhiHuTopManInformationService {
    @Autowired
    private TopManCollectService topManCollectService;
    @Autowired
    private SpiderApiUtil spiderApiUtil;
    @Autowired
    private RedisUtil redisUtil;
    @Resource
    private AccountRpcService accountRpcService;

    @Override
    public List<TopManOptionsEntity> getOptions(String type, String contentType, String clearCache) {
        OptionFactory.OptionHandler<ZhiHuOptionsTypeGroup, ZhiHuOptionsType> init = OptionFactory.init(ZhiHuOptionsTypeGroup.class, ZhiHuOptionsType.class);
        init.setCollection("tb_zhihu_category");
        switch (contentType) {
            case "all": {
                init.when(ZhiHuOptionsType.domainType, DocHandler.jsonTransferHandle(a -> a.setSubTags(null))).when(ZhiHuOptionsType.contentType, DocHandler.jsonTransferHandle(a -> a.setSubTags(null))).when(ZhiHuOptionsType.specialTab, DocHandler.jsonTransferHandle(a -> a.setSubTags(null))).when(ZhiHuOptionsType.talentInfo, (doc, param) -> this.transferTalentInfo(doc, type)).when(ZhiHuOptionsType.other, (doc, param) -> this.transferOther(doc, type));
                break;
            }
            case "article": {
                init.when(ZhiHuOptionsType.domainType, DocHandler.jsonTransferHandle(a -> a.setSubTags(null))).when(ZhiHuOptionsType.contentType, DocHandler.jsonTransferHandle(a -> a.setSubTags(null))).when(ZhiHuOptionsType.specialTab, DocHandler.jsonTransferHandle(a -> a.setSubTags(null))).when(ZhiHuOptionsType.talentInfo, (doc, param) -> this.transferTalentInfo(doc, type)).when(ZhiHuOptionsType.other2, (doc, param) -> this.transferOther(doc, type));
                break;
            }
            case "video": {
                init.when(ZhiHuOptionsType.domainType, DocHandler.jsonTransferHandle(a -> a.setSubTags(null))).when(ZhiHuOptionsType.contentType, DocHandler.jsonTransferHandle(a -> a.setSubTags(null))).when(ZhiHuOptionsType.videoTime, DocHandler.jsonTransferHandle(a -> a.setSubTags(null))).when(ZhiHuOptionsType.specialTab, DocHandler.jsonTransferHandle(a -> a.setSubTags(null))).when(ZhiHuOptionsType.talentInfo, (doc, param) -> this.transferTalentInfo(doc, type)).when(ZhiHuOptionsType.other, (doc, param) -> this.transferOther(doc, type));
                break;
            }
            default: {
                throw new ELSBootException(I18nUtil.translate((String)"", (String)"\u672a\u627e\u5230\u8be5\u8bf7\u6c42\u7c7b\u578b"));
            }
        }
        return init.getResult(contentType + "_" + type, "1".equals(clearCache));
    }

    @Override
    public List<TopManOptionsEntity> getEnterpriseOptions(String type, String contentType, String clearCache) {
        String redisKey = "OptionCache:zhihu" + contentType + type;
        List<TopManOptionsEntity> result = (List<TopManOptionsEntity>)this.redisUtil.get(redisKey);
        if (result == null) {
            OptionFactory.OptionHandler<ZhiHuOptionsTypeGroup, ZhiHuOptionsType> init = OptionFactory.init(ZhiHuOptionsTypeGroup.class, ZhiHuOptionsType.class);
            init.setCollection("tb_zhihu_category");
            switch (type) {
                case "allTopMan": {
                    init.when(ZhiHuOptionsType.domainType, DocHandler.jsonTransferHandle(a -> a.setSubTags(null))).when(ZhiHuOptionsType.contentType, DocHandler.jsonTransferHandle(a -> a.setSubTags(null))).when(ZhiHuOptionsType.videoTime, DocHandler.jsonTransferHandle(a -> a.setSubTags(null))).when(ZhiHuOptionsType.specialTab, DocHandler.jsonTransferHandle(a -> a.setSubTags(null))).when(ZhiHuOptionsType.talentInfo, (doc, param) -> this.enterpriseTransferOptions(doc, null)).when(ZhiHuOptionsType.other, (doc, param) -> this.enterpriseTransferOptions(doc, contentType)).when(ZhiHuOptionsType.other2, (doc, param) -> this.enterpriseTransferOptions(doc, contentType));
                    break;
                }
                case "myTopMan": {
                    init.when(ZhiHuOptionsType.domainType, DocHandler.jsonTransferHandle(a -> a.setSubTags(null))).when(ZhiHuOptionsType.contentType, DocHandler.jsonTransferHandle(a -> a.setSubTags(null))).when(ZhiHuOptionsType.videoTime, DocHandler.jsonTransferHandle(a -> a.setSubTags(null))).when(ZhiHuOptionsType.specialTab, DocHandler.jsonTransferHandle(a -> a.setSubTags(null))).when(ZhiHuOptionsType.talentInfo, (doc, param) -> this.enterpriseTransferOptions(doc, null)).when(ZhiHuOptionsType.other, (doc, param) -> this.enterpriseTransferOptions(doc, contentType)).when(ZhiHuOptionsType.other2, (doc, param) -> this.enterpriseTransferOptions(doc, contentType));
                    break;
                }
                default: {
                    throw new ELSBootException(I18nUtil.translate((String)"", (String)"\u672a\u627e\u5230\u8be5\u8bf7\u6c42\u7c7b\u578b"));
                }
            }
            result = init.getResult(type, "0".equals(clearCache));
            if (!"video".equals(contentType)) {
                result.removeIf(a -> a.getTitle().equals("\u89c6\u9891\u65f6\u957f"));
            }
            result.removeIf(a -> a.getChildren().isEmpty());
            if (result.size() != 0) {
                this.redisUtil.set(redisKey, result, 14400L);
            }
        }
        return result;
    }

    private List<TopManOptionsEntity.Tag> enterpriseTransferOptions(Document doc, String contentType) {
        List docList = doc.getList((Object)"directory_json", Document.class);
        String name = doc.getString((Object)"name");
        ArrayList<TopManOptionsEntity.Tag> tagList = new ArrayList<TopManOptionsEntity.Tag>();
        if ("\u5176\u4ed6\u7b5b\u9009".equals(name) && "article".equals(contentType)) {
            return tagList;
        }
        if ("\u5176\u4ed6\u7b5b\u9009(\u56de\u7b54\u6587\u7ae0)".equals(name) && !"article".equals(contentType)) {
            return tagList;
        }
        if ("\u5176\u4ed6\u7b5b\u9009".equals(name) || "\u5176\u4ed6\u7b5b\u9009(\u56de\u7b54\u6587\u7ae0)".equals(name)) {
            TopManOptionsEntity.Tag confirmChildren = new TopManOptionsEntity.Tag();
            confirmChildren.setComponentType("RSelect");
            confirmChildren.setStarTagName("\u786e\u8ba4\u72b6\u6001");
            confirmChildren.setStarTagId("1");
            List<Object> subTags = Arrays.asList(new TopManOptionsEntity.Tag("0", "\u5168\u90e8", "0"), new TopManOptionsEntity.Tag("1", "\u5df2\u786e\u8ba4", "1"), new TopManOptionsEntity.Tag("2", "\u5f85\u786e\u8ba4", "2"));
            confirmChildren.setSubTags(subTags);
            TopManOptionsEntity.Tag leaderChildren = new TopManOptionsEntity.Tag();
            leaderChildren.setComponentType("RSelect");
            leaderChildren.setStarTagName("\u8d1f\u8d23\u4eba");
            leaderChildren.setStarTagId("2");
            leaderChildren.setSubTags(this.transferAllTopManLeader());
            tagList.add(confirmChildren);
            tagList.add(leaderChildren);
        }
        docList.forEach(a -> {
            TopManOptionsEntity.Tag tag = this.enterpriseTransferSub((Document)a, name);
            if (tag != null) {
                tagList.add(tag);
            }
        });
        return tagList;
    }

    private List<Object> transferAllTopManLeader() {
        List allByAccount = this.accountRpcService.getAllByAccount(TenantContext.getTenant());
        ArrayList<Object> tags = new ArrayList<Object>(allByAccount.size() + 1);
        TopManOptionsEntity.Tag tag = new TopManOptionsEntity.Tag();
        tag.setStarTagId("0");
        tag.setStarTagName("\u5168\u90e8");
        tag.setStarTagValue("0");
        tags.add(tag);
        allByAccount.forEach(a -> {
            TopManOptionsEntity.Tag subTag = new TopManOptionsEntity.Tag();
            subTag.setStarTagId(a.getSubAccount());
            subTag.setStarTagValue(a.getSubAccount());
            subTag.setStarTagName(a.getRealname());
            tags.add(subTag);
        });
        return tags;
    }

    private TopManOptionsEntity.Tag enterpriseTransferSub(Document doc, String name) {
        TopManOptionsEntity.Tag tag = null;
        switch (name) {
            case "\u8fbe\u4eba\u4fe1\u606f": {
                if (!"\u7c89\u4e1d\u603b\u6570".equals(doc.getString((Object)"starTagName")) && !"\u8d26\u53f7\u7b49\u7ea7".equals(doc.getString((Object)"starTagName")) && !"\u662f\u5426\u7b7e\u7ea6MCN".equals(doc.getString((Object)"starTagName")) && !"\u8fbe\u4eba\u62a5\u4ef7".equals(doc.getString((Object)"starTagName"))) break;
                tag = new TopManOptionsEntity.Tag();
                tag.setStarTagId(doc.getInteger((Object)"starTagId").toString());
                tag.setStarTagName(doc.getString((Object)"starTagName"));
                tag.setStarTagValue(doc.getString((Object)"starTagName"));
                tag.setComponentType(doc.getString((Object)"componentType"));
                tag.setSubTags(doc.getList((Object)"subTags", Object.class));
                break;
            }
            case "\u5176\u4ed6\u7b5b\u9009": {
                tag = new TopManOptionsEntity.Tag();
                tag.setStarTagId(doc.getInteger((Object)"starTagId").toString());
                tag.setStarTagName(doc.getString((Object)"starTagName"));
                tag.setStarTagValue(doc.getString((Object)"starTagName"));
                tag.setComponentType(doc.getString((Object)"componentType"));
                tag.setSubTags(doc.getList((Object)"subTags", Object.class));
                break;
            }
            case "\u5176\u4ed6\u7b5b\u9009(\u56de\u7b54\u6587\u7ae0)": {
                tag = new TopManOptionsEntity.Tag();
                tag.setStarTagId(doc.getInteger((Object)"starTagId").toString());
                tag.setStarTagName(doc.getString((Object)"starTagName"));
                tag.setStarTagValue(doc.getString((Object)"starTagName"));
                tag.setComponentType(doc.getString((Object)"componentType"));
                tag.setSubTags(doc.getList((Object)"subTags", Object.class));
            }
        }
        return tag;
    }

    private List<TopManOptionsEntity.Tag> transferTalentInfo(Document doc, String type) {
        List docList = doc.getList((Object)"directory_json", Document.class);
        if (ZhiHuOptionsTypeGroup.collectTopMan.getName().equals(type)) {
            String[] starTagNames = new String[]{"\u7c89\u4e1d\u603b\u6570", "\u8d26\u53f7\u7b49\u7ea7", "\u662f\u5426\u7b7e\u7ea6MCN", "\u8fbe\u4eba\u62a5\u4ef7"};
            docList = docList.stream().filter(h -> Arrays.asList(starTagNames).contains(h.getString((Object)"starTagName"))).distinct().collect(Collectors.toList());
        }
        return docList.stream().map(h -> this.transferSub((Document)h, type)).collect(Collectors.toList());
    }

    private List<TopManOptionsEntity.Tag> transferOther(Document doc, String type) {
        List docList = doc.getList((Object)"directory_json", Document.class);
        return docList.stream().map(h -> this.transferSub((Document)h, type)).collect(Collectors.toList());
    }

    private TopManOptionsEntity.Tag transferSub(Document doc, String type) {
        TopManOptionsEntity.Tag tag = new TopManOptionsEntity.Tag();
        tag.setStarTagId(doc.getInteger((Object)"starTagId").toString());
        tag.setStarTagName(doc.getString((Object)"starTagName"));
        tag.setStarTagValue(doc.getString((Object)"starTagName"));
        tag.setComponentType(doc.getString((Object)"componentType"));
        if (ZhiHuOptionsTypeGroup.zhiHuTopMan.getName().equals(type)) {
            tag.setSubTags(doc.getList((Object)"subTags", Object.class));
            List subTags = doc.getList((Object)"subTags", Document.class);
            tag.setSubTags(subTags.stream().map(this::transferZhiHuTopMan).collect(Collectors.toList()));
        } else {
            tag.setSubTags(doc.getList((Object)"subTags", Object.class));
        }
        return tag;
    }

    private TopManOptionsEntity.Tag transferZhiHuTopMan(Document doc) {
        TopManOptionsEntity.Tag tag = new TopManOptionsEntity.Tag();
        tag.setStarTagId(doc.getString((Object)"starTagId"));
        tag.setStarTagName(doc.getString((Object)"starTagName"));
        tag.setStarTagValue(doc.getString((Object)"starTagId"));
        return tag;
    }

    @Override
    public IPage<ZhiHuTopManInformation> queryTopManList(SimplePostRequestParam<ZhiHuTopManInformationDTO> topManDto) {
        IPage<ZhiHuTopManInformation> page = new IPage<ZhiHuTopManInformation>((long)topManDto.getPageNo().intValue(), (long)topManDto.getPageSize().intValue());
        ZhiHuTopManInformationDTO filterInfo = (ZhiHuTopManInformationDTO)topManDto.getFilterInfo();
        String taskType = filterInfo.getTaskType();
        if (ZhiHuOptionsTypeGroup.zhiHuTopMan.getName().equals(taskType)) {
            Map<?, ?> map = this.handleBodyTopMan(topManDto);
            SpiderMethodType methodType = SpiderMethodType.ZHI_HU_LIST;
            Class<ZhiHuTopManPage> responseClass = ZhiHuTopManPage.class;
            ZhiHuTopManPage data = this.spiderApiUtil.postForEntity(methodType, map, responseClass);
            page.setTotal(data.getTotal());
            page.setRecords(this.handleResult(data, filterInfo.getPlatformType()));
        } else {
            QueryWrapper<ZhiHuTopManInformation> queryWrapper = this.getQueryWrapper(topManDto);
            page = ((ZhiHuTopManInformationMapper)this.baseMapper).selectCollectTopMan(page, queryWrapper, SysUtil.getLoginUser());
        }
        return page;
    }

    private QueryWrapper<ZhiHuTopManInformation> getQueryWrapper(SimplePostRequestParam<ZhiHuTopManInformationDTO> topManDto) {
        String[] columns;
        String column;
        String string;
        List<ZhiHuTopManInformationDTO.ScreenItemField> others;
        List<ZhiHuTopManInformationDTO.ScreenItemField> talentInfos;
        List<ZhiHuTopManInformationDTO.ScreenItemField> specialTabs;
        String starTagId;
        List<ZhiHuTopManInformationDTO.ScreenItemField> videoTimes;
        List<ZhiHuTopManInformationDTO.ScreenItemField> contentTypes;
        ZhiHuTopManInformationDTO filterInfo = (ZhiHuTopManInformationDTO)topManDto.getFilterInfo();
        ZhiHuTopManInformationDTO.ScreenItem screenItem = filterInfo.getScreenItem();
        QueryWrapper query = new QueryWrapper();
        if (screenItem == null) {
            return query;
        }
        boolean flag = true;
        List<ZhiHuTopManInformationDTO.ScreenItemField> domainTypes = screenItem.getDomainType();
        if (CollectionUtil.isNotEmpty(domainTypes)) {
            String title = domainTypes.get(0).getTitle();
            this.handleLike(title, (QueryWrapper<ZhiHuTopManInformation>)query, ZhiHuTopManInformation::getBadges);
        }
        if (CollectionUtil.isNotEmpty(contentTypes = screenItem.getContentType())) {
            ZhiHuTopManInformationDTO.ScreenItemField screenItemField = contentTypes.get(0);
            this.handleLike(screenItemField.getStarTagId(), (QueryWrapper<ZhiHuTopManInformation>)query, ZhiHuTopManInformation::getOrderType);
            if ("\u89c6\u9891".equals(screenItemField.getTitle())) {
                flag = false;
            }
        }
        if (CollectionUtil.isNotEmpty(videoTimes = screenItem.getVideoTime()) && StringUtils.isNotBlank((CharSequence)(starTagId = videoTimes.get(0).getStarTagId())) && "\u5168\u90e8".equals(starTagId)) {
            query.lambda().like(ZhiHuTopManInformation::getOrderThirdType, (Object)String.valueOf(Integer.valueOf(starTagId) - 1));
        }
        if (CollectionUtil.isNotEmpty(specialTabs = screenItem.getSpecialTab())) {
            String starTagId2 = domainTypes.get(0).getStarTagId();
            this.handleEquals(starTagId2, (QueryWrapper<ZhiHuTopManInformation>)query, ZhiHuTopManInformation::getTags);
        }
        if (CollectionUtil.isNotEmpty(talentInfos = screenItem.getTalentInfo())) {
            block22: for (ZhiHuTopManInformationDTO.ScreenItemField screenItemField : talentInfos) {
                String value = screenItemField.getValue();
                switch (screenItemField.getTitle()) {
                    case "\u7c89\u4e1d\u603b\u6570": {
                        this.handleInteger(value, (QueryWrapper<ZhiHuTopManInformation>)query, ZhiHuTopManInformation::getFollowerCount);
                        continue block22;
                    }
                    case "\u8d26\u53f7\u7b49\u7ea7": {
                        this.handleEquals(value, (QueryWrapper<ZhiHuTopManInformation>)query, ZhiHuTopManInformation::getLevel);
                        continue block22;
                    }
                    case "\u662f\u5426\u7b7e\u7ea6MCN": {
                        if ("1".equals(value)) {
                            this.handleEquals(value, (QueryWrapper<ZhiHuTopManInformation>)query, ZhiHuTopManInformation::getIsSignMcn);
                            continue block22;
                        }
                        this.handleEquals("0", (QueryWrapper<ZhiHuTopManInformation>)query, ZhiHuTopManInformation::getIsSignMcn);
                        continue block22;
                    }
                    case "\u8fbe\u4eba\u62a5\u4ef7": {
                        if (flag) {
                            this.handleBigDecimal(value, (QueryWrapper<ZhiHuTopManInformation>)query, ZhiHuTopManInformation::getArticleOrderPrice);
                            continue block22;
                        }
                        this.handleBigDecimal(value, (QueryWrapper<ZhiHuTopManInformation>)query, ZhiHuTopManInformation::getVideoOrderPrice);
                        continue block22;
                    }
                }
                throw new RuntimeException(I18nUtil.translate((String)"", (String)"\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u53c2\u6570\u7c7b\u578b"));
            }
        }
        if (CollectionUtil.isNotEmpty(others = screenItem.getOther())) {
            block23: for (ZhiHuTopManInformationDTO.ScreenItemField screenItemField : others) {
                String value = screenItemField.getValue();
                switch (screenItemField.getTitle()) {
                    case "\u89c6\u9891-\u811a\u672c\u64b0\u5199\uff08\u542b\u89c6\u9891\u53d1\u5e03\uff09": {
                        query.lambda().eq(ZhiHuTopManInformation::getIsVideoX, (Object)value);
                        continue block23;
                    }
                    case "\u89c6\u9891-\u5168\u7247\u5b9a\u5236\uff08\u542b\u89c6\u9891\u53d1\u5e03\uff09": {
                        query.lambda().like(ZhiHuTopManInformation::getOrderSecondType, (Object)"2");
                        continue block23;
                    }
                    case "\u5e26\u8d27\u80fd\u529b\u8005": {
                        query.lambda().eq(ZhiHuTopManInformation::getIsProductX, (Object)value);
                        continue block23;
                    }
                }
                throw new RuntimeException(I18nUtil.translate((String)"", (String)"\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u53c2\u6570\u7c7b\u578b"));
            }
        }
        if ((string = topManDto.getKeyWord()) != null && string.trim().length() > 0) {
            query.and(q -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)q.lambda().like(ZhiHuTopManInformation::getName, (Object)keyWord)).or(a -> {
                    LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)a.eq(ZhiHuTopManInformation::getUid, (Object)keyWord);
                });
            });
        }
        if ((column = topManDto.getColumn()) != null && !"default".equals(column) && (columns = column.split(",")).length > 0) {
            final String order = topManDto.getOrder();
            QueryGenerator.doMultiFieldsOrder((QueryWrapper)query, (Map)new HashMap<String, String[]>(2){
                {
                    super(arg0);
                    this.put("order", order == null ? new String[columns.length] : order.split(","));
                    this.put("column", columns);
                }
            }, (Object)((Object)new ZhiHuTopManInformation()));
        }
        return query;
    }

    private void handleEquals(String value, QueryWrapper<ZhiHuTopManInformation> query, SFunction<ZhiHuTopManInformation, ?> field) {
        if (StringUtils.isBlank((CharSequence)value) || "\u4e0d\u9650".equals(value)) {
            return;
        }
        query.lambda().eq(field, (Object)value);
    }

    private void handleLike(String value, QueryWrapper<ZhiHuTopManInformation> query, SFunction<ZhiHuTopManInformation, ?> field) {
        if (StringUtils.isBlank((CharSequence)value) || "\u5168\u90e8".equals(value)) {
            return;
        }
        query.lambda().like(field, (Object)value);
    }

    private void handleInteger(String value, QueryWrapper<ZhiHuTopManInformation> query, SFunction<ZhiHuTopManInformation, ?> field) {
        if (StringUtils.isBlank((CharSequence)value)) {
            return;
        }
        String[] split = value.split("-");
        switch (split.length) {
            case 0: {
                return;
            }
            case 2: {
                query.lambda().between(field, (Object)Integer.parseInt(split[0]), (Object)Integer.parseInt(split[1]));
                break;
            }
            case 1: {
                if (value.startsWith("-")) {
                    query.lambda().le(field, (Object)Integer.parseInt(split[0]));
                    break;
                }
                query.lambda().ge(field, (Object)Integer.parseInt(split[0]));
                break;
            }
            default: {
                throw new ELSBootException(I18nUtil.translate((String)"", (String)"{}\u914d\u7f6e\u7684\u6570\u636e\u503c\u6709\u8bef"));
            }
        }
    }

    private void handleBigDecimal(String value, QueryWrapper<ZhiHuTopManInformation> query, SFunction<ZhiHuTopManInformation, ?> field) {
        if (StringUtils.isBlank((CharSequence)value)) {
            return;
        }
        String[] split = value.split("-");
        switch (split.length) {
            case 0: {
                return;
            }
            case 2: {
                query.lambda().between(field, (Object)new BigDecimal(split[0]), (Object)new BigDecimal(split[1]));
                break;
            }
            case 1: {
                if (value.startsWith("-")) {
                    query.lambda().le(field, (Object)new BigDecimal(split[0]));
                    break;
                }
                query.lambda().ge(field, (Object)new BigDecimal(split[0]));
                break;
            }
            default: {
                throw new ELSBootException(I18nUtil.translate((String)"", (String)"{}\u914d\u7f6e\u7684\u6570\u636e\u503c\u6709\u8bef"));
            }
        }
    }

    private List<ZhiHuTopManInformation> handleResult(ZhiHuTopManPage data, String platform) {
        List<ZhiHuTopManEntity> starList = data.getList();
        if (CollectionUtil.isEmpty(starList)) {
            return new ArrayList<ZhiHuTopManInformation>(0);
        }
        List<String> topmanIds = starList.stream().map(h -> h.getUid().toString()).distinct().collect(Collectors.toList());
        List<ZhiHuTopManInformation> addedAndCollects = ((ZhiHuTopManInformationMapper)this.baseMapper).checkAddedAndCollect(topmanIds, SysUtil.getLoginUser(), platform);
        Map<Object, Object> map = new HashMap();
        if (CollectionUtil.isNotEmpty(addedAndCollects)) {
            map = addedAndCollects.stream().collect(Collectors.toMap(ZhiHuTopManInformation::getUid, h -> h, (k1, k2) -> k1));
        }
        ArrayList<ZhiHuTopManInformation> resultEntityList = new ArrayList<ZhiHuTopManInformation>(starList.size());
        for (ZhiHuTopManEntity topManInfo : starList) {
            List<Integer> tags;
            List<ZhiHuTopManEntity.Offer> offers;
            List<String> topics;
            ZhiHuTopManInformation information = new ZhiHuTopManInformation();
            BeanUtils.copyProperties((Object)topManInfo, (Object)((Object)information));
            information.setUid(topManInfo.getUid().toString());
            information.setLevel(topManInfo.getLevel().toString());
            List<ZhiHuTopManEntity.Badges> badges = topManInfo.getBadges();
            if (CollectionUtil.isNotEmpty(badges) && CollectionUtil.isNotEmpty(topics = badges.get(0).getTopics())) {
                information.setBadges(StringUtils.join(topics, (String)"\u3001"));
            }
            if (CollectionUtil.isNotEmpty(offers = topManInfo.getOffer())) {
                offers.forEach(h -> {
                    BigDecimal orderPrice = new BigDecimal(h.getOrderPrice()).divide(new BigDecimal(100), 2, 4);
                    if (h.getOrderType() == 1) {
                        information.setArticleOrderPrice(orderPrice);
                    }
                    if (h.getOrderType() == 2) {
                        information.setVideoOrderPrice(orderPrice);
                    }
                });
                List orderTypes = offers.stream().map(ZhiHuTopManEntity.Offer::getOrderType).distinct().collect(Collectors.toList());
                List orderSecondTypes = offers.stream().map(ZhiHuTopManEntity.Offer::getOrderSecondType).distinct().collect(Collectors.toList());
                List orderThirdTypes = offers.stream().map(ZhiHuTopManEntity.Offer::getOrderThirdType).distinct().collect(Collectors.toList());
                information.setOrderType(StringUtils.join(orderTypes, (String)","));
                information.setOrderSecondType(StringUtils.join(orderSecondTypes, (String)","));
                information.setOrderThirdType(StringUtils.join(orderThirdTypes, (String)","));
            }
            if (CollectionUtil.isNotEmpty(tags = topManInfo.getTags())) {
                information.setTags(tags.get(0).toString());
            } else {
                information.setTags("0");
            }
            ZhiHuTopManEntity.Mcn mcn = topManInfo.getMcn();
            if (mcn != null && mcn.getId() != 0L) {
                information.setIsSignMcn(true);
            }
            information.setIsVideoX(topManInfo.getIsVideoX());
            information.setIsProductX(topManInfo.getIsProductX());
            ZhiHuTopManInformation info = (ZhiHuTopManInformation)((Object)map.get(topManInfo.getUid().toString()));
            if (info != null) {
                information.setIsCollection(info.getIsCollection());
                information.setIsAdded(info.getIsAdded());
            }
            resultEntityList.add(information);
        }
        return resultEntityList;
    }

    private Map<?, ?> handleBodyTopMan(SimplePostRequestParam<ZhiHuTopManInformationDTO> topManDto) {
        ZhiHuTopManInformationDTO.ScreenItem screenItem;
        HashMap<String, Object> apiParam = new HashMap<String, Object>(19);
        apiParam.put("page", topManDto.getPageNo());
        apiParam.put("page_size", topManDto.getPageSize());
        String column = topManDto.getColumn();
        if (column != null && !"".equals(column)) {
            if ("follower_count".equals(column)) {
                apiParam.put("order_by", column);
            } else {
                apiParam.put("order_by", "together");
            }
        }
        apiParam.put("order_by_type", topManDto.getOrder());
        String keyWord = topManDto.getKeyWord();
        if (keyWord != null && !"".equals(keyWord)) {
            apiParam.put("name", keyWord);
        }
        if ((screenItem = ((ZhiHuTopManInformationDTO)topManDto.getFilterInfo()).getScreenItem()) != null) {
            List<ZhiHuTopManInformationDTO.ScreenItemField> domainType = screenItem.getDomainType();
            this.typeConversion("field", domainType, apiParam);
            List<ZhiHuTopManInformationDTO.ScreenItemField> contentType = screenItem.getContentType();
            this.typeConversion("offer_type", contentType, apiParam);
            List<ZhiHuTopManInformationDTO.ScreenItemField> videoTime = screenItem.getVideoTime();
            this.typeConversion("video_duration", videoTime, apiParam);
            List<ZhiHuTopManInformationDTO.ScreenItemField> specialTab = screenItem.getSpecialTab();
            this.typeConversion("tags", specialTab, apiParam);
            List<ZhiHuTopManInformationDTO.ScreenItemField> talentInfo = screenItem.getTalentInfo();
            this.talentInfoConversion(talentInfo, apiParam);
            List<ZhiHuTopManInformationDTO.ScreenItemField> other = screenItem.getOther();
            this.otherConversion(other, apiParam);
        }
        return apiParam;
    }

    private void typeConversion(String field, List<ZhiHuTopManInformationDTO.ScreenItemField> fields, Map<String, Object> apiParam) {
        if (CollectionUtil.isEmpty(fields)) {
            return;
        }
        ZhiHuTopManInformationDTO.ScreenItemField screenItemField = fields.get(0);
        if ("\u5168\u90e8".equals(screenItemField.getTitle()) || "\u4e0d\u9650".equals(screenItemField.getTitle())) {
            return;
        }
        apiParam.put(field, screenItemField.getStarTagId());
    }

    private void otherConversion(List<ZhiHuTopManInformationDTO.ScreenItemField> fields, Map<String, Object> apiParam) {
        if (CollectionUtil.isEmpty(fields)) {
            return;
        }
        fields.forEach(h -> {
            switch (h.getTitle()) {
                case "\u89c6\u9891-\u811a\u672c\u64b0\u5199\uff08\u542b\u89c6\u9891\u53d1\u5e03\uff09": {
                    apiParam.put("video_x", "true");
                    break;
                }
                case "\u89c6\u9891-\u5168\u7247\u5b9a\u5236\uff08\u542b\u89c6\u9891\u53d1\u5e03\uff09": {
                    apiParam.put("video_create_x", "true");
                    break;
                }
                case "\u5e26\u8d27\u80fd\u529b\u8005": {
                    apiParam.put("product_x", "true");
                    break;
                }
                default: {
                    throw new ELSBootException(I18nUtil.translate((String)"", (String)"{}\u914d\u7f6e\u7684\u6570\u636e\u503c\u6709\u8bef"));
                }
            }
        });
    }

    private void talentInfoConversion(List<ZhiHuTopManInformationDTO.ScreenItemField> fields, Map<String, Object> apiParam) {
        if (CollectionUtil.isEmpty(fields)) {
            return;
        }
        fields.forEach(h -> {
            switch (h.getTitle()) {
                case "\u7c89\u4e1d\u603b\u6570": {
                    this.handleTalentInfoFollower(h.getValue(), apiParam);
                    break;
                }
                case "\u8d26\u53f7\u7b49\u7ea7": {
                    apiParam.put("level", h.getValue());
                    break;
                }
                case "\u8fbe\u4eba\u6d3b\u8dc3\u5ea6": {
                    apiParam.put("author_activity", h.getValue());
                    break;
                }
                case "\u662f\u5426\u7b7e\u7ea6MCN": {
                    apiParam.put("is_sign_mcn", h.getValue());
                    break;
                }
                case "\u8363\u8a89\u8ba4\u8bc1": {
                    apiParam.put("honor_auth", h.getValue());
                    break;
                }
                case "\u8eab\u4efd\u8ba4\u8bc1": {
                    apiParam.put("is_identity_auth", h.getValue());
                    break;
                }
                case "\u8fbe\u4eba\u62a5\u4ef7": {
                    this.handleTalentInfoOfferPrice(h.getValue(), apiParam);
                    break;
                }
                default: {
                    throw new ELSBootException(I18nUtil.translate((String)"", (String)"{}\u914d\u7f6e\u7684\u6570\u636e\u503c\u6709\u8bef"));
                }
            }
        });
    }

    private void handleTalentInfoFollower(String value, Map<String, Object> apiParam) {
        if (StringUtils.isBlank((CharSequence)value)) {
            return;
        }
        String[] split = value.split("-");
        switch (split.length) {
            case 0: {
                return;
            }
            case 2: {
                int max;
                int min = StringUtils.isNotBlank((CharSequence)split[0]) ? Integer.parseInt(split[0]) : 0;
                int n = max = StringUtils.isNotBlank((CharSequence)split[1]) ? Integer.parseInt(split[1]) : 0;
                if (max < min) {
                    max = min;
                }
                apiParam.put("min_follower", min);
                apiParam.put("max_follower", max);
                break;
            }
            case 1: {
                apiParam.put("follower", Integer.parseInt(split[0]));
                break;
            }
            default: {
                throw new ELSBootException(I18nUtil.translate((String)"", (String)"{}\u914d\u7f6e\u7684\u6570\u636e\u503c\u6709\u8bef"));
            }
        }
    }

    private void handleTalentInfoOfferPrice(String value, Map<String, Object> apiParam) {
        if (StringUtils.isBlank((CharSequence)value)) {
            return;
        }
        String[] split = value.split("-");
        switch (split.length) {
            case 0: {
                return;
            }
            case 2: {
                int max;
                int min = StringUtils.isNotBlank((CharSequence)split[0]) ? Integer.parseInt(split[0]) : 0;
                int n = max = StringUtils.isNotBlank((CharSequence)split[1]) ? Integer.parseInt(split[1]) : 0;
                if (max < min) {
                    max = min;
                }
                apiParam.put("min_offer_price", min);
                apiParam.put("high_offer_price", max);
                break;
            }
            case 1: {
                apiParam.put("offer_price", Integer.parseInt(split[0]));
                break;
            }
            default: {
                throw new ELSBootException(I18nUtil.translate((String)"", (String)"{}\u914d\u7f6e\u7684\u6570\u636e\u503c\u6709\u8bef"));
            }
        }
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void collect(ZhiHuTopManCollectDTO dto) {
        if (MarkYn.check(dto.getCollect())) {
            this.addMarkToSpider(dto);
        }
        this.collectHandle(dto);
    }

    private void collectHandle(ZhiHuTopManCollectDTO dto) {
        LoginUser loginUser = SysUtil.getLoginUser();
        String elsAccount = loginUser.getElsAccount();
        String subAccount = loginUser.getSubAccount();
        ZhiHuTopManInformation entity = dto.getEntity();
        if (MarkYn.check(dto.getCollect())) {
            TopManCollectBean topManCollectBean = new TopManCollectBean();
            topManCollectBean.setTopmanId(entity.getUid());
            topManCollectBean.setPlatform("6");
            topManCollectBean.setElsAccount(elsAccount);
            topManCollectBean.setSubAccount(subAccount);
            this.topManCollectService.save((Object)topManCollectBean);
        } else {
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.lambda().eq(BaseEntity::getElsAccount, (Object)elsAccount);
            queryWrapper.lambda().eq(TopManCollectBean::getSubAccount, (Object)subAccount);
            queryWrapper.lambda().eq(TopManCollectBean::getPlatform, (Object)"6");
            queryWrapper.lambda().eq(TopManCollectBean::getTopmanId, (Object)entity.getUid());
            this.topManCollectService.remove((Wrapper)queryWrapper);
        }
    }

    @Override
    public void addMarkToSpider(ZhiHuTopManCollectDTO dto) {
        this.saveTopMan(dto.getEntity());
    }

    private void saveTopMan(ZhiHuTopManInformation information) {
        QueryWrapper query = new QueryWrapper();
        query.lambda().eq(ZhiHuTopManInformation::getUid, (Object)information.getUid());
        ZhiHuTopManInformation info = (ZhiHuTopManInformation)((Object)((ZhiHuTopManInformationMapper)this.baseMapper).selectOne((Wrapper)query));
        if (info == null) {
            information.setSubAccount(SysUtil.getLoginUser().getSubAccount());
            information.setPlatform("6");
            information.setId("");
        } else {
            information.setSubAccount(SysUtil.getLoginUser().getSubAccount());
            information.setId(info.getId());
        }
        this.saveOrUpdate((Object)information);
    }

    @Override
    public ZhuHuManDetailHeadVO getDetailHead(ZhiHuTopManDetailDTO dto) {
        ZhuHuManDetailHeadVO result = null;
        String redisKey = "ZhiHuTopManDetail_" + dto.getPuId();
        if (!"1".equals(dto.getClearCache())) {
            result = (ZhuHuManDetailHeadVO)this.redisUtil.get(redisKey);
        }
        HashMap<String, Object> apiParam = new HashMap<String, Object>(1);
        apiParam.put("pu_id", dto.getPuId());
        if (result == null) {
            result = new ZhuHuManDetailHeadVO();
            ZhuHuManDetailHeadEntity entity = this.spiderApiUtil.postForEntity(SpiderMethodType.ZHI_HU_DETAIL, apiParam, ZhuHuManDetailHeadEntity.class);
            this.getDetailHeadTranslation(entity, result);
            this.redisUtil.set(redisKey, (Object)result, 18000L);
        } else {
            boolean check = this.spiderApiUtil.checkCache(SpiderMethodType.ZHI_HU_DETAIL, apiParam);
            if (!check) {
                SpiderApiUtil.taskExecutor.execute(() -> {
                    dto.setClearCache("1");
                    this.getDetailHead(dto);
                });
            }
        }
        List<String> topmanIds = Collections.singletonList(dto.getPuId());
        List<ZhiHuTopManInformation> addedAndCollects = ((ZhiHuTopManInformationMapper)this.baseMapper).checkAddedAndCollect(topmanIds, SysUtil.getLoginUser(), dto.getPlatform());
        if (addedAndCollects != null && addedAndCollects.size() > 0) {
            ZhiHuTopManInformation information = addedAndCollects.get(0);
            result.setIsAdded(information.getIsAdded());
            result.setIsCollection(information.getIsCollection());
        }
        return result;
    }

    private void getDetailHeadTranslation(ZhuHuManDetailHeadEntity entity, ZhuHuManDetailHeadVO result) {
        List<ZhuHuManDetailHeadEntity.Detail.Offer> offerList;
        List<ZhuHuManDetailHeadEntity.Detail.PuWorks> puWorks;
        List<ZhuHuManDetailHeadEntity.Detail.AllOrderGoodsCapacity> goodsCapacities;
        List<ZhuHuManDetailHeadEntity.Detail.Badges> badgesList;
        if (entity == null || entity.getDetail() == null) {
            return;
        }
        ZhuHuManDetailHeadEntity.Detail detail = entity.getDetail();
        ZhuHuManDetailHeadVO.DetailHead detailHead = new ZhuHuManDetailHeadVO.DetailHead();
        BeanUtils.copyProperties((Object)detail, (Object)detailHead);
        ZhuHuManDetailHeadEntity.Detail.Mcn detailMcn = detail.getMcn();
        if (detailMcn != null) {
            ZhuHuManDetailHeadVO.DetailHead.Mcn mcn = new ZhuHuManDetailHeadVO.DetailHead.Mcn();
            BeanUtils.copyProperties((Object)detailMcn, (Object)mcn);
            detailHead.setMcn(mcn);
        }
        if (CollectionUtil.isNotEmpty(badgesList = detail.getBadges())) {
            ArrayList<ZhuHuManDetailHeadVO.DetailHead.Badges> badges = new ArrayList<ZhuHuManDetailHeadVO.DetailHead.Badges>(badgesList.size());
            badgesList.forEach(h -> {
                ZhuHuManDetailHeadVO.DetailHead.Badges badge = new ZhuHuManDetailHeadVO.DetailHead.Badges();
                BeanUtils.copyProperties((Object)h, (Object)badge);
                badges.add(badge);
            });
            detailHead.setBadges(badges);
        }
        result.setDetailHead(detailHead);
        ZhuHuManDetailHeadVO.CoreData coreData = new ZhuHuManDetailHeadVO.CoreData();
        BeanUtils.copyProperties((Object)detail, (Object)coreData);
        result.setCoreData(coreData);
        ZhuHuManDetailHeadVO.BaseData baseData = new ZhuHuManDetailHeadVO.BaseData();
        List<ZhuHuManDetailHeadEntity.Detail.IndustryFieldSkill> fieldSkills = detail.getIndustryFieldSkill();
        if (CollectionUtil.isNotEmpty(fieldSkills)) {
            ArrayList<ZhuHuManDetailHeadVO.BaseData.IndustryFieldSkill> skills = new ArrayList<ZhuHuManDetailHeadVO.BaseData.IndustryFieldSkill>(fieldSkills.size());
            fieldSkills.forEach(h -> {
                ZhuHuManDetailHeadVO.BaseData.IndustryFieldSkill skill = new ZhuHuManDetailHeadVO.BaseData.IndustryFieldSkill();
                BeanUtils.copyProperties((Object)h, (Object)skill);
                skills.add(skill);
            });
            baseData.setIndustryFieldSkill(skills);
        }
        if (CollectionUtil.isNotEmpty(goodsCapacities = detail.getAllOrderGoodsCapacity())) {
            ArrayList<ZhuHuManDetailHeadVO.BaseData.AllOrderGoodsCapacity> capacities = new ArrayList<ZhuHuManDetailHeadVO.BaseData.AllOrderGoodsCapacity>(goodsCapacities.size());
            goodsCapacities.forEach(h -> {
                ZhuHuManDetailHeadVO.BaseData.AllOrderGoodsCapacity capacitie = new ZhuHuManDetailHeadVO.BaseData.AllOrderGoodsCapacity();
                BeanUtils.copyProperties((Object)h, (Object)capacitie);
                capacities.add(capacitie);
            });
            baseData.setAllOrderGoodsCapacity(capacities);
        }
        result.setBaseData(baseData);
        ZhuHuManDetailHeadVO.FansData fansData = new ZhuHuManDetailHeadVO.FansData();
        ZhuHuManDetailHeadEntity.Detail.PuFollower puFollower = detail.getPuFollower();
        if (puFollower != null) {
            List<ZhuHuManDetailHeadEntity.Detail.PuFollower.Distribution> provinceList;
            List<ZhuHuManDetailHeadEntity.Detail.PuFollower.Distribution> interestList;
            List<ZhuHuManDetailHeadEntity.Detail.PuFollower.Distribution> genderList;
            ZhuHuManDetailHeadVO.FansData.PuFollower follower = new ZhuHuManDetailHeadVO.FansData.PuFollower();
            List<ZhuHuManDetailHeadEntity.Detail.PuFollower.Distribution> ageList = puFollower.getAgeDistribution();
            if (CollectionUtil.isNotEmpty(ageList)) {
                ArrayList<ZhuHuManDetailHeadVO.FansData.PuFollower.Distribution> ages = new ArrayList<ZhuHuManDetailHeadVO.FansData.PuFollower.Distribution>(ageList.size());
                ageList.forEach(h -> {
                    ZhuHuManDetailHeadVO.FansData.PuFollower.Distribution age = new ZhuHuManDetailHeadVO.FansData.PuFollower.Distribution();
                    BeanUtils.copyProperties((Object)h, (Object)age);
                    ages.add(age);
                });
                follower.setAgeDistribution(ages);
            }
            if (CollectionUtil.isNotEmpty(genderList = puFollower.getGenderDistribution())) {
                ArrayList<ZhuHuManDetailHeadVO.FansData.PuFollower.Distribution> genders = new ArrayList<ZhuHuManDetailHeadVO.FansData.PuFollower.Distribution>(genderList.size());
                genderList.forEach(h -> {
                    ZhuHuManDetailHeadVO.FansData.PuFollower.Distribution gender = new ZhuHuManDetailHeadVO.FansData.PuFollower.Distribution();
                    BeanUtils.copyProperties((Object)h, (Object)gender);
                    genders.add(gender);
                });
                follower.setGenderDistribution(genders);
            }
            if (CollectionUtil.isNotEmpty(interestList = puFollower.getInterestDistribution())) {
                ArrayList<ZhuHuManDetailHeadVO.FansData.PuFollower.Distribution> interests = new ArrayList<ZhuHuManDetailHeadVO.FansData.PuFollower.Distribution>(interestList.size());
                interestList.forEach(h -> {
                    ZhuHuManDetailHeadVO.FansData.PuFollower.Distribution interest = new ZhuHuManDetailHeadVO.FansData.PuFollower.Distribution();
                    BeanUtils.copyProperties((Object)h, (Object)interest);
                    interests.add(interest);
                });
                follower.setInterestDistribution(interests);
            }
            if (CollectionUtil.isNotEmpty(provinceList = puFollower.getProvinceDistribution())) {
                ArrayList<ZhuHuManDetailHeadVO.FansData.PuFollower.Distribution> provinces = new ArrayList<ZhuHuManDetailHeadVO.FansData.PuFollower.Distribution>(provinceList.size());
                provinceList.forEach(h -> {
                    ZhuHuManDetailHeadVO.FansData.PuFollower.Distribution province = new ZhuHuManDetailHeadVO.FansData.PuFollower.Distribution();
                    BeanUtils.copyProperties((Object)h, (Object)province);
                    provinces.add(province);
                });
                follower.setProvinceDistribution(provinces);
            }
            fansData.setPuFollower(follower);
        }
        result.setFansData(fansData);
        ZhuHuManDetailHeadVO.RepresentativeWorks representativeWorks = new ZhuHuManDetailHeadVO.RepresentativeWorks();
        ZhuHuManDetailHeadEntity.Detail.BusinessEffect businessEffect = detail.getBusinessEffect();
        if (businessEffect != null) {
            ZhuHuManDetailHeadVO.RepresentativeWorks.BusinessEffect effect = new ZhuHuManDetailHeadVO.RepresentativeWorks.BusinessEffect();
            BeanUtils.copyProperties((Object)businessEffect, (Object)effect);
            List<ZhuHuManDetailHeadEntity.Detail.BusinessEffect.RankList> rankList = businessEffect.getRankList();
            if (CollectionUtil.isNotEmpty(rankList)) {
                ArrayList<ZhuHuManDetailHeadVO.RepresentativeWorks.BusinessEffect.RankList> ranks = new ArrayList<ZhuHuManDetailHeadVO.RepresentativeWorks.BusinessEffect.RankList>(rankList.size());
                rankList.forEach(h -> {
                    ZhuHuManDetailHeadVO.RepresentativeWorks.BusinessEffect.RankList rank = new ZhuHuManDetailHeadVO.RepresentativeWorks.BusinessEffect.RankList();
                    BeanUtils.copyProperties((Object)h, (Object)rank);
                    ranks.add(rank);
                });
                effect.setRankList(ranks);
            }
            representativeWorks.setBusinessEffect(effect);
        }
        if (CollectionUtil.isNotEmpty(puWorks = detail.getPuWorks())) {
            ArrayList<ZhuHuManDetailHeadVO.RepresentativeWorks.PuWorks> works = new ArrayList<ZhuHuManDetailHeadVO.RepresentativeWorks.PuWorks>(puWorks.size());
            puWorks.forEach(h -> {
                ZhuHuManDetailHeadVO.RepresentativeWorks.PuWorks work = new ZhuHuManDetailHeadVO.RepresentativeWorks.PuWorks();
                BeanUtils.copyProperties((Object)h, (Object)work);
                works.add(work);
            });
            representativeWorks.setPuWorks(works);
        }
        result.setRepresentativeWorks(representativeWorks);
        ZhuHuManDetailHeadVO.PromotionData promotionData = new ZhuHuManDetailHeadVO.PromotionData();
        List<ZhuHuManDetailHeadEntity.Detail.OrderFieldSkill> orderFieldSkills = detail.getOrderFieldSkill();
        if (CollectionUtil.isNotEmpty(orderFieldSkills)) {
            ArrayList<ZhuHuManDetailHeadVO.PromotionData.OrderFieldSkill> skills = new ArrayList<ZhuHuManDetailHeadVO.PromotionData.OrderFieldSkill>(orderFieldSkills.size());
            orderFieldSkills.forEach(h -> {
                ZhuHuManDetailHeadVO.PromotionData.OrderFieldSkill skill = new ZhuHuManDetailHeadVO.PromotionData.OrderFieldSkill();
                BeanUtils.copyProperties((Object)h, (Object)skill);
                skills.add(skill);
            });
            promotionData.setOrderFieldSkill(skills);
        }
        if (CollectionUtil.isNotEmpty(offerList = detail.getOffer())) {
            ArrayList<ZhuHuManDetailHeadVO.PromotionData.Offer> offers = new ArrayList<ZhuHuManDetailHeadVO.PromotionData.Offer>(offerList.size());
            offerList.forEach(h -> {
                ZhuHuManDetailHeadVO.PromotionData.Offer offer = new ZhuHuManDetailHeadVO.PromotionData.Offer();
                BeanUtils.copyProperties((Object)h, (Object)offer);
                offers.add(offer);
            });
            promotionData.setOffer(offers);
        }
        result.setPromotionData(promotionData);
    }
}

