/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.industryinfo.job;

import com.els.common.api.service.JobRpcService;
import com.els.modules.industryinfo.job.utils.DataFormatUtils;
import com.els.modules.organ.entity.PurchaserOrganAttractItem;
import com.els.modules.organ.entity.PurchaserOrganContractTalentItem;
import com.els.modules.organ.entity.PurchaserOrganFansReleaseItem;
import com.els.modules.organ.entity.PurchaserOrganGradeReleaseItem;
import com.els.modules.organ.entity.PurchaserOrganHead;
import com.els.modules.organ.entity.PurchaserOrganIndustryReleaseItem;
import com.els.modules.organ.entity.PurchaserOrganItem;
import com.els.modules.organ.service.PurchaserOrganAttractItemService;
import com.els.modules.organ.service.PurchaserOrganHeadService;
import com.mongodb.client.MongoCursor;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.stereotype.Component;

@Component
public class McnHeadOrganizationJob
implements JobRpcService {
    private static final Logger log = LoggerFactory.getLogger(McnHeadOrganizationJob.class);
    @Autowired
    private PurchaserOrganHeadService purchaserOrganHeadService;
    @Autowired
    private PurchaserOrganAttractItemService purchaserOrganAttractItemService;
    @Resource
    private MongoTemplate mongoTemplate;
    private final String MCN_COLLECTION_NAME = "tb_invite_data_detail";
    private final String MCN_CATGORY_DETAIL_COLLECTION_NAME = "tb_invite_data_category_detail";
    private final String MCN_TOPMAN_CONTRACT_COLLECTION_NAME = "tb_invite_mcn_topman_list_data";
    private final int BATCH_SIZE = 500;

    public void execute(String parameter) {
        log.info("------------start McnOrganizationJob-----------" + parameter);
        log.info("ddddddddddddddddddddd:" + parameter);
        boolean i = false;
        try (MongoCursor cursor = this.mongoTemplate.getCollection("tb_invite_data_detail").find().noCursorTimeout(true).batchSize(500).cursor();){
            ArrayList<PurchaserOrganHead> entityList = new ArrayList<PurchaserOrganHead>();
            log.info("------------start McnOrganizationJob -----------1");
            while (cursor.hasNext()) {
                Document doc = (Document)cursor.next();
                try {
                    PurchaserOrganHead head = this.setHead(doc);
                    log.info("PurchaserOrganHead1=" + (Object)((Object)head));
                    entityList.add(head);
                    String string = head.getOrganType();
                }
                catch (Exception e) {
                    log.error("McnOrganizationJob error ", (Throwable)e);
                }
            }
            log.info("aaaaaaaaaaaaaaaaa=" + entityList);
            this.purchaserOrganHeadService.saveOrUpdateBatch(entityList);
        }
        catch (Exception e) {
            log.error("McnOrganizationJob error", (Throwable)e);
        }
    }

    private PurchaserOrganHead genOrganization(Document doc) {
        PurchaserOrganHead head = new PurchaserOrganHead();
        head.setId(doc.getString((Object)"_id"));
        head.setLogo(doc.getString((Object)"bussiness_logo"));
        head.setElsAccount("100000");
        head.setOrganName(doc.getString((Object)"bussiness_name"));
        head.setPlatform("1");
        head.setAuthenEnterprise(doc.getString((Object)"company_name"));
        if (doc.get((Object)"contact") != null) {
            Map contacts = (Map)doc.get((Object)"contact", Map.class);
            head.setWechat((String)contacts.get("wechat"));
            head.setLinkInformation((String)contacts.get("phone"));
        }
        if (doc.get((Object)"bussiness_type") != null) {
            head.setOrganType(this.getOrganType(doc.getList((Object)"bussiness_type", Integer.class)));
        }
        head.setSettledDays(doc.getInteger((Object)"join_days", 0) + "");
        head.setRank(String.valueOf(doc.getInteger((Object)"captain_level")));
        head.setActivityNum(DataFormatUtils.numberToBigDecimal(doc.get((Object)"total_activity_count")));
        head.setFinishActivityNum(DataFormatUtils.numberToBigDecimal(doc.get((Object)"history_activity_completed_ratio")));
        return head;
    }

    private PurchaserOrganAttractItem genPurchaserOrganAttractItem(Document attract) {
        PurchaserOrganAttractItem item = new PurchaserOrganAttractItem();
        item.setId(attract.getString((Object)"_id"));
        item.setElsAccount("100000");
        item.setHeadId(attract.getString((Object)"invite_id"));
        item.setCategory(attract.getString((Object)"cate_name"));
        item.setCategoryId(attract.getString((Object)"cate_id"));
        item.setTotalSales(DataFormatUtils.numberToBigDecimal(attract.get((Object)"sale_low")));
        item.setTalentNum(DataFormatUtils.numberToBigDecimal(attract.get((Object)"order_daren_count")));
        item.setSingleGoodsNum(DataFormatUtils.numberToBigDecimal(attract.get((Object)"order_product_count")));
        item.setSingleStoreNum(DataFormatUtils.numberToBigDecimal(attract.get((Object)"order_shop_count")));
        item.setCommissionAvg(DataFormatUtils.numberToBigDecimal(attract.get((Object)"avg_commission_rate")).multiply(new BigDecimal(100)));
        item.setTotalSingleGoodsNum(DataFormatUtils.numberToBigDecimal(attract.get((Object)"order_count")));
        item.setSingleQuantityAvg(DataFormatUtils.numberToBigDecimal(attract.get((Object)"avg_product_order_count")));
        item.setServiceGoodsNum(DataFormatUtils.numberToBigDecimal(attract.get((Object)"product_count")));
        item.setServiceStoreNum(DataFormatUtils.numberToBigDecimal(attract.get((Object)"shop_count")));
        item.setServiceFeeAvg(DataFormatUtils.numberToBigDecimal(attract.get((Object)"avg_service_rate")).multiply(new BigDecimal(100)));
        item.setDays(attract.getString((Object)"days"));
        item.setQueryDateTime(DataFormatUtils.numberToBigDecimal(attract.get((Object)"time_begin")) + "-" + DataFormatUtils.numberToBigDecimal(attract.get((Object)"time_begin")));
        return item;
    }

    private String getOrganType(List<Integer> bussiness_type) {
        if (bussiness_type.size() > 1) {
            return "2";
        }
        if (bussiness_type.size() > 0) {
            int type = bussiness_type.get(0);
            if (type == 1) {
                return type + "";
            }
            return "0";
        }
        return null;
    }

    private PurchaserOrganContractTalentItem genOrganContractTalentItem(Document doc, String headId) {
        PurchaserOrganContractTalentItem item = new PurchaserOrganContractTalentItem();
        item.setHeadId(headId);
        item.setTalentId(doc.getString((Object)"top_man_id"));
        item.setTalentName(doc.getString((Object)"nickname"));
        item.setTalentAvatar(doc.getString((Object)"avatar_url"));
        item.setFansNum(DataFormatUtils.numberToBigDecimal(doc.get((Object)"fans_num")));
        item.setViewers(DataFormatUtils.numberToBigDecimal(doc.get((Object)"watch_cnt_medium_30d")));
        item.setTrillNumber(doc.getString((Object)"account_douyin"));
        item.setCategory(this.getTopManCategory(doc.getList((Object)"main_category_list", String.class)));
        item.setGoodsWom(DataFormatUtils.numberToBigDecimal(doc.get((Object)"credit_score")));
        item.setLevel(doc.getString((Object)"level"));
        item.setGender(String.valueOf(doc.getInteger((Object)"gender")));
        return item;
    }

    private String getTopManCategory(List<String> cates) {
        String cateStr = "";
        int count = 0;
        for (String cate : cates) {
            if (count > 0) {
                cateStr = cateStr + "/";
            }
            cateStr = cateStr + cate;
            ++count;
        }
        return cateStr;
    }

    private PurchaserOrganItem genOrganizationItem(Document doc, Document mainDoc) {
        Document organItem = (Document)doc.get((Object)"overview_data");
        if (doc == null || doc.isEmpty()) {
            return null;
        }
        PurchaserOrganItem item = new PurchaserOrganItem();
        item.setId(doc.getString((Object)"_id"));
        item.setHeadId(doc.getString((Object)"invite_id"));
        item.setElsAccount("100000");
        item.setTalentNum(DataFormatUtils.numberToBigDecimal(mainDoc.get((Object)"author_count")));
        item.setFansNum(DataFormatUtils.numberToBigDecimal(mainDoc.get((Object)"total_author_fans_count")));
        item.setQualityNum(DataFormatUtils.numberToBigDecimal(organItem.get((Object)"excellent_author_count")));
        item.setQualityFansNum(DataFormatUtils.numberToBigDecimal(organItem.get((Object)"excellent_author_fans_count")));
        item.setPlayNum(DataFormatUtils.numberToBigDecimal(organItem.get((Object)"live_author_count")));
        item.setPlayTalentNum(DataFormatUtils.numberToBigDecimal(organItem.get((Object)"total_live_count")));
        item.setBurstOrder(DataFormatUtils.numberToBigDecimal(organItem.get((Object)"baodan_count")));
        item.setIntoRanking(DataFormatUtils.numberToBigDecimal(organItem.get((Object)"in_author_serving_rank_count")));
        ArrayList<PurchaserOrganIndustryReleaseItem> prchaserOrganIndustryReleaseItems = new ArrayList<PurchaserOrganIndustryReleaseItem>();
        Document category = (Document)doc.get((Object)"author_category_distribution");
        Set keys = category.keySet();
        for (String key : keys) {
            PurchaserOrganIndustryReleaseItem categoryItem = new PurchaserOrganIndustryReleaseItem();
            categoryItem.setHeadId(doc.getString((Object)"invite_id"));
            categoryItem.setCategory(key);
            categoryItem.setCategoryProportion(DataFormatUtils.numberToBigDecimal(category.get((Object)key)));
            prchaserOrganIndustryReleaseItems.add(categoryItem);
        }
        item.setPrchaserOrganIndustryReleaseItems(prchaserOrganIndustryReleaseItems);
        ArrayList<PurchaserOrganFansReleaseItem> purchaserOrganFansReleaseItems = new ArrayList<PurchaserOrganFansReleaseItem>();
        List fansDist = doc.getList((Object)"author_fans_distribution", Object.class);
        int fansRelea = 1;
        for (Object obj : fansDist) {
            PurchaserOrganFansReleaseItem fansItem = new PurchaserOrganFansReleaseItem();
            fansItem.setHeadId(doc.getString((Object)"invite_id"));
            fansItem.setFans(fansRelea + "");
            fansItem.setFansOneProportion(DataFormatUtils.numberToBigDecimal(obj));
            purchaserOrganFansReleaseItems.add(fansItem);
            ++fansRelea;
        }
        item.setPurchaserOrganFansReleaseItems(purchaserOrganFansReleaseItems);
        ArrayList<PurchaserOrganGradeReleaseItem> purchaserOrganGradeReleaseItems = new ArrayList<PurchaserOrganGradeReleaseItem>();
        Document gradeRelease = (Document)doc.get((Object)"author_level_distribution");
        Set gradeKey = gradeRelease.keySet();
        for (String key : gradeKey) {
            PurchaserOrganGradeReleaseItem gradeItem = new PurchaserOrganGradeReleaseItem();
            gradeItem.setHeadId(doc.getString((Object)"invite_id"));
            gradeItem.setGrade(key);
            gradeItem.setGradeProportion(DataFormatUtils.numberToBigDecimal(gradeRelease.get((Object)key)));
            purchaserOrganGradeReleaseItems.add(gradeItem);
        }
        item.setPurchaserOrganGradeReleaseItems(purchaserOrganGradeReleaseItems);
        return item;
    }

    public PurchaserOrganHead setHead(Document document) {
        PurchaserOrganHead head = this.genOrganization(document);
        String type = head.getOrganType();
        String invite_id = document.getString((Object)"_id");
        Document inquerDoc = new Document();
        inquerDoc.append("invite_id", (Object)invite_id);
        try (MongoCursor attractCursor = this.mongoTemplate.getCollection("tb_invite_data_category_detail").find((Bson)inquerDoc).noCursorTimeout(true).cursor();){
            ArrayList<PurchaserOrganAttractItem> entityList = new ArrayList<PurchaserOrganAttractItem>();
            Document attract = null;
            while (attractCursor.hasNext()) {
                try {
                    attract = (Document)attractCursor.next();
                    if ("\u4e0d\u9650".equals(attract.getString((Object)"cate_name")) && "30days".equals(attract.getString((Object)"days"))) {
                        head.setTalentNum(DataFormatUtils.numberToBigDecimal(attract.get((Object)"order_daren_count")));
                        head.setSingleGoodsNum(DataFormatUtils.numberToBigDecimal(attract.get((Object)"order_product_count")));
                        head.setSingleStoreNum(DataFormatUtils.numberToBigDecimal(attract.get((Object)"order_shop_count")));
                        head.setCommissionAvg(DataFormatUtils.numberToBigDecimal(attract.get((Object)"avg_commission_rate")));
                        head.setTotalSingleGoodsNum(DataFormatUtils.numberToBigDecimal(attract.get((Object)"order_count")));
                        head.setServiceGoodsNum(DataFormatUtils.numberToBigDecimal(attract.get((Object)"product_count")));
                        head.setServiceStoreNum(DataFormatUtils.numberToBigDecimal(attract.get((Object)"shop_count")));
                        head.setTotalSales(DataFormatUtils.numberToBigDecimal(attract.get((Object)"sale_low")));
                        head.setSingleQuantityAvg(DataFormatUtils.numberToBigDecimal(attract.get((Object)"avg_product_order_count")));
                    }
                    if (!"2".equals(type) && !"1".equals(type)) continue;
                    PurchaserOrganAttractItem item = this.genPurchaserOrganAttractItem(attract);
                    item.setActivityNum(DataFormatUtils.numberToBigDecimal(document.get((Object)"total_activity_count")));
                    item.setFinishActivityNum(DataFormatUtils.numberToBigDecimal(document.get((Object)"history_activity_completed_ratio")));
                    entityList.add(item);
                }
                catch (Exception e) {
                    log.error("attractCursor error", (Throwable)e);
                    if (attract == null) continue;
                    log.error("error is Data" + attract.toJson());
                }
            }
            this.purchaserOrganAttractItemService.saveOrUpdateBatch(entityList);
        }
        catch (Exception e) {
            log.error("insertCategory error", (Throwable)e);
        }
        return head;
    }
}

