/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.industryinfo.job;

import com.els.common.api.service.JobRpcService;
import com.els.modules.organ.entity.PurchaserOrganAttractItem;
import com.els.modules.organ.entity.PurchaserOrganHead;
import com.els.modules.organ.service.PurchaserOrganAttractItemService;
import com.els.modules.organ.service.PurchaserOrganHeadService;
import com.mongodb.client.MongoCursor;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.bson.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.stereotype.Component;

@Component
public class KsMcnOrganizationJob
implements JobRpcService {
    private static final Logger log = LoggerFactory.getLogger(KsMcnOrganizationJob.class);
    @Autowired
    private PurchaserOrganHeadService purchaserOrganHeadService;
    @Autowired
    private PurchaserOrganAttractItemService purchaserOrganAttractItemService;
    @Resource
    private MongoTemplate mongoTemplate;
    private final String TB_KUAIFENXIAO_INVITE_DATAS = "tb_kuaifenxiao_invite_datas";
    private final int BATCH_SIZE = 5000;

    public void execute(String parameter) {
        log.info("ddddddddddddddddddddd:" + parameter);
        log.info("------------start GoodsCategoryJob-----------");
        boolean i = false;
        try (MongoCursor cursor = this.mongoTemplate.getCollection("tb_kuaifenxiao_invite_datas").find().noCursorTimeout(true).batchSize(5000).cursor();){
            ArrayList<PurchaserOrganHead> entityList = new ArrayList<PurchaserOrganHead>();
            ArrayList<PurchaserOrganAttractItem> purchaserOrganAttractItemList = new ArrayList<PurchaserOrganAttractItem>();
            log.info("------------start GoodsCategoryJob111111 -----------1");
            boolean nIndex = false;
            while (cursor.hasNext()) {
                Document doc = (Document)cursor.next();
                try {
                    PurchaserOrganHead purchaserOrganHead = this.genOrganization(doc);
                    entityList.add(purchaserOrganHead);
                    purchaserOrganAttractItemList.add(purchaserOrganHead.getPurchaserOrganAttractItem());
                }
                catch (Exception e) {
                    log.error("GoodsCategoryJob error ", (Throwable)e);
                }
            }
            this.purchaserOrganHeadService.saveOrUpdateBatch(entityList);
            this.purchaserOrganAttractItemService.deleteBatchByIds(purchaserOrganAttractItemList);
            this.purchaserOrganAttractItemService.saveOrUpdateBatch(purchaserOrganAttractItemList);
        }
        catch (Exception e) {
            log.error("GoodsCategoryJob error", (Throwable)e);
        }
    }

    private PurchaserOrganHead genOrganization(Document doc) {
        PurchaserOrganHead head = new PurchaserOrganHead();
        head.setId(doc.getString((Object)"_id"));
        head.setElsAccount("100000");
        head.setOrganName(doc.getString((Object)"invite_name"));
        head.setOrganCode(doc.getString((Object)"invite_id"));
        head.setPlatform("2");
        head.setOrganType("1");
        List paramList = (List)doc.get((Object)"contactList");
        Map<String, String> contacts = this.getContacts(paramList);
        head.setLinkInformation(contacts.get("phone"));
        head.setLink(contacts.get("link"));
        PurchaserOrganAttractItem purchaserOrganAttractItem = new PurchaserOrganAttractItem();
        purchaserOrganAttractItem.setHeadId(doc.getString((Object)"_id"));
        purchaserOrganAttractItem.setCategory(doc.getString((Object)"category_name"));
        purchaserOrganAttractItem.setCategoryId(String.valueOf(doc.getInteger((Object)"category_id")));
        purchaserOrganAttractItem.setCommissionAvg(new BigDecimal(doc.getInteger((Object)"minItemCommissionRate")));
        purchaserOrganAttractItem.setServiceFeeAvg(new BigDecimal(doc.getInteger((Object)"minInvestmentPromotionRate")));
        purchaserOrganAttractItem.setSingleStoreNum(new BigDecimal(doc.getInteger((Object)"distributeTradeSellerCount")));
        purchaserOrganAttractItem.setSingleGoodsNum(new BigDecimal(doc.getInteger((Object)"distributeTradeItemCount")));
        purchaserOrganAttractItem.setSingleQuantityAvg(new BigDecimal(doc.getInteger((Object)"distributeItemOrderCount")));
        purchaserOrganAttractItem.setActivityNum(new BigDecimal(doc.getInteger((Object)"activityCount")));
        purchaserOrganAttractItem.setCustomerPrice(new BigDecimal(doc.getDouble((Object)"customerPrice")));
        head.setPurchaserOrganAttractItem(purchaserOrganAttractItem);
        return head;
    }

    private Map<String, String> getContacts(List<Map<String, Object>> paramList) {
        HashMap<String, String> contacts = new HashMap<String, String>();
        if (CollectionUtils.isNotEmpty(paramList)) {
            Map<String, Object> stringObjectMap = paramList.get(0);
            String phone = null;
            String link = null;
            if (stringObjectMap.get("contactDetail") != null) {
                phone = (String)stringObjectMap.get("contactDetail");
            }
            if (stringObjectMap.get("contactName") != null) {
                link = (String)stringObjectMap.get("contactName");
            }
            contacts.put("phone", phone);
            contacts.put("link", link);
        }
        return contacts;
    }
}

