/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.industryinfo.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.els.common.exception.ELSBootException;
import com.els.common.util.I18nUtil;
import com.els.modules.industryinfo.dto.DouYinTopManDetailDTO;
import com.els.modules.industryinfo.dto.KsTopManDetailDTO;
import com.els.modules.industryinfo.dto.RedBookTopManDetailDTO;
import com.els.modules.industryinfo.dto.TopManContrastDTO;
import com.els.modules.industryinfo.dto.TopManContrastParamDTO;
import com.els.modules.industryinfo.dto.ZhiHuTopManDetailDTO;
import com.els.modules.industryinfo.service.BStationTopManInformationService;
import com.els.modules.industryinfo.service.BlogTopManInformationService;
import com.els.modules.industryinfo.service.KuaiShouTopManInformationService;
import com.els.modules.industryinfo.service.RedBookTopManInformationService;
import com.els.modules.industryinfo.service.TopManContrastService;
import com.els.modules.industryinfo.service.TopManInformationService;
import com.els.modules.industryinfo.service.ZhiHuTopManInformationService;
import com.els.modules.industryinfo.vo.TopManContrastVO;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TopManContrastServiceImpl
implements TopManContrastService {
    @Autowired
    private TopManInformationService douyinTopManInformationService;
    @Autowired
    private KuaiShouTopManInformationService kuaiShouTopManInformationService;
    @Autowired
    private RedBookTopManInformationService redBookTopManInformationService;
    @Autowired
    private BStationTopManInformationService bStationTopManInformationService;
    @Autowired
    private BlogTopManInformationService blogTopManInformationService;
    @Autowired
    private ZhiHuTopManInformationService zhiHuTopManInformationService;

    @Override
    public List<TopManContrastVO> contrastTopMan(TopManContrastDTO dto) {
        ArrayList<TopManContrastVO> list = new ArrayList<TopManContrastVO>(3);
        if (dto == null || CollectionUtil.isEmpty(dto.getParamList())) {
            return list;
        }
        List<TopManContrastParamDTO> paramList = dto.getParamList();
        if (paramList.size() > 3) {
            paramList = paramList.subList(0, 3);
        }
        switch (dto.getPlatform()) {
            case "1": {
                paramList.forEach(h -> {
                    DouYinTopManDetailDTO dyDTO = this.dyDtoTransfer((TopManContrastParamDTO)h);
                    dyDTO.setClearCache(dto.getClearCache());
                    list.add(this.douyinTopManInformationService.getTopmanScore(dyDTO));
                });
                break;
            }
            case "2": {
                paramList.forEach(h -> list.add(this.kuaiShouTopManInformationService.getByUserId(h.getTopManId())));
                break;
            }
            case "3": {
                paramList.forEach(h -> {
                    RedBookTopManDetailDTO rbDTO = this.rbDtoTransfer((TopManContrastParamDTO)h);
                    rbDTO.setClearCache(dto.getClearCache());
                    list.add(this.redBookTopManInformationService.getDetailHead(rbDTO));
                });
                break;
            }
            case "4": {
                paramList.forEach(h -> list.add(this.bStationTopManInformationService.bStationTopManDetails(h.getStationId(), h.getTopManId())));
                break;
            }
            case "5": {
                paramList.forEach(h -> list.add(this.blogTopManInformationService.blogTopManDetails(h.getTopManId())));
                break;
            }
            case "6": {
                paramList.forEach(h -> {
                    ZhiHuTopManDetailDTO zhDTO = this.zhDtoTransfer((TopManContrastParamDTO)h);
                    zhDTO.setClearCache(dto.getClearCache());
                    list.add(this.zhiHuTopManInformationService.getDetailHead(zhDTO));
                });
                break;
            }
            default: {
                throw new ELSBootException(I18nUtil.translate((String)"", (String)"\u672a\u627e\u5230\u8be5\u8bf7\u6c42\u7c7b\u578b"));
            }
        }
        return list;
    }

    private DouYinTopManDetailDTO dyDtoTransfer(TopManContrastParamDTO dto) {
        DouYinTopManDetailDTO dyDTO = new DouYinTopManDetailDTO();
        dyDTO.setTopManId(dto.getTopManId());
        dyDTO.setTopManName(dto.getTopManName());
        dyDTO.setTopmanRegion(dto.getTopmanRegion());
        dyDTO.setAvatar(dto.getAvatar());
        return dyDTO;
    }

    private KsTopManDetailDTO ksDtoTransfer(TopManContrastParamDTO dto) {
        KsTopManDetailDTO dyDTO = new KsTopManDetailDTO();
        dyDTO.setUserId(dto.getUserId());
        dyDTO.setStarId(dto.getStarId());
        dyDTO.setStarType("1");
        dyDTO.setTimeRangeType("1");
        return dyDTO;
    }

    private RedBookTopManDetailDTO rbDtoTransfer(TopManContrastParamDTO dto) {
        RedBookTopManDetailDTO rbDTO = new RedBookTopManDetailDTO();
        rbDTO.setUserId(dto.getTopManId());
        rbDTO.setDateType("1");
        return rbDTO;
    }

    private ZhiHuTopManDetailDTO zhDtoTransfer(TopManContrastParamDTO dto) {
        ZhiHuTopManDetailDTO zhDTO = new ZhiHuTopManDetailDTO();
        zhDTO.setPlatform("6");
        zhDTO.setPuId(dto.getTopManId());
        return zhDTO;
    }

    @Override
    public List<TopManContrastVO> dyTopManContrast(TopManContrastDTO dto) {
        ArrayList<TopManContrastVO> list = new ArrayList<TopManContrastVO>(3);
        List<TopManContrastParamDTO> paramList = this.contrastDtoTransfer(dto);
        switch (dto.getTaskType()) {
            case "baseData": {
                paramList.forEach(h -> {
                    DouYinTopManDetailDTO dyDTO = this.dyDtoTransfer((TopManContrastParamDTO)h);
                    dyDTO.setClearCache(dto.getClearCache());
                    list.add(this.douyinTopManInformationService.getDetailHead(dyDTO));
                });
                break;
            }
            case "videoData": {
                paramList.forEach(h -> {
                    DouYinTopManDetailDTO dyDTO = this.dyDtoTransfer((TopManContrastParamDTO)h);
                    dyDTO.setClearCache(dto.getClearCache());
                    list.add(this.douyinTopManInformationService.queryDetailHeadCore(dyDTO));
                });
                break;
            }
            default: {
                throw new ELSBootException(I18nUtil.translate((String)"", (String)"\u672a\u627e\u5230\u8be5\u8bf7\u6c42\u7c7b\u578b"));
            }
        }
        return list;
    }

    @Override
    public List<TopManContrastVO> ksTopManContrast(TopManContrastDTO dto) {
        ArrayList<TopManContrastVO> list = new ArrayList<TopManContrastVO>(3);
        List<TopManContrastParamDTO> paramList = this.contrastDtoTransfer(dto);
        switch (dto.getTaskType()) {
            case "baseData": {
                paramList.forEach(h -> {
                    KsTopManDetailDTO ksDTO = this.ksDtoTransfer((TopManContrastParamDTO)h);
                    ksDTO.setClearCache(dto.getClearCache());
                    list.add(this.kuaiShouTopManInformationService.getDetailHead(ksDTO));
                });
                break;
            }
            case "videoData": {
                paramList.forEach(h -> {
                    KsTopManDetailDTO ksDTO = this.ksDtoTransfer((TopManContrastParamDTO)h);
                    ksDTO.setClearCache(dto.getClearCache());
                    list.add(this.kuaiShouTopManInformationService.getDetailBodyVideoNew(ksDTO));
                });
                break;
            }
            case "liveData": {
                paramList.forEach(h -> {
                    KsTopManDetailDTO ksDTO = this.ksDtoTransfer((TopManContrastParamDTO)h);
                    ksDTO.setClearCache(dto.getClearCache());
                    list.add(this.kuaiShouTopManInformationService.getDetailBodyLiveNew(ksDTO));
                });
                break;
            }
            case "fansData": {
                paramList.forEach(h -> {
                    KsTopManDetailDTO ksDTO = this.ksDtoTransfer((TopManContrastParamDTO)h);
                    ksDTO.setClearCache(dto.getClearCache());
                    list.add(this.kuaiShouTopManInformationService.getDetailBodyFans(ksDTO));
                });
                break;
            }
            case "goodsData": {
                paramList.forEach(h -> {
                    KsTopManDetailDTO ksDTO = this.ksDtoTransfer((TopManContrastParamDTO)h);
                    ksDTO.setClearCache(dto.getClearCache());
                    list.add(this.kuaiShouTopManInformationService.getDetailBodyBase(ksDTO));
                });
                break;
            }
            default: {
                throw new ELSBootException(I18nUtil.translate((String)"", (String)"\u672a\u627e\u5230\u8be5\u8bf7\u6c42\u7c7b\u578b"));
            }
        }
        return list;
    }

    @Override
    public List<TopManContrastVO> rbTopManContrast(TopManContrastDTO dto) {
        ArrayList<TopManContrastVO> list = new ArrayList<TopManContrastVO>(3);
        List<TopManContrastParamDTO> paramList = this.contrastDtoTransfer(dto);
        switch (dto.getTaskType()) {
            case "baseData": {
                paramList.forEach(h -> {
                    RedBookTopManDetailDTO rbDTO = this.rbDtoTransfer((TopManContrastParamDTO)h);
                    rbDTO.setClearCache(dto.getClearCache());
                    list.add(this.redBookTopManInformationService.getDetailHead(rbDTO));
                });
                break;
            }
            case "fansData": {
                paramList.forEach(h -> {
                    RedBookTopManDetailDTO rbDTO = this.rbDtoTransfer((TopManContrastParamDTO)h);
                    rbDTO.setClearCache(dto.getClearCache());
                    list.add(this.redBookTopManInformationService.getDetailFans(rbDTO));
                });
                break;
            }
            case "goodsData": {
                paramList.forEach(h -> {
                    RedBookTopManDetailDTO rbDTO = this.rbDtoTransfer((TopManContrastParamDTO)h);
                    rbDTO.setClearCache(dto.getClearCache());
                    list.add(this.redBookTopManInformationService.getDetailLiveSales(rbDTO));
                });
                break;
            }
            default: {
                throw new ELSBootException(I18nUtil.translate((String)"", (String)"\u672a\u627e\u5230\u8be5\u8bf7\u6c42\u7c7b\u578b"));
            }
        }
        return list;
    }

    @Override
    public List<TopManContrastVO> biliTopManContrast(TopManContrastDTO dto) {
        ArrayList<TopManContrastVO> list = new ArrayList<TopManContrastVO>(3);
        List<TopManContrastParamDTO> paramList = this.contrastDtoTransfer(dto);
        switch (dto.getTaskType()) {
            case "baseData": {
                paramList.forEach(h -> list.add(this.bStationTopManInformationService.bStationTopManDetails(h.getStationId(), h.getTopManId())));
                break;
            }
            case "fansData": {
                paramList.forEach(h -> list.add(this.bStationTopManInformationService.bStationTopManFanAnalysisDetails(h.getStationId(), h.getTopManId())));
                break;
            }
            default: {
                throw new ELSBootException(I18nUtil.translate((String)"", (String)"\u672a\u627e\u5230\u8be5\u8bf7\u6c42\u7c7b\u578b"));
            }
        }
        return list;
    }

    @Override
    public List<TopManContrastVO> blogTopManContrast(TopManContrastDTO dto) {
        ArrayList<TopManContrastVO> list = new ArrayList<TopManContrastVO>(3);
        List<TopManContrastParamDTO> paramList = this.contrastDtoTransfer(dto);
        switch (dto.getTaskType()) {
            case "baseData": {
                paramList.forEach(h -> list.add(this.blogTopManInformationService.blogTopManDetails(h.getTopManId())));
                break;
            }
            case "fansData": {
                paramList.forEach(h -> list.add(this.blogTopManInformationService.blogTopManFanAnalysisDetails(h.getTopManId())));
                break;
            }
            default: {
                throw new ELSBootException(I18nUtil.translate((String)"", (String)"\u672a\u627e\u5230\u8be5\u8bf7\u6c42\u7c7b\u578b"));
            }
        }
        return list;
    }

    @Override
    public List<TopManContrastVO> zhTopManContrast(TopManContrastDTO dto) {
        ArrayList<TopManContrastVO> list = new ArrayList<TopManContrastVO>(3);
        List<TopManContrastParamDTO> paramList = this.contrastDtoTransfer(dto);
        paramList.forEach(h -> {
            ZhiHuTopManDetailDTO zhDTO = this.zhDtoTransfer((TopManContrastParamDTO)h);
            zhDTO.setClearCache(dto.getClearCache());
            list.add(this.zhiHuTopManInformationService.getDetailHead(zhDTO));
        });
        return list;
    }

    private List<TopManContrastParamDTO> contrastDtoTransfer(TopManContrastDTO dto) {
        if (dto == null || CollectionUtil.isEmpty(dto.getParamList())) {
            throw new RuntimeException(I18nUtil.translate((String)"", (String)"\u53c2\u6570\u9519\u8bef"));
        }
        List<TopManContrastParamDTO> paramList = dto.getParamList();
        if (paramList.size() > 3) {
            paramList = paramList.subList(0, 3);
        }
        return paramList;
    }
}

