/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.industryinfo.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import com.els.common.exception.ELSBootException;
import com.els.common.util.I18nUtil;
import com.els.modules.industryinfo.dto.DouYinTopManDetailDTO;
import com.els.modules.industryinfo.dto.KsTopManDetailDTO;
import com.els.modules.industryinfo.dto.RedBookTopManDetailDTO;
import com.els.modules.industryinfo.dto.TopManContrastDTO;
import com.els.modules.industryinfo.dto.TopManContrastParamDTO;
import com.els.modules.industryinfo.dto.ZhiHuTopManDetailDTO;
import com.els.modules.industryinfo.entity.BStationTopManInformationFanAnalysisEntity;
import com.els.modules.industryinfo.entity.BStationTopManInformationPromotionAnalysisEntity;
import com.els.modules.industryinfo.entity.BStationTopManInformationTopDetailsEntity;
import com.els.modules.industryinfo.entity.BlogTopManInformationFanAnalysisEntity;
import com.els.modules.industryinfo.entity.BlogTopManInformationPromotionAnalysisEntity;
import com.els.modules.industryinfo.entity.BlogTopManInformationTopDetailsEntity;
import com.els.modules.industryinfo.entity.DouYinTopManInformationVideoDetailsAnalysisEntity;
import com.els.modules.industryinfo.entity.TopManResultDetailBody;
import com.els.modules.industryinfo.entity.TopManResultDetailBodyBase;
import com.els.modules.industryinfo.enumerate.BlogTopmanGenderEnum;
import com.els.modules.industryinfo.enumerate.BlogVerifiedTypeEnum;
import com.els.modules.industryinfo.service.BStationTopManInformationService;
import com.els.modules.industryinfo.service.BlogTopManInformationService;
import com.els.modules.industryinfo.service.KuaiShouTopManInformationService;
import com.els.modules.industryinfo.service.RedBookTopManInformationService;
import com.els.modules.industryinfo.service.TopManContrastService;
import com.els.modules.industryinfo.service.TopManInformationService;
import com.els.modules.industryinfo.service.ZhiHuTopManInformationService;
import com.els.modules.industryinfo.utils.spider.entity.KsTopManDetailBaseEntity;
import com.els.modules.industryinfo.utils.spider.entity.KsTopManDetailFansEntity;
import com.els.modules.industryinfo.utils.spider.entity.KsTopManDetailVideoAnalysisEntity;
import com.els.modules.industryinfo.utils.spider.vo.KsTopManDetailHeadVO;
import com.els.modules.industryinfo.utils.spider.vo.RedBookTopManDetailHeadVO;
import com.els.modules.industryinfo.utils.spider.vo.ZhuHuManDetailHeadVO;
import com.els.modules.industryinfo.vo.BiliTopManContrastVO;
import com.els.modules.industryinfo.vo.BlogTopManContrastVO;
import com.els.modules.industryinfo.vo.DyTopManContrastVO;
import com.els.modules.industryinfo.vo.KsTopManContrastVO;
import com.els.modules.industryinfo.vo.RbTopManContrastVO;
import com.els.modules.industryinfo.vo.TopManContrastVO;
import com.els.modules.industryinfo.vo.TopManDetailHeadVO;
import com.els.modules.industryinfo.vo.ZhTopManContrastVO;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TopManContrastServiceImpl
implements TopManContrastService {
    @Autowired
    private TopManInformationService douyinTopManInformationService;
    @Autowired
    private KuaiShouTopManInformationService kuaiShouTopManInformationService;
    @Autowired
    private RedBookTopManInformationService redBookTopManInformationService;
    @Autowired
    private BStationTopManInformationService bStationTopManInformationService;
    @Autowired
    private BlogTopManInformationService blogTopManInformationService;
    @Autowired
    private ZhiHuTopManInformationService zhiHuTopManInformationService;

    @Override
    public List<TopManContrastVO> contrastTopMan(TopManContrastDTO dto) {
        ArrayList<TopManContrastVO> list = new ArrayList<TopManContrastVO>(3);
        if (dto == null || CollectionUtil.isEmpty(dto.getParamList())) {
            return list;
        }
        List<TopManContrastParamDTO> paramList = dto.getParamList();
        if (paramList.size() > 3) {
            paramList = paramList.subList(0, 3);
        }
        switch (dto.getPlatform()) {
            case "1": {
                paramList.forEach(h -> {
                    DouYinTopManDetailDTO dyDTO = this.dyDtoTransfer((TopManContrastParamDTO)h);
                    dyDTO.setClearCache(dto.getClearCache());
                    list.add(this.douyinTopManInformationService.getTopmanScore(dyDTO));
                });
                break;
            }
            case "2": {
                paramList.forEach(h -> list.add(this.kuaiShouTopManInformationService.getByUserId(h.getTopManId())));
                break;
            }
            case "3": {
                paramList.forEach(h -> {
                    RedBookTopManDetailDTO rbDTO = this.rbDtoTransfer((TopManContrastParamDTO)h);
                    rbDTO.setClearCache(dto.getClearCache());
                    list.add(this.redBookTopManInformationService.getDetailHead(rbDTO));
                });
                break;
            }
            case "4": {
                paramList.forEach(h -> list.add(this.bStationTopManInformationService.bStationTopManDetails(h.getStationId(), h.getTopManId())));
                break;
            }
            case "5": {
                paramList.forEach(h -> list.add(this.blogTopManInformationService.blogTopManDetails(h.getTopManId())));
                break;
            }
            case "6": {
                paramList.forEach(h -> {
                    ZhiHuTopManDetailDTO zhDTO = this.zhDtoTransfer((TopManContrastParamDTO)h);
                    zhDTO.setClearCache(dto.getClearCache());
                    list.add(this.zhiHuTopManInformationService.getDetailHead(zhDTO));
                });
                break;
            }
            default: {
                throw new ELSBootException(I18nUtil.translate((String)"", (String)"\u672a\u627e\u5230\u8be5\u8bf7\u6c42\u7c7b\u578b"));
            }
        }
        return list;
    }

    private DouYinTopManDetailDTO dyDtoTransfer(TopManContrastParamDTO dto) {
        DouYinTopManDetailDTO dyDTO = new DouYinTopManDetailDTO();
        dyDTO.setTopManId(dto.getTopManId());
        dyDTO.setTopManName(dto.getTopManName());
        dyDTO.setTopmanRegion(dto.getTopmanRegion());
        dyDTO.setAvatar(dto.getAvatar());
        return dyDTO;
    }

    private KsTopManDetailDTO ksDtoTransfer(TopManContrastParamDTO dto) {
        KsTopManDetailDTO dyDTO = new KsTopManDetailDTO();
        dyDTO.setUserId(dto.getUserId());
        dyDTO.setStarId(dto.getStarId());
        dyDTO.setLiveStatus(dto.getLiveStatus());
        dyDTO.setStarType("1");
        dyDTO.setTimeRangeType("1");
        return dyDTO;
    }

    private RedBookTopManDetailDTO rbDtoTransfer(TopManContrastParamDTO dto) {
        RedBookTopManDetailDTO rbDTO = new RedBookTopManDetailDTO();
        rbDTO.setUserId(dto.getTopManId());
        rbDTO.setDateType("1");
        return rbDTO;
    }

    private ZhiHuTopManDetailDTO zhDtoTransfer(TopManContrastParamDTO dto) {
        ZhiHuTopManDetailDTO zhDTO = new ZhiHuTopManDetailDTO();
        zhDTO.setPlatform("6");
        zhDTO.setPuId(dto.getTopManId());
        return zhDTO;
    }

    @Override
    public TopManContrastVO dyTopManContrast(TopManContrastDTO dto) {
        DyTopManContrastVO vo = new DyTopManContrastVO();
        List<TopManContrastParamDTO> paramList = this.contrastDtoTransfer(dto);
        switch (dto.getTaskType()) {
            case "baseData": {
                ArrayList<TopManDetailHeadVO.TopManBaseData> baseDatas = new ArrayList<TopManDetailHeadVO.TopManBaseData>(dto.getParamList().size());
                paramList.forEach(h -> {
                    DouYinTopManDetailDTO dyDTO = this.dyDtoTransfer((TopManContrastParamDTO)h);
                    dyDTO.setClearCache(dto.getClearCache());
                    TopManDetailHeadVO detailHead = this.douyinTopManInformationService.getDetailHead(dyDTO);
                    if (detailHead != null && detailHead.getTopManBaseData() != null) {
                        baseDatas.add(detailHead.getTopManBaseData());
                    }
                });
                vo.setBaseDatas(baseDatas);
                break;
            }
            case "videoData": {
                ArrayList<TopManDetailHeadVO.TopManVideoData> videoDatas = new ArrayList<TopManDetailHeadVO.TopManVideoData>(dto.getParamList().size());
                paramList.forEach(h -> {
                    DouYinTopManDetailDTO dyDTO = this.dyDtoTransfer((TopManContrastParamDTO)h);
                    dyDTO.setClearCache(dto.getClearCache());
                    TopManDetailHeadVO headVO = this.douyinTopManInformationService.queryDetailHeadCore(dyDTO);
                    DouYinTopManInformationVideoDetailsAnalysisEntity videoData = null;
                    try {
                        videoData = this.douyinTopManInformationService.douYinTopManInformationVideoDetailsAnalysis(h.getTopManId(), "true");
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    if (headVO != null && videoData != null) {
                        TopManDetailHeadVO.TopManVideoData topManVideoData = headVO.getTopManVideoData();
                        DouYinTopManInformationVideoDetailsAnalysisEntity.VideoDetails videoDetails = videoData.getVideoDetails();
                        if (topManVideoData != null && videoDetails != null) {
                            topManVideoData.setCompletionRate(videoDetails.getCompletionRate());
                            topManVideoData.setInteractRate(videoDetails.getInteractRate());
                        }
                        videoDatas.add(topManVideoData);
                    }
                });
                vo.setVideoDatas(videoDatas);
                break;
            }
            case "liveData": {
                ArrayList<TopManDetailHeadVO.TopManLiveData> liveDatas = new ArrayList<TopManDetailHeadVO.TopManLiveData>(dto.getParamList().size());
                paramList.forEach(h -> {
                    DouYinTopManDetailDTO dyDTO = this.dyDtoTransfer((TopManContrastParamDTO)h);
                    dyDTO.setClearCache(dto.getClearCache());
                    TopManDetailHeadVO headVO = this.douyinTopManInformationService.queryDetailHeadCore(dyDTO);
                    if (headVO != null && headVO.getTopManLiveData() != null) {
                        liveDatas.add(headVO.getTopManLiveData());
                    }
                });
                vo.setLiveDatas(liveDatas);
                break;
            }
            case "fansData": {
                ArrayList<Object> fansDatas = new ArrayList<Object>(dto.getParamList().size());
                paramList.forEach(h -> {
                    DouYinTopManDetailDTO dyDTO = this.dyDtoTransfer((TopManContrastParamDTO)h);
                    dyDTO.setClearCache(dto.getClearCache());
                    Object fansData = null;
                    try {
                        fansData = this.douyinTopManInformationService.douYinTopManInformationFanAnalysisEntity(h.getTopManId(), "0", "1");
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    if (fansData != null) {
                        fansDatas.add(fansData);
                    }
                });
                vo.setFansDatas(fansDatas);
                break;
            }
            case "goodsData": {
                ArrayList<TopManDetailHeadVO.TopManCoreData> goodsDatas = new ArrayList<TopManDetailHeadVO.TopManCoreData>(dto.getParamList().size());
                paramList.forEach(h -> {
                    DouYinTopManDetailDTO dyDTO = this.dyDtoTransfer((TopManContrastParamDTO)h);
                    dyDTO.setClearCache(dto.getClearCache());
                    TopManDetailHeadVO detailHead = this.douyinTopManInformationService.queryDetailHeadCore(dyDTO);
                    if (detailHead != null) {
                        TopManDetailHeadVO.TopManCoreData topManCoreData = detailHead.getTopManCoreData();
                        dyDTO.setBodyType("base");
                        dyDTO.setPopularizeType("1");
                        dyDTO.setStatisticsDateType("30d");
                        TopManResultDetailBody goodsData = this.douyinTopManInformationService.queryDetailBody(dyDTO);
                        if (topManCoreData != null && goodsData != null) {
                            TopManResultDetailBodyBase bodyBase = (TopManResultDetailBodyBase)goodsData;
                            List categoryNames = bodyBase.getCategoryAnalysisData().stream().map(TopManResultDetailBodyBase.popularizeAnalysisEntity::getCategory).collect(Collectors.toList());
                            List brandNames = bodyBase.getBrandAnalysisData().stream().map(TopManResultDetailBodyBase.popularizeAnalysisEntity::getBrand).collect(Collectors.toList());
                            topManCoreData.setCategoryAnalysisData(StrUtil.join((CharSequence)"\u3001", categoryNames));
                            topManCoreData.setBrandAnalysisData(StrUtil.join((CharSequence)"\u3001", brandNames));
                        }
                        goodsDatas.add(topManCoreData);
                    }
                });
                vo.setGoodsDatas(goodsDatas);
                break;
            }
            default: {
                throw new ELSBootException(I18nUtil.translate((String)"", (String)"\u672a\u627e\u5230\u8be5\u8bf7\u6c42\u7c7b\u578b"));
            }
        }
        return vo;
    }

    @Override
    public TopManContrastVO ksTopManContrast(TopManContrastDTO dto) {
        KsTopManContrastVO vo = new KsTopManContrastVO();
        List<TopManContrastParamDTO> paramList = this.contrastDtoTransfer(dto);
        switch (dto.getTaskType()) {
            case "baseData": {
                this.getKsBaseData(paramList, dto.getClearCache(), vo);
                break;
            }
            case "videoData": {
                this.getKsVideoData(paramList, dto.getClearCache(), vo);
                break;
            }
            case "fansData": {
                this.getKsFansData(paramList, dto.getClearCache(), vo);
                break;
            }
            case "goodsData": {
                this.getKsGoodsData(paramList, dto.getClearCache(), vo);
                break;
            }
            default: {
                throw new ELSBootException(I18nUtil.translate((String)"", (String)"\u672a\u627e\u5230\u8be5\u8bf7\u6c42\u7c7b\u578b"));
            }
        }
        return vo;
    }

    private void getKsGoodsData(List<TopManContrastParamDTO> paramList, String clearCache, KsTopManContrastVO vo) {
        ArrayList<KsTopManDetailBaseEntity.KeyData> goodsDatas = new ArrayList<KsTopManDetailBaseEntity.KeyData>(paramList.size());
        for (TopManContrastParamDTO h : paramList) {
            KsTopManDetailDTO ksDTO = this.ksDtoTransfer(h);
            ksDTO.setClearCache(clearCache);
            KsTopManDetailHeadVO detailHead = this.getKsHeadData(ksDTO);
            KsTopManDetailBaseEntity goodsData = this.kuaiShouTopManInformationService.getDetailBodyBase(ksDTO);
            if (goodsData == null) continue;
            KsTopManDetailBaseEntity.KeyData keyData = goodsData.getKeyData();
            KsTopManDetailBaseEntity.CommerceCapacity commerceCapacity = goodsData.getCommerceCapacity();
            if (keyData != null && commerceCapacity != null) {
                KsTopManDetailHeadVO.CoreData coreData;
                List channelNames = CollectionUtil.isNotEmpty(commerceCapacity.getHotSaleChannelInfo()) ? commerceCapacity.getHotSaleChannelInfo().stream().map(KsTopManDetailBaseEntity.HotSaleChannelInfo::getHotSaleChannelName).collect(Collectors.toList()) : null;
                List brandNames = CollectionUtil.isNotEmpty(commerceCapacity.getHotSaleBrandInfo()) ? commerceCapacity.getHotSaleBrandInfo().stream().map(KsTopManDetailBaseEntity.HotSaleBrandInfo::getHotSaleBrandTitle).collect(Collectors.toList()) : null;
                keyData.setHotSaleChannelInfo(CollectionUtil.isNotEmpty(channelNames) ? StrUtil.join((CharSequence)"\u3001", channelNames) : "-");
                keyData.setHotSaleBrandInfo(CollectionUtil.isNotEmpty(brandNames) ? StrUtil.join((CharSequence)"\u3001", brandNames) : "-");
                KsTopManDetailHeadVO.StarProfileDict starProfileDict = detailHead.getStarProfileDict();
                if (starProfileDict != null) {
                    keyData.setHeadUrl(starProfileDict.getHeadUrl());
                    keyData.setName(starProfileDict.getName());
                }
                if ((coreData = detailHead.getCoreData()) != null) {
                    keyData.setPromoteItemCount(coreData.getPromoteItemCount());
                }
            }
            goodsDatas.add(keyData);
        }
        vo.setGoodsDatas(goodsDatas);
    }

    private void getKsFansData(List<TopManContrastParamDTO> paramList, String clearCache, KsTopManContrastVO vo) {
        ArrayList<KsTopManDetailFansEntity> fansDatas = new ArrayList<KsTopManDetailFansEntity>(paramList.size());
        paramList.forEach(h -> {
            KsTopManDetailDTO ksDTO = this.ksDtoTransfer((TopManContrastParamDTO)h);
            ksDTO.setClearCache(clearCache);
            KsTopManDetailHeadVO detailHead = this.getKsHeadData(ksDTO);
            KsTopManDetailFansEntity fansData = this.kuaiShouTopManInformationService.getDetailBodyFans(ksDTO);
            if (fansData != null) {
                KsTopManDetailHeadVO.StarProfileDict starProfileDict = detailHead.getStarProfileDict();
                if (starProfileDict != null) {
                    fansData.setHeadUrl(starProfileDict.getHeadUrl());
                    fansData.setName(starProfileDict.getName());
                }
                fansDatas.add(fansData);
            }
        });
        vo.setFansDatas(fansDatas);
    }

    private void getKsLiveData(List<TopManContrastParamDTO> paramList, String clearCache, KsTopManContrastVO vo) {
        ArrayList<KsTopManDetailHeadVO.LiveResponse> liveDatas = new ArrayList<KsTopManDetailHeadVO.LiveResponse>(paramList.size());
        paramList.forEach(h -> {
            KsTopManDetailDTO ksDTO = this.ksDtoTransfer((TopManContrastParamDTO)h);
            ksDTO.setClearCache(clearCache);
            KsTopManDetailHeadVO detailHead = this.kuaiShouTopManInformationService.getDetailHead(ksDTO);
            if (detailHead != null && detailHead.getLiveResponse() != null) {
                liveDatas.add(detailHead.getLiveResponse());
            }
        });
        vo.setLiveDatas(liveDatas);
    }

    private void getKsVideoData(List<TopManContrastParamDTO> paramList, String clearCache, KsTopManContrastVO vo) {
        ArrayList<KsTopManDetailHeadVO.VideoResponse> videoDatas = new ArrayList<KsTopManDetailHeadVO.VideoResponse>(paramList.size());
        ArrayList<KsTopManDetailHeadVO.LiveResponse> liveDatas = new ArrayList<KsTopManDetailHeadVO.LiveResponse>(paramList.size());
        paramList.forEach(h -> {
            KsTopManDetailHeadVO.StarProfileDict starProfileDict;
            KsTopManDetailDTO ksDTO = this.ksDtoTransfer((TopManContrastParamDTO)h);
            ksDTO.setClearCache(clearCache);
            KsTopManDetailHeadVO detailHead = this.getKsHeadData(ksDTO);
            KsTopManDetailVideoAnalysisEntity videoDataNew = this.kuaiShouTopManInformationService.getDetailBodyVideoNew(ksDTO);
            if (videoDataNew != null) {
                KsTopManDetailHeadVO.VideoResponse videoResponse = detailHead.getVideoResponse();
                starProfileDict = detailHead.getStarProfileDict();
                KsTopManDetailVideoAnalysisEntity.StarWorkReport starWorkReport = videoDataNew.getStarWorkReport();
                if (videoResponse != null && starProfileDict != null) {
                    videoResponse.setExpectedCpe(starProfileDict.getExpectedCpe());
                    videoResponse.setHeadUrl(starProfileDict.getHeadUrl());
                    videoResponse.setName(starProfileDict.getName());
                }
                if (videoResponse != null && starWorkReport != null) {
                    videoResponse.setPphotoCntData(starWorkReport.getPphotoCntData().get("30"));
                    videoResponse.setPplayMedianData(starWorkReport.getPplayMedianData().get("30"));
                    videoResponse.setPcompletePlayRateData(starWorkReport.getPcompletePlayRateData().get("30"));
                    videoResponse.setPhotoInteractionRateData(starWorkReport.getPhotoInteractionRateData().get("30"));
                }
                videoDatas.add(videoResponse);
            }
            KsTopManDetailHeadVO.LiveResponse liveResponse = detailHead.getLiveResponse();
            starProfileDict = detailHead.getStarProfileDict();
            if (liveResponse != null && starProfileDict != null) {
                liveResponse.setHeadUrl(starProfileDict.getHeadUrl());
                liveResponse.setName(starProfileDict.getName());
            }
            liveDatas.add(detailHead.getLiveResponse());
        });
        vo.setVideoDatas(videoDatas);
        vo.setLiveDatas(liveDatas);
    }

    private void getKsBaseData(List<TopManContrastParamDTO> paramList, String clearCache, KsTopManContrastVO vo) {
        ArrayList<KsTopManDetailHeadVO.StarProfileDict> baseDatas = new ArrayList<KsTopManDetailHeadVO.StarProfileDict>(paramList.size());
        paramList.forEach(h -> {
            KsTopManDetailDTO ksDTO = this.ksDtoTransfer((TopManContrastParamDTO)h);
            ksDTO.setClearCache(clearCache);
            KsTopManDetailHeadVO detailHead = this.getKsHeadData(ksDTO);
            KsTopManDetailHeadVO.StarProfileDict starProfileDict = detailHead.getStarProfileDict();
            if (starProfileDict != null) {
                if ("1".equals(h.getLiveStatus())) {
                    String perHour = starProfileDict.getLiveQuotedInfo() != null ? starProfileDict.getLiveQuotedInfo().getPerHour().divide(new BigDecimal(1000), 4).toPlainString() : "-";
                    starProfileDict.setPromotionPrice("\u76f4\u64ad\u62a5\u4ef7\uff1a\uffe5" + perHour + "/\u5c0f\u65f6");
                } else {
                    String perHour = starProfileDict.getOrderBid() != null ? starProfileDict.getOrderBid().divide(new BigDecimal(1000), 4).toPlainString() : "-";
                    starProfileDict.setPromotionPrice("\u89c6\u9891\u62a5\u4ef7\uff1a\uffe5" + perHour + "/\u4e2a");
                }
                if (starProfileDict.getHidePrice().booleanValue()) {
                    starProfileDict.setPromotionPrice("\u6309\u534f\u8bae\u4ef7");
                }
            }
            baseDatas.add(starProfileDict);
        });
        vo.setBaseDatas(baseDatas);
    }

    private KsTopManDetailHeadVO getKsHeadData(KsTopManDetailDTO ksDTO) {
        KsTopManDetailHeadVO detailHead = this.kuaiShouTopManInformationService.getDetailHead(ksDTO);
        if (detailHead != null) {
            return detailHead;
        }
        return new KsTopManDetailHeadVO();
    }

    @Override
    public TopManContrastVO rbTopManContrast(TopManContrastDTO dto) {
        RbTopManContrastVO vo = new RbTopManContrastVO();
        List<TopManContrastParamDTO> paramList = this.contrastDtoTransfer(dto);
        switch (dto.getTaskType()) {
            case "baseData": {
                ArrayList<RedBookTopManDetailHeadVO.DetailHead> baseDatas = new ArrayList<RedBookTopManDetailHeadVO.DetailHead>(dto.getParamList().size());
                ArrayList<RedBookTopManDetailHeadVO.NotesData> noteDatas = new ArrayList<RedBookTopManDetailHeadVO.NotesData>(dto.getParamList().size());
                ArrayList<RedBookTopManDetailHeadVO.LivesData> liveDatas = new ArrayList<RedBookTopManDetailHeadVO.LivesData>(dto.getParamList().size());
                paramList.forEach(h -> {
                    RedBookTopManDetailDTO rbDTO = this.rbDtoTransfer((TopManContrastParamDTO)h);
                    rbDTO.setClearCache(dto.getClearCache());
                    RedBookTopManDetailHeadVO detailHead = this.redBookTopManInformationService.getDetailHead(rbDTO);
                    if (detailHead != null) {
                        RedBookTopManDetailHeadVO.DetailHead baseData = detailHead.getDetailHead();
                        RedBookTopManDetailHeadVO detailPromotion = this.redBookTopManInformationService.getDetailPromotion(rbDTO);
                        if (baseData != null && detailPromotion != null) {
                            RedBookTopManDetailHeadVO.Promotion promotion = detailPromotion.getPromotion();
                            baseData.setMcnName(baseData.getNoteSign() != null ? baseData.getNoteSign().getName() : "");
                            String picturePrice = StrUtil.format((CharSequence)"\u56fe\u6587\u7b14\u8bb0\uff1a{}\uff0c", (Object[])new Object[]{promotion.getPicturePrice() != null ? "\uffe5" + promotion.getPicturePrice() : "-"});
                            String videoPrice = StrUtil.format((CharSequence)"\u89c6\u9891\u7b14\u8bb0\uff1a{}", (Object[])new Object[]{promotion.getVideoPrice() != null ? "\uffe5" + promotion.getVideoPrice() : "-"});
                            baseData.setPromotionPrice(picturePrice + videoPrice);
                            String pictureReadCost = StrUtil.format((CharSequence)"\u56fe\u6587\u7b14\u8bb0\uff1a{}\uff0c", (Object[])new Object[]{promotion.getPictureReadCost() != null ? StrUtil.format((CharSequence)"\uffe5{}/\u9605\u8bfb", (Object[])new Object[]{promotion.getPictureReadCost()}) : "-"});
                            String videoReadCost = StrUtil.format((CharSequence)"\u89c6\u9891\u7b14\u8bb0\uff1a{}", (Object[])new Object[]{promotion.getVideoReadCost() != null ? StrUtil.format((CharSequence)"\uffe5{}/\u9605\u8bfb", (Object[])new Object[]{promotion.getVideoReadCost()}) : "-"});
                            baseData.setPictureReadPrice(pictureReadCost + videoReadCost);
                        }
                        baseDatas.add(baseData);
                        RedBookTopManDetailHeadVO.NotesData notesData = detailHead.getNotesData();
                        RedBookTopManDetailHeadVO.CoreData coreData = detailHead.getCoreData();
                        if (notesData != null && coreData != null) {
                            notesData.setTotalNoteCount(coreData.getTotalNoteCount());
                            notesData.setLikeCollectCountInfo(coreData.getLikeCollectCountInfo());
                        }
                        noteDatas.add(notesData);
                        RedBookTopManDetailHeadVO.LivesData livesData = detailHead.getLivesData();
                        liveDatas.add(livesData);
                    }
                });
                vo.setBaseDatas(baseDatas);
                vo.setNoteDatas(noteDatas);
                vo.setLiveDatas(liveDatas);
                break;
            }
            case "fansData": {
                ArrayList<RedBookTopManDetailHeadVO.FansData> fansDatas = new ArrayList<RedBookTopManDetailHeadVO.FansData>(dto.getParamList().size());
                paramList.forEach(h -> {
                    RedBookTopManDetailDTO rbDTO = this.rbDtoTransfer((TopManContrastParamDTO)h);
                    rbDTO.setClearCache(dto.getClearCache());
                    RedBookTopManDetailHeadVO fansData = this.redBookTopManInformationService.getDetailFans(rbDTO);
                    if (fansData != null) {
                        fansDatas.add(fansData.getFansData());
                    }
                });
                vo.setFansDatas(fansDatas);
                break;
            }
            case "goodsData": {
                ArrayList<RedBookTopManDetailHeadVO.Sales> goodsDatas = new ArrayList<RedBookTopManDetailHeadVO.Sales>(dto.getParamList().size());
                paramList.forEach(h -> {
                    RedBookTopManDetailDTO rbDTO = this.rbDtoTransfer((TopManContrastParamDTO)h);
                    rbDTO.setClearCache(dto.getClearCache());
                    RedBookTopManDetailHeadVO goodsData = this.redBookTopManInformationService.getDetailLiveSales(rbDTO);
                    if (goodsData != null && goodsData.getSales() != null) {
                        RedBookTopManDetailHeadVO.Sales sales = goodsData.getSales();
                        List<RedBookTopManDetailHeadVO.Sales.Category> rgmvCategorys = sales.getRgmvCategory();
                        if (CollectionUtil.isNotEmpty(rgmvCategorys)) {
                            rgmvCategorys = rgmvCategorys.size() > 3 ? rgmvCategorys.subList(0, 3) : rgmvCategorys;
                            List categoryNames = rgmvCategorys.stream().map(RedBookTopManDetailHeadVO.Sales.Category::getCategoryName).collect(Collectors.toList());
                            sales.setCategories(StrUtil.join((CharSequence)"\u3001", categoryNames));
                        }
                        goodsDatas.add(sales);
                    }
                });
                vo.setGoodsDatas(goodsDatas);
                break;
            }
            default: {
                throw new ELSBootException(I18nUtil.translate((String)"", (String)"\u672a\u627e\u5230\u8be5\u8bf7\u6c42\u7c7b\u578b"));
            }
        }
        return vo;
    }

    @Override
    public TopManContrastVO biliTopManContrast(TopManContrastDTO dto) {
        BiliTopManContrastVO vo = new BiliTopManContrastVO();
        List<TopManContrastParamDTO> paramList = this.contrastDtoTransfer(dto);
        switch (dto.getTaskType()) {
            case "baseData": {
                ArrayList<BStationTopManInformationTopDetailsEntity.TopManInfo> baseDatas = new ArrayList<BStationTopManInformationTopDetailsEntity.TopManInfo>(dto.getParamList().size());
                ArrayList<BStationTopManInformationTopDetailsEntity.TopManVideoData> videoDatas = new ArrayList<BStationTopManInformationTopDetailsEntity.TopManVideoData>(dto.getParamList().size());
                ArrayList<BStationTopManInformationTopDetailsEntity.TopManLiveData> liveDatas = new ArrayList<BStationTopManInformationTopDetailsEntity.TopManLiveData>(dto.getParamList().size());
                paramList.forEach(h -> {
                    BStationTopManInformationTopDetailsEntity baseData = this.bStationTopManInformationService.bStationTopManDetails(h.getStationId(), h.getTopManId());
                    if (baseData != null) {
                        BStationTopManInformationTopDetailsEntity.TopManInfo topManInfo = baseData.getTopManInfo();
                        List<BStationTopManInformationPromotionAnalysisEntity> promotions = this.bStationTopManInformationService.bStationTopManPromotionAnalysisDetails(h.getStationId(), h.getTopManId());
                        if (topManInfo != null && CollectionUtil.isNotEmpty(promotions)) {
                            ArrayList prices = new ArrayList(promotions.size());
                            promotions.forEach(j -> prices.add(StrUtil.format((CharSequence)"{}\uff1a\uffe5{}", (Object[])new Object[]{j.getQuotationType(), j.getPrice()})));
                            String promotionPrice = StrUtil.join((CharSequence)"\uff0c", prices);
                            topManInfo.setPromotionPrice(promotionPrice);
                        }
                        baseDatas.add(topManInfo);
                        BStationTopManInformationTopDetailsEntity.TopManVideoData topManVideoData = baseData.getTopManVideoData();
                        BStationTopManInformationTopDetailsEntity.TopManCoreData topManCoreData = baseData.getTopManCoreData();
                        if (topManVideoData != null && topManCoreData != null) {
                            topManVideoData.setVideoNum(topManCoreData.getVideoNum());
                            topManVideoData.setLikeNum(topManCoreData.getLikeNum());
                            topManVideoData.setPlayNum(topManCoreData.getPlayNum());
                        }
                        videoDatas.add(topManVideoData);
                        liveDatas.add(baseData.getTopManLiveData());
                    }
                });
                vo.setBaseDatas(baseDatas);
                vo.setVideoDatas(videoDatas);
                vo.setLiveDatas(liveDatas);
                break;
            }
            case "fansData": {
                ArrayList<BStationTopManInformationFanAnalysisEntity> fansDatas = new ArrayList<BStationTopManInformationFanAnalysisEntity>(dto.getParamList().size());
                paramList.forEach(h -> {
                    BStationTopManInformationFanAnalysisEntity fansData = this.bStationTopManInformationService.bStationTopManFanAnalysisDetails(h.getStationId(), h.getTopManId());
                    if (fansData != null) {
                        fansDatas.add(fansData);
                    }
                });
                vo.setFansDatas(fansDatas);
                break;
            }
            default: {
                throw new ELSBootException(I18nUtil.translate((String)"", (String)"\u672a\u627e\u5230\u8be5\u8bf7\u6c42\u7c7b\u578b"));
            }
        }
        return vo;
    }

    @Override
    public TopManContrastVO blogTopManContrast(TopManContrastDTO dto) {
        BlogTopManContrastVO vo = new BlogTopManContrastVO();
        List<TopManContrastParamDTO> paramList = this.contrastDtoTransfer(dto);
        switch (dto.getTaskType()) {
            case "baseData": {
                ArrayList<BlogTopManInformationTopDetailsEntity.TopManInfo> baseDatas = new ArrayList<BlogTopManInformationTopDetailsEntity.TopManInfo>(dto.getParamList().size());
                ArrayList<BlogTopManInformationTopDetailsEntity.TopManCoreData> coreDatas = new ArrayList<BlogTopManInformationTopDetailsEntity.TopManCoreData>(dto.getParamList().size());
                paramList.forEach(h -> {
                    BlogTopManInformationTopDetailsEntity baseData = this.blogTopManInformationService.blogTopManDetails(h.getTopManId());
                    if (baseData != null) {
                        BlogTopManInformationTopDetailsEntity.TopManInfo topManInfo = baseData.getTopManInfo();
                        BlogTopManInformationPromotionAnalysisEntity promotion = this.blogTopManInformationService.blogTopManInformationPromotionAnalysis(h.getTopManId());
                        if (topManInfo != null && promotion != null && CollectionUtil.isNotEmpty(promotion.getPrice())) {
                            ArrayList prices = new ArrayList(promotion.getPrice().size());
                            promotion.getPrice().forEach(j -> prices.add(StrUtil.format((CharSequence)"{}\uff1a\uffe5{}", (Object[])new Object[]{j.getPriceType(), j.getPrice()})));
                            String promotionPrice = StrUtil.join((CharSequence)"\uff0c", prices);
                            topManInfo.setPromotionPrice(promotionPrice);
                            topManInfo.setTopmanGender(BlogTopmanGenderEnum.getDesc(topManInfo.getTopmanGender()));
                            topManInfo.setVerifiedType(BlogVerifiedTypeEnum.getDesc(topManInfo.getVerifiedTypeExt()));
                        }
                        baseDatas.add(baseData.getTopManInfo());
                        coreDatas.add(baseData.getTopManCoreData());
                    }
                });
                vo.setBaseDatas(baseDatas);
                vo.setCoreDatas(coreDatas);
                break;
            }
            case "fansData": {
                ArrayList<BlogTopManInformationFanAnalysisEntity> fansDatas = new ArrayList<BlogTopManInformationFanAnalysisEntity>(dto.getParamList().size());
                paramList.forEach(h -> {
                    BlogTopManInformationFanAnalysisEntity fansData = this.blogTopManInformationService.blogTopManFanAnalysisDetails(h.getTopManId());
                    if (fansData != null) {
                        fansDatas.add(fansData);
                    }
                });
                vo.setFansDatas(fansDatas);
                break;
            }
            default: {
                throw new ELSBootException(I18nUtil.translate((String)"", (String)"\u672a\u627e\u5230\u8be5\u8bf7\u6c42\u7c7b\u578b"));
            }
        }
        return vo;
    }

    @Override
    public TopManContrastVO zhTopManContrast(TopManContrastDTO dto) {
        ZhTopManContrastVO vo = new ZhTopManContrastVO();
        List<TopManContrastParamDTO> paramList = this.contrastDtoTransfer(dto);
        ArrayList<ZhuHuManDetailHeadVO.DetailHead> baseDatas = new ArrayList<ZhuHuManDetailHeadVO.DetailHead>(dto.getParamList().size());
        ArrayList<ZhuHuManDetailHeadVO.CoreData> coreDatas = new ArrayList<ZhuHuManDetailHeadVO.CoreData>(dto.getParamList().size());
        ArrayList<ZhuHuManDetailHeadVO.FansData> fansDatas = new ArrayList<ZhuHuManDetailHeadVO.FansData>(dto.getParamList().size());
        paramList.forEach(h -> {
            ZhiHuTopManDetailDTO zhDTO = this.zhDtoTransfer((TopManContrastParamDTO)h);
            zhDTO.setClearCache(dto.getClearCache());
            ZhuHuManDetailHeadVO detailHead = this.zhiHuTopManInformationService.getDetailHead(zhDTO);
            if (detailHead != null) {
                ZhuHuManDetailHeadVO.DetailHead baseData = detailHead.getDetailHead();
                ZhuHuManDetailHeadVO.PromotionData promotionData = detailHead.getPromotionData();
                if (baseData != null) {
                    baseData.setMcnName(baseData.getMcn() != null ? baseData.getMcn().getName() : "");
                    baseData.setBadgesName(CollectionUtil.isNotEmpty(baseData.getBadges()) ? baseData.getBadges().get(0).getTopics() : null);
                    String promotionPrice = this.getZhPromotionPrice(promotionData);
                    baseData.setPromotionPrice(promotionPrice);
                }
                baseDatas.add(baseData);
                ZhuHuManDetailHeadVO.CoreData coreData = detailHead.getCoreData();
                coreDatas.add(coreData);
                ZhuHuManDetailHeadVO.FansData fansData = detailHead.getFansData();
                fansDatas.add(fansData);
            }
        });
        vo.setBaseDatas(baseDatas);
        vo.setCoreDatas(coreDatas);
        vo.setFansDatas(fansDatas);
        return vo;
    }

    private String getZhPromotionPrice(ZhuHuManDetailHeadVO.PromotionData promotionData) {
        if (promotionData == null) {
            return "";
        }
        List<ZhuHuManDetailHeadVO.PromotionData.Offer> offers = promotionData.getOffer();
        if (CollectionUtil.isEmpty(offers)) {
            return "";
        }
        ZhuHuManDetailHeadVO.PromotionData.Offer offer = offers.get(0);
        return offer.getOrderPrice() != null ? StrUtil.format((CharSequence)"\u56de\u7b54&\u6587\u7ae0\uff1a\uffe5{}", (Object[])new Object[]{offer.getOrderPrice()}) : "";
    }

    private List<TopManContrastParamDTO> contrastDtoTransfer(TopManContrastDTO dto) {
        if (dto == null || CollectionUtil.isEmpty(dto.getParamList())) {
            throw new RuntimeException(I18nUtil.translate((String)"", (String)"\u53c2\u6570\u9519\u8bef"));
        }
        List<TopManContrastParamDTO> paramList = dto.getParamList();
        if (paramList.size() > 3) {
            paramList = paramList.subList(0, 3);
        }
        return paramList;
    }
}

