/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.industryinfo.job;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.els.common.api.service.JobRpcService;
import com.els.modules.industryinfo.entity.KsSpiderTopMan;
import com.els.modules.industryinfo.job.utils.DataFormatUtils;
import com.els.modules.industryinfo.service.KsSpiderTopManService;
import com.els.modules.industryinfo.service.KuaiShouTopManInformationService;
import com.mongodb.client.MongoCursor;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.bson.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.stereotype.Component;

@Component
@EnableScheduling
public class KsTopManJob
implements JobRpcService {
    private static final Logger log = LoggerFactory.getLogger(KsTopManJob.class);
    @Resource
    private MongoTemplate mongoTemplate;
    @Autowired
    private KsSpiderTopManService ksSpiderTopManService;
    @Autowired
    private KuaiShouTopManInformationService ksTopManInformationService;

    public void execute(String parameter) {
        log.info("------------start KsTopManJob-----------");
        int i = 0;
        try (MongoCursor cursor = this.mongoTemplate.getCollection("tb_kuaishou_els_topman_listDetail").find().noCursorTimeout(true).batchSize(500).cursor();){
            log.info("------------start TopManJob cursor -----------1");
            ArrayList<KsSpiderTopMan> updateList = new ArrayList<KsSpiderTopMan>(1000);
            ArrayList<KsSpiderTopMan> insertList = new ArrayList<KsSpiderTopMan>(1000);
            while (cursor.hasNext()) {
                Document doc = (Document)cursor.next();
                try {
                    QueryWrapper queryWrapper = new QueryWrapper();
                    String userId = DataFormatUtils.documentToString(doc.get((Object)"userId"));
                    ((LambdaQueryWrapper)queryWrapper.lambda().eq(KsSpiderTopMan::getTopmanId, (Object)userId)).eq(KsSpiderTopMan::getPlatform, (Object)"2");
                    KsSpiderTopMan one = (KsSpiderTopMan)((Object)this.ksSpiderTopManService.getOne((Wrapper)queryWrapper));
                    if (one == null) {
                        one = new KsSpiderTopMan();
                        this.getSpiderMarkEntity(doc, one);
                        insertList.add(one);
                        if (insertList.size() != 1000 && cursor.hasNext()) continue;
                        this.ksSpiderTopManService.insertBatch(insertList);
                        insertList = new ArrayList(1000);
                        continue;
                    }
                    this.getSpiderMarkEntity(doc, one);
                    updateList.add(one);
                    if (updateList.size() != 1000 && cursor.hasNext()) continue;
                    this.ksSpiderTopManService.updateBatch(updateList);
                    updateList = new ArrayList(1000);
                }
                catch (Exception e) {
                    log.error("doc error {}", (Object)doc);
                    log.error("genTopMan error ", (Throwable)e);
                }
            }
            log.info("------------start KsTopManJob cursor -----------" + ++i);
        }
        catch (Exception e) {
            log.error("mongodb error", (Throwable)e);
        }
    }

    private void getSpiderMarkEntity(Document doc, KsSpiderTopMan ksSpiderTopMan) {
        if (ksSpiderTopMan.getId() == null) {
            ksSpiderTopMan.setId(String.valueOf(doc.get((Object)"_id")));
        }
        ksSpiderTopMan.setTopmanId(DataFormatUtils.numberToString(doc.get((Object)"userId")));
        ksSpiderTopMan.setTopmanName(doc.getString((Object)"name"));
        ksSpiderTopMan.setKwaiid(doc.getString((Object)"kwaiId"));
        ksSpiderTopMan.setStarId(DataFormatUtils.numberToString(doc.get((Object)"starId")));
        ksSpiderTopMan.setPlatform("2");
        ksSpiderTopMan.setTopmanAvatar(doc.getString((Object)"headUrl"));
        ksSpiderTopMan.setTopmanSource("1");
        ksSpiderTopMan.setLiveStatus(DataFormatUtils.numberToString(doc.get((Object)"liveStatus")));
        ksSpiderTopMan.setTopmanSex(doc.getString((Object)"gender"));
        ksSpiderTopMan.setProvinceCode(doc.getDouble((Object)"provinceCode").intValue());
        ksSpiderTopMan.setCityCode(doc.getDouble((Object)"cityCode").intValue());
        ksSpiderTopMan.setRegion(this.ksTopManInformationService.formatRegion(ksSpiderTopMan.getProvinceCode(), ksSpiderTopMan.getCityCode()));
        ksSpiderTopMan.setContentTypeName(doc.getString((Object)"starTagStr"));
        ksSpiderTopMan.setContentFormName(doc.getString((Object)"mmuStarTagStr"));
        ksSpiderTopMan.setIndustryName(doc.getString((Object)"industryTagStr"));
        List starTagIdsList = doc.getList((Object)"starTagIds", Object.class);
        if (starTagIdsList != null && starTagIdsList.size() > 0) {
            String starTagIds = starTagIdsList.stream().map(String::valueOf).collect(Collectors.joining());
            ksSpiderTopMan.setStarTagIds(starTagIds);
        }
        ksSpiderTopMan.setFansNum(DataFormatUtils.numberToBigDecimal(doc.get((Object)"fansNum")));
        ksSpiderTopMan.setFansIncreaseNum(DataFormatUtils.numberToBigDecimal(doc.get((Object)"fansIncreaseNum")));
        ksSpiderTopMan.setFansIncreaseRate(DataFormatUtils.numberToBigDecimal(doc.get((Object)"fansIncreaseRate")));
        ksSpiderTopMan.setLiveExpectCpm(DataFormatUtils.numberToBigDecimal(doc.get((Object)"liveExpectCpm")));
        ksSpiderTopMan.setLiveExpectViewer(DataFormatUtils.numberToBigDecimal(doc.get((Object)"liveExpectViewer")));
        ksSpiderTopMan.setLiveMaxViewer(DataFormatUtils.numberToBigDecimal(doc.get((Object)"liveMaxViewer")));
        ksSpiderTopMan.setPhotoExpectClick(DataFormatUtils.numberToBigDecimal(doc.get((Object)"photoExpectClick")));
        ksSpiderTopMan.setPhotoCompletePlayRate(DataFormatUtils.numberToBigDecimal(doc.get((Object)"photoCompletePlayRate")));
        ksSpiderTopMan.setPhotoExpectCpm(DataFormatUtils.numberToBigDecimal(doc.get((Object)"photoExpectCpm")));
        ksSpiderTopMan.setPhotoInteractionRate(DataFormatUtils.numberToBigDecimal(doc.get((Object)"photoInteractionRate")));
        Document liveQuotedInfo = (Document)doc.get((Object)"liveQuotedInfo", Document.class);
        ksSpiderTopMan.setQuoteOfLive(DataFormatUtils.numberToBigDecimal(liveQuotedInfo.get((Object)"perHour")));
        ksSpiderTopMan.setQuoteOfVideo(DataFormatUtils.numberToBigDecimal(doc.get((Object)"threeDaysOrderBid")));
        if (ksSpiderTopMan.getId() == null) {
            ksSpiderTopMan.setCreateTime(new Date());
            ksSpiderTopMan.setCreateBy("KsTopManJob");
        }
        ksSpiderTopMan.setUpdateBy("KsTopManJob");
        ksSpiderTopMan.setUpdateTime(new Date());
        ksSpiderTopMan.setDeleted(0);
    }
}

