/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.job;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.els.common.api.service.JobRpcService;
import com.els.modules.job.utils.DataFormatUtils;
import com.els.modules.topman.entity.DyTopManInformationHead;
import com.els.modules.topman.service.DyTopManInformationHeadService;
import com.els.modules.topman.service.TopManInformationService;
import com.els.modules.topman.utils.spider.entity.DyTopManInfoEntity;
import com.mongodb.client.MongoCursor;
import java.util.ArrayList;
import java.util.Date;
import javax.annotation.Resource;
import org.bson.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.stereotype.Component;

@Component
@EnableScheduling
public class DyTopManJob
implements JobRpcService {
    private static final Logger log = LoggerFactory.getLogger(DyTopManJob.class);
    @Resource
    private MongoTemplate mongoTemplate;
    @Resource
    private DyTopManInformationHeadService dyTopManInformationHeadService;
    @Resource
    public TopManInformationService topManInformationService;

    public void execute(String parameter) {
        log.info("------------start DyTopManJob-----------");
        int i = 0;
        try (MongoCursor cursor = this.mongoTemplate.getCollection("tb_douyin_els_topman_listDetail").find().noCursorTimeout(true).batchSize(500).cursor();){
            log.info("------------start TopManJob cursor -----------1");
            ArrayList<DyTopManInformationHead> updateList = new ArrayList<DyTopManInformationHead>(1000);
            ArrayList<DyTopManInformationHead> insertList = new ArrayList<DyTopManInformationHead>(1000);
            while (cursor.hasNext()) {
                Document doc = (Document)cursor.next();
                try {
                    QueryWrapper queryWrapper = new QueryWrapper();
                    String userId = DataFormatUtils.documentToString(doc.get((Object)"userId"));
                    ((LambdaQueryWrapper)queryWrapper.lambda().eq(DyTopManInformationHead::getTopmanId, (Object)userId)).eq(DyTopManInformationHead::getPlatform, (Object)"1");
                    DyTopManInformationHead one = (DyTopManInformationHead)((Object)this.dyTopManInformationHeadService.getOne((Wrapper)queryWrapper));
                    if (one == null) {
                        one = new DyTopManInformationHead();
                        this.getSpiderMarkEntity(doc, one);
                        insertList.add(one);
                        if (insertList.size() != 1000 && cursor.hasNext()) continue;
                        this.dyTopManInformationHeadService.insertBatch(insertList);
                        insertList = new ArrayList(1000);
                        continue;
                    }
                    this.getSpiderMarkEntity(doc, one);
                    updateList.add(one);
                    if (updateList.size() != 1000 && cursor.hasNext()) continue;
                    this.dyTopManInformationHeadService.updateBatch(updateList);
                    updateList = new ArrayList(1000);
                }
                catch (Exception e) {
                    log.error("doc error {}", (Object)doc);
                    log.error("genTopMan error ", (Throwable)e);
                }
            }
            log.info("------------start DyTopManJob cursor -----------" + ++i);
        }
        catch (Exception e) {
            log.error("mongodb error", (Throwable)e);
        }
    }

    private void getSpiderMarkEntity(Document doc, DyTopManInformationHead dyTopManInformationHead) {
        if (dyTopManInformationHead.getId() == null) {
            dyTopManInformationHead.setId(String.valueOf(doc.get((Object)"_id")));
        }
        DyTopManInfoEntity dyTopManInfoEntity = (DyTopManInfoEntity)JSON.parseObject((String)doc.toJson(), DyTopManInfoEntity.class);
        this.topManInformationService.transferBean(dyTopManInfoEntity, dyTopManInformationHead);
        if (dyTopManInformationHead.getId() == null) {
            dyTopManInformationHead.setCreateTime(new Date());
            dyTopManInformationHead.setCreateBy("DyTopManJob");
        }
        dyTopManInformationHead.setUpdateBy("DyTopManJob");
        dyTopManInformationHead.setUpdateTime(new Date());
        dyTopManInformationHead.setDeleted(0);
    }
}

