/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.member.service.impl;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.http.HtmlUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.I18nUtil;
import com.els.config.StaticConfig;
import com.els.config.mybatis.TenantContext;
import com.els.modules.integration.service.SrmToIPaasService;
import com.els.modules.member.entity.MemberMeal;
import com.els.modules.member.entity.MemberOrder;
import com.els.modules.member.enumerate.MealTypeEnum;
import com.els.modules.member.enumerate.OrderStatusEnum;
import com.els.modules.member.mapper.MemberOrderMapper;
import com.els.modules.member.service.MemberMealService;
import com.els.modules.member.service.MemberOrderService;
import com.els.modules.member.vo.OrderPayResultVo;
import com.els.modules.system.service.CodeGeneratorService;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class MemberOrderServiceImpl
extends BaseServiceImpl<MemberOrderMapper, MemberOrder>
implements MemberOrderService {
    private static final Logger log = LoggerFactory.getLogger(MemberOrderServiceImpl.class);
    @Autowired
    private CodeGeneratorService codeGeneratorService;
    @Autowired
    private StaticConfig staticConfig;
    @Autowired
    private SrmToIPaasService srmToIPaasService;
    @Autowired
    @Lazy
    private MemberMealService memberMealService;

    @Override
    public void add(MemberOrder memberOrder) {
        ((MemberOrderMapper)this.baseMapper).insert((Object)memberOrder);
    }

    @Override
    public void edit(MemberOrder memberOrder) {
        int count = ((MemberOrderMapper)this.baseMapper).updateById((Object)memberOrder);
        Assert.isTrue((count != 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
    }

    @Override
    public void delete(String id) {
        ((MemberOrderMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    public void deleteBatch(List<String> idList) {
        ((MemberOrderMapper)this.baseMapper).deleteBatchIds(idList);
    }

    @Override
    @SrmTransaction(rollbackFor={Exception.class})
    public OrderPayResultVo createOrder(MemberOrder memberOrder) {
        MemberMeal meal = (MemberMeal)((Object)this.memberMealService.getById((Serializable)((Object)memberOrder.getMealId())));
        Assert.isTrue((boolean)ObjectUtil.isNotEmpty((Object)((Object)meal)), (String)"\u5957\u9910\u5f02\u5e38");
        Assert.isTrue((boolean)ObjectUtil.isNotEmpty((Object)memberOrder.getMealType()), (String)"\u5957\u9910\u7c7b\u578b\u5f02\u5e38");
        String mealTypeDesc = MealTypeEnum.getDescByCode(memberOrder.getMealType());
        Assert.isTrue((boolean)StrUtil.isNotBlank((CharSequence)mealTypeDesc), (String)"\u5957\u9910\u7c7b\u578b\u5f02\u5e38");
        if (memberOrder.getMealType().equals(MealTypeEnum.MEMBER_UPGRADE_RENEWAL.getCode())) {
            memberOrder.setProductName(meal.getProductName() + "_" + "_1\u5e74");
            memberOrder.setPayAmt(meal.getProductAmt().stripTrailingZeros());
            memberOrder.setProductAmt(memberOrder.getPayAmt());
        } else {
            Assert.isTrue((boolean)ObjectUtil.isNotEmpty((Object)memberOrder.getOrderNum()), (String)"\u5957\u9910\u6570\u91cf\u5f02\u5e38");
            memberOrder.setProductName(mealTypeDesc + "_" + memberOrder.getOrderNum() + "\u4e2a");
            BigDecimal amt = BigDecimal.ZERO;
            if (memberOrder.getMealType().equals(MealTypeEnum.ADD_SHOPS.getCode())) {
                amt = meal.getAddShopAmt().multiply(new BigDecimal(memberOrder.getOrderNum())).stripTrailingZeros();
            }
            if (memberOrder.getMealType().equals(MealTypeEnum.ADD_SUB_ACCOUNT.getCode())) {
                amt = meal.getAddAccountAmt().multiply(new BigDecimal(memberOrder.getOrderNum())).stripTrailingZeros();
            }
            memberOrder.setProductAmt(amt);
            memberOrder.setPayAmt(amt);
        }
        String elsAccount = TenantContext.getTenant();
        memberOrder.setToElsAccount(elsAccount);
        memberOrder.setToElsAccountName(((MemberOrderMapper)this.baseMapper).getCompanyNameByElsAccount(elsAccount));
        memberOrder.setOrderNo(this.codeGeneratorService.getNextCode("MemberOrderNo", (Object)memberOrder));
        memberOrder.setOrderStatus(OrderStatusEnum.NEWLY_BUILD.getCode());
        memberOrder.setExpirTime((Date)DateUtil.offsetMinute((Date)new Date(), (int)10));
        this.save((Object)memberOrder);
        return new OrderPayResultVo(memberOrder.getId(), this.callIpassPay(memberOrder));
    }

    @Override
    public List<MemberOrder> getOrderByElsAccount(String elsAccount) {
        return this.list((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(MemberOrder::getToElsAccount, (Object)elsAccount)).eq(MemberOrder::getOrderStatus, (Object)OrderStatusEnum.COMPLETED.getCode()));
    }

    private String callIpassPay(MemberOrder memberOrder) {
        String serviceAddress = (String)this.staticConfig.getConfig().get("service.address");
        JSONObject data = new JSONObject();
        data.put("rechargeType", (Object)memberOrder.getPayType());
        data.put("businessTag", (Object)"MCN");
        data.put("orderId", (Object)memberOrder.getId());
        data.put("orderAmt", (Object)memberOrder.getPayAmt());
        data.put("orderDate", (Object)DateUtil.format((Date)memberOrder.getCreateTime(), (String)"yyyyMMdd"));
        data.put("goodsName", (Object)memberOrder.getProductName());
        data.put("payType", (Object)"B2C");
        data.put("responseType", (Object)"HTML");
        data.put("pageNotifyUrl", (Object)"https://18b13f3883.zicp.fun/srm/member/equity/indexPage");
        data.put("backNotifyUrl", (Object)"https://18b13f3883.zicp.fun/els/openApi/invokeSrm");
        log.info("\u8c03\u7528ipass\u652f\u4ed8\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)data));
        JSONObject jsonObject = this.srmToIPaasService.callIPaasInterface(data, "commonPayService");
        log.info("\u8c03\u7528ipass\u652f\u4ed8\u54cd\u5e94:{}", (Object)jsonObject.toJSONString());
        Assert.isTrue((boolean)jsonObject.getInteger("code").equals(200), (String)jsonObject.getString("message"));
        String resultData = jsonObject.getString("data");
        String decodeHtml = HtmlUtil.unescape((String)resultData);
        log.info("decodeHtml\u54cd\u5e94:{}", (Object)decodeHtml);
        return decodeHtml;
    }
}

