/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.store.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.SysUtil;
import com.els.modules.goods.entity.GoodsDataItem;
import com.els.modules.goods.mapper.GoodsDataItemMapper;
import com.els.modules.store.dto.StoreHeadQueryDTO;
import com.els.modules.store.entity.StoreFavorite;
import com.els.modules.store.entity.StoreHead;
import com.els.modules.store.entity.StoreItem;
import com.els.modules.store.entity.StoreTopmanItem;
import com.els.modules.store.entity.StoreTopmanRecord;
import com.els.modules.store.mapper.StoreFavoriteMapper;
import com.els.modules.store.mapper.StoreHeadMapper;
import com.els.modules.store.mapper.StoreItemMapper;
import com.els.modules.store.mapper.StoreTopmanItemMapper;
import com.els.modules.store.mapper.StoreTopmanRecordMapper;
import com.els.modules.store.service.StoreHeadService;
import com.els.modules.store.service.StoreItemService;
import com.els.modules.store.vo.StoreHeadVO;
import com.els.rpc.service.InvokeBaseRpcService;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class StoreHeadServiceImpl
extends BaseServiceImpl<StoreHeadMapper, StoreHead>
implements StoreHeadService {
    @Autowired
    private StoreHeadMapper storeHeadMapper;
    @Autowired
    private StoreItemService storeItemService;
    @Autowired
    private GoodsDataItemMapper goodsDataItemMapper;
    @Autowired
    private StoreItemMapper storeItemMapper;
    @Autowired
    private StoreTopmanItemMapper storeTopmanItemMapper;
    @Autowired
    private StoreTopmanRecordMapper storeTopmanRecordMapper;
    @Autowired
    private StoreFavoriteMapper storeFavoriteMapper;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;

    @Override
    public IPage<StoreHead> queryPage(Page<StoreHead> page, QueryWrapper<StoreHead> queryWrapper, StoreHeadQueryDTO queryDTO) {
        this.categoryConvert(queryDTO);
        IPage<StoreHead> storeHeadPage = ((StoreHeadMapper)this.baseMapper).storeHeadPage(page, queryWrapper, queryDTO);
        this.replenishNew(storeHeadPage.getRecords(), queryDTO);
        return storeHeadPage;
    }

    @Override
    public List<StoreHead> queryList(QueryWrapper<StoreHead> queryWrapper, StoreHeadQueryDTO queryDTO) {
        this.categoryConvert(queryDTO);
        List<StoreHead> list = ((StoreHeadMapper)this.baseMapper).storeHeadList(queryWrapper, queryDTO);
        this.replenishNew(list, queryDTO);
        return list;
    }

    @Override
    public IPage<StoreHead> queryFavoritePage(Page<StoreHead> page, QueryWrapper<StoreHead> queryWrapper, StoreHeadQueryDTO queryDTO) {
        String subAccount;
        LoginUser loginUser = SysUtil.getLoginUser();
        String elsAccount = loginUser.getElsAccount();
        List<StoreFavorite> goodsFavoriteList = this.storeFavoriteMapper.selectByElsAccount(elsAccount, subAccount = loginUser.getSubAccount());
        if (!CollectionUtils.isEmpty(goodsFavoriteList)) {
            List headIds = goodsFavoriteList.stream().map(StoreFavorite::getHeadId).collect(Collectors.toList());
            queryWrapper.lambda().in(BaseEntity::getId, headIds);
        } else {
            queryWrapper.lambda().eq(BaseEntity::getId, null);
        }
        this.categoryConvert(queryDTO);
        IPage<StoreHead> storeHeadPage = ((StoreHeadMapper)this.baseMapper).storeHeadPage(page, queryWrapper, queryDTO);
        this.replenishNew(storeHeadPage.getRecords(), queryDTO);
        return storeHeadPage;
    }

    private StoreHeadQueryDTO categoryConvert(StoreHeadQueryDTO queryDTO) {
        String category = queryDTO.getStoreCategory();
        if (StringUtils.isNotBlank((CharSequence)category)) {
            if (category.contains(",")) {
                category = category.replace(",", "|");
            } else if (category.contains("\u5168\u90e8")) {
                category = "";
            }
        }
        queryDTO.setStoreCategory(category);
        return queryDTO;
    }

    private List<StoreHead> replenishNew(List<StoreHead> list, StoreHeadQueryDTO queryDTO) {
        if (!CollectionUtils.isEmpty(list)) {
            for (StoreHead storeHead : list) {
                List<GoodsDataItem> itemList = this.goodsDataItemMapper.queryGoodsDataItem(storeHead.getShopId(), "30");
                if (CollectionUtil.isNotEmpty(itemList)) {
                    BigDecimal salesAmountMin = itemList.stream().map(GoodsDataItem::getSalesAmountMin).reduce(BigDecimal.ZERO, BigDecimal::add);
                    BigDecimal salesAmountMax = itemList.stream().map(GoodsDataItem::getSalesAmountMax).reduce(BigDecimal.ZERO, BigDecimal::add);
                    storeHead.setSalesAmountMin(salesAmountMin);
                    storeHead.setSalesAmountMax(salesAmountMax);
                }
                LoginUser loginUser = SysUtil.getLoginUser();
                String elsAccount = loginUser.getElsAccount();
                String subAccount = loginUser.getSubAccount();
                StoreFavorite storeFavorite = this.storeFavoriteMapper.selectGoodsFavorite(storeHead.getId(), elsAccount, subAccount);
                storeHead.setFavoriteStore(false);
                if (storeFavorite == null) continue;
                storeHead.setFavoriteStore(true);
            }
        }
        return list;
    }

    @Override
    public StoreHeadVO queryById(String id) {
        StoreItem storeItem;
        StoreHeadVO storeHeadVO = new StoreHeadVO();
        StoreHead storeHead = (StoreHead)((Object)this.getById((Serializable)((Object)id)));
        if (storeHead == null) {
            return storeHeadVO;
        }
        BeanUtils.copyProperties((Object)((Object)storeHead), (Object)((Object)storeHeadVO));
        String timeSelect = "30";
        List<GoodsDataItem> itemList = this.goodsDataItemMapper.queryGoodsDataItem(storeHead.getShopId(), timeSelect);
        if (CollectionUtil.isNotEmpty(itemList)) {
            BigDecimal salesAmountMin = itemList.stream().map(GoodsDataItem::getSalesAmountMin).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal salesAmountMax = itemList.stream().map(GoodsDataItem::getSalesAmountMax).reduce(BigDecimal.ZERO, BigDecimal::add);
            storeHeadVO.setSalesAmountMin(salesAmountMin);
            storeHeadVO.setSalesAmountMax(salesAmountMax);
        }
        if ((storeItem = this.storeItemService.queryStoreItem(id, timeSelect)) != null) {
            storeHeadVO.setSalesNum(storeItem.getSalesNum());
            storeHeadVO.setGoodsNum(storeItem.getGoodsNum());
            storeHeadVO.setTopmanNum(storeItem.getTopmanNum());
            storeHeadVO.setVideosNum(storeItem.getVideosNum());
            storeHeadVO.setLivesNum(storeItem.getLivesNum());
            storeHeadVO.setQueryDay(storeItem.getQueryDay());
        }
        LoginUser loginUser = SysUtil.getLoginUser();
        String elsAccount = loginUser.getElsAccount();
        String subAccount = loginUser.getSubAccount();
        StoreFavorite storeFavorite = this.storeFavoriteMapper.selectGoodsFavorite(storeHead.getId(), elsAccount, subAccount);
        storeHeadVO.setFavoriteStore(false);
        if (storeFavorite != null) {
            storeHeadVO.setFavoriteStore(true);
        }
        return storeHeadVO;
    }

    @Override
    public StoreHead queryByShopId(String shopId) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(StoreHead::getShopId, (Object)shopId);
        return (StoreHead)((Object)((StoreHeadMapper)this.baseMapper).selectOne((Wrapper)queryWrapper));
    }

    @Override
    @Deprecated
    public QueryWrapper<StoreHead> criteriaQuery(QueryWrapper<StoreHead> queryWrapper, StoreHeadQueryDTO queryDTO) {
        List<StoreItem> goodsItems;
        String experienceNum;
        String category = queryDTO.getStoreCategory();
        if (StringUtils.isNotBlank((CharSequence)category)) {
            if (category.contains(",")) {
                String[] strings = category.split(",");
                List<String> list = Arrays.asList(strings);
                queryWrapper.lambda().in(StoreHead::getCategory, list);
            } else if (!category.contains("\u5168\u90e8")) {
                queryWrapper.lambda().eq(StoreHead::getCategory, (Object)category);
            }
        }
        if (StringUtils.isNotBlank((CharSequence)(experienceNum = queryDTO.getStoreExperienceNum())) && experienceNum.contains("-")) {
            String[] strings = experienceNum.split("-");
            queryWrapper.lambda().gt(StoreHead::getExperienceNum, (Object)new BigDecimal(strings[0]));
            queryWrapper.lambda().le(StoreHead::getExperienceNum, (Object)new BigDecimal(strings[1]));
        }
        if (CollectionUtil.isNotEmpty(goodsItems = this.storeItemService.queryList(queryDTO))) {
            List ids = goodsItems.stream().map(StoreItem::getHeadId).distinct().collect(Collectors.toList());
            queryWrapper.lambda().in(BaseEntity::getId, ids);
        } else {
            queryWrapper.lambda().eq(BaseEntity::getId, null);
        }
        return queryWrapper;
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void saveMain(StoreHead storeHead, StoreHeadVO headVO) {
        String platform = storeHead.getPlatform();
        String account = storeHead.getBusAccount();
        storeHead.setStoreCode(platform + account + this.invokeBaseRpcService.getNextCode("mcnSrmStoreCode", (Object)storeHead));
        this.storeHeadMapper.insert((Object)storeHead);
        super.setHeadDefaultValue((BaseEntity)storeHead);
        this.insertData(storeHead, headVO);
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void updateMain(StoreHead storeHead, StoreHeadVO headVO) {
        this.storeHeadMapper.updateById((Object)storeHead);
        this.storeTopmanItemMapper.deleteByMainId(storeHead.getId());
        this.insertData(storeHead, headVO);
    }

    @Override
    public void favorite(String id) {
        StoreHead storeHead = (StoreHead)((Object)((StoreHeadMapper)this.baseMapper).selectById((Serializable)((Object)id)));
        StoreFavorite storeFavorite = new StoreFavorite();
        LoginUser loginUser = SysUtil.getLoginUser();
        String elsAccount = loginUser.getElsAccount();
        String subAccount = loginUser.getSubAccount();
        storeFavorite.setElsAccount(elsAccount);
        storeFavorite.setUserId(subAccount);
        storeFavorite.setHeadId(storeHead.getId());
        storeFavorite.setPlatform(storeHead.getPlatform());
        storeFavorite.setFavoriteTime(new Date());
        this.storeFavoriteMapper.insert((Object)storeFavorite);
    }

    @Override
    public void cancelFavorite(String id) {
        LoginUser loginUser = SysUtil.getLoginUser();
        String elsAccount = loginUser.getElsAccount();
        String subAccount = loginUser.getSubAccount();
        this.storeFavoriteMapper.deleteGoodsFavorite(id, elsAccount, subAccount);
    }

    private void insertData(StoreHead storeHead, StoreHeadVO headVO) {
        List<StoreTopmanRecord> records;
        List<StoreItem> storeItemList = headVO.getStoreItemList();
        List<StoreTopmanItem> storeTopmanItemList = headVO.getStoreTopmanItemList();
        List<StoreTopmanRecord> storeTopmanRecordList = headVO.getStoreTopmanRecordList();
        if (!CollectionUtils.isEmpty(storeItemList)) {
            for (StoreItem storeItem : storeItemList) {
                storeItem.setHeadId(storeHead.getId());
                SysUtil.setSysParam((BaseEntity)storeItem, (BaseEntity)storeHead);
            }
            if (!storeItemList.isEmpty()) {
                this.storeItemMapper.insertBatchSomeColumn(storeItemList);
            }
        }
        if (!CollectionUtils.isEmpty(storeTopmanRecordList)) {
            for (StoreTopmanRecord storeTopmanRecord : storeTopmanRecordList) {
                storeTopmanRecord.setHeadId(storeHead.getId());
                SysUtil.setSysParam((BaseEntity)storeTopmanRecord, (BaseEntity)storeHead);
            }
            if (!storeTopmanRecordList.isEmpty()) {
                this.storeTopmanRecordMapper.insertBatchSomeColumn(storeTopmanRecordList);
            }
        }
        if (!CollectionUtils.isEmpty(records = this.storeTopmanRecordMapper.selectByMainId(storeHead.getId()))) {
            for (StoreTopmanRecord entity : records) {
                if (CollectionUtils.isEmpty(storeTopmanItemList)) continue;
                for (StoreTopmanItem entity2 : storeTopmanItemList) {
                    entity2.setRecordId(entity.getId());
                    SysUtil.setSysParam((BaseEntity)entity2, (BaseEntity)storeHead);
                }
                if (storeTopmanItemList.isEmpty()) continue;
                this.storeTopmanItemMapper.insertBatchSomeColumn(storeTopmanItemList);
            }
        }
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void delMain(String id) {
        this.storeTopmanRecordMapper.deleteByMainId(id);
        this.storeHeadMapper.deleteById((Serializable)((Object)id));
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void delBatchMain(List<String> idList) {
        for (Serializable serializable : idList) {
            this.storeTopmanRecordMapper.deleteByMainId(serializable.toString());
            this.storeHeadMapper.deleteById(serializable);
        }
    }
}

