/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.member.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.I18nUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.member.entity.MemberMeal;
import com.els.modules.member.entity.MemberMealDetail;
import com.els.modules.member.entity.MemberMealGroup;
import com.els.modules.member.enumerate.MealTypeEnum;
import com.els.modules.member.mapper.MemberMealMapper;
import com.els.modules.member.service.MemberMealDetailService;
import com.els.modules.member.service.MemberMealGroupService;
import com.els.modules.member.service.MemberMealService;
import com.els.modules.member.service.MemberOrderService;
import com.els.modules.member.vo.MemberMealVo;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class MemberMealServiceImpl
extends BaseServiceImpl<MemberMealMapper, MemberMeal>
implements MemberMealService {
    @Autowired
    private MemberMealGroupService memberMealGroupService;
    @Autowired
    private MemberMealDetailService memberMealDetailService;
    @Autowired
    private MemberOrderService memberOrderService;

    @Override
    public void add(MemberMeal memberMeal) {
        ((MemberMealMapper)this.baseMapper).insert((Object)memberMeal);
    }

    @Override
    public void edit(MemberMeal memberMeal) {
        int count = ((MemberMealMapper)this.baseMapper).updateById((Object)memberMeal);
        Assert.isTrue((count != 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
    }

    @Override
    public void delete(String id) {
        ((MemberMealMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    public void deleteBatch(List<String> idList) {
        ((MemberMealMapper)this.baseMapper).deleteBatchIds(idList);
    }

    @Override
    public MemberMealVo getMeal(String type) {
        Assert.isTrue((boolean)StrUtil.isNotBlank((CharSequence)type), (String)"\u53c2\u6570\u5f02\u5e38");
        MealTypeEnum mealType = MealTypeEnum.getByCode(type);
        List dbs = this.list((Wrapper)Wrappers.lambdaQuery().eq(MemberMeal::getPayShow, (Object)"1"));
        MemberMealVo vo = new MemberMealVo();
        String elsAccount = TenantContext.getTenant();
        List orders = this.memberOrderService.getOrderByElsAccount(elsAccount).stream().filter(o -> o.getMealType().equals(type)).collect(Collectors.toList());
        DateTime validityTime = DateUtil.offsetMonth((Date)new Date(), (int)12);
        switch (mealType) {
            case MEMBER_UPGRADE_RENEWAL: {
                if (!CollUtil.isNotEmpty(orders)) break;
                orders = orders.stream().filter(o -> ObjectUtil.isEmpty((Object)o.getIsDed()) || !"1".equals(o.getIsDed())).collect(Collectors.toList());
                List mealIds = orders.stream().map(o -> o.getMealId()).distinct().collect(Collectors.toList());
                List oldMeals = dbs.stream().filter(x -> mealIds.contains(x.getId())).collect(Collectors.toList());
                if (!ObjectUtil.isNotEmpty(oldMeals)) break;
                Assert.isTrue((oldMeals.size() == 1 ? 1 : 0) != 0, (String)"\u5957\u9910\u5f02\u5e38");
                MemberMeal nowMeal = (MemberMeal)((Object)oldMeals.get(0));
                orders = orders.stream().filter(o -> o.getMealId().equals(nowMeal.getId())).collect(Collectors.toList());
                dbs.forEach(dbMeals -> {
                    if (dbMeals.getMemberLev() < nowMeal.getMemberLev()) {
                        dbMeals.setCanChoice(false);
                    }
                });
                break;
            }
            case ADD_SHOPS: {
                break;
            }
        }
        vo.setMeals(dbs);
        vo.setValidityTime((Date)validityTime);
        return vo;
    }

    @Override
    public MemberMealVo getMealDetail() {
        List meals = this.list((Wrapper)Wrappers.lambdaQuery().orderByDesc(MemberMeal::getMemberLev));
        MemberMealVo vo = new MemberMealVo();
        vo.setMeals(meals);
        List memberMealGroups = this.memberMealGroupService.list((Wrapper)Wrappers.lambdaQuery().orderByAsc(MemberMealGroup::getSort));
        LinkedHashMap mealDetails = Maps.newLinkedHashMap();
        memberMealGroups.forEach(memberMealGroup -> mealDetails.put(memberMealGroup.getGroupName(), this.memberMealDetailService.list((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(MemberMealDetail::getGroupId, (Object)memberMealGroup.getId())).orderByAsc(MemberMealDetail::getSort))));
        vo.setMealDetails(mealDetails);
        return vo;
    }
}

