/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.topman.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.lang.func.VoidFunc1;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.query.QueryGenerator;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.I18nUtil;
import com.els.common.util.RedisUtil;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.industryInfo.api.annotation.OrderTagId;
import com.els.modules.industryInfo.api.dto.SimplePostRequestParam;
import com.els.modules.topman.dto.KsTopManCollectDTO;
import com.els.modules.topman.dto.KsTopManDetailDTO;
import com.els.modules.topman.dto.KsTopManInformationDTO;
import com.els.modules.topman.entity.KsCategoryEntity;
import com.els.modules.topman.entity.KsRegionEntity;
import com.els.modules.topman.entity.KsSpiderTopMan;
import com.els.modules.topman.entity.TopManCollectBean;
import com.els.modules.topman.entity.TopManSpiderMark;
import com.els.modules.topman.enumerate.MarkYn;
import com.els.modules.topman.enumerate.MongoCollectionType;
import com.els.modules.topman.enumerate.TopManCategoryEnum;
import com.els.modules.topman.exception.TopManException;
import com.els.modules.topman.mapper.KsTopManInformationMapper;
import com.els.modules.topman.service.KsSpiderTopManService;
import com.els.modules.topman.service.KuaiShouTopManInformationService;
import com.els.modules.topman.service.MongoEntityService;
import com.els.modules.topman.service.MongoHandleService;
import com.els.modules.topman.service.TopManCollectService;
import com.els.modules.topman.utils.spider.entity.KsTopManDetailBaseEntity;
import com.els.modules.topman.utils.spider.entity.KsTopManDetailFansEntity;
import com.els.modules.topman.utils.spider.entity.KsTopManDetailGoodsEntity;
import com.els.modules.topman.utils.spider.entity.KsTopManDetailGoodsItemEntity;
import com.els.modules.topman.utils.spider.entity.KsTopManDetailGoodsStoreEntity;
import com.els.modules.topman.utils.spider.entity.KsTopManDetailLiveAnalysisEntity;
import com.els.modules.topman.utils.spider.entity.KsTopManDetailLiveDataEntity;
import com.els.modules.topman.utils.spider.entity.KsTopManDetailLiveEntity;
import com.els.modules.topman.utils.spider.entity.KsTopManDetailVideoAnalysisEntity;
import com.els.modules.topman.utils.spider.entity.KsTopManDetailVideoEntity;
import com.els.modules.topman.utils.spider.entity.KuaiShouIndexListPage;
import com.els.modules.topman.utils.spider.entity.KuaiShouTopManInfo;
import com.els.modules.topman.utils.spider.properties.SpiderMethodType;
import com.els.modules.topman.utils.spider.spiderApi.SpiderApiUtil;
import com.els.modules.topman.utils.spider.vo.KsTopManDetailHeadContacrVO;
import com.els.modules.topman.utils.spider.vo.KsTopManDetailHeadVO;
import com.els.modules.topman.vo.KsSpiderApiIndexListVo;
import com.els.modules.topman.vo.KsTopManCategory;
import com.els.modules.topman.vo.KsTopManVO;
import com.google.common.collect.Maps;
import com.mongodb.client.MongoCursor;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.data.mongodb.core.query.UpdateDefinition;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class KsTopManInformationServiceImpl
implements KuaiShouTopManInformationService {
    private static final Logger log;
    private static final Map<String, Integer> orderTag;
    private static final String CATALOGUE = "talent:category:cache";
    private static final String COLON = ":";
    @Autowired
    private SpiderApiUtil spiderApiUtil;
    @Autowired
    private KsSpiderTopManService ksSpiderTopManService;
    @Autowired
    private RedisUtil redisUtil;
    @Resource
    private MongoTemplate mongoTemplate;
    @Autowired
    private TopManCollectService topManCollectService;
    @Autowired
    private KsTopManInformationMapper ksTopManInformationMapper;
    @Resource
    private MongoHandleService mongoHandleService;

    @Override
    public List<KsTopManCategory> getCategoryData(String type) {
        StringBuilder redisKey;
        List<KsTopManCategory> stringListMap;
        String language = I18nUtil.getCurrentLanguage();
        if (StrUtil.isBlank((CharSequence)language)) {
            language = "zh";
        }
        if ((stringListMap = (List<KsTopManCategory>)this.redisUtil.get((redisKey = new StringBuilder(CATALOGUE).append(TenantContext.getTenant()).append(COLON).append(type).append(COLON).append(language)).toString())) != null) {
            return stringListMap;
        }
        log.info("getCategoryData:\u8d70\u4e86\u65e0\u7f13\u5b58");
        LinkedHashMap<String, KsTopManCategory> resultData = new LinkedHashMap<String, KsTopManCategory>();
        Document document = new Document();
        String kuaishouCategory = "tb_kuaishou_category";
        MongoCursor attractCursor = this.mongoTemplate.getCollection(kuaishouCategory).find((Bson)document).noCursorTimeout(true).cursor();
        Document attract = null;
        boolean isTalentCategory = false;
        KsTopManCategory talentInfoCategory = new KsTopManCategory();
        ArrayList<KsTopManCategory.ContentCategory> talentList = new ArrayList<KsTopManCategory.ContentCategory>();
        boolean isFanCategory = false;
        KsTopManCategory fanInfoCategory = new KsTopManCategory();
        ArrayList<KsTopManCategory.ContentCategory> fanList = new ArrayList<KsTopManCategory.ContentCategory>();
        boolean isContentCategory = false;
        KsTopManCategory contentPerformanceCategory = new KsTopManCategory();
        ArrayList<KsTopManCategory.ContentCategory> contentList = new ArrayList<KsTopManCategory.ContentCategory>();
        while (attractCursor.hasNext()) {
            try {
                ArrayList<KsTopManCategory.SubTags> commonList;
                List directoryJson;
                List directoryJson2;
                KsTopManCategory.ContentCategory topManInfo;
                attract = (Document)attractCursor.next();
                String name = attract.getString((Object)"name");
                String secName = attract.getString((Object)"sec_name");
                String str = attract.toJson();
                Map t = (Map)JSONObject.parseObject((String)str, Map.class);
                KsTopManCategory ksTopManCategory = new KsTopManCategory();
                if (TopManCategoryEnum.CONTENT_CATEGORY.getDesc().equals(name)) {
                    this.getContentData(t, resultData, "contentType", ksTopManCategory, 1);
                }
                if (TopManCategoryEnum.INDUSTRY.getDesc().equals(name)) {
                    this.getContentData(t, resultData, "Industry", ksTopManCategory, 2);
                }
                if (TopManCategoryEnum.CONTENT_FORM.getDesc().equals(name)) {
                    this.getContentData(t, resultData, "contentForm", ksTopManCategory, 3);
                }
                if (TopManCategoryEnum.RECOMMEND.getDesc().equals(name)) {
                    ksTopManCategory.setFieldName("starRecommendation");
                    ksTopManCategory.setTitle(name);
                    ksTopManCategory.setSort(4);
                    ArrayList<KsTopManCategory.ContentCategory> categoryList = new ArrayList<KsTopManCategory.ContentCategory>();
                    List directoryJson3 = (List)t.get("directory_json");
                    directoryJson3.forEach(a -> {
                        if (this.checkoutStarRecommendation(a.get("tagName").toString(), type)) {
                            KsTopManCategory.ContentCategory contentCategory = new KsTopManCategory.ContentCategory();
                            contentCategory.setStarTagId(String.valueOf(a.get("tagId")));
                            contentCategory.setStarTagName(String.valueOf(a.get("tagName")));
                            contentCategory.setComponent("RCheckbox");
                            categoryList.add(contentCategory);
                        }
                    });
                    ksTopManCategory.setChildren(categoryList);
                    resultData.put("starRecommendation", ksTopManCategory);
                }
                if (TopManCategoryEnum.CONTENT_PERFORMANCE.getDesc().equals(name)) {
                    topManInfo = new KsTopManCategory.ContentCategory();
                    topManInfo.setComponent("RCustomSelect");
                    topManInfo.setStarTagId(attract.getString((Object)"_id"));
                    topManInfo.setStarTagName(attract.getString((Object)"sec_name"));
                    if (TopManCategoryEnum.ESTIMATED_CPM.getDesc().equals(secName) || TopManCategoryEnum.EXPECTED_PLAYBACK_VOLUME.getDesc().equals(secName) || TopManCategoryEnum.NUMBER_OF_PEOPLE.getDesc().equals(secName) || TopManCategoryEnum.ESTIMATED_ONLINE_POPULATION.getDesc().equals(secName)) {
                        ArrayList<KsTopManCategory.SubTags> commonList2 = new ArrayList<KsTopManCategory.SubTags>();
                        directoryJson2 = JSON.parseArray((String)t.get("directory_json").toString(), KsTopManCategory.Fans.class);
                        this.getParamData(commonList2, directoryJson2, "", "");
                        topManInfo.setSubTags(commonList2);
                    } else {
                        ArrayList<KsTopManCategory.SubTags> subTagsList = new ArrayList<KsTopManCategory.SubTags>();
                        directoryJson2 = JSON.parseArray((String)t.get("directory_json").toString(), KsTopManCategory.Fans.class);
                        directoryJson2.forEach(a -> {
                            KsTopManCategory.SubTags subTags = new KsTopManCategory.SubTags();
                            if (TopManCategoryEnum.CPE.getDesc().equals(secName)) {
                                subTags.setStarTagName(a.getMax().stripTrailingZeros().toPlainString() + "\u4ee5\u4e0b");
                                subTags.setStarTagValue(a.getMax());
                            } else {
                                subTags.setStarTagName(a.getMin().multiply(new BigDecimal(100)).stripTrailingZeros().toPlainString() + "%\u4ee5\u4e0a");
                                subTags.setStarTagValue(a.getMin());
                            }
                            subTagsList.add(subTags);
                        });
                        topManInfo.setSubTags(subTagsList);
                    }
                    this.contentPerformanceGroup(contentList, topManInfo, type);
                    if (!isContentCategory) {
                        contentPerformanceCategory.setFieldName("contentPerformance");
                        contentPerformanceCategory.setTitle(name);
                        contentPerformanceCategory.setSort(8);
                        isContentCategory = true;
                    }
                }
                if (TopManCategoryEnum.TANLENT_INDEX.getDesc().equals(secName)) {
                    ksTopManCategory.setFieldName("talentIndex");
                    ksTopManCategory.setTitle(TopManCategoryEnum.TANLENT_INDEX.getDesc());
                    ksTopManCategory.setSort(6);
                    topManInfo = new KsTopManCategory.ContentCategory();
                    topManInfo.setStarTagId(attract.getString((Object)"_id"));
                    ArrayList<KsTopManCategory.ContentCategory> categoryList = new ArrayList<KsTopManCategory.ContentCategory>();
                    ArrayList<KsTopManCategory.SubTags> subTagsList = new ArrayList<KsTopManCategory.SubTags>();
                    directoryJson = JSON.parseArray((String)t.get("directory_json").toString(), KsTopManCategory.Fans.class);
                    directoryJson.stream().sorted((a, b) -> this.getDefault(a.getMin()).compareTo(this.getDefault(b.getMin()))).forEach(a -> {
                        KsTopManCategory.SubTags subTags = new KsTopManCategory.SubTags();
                        subTags.setStarTagName(a.getMin().stripTrailingZeros().toPlainString() + "\u4ee5\u4e0a");
                        subTags.setStarTagValue(a.getMin());
                        subTagsList.add(subTags);
                    });
                    topManInfo.setComponent("RCustomSelect");
                    topManInfo.setStarTagName(TopManCategoryEnum.COMPOSTIE_INDEX.getDesc());
                    topManInfo.setSubTags(subTagsList);
                    categoryList.add(topManInfo);
                    KsTopManCategory.ContentCategory powderTopManInfo = new KsTopManCategory.ContentCategory();
                    BeanUtils.copyProperties((Object)topManInfo, (Object)powderTopManInfo);
                    powderTopManInfo.setStarTagName(TopManCategoryEnum.FLOUR_INDEX.getDesc());
                    categoryList.add(powderTopManInfo);
                    KsTopManCategory.ContentCategory creationTopManInfo = new KsTopManCategory.ContentCategory();
                    BeanUtils.copyProperties((Object)topManInfo, (Object)creationTopManInfo);
                    creationTopManInfo.setStarTagName(TopManCategoryEnum.CREATION_INDEX.getDesc());
                    categoryList.add(creationTopManInfo);
                    KsTopManCategory.ContentCategory costTopManInfo = new KsTopManCategory.ContentCategory();
                    BeanUtils.copyProperties((Object)topManInfo, (Object)costTopManInfo);
                    costTopManInfo.setStarTagName(TopManCategoryEnum.COST_PERFORMANCE.getDesc());
                    categoryList.add(costTopManInfo);
                    KsTopManCategory.ContentCategory activityManInfo = new KsTopManCategory.ContentCategory();
                    BeanUtils.copyProperties((Object)topManInfo, (Object)activityManInfo);
                    activityManInfo.setStarTagName(TopManCategoryEnum.BUSINESS_ACTIVITY.getDesc());
                    categoryList.add(activityManInfo);
                    KsTopManCategory.ContentCategory cooperationManInfo = new KsTopManCategory.ContentCategory();
                    BeanUtils.copyProperties((Object)topManInfo, (Object)cooperationManInfo);
                    cooperationManInfo.setStarTagName(TopManCategoryEnum.COOPERATION_INDEX.getDesc());
                    categoryList.add(cooperationManInfo);
                    ksTopManCategory.setChildren(categoryList);
                    resultData.put("talentIndex", ksTopManCategory);
                }
                if (TopManCategoryEnum.TALENT_INFORMATION.getDesc().equals(name)) {
                    if ("0".equals(type) || "2".equals(type) || "3".equals(type)) {
                        if (!TopManCategoryEnum.TANLENT_INDEX.getDesc().equals(secName) && !TopManCategoryEnum.TALENT_QUOTATION.getDesc().equals(secName)) {
                            this.talentInfoTranslation(attract, name, secName, t, talentList, talentInfoCategory, isTalentCategory);
                        }
                    } else if (!TopManCategoryEnum.TANLENT_INDEX.getDesc().equals(secName)) {
                        this.talentInfoTranslation(attract, name, secName, t, talentList, talentInfoCategory, isTalentCategory);
                    }
                }
                if (!TopManCategoryEnum.FAN_PORTRAIT.getDesc().equals(name)) continue;
                topManInfo = new KsTopManCategory.ContentCategory();
                topManInfo.setStarTagId(attract.getString((Object)"_id"));
                String value = attract.getString((Object)"sec_name").equals(TopManCategoryEnum.FAN_REGION.getDesc()) ? "\u7c89\u4e1d\u57ce\u5e02\u7ebf" : attract.getString((Object)"sec_name");
                topManInfo.setStarTagName(value);
                if (TopManCategoryEnum.FAN_REGION.getDesc().equals(secName) || TopManCategoryEnum.FAN_DEVICE.getDesc().equals(secName)) {
                    directoryJson2 = JSON.parseArray((String)t.get("directory_json").toString(), KsTopManCategory.Sex.class);
                    commonList = new ArrayList<KsTopManCategory.SubTags>(directoryJson2.size());
                    directoryJson2.forEach(a -> {
                        KsTopManCategory.SubTags subTags = new KsTopManCategory.SubTags();
                        subTags.setStarTagName(a.getLabel() + "\u5c45\u591a");
                        subTags.setStarTagValue(a.getValue());
                        commonList.add(subTags);
                    });
                    topManInfo.setComponent("RSelect");
                    topManInfo.setSubTags(commonList);
                }
                if (TopManCategoryEnum.FAN_GENDER.getDesc().equals(secName)) {
                    directoryJson2 = JSON.parseArray((String)t.get("directory_json").toString(), KsTopManCategory.Sex.class);
                    commonList = new ArrayList(directoryJson2.size());
                    directoryJson2.forEach(a -> {
                        KsTopManCategory.SubTags subTags = new KsTopManCategory.SubTags();
                        subTags.setStarTagName(a.getLabel() + "\u5c45\u591a");
                        subTags.setStarTagValue(a.getValue());
                        commonList.add(subTags);
                    });
                    topManInfo.setComponent("RSelect");
                    topManInfo.setSubTags(commonList);
                }
                if (TopManCategoryEnum.FAN_AGE.getDesc().equals(secName)) {
                    ArrayList<KsTopManCategory.SubTags> commonList3 = new ArrayList<KsTopManCategory.SubTags>();
                    directoryJson = JSON.parseArray((String)t.get("directory_json").toString(), KsTopManCategory.Fans.class);
                    this.getParamData(commonList3, directoryJson, "\u5c81", secName);
                    topManInfo.setComponent("RSelect");
                    topManInfo.setSubTags(commonList3);
                }
                fanList.add(topManInfo);
                if (isFanCategory) continue;
                fanInfoCategory.setFieldName("fanInfo");
                fanInfoCategory.setTitle("\u7c89\u4e1d\u4fe1\u606f");
                fanInfoCategory.setSort(5);
                isFanCategory = true;
            }
            catch (Exception e) {
                log.error("attractCursor error", (Throwable)e);
                if (attract == null) continue;
                log.error("error is Data" + attract.toJson());
            }
        }
        contentPerformanceCategory.setChildren(contentList);
        resultData.put("contentPerformance", contentPerformanceCategory);
        talentInfoCategory.setChildren(talentList);
        resultData.put("talentInfo", talentInfoCategory);
        fanInfoCategory.setChildren(fanList);
        resultData.put("fanInfo", fanInfoCategory);
        stringListMap = this.groupMap(type, resultData);
        if (!stringListMap.isEmpty()) {
            this.redisUtil.set(redisKey.toString(), stringListMap, 14400L);
        }
        return stringListMap;
    }

    private void talentInfoTranslation(Document attract, String name, String secName, Map<?, ?> t, List<KsTopManCategory.ContentCategory> talentList, KsTopManCategory talentInfoCategory, boolean isTalentCategory) {
        ArrayList<KsTopManCategory.SubTags> commonList;
        List directoryJson;
        KsTopManCategory.ContentCategory topManInfo = new KsTopManCategory.ContentCategory();
        topManInfo.setStarTagId(attract.getString((Object)"_id"));
        topManInfo.setStarTagName(attract.getString((Object)"sec_name"));
        topManInfo.setComponent("RCascader");
        if (TopManCategoryEnum.TALENT_REGION.getDesc().equals(secName)) {
            ArrayList<KsTopManCategory.SubTags> categoryList = new ArrayList<KsTopManCategory.SubTags>();
            directoryJson = (List)t.get("directory_json");
            for (Map param : directoryJson) {
                KsTopManCategory.SubTags subTags = new KsTopManCategory.SubTags();
                subTags.setStarTagId(String.valueOf(param.get("provinceCode")));
                subTags.setStarTagName((String)param.get("provinceName"));
                subTags.setStarTagValue((String)param.get("provinceName"));
                List citys = (List)param.get("citys");
                ArrayList<KsTopManCategory.SubTags> subTagsList = new ArrayList<KsTopManCategory.SubTags>();
                for (Map citysMap : citys) {
                    KsTopManCategory.SubTags subTagsCitys = new KsTopManCategory.SubTags();
                    subTagsCitys.setStarTagId(String.valueOf(citysMap.get("cityCode")));
                    subTagsCitys.setStarTagName((String)citysMap.get("cityName"));
                    subTagsCitys.setStarTagValue((String)citysMap.get("cityName"));
                    subTagsList.add(subTagsCitys);
                }
                subTags.setSubTags(subTagsList);
                categoryList.add(subTags);
            }
            topManInfo.setSubTags(categoryList);
        }
        if (TopManCategoryEnum.TALENT_QUOTATION.getDesc().equals(secName) || TopManCategoryEnum.NUMBER_OF_FANS.getDesc().equals(secName)) {
            commonList = new ArrayList<KsTopManCategory.SubTags>();
            directoryJson = JSON.parseArray((String)t.get("directory_json").toString(), KsTopManCategory.Fans.class);
            this.getParamData(commonList, directoryJson, "", secName);
            topManInfo.setComponent("RCustomSelect");
            topManInfo.setSubTags(commonList);
        }
        if (TopManCategoryEnum.GENDER_OF_TALENT.getDesc().equals(secName)) {
            commonList = new ArrayList();
            directoryJson = JSON.parseArray((String)t.get("directory_json").toString(), KsTopManCategory.Sex.class);
            directoryJson.forEach(a -> {
                KsTopManCategory.SubTags subTags = new KsTopManCategory.SubTags();
                subTags.setStarTagName(a.getLabel());
                subTags.setStarTagValue(a.getValue().replace("\u6027", ""));
                commonList.add(subTags);
            });
            topManInfo.setComponent("RSelect");
            topManInfo.setSubTags(commonList);
        }
        talentList.add(topManInfo);
        if (!isTalentCategory) {
            talentInfoCategory.setFieldName("talentInfo");
            talentInfoCategory.setTitle(name);
            talentInfoCategory.setSort(5);
            isTalentCategory = true;
        }
    }

    private void contentPerformanceGroup(List<KsTopManCategory.ContentCategory> contentList, KsTopManCategory.ContentCategory topManInfo, String type) {
        if (("1".equals(type) || "2".equals(type)) && (TopManCategoryEnum.ESTIMATED_CPM.getDesc().equals(topManInfo.getStarTagName()) || TopManCategoryEnum.CPE.getDesc().equals(topManInfo.getStarTagName()) || TopManCategoryEnum.EXPECTED_PLAYBACK_VOLUME.getDesc().equals(topManInfo.getStarTagName()) || TopManCategoryEnum.INTERACTION_RATE.getDesc().equals(topManInfo.getStarTagName()) || TopManCategoryEnum.COMPLETION_RATE.getDesc().equals(topManInfo.getStarTagName()))) {
            contentList.add(topManInfo);
        }
        if ("4".equals(type) && (TopManCategoryEnum.ESTIMATED_CPM.getDesc().equals(topManInfo.getStarTagName()) || TopManCategoryEnum.NUMBER_OF_PEOPLE.getDesc().equals(topManInfo.getStarTagName()) || TopManCategoryEnum.ESTIMATED_ONLINE_POPULATION.getDesc().equals(topManInfo.getStarTagName()))) {
            contentList.add(topManInfo);
        }
    }

    private boolean checkoutStarRecommendation(String str, String type) {
        boolean isFalse = true;
        if (StringUtils.isBlank((CharSequence)str)) {
            return isFalse;
        }
        if ("4".equals(type) || "1".equals(type)) {
            if ("\u652f\u6301\u5bf9\u516c".equals(str) || "\u6709\u5546\u5355\u7ecf\u9a8c".equals(str) || "\u5386\u53f2\u5408\u4f5c\u8fc7".equals(str) || "\u4f18\u9009\u8fbe\u4eba".equals(str)) {
                isFalse = false;
                return isFalse;
            }
        } else if ("\u8fd130\u65e5\u7c89\u4e1d\u6570\u4e0a\u5347".equals(str) || "\u652f\u6301\u5bf9\u516c".equals(str) || "\u6709\u5546\u5355\u7ecf\u9a8c".equals(str) || "\u5386\u53f2\u5408\u4f5c\u8fc7".equals(str) || "\u4f18\u9009\u8fbe\u4eba".equals(str)) {
            isFalse = false;
            return isFalse;
        }
        return isFalse;
    }

    private List<KsTopManCategory> groupMap(String type, Map<String, KsTopManCategory> resultData) {
        LinkedList<KsTopManCategory> linkedHashData = new LinkedList<KsTopManCategory>();
        if (resultData != null && resultData.size() > 0) {
            linkedHashData.add(resultData.get("contentType"));
            linkedHashData.add(resultData.get("Industry"));
            switch (type) {
                case "1": {
                    linkedHashData.add(resultData.get("contentForm"));
                    linkedHashData.add(resultData.get("starRecommendation"));
                    linkedHashData.add(resultData.get("talentInfo"));
                    linkedHashData.add(resultData.get("talentIndex"));
                    linkedHashData.add(resultData.get("fanInfo"));
                    linkedHashData.add(resultData.get("contentPerformance"));
                    break;
                }
                case "2": {
                    linkedHashData.add(resultData.get("starRecommendation"));
                    linkedHashData.add(resultData.get("talentInfo"));
                    linkedHashData.add(resultData.get("fanInfo"));
                    break;
                }
                case "3": {
                    linkedHashData.add(resultData.get("starRecommendation"));
                    linkedHashData.add(resultData.get("talentInfo"));
                    linkedHashData.add(resultData.get("fanInfo"));
                    break;
                }
                case "4": {
                    linkedHashData.add(resultData.get("starRecommendation"));
                    linkedHashData.add(resultData.get("talentInfo"));
                    linkedHashData.add(resultData.get("talentIndex"));
                    linkedHashData.add(resultData.get("fanInfo"));
                    linkedHashData.add(resultData.get("contentPerformance"));
                    break;
                }
                case "0": {
                    linkedHashData.add(resultData.get("starRecommendation"));
                    linkedHashData.add(resultData.get("talentInfo"));
                    linkedHashData.add(resultData.get("fanInfo"));
                    break;
                }
                default: {
                    new ELSBootException("type\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
                }
            }
        }
        return linkedHashData;
    }

    private void getContentData(Map t, Map<String, KsTopManCategory> resultData, String type, KsTopManCategory ksTopManCategory, int sort) {
        ksTopManCategory.setTitle(String.valueOf(t.get("name")));
        ksTopManCategory.setSort(sort);
        ksTopManCategory.setFieldName(type);
        LinkedList<KsTopManCategory.ContentCategory> categoryList = new LinkedList<KsTopManCategory.ContentCategory>();
        List map = (List)t.get("directory_json");
        if (map != null && map.size() > 0) {
            for (Map param : map) {
                KsTopManCategory.ContentCategory aa = new KsTopManCategory.ContentCategory();
                aa.setStarTagName((String)param.get("starTagName"));
                aa.setStarTagId((String)param.get("starTagId"));
                aa.setComponent("RButton");
                categoryList.add(aa);
            }
            ksTopManCategory.setChildren(categoryList);
            resultData.put(type, ksTopManCategory);
        }
    }

    private void getParamData(List<KsTopManCategory.SubTags> commonList, List<KsTopManCategory.Fans> map, String postStr, String type) {
        map.stream().sorted((a, b) -> this.getDefault(a.getMin()).compareTo(this.getDefault(b.getMin()))).forEach(a -> {
            String min;
            KsTopManCategory.SubTags common = new KsTopManCategory.SubTags();
            if (a.getMax() == null) {
                min = KsTopManInformationServiceImpl.getTenThousandOfANumber(type.equals(TopManCategoryEnum.TALENT_QUOTATION.getDesc()) ? a.getMin().divide(new BigDecimal(1000), 0, 4) : a.getMin());
                if (!TopManCategoryEnum.FAN_AGE.getDesc().equals(type)) {
                    common.setStarTagName(min + postStr + "\u4ee5\u4e0a");
                } else {
                    common.setStarTagName(min + postStr + "\u4ee5\u4e0a\u5c45\u591a");
                }
                common.setStarTagValue(a.getMin().setScale(2, RoundingMode.HALF_UP).stripTrailingZeros().toPlainString() + "-");
            }
            if (a.getMin() == null) {
                String max = KsTopManInformationServiceImpl.getTenThousandOfANumber(type.equals(TopManCategoryEnum.TALENT_QUOTATION.getDesc()) ? a.getMax().divide(new BigDecimal(1000), 0, 4) : a.getMax());
                if (!TopManCategoryEnum.FAN_AGE.getDesc().equals(type)) {
                    common.setStarTagName(max + postStr + "\u4ee5\u4e0b");
                } else {
                    common.setStarTagName(max + postStr + "\u4ee5\u4e0b\u5c45\u591a");
                }
                common.setStarTagValue("-" + a.getMax().setScale(2, RoundingMode.HALF_UP).stripTrailingZeros().toPlainString());
            }
            if (a.getMin() != null && a.getMax() != null) {
                min = KsTopManInformationServiceImpl.getTenThousandOfANumber(type.equals(TopManCategoryEnum.TALENT_QUOTATION.getDesc()) ? a.getMin().divide(new BigDecimal(1000), 0, 4) : a.getMin());
                String max = KsTopManInformationServiceImpl.getTenThousandOfANumber(type.equals(TopManCategoryEnum.TALENT_QUOTATION.getDesc()) ? a.getMax().divide(new BigDecimal(1000), 0, 4) : a.getMax());
                if (!TopManCategoryEnum.FAN_AGE.getDesc().equals(type)) {
                    common.setStarTagName(min + postStr + "-" + max + postStr);
                } else {
                    common.setStarTagName(min + postStr + "-" + max + postStr + "\u5c45\u591a");
                }
                common.setStarTagValue(a.getMin().setScale(2, RoundingMode.HALF_UP).stripTrailingZeros().toPlainString() + "-" + a.getMax().setScale(2, RoundingMode.HALF_UP).stripTrailingZeros().toPlainString());
            }
            commonList.add(common);
        });
    }

    private BigDecimal getDefault(BigDecimal bigDecimal) {
        BigDecimal defaultNum = new BigDecimal(0);
        return bigDecimal == null ? defaultNum : bigDecimal;
    }

    private static String getTenThousandOfANumber(BigDecimal num) {
        BigDecimal d10000 = new BigDecimal(10000);
        if (num.compareTo(d10000) < 0) {
            return num.setScale(2, RoundingMode.HALF_UP).stripTrailingZeros().toPlainString();
        }
        String numStr = num.divide(d10000, 2, RoundingMode.HALF_UP).toPlainString();
        String[] ss = numStr.split("\\.");
        if ("00".equals(ss[1])) {
            return ss[0] + "w";
        }
        if ('0' == ss[1].charAt(1)) {
            return ss[0] + "." + ss[1].charAt(0) + "w";
        }
        return numStr + "w";
    }

    @Override
    public void cleanCache() {
        String language = I18nUtil.getCurrentLanguage();
        if (StrUtil.isBlank((CharSequence)language)) {
            language = "zh";
        }
        StringBuilder redisKeyVideo = new StringBuilder(CATALOGUE).append(TenantContext.getTenant()).append(COLON).append("1").append(COLON).append(language);
        StringBuilder redisKeyAll = new StringBuilder(CATALOGUE).append(TenantContext.getTenant()).append(COLON).append("2").append(COLON).append(language);
        StringBuilder redisKeyMy = new StringBuilder(CATALOGUE).append(TenantContext.getTenant()).append(COLON).append("3").append(COLON).append(language);
        StringBuilder redisKeyLive = new StringBuilder(CATALOGUE).append(TenantContext.getTenant()).append(COLON).append("4").append(COLON).append(language);
        StringBuilder redisKeyCollect = new StringBuilder(CATALOGUE).append(TenantContext.getTenant()).append(COLON).append("0").append(COLON).append(language);
        String[] arr = new String[]{redisKeyVideo.toString(), redisKeyAll.toString(), redisKeyMy.toString(), redisKeyLive.toString(), redisKeyCollect.toString()};
        this.redisUtil.del(arr);
    }

    @Override
    public IPage<KsTopManVO> queryTopManList(SimplePostRequestParam<KsTopManInformationDTO> topManDto) throws Exception {
        IPage<KsTopManVO> page = new IPage<KsTopManVO>((long)topManDto.getPageNo().intValue(), (long)topManDto.getPageSize().intValue());
        KsTopManInformationDTO filterInfo = (KsTopManInformationDTO)topManDto.getFilterInfo();
        String taskType = filterInfo.getTaskType();
        if ("1".equals(taskType) || "4".equals(taskType)) {
            Map<?, ?> map = this.apiGetList(topManDto);
            SpiderMethodType kuaiShouIndexList = SpiderMethodType.KUAI_SHOU_INDEX_LIST;
            Class<KuaiShouIndexListPage> responseClass = KuaiShouIndexListPage.class;
            KuaiShouIndexListPage data = this.spiderApiUtil.postForEntity(kuaiShouIndexList, map, responseClass);
            page.setTotal(data.getTotal());
            page.setRecords(this.handleResult(data, filterInfo.getPlatformType(), taskType));
        } else {
            QueryWrapper<KsSpiderTopMan> queryWrapper = this.getQueryWrapper(topManDto);
            page = this.ksTopManInformationMapper.selectCollectTopMan(page, (Wrapper<KsSpiderTopMan>)queryWrapper, SysUtil.getLoginUser());
        }
        return page;
    }

    private List<KsTopManVO> handleResult(KuaiShouIndexListPage data, String platform, String taskType) {
        List<KuaiShouTopManInfo> starList = data.getStarList();
        if (starList == null || starList.size() == 0) {
            return new ArrayList<KsTopManVO>(0);
        }
        HashMap<String, KsTopManVO> map = new HashMap<String, KsTopManVO>(starList.size());
        ArrayList<KsTopManVO> resultEntityList = new ArrayList<KsTopManVO>(starList.size());
        for (KuaiShouTopManInfo kuaiShouTopManInfo : starList) {
            KsTopManVO ksTopManVO = new KsTopManVO();
            BeanUtils.copyProperties((Object)kuaiShouTopManInfo, (Object)ksTopManVO);
            ksTopManVO.setStarType(taskType);
            KuaiShouTopManInfo.LiveQuotedInfo liveQuotedInfo = kuaiShouTopManInfo.getLiveQuotedInfo();
            ksTopManVO.setLiveQuotedPricePerHour(liveQuotedInfo.getPerHour());
            String region = this.formatRegion(kuaiShouTopManInfo.getProvinceCode(), kuaiShouTopManInfo.getCityCode());
            ksTopManVO.setRegion(region);
            BigDecimal d1000 = new BigDecimal(1000);
            BigDecimal d100 = new BigDecimal(100);
            ksTopManVO.setThreeDaysOrderBid(ksTopManVO.getThreeDaysOrderBid().divide(d1000, 2, RoundingMode.HALF_UP));
            ksTopManVO.setLiveQuotedPricePerHour(ksTopManVO.getLiveQuotedPricePerHour().divide(d1000, 2, RoundingMode.HALF_UP));
            ksTopManVO.setFansIncreaseRate(ksTopManVO.getFansIncreaseRate().multiply(d100));
            ksTopManVO.setPhotoCompletePlayRate(ksTopManVO.getPhotoCompletePlayRate().multiply(d100));
            ksTopManVO.setPhotoInteractionRate(ksTopManVO.getPhotoInteractionRate().multiply(d100));
            resultEntityList.add(ksTopManVO);
            map.put(String.valueOf(ksTopManVO.getUserId()), ksTopManVO);
        }
        AddedAndCollect addedAndCollect = new AddedAndCollect();
        addedAndCollect.setTopManIds(map.keySet());
        addedAndCollect.setPlatform(platform);
        addedAndCollect.setLoginUser(SysUtil.getLoginUser());
        List<AddedAndCollect> addedAndCollects = this.ksTopManInformationMapper.checkAddedAndCollect(addedAndCollect);
        addedAndCollects.forEach(a -> {
            String topManId = a.getTopManId();
            KsTopManVO ksTopManVO = (KsTopManVO)map.get(topManId);
            if (ksTopManVO != null) {
                ksTopManVO.setIsCollection(a.getIsCollect());
                ksTopManVO.setIsAdded(a.getIsAdded());
            }
        });
        return resultEntityList;
    }

    private QueryWrapper<KsSpiderTopMan> getQueryWrapper(SimplePostRequestParam<KsTopManInformationDTO> topManDto) {
        String[] columns;
        String column;
        KsTopManInformationDTO filterInfo = (KsTopManInformationDTO)topManDto.getFilterInfo();
        QueryWrapper query = new QueryWrapper();
        KsTopManInformationDTO.ScreenItem screenItem = filterInfo.getScreenItem();
        this.handleInTitle(screenItem.getContentType(), (QueryWrapper<KsSpiderTopMan>)query, KsSpiderTopMan::getContentTypeName);
        this.handleInTitle(screenItem.getIndustry(), (QueryWrapper<KsSpiderTopMan>)query, KsSpiderTopMan::getIndustryName);
        this.handleInTitle(screenItem.getContentForm(), (QueryWrapper<KsSpiderTopMan>)query, KsSpiderTopMan::getContentFormName);
        List<KsTopManInformationDTO.ScreenItemField> starRecommendation = screenItem.getStarRecommendation();
        if (starRecommendation != null && starRecommendation.size() > 0) {
            query.and(wrapper -> {
                for (KsTopManInformationDTO.ScreenItemField screenItemField : starRecommendation) {
                    ((LambdaQueryWrapper)wrapper.lambda().like(KsSpiderTopMan::getStarTagIds, (Object)screenItemField)).or();
                }
            });
        }
        List<KsTopManInformationDTO.ScreenItemField> talentInfos = screenItem.getTalentInfo();
        block10: for (int i = 0; talentInfos != null && i < talentInfos.size(); ++i) {
            KsTopManInformationDTO.ScreenItemField screenItemField = talentInfos.get(i);
            String value = screenItemField.getValue();
            switch (screenItemField.getTitle()) {
                case "\u7c89\u4e1d\u6570\u91cf": {
                    this.handleMinMax(value, (QueryWrapper<KsSpiderTopMan>)query, KsSpiderTopMan::getFansNum);
                    continue block10;
                }
                case "\u8fbe\u4eba\u6027\u522b": {
                    query.lambda().eq(KsSpiderTopMan::getTopmanSex, (Object)value);
                    continue block10;
                }
                case "\u8fbe\u4eba\u5730\u57df": {
                    List strings = JSON.parseArray((String)value, String.class);
                    ((LambdaQueryWrapper)query.lambda().eq(KsSpiderTopMan::getProvinceCode, (Object)Integer.parseInt((String)strings.get(0)))).eq(KsSpiderTopMan::getCityCode, (Object)Integer.parseInt((String)strings.get(1)));
                    continue block10;
                }
                default: {
                    throw new RuntimeException(I18nUtil.translate((String)"", (String)"\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u53c2\u6570\u7c7b\u578b"));
                }
            }
        }
        String keyWord = topManDto.getKeyWord();
        if (keyWord != null && keyWord.trim().length() > 0) {
            query.and(q -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)q.lambda().like(KsSpiderTopMan::getTopmanName, (Object)keyWord)).or(a -> {
                    LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)a.eq(KsSpiderTopMan::getTopmanId, (Object)keyWord);
                });
            });
        }
        if ((column = topManDto.getColumn()) != null && !"default".equals(column) && (columns = column.split(",")).length > 0) {
            final String order = topManDto.getOrder();
            QueryGenerator.doMultiFieldsOrder((QueryWrapper)query, (Map)new HashMap<String, String[]>(2){
                {
                    super(x0);
                    this.put("order", order == null ? new String[columns.length] : order.split(","));
                    this.put("column", columns);
                }
            }, (Object)new KsTopManVO());
        }
        return query;
    }

    private void handleInTitle(List<KsTopManInformationDTO.ScreenItemField> list, QueryWrapper<KsSpiderTopMan> query, SFunction<KsSpiderTopMan, ?> field) {
        if (list == null || list.size() == 0) {
            return;
        }
        List collect = list.stream().map(KsTopManInformationDTO.ScreenItemField::getTitle).collect(Collectors.toList());
        query.lambda().in(field, collect);
    }

    private void handleMinMax(String value, QueryWrapper<KsSpiderTopMan> query, SFunction<KsSpiderTopMan, ?> field) {
        if (value == null) {
            return;
        }
        String[] split = value.split("-");
        switch (split.length) {
            case 0: {
                return;
            }
            case 2: {
                query.lambda().between(field, (Object)new BigDecimal(split[0]), (Object)new BigDecimal(split[1]));
                break;
            }
            case 1: {
                if (value.startsWith("-")) {
                    query.lambda().le(field, (Object)new BigDecimal(split[0]));
                    break;
                }
                query.lambda().ge(field, (Object)new BigDecimal(split[0]));
                break;
            }
            default: {
                throw new TopManException.TransferParamException.ParamFormatError(I18nUtil.translate((String)"", (String)"{}\u914d\u7f6e\u7684\u6570\u636e\u503c\u4e0d\u6b63\u786e\uff0c\u8bf7\u4f7f\u7528\u59820-9\u7c7b\u4f3c\u7684\u683c\u5f0f\uff0c\u5de6\u8fb9\u662f\u5f00\u59cb\u53f3\u8fb9\u662f\u7ed3\u675f\uff0c\u5de6\u53f3\u54ea\u8fb9\u4e0d\u9650\u5236\u5219\u7559\u7a7a\uff0c\u90fd\u4e0d\u9650\u5236\u5219\u4e3a-"));
            }
        }
    }

    @Override
    @Transactional
    public void collect(KsTopManCollectDTO ksTopManCollectDTO) {
        if (MarkYn.check(ksTopManCollectDTO.getCollect())) {
            this.addMarkToSpider(ksTopManCollectDTO);
        }
        this.collectHandle(ksTopManCollectDTO);
    }

    private void collectHandle(KsTopManCollectDTO ksTopManCollectDTO) {
        LoginUser loginUser = SysUtil.getLoginUser();
        String elsAccount = loginUser.getElsAccount();
        String subAccount = loginUser.getSubAccount();
        String collect = ksTopManCollectDTO.getCollect();
        KsTopManVO entity = ksTopManCollectDTO.getEntity();
        if (MarkYn.check(collect)) {
            TopManCollectBean topManCollectBean = new TopManCollectBean();
            topManCollectBean.setTopmanId(String.valueOf(entity.getUserId()));
            topManCollectBean.setPlatform(ksTopManCollectDTO.getPlatform());
            topManCollectBean.setElsAccount(elsAccount);
            topManCollectBean.setSubAccount(subAccount);
            this.topManCollectService.save((Object)topManCollectBean);
        } else {
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.lambda().eq(BaseEntity::getElsAccount, (Object)elsAccount);
            queryWrapper.lambda().eq(TopManCollectBean::getSubAccount, (Object)subAccount);
            queryWrapper.lambda().eq(TopManCollectBean::getPlatform, (Object)ksTopManCollectDTO.getPlatform());
            queryWrapper.lambda().eq(TopManCollectBean::getTopmanId, (Object)entity.getUserId());
            this.topManCollectService.remove((Wrapper)queryWrapper);
        }
    }

    @Override
    public void addMarkToSpider(KsTopManCollectDTO ksTopManCollectDTO) {
        this.addMarkToMongo(ksTopManCollectDTO);
        KsSpiderTopMan spiderMarkEntity = this.getSpiderMarkEntity(ksTopManCollectDTO);
        this.ksSpiderTopManService.saveKsSpiderTopMan(spiderMarkEntity);
    }

    private void addMarkToMongo(KsTopManCollectDTO ksTopManCollectDTO) {
        KsTopManVO entity = ksTopManCollectDTO.getEntity();
        String userId = String.valueOf(entity.getUserId());
        MongoCollectionType collectMark = MongoCollectionType.TB_KS_ELS_TOP_MAN;
        HashMap<String, String> param = new HashMap<String, String>(1);
        param.put("topManId", String.valueOf(userId));
        Map<String, TopManSpiderMark> data = this.mongoHandleService.handleMongo(collectMark, param, TopManSpiderMark.class);
        TopManSpiderMark topManSpiderMark = data.get(userId);
        if (topManSpiderMark == null) {
            topManSpiderMark = new TopManSpiderMark();
            topManSpiderMark.setTopManId(userId);
            topManSpiderMark.setTaskType(ksTopManCollectDTO.getTaskType());
            topManSpiderMark.setCount(1);
            this.mongoTemplate.insert((Object)topManSpiderMark, collectMark.getCollectName());
        } else {
            Query query = new Query((CriteriaDefinition)Criteria.where((String)"topManId").is((Object)String.valueOf(userId)));
            Update update = new Update().set("count", (Object)(topManSpiderMark.getCount() + 1));
            this.mongoTemplate.upsert(query, (UpdateDefinition)update, TopManSpiderMark.class, collectMark.getCollectName());
        }
    }

    private KsSpiderTopMan getSpiderMarkEntity(KsTopManCollectDTO ksTopManCollectDTO) {
        KsTopManVO entity = ksTopManCollectDTO.getEntity();
        KsSpiderTopMan ksSpiderTopMan = new KsSpiderTopMan();
        ksSpiderTopMan.setStarType(entity.getStarType());
        ksSpiderTopMan.setTopmanId(String.valueOf(entity.getUserId()));
        ksSpiderTopMan.setTopmanName(entity.getName());
        ksSpiderTopMan.setKwaiid(entity.getKwaiId());
        ksSpiderTopMan.setStarId(String.valueOf(entity.getStarId()));
        ksSpiderTopMan.setPlatform(ksTopManCollectDTO.getPlatform());
        ksSpiderTopMan.setTopmanAvatar(entity.getHeadUrl());
        ksSpiderTopMan.setTopmanSource("1");
        ksSpiderTopMan.setLiveStatus(String.valueOf(entity.getLiveStatus()));
        ksSpiderTopMan.setRegion(entity.getRegion());
        ksSpiderTopMan.setProvinceCode(entity.getProvinceCode());
        ksSpiderTopMan.setCityCode(entity.getCityCode());
        ksSpiderTopMan.setContentTypeName(entity.getStarTagStr());
        ksSpiderTopMan.setContentFormName(entity.getMmuStarTagStr());
        ksSpiderTopMan.setIndustryName(entity.getIndustryTagStr());
        if (entity.getStarTagIds() != null && entity.getStarTagIds().length > 0) {
            String starTagIds = Arrays.stream(entity.getStarTagIds()).map(String::valueOf).collect(Collectors.joining(","));
            ksSpiderTopMan.setStarTagIds(starTagIds);
        }
        ksSpiderTopMan.setFansNum(entity.getFansNum());
        ksSpiderTopMan.setFansIncreaseNum(entity.getFansIncreaseNum());
        ksSpiderTopMan.setFansIncreaseRate(entity.getFansIncreaseRate());
        ksSpiderTopMan.setLiveExpectCpm(entity.getLiveExpectCpm());
        ksSpiderTopMan.setLiveExpectViewer(entity.getLiveExpectViewer());
        ksSpiderTopMan.setLiveMaxViewer(entity.getLiveMaxViewer());
        ksSpiderTopMan.setPhotoExpectClick(entity.getPhotoExpectClick());
        ksSpiderTopMan.setPhotoCompletePlayRate(entity.getPhotoCompletePlayRate());
        ksSpiderTopMan.setPhotoExpectCpm(entity.getPhotoExpectCpm());
        ksSpiderTopMan.setPhotoInteractionRate(entity.getPhotoInteractionRate());
        ksSpiderTopMan.setQuoteOfLive(entity.getLiveQuotedPricePerHour());
        ksSpiderTopMan.setQuoteOfVideo(entity.getThreeDaysOrderBid());
        ksSpiderTopMan.setTopmanSex(entity.getGender());
        ksSpiderTopMan.setCreateTime(new Date());
        LoginUser loginUser = SysUtil.getLoginUser();
        ksSpiderTopMan.setCreateBy(loginUser.getElsAccount() + "-" + loginUser.getSubAccount());
        ksSpiderTopMan.setDeleted(0);
        return ksSpiderTopMan;
    }

    @Override
    public KsTopManVO getByUserId(String userId) {
        HashMap map = Maps.newHashMap();
        map.put("userName", userId);
        map.put("pageSize", 1);
        map.put("currentPage", 1);
        map.put("starOrderTag", 3);
        map.put("taskType", 1);
        KuaiShouIndexListPage data = this.spiderApiUtil.postForEntity(SpiderMethodType.KUAI_SHOU_INDEX_LIST, map, KuaiShouIndexListPage.class);
        KuaiShouTopManInfo info = data.getStarList().get(0);
        KsTopManVO ksTopManVO = new KsTopManVO();
        BeanUtil.copyProperties((Object)info, (Object)ksTopManVO, (String[])new String[0]);
        ksTopManVO.setRegion(this.formatRegion(ksTopManVO.getProvinceCode(), ksTopManVO.getCityCode()));
        return ksTopManVO;
    }

    @Override
    public KsTopManDetailHeadVO getDetailHead(KsTopManDetailDTO param) {
        KsTopManDetailHeadVO result = null;
        String redisKey = "KsTopManDetailHead_" + param.getUserId() + "_" + param.getStarId() + "_" + param.getStarType();
        if (!"1".equals(param.getClearCache())) {
            result = (KsTopManDetailHeadVO)this.redisUtil.get(redisKey);
        }
        HashMap<String, Object> apiParam = new HashMap<String, Object>(3);
        apiParam.put("starType", StringUtils.isNotBlank((CharSequence)param.getStarType()) ? param.getStarType() : "1");
        apiParam.put("starId", param.getStarId());
        apiParam.put("userID", param.getUserId());
        if (result == null) {
            result = this.spiderApiUtil.postForEntity(SpiderMethodType.KUAI_SHOU_DETAIL_HEAD_STAR_PROFILE, apiParam, KsTopManDetailHeadVO.class);
            KsTopManDetailHeadVO.CoreData coreData = this.spiderApiUtil.postForEntity(SpiderMethodType.KUAI_SHOU_DETAIL_HEAD_CORE_DATA, apiParam, KsTopManDetailHeadVO.CoreData.class);
            result.setCoreData(coreData);
            KsTopManDetailVideoAnalysisEntity videoAnalysis = this.spiderApiUtil.postForEntity(SpiderMethodType.KUAI_SHOU_DETAIL_BODY_VIDEO_ANALYSIS, apiParam, KsTopManDetailVideoAnalysisEntity.class);
            this.videoAnalysisConverter(videoAnalysis, result);
        } else {
            boolean check = this.spiderApiUtil.checkCache(SpiderMethodType.KUAI_SHOU_DETAIL_HEAD_STAR_PROFILE, apiParam);
            if (!check) {
                SpiderApiUtil.taskExecutor.execute(() -> {
                    param.setClearCache("1");
                    this.getDetailHead(param);
                });
            }
        }
        AddedAndCollect addedAndCollect = new AddedAndCollect();
        addedAndCollect.setPlatform(param.getPlatform());
        addedAndCollect.setLoginUser(SysUtil.getLoginUser());
        addedAndCollect.setTopManIds(Collections.singletonList(param.getUserId()));
        List<AddedAndCollect> addedAndCollects = this.ksTopManInformationMapper.checkAddedAndCollect(addedAndCollect);
        if (addedAndCollects != null && addedAndCollects.size() > 0) {
            AddedAndCollect a = addedAndCollects.get(0);
            result.setIsAdded(a.getIsAdded());
            result.setIsCollection(a.getIsCollect());
        }
        return result;
    }

    private void videoAnalysisConverter(KsTopManDetailVideoAnalysisEntity videoAnalysis, KsTopManDetailHeadVO result) {
        if (videoAnalysis == null || videoAnalysis.getStarWorkReport() == null) {
            return;
        }
        KsTopManDetailVideoAnalysisEntity.StarWorkReport starWorkReport = videoAnalysis.getStarWorkReport();
        KsTopManDetailHeadVO.VideoResponse videoResponse = result.getVideoResponse();
        videoResponse.setVideoCount(CollectionUtil.isNotEmpty(starWorkReport.getPphotoCntData()) ? BigDecimal.valueOf(starWorkReport.getPphotoCntData().get("30").intValue()) : BigDecimal.ZERO);
        videoResponse.setVideoPlayCntMedian(CollectionUtil.isNotEmpty(starWorkReport.getPplayMedianData()) ? BigDecimal.valueOf(starWorkReport.getPplayMedianData().get("30").intValue()) : BigDecimal.ZERO);
    }

    @Override
    public KsTopManDetailHeadVO getDetailHeadNew(KsTopManDetailDTO param) {
        SpiderMethodType spiderMethodType = SpiderMethodType.KUAI_SHOU_DETAIL_HEAD_STAR_PROFILE;
        KsTopManDetailHeadVO result = null;
        String redisKey = "KsTopManDetailHeadNew_" + param.getStarId() + "_" + param.getStarType();
        if (!"1".equals(param.getClearCache())) {
            result = (KsTopManDetailHeadVO)this.redisUtil.get(redisKey);
        }
        HashMap<String, Object> apiParam = new HashMap<String, Object>(2);
        apiParam.put("starId", param.getStarId());
        apiParam.put("starType", param.getStarType());
        if (result == null) {
            result = this.spiderApiUtil.postForEntity(spiderMethodType, apiParam, KsTopManDetailHeadVO.class);
        } else {
            boolean check = this.spiderApiUtil.checkCache(spiderMethodType, apiParam);
            if (!check) {
                SpiderApiUtil.taskExecutor.execute(() -> {
                    param.setClearCache("1");
                    this.getDetailHeadNew(param);
                });
            }
        }
        AddedAndCollect addedAndCollect = new AddedAndCollect();
        addedAndCollect.setPlatform(param.getPlatform());
        addedAndCollect.setLoginUser(SysUtil.getLoginUser());
        addedAndCollect.setTopManIds(Collections.singletonList(param.getUserId()));
        List<AddedAndCollect> addedAndCollects = this.ksTopManInformationMapper.checkAddedAndCollect(addedAndCollect);
        if (addedAndCollects != null && addedAndCollects.size() > 0) {
            AddedAndCollect a = addedAndCollects.get(0);
            result.setIsAdded(a.getIsAdded());
            result.setIsCollection(a.getIsCollect());
        }
        return result;
    }

    @Override
    public KsTopManDetailHeadVO getDetailBase(KsTopManDetailDTO param) {
        SpiderMethodType spiderMethodType = SpiderMethodType.KUAI_SHOU_DETAIL_HEAD_USER_TEXT;
        KsTopManDetailHeadVO result = null;
        String redisKey = "KsTopManDetailBase_" + param.getProfileId();
        if (!"1".equals(param.getClearCache())) {
            result = (KsTopManDetailHeadVO)this.redisUtil.get(redisKey);
        }
        HashMap<String, Object> apiParam = new HashMap<String, Object>(1);
        apiParam.put("profileId", param.getProfileId());
        if (result == null) {
            result = new KsTopManDetailHeadVO();
            KsTopManDetailHeadVO.BaseData baseData = this.spiderApiUtil.postForEntity(spiderMethodType, apiParam, KsTopManDetailHeadVO.BaseData.class);
            result.setBaseData(baseData);
        } else {
            boolean check = this.spiderApiUtil.checkCache(spiderMethodType, apiParam);
            if (!check) {
                SpiderApiUtil.taskExecutor.execute(() -> {
                    param.setClearCache("1");
                    this.getDetailBase(param);
                });
            }
        }
        return result;
    }

    @Override
    public KsTopManDetailHeadVO getDetailCore(KsTopManDetailDTO param) {
        SpiderMethodType spiderMethodType = SpiderMethodType.KUAI_SHOU_DETAIL_HEAD_CORE_DATA;
        KsTopManDetailHeadVO result = null;
        String redisKey = "KsTopManDetailCore_" + param.getUserId();
        if (!"1".equals(param.getClearCache())) {
            result = (KsTopManDetailHeadVO)this.redisUtil.get(redisKey);
        }
        HashMap<String, Object> apiParam = new HashMap<String, Object>(1);
        apiParam.put("userID", param.getUserId());
        if (result == null) {
            result = new KsTopManDetailHeadVO();
            KsTopManDetailHeadVO.CoreData coreData = this.spiderApiUtil.postForEntity(spiderMethodType, apiParam, KsTopManDetailHeadVO.CoreData.class);
            result.setCoreData(coreData);
        } else {
            boolean check = this.spiderApiUtil.checkCache(spiderMethodType, apiParam);
            if (!check) {
                SpiderApiUtil.taskExecutor.execute(() -> {
                    param.setClearCache("1");
                    this.getDetailCore(param);
                });
            }
        }
        return result;
    }

    @Override
    public KsTopManDetailHeadContacrVO getDetailHeadContacr(KsTopManDetailDTO param) {
        KsTopManDetailHeadContacrVO result = null;
        String redisKey = "KsTopManDetailHeadContacr_" + param.getUserId();
        if (!"1".equals(param.getClearCache())) {
            result = (KsTopManDetailHeadContacrVO)this.redisUtil.get(redisKey);
        }
        HashMap<String, Object> apiParam = new HashMap<String, Object>(2);
        apiParam.put("advertiserPhone", "(+86)" + param.getContacrPhone());
        apiParam.put("starId", param.getUserId());
        if (result == null) {
            result = this.spiderApiUtil.postForEntity(SpiderMethodType.KUAI_SHOU_DETAIL_HEAD_CONTACR, apiParam, KsTopManDetailHeadContacrVO.class);
            this.redisUtil.set(redisKey, (Object)result, 14400L);
        } else {
            boolean check = this.spiderApiUtil.checkCache(SpiderMethodType.KUAI_SHOU_DETAIL_HEAD_CONTACR, apiParam);
            if (!check) {
                SpiderApiUtil.taskExecutor.execute(() -> {
                    param.setClearCache("1");
                    this.getDetailHeadContacr(param);
                });
            }
        }
        return result;
    }

    @Override
    public KsTopManDetailBaseEntity getDetailBodyBase(KsTopManDetailDTO param) {
        SpiderMethodType spiderMethodType = SpiderMethodType.KUAI_SHOU_DETAIL_BODY_BASE;
        KsTopManDetailBaseEntity result = null;
        String redisKey = "KsTopManDetailBodyBase_" + param.getUserId();
        if (!"1".equals(param.getClearCache())) {
            result = (KsTopManDetailBaseEntity)this.redisUtil.get(redisKey);
        }
        HashMap<String, Object> apiParam = new HashMap<String, Object>(1);
        apiParam.put("userID", param.getUserId());
        if (result == null) {
            result = this.spiderApiUtil.postForEntity(spiderMethodType, apiParam, KsTopManDetailBaseEntity.class);
            KsTopManDetailHeadVO.CoreData coreData = this.spiderApiUtil.postForEntity(SpiderMethodType.KUAI_SHOU_DETAIL_HEAD_CORE_DATA, apiParam, KsTopManDetailHeadVO.CoreData.class);
            this.getDetailBodyBaseTranslation(coreData, result);
            this.redisUtil.set(redisKey, (Object)result, 14400L);
        } else if (!this.spiderApiUtil.checkCache(spiderMethodType, apiParam)) {
            SpiderApiUtil.taskExecutor.execute(() -> {
                param.setClearCache("1");
                this.getDetailBodyBase(param);
            });
        }
        return result;
    }

    private void getDetailBodyBaseTranslation(KsTopManDetailHeadVO.CoreData coreData, KsTopManDetailBaseEntity result) {
        KsTopManDetailBaseEntity.CommerceRequirement commerceRequirement = result.getCommerceRequirement();
        if (commerceRequirement != null && commerceRequirement.getInviteCommissionRate() != null) {
            commerceRequirement.setInviteCommissionRate(commerceRequirement.getInviteCommissionRate().divide(new BigDecimal(10), 2, RoundingMode.HALF_UP));
        }
        if (coreData == null) {
            return;
        }
        KsTopManDetailBaseEntity.CommerceCapacity commerceCapacity = result.getCommerceCapacity();
        List<KsTopManDetailHeadVO.HotSaleChannelInfo> hotSaleChannelList = coreData.getHotSaleChannelInfo();
        List<KsTopManDetailHeadVO.HotSaleBrandInfo> hotSaleBrandList = coreData.getHotSaleBrandInfo();
        if (CollectionUtil.isNotEmpty(hotSaleChannelList)) {
            ArrayList<KsTopManDetailBaseEntity.HotSaleChannelInfo> hotSaleChannelInfos = new ArrayList<KsTopManDetailBaseEntity.HotSaleChannelInfo>(hotSaleChannelList.size());
            hotSaleChannelList.forEach(h -> {
                KsTopManDetailBaseEntity.HotSaleChannelInfo hotSaleChannelInfo = new KsTopManDetailBaseEntity.HotSaleChannelInfo();
                BeanUtils.copyProperties((Object)h, (Object)hotSaleChannelInfo);
                hotSaleChannelInfos.add(hotSaleChannelInfo);
            });
            commerceCapacity.setHotSaleChannelInfo(hotSaleChannelInfos);
        }
        if (CollectionUtil.isNotEmpty(hotSaleBrandList)) {
            ArrayList<KsTopManDetailBaseEntity.HotSaleBrandInfo> hotSaleBrandInfos = new ArrayList<KsTopManDetailBaseEntity.HotSaleBrandInfo>(hotSaleBrandList.size());
            hotSaleBrandList.forEach(h -> {
                KsTopManDetailBaseEntity.HotSaleBrandInfo hotSaleBrandInfo = new KsTopManDetailBaseEntity.HotSaleBrandInfo();
                BeanUtils.copyProperties((Object)h, (Object)hotSaleBrandInfo);
                hotSaleBrandInfos.add(hotSaleBrandInfo);
            });
            commerceCapacity.setHotSaleBrandInfo(hotSaleBrandInfos);
        }
    }

    @Override
    public KsTopManDetailLiveEntity getDetailBodyLive(KsTopManDetailDTO param) {
        BigDecimal d100 = new BigDecimal(100);
        HashMap<String, Object> apiParam = new HashMap<String, Object>(8);
        apiParam.put("promoterId", param.getUserId());
        apiParam.put("userID", param.getUserId());
        apiParam.put("channelIdList", param.getChannelIdList() == null ? Collections.EMPTY_LIST : param.getChannelIdList());
        apiParam.put("timeRangeType", param.getTimeRangeType());
        apiParam.put("minPrice", param.getMinPrice() == null ? Integer.valueOf(0) : param.getMinPrice().multiply(d100));
        apiParam.put("maxPrice", param.getMaxPrice() == null ? Integer.valueOf(10000000) : param.getMaxPrice().multiply(d100));
        apiParam.put("orderType", param.getOrderType() == null ? "0" : param.getOrderType());
        apiParam.put("offset", (param.getPage() - 1) * param.getPageSize());
        apiParam.put("limit", param.getPageSize());
        KsTopManDetailLiveEntity result = this.spiderApiUtil.postForEntity(SpiderMethodType.KUAI_SHOU_DETAIL_BODY_LIVE_LIST, apiParam, KsTopManDetailLiveEntity.class);
        result.getResultList().forEach(a -> a.setPromoteAvgPrice(a.getPromoteAvgPrice().divide(d100, 0, RoundingMode.HALF_UP)));
        return result;
    }

    @Override
    public KsTopManDetailLiveAnalysisEntity getDetailBodyLiveNew(KsTopManDetailDTO param) {
        SpiderMethodType spiderMethodType = SpiderMethodType.KUAI_SHOU_DETAIL_BODY_LIVE_ANALYSIS;
        KsTopManDetailLiveAnalysisEntity result = null;
        String redisKey = "KsTopManDetailBodyLiveAnalysis_" + param.getUserId() + "_" + param.getTimeRangeType();
        if (!"1".equals(param.getClearCache())) {
            result = (KsTopManDetailLiveAnalysisEntity)this.redisUtil.get(redisKey);
        }
        HashMap<String, Object> apiParam = new HashMap<String, Object>(2);
        apiParam.put("userID", param.getUserId());
        apiParam.put("timeRangeType", param.getTimeRangeType());
        if (result == null) {
            result = this.spiderApiUtil.postForEntity(spiderMethodType, apiParam, KsTopManDetailLiveAnalysisEntity.class);
            KsTopManDetailLiveEntity tCount = this.spiderApiUtil.postForEntity(SpiderMethodType.KUAI_SHOU_DETAIL_BODY_LIVE_SALE_COUNT, apiParam, KsTopManDetailLiveEntity.class);
            if (tCount != null) {
                KsTopManDetailLiveAnalysisEntity.StaticDataInfoView staticDataInfoView = result.getStaticDataInfoView();
                staticDataInfoView.setPromoteItemCount(tCount.getPromoteItemCount());
                result.setStaticDataInfoView(staticDataInfoView);
            }
            this.redisUtil.set(redisKey, (Object)result, 14400L);
        } else if (!this.spiderApiUtil.checkCache(spiderMethodType, apiParam)) {
            SpiderApiUtil.taskExecutor.execute(() -> {
                param.setClearCache("1");
                this.getDetailBodyLiveNew(param);
            });
        }
        return result;
    }

    @Override
    public KsTopManDetailLiveDataEntity getDetailBodyLiveData(KsTopManDetailDTO param) {
        HashMap<String, Object> apiParam = new HashMap<String, Object>(7);
        apiParam.put("liveStreamId", param.getLiveStreamId());
        apiParam.put("channelIdList", param.getChannelIdList() == null ? Collections.EMPTY_LIST : param.getChannelIdList());
        apiParam.put("brandIdList", param.getBrandIdList() == null ? Collections.EMPTY_LIST : param.getBrandIdList());
        apiParam.put("timeRangeType", param.getTimeRangeType());
        apiParam.put("orderType", param.getOrderType() == null ? "0" : param.getOrderType());
        apiParam.put("offset", (param.getPage() - 1) * param.getPageSize());
        apiParam.put("limit", param.getPageSize());
        return this.spiderApiUtil.postForEntity(SpiderMethodType.KUAI_SHOU_DETAIL_BODY_LIVE_DATA, apiParam, KsTopManDetailLiveDataEntity.class);
    }

    @Override
    public KsTopManDetailVideoEntity getDetailBodyVideo(KsTopManDetailDTO param) {
        SpiderMethodType spiderMethodType = SpiderMethodType.KUAI_SHOU_DETAIL_BODY_VIDEO;
        KsTopManDetailVideoEntity result = null;
        String redisKey = "KsTopManDetailBodyVideo_" + param.getStarId();
        if (!"1".equals(param.getClearCache())) {
            result = (KsTopManDetailVideoEntity)this.redisUtil.get(redisKey);
        }
        HashMap<String, Object> apiParam = new HashMap<String, Object>(1);
        apiParam.put("starId", param.getStarId());
        if (result == null) {
            result = this.spiderApiUtil.postForEntity(spiderMethodType, apiParam, KsTopManDetailVideoEntity.class);
            this.redisUtil.set(redisKey, (Object)result, 14400L);
        } else if (!this.spiderApiUtil.checkCache(spiderMethodType, apiParam)) {
            SpiderApiUtil.taskExecutor.execute(() -> {
                param.setClearCache("1");
                this.getDetailBodyVideo(param);
            });
        }
        return result;
    }

    @Override
    public KsTopManDetailVideoAnalysisEntity getDetailBodyVideoNew(KsTopManDetailDTO param) {
        SpiderMethodType spiderMethodType = SpiderMethodType.KUAI_SHOU_DETAIL_BODY_VIDEO_ANALYSIS;
        KsTopManDetailVideoAnalysisEntity result = null;
        String redisKey = "KsTopManDetailBodyVideoAnalysis_" + param.getStarId() + "_" + param.getStarType();
        if (!"1".equals(param.getClearCache())) {
            result = (KsTopManDetailVideoAnalysisEntity)this.redisUtil.get(redisKey);
        }
        HashMap<String, Object> apiParam = new HashMap<String, Object>(2);
        apiParam.put("starId", param.getStarId());
        apiParam.put("starType", param.getStarType());
        if (result == null) {
            result = this.spiderApiUtil.postForEntity(spiderMethodType, apiParam, KsTopManDetailVideoAnalysisEntity.class);
            this.redisUtil.set(redisKey, (Object)result, 14400L);
        } else if (!this.spiderApiUtil.checkCache(spiderMethodType, apiParam)) {
            SpiderApiUtil.taskExecutor.execute(() -> {
                param.setClearCache("1");
                this.getDetailBodyVideoNew(param);
            });
        }
        return result;
    }

    @Override
    public KsTopManDetailFansEntity getDetailBodyFans(KsTopManDetailDTO param) {
        SpiderMethodType spiderMethodType = SpiderMethodType.KUAI_SHOU_DETAIL_BODY_FANS;
        KsTopManDetailFansEntity result = null;
        String redisKey = "KsTopManDetailBodyFans_" + param.getUserId() + "_" + param.getStarId() + "_" + param.getStarType();
        if (!"1".equals(param.getClearCache())) {
            result = (KsTopManDetailFansEntity)this.redisUtil.get(redisKey);
        }
        HashMap<String, Object> apiParam = new HashMap<String, Object>(3);
        apiParam.put("starType", StringUtils.isNotBlank((CharSequence)param.getStarType()) ? param.getStarType() : "1");
        apiParam.put("starId", param.getStarId());
        apiParam.put("userID", param.getUserId());
        if (result == null) {
            result = this.spiderApiUtil.postForEntity(spiderMethodType, apiParam, KsTopManDetailFansEntity.class);
            this.formatFansAnalysisData(result);
            KsTopManDetailHeadVO fansDataOther = this.spiderApiUtil.postForEntity(SpiderMethodType.KUAI_SHOU_DETAIL_HEAD_STAR_PROFILE, apiParam, KsTopManDetailHeadVO.class);
            this.fansTrendTranslation(fansDataOther, result);
            this.redisUtil.set(redisKey, (Object)result, 14400L);
        } else if (!this.spiderApiUtil.checkCache(spiderMethodType, apiParam)) {
            SpiderApiUtil.taskExecutor.execute(() -> {
                param.setClearCache("1");
                this.getDetailBodyFans(param);
            });
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    private void formatFansAnalysisData(KsTopManDetailFansEntity result) {
        if (result == null) {
            return;
        }
        HashMap<String, String> cityLine = new HashMap<String, String>(6);
        cityLine.put("firstline", "\u4e00\u7ebf");
        cityLine.put("newfirstline", "\u65b0\u4e00\u7ebf");
        cityLine.put("secondline", "\u4e8c\u7ebf");
        cityLine.put("thirdline", "\u4e09\u7ebf");
        cityLine.put("fourthline", "\u56db\u7ebf");
        cityLine.put("fifthline", "\u4e94\u7ebf");
        BigDecimal d100 = new BigDecimal(100);
        BigDecimal check = new BigDecimal(0);
        for (KsTopManDetailFansEntity.ViewData viewData : result.getCityPercentage()) {
            viewData.setLabel((String)cityLine.get(viewData.getLabel()));
            BigDecimal bigDecimal = viewData.getValue();
            viewData.setValue(bigDecimal.multiply(d100).setScale(2, RoundingMode.HALF_UP));
            if (check.compareTo(bigDecimal) >= 0) continue;
            check = bigDecimal;
            result.setCityPercentageOptimum(viewData);
        }
        BigDecimal check1 = new BigDecimal(0);
        for (KsTopManDetailFansEntity.ViewData viewData : result.getSexPercentage()) {
            BigDecimal bigDecimal = viewData.getValue();
            viewData.setValue(bigDecimal.multiply(d100).setScale(2, RoundingMode.HALF_UP));
            if (check1.compareTo(bigDecimal) >= 0) continue;
            check1 = bigDecimal;
            result.setSexPercentageOptimum(viewData);
        }
        BigDecimal bigDecimal = new BigDecimal(0);
        for (KsTopManDetailFansEntity.ViewData viewData : result.getAgePercentage()) {
            void var6_9;
            BigDecimal bigDecimal2 = viewData.getValue();
            viewData.setValue(bigDecimal2.multiply(d100).setScale(2, RoundingMode.HALF_UP));
            if (var6_9.compareTo(bigDecimal2) >= 0) continue;
            BigDecimal bigDecimal3 = bigDecimal2;
            result.setAgePercentageOptimum(viewData);
        }
        BigDecimal bigDecimal4 = new BigDecimal(0);
        for (KsTopManDetailFansEntity.ViewData viewData : result.getMobileBrandPercentage()) {
            void var7_16;
            BigDecimal bigDecimal5 = viewData.getValue();
            viewData.setValue(bigDecimal5.multiply(d100).setScale(2, RoundingMode.HALF_UP));
            if (var7_16.compareTo(bigDecimal5) >= 0) continue;
            BigDecimal bigDecimal6 = bigDecimal5;
            result.setMobileBrandPercentageOptimum(viewData);
        }
        BigDecimal bigDecimal7 = new BigDecimal(0);
        for (KsTopManDetailFansEntity.ViewData viewData : result.getMobilePricePercentage()) {
            void var8_23;
            BigDecimal value = viewData.getValue();
            viewData.setValue(value.multiply(d100).setScale(2, RoundingMode.HALF_UP));
            if (var8_23.compareTo(value) >= 0) continue;
            BigDecimal bigDecimal8 = value;
            result.setMobilePricePercentageOptimum(viewData);
        }
        BigDecimal bigDecimal9 = new BigDecimal(0);
        for (KsTopManDetailFansEntity.ViewData viewData : result.getAreaTopWithRadio()) {
            void var9_30;
            BigDecimal value = viewData.getValue();
            viewData.setValue(value.multiply(d100).setScale(2, RoundingMode.HALF_UP));
            if (var9_30.compareTo(value) >= 0) continue;
            BigDecimal bigDecimal10 = value;
            result.setAreaTopWithRadioOptimum(viewData);
        }
        BigDecimal bigDecimal11 = new BigDecimal(0);
        for (KsTopManDetailFansEntity.ViewData viewData : result.getAreaTopWithPermeation()) {
            void var10_37;
            BigDecimal value = viewData.getValue();
            viewData.setValue(value.multiply(d100).setScale(2, RoundingMode.HALF_UP));
            if (var10_37.compareTo(value) >= 0) continue;
            BigDecimal bigDecimal12 = value;
            result.setAreaTopWithPermeationOptimum(viewData);
        }
    }

    private void fansTrendTranslation(KsTopManDetailHeadVO fansDataOther, KsTopManDetailFansEntity result) {
        if (fansDataOther == null) {
            return;
        }
        if (fansDataOther.getFansData() != null) {
            KsTopManDetailHeadVO.FansData fansData = fansDataOther.getFansData();
            result.setFansIncreaseRateIn30(fansData.getFansIncreaseRateIn30());
            result.setFansIncreaseRateIn90(fansData.getFansIncreaseRateIn90());
            result.setFansInterestPercentage(fansData.getFansInterestPercentage());
            result.setCityDetailPercentage(fansData.getCityDetailPercentage());
            result.setStarActiveFansRateDtoList(fansData.getStarActiveFansRateDtoList());
        }
        Map<String, List<KsTopManDetailHeadVO.ViewData>> trendDataMap = fansDataOther.getStarProfileDict().getTrendData();
        Map<String, List<KsTopManDetailHeadVO.ViewData>> trendDiffDataMap = fansDataOther.getStarProfileDict().getTrendDiffData();
        String day = "90";
        if (trendDataMap != null) {
            for (String key : trendDataMap.keySet()) {
                List<KsTopManDetailHeadVO.ViewData> trendDatas;
                if (!day.equals(key) || !CollectionUtil.isNotEmpty(trendDatas = trendDataMap.get(key))) continue;
                ArrayList<KsTopManDetailFansEntity.ViewData> trend = new ArrayList<KsTopManDetailFansEntity.ViewData>(trendDatas.size());
                trendDatas.forEach(h -> {
                    KsTopManDetailFansEntity.ViewData data = new KsTopManDetailFansEntity.ViewData();
                    BeanUtils.copyProperties((Object)h, (Object)data);
                    trend.add(data);
                });
                result.setTrend(trend);
            }
        }
        if (trendDiffDataMap != null) {
            for (String key : trendDiffDataMap.keySet()) {
                List<KsTopManDetailHeadVO.ViewData> trendDiffDatas;
                if (!day.equals(key) || !CollectionUtil.isNotEmpty(trendDiffDatas = trendDiffDataMap.get(key))) continue;
                ArrayList<KsTopManDetailFansEntity.ViewData> trendDiff = new ArrayList<KsTopManDetailFansEntity.ViewData>(trendDiffDatas.size());
                trendDiffDatas.forEach(h -> {
                    KsTopManDetailFansEntity.ViewData data = new KsTopManDetailFansEntity.ViewData();
                    BeanUtils.copyProperties((Object)h, (Object)data);
                    trendDiff.add(data);
                });
                result.setTrendDiff(trendDiff);
            }
        }
    }

    @Override
    public KsTopManDetailGoodsEntity getDetailBodyGoodsCategory(KsTopManDetailDTO param) {
        SpiderMethodType spiderMethodType = SpiderMethodType.KUAI_SHOU_DETAIL_BODY_CHANNEL_LIST;
        KsTopManDetailGoodsEntity result = null;
        String redisKey = "KsTopManDetailBodyGoodsCategory_";
        if (!"1".equals(param.getClearCache())) {
            result = (KsTopManDetailGoodsEntity)this.redisUtil.get(redisKey);
        }
        HashMap<String, Object> apiParam = new HashMap<String, Object>(0);
        if (result == null) {
            result = this.spiderApiUtil.getForEntity(spiderMethodType, apiParam, KsTopManDetailGoodsEntity.class);
        } else if (!this.spiderApiUtil.checkCache(spiderMethodType, apiParam)) {
            SpiderApiUtil.taskExecutor.execute(() -> {
                param.setClearCache("1");
                this.getDetailBodyGoodsCategory(param);
            });
        }
        return result;
    }

    @Override
    public KsTopManDetailGoodsEntity getDetailBodyGoods(KsTopManDetailDTO param) {
        SpiderMethodType spiderMethodType = SpiderMethodType.KUAI_SHOU_DETAIL_BODY_GOODS;
        KsTopManDetailGoodsEntity result = null;
        String redisKey = "KsTopManDetailBodyGoods_" + param.getUserId() + "_" + param.getTimeRangeType();
        if (!"1".equals(param.getClearCache())) {
            result = (KsTopManDetailGoodsEntity)this.redisUtil.get(redisKey);
        }
        HashMap<String, Object> apiParam = new HashMap<String, Object>(2);
        apiParam.put("userID", param.getUserId());
        apiParam.put("timeRangeType", param.getTimeRangeType());
        if (result == null) {
            result = this.spiderApiUtil.postForEntity(spiderMethodType, apiParam, KsTopManDetailGoodsEntity.class);
        } else if (!this.spiderApiUtil.checkCache(spiderMethodType, apiParam)) {
            SpiderApiUtil.taskExecutor.execute(() -> {
                param.setClearCache("1");
                this.getDetailBodyGoods(param);
            });
        }
        return result;
    }

    @Override
    public KsTopManDetailGoodsItemEntity getDetailBodyGoodsItem(KsTopManDetailDTO param) {
        SpiderMethodType spiderMethodType = SpiderMethodType.KUAI_SHOU_DETAIL_BODY_GOODS_ITEM;
        KsTopManDetailGoodsItemEntity result = null;
        String redisKey = "KsTopManDetailBodyGoodsItem_" + param.getUserId() + "_" + param.getTimeRangeType() + "_" + param.getPage() + "_" + param.getPageSize();
        if (!"1".equals(param.getClearCache())) {
            result = (KsTopManDetailGoodsItemEntity)this.redisUtil.get(redisKey);
        }
        HashMap<String, Object> apiParam = new HashMap<String, Object>(4);
        apiParam.put("promoterId", param.getUserId());
        apiParam.put("timeRangeType", param.getTimeRangeType());
        apiParam.put("pageNum", param.getPage());
        apiParam.put("pageSize", param.getPageSize());
        if (result == null) {
            result = this.spiderApiUtil.postForEntity(spiderMethodType, apiParam, KsTopManDetailGoodsItemEntity.class);
        } else if (!this.spiderApiUtil.checkCache(spiderMethodType, apiParam)) {
            SpiderApiUtil.taskExecutor.execute(() -> {
                param.setClearCache("1");
                this.getDetailBodyGoodsItem(param);
            });
        }
        return result;
    }

    @Override
    public KsTopManDetailGoodsStoreEntity getDetailBodyGoodsStore(KsTopManDetailDTO param) {
        SpiderMethodType spiderMethodType = SpiderMethodType.KUAI_SHOU_DETAIL_BODY_GOODS_STORE;
        KsTopManDetailGoodsStoreEntity result = null;
        String redisKey = "KsTopManDetailBodyGoodsStore_" + param.getUserId() + "_" + param.getTimeRangeType() + "_" + param.getPage() + "_" + param.getPageSize();
        if (!"1".equals(param.getClearCache())) {
            result = (KsTopManDetailGoodsStoreEntity)this.redisUtil.get(redisKey);
        }
        HashMap<String, Object> apiParam = new HashMap<String, Object>(4);
        apiParam.put("promoterId", param.getUserId());
        apiParam.put("timeRangeType", param.getTimeRangeType());
        apiParam.put("pageNum", param.getPage());
        apiParam.put("pageSize", param.getPageSize());
        if (result == null) {
            result = this.spiderApiUtil.postForEntity(spiderMethodType, apiParam, KsTopManDetailGoodsStoreEntity.class);
        } else if (!this.spiderApiUtil.checkCache(spiderMethodType, apiParam)) {
            SpiderApiUtil.taskExecutor.execute(() -> {
                param.setClearCache("1");
                this.getDetailBodyGoodsStore(param);
            });
        }
        return result;
    }

    @Override
    public Map<?, ?> apiGetList(SimplePostRequestParam<KsTopManInformationDTO> topManDto) throws Exception {
        String column = topManDto.getColumn();
        String order = topManDto.getOrder();
        KsTopManInformationDTO filterInfo = (KsTopManInformationDTO)topManDto.getFilterInfo();
        Integer orderTabId = orderTag.get(order == null ? "default" : column);
        if (orderTabId == null) {
            throw new RuntimeException(I18nUtil.translate((String)"", (String)"\u8be5\u5b57\u6bb5\u65e0\u6cd5\u6392\u5e8f"));
        }
        KsSpiderApiIndexListVo ksSpiderApiIndexListVo = new KsSpiderApiIndexListVo(topManDto.getPageNo(), topManDto.getPageSize());
        String keyWord = topManDto.getKeyWord();
        if (keyWord != null && !"".equals(keyWord)) {
            ksSpiderApiIndexListVo.setUserName(keyWord);
        }
        ksSpiderApiIndexListVo.setStarOrderTag(orderTabId);
        if (!orderTabId.equals(3)) {
            ksSpiderApiIndexListVo.setStarOrderType("desc".equals(order) ? 2 : 1);
        }
        ksSpiderApiIndexListVo.setTaskType(Integer.parseInt(filterInfo.getTaskType()));
        KsTopManInformationDTO.ScreenItem screenItem = filterInfo.getScreenItem();
        if (screenItem != null) {
            List<KsTopManInformationDTO.ScreenItemField> contentType = screenItem.getContentType();
            ksSpiderApiIndexListVo.setContentTagIdList(this.handleTagList(contentType, "\u5185\u5bb9\u5206\u7c7b"));
            List<KsTopManInformationDTO.ScreenItemField> industry = screenItem.getIndustry();
            ksSpiderApiIndexListVo.setIndustryTagIdList(this.handleTagList(industry, "\u6240\u5c5e\u884c\u4e1a"));
            List<KsTopManInformationDTO.ScreenItemField> contentForm = screenItem.getContentForm();
            ksSpiderApiIndexListVo.setContentFormTagId(this.handleStringList(contentForm));
            List<KsTopManInformationDTO.ScreenItemField> starRecommendation = screenItem.getStarRecommendation();
            ksSpiderApiIndexListVo.setStarTagIds(this.handleStringList(starRecommendation));
            List<KsTopManInformationDTO.ScreenItemField> talentInfos = screenItem.getTalentInfo();
            this.initScreenItemField(talentInfos, ksSpiderApiIndexListVo);
            List<KsTopManInformationDTO.ScreenItemField> talentIndex = screenItem.getTalentIndex();
            this.initScreenItemField(talentIndex, ksSpiderApiIndexListVo);
            List<KsTopManInformationDTO.ScreenItemField> fanInfo = screenItem.getFanInfo();
            this.initScreenItemField(fanInfo, ksSpiderApiIndexListVo);
            List<KsTopManInformationDTO.ScreenItemField> contentPerformance = screenItem.getContentPerformance();
            this.initScreenItemField(contentPerformance, ksSpiderApiIndexListVo);
        }
        String json = JSON.toJSONString((Object)ksSpiderApiIndexListVo);
        return (Map)JSON.parseObject((String)json, Map.class);
    }

    private List<KsSpiderApiIndexListVo.Tag> handleTagList(List<KsTopManInformationDTO.ScreenItemField> screenItemFields, String name) {
        if (screenItemFields == null || screenItemFields.size() == 0) {
            return null;
        }
        return screenItemFields.stream().filter(a -> a.getStarTagId() != null).map(a -> {
            KsCategoryEntity suCategory;
            KsSpiderApiIndexListVo.Tag tag = new KsSpiderApiIndexListVo.Tag();
            tag.setId(a.getStarTagId());
            HashMap<String, String> param = new HashMap<String, String>(1);
            param.put("name", name);
            Map<String, KsCategoryEntity> category = this.cacheMongo(MongoCollectionType.TB_KS_CATEGORY, KsCategoryEntity.class, param);
            if (category != null && (suCategory = category.get(a.getStarTagId())) != null) {
                tag.setSubIds(suCategory.getSubTagsString());
            }
            return tag;
        }).collect(Collectors.toList());
    }

    private List<String> handleStringList(List<KsTopManInformationDTO.ScreenItemField> screenItemFields) {
        if (screenItemFields != null && screenItemFields.size() > 0) {
            return screenItemFields.stream().map(KsTopManInformationDTO.ScreenItemField::getStarTagId).collect(Collectors.toList());
        }
        return null;
    }

    private void initScreenItemField(List<KsTopManInformationDTO.ScreenItemField> screenItemFields, KsSpiderApiIndexListVo ksSpiderApiIndexListVo) throws Exception {
        if (screenItemFields == null || screenItemFields.size() == 0) {
            return;
        }
        block46: for (KsTopManInformationDTO.ScreenItemField screenItemField : screenItemFields) {
            String value = screenItemField.getValue();
            switch (screenItemField.getTitle()) {
                case "\u7c89\u4e1d\u6570\u91cf": {
                    this.handleMinMax(value, (VoidFunc1<BigDecimal>)((VoidFunc1 & Serializable)ksSpiderApiIndexListVo::setFansMinNum), (VoidFunc1<BigDecimal>)((VoidFunc1 & Serializable)ksSpiderApiIndexListVo::setFansMaxNum));
                    continue block46;
                }
                case "\u8fbe\u4eba\u62a5\u4ef7": {
                    this.handleMinMax(value, (VoidFunc1<BigDecimal>)((VoidFunc1 & Serializable)ksSpiderApiIndexListVo::setStarMinPrice), (VoidFunc1<BigDecimal>)((VoidFunc1 & Serializable)ksSpiderApiIndexListVo::setStarMaxPrice));
                    continue block46;
                }
                case "\u8fbe\u4eba\u6027\u522b": {
                    ksSpiderApiIndexListVo.setGender(value);
                    continue block46;
                }
                case "\u8fbe\u4eba\u5730\u57df": {
                    List strings = JSON.parseArray((String)value, String.class);
                    ksSpiderApiIndexListVo.setProvinceCode(Integer.parseInt((String)strings.get(0)));
                    ksSpiderApiIndexListVo.setCityCode(Integer.parseInt((String)strings.get(1)));
                    continue block46;
                }
                case "\u7efc\u5408\u6307\u6570": {
                    this.handleScope(value, (VoidFunc1<KsSpiderApiIndexListVo.Scope>)((VoidFunc1 & Serializable)ksSpiderApiIndexListVo::setStarIndex));
                    continue block46;
                }
                case "\u6da8\u7c89\u6307\u6570": {
                    this.handleScope(value, (VoidFunc1<KsSpiderApiIndexListVo.Scope>)((VoidFunc1 & Serializable)ksSpiderApiIndexListVo::setAddFansIndex));
                    continue block46;
                }
                case "\u521b\u4f5c\u6307\u6570": {
                    this.handleScope(value, (VoidFunc1<KsSpiderApiIndexListVo.Scope>)((VoidFunc1 & Serializable)ksSpiderApiIndexListVo::setCreateIndex));
                    continue block46;
                }
                case "\u6027\u4ef7\u6bd4": {
                    this.handleScope(value, (VoidFunc1<KsSpiderApiIndexListVo.Scope>)((VoidFunc1 & Serializable)ksSpiderApiIndexListVo::setPerformancePriceIndex));
                    continue block46;
                }
                case "\u5546\u4e1a\u6d3b\u8dc3\u5ea6": {
                    this.handleScope(value, (VoidFunc1<KsSpiderApiIndexListVo.Scope>)((VoidFunc1 & Serializable)ksSpiderApiIndexListVo::setBizActIndex));
                    continue block46;
                }
                case "\u5408\u4f5c\u6307\u6570": {
                    this.handleScope(value, (VoidFunc1<KsSpiderApiIndexListVo.Scope>)((VoidFunc1 & Serializable)ksSpiderApiIndexListVo::setCoopIndex));
                    continue block46;
                }
                case "\u7c89\u4e1d\u5e74\u9f84": {
                    this.handleRatioList(value, (VoidFunc1<List<KsSpiderApiIndexListVo.Ratio>>)((VoidFunc1 & Serializable)ksSpiderApiIndexListVo::setFansAgeList));
                    continue block46;
                }
                case "\u7c89\u4e1d\u6027\u522b": {
                    this.handleRatio(value, (VoidFunc1<KsSpiderApiIndexListVo.Ratio>)((VoidFunc1 & Serializable)ksSpiderApiIndexListVo::setFansGender));
                    continue block46;
                }
                case "\u7c89\u4e1d\u57ce\u5e02\u7ebf": {
                    this.handleRatioList(value, (VoidFunc1<List<KsSpiderApiIndexListVo.Ratio>>)((VoidFunc1 & Serializable)ksSpiderApiIndexListVo::setFansCityList));
                    continue block46;
                }
                case "\u7c89\u4e1d\u8bbe\u5907": {
                    this.handleRatio(value, (VoidFunc1<KsSpiderApiIndexListVo.Ratio>)((VoidFunc1 & Serializable)ksSpiderApiIndexListVo::setFansMobile));
                    continue block46;
                }
                case "\u9884\u8ba1CPM": {
                    this.handleMinMax(value, (VoidFunc1<BigDecimal>)((VoidFunc1 & Serializable)ksSpiderApiIndexListVo::setExpectCpmMinNum), (VoidFunc1<BigDecimal>)((VoidFunc1 & Serializable)ksSpiderApiIndexListVo::setExpectCpmMaxNum));
                    continue block46;
                }
                case "CPE": {
                    this.handleScope(value, (VoidFunc1<KsSpiderApiIndexListVo.Scope>)((VoidFunc1 & Serializable)ksSpiderApiIndexListVo::setExpectedCpe));
                    continue block46;
                }
                case "\u9884\u671f\u64ad\u653e\u91cf": {
                    this.handleMinMax(value, (VoidFunc1<BigDecimal>)((VoidFunc1 & Serializable)ksSpiderApiIndexListVo::setPhotoExpectPlayMinNum), (VoidFunc1<BigDecimal>)((VoidFunc1 & Serializable)ksSpiderApiIndexListVo::setPhotoExpectPlayMaxNum));
                    continue block46;
                }
                case "\u9884\u671f\u89c2\u770b\u4eba\u6570": {
                    this.handleMinMax(value, (VoidFunc1<BigDecimal>)((VoidFunc1 & Serializable)ksSpiderApiIndexListVo::setLiveAvgPeopleMinNum), (VoidFunc1<BigDecimal>)((VoidFunc1 & Serializable)ksSpiderApiIndexListVo::setLiveAvgPeopleMaxNum));
                    continue block46;
                }
                case "\u6700\u9ad8\u5728\u7ebf\u4eba\u6570": {
                    this.handleMinMax(value, (VoidFunc1<BigDecimal>)((VoidFunc1 & Serializable)ksSpiderApiIndexListVo::setLiveMaxViewerMinNum), (VoidFunc1<BigDecimal>)((VoidFunc1 & Serializable)ksSpiderApiIndexListVo::setLiveMaxViewerMaxNum));
                    continue block46;
                }
                case "\u4e92\u52a8\u7387": {
                    this.handleScopePercentage(value, (VoidFunc1<KsSpiderApiIndexListVo.Scope>)((VoidFunc1 & Serializable)ksSpiderApiIndexListVo::setPhotoInteractionRate));
                    continue block46;
                }
                case "\u5b8c\u64ad\u7387": {
                    this.handleScopePercentage(value, (VoidFunc1<KsSpiderApiIndexListVo.Scope>)((VoidFunc1 & Serializable)ksSpiderApiIndexListVo::setPhotoCompletePlayRate));
                    continue block46;
                }
            }
            throw new RuntimeException(I18nUtil.translate((String)"", (String)"\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u53c2\u6570\u7c7b\u578b"));
        }
    }

    private void handleScope(String value, VoidFunc1<KsSpiderApiIndexListVo.Scope> field) throws Exception {
        KsSpiderApiIndexListVo.Scope scope = new KsSpiderApiIndexListVo.Scope();
        this.handleMinMax(value, (VoidFunc1<BigDecimal>)((VoidFunc1 & Serializable)scope::setMin), (VoidFunc1<BigDecimal>)((VoidFunc1 & Serializable)scope::setMax));
        field.call((Object)scope);
    }

    private void handleMinMax(String value, VoidFunc1<BigDecimal> minField, VoidFunc1<BigDecimal> maxField) throws Exception {
        if (value == null) {
            return;
        }
        String[] split = value.split("-");
        switch (split.length) {
            case 0: {
                return;
            }
            case 2: {
                String max;
                String min = split[0];
                if (min != null && !"".equals(min)) {
                    minField.call((Object)new BigDecimal(split[0]));
                }
                if ((max = split[1]) == null || "".equals(max)) break;
                maxField.call((Object)new BigDecimal(split[1]));
                break;
            }
            case 1: {
                if (value.startsWith("-")) {
                    maxField.call((Object)new BigDecimal(split[0]));
                    break;
                }
                minField.call((Object)new BigDecimal(split[0]));
                break;
            }
            default: {
                throw new TopManException.TransferParamException.ParamFormatError(I18nUtil.translate((String)"", (String)"{}\u914d\u7f6e\u7684\u6570\u636e\u503c\u4e0d\u6b63\u786e\uff0c\u8bf7\u4f7f\u7528\u59820-9\u7c7b\u4f3c\u7684\u683c\u5f0f\uff0c\u5de6\u8fb9\u662f\u5f00\u59cb\u53f3\u8fb9\u662f\u7ed3\u675f\uff0c\u5de6\u53f3\u54ea\u8fb9\u4e0d\u9650\u5236\u5219\u7559\u7a7a\uff0c\u90fd\u4e0d\u9650\u5236\u5219\u4e3a-"));
            }
        }
    }

    private void handleScopePercentage(String value, VoidFunc1<KsSpiderApiIndexListVo.Scope> field) throws Exception {
        KsSpiderApiIndexListVo.Scope scope = new KsSpiderApiIndexListVo.Scope();
        this.handleMinMaxPercentage(value, (VoidFunc1<BigDecimal>)((VoidFunc1 & Serializable)scope::setMin), (VoidFunc1<BigDecimal>)((VoidFunc1 & Serializable)scope::setMax));
        field.call((Object)scope);
    }

    private void handleMinMaxPercentage(String value, VoidFunc1<BigDecimal> minField, VoidFunc1<BigDecimal> maxField) throws Exception {
        if (value == null) {
            return;
        }
        String[] split = value.split("-");
        switch (split.length) {
            case 0: {
                return;
            }
            case 2: {
                String max;
                String min = split[0];
                if (min != null && !"".equals(min)) {
                    BigDecimal minPercentage = new BigDecimal(split[0]).divide(new BigDecimal(100), 2, 4);
                    minField.call((Object)minPercentage);
                }
                if ((max = split[1]) == null || "".equals(max)) break;
                BigDecimal maxPercentage = new BigDecimal(split[1]).divide(new BigDecimal(100), 2, 4);
                maxField.call((Object)maxPercentage);
                break;
            }
            case 1: {
                if (value.startsWith("-")) {
                    maxField.call((Object)new BigDecimal(split[0]));
                    break;
                }
                minField.call((Object)new BigDecimal(split[0]));
                break;
            }
            default: {
                throw new TopManException.TransferParamException.ParamFormatError(I18nUtil.translate((String)"", (String)"{}\u914d\u7f6e\u7684\u6570\u636e\u503c\u4e0d\u6b63\u786e\uff0c\u8bf7\u4f7f\u7528\u59820-9\u7c7b\u4f3c\u7684\u683c\u5f0f\uff0c\u5de6\u8fb9\u662f\u5f00\u59cb\u53f3\u8fb9\u662f\u7ed3\u675f\uff0c\u5de6\u53f3\u54ea\u8fb9\u4e0d\u9650\u5236\u5219\u7559\u7a7a\uff0c\u90fd\u4e0d\u9650\u5236\u5219\u4e3a-"));
            }
        }
    }

    private void handleRatio(String value, VoidFunc1<KsSpiderApiIndexListVo.Ratio> field) throws Exception {
        if (value == null || "".equals(value)) {
            return;
        }
        field.call((Object)new KsSpiderApiIndexListVo.Ratio(value));
    }

    private void handleRatioList(String value, VoidFunc1<List<KsSpiderApiIndexListVo.Ratio>> field) throws Exception {
        if (value == null || "".equals(value)) {
            return;
        }
        field.call(Collections.singletonList(new KsSpiderApiIndexListVo.Ratio(value)));
    }

    @Override
    public String formatRegion(Integer provinceCode, Integer cityCode) {
        HashMap<String, String> param = new HashMap<String, String>(2);
        param.put("name", "\u8fbe\u4eba\u4fe1\u606f");
        param.put("sec_name", "\u8fbe\u4eba\u5730\u57df");
        Map<String, KsRegionEntity> region = this.cacheMongo(MongoCollectionType.TB_KS_CATEGORY, KsRegionEntity.class, param);
        if (CollectionUtil.isEmpty(region) || region.get(String.valueOf(provinceCode)) == null) {
            return null;
        }
        KsRegionEntity province = region.get(String.valueOf(provinceCode));
        List<KsRegionEntity.KsCityEntity> cityList = province.getCitys();
        String regionString = province.getProvinceName();
        for (KsRegionEntity.KsCityEntity city : cityList) {
            if (!city.getCityCode().equals(String.valueOf(cityCode))) continue;
            regionString = regionString + "-" + city.getCityName();
            break;
        }
        return regionString;
    }

    private <T extends MongoEntityService> Map<String, T> cacheMongo(MongoCollectionType collectionType, Class<T> beanClass, Map<String, String> param) {
        if (beanClass == null || collectionType.getRedisKeyPre() == null) {
            return null;
        }
        StringBuilder redisKey = new StringBuilder(collectionType.getRedisKeyPre());
        for (String value : param.values()) {
            redisKey.append("_").append(value);
        }
        Map<String, T> result = (Map<String, T>)this.redisUtil.get(redisKey.toString());
        if (result == null) {
            result = this.mongoHandleService.handleMongo(collectionType, param, beanClass);
            this.redisUtil.set(redisKey.toString(), result, (long)collectionType.getCacheTime().intValue());
        }
        return result;
    }

    static {
        Field[] declaredFields;
        log = LoggerFactory.getLogger(KsTopManInformationServiceImpl.class);
        orderTag = new HashMap<String, Integer>(10);
        orderTag.put("default", 3);
        orderTag.put(null, 3);
        Class<KsTopManVO> ksTopManResultEntityClass = KsTopManVO.class;
        for (Field declaredField : declaredFields = ksTopManResultEntityClass.getDeclaredFields()) {
            OrderTagId annotation = declaredField.getAnnotation(OrderTagId.class);
            if (annotation == null) continue;
            orderTag.put(declaredField.getName(), annotation.value());
        }
    }

    public static class AddedAndCollect {
        private LoginUser loginUser;
        private String platform;
        private Collection<String> topManIds;
        private String topManId;
        private String isAdded;
        private String isCollect;

        public LoginUser getLoginUser() {
            return this.loginUser;
        }

        public String getPlatform() {
            return this.platform;
        }

        public Collection<String> getTopManIds() {
            return this.topManIds;
        }

        public String getTopManId() {
            return this.topManId;
        }

        public String getIsAdded() {
            return this.isAdded;
        }

        public String getIsCollect() {
            return this.isCollect;
        }

        public void setLoginUser(LoginUser loginUser) {
            this.loginUser = loginUser;
        }

        public void setPlatform(String platform) {
            this.platform = platform;
        }

        public void setTopManIds(Collection<String> topManIds) {
            this.topManIds = topManIds;
        }

        public void setTopManId(String topManId) {
            this.topManId = topManId;
        }

        public void setIsAdded(String isAdded) {
            this.isAdded = isAdded;
        }

        public void setIsCollect(String isCollect) {
            this.isCollect = isCollect;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AddedAndCollect)) {
                return false;
            }
            AddedAndCollect other = (AddedAndCollect)o;
            if (!other.canEqual(this)) {
                return false;
            }
            LoginUser this$loginUser = this.getLoginUser();
            LoginUser other$loginUser = other.getLoginUser();
            if (this$loginUser == null ? other$loginUser != null : !this$loginUser.equals(other$loginUser)) {
                return false;
            }
            String this$platform = this.getPlatform();
            String other$platform = other.getPlatform();
            if (this$platform == null ? other$platform != null : !this$platform.equals(other$platform)) {
                return false;
            }
            Collection<String> this$topManIds = this.getTopManIds();
            Collection<String> other$topManIds = other.getTopManIds();
            if (this$topManIds == null ? other$topManIds != null : !((Object)this$topManIds).equals(other$topManIds)) {
                return false;
            }
            String this$topManId = this.getTopManId();
            String other$topManId = other.getTopManId();
            if (this$topManId == null ? other$topManId != null : !this$topManId.equals(other$topManId)) {
                return false;
            }
            String this$isAdded = this.getIsAdded();
            String other$isAdded = other.getIsAdded();
            if (this$isAdded == null ? other$isAdded != null : !this$isAdded.equals(other$isAdded)) {
                return false;
            }
            String this$isCollect = this.getIsCollect();
            String other$isCollect = other.getIsCollect();
            return !(this$isCollect == null ? other$isCollect != null : !this$isCollect.equals(other$isCollect));
        }

        protected boolean canEqual(Object other) {
            return other instanceof AddedAndCollect;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            LoginUser $loginUser = this.getLoginUser();
            result = result * 59 + ($loginUser == null ? 43 : $loginUser.hashCode());
            String $platform = this.getPlatform();
            result = result * 59 + ($platform == null ? 43 : $platform.hashCode());
            Collection<String> $topManIds = this.getTopManIds();
            result = result * 59 + ($topManIds == null ? 43 : ((Object)$topManIds).hashCode());
            String $topManId = this.getTopManId();
            result = result * 59 + ($topManId == null ? 43 : $topManId.hashCode());
            String $isAdded = this.getIsAdded();
            result = result * 59 + ($isAdded == null ? 43 : $isAdded.hashCode());
            String $isCollect = this.getIsCollect();
            result = result * 59 + ($isCollect == null ? 43 : $isCollect.hashCode());
            return result;
        }

        public String toString() {
            return "KsTopManInformationServiceImpl.AddedAndCollect(loginUser=" + this.getLoginUser() + ", platform=" + this.getPlatform() + ", topManIds=" + this.getTopManIds() + ", topManId=" + this.getTopManId() + ", isAdded=" + this.getIsAdded() + ", isCollect=" + this.getIsCollect() + ")";
        }
    }
}

