/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.topman.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import com.els.common.exception.ELSBootException;
import com.els.common.util.I18nUtil;
import com.els.modules.topman.dto.DouYinTopManDetailDTO;
import com.els.modules.topman.dto.KsTopManDetailDTO;
import com.els.modules.topman.dto.RedBookTopManDetailDTO;
import com.els.modules.topman.dto.TopManContrastDTO;
import com.els.modules.topman.dto.TopManContrastParamDTO;
import com.els.modules.topman.dto.ZhiHuTopManDetailDTO;
import com.els.modules.topman.entity.BStationTopManInformationFanAnalysisEntity;
import com.els.modules.topman.entity.BStationTopManInformationPromotionAnalysisEntity;
import com.els.modules.topman.entity.BStationTopManInformationTopDetailsEntity;
import com.els.modules.topman.entity.BlogTopManInformationFanAnalysisEntity;
import com.els.modules.topman.entity.BlogTopManInformationPromotionAnalysisEntity;
import com.els.modules.topman.entity.BlogTopManInformationTopDetailsEntity;
import com.els.modules.topman.entity.DouYinTopManInformationFanAnalysisEntity;
import com.els.modules.topman.entity.DouYinTopManInformationVideoDetailsAnalysisEntity;
import com.els.modules.topman.entity.TopManResultDetailBody;
import com.els.modules.topman.entity.TopManResultDetailBodyBase;
import com.els.modules.topman.enumerate.BlogTopmanGenderEnum;
import com.els.modules.topman.enumerate.BlogVerifiedTypeEnum;
import com.els.modules.topman.service.BStationTopManInformationService;
import com.els.modules.topman.service.BlogTopManInformationService;
import com.els.modules.topman.service.KuaiShouTopManInformationService;
import com.els.modules.topman.service.RedBookTopManInformationService;
import com.els.modules.topman.service.TopManContrastService;
import com.els.modules.topman.service.TopManInformationService;
import com.els.modules.topman.service.ZhiHuTopManInformationService;
import com.els.modules.topman.utils.spider.entity.KsTopManDetailBaseEntity;
import com.els.modules.topman.utils.spider.entity.KsTopManDetailFansEntity;
import com.els.modules.topman.utils.spider.entity.KsTopManDetailVideoAnalysisEntity;
import com.els.modules.topman.utils.spider.vo.KsTopManDetailHeadVO;
import com.els.modules.topman.utils.spider.vo.RedBookTopManDetailHeadVO;
import com.els.modules.topman.utils.spider.vo.ZhiHuManDetailHeadVO;
import com.els.modules.topman.vo.BiliTopManContrastVO;
import com.els.modules.topman.vo.BlogTopManContrastVO;
import com.els.modules.topman.vo.DyTopManContrastVO;
import com.els.modules.topman.vo.DyTopManFansDatasContrastVO;
import com.els.modules.topman.vo.DyTopManVO;
import com.els.modules.topman.vo.KsTopManContrastVO;
import com.els.modules.topman.vo.RbTopManContrastVO;
import com.els.modules.topman.vo.TopManContrastVO;
import com.els.modules.topman.vo.TopManDetailHeadVO;
import com.els.modules.topman.vo.ZhTopManContrastVO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TopManContrastServiceImpl
implements TopManContrastService {
    @Autowired
    private TopManInformationService douyinTopManInformationService;
    @Autowired
    private KuaiShouTopManInformationService kuaiShouTopManInformationService;
    @Autowired
    private RedBookTopManInformationService redBookTopManInformationService;
    @Autowired
    private BStationTopManInformationService bStationTopManInformationService;
    @Autowired
    private BlogTopManInformationService blogTopManInformationService;
    @Autowired
    private ZhiHuTopManInformationService zhiHuTopManInformationService;

    @Override
    public List<TopManContrastVO> contrastTopMan(TopManContrastDTO dto) {
        ArrayList<TopManContrastVO> list = new ArrayList<TopManContrastVO>(3);
        if (dto == null || CollectionUtil.isEmpty(dto.getParamList())) {
            return list;
        }
        List<TopManContrastParamDTO> paramList = dto.getParamList();
        if (paramList.size() > 3) {
            paramList = paramList.subList(0, 3);
        }
        switch (dto.getPlatform()) {
            case "1": {
                paramList.forEach(h -> {
                    DouYinTopManDetailDTO dyDTO = this.dyDtoTransfer((TopManContrastParamDTO)h);
                    dyDTO.setClearCache(dto.getClearCache());
                    list.add(this.douyinTopManInformationService.getTopmanScore(dyDTO));
                });
                break;
            }
            case "2": {
                paramList.forEach(h -> list.add(this.kuaiShouTopManInformationService.getByUserId(h.getTopManId())));
                break;
            }
            case "3": {
                paramList.forEach(h -> {
                    RedBookTopManDetailDTO rbDTO = this.rbDtoTransfer((TopManContrastParamDTO)h);
                    rbDTO.setClearCache(dto.getClearCache());
                    list.add(this.redBookTopManInformationService.getDetailHead(rbDTO));
                });
                break;
            }
            case "4": {
                paramList.forEach(h -> list.add(this.bStationTopManInformationService.bStationTopManDetails(h.getStationId(), h.getTopManId())));
                break;
            }
            case "5": {
                paramList.forEach(h -> list.add(this.blogTopManInformationService.blogTopManDetails(h.getTopManId())));
                break;
            }
            case "6": {
                paramList.forEach(h -> {
                    ZhiHuTopManDetailDTO zhDTO = this.zhDtoTransfer((TopManContrastParamDTO)h);
                    zhDTO.setClearCache(dto.getClearCache());
                    list.add(this.zhiHuTopManInformationService.getDetailHead(zhDTO));
                });
                break;
            }
            default: {
                throw new ELSBootException(I18nUtil.translate((String)"", (String)"\u672a\u627e\u5230\u8be5\u8bf7\u6c42\u7c7b\u578b"));
            }
        }
        return list;
    }

    private DouYinTopManDetailDTO dyDtoTransfer(TopManContrastParamDTO dto) {
        DouYinTopManDetailDTO dyDTO = new DouYinTopManDetailDTO();
        dyDTO.setTopManId(dto.getTopManId());
        dyDTO.setTopManName(dto.getTopManName());
        dyDTO.setTopmanRegion(dto.getTopmanRegion());
        dyDTO.setAvatar(dto.getAvatar());
        return dyDTO;
    }

    private DouYinTopManDetailDTO dyDtoTransferNew(DyTopManVO dto) {
        DouYinTopManDetailDTO dyDTO = new DouYinTopManDetailDTO();
        dyDTO.setTopManId(dto.getUid());
        dyDTO.setTopManName(dto.getTopmanName());
        dyDTO.setTopmanRegion(dto.getTopmanRegion());
        dyDTO.setAvatar(dto.getAvatar());
        return dyDTO;
    }

    private KsTopManDetailDTO ksDtoTransfer(TopManContrastParamDTO dto) {
        KsTopManDetailDTO dyDTO = new KsTopManDetailDTO();
        dyDTO.setUserId(dto.getUserId());
        dyDTO.setStarId(dto.getStarId());
        dyDTO.setStarType(dto.getStarType());
        dyDTO.setTimeRangeType(1);
        return dyDTO;
    }

    private RedBookTopManDetailDTO rbDtoTransfer(TopManContrastParamDTO dto) {
        RedBookTopManDetailDTO rbDTO = new RedBookTopManDetailDTO();
        rbDTO.setUserId(dto.getTopManId());
        rbDTO.setDateType("1");
        return rbDTO;
    }

    private ZhiHuTopManDetailDTO zhDtoTransfer(TopManContrastParamDTO dto) {
        ZhiHuTopManDetailDTO zhDTO = new ZhiHuTopManDetailDTO();
        zhDTO.setPlatform("6");
        zhDTO.setPuId(dto.getTopManId());
        return zhDTO;
    }

    @Override
    public TopManContrastVO dyTopManContrast(TopManContrastDTO dto) {
        DyTopManContrastVO vo = new DyTopManContrastVO();
        List<DyTopManVO> paramList = this.contrastDtoTransferDy(dto);
        switch (dto.getTaskType()) {
            case "baseData": {
                this.getDyBaseData(paramList, dto.getClearCache(), vo);
                break;
            }
            case "videoData": {
                this.getDyVideoData(paramList, dto.getClearCache(), vo);
                break;
            }
            case "fansDataOld": {
                this.getDyFansDataOld(paramList, dto.getClearCache(), vo);
                break;
            }
            case "fansData": {
                this.getDyFansData(paramList, dto.getClearCache(), vo);
                break;
            }
            case "goodsData": {
                this.getDyGoodsData(paramList, dto.getClearCache(), vo);
                break;
            }
            default: {
                throw new ELSBootException(I18nUtil.translate((String)"", (String)"\u672a\u627e\u5230\u8be5\u8bf7\u6c42\u7c7b\u578b"));
            }
        }
        return vo;
    }

    private void getDyGoodsData(List<DyTopManVO> paramList, String clearCache, DyTopManContrastVO vo) {
        ArrayList<TopManDetailHeadVO.TopManCoreData> goodsDatas = new ArrayList<TopManDetailHeadVO.TopManCoreData>(paramList.size());
        paramList.forEach(h -> {
            DouYinTopManDetailDTO dyDTO = this.dyDtoTransferNew((DyTopManVO)h);
            dyDTO.setClearCache(clearCache);
            TopManDetailHeadVO coreData = this.douyinTopManInformationService.queryDetailHeadCore(dyDTO);
            if (coreData != null) {
                TopManDetailHeadVO.TopManCoreData topManCoreData = coreData.getTopManCoreData();
                dyDTO.setBodyType("base");
                dyDTO.setPopularizeType("1");
                dyDTO.setStatisticsDateType("30d");
                TopManResultDetailBody goodsData = this.douyinTopManInformationService.queryDetailBody(dyDTO);
                if (topManCoreData != null && goodsData != null) {
                    TopManResultDetailBodyBase bodyBase = (TopManResultDetailBodyBase)goodsData;
                    List categoryNames = CollectionUtil.isNotEmpty(bodyBase.getCategoryAnalysisData()) ? bodyBase.getCategoryAnalysisData().stream().map(TopManResultDetailBodyBase.popularizeAnalysisEntity::getCategory).collect(Collectors.toList()) : null;
                    List brandNames = CollectionUtil.isNotEmpty(bodyBase.getBrandAnalysisData()) ? bodyBase.getBrandAnalysisData().stream().map(TopManResultDetailBodyBase.popularizeAnalysisEntity::getBrand).collect(Collectors.toList()) : null;
                    topManCoreData.setCategoryAnalysisData(CollectionUtil.isNotEmpty(categoryNames) ? StrUtil.join((CharSequence)"\u3001", categoryNames) : "-");
                    topManCoreData.setBrandAnalysisData(CollectionUtil.isNotEmpty(brandNames) ? StrUtil.join((CharSequence)"\u3001", brandNames) : "-");
                }
                if (topManCoreData != null) {
                    topManCoreData.setTopmanAvatar(h.getAvatar());
                    topManCoreData.setTopManName(h.getTopmanName());
                }
                goodsDatas.add(topManCoreData);
            }
        });
        vo.setGoodsDatas(goodsDatas);
    }

    private void getDyFansData(List<DyTopManVO> paramList, String clearCache, DyTopManContrastVO vo) {
        ArrayList<DyTopManFansDatasContrastVO> fansDatas = new ArrayList<DyTopManFansDatasContrastVO>(paramList.size());
        paramList.forEach(h -> {
            DouYinTopManDetailDTO dyDTO = this.dyDtoTransferNew((DyTopManVO)h);
            dyDTO.setClearCache(clearCache);
            DouYinTopManInformationFanAnalysisEntity fansAnalysis = (DouYinTopManInformationFanAnalysisEntity)this.douyinTopManInformationService.queryDetailsFanAnalysis(h.getTopManId(), "0", "1");
            if (fansAnalysis != null) {
                DyTopManFansDatasContrastVO fansData = new DyTopManFansDatasContrastVO();
                List<DyTopManFansDatasContrastVO.Tag> gender = this.getDyFansDataTag(fansAnalysis.getGender(), false);
                fansData.setGender(gender);
                List<DyTopManFansDatasContrastVO.Tag> age = this.getDyFansDataTag(fansAnalysis.getAge(), false);
                fansData.setAge(age);
                List<DyTopManFansDatasContrastVO.Tag> activity = this.getDyFansDataTag(fansAnalysis.getActivity(), false);
                fansData.setActivity(activity);
                List<DyTopManFansDatasContrastVO.Tag> cityLevel = this.getDyFansDataTag(fansAnalysis.getCityLevel(), true);
                fansData.setCityLevel(cityLevel);
                List<DyTopManFansDatasContrastVO.Tag> province = this.getDyFansDataProvinceTag(fansAnalysis.getProvince());
                fansData.setProvince(province);
                List<DyTopManFansDatasContrastVO.Tag> guestPrice = this.getDyFansDataTag(fansAnalysis.getGuestPrice(), false);
                fansData.setGuestPrice(guestPrice);
                List<DyTopManFansDatasContrastVO.Tag> category = this.getDyFansDataTag(fansAnalysis.getCategory(), true);
                fansData.setCategory(category);
                fansData.setTopmanAvatar(h.getAvatar());
                fansData.setTopManName(h.getTopmanName());
                fansDatas.add(fansData);
            }
        });
        vo.setFansDatas(fansDatas);
    }

    private List<DyTopManFansDatasContrastVO.Tag> getDyFansDataTag(DouYinTopManInformationFanAnalysisEntity.FanCommonAttribute entity, boolean flag) {
        if (entity == null || CollectionUtil.isEmpty(entity.getX())) {
            return null;
        }
        List<String> x = entity.getX();
        if (flag && x.size() > 3) {
            x = x.subList(0, 3);
        }
        ArrayList<DyTopManFansDatasContrastVO.Tag> tags = new ArrayList<DyTopManFansDatasContrastVO.Tag>(x.size());
        for (int i = 0; i < x.size(); ++i) {
            DyTopManFansDatasContrastVO.Tag tag = new DyTopManFansDatasContrastVO.Tag();
            tag.setX(x.get(i));
            tag.setY(entity.getY().get(i));
            tags.add(tag);
        }
        return tags;
    }

    private List<DyTopManFansDatasContrastVO.Tag> getDyFansDataProvinceTag(List<DouYinTopManInformationFanAnalysisEntity.Region> list) {
        if (CollectionUtil.isEmpty(list)) {
            return null;
        }
        if (list.size() > 3) {
            list = list.subList(0, 3);
        }
        ArrayList<DyTopManFansDatasContrastVO.Tag> tags = new ArrayList<DyTopManFansDatasContrastVO.Tag>(list.size());
        list.forEach(h -> {
            DyTopManFansDatasContrastVO.Tag tag = new DyTopManFansDatasContrastVO.Tag();
            tag.setX(h.getX());
            tag.setY(h.getY().toPlainString());
            tags.add(tag);
        });
        return tags;
    }

    private void getDyFansDataOld(List<DyTopManVO> paramList, String clearCache, DyTopManContrastVO vo) {
        ArrayList<DouYinTopManInformationFanAnalysisEntity> fansDatas = new ArrayList<DouYinTopManInformationFanAnalysisEntity>(paramList.size());
        paramList.forEach(h -> {
            DouYinTopManDetailDTO dyDTO = this.dyDtoTransferNew((DyTopManVO)h);
            dyDTO.setClearCache(clearCache);
            DouYinTopManInformationFanAnalysisEntity fansData = (DouYinTopManInformationFanAnalysisEntity)this.douyinTopManInformationService.queryDetailsFanAnalysis(h.getTopManId(), "0", "1");
            if (fansData != null) {
                fansData.setTopmanAvatar(h.getAvatar());
                fansData.setTopManName(h.getTopmanName());
                fansDatas.add(fansData);
            }
        });
        vo.setFansDatasOld(fansDatas);
    }

    private void getDyVideoData(List<DyTopManVO> paramList, String clearCache, DyTopManContrastVO vo) {
        ArrayList<TopManDetailHeadVO.TopManVideoData> videoDatas = new ArrayList<TopManDetailHeadVO.TopManVideoData>(paramList.size());
        ArrayList<TopManDetailHeadVO.TopManLiveData> liveDatas = new ArrayList<TopManDetailHeadVO.TopManLiveData>(paramList.size());
        paramList.forEach(h -> {
            DouYinTopManDetailDTO dyDTO = this.dyDtoTransferNew((DyTopManVO)h);
            dyDTO.setClearCache(clearCache);
            TopManDetailHeadVO headVO = this.douyinTopManInformationService.queryDetailHeadCore(dyDTO);
            if (headVO != null) {
                TopManDetailHeadVO.TopManVideoData topManVideoData = headVO.getTopManVideoData();
                DouYinTopManInformationVideoDetailsAnalysisEntity videoData = this.douyinTopManInformationService.queryDetailsVideoAnalysis(h.getTopManId(), "true");
                if (topManVideoData != null && videoData != null && videoData.getVideoDetails() != null) {
                    DouYinTopManInformationVideoDetailsAnalysisEntity.VideoDetails videoDetails = videoData.getVideoDetails();
                    topManVideoData.setCompletionRate(videoDetails.getCompletionRate());
                    topManVideoData.setInteractRate(videoDetails.getInteractRate());
                }
                if (topManVideoData != null) {
                    topManVideoData.setTopmanAvatar(h.getAvatar());
                    topManVideoData.setTopManName(h.getTopmanName());
                }
                videoDatas.add(topManVideoData);
                TopManDetailHeadVO.TopManLiveData topManLiveData = headVO.getTopManLiveData();
                if (topManLiveData != null) {
                    topManLiveData.setTopmanAvatar(h.getAvatar());
                    topManLiveData.setTopManName(h.getTopmanName());
                }
                liveDatas.add(topManLiveData);
            }
        });
        vo.setVideoDatas(videoDatas);
        vo.setLiveDatas(liveDatas);
    }

    private void getDyBaseData(List<DyTopManVO> paramList, String clearCache, DyTopManContrastVO vo) {
        ArrayList<TopManDetailHeadVO.TopManBaseData> baseDatas = new ArrayList<TopManDetailHeadVO.TopManBaseData>(paramList.size());
        paramList.forEach(h -> {
            DouYinTopManDetailDTO dyDTO = this.dyDtoTransferNew((DyTopManVO)h);
            dyDTO.setClearCache(clearCache);
            TopManDetailHeadVO detailHead = this.getDyHeadData(dyDTO);
            TopManDetailHeadVO.TopManBaseData topManBaseData = detailHead.getTopManBaseData();
            if (topManBaseData == null) {
                topManBaseData = new TopManDetailHeadVO.TopManBaseData();
                this.topManBaseDataConverter((DyTopManVO)h, topManBaseData);
            } else {
                topManBaseData.setAgency(StringUtils.isNotBlank((CharSequence)topManBaseData.getAgency()) ? topManBaseData.getAgency() : "\u672a\u7b7e\u7ea6");
                this.topManBaseDataConverter((DyTopManVO)h, topManBaseData);
            }
            baseDatas.add(topManBaseData);
        });
        vo.setBaseDatas(baseDatas);
    }

    private void topManBaseDataConverter(DyTopManVO h, TopManDetailHeadVO.TopManBaseData topManBaseData) {
        topManBaseData.setTopManId(h.getTopManId());
        topManBaseData.setTopmanAvatar(h.getAvatar());
        topManBaseData.setTopManName(h.getTopmanName());
        topManBaseData.setTopManLevel(h.getTopmanLevel());
        topManBaseData.setTopManSex(h.getTopmanGender());
        topManBaseData.setTopManRegion(h.getTopmanRegion());
        topManBaseData.setFansNum(h.getFansNum().toPlainString());
    }

    private TopManDetailHeadVO getDyHeadData(DouYinTopManDetailDTO dyDTO) {
        try {
            TopManDetailHeadVO detailHead = this.douyinTopManInformationService.getTopmanScore(dyDTO);
            if (detailHead != null) {
                return detailHead;
            }
            return new TopManDetailHeadVO();
        }
        catch (Exception e) {
            return new TopManDetailHeadVO();
        }
    }

    @Override
    public TopManContrastVO ksTopManContrast(TopManContrastDTO dto) {
        KsTopManContrastVO vo = new KsTopManContrastVO();
        List<TopManContrastParamDTO> paramList = this.contrastDtoTransfer(dto);
        switch (dto.getTaskType()) {
            case "baseData": {
                this.getKsBaseData(paramList, dto.getClearCache(), vo);
                break;
            }
            case "videoData": {
                this.getKsVideoData(paramList, dto.getClearCache(), vo);
                break;
            }
            case "fansData": {
                this.getKsFansData(paramList, dto.getClearCache(), vo);
                break;
            }
            case "goodsData": {
                this.getKsGoodsData(paramList, dto.getClearCache(), vo);
                break;
            }
            default: {
                throw new ELSBootException(I18nUtil.translate((String)"", (String)"\u672a\u627e\u5230\u8be5\u8bf7\u6c42\u7c7b\u578b"));
            }
        }
        return vo;
    }

    private void getKsGoodsData(List<TopManContrastParamDTO> paramList, String clearCache, KsTopManContrastVO vo) {
        ArrayList<KsTopManDetailBaseEntity.KeyData> goodsDatas = new ArrayList<KsTopManDetailBaseEntity.KeyData>(paramList.size());
        for (TopManContrastParamDTO h : paramList) {
            KsTopManDetailDTO ksDTO = this.ksDtoTransfer(h);
            ksDTO.setClearCache(clearCache);
            KsTopManDetailHeadVO detailHead = this.getKsHeadData(ksDTO);
            KsTopManDetailBaseEntity goodsData = this.kuaiShouTopManInformationService.getDetailBodyBase(ksDTO);
            if (goodsData == null) continue;
            KsTopManDetailBaseEntity.KeyData keyData = goodsData.getKeyData();
            KsTopManDetailBaseEntity.CommerceCapacity commerceCapacity = goodsData.getCommerceCapacity();
            if (keyData != null && commerceCapacity != null) {
                KsTopManDetailHeadVO.CoreData coreData;
                List channelNames = CollectionUtil.isNotEmpty(commerceCapacity.getHotSaleChannelInfo()) ? commerceCapacity.getHotSaleChannelInfo().stream().map(KsTopManDetailBaseEntity.HotSaleChannelInfo::getHotSaleChannelName).collect(Collectors.toList()) : null;
                List brandNames = CollectionUtil.isNotEmpty(commerceCapacity.getHotSaleBrandInfo()) ? commerceCapacity.getHotSaleBrandInfo().stream().map(KsTopManDetailBaseEntity.HotSaleBrandInfo::getHotSaleBrandTitle).collect(Collectors.toList()) : null;
                keyData.setHotSaleChannelInfo(CollectionUtil.isNotEmpty(channelNames) ? StrUtil.join((CharSequence)"\u3001", channelNames) : "-");
                keyData.setHotSaleBrandInfo(CollectionUtil.isNotEmpty(brandNames) ? StrUtil.join((CharSequence)"\u3001", brandNames) : "-");
                KsTopManDetailHeadVO.StarProfileDict starProfileDict = detailHead.getStarProfileDict();
                if (starProfileDict != null) {
                    keyData.setHeadUrl(starProfileDict.getHeadUrl());
                    keyData.setName(starProfileDict.getName());
                }
                if ((coreData = detailHead.getCoreData()) != null) {
                    keyData.setPromoteItemCount(coreData.getPromoteItemCount() != null ? coreData.getPromoteItemCount().toPlainString() : "-");
                }
            }
            goodsDatas.add(keyData);
        }
        vo.setGoodsDatas(goodsDatas);
    }

    private void getKsFansData(List<TopManContrastParamDTO> paramList, String clearCache, KsTopManContrastVO vo) {
        ArrayList<KsTopManDetailFansEntity> fansDatas = new ArrayList<KsTopManDetailFansEntity>(paramList.size());
        paramList.forEach(h -> {
            KsTopManDetailDTO ksDTO = this.ksDtoTransfer((TopManContrastParamDTO)h);
            ksDTO.setClearCache(clearCache);
            KsTopManDetailHeadVO detailHead = this.getKsHeadData(ksDTO);
            KsTopManDetailFansEntity fansData = this.kuaiShouTopManInformationService.getDetailBodyFans(ksDTO);
            if (fansData != null) {
                KsTopManDetailHeadVO.StarProfileDict starProfileDict = detailHead.getStarProfileDict();
                if (starProfileDict != null) {
                    fansData.setHeadUrl(starProfileDict.getHeadUrl());
                    fansData.setName(starProfileDict.getName());
                }
                fansDatas.add(fansData);
            }
        });
        vo.setFansDatas(fansDatas);
    }

    private void getKsVideoData(List<TopManContrastParamDTO> paramList, String clearCache, KsTopManContrastVO vo) {
        ArrayList<KsTopManDetailHeadVO.VideoResponse> videoDatas = new ArrayList<KsTopManDetailHeadVO.VideoResponse>(paramList.size());
        ArrayList<KsTopManDetailHeadVO.LiveResponse> liveDatas = new ArrayList<KsTopManDetailHeadVO.LiveResponse>(paramList.size());
        paramList.forEach(h -> {
            KsTopManDetailHeadVO.StarProfileDict starProfileDict;
            KsTopManDetailDTO ksDTO = this.ksDtoTransfer((TopManContrastParamDTO)h);
            ksDTO.setClearCache(clearCache);
            KsTopManDetailHeadVO detailHead = this.getKsHeadData(ksDTO);
            KsTopManDetailVideoAnalysisEntity videoDataNew = this.kuaiShouTopManInformationService.getDetailBodyVideoNew(ksDTO);
            if (videoDataNew != null) {
                KsTopManDetailHeadVO.VideoResponse videoResponse = detailHead.getVideoResponse();
                starProfileDict = detailHead.getStarProfileDict();
                KsTopManDetailVideoAnalysisEntity.StarWorkReport starWorkReport = videoDataNew.getStarWorkReport();
                if (videoResponse != null && starProfileDict != null) {
                    videoResponse.setExpectedCpe(starProfileDict.getExpectedCpe());
                    videoResponse.setHeadUrl(starProfileDict.getHeadUrl());
                    videoResponse.setName(starProfileDict.getName());
                }
                if (videoResponse != null && starWorkReport != null) {
                    videoResponse.setPphotoCntData(starWorkReport.getPphotoCntData().get("30"));
                    videoResponse.setPplayMedianData(starWorkReport.getPplayMedianData().get("30"));
                    videoResponse.setPcompletePlayRateData(starWorkReport.getPcompletePlayRateData().get("30"));
                    videoResponse.setPhotoInteractionRateData(starWorkReport.getPhotoInteractionRateData().get("30"));
                }
                videoDatas.add(videoResponse);
            }
            KsTopManDetailHeadVO.LiveResponse liveResponse = detailHead.getLiveResponse();
            starProfileDict = detailHead.getStarProfileDict();
            if (liveResponse != null && starProfileDict != null) {
                liveResponse.setHeadUrl(starProfileDict.getHeadUrl());
                liveResponse.setName(starProfileDict.getName());
            }
            liveDatas.add(liveResponse);
        });
        vo.setVideoDatas(videoDatas);
        vo.setLiveDatas(liveDatas);
    }

    private void getKsBaseData(List<TopManContrastParamDTO> paramList, String clearCache, KsTopManContrastVO vo) {
        ArrayList<KsTopManDetailHeadVO.StarProfileDict> baseDatas = new ArrayList<KsTopManDetailHeadVO.StarProfileDict>(paramList.size());
        paramList.forEach(h -> {
            KsTopManDetailDTO ksDTO = this.ksDtoTransfer((TopManContrastParamDTO)h);
            ksDTO.setClearCache(clearCache);
            KsTopManDetailHeadVO detailHead = this.getKsHeadData(ksDTO);
            KsTopManDetailHeadVO.StarProfileDict starProfileDict = detailHead.getStarProfileDict();
            if (starProfileDict != null) {
                starProfileDict.setGovName(StringUtils.isNotBlank((CharSequence)starProfileDict.getGovName()) ? starProfileDict.getGovName() : "\u672a\u7b7e\u7ea6");
                String starType = "4";
                if (starType.equals(h.getStarType())) {
                    String perHour = starProfileDict.getLiveQuotedInfo() != null ? starProfileDict.getLiveQuotedInfo().getPerHour().divide(new BigDecimal(1000), 4).toPlainString() : "-";
                    starProfileDict.setPromotionPrice("\u76f4\u64ad\u62a5\u4ef7\uff1a\uffe5" + perHour + "/\u5c0f\u65f6");
                } else {
                    String perHour = starProfileDict.getOrderBid() != null ? starProfileDict.getOrderBid().divide(new BigDecimal(1000), 4).toPlainString() : "-";
                    starProfileDict.setPromotionPrice("\u89c6\u9891\u62a5\u4ef7\uff1a\uffe5" + perHour + "/\u4e2a");
                }
                if (starProfileDict.getHidePrice().booleanValue()) {
                    starProfileDict.setPromotionPrice("\u6309\u534f\u8bae\u4ef7");
                }
            }
            baseDatas.add(starProfileDict);
        });
        vo.setBaseDatas(baseDatas);
    }

    private KsTopManDetailHeadVO getKsHeadData(KsTopManDetailDTO ksDTO) {
        KsTopManDetailHeadVO detailHead = this.kuaiShouTopManInformationService.getDetailHead(ksDTO);
        if (detailHead != null) {
            return detailHead;
        }
        return new KsTopManDetailHeadVO();
    }

    @Override
    public TopManContrastVO rbTopManContrast(TopManContrastDTO dto) {
        RbTopManContrastVO vo = new RbTopManContrastVO();
        List<TopManContrastParamDTO> paramList = this.contrastDtoTransfer(dto);
        switch (dto.getTaskType()) {
            case "baseData": {
                this.getRbBaseData(paramList, dto.getClearCache(), vo);
                break;
            }
            case "fansData": {
                this.getRbFansData(paramList, dto.getClearCache(), vo);
                break;
            }
            case "goodsData": {
                this.getRbGoodsData(paramList, dto.getClearCache(), vo);
                break;
            }
            default: {
                throw new ELSBootException(I18nUtil.translate((String)"", (String)"\u672a\u627e\u5230\u8be5\u8bf7\u6c42\u7c7b\u578b"));
            }
        }
        return vo;
    }

    private void getRbGoodsData(List<TopManContrastParamDTO> paramList, String clearCache, RbTopManContrastVO vo) {
        ArrayList<RedBookTopManDetailHeadVO.Sales> goodsDatas = new ArrayList<RedBookTopManDetailHeadVO.Sales>(paramList.size());
        paramList.forEach(h -> {
            RedBookTopManDetailDTO rbDTO = this.rbDtoTransfer((TopManContrastParamDTO)h);
            rbDTO.setClearCache(clearCache);
            RedBookTopManDetailHeadVO detailHead = this.getRbHeadData(rbDTO);
            RedBookTopManDetailHeadVO goodsData = this.redBookTopManInformationService.getDetailLiveSales(rbDTO);
            if (goodsData != null) {
                RedBookTopManDetailHeadVO.Sales sales = goodsData.getSales();
                RedBookTopManDetailHeadVO.DetailHead baseData = detailHead.getDetailHead();
                List<RedBookTopManDetailHeadVO.Sales.Category> rgmvCategorys = sales.getRgmvCategory();
                if (CollectionUtil.isNotEmpty(rgmvCategorys)) {
                    rgmvCategorys = rgmvCategorys.size() > 3 ? rgmvCategorys.subList(0, 3) : rgmvCategorys;
                    List categoryNames = rgmvCategorys.stream().map(RedBookTopManDetailHeadVO.Sales.Category::getCategoryName).collect(Collectors.toList());
                    sales.setCategories(CollectionUtil.isNotEmpty(categoryNames) ? StrUtil.join((CharSequence)"\u3001", categoryNames) : "-");
                }
                if (baseData != null) {
                    sales.setHeadPhoto(baseData.getHeadPhoto());
                    sales.setName(baseData.getName());
                }
                goodsDatas.add(sales);
            }
        });
        vo.setGoodsDatas(goodsDatas);
    }

    private void getRbFansData(List<TopManContrastParamDTO> paramList, String clearCache, RbTopManContrastVO vo) {
        ArrayList<RedBookTopManDetailHeadVO.FansData> fansDatas = new ArrayList<RedBookTopManDetailHeadVO.FansData>(paramList.size());
        paramList.forEach(h -> {
            RedBookTopManDetailDTO rbDTO = this.rbDtoTransfer((TopManContrastParamDTO)h);
            rbDTO.setClearCache(clearCache);
            RedBookTopManDetailHeadVO detailHead = this.getRbHeadData(rbDTO);
            RedBookTopManDetailHeadVO fansData = this.redBookTopManInformationService.getDetailFans(rbDTO);
            if (fansData != null) {
                RedBookTopManDetailHeadVO.FansData fans = fansData.getFansData();
                RedBookTopManDetailHeadVO.DetailHead baseData = detailHead.getDetailHead();
                if (fans != null && baseData != null) {
                    fans.setHeadPhoto(baseData.getHeadPhoto());
                    fans.setName(baseData.getName());
                }
                fansDatas.add(fans);
            }
        });
        vo.setFansDatas(fansDatas);
    }

    private void getRbBaseData(List<TopManContrastParamDTO> paramList, String clearCache, RbTopManContrastVO vo) {
        ArrayList<RedBookTopManDetailHeadVO.DetailHead> baseDatas = new ArrayList<RedBookTopManDetailHeadVO.DetailHead>(paramList.size());
        ArrayList<RedBookTopManDetailHeadVO.NotesData> noteDatas = new ArrayList<RedBookTopManDetailHeadVO.NotesData>(paramList.size());
        ArrayList<RedBookTopManDetailHeadVO.LivesData> liveDatas = new ArrayList<RedBookTopManDetailHeadVO.LivesData>(paramList.size());
        paramList.forEach(h -> {
            RedBookTopManDetailDTO rbDTO = this.rbDtoTransfer((TopManContrastParamDTO)h);
            rbDTO.setClearCache(clearCache);
            RedBookTopManDetailHeadVO detailHead = this.getRbHeadData(rbDTO);
            RedBookTopManDetailHeadVO.DetailHead baseData = detailHead.getDetailHead();
            RedBookTopManDetailHeadVO detailPromotion = this.redBookTopManInformationService.getDetailPromotion(rbDTO);
            if (baseData != null && detailPromotion != null) {
                RedBookTopManDetailHeadVO.Promotion promotion = detailPromotion.getPromotion();
                baseData.setMcnName(baseData.getNoteSign() != null && StringUtils.isNotBlank((CharSequence)baseData.getNoteSign().getName()) ? baseData.getNoteSign().getName() : "\u672a\u7b7e\u7ea6");
                String picturePrice = StrUtil.format((CharSequence)"\u56fe\u6587\u7b14\u8bb0\uff1a{}\uff0c", (Object[])new Object[]{promotion.getPicturePrice() != null ? "\uffe5" + promotion.getPicturePrice() : "-"});
                String videoPrice = StrUtil.format((CharSequence)"\u89c6\u9891\u7b14\u8bb0\uff1a{}", (Object[])new Object[]{promotion.getVideoPrice() != null ? "\uffe5" + promotion.getVideoPrice() : "-"});
                baseData.setPromotionPrice(picturePrice + videoPrice);
                String pictureReadCost = StrUtil.format((CharSequence)"\u56fe\u6587\u7b14\u8bb0\uff1a{}\uff0c", (Object[])new Object[]{promotion.getPictureReadCost() != null ? StrUtil.format((CharSequence)"\uffe5{}/\u9605\u8bfb", (Object[])new Object[]{promotion.getPictureReadCost()}) : "-"});
                String videoReadCost = StrUtil.format((CharSequence)"\u89c6\u9891\u7b14\u8bb0\uff1a{}", (Object[])new Object[]{promotion.getVideoReadCost() != null ? StrUtil.format((CharSequence)"\uffe5{}/\u9605\u8bfb", (Object[])new Object[]{promotion.getVideoReadCost()}) : "-"});
                baseData.setPictureReadPrice(pictureReadCost + videoReadCost);
            }
            baseDatas.add(baseData);
            RedBookTopManDetailHeadVO.NotesData notesData = detailHead.getNotesData();
            RedBookTopManDetailHeadVO.CoreData coreData = detailHead.getCoreData();
            if (notesData != null && coreData != null) {
                notesData.setTotalNoteCount(coreData.getTotalNoteCount());
                notesData.setLikeCollectCountInfo(coreData.getLikeCollectCountInfo());
            }
            if (notesData != null && baseData != null) {
                notesData.setHeadPhoto(baseData.getHeadPhoto());
                notesData.setName(baseData.getName());
            }
            noteDatas.add(notesData);
            RedBookTopManDetailHeadVO.LivesData livesData = detailHead.getLivesData();
            if (livesData != null && baseData != null) {
                livesData.setHeadPhoto(baseData.getHeadPhoto());
                livesData.setName(baseData.getName());
            }
            liveDatas.add(livesData);
        });
        vo.setBaseDatas(baseDatas);
        vo.setNoteDatas(noteDatas);
        vo.setLiveDatas(liveDatas);
    }

    private RedBookTopManDetailHeadVO getRbHeadData(RedBookTopManDetailDTO rbDTO) {
        RedBookTopManDetailHeadVO detailHead = this.redBookTopManInformationService.getDetailHead(rbDTO);
        if (detailHead != null) {
            return detailHead;
        }
        return new RedBookTopManDetailHeadVO();
    }

    @Override
    public TopManContrastVO biliTopManContrast(TopManContrastDTO dto) {
        BiliTopManContrastVO vo = new BiliTopManContrastVO();
        List<TopManContrastParamDTO> paramList = this.contrastDtoTransfer(dto);
        switch (dto.getTaskType()) {
            case "baseData": {
                this.getBiliBaseData(paramList, vo);
                break;
            }
            case "fansData": {
                this.getBiliFansData(paramList, vo);
                break;
            }
            default: {
                throw new ELSBootException(I18nUtil.translate((String)"", (String)"\u672a\u627e\u5230\u8be5\u8bf7\u6c42\u7c7b\u578b"));
            }
        }
        return vo;
    }

    private void getBiliFansData(List<TopManContrastParamDTO> paramList, BiliTopManContrastVO vo) {
        ArrayList<BStationTopManInformationFanAnalysisEntity> fansDatas = new ArrayList<BStationTopManInformationFanAnalysisEntity>(paramList.size());
        paramList.forEach(h -> {
            BStationTopManInformationFanAnalysisEntity fansData = this.bStationTopManInformationService.bStationTopManFanAnalysisDetails(h.getStationId(), h.getTopManId());
            if (fansData != null) {
                BStationTopManInformationTopDetailsEntity baseData = this.bStationTopManInformationService.bStationTopManDetails(h.getStationId(), h.getTopManId());
                if (baseData != null && baseData.getTopManInfo() != null) {
                    BStationTopManInformationTopDetailsEntity.TopManInfo topManInfo = baseData.getTopManInfo();
                    fansData.setTopmanAvatar(topManInfo.getTopmanAvatar());
                    fansData.setTopmanName(topManInfo.getTopmanName());
                }
                fansDatas.add(fansData);
            }
        });
        vo.setFansDatas(fansDatas);
    }

    private void getBiliBaseData(List<TopManContrastParamDTO> paramList, BiliTopManContrastVO vo) {
        ArrayList<BStationTopManInformationTopDetailsEntity.TopManInfo> baseDatas = new ArrayList<BStationTopManInformationTopDetailsEntity.TopManInfo>(paramList.size());
        ArrayList<BStationTopManInformationTopDetailsEntity.TopManVideoData> videoDatas = new ArrayList<BStationTopManInformationTopDetailsEntity.TopManVideoData>(paramList.size());
        ArrayList<BStationTopManInformationTopDetailsEntity.TopManLiveData> liveDatas = new ArrayList<BStationTopManInformationTopDetailsEntity.TopManLiveData>(paramList.size());
        paramList.forEach(h -> {
            BStationTopManInformationTopDetailsEntity baseData = this.bStationTopManInformationService.bStationTopManDetails(h.getStationId(), h.getTopManId());
            if (baseData != null) {
                BStationTopManInformationTopDetailsEntity.TopManInfo topManInfo = baseData.getTopManInfo();
                List<BStationTopManInformationPromotionAnalysisEntity> promotions = this.bStationTopManInformationService.bStationTopManPromotionAnalysisDetails(h.getStationId(), h.getTopManId());
                if (topManInfo != null && CollectionUtil.isNotEmpty(promotions)) {
                    List prices = promotions.stream().map(j -> StrUtil.format((CharSequence)"{}\uff1a\uffe5{}", (Object[])new Object[]{j.getQuotationType(), j.getPrice()})).collect(Collectors.toList());
                    String promotionPrice = StrUtil.join((CharSequence)"\uff0c", prices);
                    topManInfo.setPromotionPrice(promotionPrice);
                }
                if (topManInfo != null) {
                    topManInfo.setAuthentication(StringUtils.isNotBlank((CharSequence)topManInfo.getAuthentication()) ? topManInfo.getAuthentication() : "-");
                    topManInfo.setMcnCompanyName(StringUtils.isNotBlank((CharSequence)topManInfo.getMcnCompanyName()) ? topManInfo.getMcnCompanyName() : "-");
                }
                baseDatas.add(topManInfo);
                BStationTopManInformationTopDetailsEntity.TopManVideoData topManVideoData = baseData.getTopManVideoData();
                BStationTopManInformationTopDetailsEntity.TopManCoreData topManCoreData = baseData.getTopManCoreData();
                if (topManVideoData != null && topManCoreData != null) {
                    topManVideoData.setVideoNum(topManCoreData.getVideoNum());
                    topManVideoData.setLikeNum(topManCoreData.getLikeNum());
                    topManVideoData.setPlayNum(topManCoreData.getPlayNum());
                }
                if (topManVideoData != null && topManInfo != null) {
                    topManVideoData.setTopmanAvatar(topManInfo.getTopmanAvatar());
                    topManVideoData.setTopmanName(topManInfo.getTopmanName());
                }
                videoDatas.add(topManVideoData);
                BStationTopManInformationTopDetailsEntity.TopManLiveData topManLiveData = baseData.getTopManLiveData();
                if (topManLiveData != null && topManInfo != null) {
                    topManLiveData.setTopmanAvatar(topManInfo.getTopmanAvatar());
                    topManLiveData.setTopmanName(topManInfo.getTopmanName());
                }
                liveDatas.add(topManLiveData);
            }
        });
        vo.setBaseDatas(baseDatas);
        vo.setVideoDatas(videoDatas);
        vo.setLiveDatas(liveDatas);
    }

    @Override
    public TopManContrastVO blogTopManContrast(TopManContrastDTO dto) {
        BlogTopManContrastVO vo = new BlogTopManContrastVO();
        List<TopManContrastParamDTO> paramList = this.contrastDtoTransfer(dto);
        switch (dto.getTaskType()) {
            case "baseData": {
                this.getBlogBaseData(paramList, vo);
                break;
            }
            case "fansData": {
                this.getBlogFansData(paramList, vo);
                break;
            }
            default: {
                throw new ELSBootException(I18nUtil.translate((String)"", (String)"\u672a\u627e\u5230\u8be5\u8bf7\u6c42\u7c7b\u578b"));
            }
        }
        return vo;
    }

    private void getBlogFansData(List<TopManContrastParamDTO> paramList, BlogTopManContrastVO vo) {
        ArrayList<BlogTopManInformationFanAnalysisEntity> fansDatas = new ArrayList<BlogTopManInformationFanAnalysisEntity>(paramList.size());
        paramList.forEach(h -> {
            BlogTopManInformationFanAnalysisEntity fansData = this.blogTopManInformationService.blogTopManFanAnalysisDetails(h.getTopManId());
            if (fansData != null) {
                BlogTopManInformationTopDetailsEntity baseData = this.blogTopManInformationService.blogTopManDetails(h.getTopManId());
                if (baseData != null && baseData.getTopManInfo() != null) {
                    BlogTopManInformationTopDetailsEntity.TopManInfo topManInfo = baseData.getTopManInfo();
                    fansData.setTopmanAvatar(topManInfo.getTopmanAvatar());
                    fansData.setTopmanName(topManInfo.getTopmanName());
                }
                fansDatas.add(fansData);
            }
        });
        vo.setFansDatas(fansDatas);
    }

    private void getBlogBaseData(List<TopManContrastParamDTO> paramList, BlogTopManContrastVO vo) {
        ArrayList<BlogTopManInformationTopDetailsEntity.TopManInfo> baseDatas = new ArrayList<BlogTopManInformationTopDetailsEntity.TopManInfo>(paramList.size());
        ArrayList<BlogTopManInformationTopDetailsEntity.TopManCoreData> coreDatas = new ArrayList<BlogTopManInformationTopDetailsEntity.TopManCoreData>(paramList.size());
        paramList.forEach(h -> {
            BlogTopManInformationTopDetailsEntity baseData = this.blogTopManInformationService.blogTopManDetails(h.getTopManId());
            if (baseData != null) {
                BlogTopManInformationTopDetailsEntity.TopManInfo topManInfo = baseData.getTopManInfo();
                BlogTopManInformationPromotionAnalysisEntity promotion = this.blogTopManInformationService.blogTopManInformationPromotionAnalysis(h.getTopManId());
                if (topManInfo != null && promotion != null && CollectionUtil.isNotEmpty(promotion.getPrice())) {
                    List prices = promotion.getPrice().stream().map(j -> StrUtil.format((CharSequence)"{}\uff1a\uffe5{}", (Object[])new Object[]{j.getPriceType(), j.getPrice()})).collect(Collectors.toList());
                    topManInfo.setPromotionPrice(CollectionUtil.isNotEmpty(prices) ? StrUtil.join((CharSequence)"\uff0c", prices) : "-");
                }
                if (topManInfo != null) {
                    topManInfo.setTopmanGender(StringUtils.isNotEmpty((CharSequence)topManInfo.getTopmanGender()) ? BlogTopmanGenderEnum.getDesc(topManInfo.getTopmanGender()) : "-");
                    topManInfo.setVerifiedReason(StringUtils.isNotEmpty((CharSequence)topManInfo.getVerifiedReason()) ? topManInfo.getVerifiedReason() : "-");
                    topManInfo.setVerifiedType(StringUtils.isNotEmpty((CharSequence)topManInfo.getVerifiedTypeExt()) ? BlogVerifiedTypeEnum.getDesc(topManInfo.getVerifiedTypeExt()) : "-");
                    topManInfo.setPartner(StringUtils.isNotEmpty((CharSequence)topManInfo.getPartner()) ? BlogVerifiedTypeEnum.getDesc(topManInfo.getPartner()) : "\u672a\u7b7e\u7ea6");
                }
                baseDatas.add(baseData.getTopManInfo());
                BlogTopManInformationTopDetailsEntity.TopManCoreData coreData = baseData.getTopManCoreData();
                if (coreData != null && topManInfo != null) {
                    coreData.setTopmanAvatar(topManInfo.getTopmanAvatar());
                    coreData.setTopmanName(topManInfo.getTopmanName());
                }
                coreDatas.add(coreData);
            }
        });
        vo.setBaseDatas(baseDatas);
        vo.setCoreDatas(coreDatas);
    }

    @Override
    public TopManContrastVO zhTopManContrast(TopManContrastDTO dto) {
        ZhTopManContrastVO vo = new ZhTopManContrastVO();
        List<TopManContrastParamDTO> paramList = this.contrastDtoTransfer(dto);
        ArrayList<ZhiHuManDetailHeadVO.DetailHead> baseDatas = new ArrayList<ZhiHuManDetailHeadVO.DetailHead>(dto.getParamList().size());
        ArrayList<ZhiHuManDetailHeadVO.CoreData> coreDatas = new ArrayList<ZhiHuManDetailHeadVO.CoreData>(dto.getParamList().size());
        ArrayList<ZhiHuManDetailHeadVO.FansData.PuFollower> fansDatas = new ArrayList<ZhiHuManDetailHeadVO.FansData.PuFollower>(dto.getParamList().size());
        for (TopManContrastParamDTO h : paramList) {
            ZhiHuTopManDetailDTO zhDTO = this.zhDtoTransfer(h);
            zhDTO.setClearCache(dto.getClearCache());
            ZhiHuManDetailHeadVO detailHead = this.zhiHuTopManInformationService.getDetailHead(zhDTO);
            if (detailHead == null) {
                return vo;
            }
            ZhiHuManDetailHeadVO.DetailHead baseData = detailHead.getDetailHead();
            if (baseData != null) {
                baseData.setMcnName(baseData.getMcn() != null && StringUtils.isNotBlank((CharSequence)baseData.getMcn().getName()) ? baseData.getMcn().getName() : "\u672a\u7b7e\u7ea6");
                ZhiHuManDetailHeadVO.BaseData data = detailHead.getBaseData();
                if (data != null && CollectionUtil.isNotEmpty(data.getCommercialScorePersonalV2())) {
                    List<ZhiHuManDetailHeadVO.BaseData.CommercialScorePersonalV2> personals = data.getCommercialScorePersonalV2();
                    List badgesNames = personals.stream().map(ZhiHuManDetailHeadVO.BaseData.CommercialScorePersonalV2::getFieldName).collect(Collectors.toList());
                    baseData.setBadgesName(StrUtil.join((CharSequence)"\u3001", badgesNames));
                }
                List<String> promotionPrice = this.getZhPromotionPrice(detailHead.getPromotionData());
                baseData.setPromotionPrice(promotionPrice);
            }
            baseDatas.add(baseData);
            ZhiHuManDetailHeadVO.CoreData coreData = detailHead.getCoreData();
            if (coreData != null && baseData != null) {
                coreData.setAvatarPath(baseData.getAvatarPath());
                coreData.setName(baseData.getName());
            }
            coreDatas.add(coreData);
            ZhiHuManDetailHeadVO.FansData fansData = detailHead.getFansData();
            if (fansData == null || fansData.getPuFollower() == null) continue;
            ZhiHuManDetailHeadVO.FansData.PuFollower puFollower = fansData.getPuFollower();
            if (baseData != null) {
                puFollower.setAvatarPath(baseData.getAvatarPath());
                puFollower.setName(baseData.getName());
            }
            fansDatas.add(puFollower);
        }
        vo.setBaseDatas(baseDatas);
        vo.setCoreDatas(coreDatas);
        vo.setFansDatas(fansDatas);
        return vo;
    }

    private List<String> getZhPromotionPrice(ZhiHuManDetailHeadVO.PromotionData promotionData) {
        ArrayList<String> list = new ArrayList<String>(1);
        list.add("-");
        if (promotionData == null) {
            return list;
        }
        List<ZhiHuManDetailHeadVO.PromotionData.Offer> offers = promotionData.getOffer();
        if (CollectionUtil.isEmpty(offers) || offers.get(0) == null) {
            return list;
        }
        return offers.stream().map(this::promotionPriceConverter).collect(Collectors.toList());
    }

    private String promotionPriceConverter(ZhiHuManDetailHeadVO.PromotionData.Offer offer) {
        String promotionPrice = "";
        BigDecimal finalOrderPrice = null;
        Integer orderPrice = offer.getOrderPrice();
        if (orderPrice != null) {
            finalOrderPrice = new BigDecimal(orderPrice).divide(new BigDecimal(100), 2, 4);
        }
        if (offer.getOrderType() == 1) {
            promotionPrice = finalOrderPrice != null ? StrUtil.format((CharSequence)"\u56de\u7b54&\u6587\u7ae0\uff1a\uffe5{}", (Object[])new Object[]{finalOrderPrice}) : "";
        } else if (offer.getOrderSecondType() == 1) {
            promotionPrice = finalOrderPrice != null ? StrUtil.format((CharSequence)"\u89c6\u9891-\u811a\u672c\u64b0\u5199\uff1a\uffe5{}", (Object[])new Object[]{finalOrderPrice}) : "";
        } else {
            if (offer.getOrderThirdType() == 1) {
                String string = promotionPrice = finalOrderPrice != null ? StrUtil.format((CharSequence)"\u89c6\u9891-\u5168\u7247\u5b9a\u52361-3min\uff1a\uffe5{}", (Object[])new Object[]{finalOrderPrice}) : "";
            }
            if (offer.getOrderThirdType() == 2) {
                String string = promotionPrice = finalOrderPrice != null ? StrUtil.format((CharSequence)"\u89c6\u9891-\u5168\u7247\u5b9a\u52363-5min\uff1a\uffe5{}", (Object[])new Object[]{finalOrderPrice}) : "";
            }
            if (offer.getOrderThirdType() == 3) {
                String string = promotionPrice = finalOrderPrice != null ? StrUtil.format((CharSequence)"\u89c6\u9891-\u5168\u7247\u5b9a\u52365-10min\uff1a\uffe5{}", (Object[])new Object[]{finalOrderPrice}) : "";
            }
            if (offer.getOrderThirdType() == 4) {
                promotionPrice = finalOrderPrice != null ? StrUtil.format((CharSequence)"\u89c6\u9891-\u5168\u7247\u5b9a\u523610min\u4ee5\u4e0a\uff1a\uffe5{}", (Object[])new Object[]{finalOrderPrice}) : "";
            }
        }
        return promotionPrice;
    }

    private List<TopManContrastParamDTO> contrastDtoTransfer(TopManContrastDTO dto) {
        if (dto == null || CollectionUtil.isEmpty(dto.getParamList())) {
            throw new RuntimeException(I18nUtil.translate((String)"", (String)"\u53c2\u6570\u9519\u8bef"));
        }
        List<TopManContrastParamDTO> paramList = dto.getParamList();
        if (paramList.size() > 3) {
            paramList = paramList.subList(0, 3);
        }
        return paramList;
    }

    private List<DyTopManVO> contrastDtoTransferDy(TopManContrastDTO dto) {
        if (dto == null || CollectionUtil.isEmpty(dto.getDataList())) {
            throw new RuntimeException(I18nUtil.translate((String)"", (String)"\u53c2\u6570\u9519\u8bef"));
        }
        List<DyTopManVO> paramList = dto.getDataList();
        if (paramList.size() > 3) {
            paramList = paramList.subList(0, 3);
        }
        return paramList;
    }
}

