/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.topman.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.system.query.QueryGenerator;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.Assert;
import com.els.common.util.I18nUtil;
import com.els.common.util.RedisUtil;
import com.els.common.util.SysUtil;
import com.els.modules.industryInfo.api.annotation.OrderTagId;
import com.els.modules.industryInfo.api.dto.SimplePostRequestParam;
import com.els.modules.industryInfo.api.enumerate.DyOptionType;
import com.els.modules.industryInfo.api.enumerate.StatisticsDateType;
import com.els.modules.industryInfo.api.optiondic.DouYinTopManOptionSource;
import com.els.modules.industryInfo.api.weboption.MultipleOptionTag;
import com.els.modules.industryInfo.api.weboption.OptionComponentType;
import com.els.modules.industryInfo.api.weboption.RequestOptionVO;
import com.els.modules.industryInfo.api.weboption.TopManOptionsEntity;
import com.els.modules.topman.dto.DouYinTopManCollectDTO;
import com.els.modules.topman.dto.DouYinTopManDetailDTO;
import com.els.modules.topman.entity.DouYinTopManInformationBaseSimilarTalentEntity;
import com.els.modules.topman.entity.DouYinTopManInformationFanAnalysisEntity;
import com.els.modules.topman.entity.DouYinTopManInformationLiveDetailsAnalysisEntity;
import com.els.modules.topman.entity.DouYinTopManInformationLiveListEntity;
import com.els.modules.topman.entity.DouYinTopManInformationVideoDetailsAnalysisEntity;
import com.els.modules.topman.entity.DouYinTopManInformationVideoListEntity;
import com.els.modules.topman.entity.DyTopManInformationHead;
import com.els.modules.topman.entity.TopManCollectBean;
import com.els.modules.topman.entity.TopManGoodsListEntity;
import com.els.modules.topman.entity.TopManParamEntity;
import com.els.modules.topman.entity.TopManResultDetailBody;
import com.els.modules.topman.entity.TopManResultDetailBodyBase;
import com.els.modules.topman.entity.TopManResultDetailBodyContacr;
import com.els.modules.topman.entity.TopManResultDetailBodyFans;
import com.els.modules.topman.entity.TopManResultDetailBodyLive;
import com.els.modules.topman.entity.TopManResultDetailBodySaleGoods;
import com.els.modules.topman.entity.TopManResultDetailBodyVideo;
import com.els.modules.topman.entity.TopManResultEntity;
import com.els.modules.topman.entity.TopManShopListEntity;
import com.els.modules.topman.entity.TopManSpiderMark;
import com.els.modules.topman.enumerate.MarkYn;
import com.els.modules.topman.enumerate.MongoCollectionType;
import com.els.modules.topman.enumerate.TopManQueryType;
import com.els.modules.topman.exception.TopManException;
import com.els.modules.topman.mapper.TopManInformationMapper;
import com.els.modules.topman.service.DyTopManInformationHeadService;
import com.els.modules.topman.service.MongoHandleService;
import com.els.modules.topman.service.TopManCollectService;
import com.els.modules.topman.service.TopManInformationService;
import com.els.modules.topman.utils.HttpRequestUtils;
import com.els.modules.topman.utils.spider.entity.DyTopManDetailBaseContacrEntity;
import com.els.modules.topman.utils.spider.entity.DyTopManDetailBaseEntity;
import com.els.modules.topman.utils.spider.entity.DyTopManDetailBaseInfoEntity;
import com.els.modules.topman.utils.spider.entity.DyTopManDetailSaleGoodsEntity;
import com.els.modules.topman.utils.spider.entity.DyTopManIndexListPage;
import com.els.modules.topman.utils.spider.entity.DyTopManInfoEntity;
import com.els.modules.topman.utils.spider.entity.DyTopManSaleGoodsTagEntity;
import com.els.modules.topman.utils.spider.entity.DyTopManSpiderGoodsListEntity;
import com.els.modules.topman.utils.spider.entity.DyTopManSpiderShopListEntity;
import com.els.modules.topman.utils.spider.entity.TopManDetailDouYinIdEntity;
import com.els.modules.topman.utils.spider.entity.TopManDetailDouYinMcnEntity;
import com.els.modules.topman.utils.spider.properties.SpiderBaseProperties;
import com.els.modules.topman.utils.spider.properties.SpiderMethodType;
import com.els.modules.topman.utils.spider.spiderApi.SpiderApiUtil;
import com.els.modules.topman.vo.AddedAndCollectVO;
import com.els.modules.topman.vo.DyTopManAddPopupVO;
import com.els.modules.topman.vo.DyTopManCollectVo;
import com.els.modules.topman.vo.DyTopManVO;
import com.els.modules.topman.vo.TopManDetailDouYinIdVO;
import com.els.modules.topman.vo.TopManDetailDouYinMcnVO;
import com.els.modules.topman.vo.TopManDetailHeadVO;
import com.els.modules.topman.vo.TopManInformationVO;
import java.io.IOException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.data.mongodb.core.query.UpdateDefinition;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class TopManInformationServiceImpl
extends BaseServiceImpl<TopManInformationMapper, TopManParamEntity>
implements TopManInformationService {
    private static final Logger log;
    private static final Map<String, Integer> orderTag;
    private final BigDecimal divide = new BigDecimal("100.00");
    HashMap<TopManQueryType, ListMethod> typeMethod = null;
    @Resource
    private SpiderApiUtil spiderApiUtil;
    @Resource
    private TopManCollectService topManCollectService;
    @Resource
    private RedisUtil redisUtil;
    @Resource
    private DyTopManInformationHeadService dyTopManInformationHeadService;
    @Resource
    private MongoTemplate mongoTemplate;
    @Resource
    private MongoHandleService mongoHandleService;
    @Autowired
    private SpiderBaseProperties spiderBaseProperties;

    @Override
    @Deprecated
    public IPage<? extends TopManResultEntity> queryTopManList(SimplePostRequestParam<TopManInformationVO> topManDto, TopManQueryType topManQueryType) {
        if (this.typeMethod == null) {
            this.typeMethod = new HashMap<TopManQueryType, ListMethod>(){
                {
                    this.put(TopManQueryType.all, ((TopManInformationMapper)TopManInformationServiceImpl.this.baseMapper)::selectPageAll);
                    this.put(TopManQueryType.myCollection, ((TopManInformationMapper)TopManInformationServiceImpl.this.baseMapper)::selectPageCollection);
                    this.put(TopManQueryType.liveTopMan, ((TopManInformationMapper)TopManInformationServiceImpl.this.baseMapper)::selectPageLiveTopMan);
                    this.put(TopManQueryType.videoTopMan, ((TopManInformationMapper)TopManInformationServiceImpl.this.baseMapper)::selectPageVideoTopMan);
                    this.put(TopManQueryType.onlyIdByMsgTask, ((TopManInformationMapper)TopManInformationServiceImpl.this.baseMapper)::onlyIdByMsgTask);
                }
            };
        }
        QueryWrapper<TopManParamEntity> queryWrapper = this.getQueryWrapper(topManDto);
        Page page = new Page((long)topManDto.getPageNo().intValue(), (long)topManDto.getPageSize().intValue());
        page.setCountId("pageSelectCount");
        ((TopManInformationVO)topManDto.getFilterInfo()).getCountTables().add(topManQueryType.getCountTable());
        topManQueryType.getInitMethod().initQueryWrapper(queryWrapper, null);
        if (TopManQueryType.isOnlyIdByMsgTask(topManQueryType)) {
            String sql = "SELECT 1 from mcn_top_man_msg_record r where aa.topman_id = r.topman_id   and r.els_account = " + SysUtil.getLoginUser().getSubAccount();
            queryWrapper.notExists(sql);
        }
        return Optional.ofNullable(this.typeMethod.get((Object)topManQueryType)).orElseThrow(() -> new TopManException(I18nUtil.translate((String)"", (String)"\u8bf7\u6c42\u65b9\u5f0f\u9519\u8bef"))).apply((IPage<TopManResultEntity>)page, (Wrapper<TopManParamEntity>)queryWrapper, SysUtil.getLoginUser(), (TopManInformationVO)topManDto.getFilterInfo(), StatisticsDateType.M1);
    }

    @Deprecated
    private QueryWrapper<TopManParamEntity> getQueryWrapper(SimplePostRequestParam<TopManInformationVO> topManDto) {
        String[] columns;
        String column;
        TopManInformationVO filterInfo = (TopManInformationVO)topManDto.getFilterInfo();
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.setEntityClass(TopManParamEntity.class);
        filterInfo.initQueryWrapper((QueryWrapper<TopManParamEntity>)queryWrapper);
        String keyWord = topManDto.getKeyWord();
        if (keyWord != null && keyWord.trim().length() > 0) {
            ((QueryWrapper)queryWrapper.like((Object)"aa.topman_name", (Object)keyWord)).or(a -> {
                QueryWrapper cfr_ignored_0 = (QueryWrapper)a.eq((Object)"aa.topman_id", (Object)keyWord);
            });
        }
        if ((column = topManDto.getColumn()) != null && (columns = column.split(",")).length > 0) {
            final String order = topManDto.getOrder();
            QueryGenerator.doMultiFieldsOrder((QueryWrapper)queryWrapper, (Map)new HashMap<String, String[]>(2){
                {
                    super(x0);
                    this.put("column", columns);
                    this.put("order", order == null ? new String[columns.length] : order.split(","));
                }
            }, (Object)((Object)new TopManParamEntity()));
        }
        return queryWrapper;
    }

    @Override
    public IPage<DyTopManVO> queryTopManListNew(SimplePostRequestParam<RequestOptionVO> topManDto) {
        Page<DyTopManVO> result;
        Assert.isNotNull((Object)topManDto.getFilterInfo(), (String)I18nUtil.translate((String)"", (String)"filterInfo\u53c2\u6570\u5fc5\u4f20"));
        if (!"0".equals(((RequestOptionVO)topManDto.getFilterInfo()).getTaskType())) {
            result = new Page<DyTopManVO>((long)topManDto.getPageNo().intValue(), (long)topManDto.getPageSize().intValue());
            Map<String, Object> apiParam = this.getApiParam(topManDto);
            DyTopManIndexListPage apiResult = this.spiderApiUtil.postForEntity(SpiderMethodType.DOU_YIN_INDEX_LIST, apiParam, DyTopManIndexListPage.class);
            result.setTotal(apiResult.getTotal());
            result.setRecords(this.transferApiIndexListResult(apiResult));
        } else {
            QueryWrapper<DyTopManInformationHead> queryWrapper = this.getQueryWrapperNew(topManDto);
            Page page = new Page((long)topManDto.getPageNo().intValue(), (long)topManDto.getPageSize().intValue());
            result = ((TopManInformationMapper)this.baseMapper).selectCollectTopMan((Page<DyTopManVO>)page, queryWrapper, SysUtil.getLoginUser());
            result.getRecords().forEach(h -> {
                h.setTopmanLevel((String)DouYinTopManOptionSource.level.get(Integer.valueOf(h.getTopmanLevel())));
                h.setTopmanGender((String)DouYinTopManOptionSource.gender.get(Integer.valueOf(h.getTopmanGender())));
            });
        }
        return result;
    }

    @Override
    public Map<String, Object> getApiParam(SimplePostRequestParam<RequestOptionVO> topManDto) {
        HashMap<String, Object> apiParam = new HashMap<String, Object>(9);
        apiParam.put("refresh", topManDto.getPageNo().equals(1));
        apiParam.put("req_source", 0);
        apiParam.put("search_id", "");
        apiParam.put("search_source", 1);
        apiParam.put("act_id", "");
        RequestOptionVO filterInfo = (RequestOptionVO)topManDto.getFilterInfo();
        apiParam.put("type", filterInfo.getTaskType());
        apiParam.put("page", topManDto.getPageNo());
        try {
            String keyWord = URLEncoder.encode(topManDto.getKeyWord(), "utf-8");
            apiParam.put("query", keyWord);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        HashMap<String, Object> optionsMap = new HashMap<String, Object>(10);
        apiParam.put("options", optionsMap);
        Map screenItem = filterInfo.getScreenItem();
        if (screenItem != null && screenItem.size() > 0) {
            for (String key : screenItem.keySet()) {
                DyOptionType dyOptionType = DyOptionType.getDyOptionType((String)key);
                Assert.isNotNull((Object)dyOptionType, (String)I18nUtil.translate((String)"", (String)"\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u7c7b\u578b"));
                List screenItems = (List)screenItem.get(key);
                if (screenItems == null || screenItems.size() == 0) continue;
                switch (dyOptionType) {
                    case category: {
                        optionsMap.put("main_cate", ((RequestOptionVO.ScreenItem)screenItems.get(0)).getStarTagId());
                        break;
                    }
                    case contentType: {
                        optionsMap.put("content_type", StringUtils.join((Iterable)screenItems.stream().map(RequestOptionVO.ScreenItem::getStarTagId).collect(Collectors.toList()), (String)","));
                        break;
                    }
                    case topManInfo: {
                        this.handleTopManInfo(screenItems, optionsMap);
                        break;
                    }
                    case saleData: {
                        this.handleSaleData(screenItems, optionsMap);
                        break;
                    }
                    case fansData: {
                        this.handleFansData(screenItems, optionsMap);
                        break;
                    }
                    case priceQuoter: {
                        this.handlePriceQuoter(screenItems, optionsMap);
                    }
                }
            }
        }
        return apiParam;
    }

    private void handleTopManInfo(List<RequestOptionVO.ScreenItem> screenItems, Map<String, Object> apiParam) {
        if (screenItems == null || screenItems.size() == 0) {
            return;
        }
        for (RequestOptionVO.ScreenItem item : screenItems) {
            String title;
            String value = item.getValue();
            if (value == null) continue;
            switch (title = item.getTitle()) {
                case "\u8fbe\u4eba\u7b49\u7ea7": {
                    apiParam.put("author_level", value);
                    break;
                }
                case "\u7c89\u4e1d\u603b\u6570": {
                    apiParam.put("fans_num", value);
                    break;
                }
                case "\u8fbe\u4eba\u6027\u522b": {
                    apiParam.put("author_gender", value);
                    break;
                }
                case "\u8fbe\u4eba\u5730\u57df": {
                    try {
                        List region = JSON.parseArray((String)value, String.class);
                        apiParam.put("author_location", URLEncoder.encode((String)region.get(1), "utf-8"));
                        break;
                    }
                    catch (UnsupportedEncodingException e) {
                        throw new RuntimeException(e);
                    }
                }
                case "\u662f\u5426\u7b7e\u7ea6\u673a\u6784": {
                    apiParam.put("bind_institution", value);
                    break;
                }
                case "\u7eaf\u4f63\u8fbe\u4eba": {
                    apiParam.put("only_commission", value);
                    break;
                }
                case "\u660e\u661f": {
                    apiParam.put("star", value);
                    break;
                }
                case "\u9ed1\u9a6c": {
                    apiParam.put("dark_horse", DouYinTopManOptionSource.category.keySet());
                    break;
                }
                case "\u6709\u8054\u7cfb\u65b9\u5f0f": {
                    apiParam.put("has_contact", value);
                    break;
                }
                case "\u79cd\u8349\u6548\u7387\u9ad8": {
                    apiParam.put("high_recommend_rate", value);
                    break;
                }
                case "\u76f4\u64ad\u79cd\u8349\u6548\u7387\u9ad8": {
                    apiParam.put("high_recommend_rate", value);
                    break;
                }
                case "\u89c6\u9891\u79cd\u8349\u6548\u7387\u9ad8": {
                    apiParam.put("high_recommend_rate", value);
                }
            }
        }
    }

    private void handleSaleData(List<RequestOptionVO.ScreenItem> screenItems, Map<String, Object> apiParam) {
        if (screenItems == null || screenItems.size() == 0) {
            return;
        }
        for (RequestOptionVO.ScreenItem item : screenItems) {
            String title;
            String value = item.getValue();
            if (value == null) continue;
            switch (title = item.getTitle()) {
                case "30\u65e5\u9500\u552e\u989d": {
                    apiParam.put("gmv_d30", value);
                    break;
                }
                case "\u76f4\u64ad\u573a\u5747\u9500\u552e\u989d": {
                    apiParam.put("live_sale_avg", value);
                    break;
                }
                case "\u76f4\u64ad\u89c2\u770b\u4eba\u6570": {
                    apiParam.put("live_watcher", value);
                    break;
                }
                case "\u76f4\u64adGPM": {
                    apiParam.put("live_GPM", value);
                    break;
                }
                case "\u5355\u89c6\u9891\u9500\u552e\u989d": {
                    apiParam.put("video_sale_single", value);
                    break;
                }
                case "\u89c6\u9891\u64ad\u653e\u91cf": {
                    apiParam.put("video_play_time", value);
                    break;
                }
                case "\u89c6\u9891GPM": {
                    apiParam.put("video_GPM", value);
                    break;
                }
                case "\u5e26\u8d27\u5546\u54c1\u5747\u4ef7": {
                    apiParam.put("good_price_avg", value);
                    break;
                }
                case "\u76f4\u64ad\u5546\u54c1\u5747\u4ef7": {
                    apiParam.put("live_good_price_avg", value);
                    break;
                }
                case "\u89c6\u9891\u5546\u54c1\u5747\u4ef7": {
                    apiParam.put("video_good_price_avg", value);
                    break;
                }
                case "\u7ed3\u7b97\u7387\u9ad8": {
                    apiParam.put("low_refund_rate", value);
                    break;
                }
                case "\u76f4\u64ad\u5e26\u8d27\u7ed3\u7b97\u7387\u9ad8": {
                    apiParam.put("live_low_refund_rate", value);
                    break;
                }
                case "\u89c6\u9891\u5e26\u8d27\u7ed3\u7b97\u7387\u9ad8": {
                    apiParam.put("video_low_refund_rate", value);
                    break;
                }
                case "\u5e26\u8d27\u53e3\u7891": {
                    apiParam.put("sale_reputation", value);
                }
            }
        }
    }

    private void handleFansData(List<RequestOptionVO.ScreenItem> screenItems, Map<String, Object> apiParam) {
        if (screenItems == null || screenItems.size() == 0) {
            return;
        }
        for (RequestOptionVO.ScreenItem item : screenItems) {
            String title;
            String value = item.getValue();
            if (value == null) continue;
            switch (title = item.getTitle()) {
                case "\u7c89\u4e1d\u6027\u522b": {
                    apiParam.put("fans_gender", value);
                    break;
                }
                case "\u7c89\u4e1d\u5e74\u9f84": {
                    apiParam.put("fans_age", value);
                    break;
                }
                case "\u7c89\u4e1d\u57ce\u5e02\u7ebf": {
                    apiParam.put("fans_location", value);
                    break;
                }
                case "\u7c89\u4e1d\u4eba\u7fa4": {
                    apiParam.put("consumer_group", value);
                }
            }
        }
    }

    private void handlePriceQuoter(List<RequestOptionVO.ScreenItem> screenItems, Map<String, Object> apiParam) {
        if (screenItems == null || screenItems.size() == 0) {
            return;
        }
        for (RequestOptionVO.ScreenItem item : screenItems) {
            String title;
            String value = item.getValue();
            if (value == null) continue;
            switch (title = item.getTitle()) {
                case "\u4f63\u91d1\u62a5\u4ef7": {
                    apiParam.put("commission_quotation", value);
                    break;
                }
                case "\u6df7\u573a\u670d\u52a1\u8d39\u62a5\u4ef7": {
                    apiParam.put("fee_quotation", value);
                }
            }
        }
    }

    private List<DyTopManVO> transferApiIndexListResult(DyTopManIndexListPage apiResult) {
        List<DyTopManInfoEntity> list = apiResult.getList();
        if (list == null || list.size() == 0) {
            return null;
        }
        ArrayList<DyTopManVO> result = new ArrayList<DyTopManVO>(list.size());
        HashMap<String, DyTopManVO> map = new HashMap<String, DyTopManVO>(list.size());
        for (DyTopManInfoEntity dyTopManInfoEntity : list) {
            DyTopManVO bean = new DyTopManVO();
            result.add(bean);
            DyTopManInfoEntity.AuthorBase authorBase = dyTopManInfoEntity.getAuthorBase();
            bean.setAvatar(authorBase.getAvatar());
            bean.setTopmanLevelId(authorBase.getAuthorLevel().toString());
            bean.setTopmanLevel((String)DouYinTopManOptionSource.level.get(authorBase.getAuthorLevel()));
            bean.setTopmanName(authorBase.getNickname());
            bean.setTopmanRegion(authorBase.getCity());
            bean.setUid(authorBase.getUid());
            bean.setTopmanGenderId(authorBase.getGender().toString());
            bean.setTopmanGender((String)DouYinTopManOptionSource.gender.get(authorBase.getGender()));
            bean.setFansNum(authorBase.getFansNum());
            DyTopManInfoEntity.AuthorSale authorSale = dyTopManInfoEntity.getAuthorSale();
            bean.setSaleD30High(authorSale.getSaleD30High());
            bean.setSaleD30Low(authorSale.getSaleD30Low());
            DyTopManInfoEntity.AuthorLive authorLive = dyTopManInfoEntity.getAuthorLive();
            bean.setWatchingNumber(authorLive.getWatchingNumber());
            bean.setLiveGpmHigh(authorLive.getGpmHigh());
            bean.setLiveGpmLow(authorLive.getGpmLow());
            bean.setLiveSaleHigh(authorLive.getSaleHigh());
            bean.setLiveSaleLow(authorLive.getSaleLow());
            DyTopManInfoEntity.AuthorVideo authorVideo = dyTopManInfoEntity.getAuthorVideo();
            bean.setVideoGpmHigh(authorVideo.getGpmHigh());
            bean.setVideoGpmLow(authorVideo.getGpmLow());
            bean.setVideoSaleHigh(authorVideo.getVideoSaleHigh());
            bean.setVideoSaleLow(authorVideo.getVideoSaleLow());
            bean.setPlayMedian(authorVideo.getPlayMedian());
            DyTopManInfoEntity.AuthorTag authorTag = dyTopManInfoEntity.getAuthorTag();
            bean.setCategory(StringUtils.join(authorTag.getMainCate(), (String)","));
            bean.setContentType(StringUtils.join(authorTag.getWorkCate(), (String)","));
            bean.setMainSaleType(authorSale.getMainSaleType());
            bean.setDarkHorse(authorTag.getDarkHorse());
            bean.setHighReply(authorTag.getHighReply());
            bean.setHighCooperation(authorTag.getHighCooperation());
            if (authorTag.getIsStar().booleanValue()) {
                bean.setStar("1");
            } else {
                bean.setStar("0");
            }
            bean.setContactIcon(authorTag.getContactIcon());
            bean.setSatisfyRequirement(authorTag.getSatisfyRequirement().toPlainString());
            bean.setInvitationStatus(authorTag.getInvitationStatus().toString());
            bean.setInviteStatus(authorTag.getInviteStatus().toString());
            DyTopManInfoEntity.AuthorConf authorConf = dyTopManInfoEntity.getAuthorConf();
            DyTopManInfoEntity.AuthorConf.SaleRequirement saleRequirement = authorConf.getSaleRequirement();
            bean.setPriceType(saleRequirement.getPriceType().toString());
            bean.setPriceType2(saleRequirement.getType().toString());
            map.put(authorBase.getNickname() + "-" + authorBase.getCity(), bean);
        }
        this.checkCollectAndAdded(map);
        return result;
    }

    private List<AddedAndCollectVO> checkCollectAndAdded(Map<String, DyTopManVO> map) {
        AddedAndCollectVO addedAndCollect = new AddedAndCollectVO();
        Set<String> strings = map.keySet();
        List<String> topManNames = strings.stream().map(h -> h.split("-")[0]).distinct().collect(Collectors.toList());
        addedAndCollect.setTopManNames(topManNames);
        addedAndCollect.setPlatform("1");
        addedAndCollect.setLoginUser(SysUtil.getLoginUser());
        List<AddedAndCollectVO> addedAndCollects = ((TopManInformationMapper)this.baseMapper).checkAddedAndCollect(addedAndCollect);
        addedAndCollects.forEach(a -> {
            String topManNameRegion = a.getTopManName() + "-" + a.getRegion();
            DyTopManVO dyTopManVO = (DyTopManVO)map.get(topManNameRegion);
            if (dyTopManVO != null) {
                dyTopManVO.setTopManId(a.getTopManId());
                dyTopManVO.setIsCollection(a.getIsCollect());
                dyTopManVO.setIsAdded(a.getIsAdded());
            }
        });
        return addedAndCollects;
    }

    private QueryWrapper<DyTopManInformationHead> getQueryWrapperNew(SimplePostRequestParam<RequestOptionVO> topManDto) {
        Map screenItem;
        String[] columns;
        QueryWrapper queryWrapper = new QueryWrapper();
        String keyWord = topManDto.getKeyWord();
        if (keyWord != null && !"".equals(keyWord)) {
            queryWrapper.and(a -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)a.lambda().eq(DyTopManInformationHead::getTopmanId, (Object)keyWord)).or(b -> {
                    LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)b.like(DyTopManInformationHead::getTopmanName, (Object)keyWord);
                });
            });
        }
        String column = topManDto.getColumn();
        final String order = topManDto.getOrder();
        if (column != null && order != null && (columns = column.split(",")).length > 0) {
            QueryGenerator.doMultiFieldsOrder((QueryWrapper)queryWrapper, (Map)new HashMap<String, String[]>(2){
                {
                    super(x0);
                    this.put("order", order.split(","));
                    this.put("column", columns);
                }
            }, (Object)((Object)new DyTopManInformationHead()));
        }
        if ((screenItem = ((RequestOptionVO)topManDto.getFilterInfo()).getScreenItem()) != null && screenItem.size() > 0) {
            for (String key : screenItem.keySet()) {
                DyOptionType dyOptionType = DyOptionType.getDyOptionType((String)key);
                Assert.isNotNull((Object)dyOptionType, (String)I18nUtil.translate((String)"", (String)"\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u7c7b\u578b"));
                List screenItems = (List)screenItem.get(key);
                if (screenItems == null || screenItems.size() == 0) continue;
                SFunction & Serializable categoryOrContentType = null;
                switch (dyOptionType) {
                    case category: {
                        categoryOrContentType = DyTopManInformationHead::getCategory;
                    }
                    case contentType: {
                        if (categoryOrContentType == null) {
                            categoryOrContentType = DyTopManInformationHead::getContentType;
                        }
                        AtomicReference next = new AtomicReference();
                        queryWrapper.lambda().and(next::set);
                        for (int i = 0; i < screenItems.size(); ++i) {
                            RequestOptionVO.ScreenItem item = (RequestOptionVO.ScreenItem)screenItems.get(i);
                            ((LambdaQueryWrapper)next.get()).like((Object)categoryOrContentType, (Object)item.getTitle());
                            if (i == screenItems.size() - 1) continue;
                            ((LambdaQueryWrapper)next.get()).or(next::set);
                        }
                    }
                    case topManInfo: {
                        this.handleTopManInfoWrapper(screenItems, (QueryWrapper<DyTopManInformationHead>)queryWrapper);
                        break;
                    }
                    case saleData: {
                        this.handleSaleDataWrapper(screenItems, (QueryWrapper<DyTopManInformationHead>)queryWrapper);
                    }
                }
            }
        }
        return queryWrapper;
    }

    private void handleSaleDataWrapper(List<RequestOptionVO.ScreenItem> screenItems, QueryWrapper<DyTopManInformationHead> queryWrapper) {
        if (screenItems == null || screenItems.size() == 0) {
            return;
        }
        for (RequestOptionVO.ScreenItem item : screenItems) {
            String title;
            String value = item.getValue();
            if (value == null) continue;
            switch (title = item.getTitle()) {
                case "30\u65e5\u9500\u552e\u989d": {
                    this.handleMultipleQueryWrapperBetween(queryWrapper, value, DyTopManInformationHead::getSaleD30High);
                    break;
                }
                case "\u76f4\u64ad\u573a\u5747\u9500\u552e\u989d": {
                    this.handleMultipleQueryWrapperBetween(queryWrapper, value, DyTopManInformationHead::getLiveSaleHigh);
                    break;
                }
                case "\u76f4\u64ad\u89c2\u770b\u4eba\u6570": {
                    this.handleMultipleQueryWrapperBetween(queryWrapper, value, DyTopManInformationHead::getLiveWatchingNumber);
                    break;
                }
                case "\u76f4\u64adGPM": {
                    this.handleMultipleQueryWrapperBetween(queryWrapper, value, DyTopManInformationHead::getLiveGpmHigh);
                    break;
                }
                case "\u5355\u89c6\u9891\u9500\u552e\u989d": {
                    this.handleMultipleQueryWrapperBetween(queryWrapper, value, DyTopManInformationHead::getVideoSaleHigh);
                    break;
                }
                case "\u89c6\u9891\u64ad\u653e\u91cf": {
                    this.handleMultipleQueryWrapperBetween(queryWrapper, value, DyTopManInformationHead::getVideoPlayMedian);
                    break;
                }
                case "\u89c6\u9891GPM": {
                    this.handleMultipleQueryWrapperBetween(queryWrapper, value, DyTopManInformationHead::getVideoGpmHigh);
                    break;
                }
                case "\u5e26\u8d27\u5546\u54c1\u5747\u4ef7": 
                case "\u76f4\u64ad\u5546\u54c1\u5747\u4ef7": 
                case "\u89c6\u9891\u5546\u54c1\u5747\u4ef7": {
                    break;
                }
                case "\u7ed3\u7b97\u7387\u9ad8": 
                case "\u76f4\u64ad\u5e26\u8d27\u7ed3\u7b97\u7387\u9ad8": 
                case "\u89c6\u9891\u5e26\u8d27\u7ed3\u7b97\u7387\u9ad8": {
                    queryWrapper.lambda().eq(DyTopManInformationHead::getHighReply, (Object)"\u5904\u7406\u7387\u9ad8");
                    break;
                }
            }
        }
    }

    private void handleTopManInfoWrapper(List<RequestOptionVO.ScreenItem> screenItems, QueryWrapper<DyTopManInformationHead> queryWrapper) {
        if (screenItems == null || screenItems.size() == 0) {
            return;
        }
        for (RequestOptionVO.ScreenItem item : screenItems) {
            String title;
            String value = item.getValue();
            if (value == null) continue;
            switch (title = item.getTitle()) {
                case "\u8fbe\u4eba\u7b49\u7ea7": {
                    queryWrapper.lambda().eq(DyTopManInformationHead::getTopmanLevel, (Object)value);
                    break;
                }
                case "\u7c89\u4e1d\u603b\u6570": {
                    this.handleMultipleQueryWrapperBetween(queryWrapper, value, DyTopManInformationHead::getFansNum);
                    break;
                }
                case "\u8fbe\u4eba\u6027\u522b": {
                    queryWrapper.lambda().eq(DyTopManInformationHead::getTopmanSex, (Object)value);
                    break;
                }
                case "\u8fbe\u4eba\u5730\u57df": {
                    List region = (List)JSONObject.parseObject((String)value, List.class);
                    String regionParam = StringUtils.join((Iterable)region, (String)"\u00b7");
                    queryWrapper.lambda().eq(DyTopManInformationHead::getRegion, (Object)regionParam);
                    break;
                }
                case "\u662f\u5426\u7b7e\u7ea6\u673a\u6784": {
                    break;
                }
                case "\u7eaf\u4f63\u8fbe\u4eba": {
                    queryWrapper.lambda().eq(DyTopManInformationHead::getPriceType, (Object)"1");
                    queryWrapper.lambda().eq(DyTopManInformationHead::getPriceType2, (Object)"1");
                    break;
                }
                case "\u660e\u661f": {
                    queryWrapper.lambda().eq(DyTopManInformationHead::getStar, (Object)"true");
                    break;
                }
                case "\u9ed1\u9a6c": {
                    queryWrapper.lambda().isNotNull(DyTopManInformationHead::getDarkHorse);
                    break;
                }
                case "\u6709\u8054\u7cfb\u65b9\u5f0f": {
                    queryWrapper.lambda().isNotNull(DyTopManInformationHead::getContactIcon);
                }
            }
        }
    }

    private void handleMultipleQueryWrapperBetween(QueryWrapper<DyTopManInformationHead> queryWrapper, String value, SFunction<DyTopManInformationHead, ?> field) {
        AtomicReference next = new AtomicReference();
        queryWrapper.and(next::set);
        List tags = JSON.parseArray((String)value, MultipleOptionTag.class);
        for (int i = 0; i < tags.size(); ++i) {
            MultipleOptionTag item = (MultipleOptionTag)tags.get(i);
            this.handleScope((QueryWrapper<DyTopManInformationHead>)((QueryWrapper)next.get()), item.getName(), field);
            if (i == tags.size() - 1) continue;
            ((QueryWrapper)next.get()).or(next::set);
        }
    }

    private void handleScope(QueryWrapper<DyTopManInformationHead> queryWrapper, String value, SFunction<DyTopManInformationHead, ?> function) {
        if (value.contains("\u4ee5\u4e0b")) {
            queryWrapper.lambda().lt(function, (Object)this.formatNumber(value));
        }
        if (value.contains("\u4ee5\u4e0a")) {
            queryWrapper.lambda().gt(function, (Object)this.formatNumber(value));
        }
        if (value.contains("-")) {
            String[] split = value.split("-");
            queryWrapper.lambda().between(function, (Object)this.formatNumber(split[0]), (Object)this.formatNumber(split[1]));
        }
    }

    private Integer formatNumber(String value) {
        return Integer.valueOf(value.replace("\u4ee5\u4e0b", "").replace("\u4ee5\u4e0a", "").replace("w", "0000"));
    }

    @Override
    public List<TopManOptionsEntity> getOptions(String type, String clearCache) {
        ArrayList<TopManOptionsEntity> result = new ArrayList<TopManOptionsEntity>(10);
        TopManOptionsEntity vo = DyOptionType.category.getTopManOptionsEntity();
        vo.setChildren(DouYinTopManOptionSource.toChildren((Map)DouYinTopManOptionSource.category, (OptionComponentType)OptionComponentType.RButton));
        result.add(vo);
        TopManOptionsEntity vo1 = DyOptionType.contentType.getTopManOptionsEntity();
        vo1.setChildren(DouYinTopManOptionSource.toChildren((Map)DouYinTopManOptionSource.contentType, (OptionComponentType)OptionComponentType.RButton));
        result.add(vo1);
        result.add(this.handleTopManInfoVo(type));
        result.add(this.handleSaleDataVo(type));
        if (!"0".equals(type)) {
            result.add(this.handleFansDataVo());
            result.add(this.handlePriceQuoterVo(type));
        }
        return result;
    }

    @Override
    @Transactional
    public void collectNew(DouYinTopManCollectDTO dto) {
        LoginUser loginUser = SysUtil.getLoginUser();
        String elsAccount = loginUser.getElsAccount();
        String subAccount = loginUser.getSubAccount();
        String topManId = this.addToMySqlNew(dto);
        this.addMarkToMongo(new DyTopManCollectVo("11", topManId));
        if (MarkYn.check(dto.getCollect())) {
            TopManCollectBean topManCollectBean = new TopManCollectBean();
            topManCollectBean.setTopmanId(topManId);
            topManCollectBean.setPlatform("1");
            topManCollectBean.setElsAccount(elsAccount);
            topManCollectBean.setSubAccount(subAccount);
            this.topManCollectService.save((Object)topManCollectBean);
        } else {
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.lambda().eq(BaseEntity::getElsAccount, (Object)elsAccount);
            queryWrapper.lambda().eq(TopManCollectBean::getSubAccount, (Object)subAccount);
            queryWrapper.lambda().eq(TopManCollectBean::getPlatform, (Object)"1");
            queryWrapper.lambda().eq(TopManCollectBean::getTopmanId, (Object)topManId);
            this.topManCollectService.remove((Wrapper)queryWrapper);
        }
    }

    private void addMarkToMongo(DyTopManCollectVo dyTopManCollectVo) {
        MongoCollectionType collectMark = MongoCollectionType.TB_DY_ELS_TOP_MAN;
        String userId = String.valueOf(dyTopManCollectVo.getTopManId());
        HashMap<String, String> param = new HashMap<String, String>(2);
        param.put("topManId", String.valueOf(userId));
        Map<String, TopManSpiderMark> data = this.mongoHandleService.handleMongo(collectMark, param, TopManSpiderMark.class);
        TopManSpiderMark topManSpiderMark = data.get(userId);
        if (topManSpiderMark != null) {
            Query query = new Query((CriteriaDefinition)Criteria.where((String)"topManId").is((Object)String.valueOf(userId)));
            Update update = new Update().set("count", (Object)(topManSpiderMark.getCount() + 1));
            this.mongoTemplate.upsert(query, (UpdateDefinition)update, TopManSpiderMark.class, collectMark.getCollectName());
        } else {
            topManSpiderMark = new TopManSpiderMark();
            topManSpiderMark.setTaskType(dyTopManCollectVo.getTaskType());
            topManSpiderMark.setCount(1);
            topManSpiderMark.setTopManId(userId);
            this.mongoTemplate.insert((Object)topManSpiderMark, collectMark.getCollectName());
        }
    }

    @Override
    public String addToMySqlNew(DouYinTopManCollectDTO dto) {
        DyTopManVO entity = dto.getEntity();
        String topManId = StringUtils.isBlank((CharSequence)dto.getTiktokNo()) ? this.seleteTopManId(entity) : dto.getTiktokNo();
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(DyTopManInformationHead::getTopmanId, (Object)topManId);
        DyTopManInformationHead dyTopManInformationHead = (DyTopManInformationHead)((Object)this.dyTopManInformationHeadService.getOne((Wrapper)queryWrapper));
        if (dyTopManInformationHead == null) {
            dyTopManInformationHead = new DyTopManInformationHead();
        }
        BeanUtils.copyProperties((Object)entity, (Object)((Object)dyTopManInformationHead));
        dyTopManInformationHead.setTopmanId(topManId);
        if (StringUtils.isNotBlank((CharSequence)entity.getAvatar()) && entity.getAvatar().contains("-sign")) {
            String newAvatar = entity.getAvatar().replace("-sign", "");
            dyTopManInformationHead.setTopmanAvatar(newAvatar);
        } else {
            dyTopManInformationHead.setTopmanAvatar(entity.getAvatar());
        }
        dyTopManInformationHead.setTopmanSex(entity.getTopmanGenderId());
        dyTopManInformationHead.setTopmanLevel(entity.getTopmanLevelId());
        dyTopManInformationHead.setRegion(entity.getTopmanRegion());
        dyTopManInformationHead.setLiveWatchingNumber(entity.getWatchingNumber());
        dyTopManInformationHead.setVideoPlayMedian(entity.getPlayMedian());
        this.dyTopManInformationHeadService.saveOrUpdate((Object)dyTopManInformationHead);
        return topManId;
    }

    private String seleteTopManId(DyTopManVO entity) {
        DouYinTopManDetailDTO param = new DouYinTopManDetailDTO();
        param.setAvatar(entity.getAvatar());
        param.setTopManName(entity.getTopmanName());
        param.setTopmanRegion(entity.getTopmanRegion());
        param.setTopManId(entity.getUid());
        TopManDetailDouYinMcnVO vo = this.getDouYinIdNew(param);
        return vo.getUniqueId();
    }

    @Override
    public DyTopManAddPopupVO addPopupInfo(DouYinTopManDetailDTO param) {
        DyTopManAddPopupVO popupVO = new DyTopManAddPopupVO();
        param.setCheckType("1");
        param.setContactType("1");
        TopManResultDetailBodyContacr detailBody1 = (TopManResultDetailBodyContacr)this.queryDetailContacr(param);
        param.setContactType("2");
        TopManResultDetailBodyContacr detailBody2 = (TopManResultDetailBodyContacr)this.queryDetailContacr(param);
        popupVO.setContactPerson(param.getTopManName());
        popupVO.setContactPhone(detailBody1.getContactValue());
        popupVO.setWechat(detailBody2.getContactValue());
        return popupVO;
    }

    @Override
    public void transferBean(DyTopManInfoEntity source, DyTopManInformationHead target) {
        DyTopManInfoEntity.AuthorTag authorTag = source.getAuthorTag();
        target.setCategory(StringUtils.join(authorTag.getMainCate(), (String)","));
        target.setContentType(StringUtils.join(authorTag.getWorkCate(), (String)","));
        target.setContactIcon(authorTag.getContactIcon());
        target.setDarkHorse(authorTag.getDarkHorse());
        target.setHighCooperation(authorTag.getHighCooperation());
        target.setHighReply(authorTag.getHighReply());
        target.setInvitationStatus(String.valueOf(authorTag.getInvitationStatus()));
        target.setInviteStatus(String.valueOf(authorTag.getInviteStatus()));
        target.setSatisfyRequirement(authorTag.getSatisfyRequirement().toPlainString());
        DyTopManInfoEntity.AuthorBase authorBase = source.getAuthorBase();
        target.setFansNum(authorBase.getFansNum());
        target.setTopmanName(authorBase.getNickname());
        target.setTopmanSex(String.valueOf(authorBase.getGender()));
        target.setRegion(authorBase.getCity());
        target.setTopmanAvatar(authorBase.getAvatar());
        target.setTopmanLevel(String.valueOf(authorBase.getAuthorLevel()));
        target.setUid(authorBase.getUid());
        DyTopManInfoEntity.AuthorConf authorConf = source.getAuthorConf();
        DyTopManInfoEntity.AuthorConf.SaleRequirement saleRequirement = authorConf.getSaleRequirement();
        target.setPriceType(String.valueOf(saleRequirement.getPriceType()));
        target.setPriceType2(String.valueOf(saleRequirement.getType()));
        DyTopManInfoEntity.AuthorLive authorLive = source.getAuthorLive();
        target.setLiveGpmHigh(authorLive.getGpmHigh());
        target.setLiveGpmLow(authorLive.getGpmLow());
        target.setLiveSaleHigh(authorLive.getSaleHigh());
        target.setLiveSaleLow(authorLive.getSaleLow());
        target.setLiveWatchingNumber(authorLive.getWatchingNumber());
        DyTopManInfoEntity.AuthorVideo authorVideo = source.getAuthorVideo();
        target.setVideoGpmHigh(authorVideo.getGpmHigh());
        target.setVideoGpmLow(authorVideo.getGpmLow());
        target.setVideoSaleHigh(authorVideo.getVideoSaleHigh());
        target.setVideoSaleLow(authorVideo.getVideoSaleLow());
        target.setVideoPlayMedian(authorVideo.getPlayMedian());
        DyTopManInfoEntity.AuthorSale authorSale = source.getAuthorSale();
        target.setMainSaleType(authorSale.getMainSaleType());
        target.setSaleD30High(authorSale.getSaleD30High());
        target.setSaleD30Low(authorSale.getSaleD30Low());
    }

    @Override
    public List<DouYinTopManInformationBaseSimilarTalentEntity> queryBaseSimilarTalent(String fromUid, String product) throws IOException {
        String url = this.spiderBaseProperties.getTopManUrl() + "/doudian/similar/talent?fromUid=" + fromUid + "&product=" + product;
        JSONObject jsonObject = HttpRequestUtils.httpGet(url);
        if (jsonObject == null) {
            return new ArrayList<DouYinTopManInformationBaseSimilarTalentEntity>();
        }
        JSONArray data = jsonObject.getJSONArray("data");
        return data.toJavaList(DouYinTopManInformationBaseSimilarTalentEntity.class);
    }

    @Override
    public DouYinTopManInformationLiveDetailsAnalysisEntity queryDetailsLiveAnalysis(String uid, String product, String days) throws IOException {
        String url = this.spiderBaseProperties.getTopManUrl() + "/doudian/live/details/analysis?uid=" + uid + "&product=" + product + "&days=" + days;
        JSONObject jsonObject = HttpRequestUtils.httpGet(url);
        if (jsonObject == null) {
            return new DouYinTopManInformationLiveDetailsAnalysisEntity();
        }
        DouYinTopManInformationLiveDetailsAnalysisEntity.LiveDetails liveDetails = (DouYinTopManInformationLiveDetailsAnalysisEntity.LiveDetails)jsonObject.toJavaObject(DouYinTopManInformationLiveDetailsAnalysisEntity.LiveDetails.class);
        DouYinTopManInformationLiveDetailsAnalysisEntity.ChartDataTrends watching = (DouYinTopManInformationLiveDetailsAnalysisEntity.ChartDataTrends)jsonObject.getObject("watching", DouYinTopManInformationLiveDetailsAnalysisEntity.ChartDataTrends.class);
        DouYinTopManInformationLiveDetailsAnalysisEntity.ChartDataTrends likes = (DouYinTopManInformationLiveDetailsAnalysisEntity.ChartDataTrends)jsonObject.getObject("likes", DouYinTopManInformationLiveDetailsAnalysisEntity.ChartDataTrends.class);
        DouYinTopManInformationLiveDetailsAnalysisEntity.ChartDataTrends comments = (DouYinTopManInformationLiveDetailsAnalysisEntity.ChartDataTrends)jsonObject.getObject("comments", DouYinTopManInformationLiveDetailsAnalysisEntity.ChartDataTrends.class);
        DouYinTopManInformationLiveDetailsAnalysisEntity.ChartDataTrends shares = (DouYinTopManInformationLiveDetailsAnalysisEntity.ChartDataTrends)jsonObject.getObject("shares", DouYinTopManInformationLiveDetailsAnalysisEntity.ChartDataTrends.class);
        DouYinTopManInformationLiveDetailsAnalysisEntity.ChartDataTrends peaks = (DouYinTopManInformationLiveDetailsAnalysisEntity.ChartDataTrends)jsonObject.getObject("peaks", DouYinTopManInformationLiveDetailsAnalysisEntity.ChartDataTrends.class);
        DouYinTopManInformationLiveDetailsAnalysisEntity liveDetailsAnalysis = new DouYinTopManInformationLiveDetailsAnalysisEntity();
        liveDetailsAnalysis.setLiveDetails(liveDetails);
        liveDetailsAnalysis.setWatching(watching);
        liveDetailsAnalysis.setLikes(likes);
        liveDetailsAnalysis.setComments(comments);
        liveDetailsAnalysis.setShares(shares);
        liveDetailsAnalysis.setPeaks(peaks);
        return liveDetailsAnalysis;
    }

    @Override
    public IPage<DouYinTopManInformationLiveListEntity> queryDetailsLiveList(String uid, String product, String days, long page, long size) throws IOException {
        String url = this.spiderBaseProperties.getTopManUrl() + "/doudian/live/details/list?uid=" + uid + "&product=" + product + "&days=" + days + "&page=" + page;
        System.out.println(url);
        JSONObject jsonObject = HttpRequestUtils.httpGet(url);
        if (jsonObject == null) {
            return new Page();
        }
        JSONArray data = jsonObject.getJSONArray("data");
        List douYinTopManInformationLiveListEntities = data.toJavaList(DouYinTopManInformationLiveListEntity.class);
        Page pageData = new Page(page, size, (long)jsonObject.getInteger("total").intValue());
        pageData.setRecords(douYinTopManInformationLiveListEntities);
        return pageData;
    }

    @Override
    public DouYinTopManInformationVideoDetailsAnalysisEntity queryDetailsVideoAnalysis(String uid, String product) {
        String url = this.spiderBaseProperties.getTopManUrl() + "/doudian/video/details/analysis?uid=" + uid + "&product=" + product;
        System.out.println(url);
        JSONObject jsonObject = HttpRequestUtils.httpGet(url);
        if (jsonObject == null) {
            return new DouYinTopManInformationVideoDetailsAnalysisEntity();
        }
        DouYinTopManInformationVideoDetailsAnalysisEntity.VideoDetails videoDetails = (DouYinTopManInformationVideoDetailsAnalysisEntity.VideoDetails)jsonObject.toJavaObject(DouYinTopManInformationVideoDetailsAnalysisEntity.VideoDetails.class);
        DouYinTopManInformationVideoDetailsAnalysisEntity.ChartDataTrends plays = (DouYinTopManInformationVideoDetailsAnalysisEntity.ChartDataTrends)jsonObject.getObject("plays", DouYinTopManInformationVideoDetailsAnalysisEntity.ChartDataTrends.class);
        DouYinTopManInformationVideoDetailsAnalysisEntity.ChartDataTrends likes = (DouYinTopManInformationVideoDetailsAnalysisEntity.ChartDataTrends)jsonObject.getObject("likes", DouYinTopManInformationVideoDetailsAnalysisEntity.ChartDataTrends.class);
        DouYinTopManInformationVideoDetailsAnalysisEntity.ChartDataTrends comments = (DouYinTopManInformationVideoDetailsAnalysisEntity.ChartDataTrends)jsonObject.getObject("comments", DouYinTopManInformationVideoDetailsAnalysisEntity.ChartDataTrends.class);
        DouYinTopManInformationVideoDetailsAnalysisEntity.ChartDataTrends shares = (DouYinTopManInformationVideoDetailsAnalysisEntity.ChartDataTrends)jsonObject.getObject("shares", DouYinTopManInformationVideoDetailsAnalysisEntity.ChartDataTrends.class);
        DouYinTopManInformationVideoDetailsAnalysisEntity detailsAnalysis = new DouYinTopManInformationVideoDetailsAnalysisEntity();
        detailsAnalysis.setVideoDetails(videoDetails);
        detailsAnalysis.setPlays(plays);
        detailsAnalysis.setLikes(likes);
        detailsAnalysis.setComments(comments);
        detailsAnalysis.setShares(shares);
        return detailsAnalysis;
    }

    @Override
    public IPage<DouYinTopManInformationVideoListEntity> queryDetailsVideoList(String uid, String product, long page, long size) throws IOException {
        String url = this.spiderBaseProperties.getTopManUrl() + "/doudian/video/details/list?uid=" + uid + "&product=" + product + "&page=" + page;
        System.out.println(url);
        JSONObject jsonObject = HttpRequestUtils.httpGet(url);
        if (jsonObject == null) {
            return new Page();
        }
        JSONArray data = jsonObject.getJSONArray("data");
        List douYinTopManInformationVideoListEntities = data.toJavaList(DouYinTopManInformationVideoListEntity.class);
        Page pageData = new Page(page, size, (long)jsonObject.getInteger("total").intValue());
        pageData.setRecords(douYinTopManInformationVideoListEntities);
        return pageData;
    }

    @Override
    public Object queryDetailsFanAnalysis(String uid, String fanType, String worksType) {
        String url = this.spiderBaseProperties.getTopManUrl() + "/doudian/fan/details/analysis?uid=" + uid + "&fanType=" + fanType + "&worksType=" + worksType;
        System.out.println(url);
        JSONObject jsonObject = HttpRequestUtils.httpGet(url);
        if (jsonObject == null) {
            return new DouYinTopManInformationFanAnalysisEntity();
        }
        if (fanType.equals("2")) {
            HashMap<String, DouYinTopManInformationFanAnalysisEntity> resultMap = new HashMap<String, DouYinTopManInformationFanAnalysisEntity>();
            JSONObject jsonObject7d = jsonObject.getJSONObject("7d");
            DouYinTopManInformationFanAnalysisEntity douYinTopManInformationFanAnalysis7d = this.handleDouYinTopManInformationFanAnalysisEntity(jsonObject7d);
            JSONObject jsonObject30d = jsonObject.getJSONObject("30d");
            DouYinTopManInformationFanAnalysisEntity douYinTopManInformationFanAnalysis30d = this.handleDouYinTopManInformationFanAnalysisEntity(jsonObject30d);
            JSONObject jsonObject90d = jsonObject.getJSONObject("90d");
            DouYinTopManInformationFanAnalysisEntity douYinTopManInformationFanAnalysis90d = this.handleDouYinTopManInformationFanAnalysisEntity(jsonObject90d);
            resultMap.put("7d", douYinTopManInformationFanAnalysis7d);
            resultMap.put("30d", douYinTopManInformationFanAnalysis30d);
            resultMap.put("90d", douYinTopManInformationFanAnalysis90d);
            return resultMap;
        }
        return this.handleDouYinTopManInformationFanAnalysisEntity(jsonObject);
    }

    private DouYinTopManInformationFanAnalysisEntity handleDouYinTopManInformationFanAnalysisEntity(JSONObject jsonObject) {
        DouYinTopManInformationFanAnalysisEntity douYinTopManInformationFanAnalysisEntity = (DouYinTopManInformationFanAnalysisEntity)jsonObject.toJavaObject(DouYinTopManInformationFanAnalysisEntity.class);
        JSONArray fanPortrait = jsonObject.getJSONArray("fanPortrait");
        List fanPortraitOverviews = fanPortrait.toJavaList(DouYinTopManInformationFanAnalysisEntity.FanPortraitOverview.class);
        DouYinTopManInformationFanAnalysisEntity.FanCommonAttribute increment = (DouYinTopManInformationFanAnalysisEntity.FanCommonAttribute)jsonObject.getObject("increment", DouYinTopManInformationFanAnalysisEntity.FanCommonAttribute.class);
        DouYinTopManInformationFanAnalysisEntity.FanCommonAttribute total = (DouYinTopManInformationFanAnalysisEntity.FanCommonAttribute)jsonObject.getObject("total", DouYinTopManInformationFanAnalysisEntity.FanCommonAttribute.class);
        DouYinTopManInformationFanAnalysisEntity.FanCommonAttribute gender = (DouYinTopManInformationFanAnalysisEntity.FanCommonAttribute)jsonObject.getObject("gender", DouYinTopManInformationFanAnalysisEntity.FanCommonAttribute.class);
        DouYinTopManInformationFanAnalysisEntity.FanCommonAttribute age = (DouYinTopManInformationFanAnalysisEntity.FanCommonAttribute)jsonObject.getObject("age", DouYinTopManInformationFanAnalysisEntity.FanCommonAttribute.class);
        DouYinTopManInformationFanAnalysisEntity.FanCommonAttribute consumeCrowdRate = (DouYinTopManInformationFanAnalysisEntity.FanCommonAttribute)jsonObject.getObject("consumeCrowdRate", DouYinTopManInformationFanAnalysisEntity.FanCommonAttribute.class);
        DouYinTopManInformationFanAnalysisEntity.FanCommonAttribute activity = (DouYinTopManInformationFanAnalysisEntity.FanCommonAttribute)jsonObject.getObject("activity", DouYinTopManInformationFanAnalysisEntity.FanCommonAttribute.class);
        DouYinTopManInformationFanAnalysisEntity.FanCommonAttribute equipment = (DouYinTopManInformationFanAnalysisEntity.FanCommonAttribute)jsonObject.getObject("equipment", DouYinTopManInformationFanAnalysisEntity.FanCommonAttribute.class);
        DouYinTopManInformationFanAnalysisEntity.FanCommonAttribute guestPrice = (DouYinTopManInformationFanAnalysisEntity.FanCommonAttribute)jsonObject.getObject("guestPrice", DouYinTopManInformationFanAnalysisEntity.FanCommonAttribute.class);
        DouYinTopManInformationFanAnalysisEntity.FanCommonAttribute category = (DouYinTopManInformationFanAnalysisEntity.FanCommonAttribute)jsonObject.getObject("category", DouYinTopManInformationFanAnalysisEntity.FanCommonAttribute.class);
        JSONArray regionDataList = jsonObject.getJSONArray("region");
        List regions = regionDataList.toJavaList(DouYinTopManInformationFanAnalysisEntity.Region.class);
        JSONArray provinceDataList = jsonObject.getJSONArray("province");
        List provinces = provinceDataList.toJavaList(DouYinTopManInformationFanAnalysisEntity.Region.class);
        JSONArray cityDataList = jsonObject.getJSONArray("city");
        List citys = cityDataList.toJavaList(DouYinTopManInformationFanAnalysisEntity.Region.class);
        DouYinTopManInformationFanAnalysisEntity.FanCommonAttribute cityLevel = (DouYinTopManInformationFanAnalysisEntity.FanCommonAttribute)jsonObject.getObject("cityLevel", DouYinTopManInformationFanAnalysisEntity.FanCommonAttribute.class);
        douYinTopManInformationFanAnalysisEntity.setFanPortrait(fanPortraitOverviews);
        douYinTopManInformationFanAnalysisEntity.setIncrement(increment);
        douYinTopManInformationFanAnalysisEntity.setTotal(total);
        douYinTopManInformationFanAnalysisEntity.setGender(gender);
        douYinTopManInformationFanAnalysisEntity.setAge(age);
        douYinTopManInformationFanAnalysisEntity.setConsumeCrowdRate(consumeCrowdRate);
        douYinTopManInformationFanAnalysisEntity.setActivity(activity);
        douYinTopManInformationFanAnalysisEntity.setEquipment(equipment);
        douYinTopManInformationFanAnalysisEntity.setGuestPrice(guestPrice);
        douYinTopManInformationFanAnalysisEntity.setCategory(category);
        douYinTopManInformationFanAnalysisEntity.setRegion(regions);
        douYinTopManInformationFanAnalysisEntity.setProvince(provinces);
        douYinTopManInformationFanAnalysisEntity.setCity(citys);
        douYinTopManInformationFanAnalysisEntity.setCityLevel(cityLevel);
        return douYinTopManInformationFanAnalysisEntity;
    }

    private TopManOptionsEntity handlePriceQuoterVo(String type) {
        TopManOptionsEntity vo = DyOptionType.priceQuoter.getTopManOptionsEntity();
        ArrayList<TopManOptionsEntity.Tag> childrenList = new ArrayList<TopManOptionsEntity.Tag>(10);
        vo.setChildren(childrenList);
        TopManOptionsEntity.Tag tag = new TopManOptionsEntity.Tag();
        childrenList.add(tag);
        tag.setComponentType(OptionComponentType.RSelect);
        tag.setStarTagName("\u4f63\u91d1\u62a5\u4ef7");
        tag.setSubTags(DouYinTopManOptionSource.toSubTag((Map)DouYinTopManOptionSource.commissionQuote));
        if ("1".equals(type) || "2".equals(type)) {
            tag = new TopManOptionsEntity.Tag();
            childrenList.add(tag);
            tag.setComponentType(OptionComponentType.RSelect);
            tag.setStarTagName("\u6df7\u573a\u670d\u52a1\u8d39\u62a5\u4ef7");
            tag.setTips("\u8fbe\u4eba\u6df7\u573a\u670d\u52a1\u8d39\u62a5\u4ef7\uff0c\u5b9e\u9645\u5408\u4f5c\u4ef7\u683c\u53ef\u518d\u4e0e\u8fbe\u4eba\u6c9f\u901a");
            tag.setSubTags(DouYinTopManOptionSource.toSubTag((Map)DouYinTopManOptionSource.serviceFee));
        }
        return vo;
    }

    private TopManOptionsEntity handleTopManInfoVo(String type) {
        TopManOptionsEntity vo = DyOptionType.topManInfo.getTopManOptionsEntity();
        ArrayList<TopManOptionsEntity.Tag> childrenList = new ArrayList<TopManOptionsEntity.Tag>(10);
        vo.setChildren(childrenList);
        TopManOptionsEntity.Tag tag = new TopManOptionsEntity.Tag();
        childrenList.add(tag);
        tag.setComponentType(OptionComponentType.RSelect);
        tag.setStarTagName("\u8fbe\u4eba\u7b49\u7ea7");
        tag.setSubTags(DouYinTopManOptionSource.toSubTag((Map)DouYinTopManOptionSource.level));
        if (!"0".equals(type)) {
            tag = new TopManOptionsEntity.Tag();
            childrenList.add(tag);
            tag.setComponentType(OptionComponentType.RSelect);
            tag.setStarTagName("\u7c89\u4e1d\u603b\u6570");
            tag.setSubTags(DouYinTopManOptionSource.toSubTag((Map)DouYinTopManOptionSource.fansNo));
        }
        tag = new TopManOptionsEntity.Tag();
        childrenList.add(tag);
        tag.setComponentType(OptionComponentType.RSelect);
        tag.setStarTagName("\u8fbe\u4eba\u6027\u522b");
        tag.setSubTags(DouYinTopManOptionSource.toSubTag((Map)DouYinTopManOptionSource.gender));
        tag = new TopManOptionsEntity.Tag();
        childrenList.add(tag);
        tag.setComponentType(OptionComponentType.RCascader);
        tag.setStarTagName("\u8fbe\u4eba\u5730\u57df");
        Map topManArea = DouYinTopManOptionSource.topManArea;
        ArrayList<TopManOptionsEntity.Tag> subTags = new ArrayList<TopManOptionsEntity.Tag>(topManArea.size());
        tag.setSubTags(subTags);
        for (Map.Entry gp : topManArea.entrySet()) {
            TopManOptionsEntity.Tag province = new TopManOptionsEntity.Tag();
            subTags.add(province);
            province.setStarTagName((String)gp.getKey());
            province.setStarTagValue((String)gp.getKey());
            List value = (List)gp.getValue();
            ArrayList citys = new ArrayList(value.size());
            province.setSubTags(citys);
            province.setLevel(Integer.valueOf(1));
            value.forEach(a -> {
                TopManOptionsEntity.Tag city = new TopManOptionsEntity.Tag();
                citys.add(city);
                city.setLevel(Integer.valueOf(2));
                city.setStarTagName(a);
                city.setStarTagValue(a);
            });
        }
        if (!"0".equals(type)) {
            tag = new TopManOptionsEntity.Tag();
            childrenList.add(tag);
            tag.setComponentType(OptionComponentType.RSelect);
            tag.setStarTagName("\u662f\u5426\u7b7e\u7ea6\u673a\u6784");
            tag.setSubTags(DouYinTopManOptionSource.toSubTag((Map)DouYinTopManOptionSource.yesOrNo));
        }
        tag = new TopManOptionsEntity.Tag();
        childrenList.add(tag);
        tag.setComponentType(OptionComponentType.RCheckbox);
        tag.setStarTagName("\u7eaf\u4f63\u8fbe\u4eba");
        tag = new TopManOptionsEntity.Tag();
        childrenList.add(tag);
        tag.setComponentType(OptionComponentType.RCheckbox);
        tag.setStarTagName("\u660e\u661f");
        tag = new TopManOptionsEntity.Tag();
        childrenList.add(tag);
        tag.setComponentType(OptionComponentType.RCheckbox);
        tag.setStarTagName("\u9ed1\u9a6c");
        tag = new TopManOptionsEntity.Tag();
        childrenList.add(tag);
        tag.setComponentType(OptionComponentType.RCheckbox);
        tag.setStarTagName("\u6709\u8054\u7cfb\u65b9\u5f0f");
        switch (type) {
            case "1": {
                tag = new TopManOptionsEntity.Tag();
                childrenList.add(tag);
                tag.setComponentType(OptionComponentType.RCheckbox);
                tag.setStarTagName("\u79cd\u8349\u6548\u7387\u9ad8");
                break;
            }
            case "2": {
                tag = new TopManOptionsEntity.Tag();
                childrenList.add(tag);
                tag.setComponentType(OptionComponentType.RCheckbox);
                tag.setStarTagName("\u76f4\u64ad\u79cd\u8349\u6548\u7387\u9ad8");
                break;
            }
            case "3": {
                tag = new TopManOptionsEntity.Tag();
                childrenList.add(tag);
                tag.setComponentType(OptionComponentType.RCheckbox);
                tag.setStarTagName("\u89c6\u9891\u79cd\u8349\u6548\u7387\u9ad8");
                break;
            }
        }
        return vo;
    }

    private TopManOptionsEntity handleFansDataVo() {
        TopManOptionsEntity vo = DyOptionType.fansData.getTopManOptionsEntity();
        ArrayList<TopManOptionsEntity.Tag> childrenList = new ArrayList<TopManOptionsEntity.Tag>(10);
        vo.setChildren(childrenList);
        TopManOptionsEntity.Tag tag = new TopManOptionsEntity.Tag();
        childrenList.add(tag);
        tag.setComponentType(OptionComponentType.RSelect);
        tag.setStarTagName("\u7c89\u4e1d\u6027\u522b");
        tag.setSubTags(DouYinTopManOptionSource.toSubTag((Map)DouYinTopManOptionSource.fansGender));
        tag = new TopManOptionsEntity.Tag();
        childrenList.add(tag);
        tag.setComponentType(OptionComponentType.RSelect);
        tag.setStarTagName("\u7c89\u4e1d\u5e74\u9f84");
        tag.setSubTags(DouYinTopManOptionSource.toSubTag((Map)DouYinTopManOptionSource.fansAge));
        tag = new TopManOptionsEntity.Tag();
        childrenList.add(tag);
        tag.setComponentType(OptionComponentType.RSelect);
        tag.setStarTagName("\u7c89\u4e1d\u57ce\u5e02\u7ebf");
        tag.setSubTags(DouYinTopManOptionSource.toSubTag((Map)DouYinTopManOptionSource.fansArea));
        tag = new TopManOptionsEntity.Tag();
        childrenList.add(tag);
        tag.setComponentType(OptionComponentType.RSelect);
        tag.setStarTagName("\u7c89\u4e1d\u4eba\u7fa4");
        tag.setTips("\u8fbe\u4eba\u7c89\u4e1d\u6309\u6d88\u8d39\u80fd\u529b\u3001\u6240\u5904\u5730\u57df\u7b49\u56e0\u7d20\u8fdb\u884c\u7684\u4eba\u7fa4\u5305\u5206\u7c7b");
        tag.setSubTags(DouYinTopManOptionSource.toSubTag((Map)DouYinTopManOptionSource.eightCrowds));
        return vo;
    }

    private TopManOptionsEntity handleSaleDataVo(String type) {
        TopManOptionsEntity.Tag tag;
        TopManOptionsEntity vo = DyOptionType.saleData.getTopManOptionsEntity();
        ArrayList<TopManOptionsEntity.Tag> childrenList = new ArrayList<TopManOptionsEntity.Tag>(10);
        vo.setChildren(childrenList);
        if ("1".equals(type)) {
            tag = new TopManOptionsEntity.Tag();
            childrenList.add(tag);
            tag.setComponentType(OptionComponentType.RSelect);
            tag.setStarTagName("30\u65e5\u9500\u552e\u989d");
            tag.setTips("\u8fd130\u5929\u8fbe\u4eba\u901a\u8fc7\u6240\u6709\u6765\u6e90\u5e26\u8d27\u7684\u603b\u9500\u552e\u989d");
            tag.setSubTags(DouYinTopManOptionSource.toSubTag((Map)DouYinTopManOptionSource.saleAvg));
        }
        String priceAvgTagName = null;
        String markupRateTagName = null;
        if ("1".equals(type) || "2".equals(type)) {
            tag = new TopManOptionsEntity.Tag();
            childrenList.add(tag);
            tag.setComponentType(OptionComponentType.RSelect);
            tag.setStarTagName("\u76f4\u64ad\u573a\u5747\u9500\u552e\u989d");
            tag.setTips("\u8fd130\u5929\u5e26\u8d27\u76f4\u64ad\u573a\u6b21\u7684\u5e73\u5747GMV\uff0c\u5254\u9664\u5f00\u64ad\u65f6\u95f4\u5c0f\u4e8e25\u5206\u949f\u7684\u76f4\u64ad");
            tag.setSubTags(DouYinTopManOptionSource.toSubTag((Map)DouYinTopManOptionSource.saleAvg));
            tag = new TopManOptionsEntity.Tag();
            childrenList.add(tag);
            tag.setComponentType(OptionComponentType.RSelect);
            tag.setTips("\u8fd130\u5929\u5e26\u8d27\u76f4\u64ad\u7684\u89c2\u770b\u4eba\u6570\u7684\u4e2d\u4f4d\u6570\uff0c\u5254\u9664\u5f00\u64ad\u65f6\u95f4\u5c0f\u4e8e25\u5206\u949f\u7684\u76f4\u64ad");
            tag.setStarTagName("\u76f4\u64ad\u89c2\u770b\u4eba\u6570");
            tag.setSubTags(DouYinTopManOptionSource.toSubTag((Map)DouYinTopManOptionSource.viwerCount));
            tag = new TopManOptionsEntity.Tag();
            childrenList.add(tag);
            tag.setComponentType(OptionComponentType.RSelect);
            tag.setStarTagName("\u76f4\u64adGPM");
            tag.setTips("\u8fd130\u5929\u5e26\u8d27\u76f4\u64ad\u8d2d\u7269\u8f66\u5343\u6b21\u66dd\u5149\u4ea7\u751f\u7684GMV\uff0c\u5254\u9664\u5f00\u64ad\u65f6\u95f4\u5c0f\u4e8e25\u5206\u949f\u7684\u76f4\u64ad");
            tag.setSubTags(DouYinTopManOptionSource.toSubTag((Map)DouYinTopManOptionSource.gpmAndPriceAvg));
            priceAvgTagName = "1".equals(type) ? "\u5e26\u8d27\u5546\u54c1\u5747\u4ef7" : "\u76f4\u64ad\u5546\u54c1\u5747\u4ef7";
            String string = markupRateTagName = "1".equals(type) ? "\u7ed3\u7b97\u7387\u9ad8" : "\u76f4\u64ad\u5e26\u8d27\u7ed3\u7b97\u7387\u9ad8";
        }
        if ("1".equals(type) || "3".equals(type)) {
            tag = new TopManOptionsEntity.Tag();
            childrenList.add(tag);
            tag.setComponentType(OptionComponentType.RSelect);
            tag.setStarTagName("\u5355\u89c6\u9891\u9500\u552e\u989d");
            tag.setTips("\u8fd130\u5929\u5e26\u8d27\u89c6\u9891\u5e73\u5747GMV");
            tag.setSubTags(DouYinTopManOptionSource.toSubTag((Map)DouYinTopManOptionSource.saleAvg));
            tag = new TopManOptionsEntity.Tag();
            childrenList.add(tag);
            tag.setComponentType(OptionComponentType.RSelect);
            tag.setStarTagName("\u89c6\u9891\u64ad\u653e\u91cf");
            tag.setTips("\u8fd130\u5929\u5e26\u8d27\u89c6\u9891\u7684\u64ad\u653e\u91cf\u7684\u4e2d\u4f4d\u6570");
            tag.setSubTags(DouYinTopManOptionSource.toSubTag((Map)DouYinTopManOptionSource.playCount));
            tag = new TopManOptionsEntity.Tag();
            childrenList.add(tag);
            tag.setComponentType(OptionComponentType.RSelect);
            tag.setStarTagName("\u89c6\u9891GPM");
            tag.setTips("\u8fd130\u5929\u5e26\u8d27\u89c6\u9891\u8d2d\u7269\u8f66\u5343\u6b21\u66dd\u5149\u4ea7\u751f\u7684GMV");
            tag.setSubTags(DouYinTopManOptionSource.toSubTag((Map)DouYinTopManOptionSource.gpmAndPriceAvg));
            priceAvgTagName = "1".equals(type) ? "\u5e26\u8d27\u5546\u54c1\u5747\u4ef7" : "\u89c6\u9891\u5546\u54c1\u5747\u4ef7";
            String string = markupRateTagName = "1".equals(type) ? "\u7ed3\u7b97\u7387\u9ad8" : "\u89c6\u9891\u5e26\u8d27\u7ed3\u7b97\u7387\u9ad8";
        }
        if (!"0".equals(type)) {
            tag = new TopManOptionsEntity.Tag();
            childrenList.add(tag);
            tag.setComponentType(OptionComponentType.RSelect);
            tag.setStarTagName(priceAvgTagName);
            tag.setTips("\u8fbe\u4eba\u5e26\u8d27\u5546\u54c1\u7684\u5e73\u5747\u4ef7\u683c");
            tag.setSubTags(DouYinTopManOptionSource.toSubTag((Map)DouYinTopManOptionSource.gpmAndPriceAvg));
            tag = new TopManOptionsEntity.Tag();
            childrenList.add(tag);
            tag.setComponentType(OptionComponentType.RSelect);
            tag.setStarTagName("\u5e26\u8d27\u53e3\u7891");
            tag.setTips("\u5e26\u8d27\u53e3\u7891\u7531\u6296\u97f3\u5e73\u53f0\u57fa\u4e8e\u7528\u6237\u8bc4\u4ef7\u3001\u552e\u540e\u3001\u6295\u8bc9\u7b49\u591a\u7ef4\u5ea6\u7efc\u5408\u8ba1\u7b97\u5f97\u51fa\uff0c\u53cd\u6620\u8fbe\u4eba\u5e26\u8d27\u5546\u54c1\u9760\u8c31\u7a0b\u5ea6\uff0c5\u661f\u4e3a\u6700\u9ad8\u7b49\u7ea7\u3002\u53e3\u7891\u661f\u7ea7\u8d8a\u9ad8\uff0c\u5e26\u8d27\u5546\u54c1\u54c1\u8d28\u8d8a\u597d\uff0c\u8d2d\u7269\u4f53\u9a8c\u8d8a\u597d\u3002");
            tag.setSubTags(DouYinTopManOptionSource.toSubTag((Map)DouYinTopManOptionSource.wow));
        } else {
            markupRateTagName = "\u7ed3\u7b97\u7387\u9ad8";
        }
        tag = new TopManOptionsEntity.Tag();
        childrenList.add(tag);
        tag.setComponentType(OptionComponentType.RCheckbox);
        tag.setTips("\u7ed3\u7b97\u7387\u9ad8\u6307\u8be5\u8fbe\u4eba\u8fd130\u65e5\u7ed3\u7b97\u7387\u5904\u4e8e\u8fbe\u4eba\u9886\u5148\u6c34\u5e73");
        tag.setStarTagName(markupRateTagName);
        return vo;
    }

    private String subAvatar(String avatar, String uid) {
        if (avatar.contains("aweme-avatar/") && avatar.contains(".jpeg")) {
            return avatar.substring(avatar.lastIndexOf("aweme-avatar/") + 1, avatar.indexOf(".jpeg"));
        }
        return uid;
    }

    @Override
    public TopManDetailHeadVO getDetailHead(DouYinTopManDetailDTO param) {
        String id = param.getTopManId();
        String name = param.getTopManName();
        String region = param.getTopmanRegion();
        if (StringUtils.isBlank((CharSequence)id) || StringUtils.isBlank((CharSequence)name) || StringUtils.isBlank((CharSequence)region)) {
            throw new RuntimeException(I18nUtil.translate((String)"", (String)"\u53c2\u6570\u9519\u8bef"));
        }
        String key = "TopManDetailHead_" + name + "_" + region;
        TopManDetailHeadVO topManDetailHeadVO = null;
        if (!"1".equals(param.getClearCache())) {
            topManDetailHeadVO = (TopManDetailHeadVO)this.redisUtil.get(key);
        }
        HashMap<String, Object> paramBean = new HashMap<String, Object>(1);
        paramBean.put("uid", id);
        if (topManDetailHeadVO == null) {
            DyTopManDetailBaseInfoEntity baseInfo = this.spiderApiUtil.getForEntity(SpiderMethodType.DOU_YIN_BASE_INFO, paramBean, DyTopManDetailBaseInfoEntity.class);
            topManDetailHeadVO = this.transitionDetailHead(baseInfo, key);
        }
        return topManDetailHeadVO;
    }

    private TopManDetailHeadVO transitionDetailHead(DyTopManDetailBaseInfoEntity baseInfo, String key) {
        if (baseInfo == null) {
            return null;
        }
        TopManDetailHeadVO topManDetailHeadVO = new TopManDetailHeadVO();
        TopManDetailHeadVO.TopManBaseData topManBaseData = new TopManDetailHeadVO.TopManBaseData();
        topManBaseData.setTopManId(baseInfo.getAccountDouyin());
        topManBaseData.setTopManLevel(baseInfo.getLevel() != null ? (String)DouYinTopManOptionSource.level.get(baseInfo.getLevel()) : "");
        topManBaseData.setTopManName(baseInfo.getNickname());
        topManBaseData.setSaleType(baseInfo.getSaleType());
        topManBaseData.setTopManRegion(baseInfo.getCity());
        topManBaseData.setCreditScore(baseInfo.getCreditScore() != null ? baseInfo.getCreditScore().divide(new BigDecimal(100), 2, RoundingMode.HALF_UP) : BigDecimal.ZERO);
        topManBaseData.setFansNum(baseInfo.getFansSum());
        topManBaseData.setGoodsWom(baseInfo.getSalesScore());
        topManBaseData.setTiktokNo(baseInfo.getAccountDouyin());
        topManBaseData.setTopmanAvatar(baseInfo.getAvatar());
        topManBaseData.setPlatform("1");
        topManBaseData.setTopManSex(baseInfo.getGender() != null ? (String)DouYinTopManOptionSource.gender.get(baseInfo.getGender()) : "");
        topManBaseData.setAgency(baseInfo.getAgency());
        topManBaseData.setIntroduction(baseInfo.getIntroduction());
        topManDetailHeadVO.setTopManBaseData(topManBaseData);
        if (StringUtils.isNotBlank((CharSequence)baseInfo.getNickname())) {
            this.redisUtil.set(key, (Object)topManDetailHeadVO, 14400L);
        }
        return topManDetailHeadVO;
    }

    private TopManDetailHeadVO getBaseInfoNew(DouYinTopManDetailDTO param) {
        String id = param.getTopManId();
        String avatar = param.getAvatar();
        if (StringUtils.isBlank((CharSequence)id) || StringUtils.isBlank((CharSequence)avatar)) {
            throw new RuntimeException(I18nUtil.translate((String)"", (String)"\u53c2\u6570\u9519\u8bef"));
        }
        String subAvatar = this.subAvatar(avatar, id);
        String key = "DetailBaseInfo_" + subAvatar;
        TopManDetailHeadVO topManDetailHeadVO = null;
        if (!"1".equals(param.getClearCache())) {
            topManDetailHeadVO = (TopManDetailHeadVO)this.redisUtil.get(key);
        }
        HashMap<String, Object> paramBean = new HashMap<String, Object>(1);
        paramBean.put("uid", id);
        if (topManDetailHeadVO == null) {
            long time = System.currentTimeMillis();
            DyTopManDetailBaseInfoEntity baseInfo = this.spiderApiUtil.getForEntity(SpiderMethodType.DOU_YIN_BASE_INFO, paramBean, DyTopManDetailBaseInfoEntity.class);
            topManDetailHeadVO = this.transitionBaseInfo(baseInfo);
            long endTime = System.currentTimeMillis();
            log.info("api\u63a5\u53e3-DOU_YIN_BASE_INFO\uff1a" + (endTime - time));
            if (topManDetailHeadVO.getTopManBaseData() != null && StringUtils.isNotBlank((CharSequence)topManDetailHeadVO.getTopManBaseData().getTopManId())) {
                this.redisUtil.set(key, (Object)topManDetailHeadVO, 14400L);
            }
        }
        return topManDetailHeadVO;
    }

    private TopManDetailHeadVO transitionBaseInfo(DyTopManDetailBaseInfoEntity baseInfo) {
        TopManDetailHeadVO topManDetailHeadVO = new TopManDetailHeadVO();
        TopManDetailHeadVO.TopManBaseData topManBaseData = new TopManDetailHeadVO.TopManBaseData();
        topManBaseData.setTopManId(baseInfo.getAccountDouyin());
        topManBaseData.setTopManLevel((String)DouYinTopManOptionSource.level.get(baseInfo.getLevel()));
        topManBaseData.setTopManName(baseInfo.getNickname());
        topManBaseData.setTopManRegion(baseInfo.getCity());
        topManBaseData.setContentType(StringUtils.join(baseInfo.getWorksType(), (String)"-"));
        topManBaseData.setCreditScore(baseInfo.getCreditScore().divide(new BigDecimal(100), 2, RoundingMode.HALF_UP));
        topManBaseData.setFansNum(baseInfo.getFansSum());
        topManBaseData.setGoodsWom(baseInfo.getScore());
        topManBaseData.setTiktokNo(baseInfo.getAccountDouyin());
        topManBaseData.setTopmanAvatar(baseInfo.getAvatar());
        topManBaseData.setPlatform("1");
        topManBaseData.setTopManSex((String)DouYinTopManOptionSource.gender.get(baseInfo.getGender()));
        topManDetailHeadVO.setTopManBaseData(topManBaseData);
        return topManDetailHeadVO;
    }

    @Override
    public TopManDetailHeadVO detailHeadInfo(DouYinTopManDetailDTO param) {
        int i;
        TopManDetailHeadVO.TopManBaseData topManBaseData;
        String id = param.getTopManId();
        String avatar = param.getAvatar();
        if (StringUtils.isBlank((CharSequence)id) || StringUtils.isBlank((CharSequence)avatar)) {
            throw new RuntimeException(I18nUtil.translate((String)"", (String)"\u53c2\u6570\u9519\u8bef"));
        }
        String subAvatar = this.subAvatar(avatar, id);
        String key = "TopManDetailHeadInfo_" + subAvatar;
        TopManDetailHeadVO topManDetailHeadVO = null;
        if (!"1".equals(param.getClearCache())) {
            topManDetailHeadVO = (TopManDetailHeadVO)this.redisUtil.get(key);
        }
        HashMap<String, String> paramBean = new HashMap<String, String>(1);
        paramBean.put("uid", id);
        if (topManDetailHeadVO == null) {
            topManDetailHeadVO = new TopManDetailHeadVO();
            DyTopManDetailBaseInfoEntity baseInfo = this.spiderApiUtil.postForEntity(SpiderMethodType.DOU_YIN_BASE_TOPMAN_SCORE, paramBean, DyTopManDetailBaseInfoEntity.class);
            this.transitionTopmanScore(baseInfo, topManDetailHeadVO);
            if (StringUtils.isNotBlank((CharSequence)topManDetailHeadVO.getTopManBaseData().getTopManId())) {
                this.redisUtil.set(key, (Object)topManDetailHeadVO, 14400L);
            }
        }
        topManBaseData.setIsAdded((i = ((TopManInformationMapper)this.baseMapper).checkAddAndCollect((topManBaseData = topManDetailHeadVO.getTopManBaseData()).getPlatform(), topManBaseData.getTopManId(), SysUtil.getLoginUser())) == 2 || i == 3 ? "1" : "0");
        topManBaseData.setIsCollection(i == 1 || i == 3 ? "1" : "0");
        return topManDetailHeadVO;
    }

    private void transitionTopmanScore(DyTopManDetailBaseInfoEntity baseInfo, TopManDetailHeadVO topManDetailHeadVO) {
        TopManDetailHeadVO.TopManBaseData topManBaseData = new TopManDetailHeadVO.TopManBaseData();
        if (baseInfo == null) {
            topManDetailHeadVO.setTopManBaseData(topManBaseData);
        }
        topManBaseData.setTopManId(baseInfo.getAccountDouyin());
        topManBaseData.setTopManLevel(baseInfo.getLevel() != null ? (String)DouYinTopManOptionSource.level.get(baseInfo.getLevel()) : "");
        topManBaseData.setTopManName(baseInfo.getNickname());
        topManBaseData.setSaleType(baseInfo.getSaleType());
        topManBaseData.setTopManRegion(baseInfo.getCity());
        topManBaseData.setCreditScore(baseInfo.getCreditScore() != null ? baseInfo.getCreditScore().divide(new BigDecimal(100), 2, RoundingMode.HALF_UP) : BigDecimal.ZERO);
        topManBaseData.setFansNum(baseInfo.getFansSum());
        topManBaseData.setGoodsWom(baseInfo.getSalesScore());
        topManBaseData.setTiktokNo(baseInfo.getAccountDouyin());
        topManBaseData.setTopmanAvatar(baseInfo.getAvatar());
        topManBaseData.setPlatform("1");
        topManBaseData.setTopManSex(baseInfo.getGender() != null ? (String)DouYinTopManOptionSource.gender.get(baseInfo.getGender()) : "");
        topManBaseData.setAgency(baseInfo.getAgency());
        topManDetailHeadVO.setTopManBaseData(topManBaseData);
    }

    @Override
    public TopManDetailDouYinMcnVO getDouYinIdNew(DouYinTopManDetailDTO param) {
        TopManDetailDouYinMcnVO vo = new TopManDetailDouYinMcnVO();
        long time = System.currentTimeMillis();
        if (StringUtils.isBlank((CharSequence)vo.getUniqueId())) {
            try {
                TopManDetailHeadVO.TopManBaseData topManBaseData;
                TopManDetailHeadVO headVO = this.getBaseInfoNew(param);
                if (headVO != null && (topManBaseData = headVO.getTopManBaseData()) != null && StringUtils.isNotBlank((CharSequence)topManBaseData.getTopManId())) {
                    vo.setUniqueId(topManBaseData.getTopManId());
                    long endTime = System.currentTimeMillis();
                    log.info("\u8be6\u60c5\u63a5\u53e3-\u83b7\u53d6\u8fbe\u4ebaID\uff1a" + (endTime - time));
                    return vo;
                }
            }
            catch (Exception headVO) {
                // empty catch block
            }
        }
        if (StringUtils.isBlank((CharSequence)vo.getUniqueId())) {
            try {
                TopManDetailDouYinIdVO.DyUserInfo userInfo;
                TopManDetailDouYinIdVO dyVO = this.getDouYinId(param);
                if (StringUtils.isBlank((CharSequence)vo.getUniqueId()) && dyVO != null && (userInfo = dyVO.getUserInfo()) != null && StringUtils.isNotBlank((CharSequence)userInfo.getUniqueId())) {
                    vo.setUniqueId(userInfo.getUniqueId());
                    long endTime = System.currentTimeMillis();
                    log.info("\u6296\u97f3\u5b98\u7f51\u63a5\u53e3-\u83b7\u53d6\u8fbe\u4ebaID\uff1a" + (endTime - time));
                    return vo;
                }
            }
            catch (Exception dyVO) {
                // empty catch block
            }
        }
        if (StringUtils.isBlank((CharSequence)vo.getUniqueId())) {
            vo = this.getDouYinIdMcn(param);
            long endTime = System.currentTimeMillis();
            log.info("\u8749\u5988\u5988\u63a5\u53e3-\u83b7\u53d6\u8fbe\u4ebaID\uff1a" + (endTime - time));
            return vo;
        }
        log.error("\u83b7\u53d6\u6296\u97f3\u53f7\u63a5\u53e3\u5931\u8d25\uff1a" + param);
        return vo;
    }

    @Override
    public TopManDetailDouYinIdVO getDouYinId(DouYinTopManDetailDTO param) {
        String avatar = param.getAvatar();
        String name = param.getTopManName();
        if (StringUtils.isBlank((CharSequence)avatar) || StringUtils.isBlank((CharSequence)name)) {
            throw new RuntimeException(I18nUtil.translate((String)"", (String)"\u53c2\u6570\u9519\u8bef"));
        }
        String subAvatar = this.subAvatar(avatar, null);
        String key = "DetailDouYinId_" + subAvatar;
        TopManDetailDouYinIdVO douYinIdVO = null;
        if (!"1".equals(param.getClearCache())) {
            douYinIdVO = (TopManDetailDouYinIdVO)this.redisUtil.get(key);
        }
        HashMap<String, Object> paramBean = new HashMap<String, Object>(1);
        paramBean.put("topman_name", name);
        if (douYinIdVO == null) {
            long time = System.currentTimeMillis();
            TopManDetailDouYinIdEntity entity = this.spiderApiUtil.getForEntity(SpiderMethodType.DOU_YIN_ID, paramBean, TopManDetailDouYinIdEntity.class);
            long endTime = System.currentTimeMillis();
            log.info("api\u63a5\u53e3-DOU_YIN_ID\uff1a" + (endTime - time));
            douYinIdVO = this.transitionDouYinId(entity, avatar, key);
        }
        return douYinIdVO;
    }

    private TopManDetailDouYinIdVO transitionDouYinId(TopManDetailDouYinIdEntity entity, String avatar, String key) {
        TopManDetailDouYinIdVO douYinIdVO = new TopManDetailDouYinIdVO();
        if (entity == null) {
            return douYinIdVO;
        }
        String str = avatar.substring(avatar.lastIndexOf("/"), avatar.indexOf("?"));
        for (TopManDetailDouYinIdEntity.Result result : entity.getResult()) {
            if (douYinIdVO.getUserInfo() != null) break;
            TopManDetailDouYinIdEntity.DyUserInfo user = result.getUserInfo();
            TopManDetailDouYinIdEntity.DyUserInfo.AvatarThumb avatarThumb = user.getAvatarThumb();
            String url = avatarThumb.getUrlList().get(0);
            String str2 = url.substring(url.lastIndexOf("/"));
            if (!str2.contains(str)) continue;
            TopManDetailDouYinIdVO.DyUserInfo userInfo = new TopManDetailDouYinIdVO.DyUserInfo();
            userInfo.setUniqueId(user.getUniqueId());
            douYinIdVO.setUserInfo(userInfo);
            douYinIdVO.setIsRedUniqueid(result.getIsRedUniqueid());
            log.info("\u83b7\u53d6\u8fbe\u4ebaID\u6210\u529f:[{}]", (Object)douYinIdVO);
        }
        if (douYinIdVO.getUserInfo() != null) {
            this.redisUtil.set(key, (Object)douYinIdVO, 14400L);
        }
        return douYinIdVO;
    }

    @Override
    public TopManDetailDouYinMcnVO getDouYinIdMcn(DouYinTopManDetailDTO param) {
        String avatar = param.getAvatar();
        String name = param.getTopManName();
        if (StringUtils.isBlank((CharSequence)avatar) || StringUtils.isBlank((CharSequence)name)) {
            throw new RuntimeException(I18nUtil.translate((String)"", (String)"\u53c2\u6570\u9519\u8bef"));
        }
        String subAvatar = this.subAvatar(avatar, null);
        String key = "DetailDouYinMcn_" + subAvatar;
        TopManDetailDouYinMcnVO vo = null;
        if (!"1".equals(param.getClearCache())) {
            vo = (TopManDetailDouYinMcnVO)this.redisUtil.get(key);
        }
        HashMap<String, Object> paramBean = new HashMap<String, Object>(1);
        paramBean.put("topman_name", name);
        if (vo == null) {
            long time = System.currentTimeMillis();
            TopManDetailDouYinMcnEntity entity = this.spiderApiUtil.getForEntity(SpiderMethodType.DOU_YIN_CMM, paramBean, TopManDetailDouYinMcnEntity.class);
            long endTime = System.currentTimeMillis();
            log.info("api\u63a5\u53e3-DOU_YIN_CMM\uff1a" + (endTime - time));
            vo = this.transitionDouYinMcn(entity, avatar, key);
        }
        return vo;
    }

    private TopManDetailDouYinMcnVO transitionDouYinMcn(TopManDetailDouYinMcnEntity entity, String avatar, String key) {
        TopManDetailDouYinMcnVO vo = new TopManDetailDouYinMcnVO();
        if (entity == null || entity.getResult() == null || CollectionUtil.isEmpty(entity.getResult().getList())) {
            return vo;
        }
        List<TopManDetailDouYinMcnEntity.Result.UserInfo> list = entity.getResult().getList();
        String str = avatar.substring(avatar.lastIndexOf("/") + 1, avatar.indexOf("?"));
        for (TopManDetailDouYinMcnEntity.Result.UserInfo result : list) {
            if (StringUtils.isNotBlank((CharSequence)vo.getUniqueId())) break;
            String url = result.getAvatar();
            String str2 = url.substring(url.lastIndexOf("%2F") + 1);
            if (!str2.contains(str)) continue;
            BeanUtils.copyProperties((Object)result, (Object)vo);
            log.info("\u83b7\u53d6\u8fbe\u4ebaID\u6210\u529f:[{}]", (Object)vo);
        }
        if (StringUtils.isNotBlank((CharSequence)vo.getUniqueId())) {
            this.redisUtil.set(key, (Object)vo, 14400L);
        }
        return vo;
    }

    @Override
    public TopManDetailHeadVO queryDetailHeadCore(DouYinTopManDetailDTO param) {
        String id = param.getTopManId();
        String avatar = param.getAvatar();
        if (StringUtils.isBlank((CharSequence)id) || StringUtils.isBlank((CharSequence)avatar)) {
            throw new ELSBootException("\u53c2\u6570\u9519\u8bef");
        }
        String subAvatar = this.subAvatar(avatar, id);
        String key = "TopManDetailHeadCore_" + subAvatar;
        TopManDetailHeadVO topManDetailHeadVO = null;
        if (!"1".equals(param.getClearCache())) {
            topManDetailHeadVO = (TopManDetailHeadVO)this.redisUtil.get(key);
        }
        HashMap<String, Object> paramBean = new HashMap<String, Object>(2);
        paramBean.put("uid", param.getTopManId());
        paramBean.put("days", StatisticsDateType.M1.getDicCode());
        if (topManDetailHeadVO == null) {
            topManDetailHeadVO = new TopManDetailHeadVO();
            DyTopManDetailBaseEntity data = this.spiderApiUtil.getForEntity(SpiderMethodType.DOU_YIN_BASE, paramBean, DyTopManDetailBaseEntity.class);
            if (data != null) {
                this.transitionDetailHeadCore(param, data, topManDetailHeadVO);
                this.redisUtil.set(key, (Object)topManDetailHeadVO, 14400L);
            }
        }
        return topManDetailHeadVO;
    }

    private void transitionDetailHeadCore(DouYinTopManDetailDTO param, DyTopManDetailBaseEntity data, TopManDetailHeadVO topManDetailHeadVO) {
        DyTopManDetailBaseEntity.VideoData videoData;
        DyTopManDetailBaseEntity.LiveData liveData;
        DyTopManDetailBaseEntity.CoreData coreData = data.getCoreData();
        if (coreData != null) {
            TopManDetailHeadVO.TopManCoreData topManCoreData = new TopManDetailHeadVO.TopManCoreData();
            topManDetailHeadVO.setTopManCoreData(topManCoreData);
            topManCoreData.setCommerceDays(coreData.getTotalWorkDay());
            topManCoreData.setPopularizeGoodsQuantity(coreData.getPromotionSum());
            topManCoreData.setCooperationShop(coreData.getCooperateShopNum());
            topManCoreData.setGoodsTotalSalesLow(coreData.getSaleLow());
            topManCoreData.setGoodsTotalSalesHigh(coreData.getSaleHigh());
        }
        if ((liveData = data.getLiveData()) != null) {
            TopManDetailHeadVO.TopManLiveData topManLiveData = new TopManDetailHeadVO.TopManLiveData();
            topManDetailHeadVO.setTopManLiveData(topManLiveData);
            topManLiveData.setLiveProportionOfSales(liveData.getPercentage().divide(this.divide, 2, RoundingMode.HALF_UP));
            topManLiveData.setLiveGpmHigh(liveData.getGpmHigh());
            topManLiveData.setLiveGpmLow(liveData.getGpmLow());
            topManLiveData.setGoodsLiveQuantity(liveData.getCount());
            topManLiveData.setLiveSalesAvgHigh(liveData.getSaleHigh());
            topManLiveData.setLiveSalesAvgLow(liveData.getSaleLow());
            topManLiveData.setGoodsLiveViewers(liveData.getWatchingNum());
            topManLiveData.setLiveRate(liveData.getRecommendRate());
        }
        if ((videoData = data.getVideoData()) != null) {
            TopManDetailHeadVO.TopManVideoData topManVideoData = new TopManDetailHeadVO.TopManVideoData();
            topManDetailHeadVO.setTopManVideoData(topManVideoData);
            topManVideoData.setGoodsVideoQuantity(videoData.getCount());
            topManVideoData.setVideoGpmHigh(videoData.getGpmHigh());
            topManVideoData.setVideoGpmLow(videoData.getGpmLow());
            topManVideoData.setVideoProportionOfSales(videoData.getPercentage().divide(this.divide, 2, RoundingMode.HALF_UP));
            topManVideoData.setVideoSalesAvgHigh(videoData.getSaleHigh());
            topManVideoData.setVideoSalesAvgLow(videoData.getSaleLow());
            topManVideoData.setGoodsPlayQuantity(videoData.getWatchingNum());
            topManVideoData.setVideoRate(videoData.getRecommendRate());
        }
        this.cacheTopManResultDetailBodyBaseNew(param, StatisticsDateType.M1, data);
    }

    private Map<String, TopManResultDetailBodyBase> cacheTopManResultDetailBodyBaseNew(DouYinTopManDetailDTO param, StatisticsDateType dateType, DyTopManDetailBaseEntity data) {
        DyTopManDetailBaseEntity.SaleAnalysis saleAnalysis;
        if (data != null && (saleAnalysis = data.getSaleAnalysis()) != null) {
            HashMap<String, TopManResultDetailBodyBase> cacheBean = new HashMap<String, TopManResultDetailBodyBase>();
            TopManResultDetailBodyBase videoDetailBodyBase = new TopManResultDetailBodyBase();
            DyTopManDetailBaseEntity.SaleAnalysisMember video = saleAnalysis.getVideo();
            this.transferSaleAnalysis(video, videoDetailBodyBase);
            cacheBean.put("2", videoDetailBodyBase);
            TopManResultDetailBodyBase liveDetailBodyBase = new TopManResultDetailBodyBase();
            DyTopManDetailBaseEntity.SaleAnalysisMember live = saleAnalysis.getLive();
            liveDetailBodyBase.setFanAnalysisData(data.getFanAnalysis());
            this.transferSaleAnalysis(live, liveDetailBodyBase);
            cacheBean.put("1", liveDetailBodyBase);
            this.redisUtil.set("TopManBodyBaseAnalysis_" + param.getTopManName() + "_" + param.getTopmanRegion() + "_" + dateType.getDicCode(), cacheBean, 14400L);
            return cacheBean;
        }
        return null;
    }

    private void transferSaleAnalysis(DyTopManDetailBaseEntity.SaleAnalysisMember source, TopManResultDetailBodyBase target) {
        List<DyTopManDetailBaseEntity.SaleAnalysisMember.Category> category;
        if (source == null || target == null) {
            return;
        }
        List<DyTopManDetailBaseEntity.SaleAnalysisMember.Brand> brand = source.getBrand();
        if (brand != null && brand.size() > 0) {
            ArrayList<TopManResultDetailBodyBase.popularizeAnalysisEntity> brandList = new ArrayList<TopManResultDetailBodyBase.popularizeAnalysisEntity>(Math.min(3, brand.size()));
            target.setBrandAnalysisData(brandList);
            for (int i = 0; i < Math.min(3, brand.size()); ++i) {
                DyTopManDetailBaseEntity.SaleAnalysisMember.Brand a = brand.get(i);
                TopManResultDetailBodyBase.popularizeAnalysisEntity brandEntity = new TopManResultDetailBodyBase.popularizeAnalysisEntity();
                brandList.add(brandEntity);
                brandEntity.setBrand(a.getBrand());
                brandEntity.setPriceAvg(a.getAveragePrice().divide(this.divide, 2, RoundingMode.HALF_UP));
                brandEntity.setSaleAmountLow(a.getAverageGMVLow());
                brandEntity.setSaleAmountHigh(a.getAverageGMVHigh());
            }
        }
        if ((category = source.getCategory()) != null && category.size() > 0) {
            ArrayList<TopManResultDetailBodyBase.popularizeAnalysisEntity> categoryList = new ArrayList<TopManResultDetailBodyBase.popularizeAnalysisEntity>(Math.min(3, category.size()));
            target.setCategoryAnalysisData(categoryList);
            for (int i = 0; i < Math.min(3, category.size()); ++i) {
                DyTopManDetailBaseEntity.SaleAnalysisMember.Category a = category.get(i);
                TopManResultDetailBodyBase.popularizeAnalysisEntity categoryEntity = new TopManResultDetailBodyBase.popularizeAnalysisEntity();
                categoryList.add(categoryEntity);
                categoryEntity.setCategory(a.getCategory());
                categoryEntity.setPriceAvg(a.getAveragePrice().divide(this.divide, 2, RoundingMode.HALF_UP));
                categoryEntity.setSaleAmountLow(a.getAverageGMVLow());
                categoryEntity.setSaleAmountHigh(a.getAverageGMVHigh());
                categoryEntity.setCommissionRateLow(a.getSuggestRatioMin());
                categoryEntity.setCommissionRateHigh(a.getSuggestRatioMax());
            }
        }
    }

    @Override
    public IPage<TopManGoodsListEntity> queryGoodsListNew(SimplePostRequestParam<DouYinTopManDetailDTO> param) {
        Integer pageNo = param.getPageNo();
        Integer pageSize = param.getPageSize();
        DouYinTopManDetailDTO filterInfo = (DouYinTopManDetailDTO)param.getFilterInfo();
        List<String> brand = filterInfo.getBrand();
        final String brandParam = brand != null && brand.size() > 0 ? brand.get(0) : "";
        List<String> category = filterInfo.getCategory();
        final String statisticsDateType = filterInfo.getStatisticsDateType();
        final String topManId = filterInfo.getTopManId();
        final String categoryParam = category != null && category.size() > 0 ? category.get(0) : "";
        int tP = pageNo * pageSize;
        final int ddPage = (int)Math.ceil((double)tP / 15.0);
        int mcnPage = tP % 15;
        mcnPage = mcnPage == 0 ? 15 : mcnPage;
        Page result = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        HashMap<String, Object> paramBean = new HashMap<String, Object>(5){
            {
                super(x0);
                this.put("uid", topManId);
                this.put("days", statisticsDateType);
                this.put("cate_id", categoryParam);
                this.put("brand_id", brandParam);
                this.put("page", ddPage);
            }
        };
        DyTopManSpiderGoodsListEntity goodsListEntity = this.spiderApiUtil.getForEntity(SpiderMethodType.DOU_YIN_SALE_GOODS_PRODUCT, (Map<String, Object>)paramBean, DyTopManSpiderGoodsListEntity.class);
        if (goodsListEntity != null) {
            result.setTotal(goodsListEntity.getTotal());
            List<DyTopManSpiderGoodsListEntity.Goods> productInfo = goodsListEntity.getProductInfo();
            if (productInfo != null && productInfo.size() > mcnPage - 5) {
                ArrayList<TopManGoodsListEntity> resultEntity = new ArrayList<TopManGoodsListEntity>(5);
                result.setRecords(resultEntity);
                for (DyTopManSpiderGoodsListEntity.Goods a : productInfo.subList(mcnPage - 5, Math.min(mcnPage, productInfo.size()))) {
                    TopManGoodsListEntity topManGoodsListEntity = new TopManGoodsListEntity();
                    resultEntity.add(topManGoodsListEntity);
                    topManGoodsListEntity.setGoodsId(a.getGoodsInfo().getPid());
                    topManGoodsListEntity.setGoodsPicture(a.getGoodsInfo().getImg());
                    topManGoodsListEntity.setGoodsPrice(a.getGoodsInfo().getCurPrice());
                    topManGoodsListEntity.setGoodsTitle(a.getGoodsInfo().getTitle());
                    topManGoodsListEntity.setGoodsSaleAmountHigh(a.getGoodsSaleHigh());
                    topManGoodsListEntity.setGoodsSaleAmountLow(a.getGoodsSaleLow());
                    topManGoodsListEntity.setLiveQuantity(a.getRelatedLiveTimes());
                    topManGoodsListEntity.setVideoQuantity(a.getRelatedVideoNum());
                }
            }
        }
        return result;
    }

    @Override
    public IPage<TopManShopListEntity> queryShopListNew(SimplePostRequestParam<DouYinTopManDetailDTO> param) {
        DouYinTopManDetailDTO filterInfo = (DouYinTopManDetailDTO)param.getFilterInfo();
        List<String> category = filterInfo.getCategory();
        final String categoryParam = category != null && category.size() > 0 ? category.get(0) : "";
        Integer pageNo = param.getPageNo();
        Integer pageSize = param.getPageSize();
        final String statisticsDateType = filterInfo.getStatisticsDateType();
        final String topManId = filterInfo.getTopManId();
        int tP = pageNo * pageSize;
        final int ddPage = (int)Math.ceil((double)tP / 15.0);
        int mcnPage = tP % 15;
        mcnPage = mcnPage == 0 ? 15 : mcnPage;
        Page result = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        HashMap<String, Object> paramBean = new HashMap<String, Object>(4){
            {
                super(x0);
                this.put("uid", topManId);
                this.put("days", statisticsDateType);
                this.put("cate_id", categoryParam);
                this.put("page", ddPage);
            }
        };
        DyTopManSpiderShopListEntity shopListEntity = this.spiderApiUtil.getForEntity(SpiderMethodType.DOU_YIN_SALE_GOODS_SHOP, (Map<String, Object>)paramBean, DyTopManSpiderShopListEntity.class);
        if (shopListEntity != null) {
            result.setTotal(shopListEntity.getTotal());
            List<DyTopManSpiderShopListEntity.Shop> shopInfo = shopListEntity.getShopInfo();
            if (shopInfo != null && shopInfo.size() > mcnPage - 5) {
                ArrayList<TopManShopListEntity> record = new ArrayList<TopManShopListEntity>(5);
                result.setRecords(record);
                for (DyTopManSpiderShopListEntity.Shop a : shopInfo.subList(mcnPage - 5, Math.min(mcnPage, shopInfo.size()))) {
                    TopManShopListEntity shop = new TopManShopListEntity();
                    record.add(shop);
                    shop.setLiveQuantity(a.getRelatedTimes());
                    shop.setShopId(a.getBasicInfo().getShopId());
                    shop.setPopularizeGoodsQuantity(a.getBasicInfo().getSalesCnt());
                    shop.setShopLogo(a.getBasicInfo().getShopAvatar());
                    shop.setVideoQuantity(a.getRelatedVideoNum());
                    shop.setGmvHigh(a.getPromotionGmvHigh());
                    shop.setGmvLow(a.getPromotionGmvLow());
                    shop.setShopTitle(a.getBasicInfo().getName());
                }
            }
        }
        return result;
    }

    @Override
    public TopManResultDetailBody queryDetailBody(DouYinTopManDetailDTO param) {
        return BodyType.getTypeWhitName(param.getBodyType()).function.queryDetailBody(param);
    }

    private TopManResultDetailBody queryDetailBodyBaseNew(DouYinTopManDetailDTO param) {
        String popularizeType = param.getPopularizeType();
        final String id = param.getTopManId();
        String name = param.getTopManName();
        String region = param.getTopmanRegion();
        final String dateType = param.getStatisticsDateType();
        StatisticsDateType typeWhitDicCode = StatisticsDateType.getTypeWhitDicCode((String)dateType, null);
        if (typeWhitDicCode == null) {
            throw new RuntimeException(I18nUtil.translate((String)"", (String)"\u65f6\u95f4\u683c\u5f0f\u9519\u8bef"));
        }
        String key = "TopManBodyBaseAnalysis_" + name + "_" + region + "_" + dateType;
        Map<String, TopManResultDetailBodyBase> cBean = null;
        if (!"1".equals(param.getClearCache())) {
            cBean = (Map<String, TopManResultDetailBodyBase>)this.redisUtil.get(key);
        }
        HashMap<String, Object> paramBean = new HashMap<String, Object>(2){
            {
                super(x0);
                this.put("uid", id);
                this.put("days", dateType);
            }
        };
        if (cBean == null) {
            DyTopManDetailBaseEntity topManDetail = this.spiderApiUtil.getForEntity(SpiderMethodType.DOU_YIN_BASE, (Map<String, Object>)paramBean, DyTopManDetailBaseEntity.class);
            cBean = this.cacheTopManResultDetailBodyBaseNew(param, typeWhitDicCode, topManDetail);
        }
        TopManResultDetailBodyBase topManResultDetailBodyBase = (TopManResultDetailBodyBase)cBean.get(popularizeType);
        return cBean != null ? (TopManResultDetailBody)((Object)cBean.get(popularizeType)) : new TopManResultDetailBodyBase();
    }

    private TopManResultDetailBody queryDetailBodySaleGoodsNew(DouYinTopManDetailDTO param) {
        String topManName = param.getTopManName();
        final String topManId = param.getTopManId();
        final String dateType = param.getStatisticsDateType();
        StatisticsDateType typeWhitDicCode = StatisticsDateType.getTypeWhitDicCode((String)dateType, null);
        if (typeWhitDicCode == null) {
            throw new RuntimeException(I18nUtil.translate((String)"", (String)"\u65f6\u95f4\u683c\u5f0f\u9519\u8bef"));
        }
        String key = "TopManBodySaleGoods_" + topManName + "_" + dateType;
        TopManResultDetailBodySaleGoods saleGoods = null;
        if (!"1".equals(param.getClearCache())) {
            saleGoods = (TopManResultDetailBodySaleGoods)((Object)this.redisUtil.get(key));
        }
        HashMap<String, Object> paramBean = new HashMap<String, Object>(2){
            {
                super(x0);
                this.put("uid", topManId);
                this.put("days", dateType);
            }
        };
        if (saleGoods == null) {
            saleGoods = new TopManResultDetailBodySaleGoods();
            DyTopManDetailSaleGoodsEntity topManSaleGoodsDetail = this.spiderApiUtil.getForEntity(SpiderMethodType.DOU_YIN_SALE_GOODS, (Map<String, Object>)paramBean, DyTopManDetailSaleGoodsEntity.class);
            this.transferSaleGoods(topManSaleGoodsDetail, saleGoods);
            DyTopManSaleGoodsTagEntity topManSaleGoodsTag = this.spiderApiUtil.getForEntity(SpiderMethodType.DOU_YIN_SALE_GOODS_TAG, (Map<String, Object>)paramBean, DyTopManSaleGoodsTagEntity.class);
            this.transferSaleGoodsTag(topManSaleGoodsTag, saleGoods);
            this.redisUtil.set(key, (Object)saleGoods, 14400L);
        }
        return saleGoods;
    }

    private void transferSaleGoods(DyTopManDetailSaleGoodsEntity source, TopManResultDetailBodySaleGoods target) {
        if (source != null && target != null) {
            DyTopManDetailSaleGoodsEntity.VideoData videoData;
            DyTopManDetailSaleGoodsEntity.LiveData liveData;
            target.setStatisticsDate(source.getStartTime() + "\u81f3" + source.getEndTime());
            DyTopManDetailSaleGoodsEntity.CoreData coreData = source.getCoreData();
            if (coreData != null) {
                TopManResultDetailBodySaleGoods.SaleGoodsCoreData saleGoodsCoreData = new TopManResultDetailBodySaleGoods.SaleGoodsCoreData();
                target.setSaleGoodsCoreData(saleGoodsCoreData);
                saleGoodsCoreData.setPopularizeGoodsQuantity(coreData.getPromotionSum());
                saleGoodsCoreData.setPriceAvg(coreData.getAveragePrice().divide(this.divide, 2, RoundingMode.HALF_UP));
                saleGoodsCoreData.setCooperationShopQuantity(coreData.getCooperateShopNum());
                saleGoodsCoreData.setSaleTotalAmountHigh(coreData.getSaleHigh());
                saleGoodsCoreData.setSaleTotalAmountLow(coreData.getSaleLow());
            }
            if ((liveData = source.getLiveData()) != null) {
                TopManResultDetailBodySaleGoods.SaleGoodsLiveData saleGoodsLiveData = new TopManResultDetailBodySaleGoods.SaleGoodsLiveData();
                target.setSaleGoodsLiveData(saleGoodsLiveData);
                saleGoodsLiveData.setLiveGpmHigh(liveData.getGpmHigh());
                saleGoodsLiveData.setLiveGpmLow(liveData.getGpmLow());
                saleGoodsLiveData.setLiveCooperationShop(liveData.getCooperateShopNum());
                saleGoodsLiveData.setLivePopularizeGoods(liveData.getPromotionSum());
                saleGoodsLiveData.setLivePriceAvg(liveData.getAveragePrice().divide(this.divide, 2, RoundingMode.HALF_UP));
                saleGoodsLiveData.setLiveSaleAvgHigh(liveData.getSaleHigh());
                saleGoodsLiveData.setLiveSaleAvgLow(liveData.getSaleLow());
                saleGoodsLiveData.setLiveSaleRate(liveData.getPercentage().divide(this.divide, 2, RoundingMode.HALF_UP));
                saleGoodsLiveData.setRecommendRate(liveData.getRecommendRate());
            }
            if ((videoData = source.getVideoData()) != null) {
                TopManResultDetailBodySaleGoods.SaleGoodsVideoData saleGoodsVideoData = new TopManResultDetailBodySaleGoods.SaleGoodsVideoData();
                target.setSaleGoodsVideoData(saleGoodsVideoData);
                saleGoodsVideoData.setVideoGpmHigh(videoData.getGpmHigh());
                saleGoodsVideoData.setVideoGpmLow(videoData.getGpmLow());
                saleGoodsVideoData.setVideoCooperationShop(videoData.getCooperateShopNum());
                saleGoodsVideoData.setVideoPopularizeGoods(videoData.getPromotionSum());
                saleGoodsVideoData.setVideoPriceAvg(videoData.getAveragePrice().divide(this.divide, 2, RoundingMode.HALF_UP));
                saleGoodsVideoData.setVideoSaleAvgHigh(videoData.getSaleHigh());
                saleGoodsVideoData.setVideoSaleAvgLow(videoData.getSaleLow());
                saleGoodsVideoData.setVideoSaleRate(videoData.getPercentage().divide(this.divide, 2, RoundingMode.HALF_UP));
                saleGoodsVideoData.setRecommendRate(videoData.getRecommendRate());
            }
        }
    }

    private void transferSaleGoodsTag(DyTopManSaleGoodsTagEntity source, TopManResultDetailBodySaleGoods target) {
        DyTopManSaleGoodsTagEntity.TagType cooperateShopTag;
        if (source == null || target == null) {
            return;
        }
        DyTopManSaleGoodsTagEntity.TagType sellProductTag = source.getSellProductTag();
        if (sellProductTag != null) {
            ArrayList<TopManResultDetailBodySaleGoods.DataCountItemEntity> sellProductList = new ArrayList<TopManResultDetailBodySaleGoods.DataCountItemEntity>(2);
            target.setSaleGoodsCount(sellProductList);
            this.transferTagDic(sellProductTag, sellProductList);
        }
        if ((cooperateShopTag = source.getCooperateShopTag()) != null) {
            ArrayList<TopManResultDetailBodySaleGoods.DataCountItemEntity> cooperateShopList = new ArrayList<TopManResultDetailBodySaleGoods.DataCountItemEntity>(1);
            target.setCooperationShopCount(cooperateShopList);
            this.transferTagDic(cooperateShopTag, cooperateShopList);
        }
    }

    private void transferTagDic(DyTopManSaleGoodsTagEntity.TagType tagType, ArrayList<TopManResultDetailBodySaleGoods.DataCountItemEntity> list) {
        List<DyTopManSaleGoodsTagEntity.Brand> brand;
        List<DyTopManSaleGoodsTagEntity.Category> indusCat = tagType.getIndusCat();
        if (indusCat != null && indusCat.size() > 0) {
            TopManResultDetailBodySaleGoods.DataCountItemEntity cateItem = new TopManResultDetailBodySaleGoods.DataCountItemEntity("category", "\u4e3b\u63a8\u7c7b\u76ee");
            list.add(cateItem);
            ArrayList<TopManResultDetailBodySaleGoods.DataCountDic> itemDic = new ArrayList<TopManResultDetailBodySaleGoods.DataCountDic>(indusCat.size());
            cateItem.setChildren(itemDic);
            for (DyTopManSaleGoodsTagEntity.Category a : indusCat) {
                TopManResultDetailBodySaleGoods.DataCountDic dataCountDic = new TopManResultDetailBodySaleGoods.DataCountDic();
                itemDic.add(dataCountDic);
                dataCountDic.setKey(String.valueOf(a.getCateId()));
                dataCountDic.setTitle(a.getCateName() + "(" + a.getVol() + ")");
            }
        }
        if ((brand = tagType.getBrand()) != null && brand.size() > 0) {
            TopManResultDetailBodySaleGoods.DataCountItemEntity brandItems = new TopManResultDetailBodySaleGoods.DataCountItemEntity("brand", "\u5408\u4f5c\u54c1\u724c");
            list.add(brandItems);
            ArrayList<TopManResultDetailBodySaleGoods.DataCountDic> brandItemDic = new ArrayList<TopManResultDetailBodySaleGoods.DataCountDic>(brand.size());
            brandItems.setChildren(brandItemDic);
            for (DyTopManSaleGoodsTagEntity.Brand a : brand) {
                TopManResultDetailBodySaleGoods.DataCountDic dataCountDic = new TopManResultDetailBodySaleGoods.DataCountDic();
                brandItemDic.add(dataCountDic);
                dataCountDic.setKey(String.valueOf(a.getBrandId()));
                dataCountDic.setTitle(a.getBrandName() + "(" + a.getVol() + ")");
            }
        }
    }

    private TopManResultDetailBody queryDetailBodyLive(DouYinTopManDetailDTO param) {
        return new TopManResultDetailBodyLive(){};
    }

    private TopManResultDetailBody queryDetailBodyVideo(DouYinTopManDetailDTO param) {
        return new TopManResultDetailBodyVideo(){};
    }

    private TopManResultDetailBody queryDetailBodyFans(DouYinTopManDetailDTO param) {
        return new TopManResultDetailBodyFans(){};
    }

    private TopManResultDetailBody queryDetailContacr(DouYinTopManDetailDTO param) {
        String id = param.getTopManId();
        String name = param.getTopManName();
        String region = param.getTopmanRegion();
        if (StringUtils.isBlank((CharSequence)name) || StringUtils.isBlank((CharSequence)region)) {
            throw new RuntimeException(I18nUtil.translate((String)"", (String)"\u53c2\u6570\u9519\u8bef"));
        }
        String key = "TopManBodyContacr_" + name + "_" + region + "_" + param.getContactType() + "_" + param.getCheckType();
        TopManResultDetailBodyContacr cBean = null;
        if (!"1".equals(param.getClearCache())) {
            cBean = (TopManResultDetailBodyContacr)((Object)this.redisUtil.get(key));
        }
        HashMap<String, String> paramBean = new HashMap<String, String>(3);
        paramBean.put("uid", id);
        paramBean.put("contact_mode", param.getContactType());
        paramBean.put("check_mode", param.getCheckType());
        if (cBean == null) {
            DyTopManDetailBaseContacrEntity bodyContacr = this.spiderApiUtil.postForEntity(SpiderMethodType.DOU_YIN_BASE_CONTACR, paramBean, DyTopManDetailBaseContacrEntity.class);
            cBean = this.cacheDetailContacr(key, bodyContacr);
        }
        return cBean != null ? cBean : new TopManResultDetailBody();
    }

    private TopManResultDetailBodyContacr cacheDetailContacr(String key, DyTopManDetailBaseContacrEntity data) {
        if (data != null) {
            TopManResultDetailBodyContacr cacheBean = new TopManResultDetailBodyContacr();
            BeanUtils.copyProperties((Object)data, (Object)((Object)cacheBean));
            this.redisUtil.set(key, (Object)cacheBean, 14400L);
            return cacheBean;
        }
        return null;
    }

    @PostConstruct
    private void registerMapper() {
        BodyType.base.function = this::queryDetailBodyBaseNew;
        BodyType.saleGoods.function = this::queryDetailBodySaleGoodsNew;
        BodyType.live.function = this::queryDetailBodyLive;
        BodyType.video.function = this::queryDetailBodyVideo;
        BodyType.fans.function = this::queryDetailBodyFans;
        BodyType.contacr.function = this::queryDetailContacr;
    }

    static {
        Field[] declaredFields;
        log = LoggerFactory.getLogger(TopManInformationServiceImpl.class);
        orderTag = new HashMap<String, Integer>(10);
        Class<DyTopManVO> entityClass = DyTopManVO.class;
        for (Field declaredField : declaredFields = entityClass.getDeclaredFields()) {
            OrderTagId annotation = declaredField.getAnnotation(OrderTagId.class);
            if (annotation == null) continue;
            orderTag.put(declaredField.getName(), annotation.value());
        }
    }

    private static enum BodyType {
        base,
        saleGoods,
        live,
        video,
        fans,
        contacr;

        private BodyTypeMethodFunction function;

        public static BodyType getTypeWhitName(String name) {
            for (BodyType value : BodyType.values()) {
                if (!value.name().equals(name)) continue;
                return value;
            }
            throw new TopManException(I18nUtil.translate((String)"", (String)"\u83b7\u53d6\u8fbe\u4eba\u8be6\u60c5\u7684\u4e3b\u4f53\u7c7b\u578b\u9519\u8bef\uff1abase\u3001saleGoods\u3001live\u3001video\u3001fans\u3001contacr"));
        }

        @FunctionalInterface
        static interface BodyTypeMethodFunction {
            public TopManResultDetailBody queryDetailBody(DouYinTopManDetailDTO var1);
        }
    }

    @FunctionalInterface
    @Deprecated
    private static interface ListMethod {
        public IPage<? extends TopManResultEntity> apply(IPage<TopManResultEntity> var1, Wrapper<TopManParamEntity> var2, LoginUser var3, TopManInformationVO var4, StatisticsDateType var5);
    }
}

