/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.topman.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.query.QueryGenerator;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.topman.entity.TopManMsgConfig;
import com.els.modules.topman.service.TopManMsgConfigService;
import com.els.modules.topman.utils.RedissonUtil;
import com.els.modules.topman.vo.TopManMsgConfigVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.redisson.api.RLock;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u8fbe\u4eba\u6d88\u606f\u914d\u7f6e"})
@RestController
@RequestMapping(value={"/msg/topManMsgConfig"})
public class TopManMsgConfigController
extends BaseController<TopManMsgConfig, TopManMsgConfigService> {
    @Autowired
    private TopManMsgConfigService topManMsgConfigService;
    @Autowired
    private RedisTemplate redisTemplate;
    @Autowired
    private RedissonUtil redissonUtil;

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    public Result<?> queryPageList(TopManMsgConfig topManMsgConfig, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)topManMsgConfig), (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        LoginUser loginUser = SysUtil.getLoginUser();
        queryWrapper.eq((Object)"els_account", (Object)TenantContext.getTenant());
        queryWrapper.eq((Object)"sub_account", (Object)loginUser.getSubAccount());
        queryWrapper.orderByAsc((Object)"sort_num");
        IPage pageList = this.topManMsgConfigService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @GetMapping(value={"/noToken/delRedis"})
    public void delRedis(@RequestParam(value="key") String key) {
        this.redisTemplate.delete((Object)key);
    }

    @GetMapping(value={"/noToken/key"})
    public void key(@RequestParam(value="key") String key) {
        RLock lock = this.redissonUtil.lock(key, (Long)1000000000L);
    }

    @AutoLog(value="\u8fbe\u4eba\u6d88\u606f\u914d\u7f6e-\u6dfb\u52a0")
    @ApiOperation(value="\u6dfb\u52a0", notes="\u6dfb\u52a0")
    @PostMapping(value={"/add"})
    public Result<?> add(@RequestBody TopManMsgConfig topManMsgConfig) {
        this.topManMsgConfigService.add(topManMsgConfig);
        return Result.ok((Object)((Object)topManMsgConfig));
    }

    @AutoLog(value="\u8fbe\u4eba\u6d88\u606f\u914d\u7f6e-\u7f16\u8f91")
    @ApiOperation(value="\u7f16\u8f91", notes="\u7f16\u8f91")
    @PostMapping(value={"/edit"})
    public Result<?> edit(@RequestBody TopManMsgConfig topManMsgConfig) {
        this.topManMsgConfigService.edit(topManMsgConfig);
        return this.commonSuccessResult(3);
    }

    @AutoLog(value="\u8fbe\u4eba\u6d88\u606f\u914d\u7f6e-\u7f16\u8f91")
    @ApiOperation(value="\u7f16\u8f91", notes="\u7f16\u8f91")
    @PostMapping(value={"/save/{platform}"})
    public Result<?> save(@RequestBody TopManMsgConfigVO configs, @PathVariable(value="platform") String platform) {
        this.topManMsgConfigService.saveConfigs(configs.getConfigs(), platform);
        return this.commonSuccessResult(3);
    }

    @AutoLog(value="\u8fbe\u4eba\u6d88\u606f\u914d\u7f6e-\u901a\u8fc7id\u5220\u9664")
    @ApiOperation(value="\u901a\u8fc7id\u5220\u9664", notes="\u901a\u8fc7id\u5220\u9664")
    @GetMapping(value={"/delete"})
    public Result<?> delete(@RequestParam(name="id") String id) {
        this.topManMsgConfigService.delete(id);
        return this.commonSuccessResult(4);
    }

    @AutoLog(value="\u8fbe\u4eba\u6d88\u606f\u914d\u7f6e-\u6279\u91cf\u5220\u9664")
    @ApiOperation(value="\u6279\u91cf\u5220\u9664", notes="\u6279\u91cf\u5220\u9664")
    @GetMapping(value={"/deleteBatch"})
    public Result<?> deleteBatch(@RequestParam(name="ids") String ids) {
        List<String> idList = Arrays.asList(ids.split(","));
        this.topManMsgConfigService.deleteBatch(idList);
        return this.commonSuccessResult(4);
    }

    @ApiOperation(value="\u901a\u8fc7id\u67e5\u8be2", notes="\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    public Result<?> queryById(@RequestParam(name="id") String id) {
        TopManMsgConfig topManMsgConfig = (TopManMsgConfig)((Object)this.topManMsgConfigService.getById((Serializable)((Object)id)));
        return Result.ok((Object)((Object)topManMsgConfig));
    }
}

