/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.topman.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.RedisUtil;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.account.api.service.AccountRpcService;
import com.els.modules.industryInfo.api.weboption.TopManOptionsEntity;
import com.els.modules.topman.dto.BilibiliTopManCollectDTO;
import com.els.modules.topman.entity.BilibiliTopManInformation;
import com.els.modules.topman.entity.TopManCollectBean;
import com.els.modules.topman.entity.TopManSpiderMark;
import com.els.modules.topman.enumerate.BilibiliOptionsType;
import com.els.modules.topman.enumerate.BilibiliOptionsTypeGroup;
import com.els.modules.topman.enumerate.MarkYn;
import com.els.modules.topman.enumerate.MongoCollectionType;
import com.els.modules.topman.mapper.BilibiliTopManInformationMapper;
import com.els.modules.topman.service.BilibiliTopManInformationService;
import com.els.modules.topman.service.MongoEntityService;
import com.els.modules.topman.service.TopManCollectService;
import com.els.modules.topman.weboption.OptionFactory;
import com.mongodb.client.MongoCursor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.data.mongodb.core.query.UpdateDefinition;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class BilibiliTopManInformationServiceImpl
extends BaseServiceImpl<BilibiliTopManInformationMapper, BilibiliTopManInformation>
implements BilibiliTopManInformationService {
    @Autowired
    private TopManCollectService topManCollectService;
    @Resource
    private MongoTemplate mongoTemplate;
    @Resource
    private AccountRpcService accountRpcService;
    @Autowired
    private RedisUtil redisUtil;
    private static final String COLON = ":";

    @Override
    public List<TopManOptionsEntity> getOptions(String type, String clearCache) {
        OptionFactory.OptionHandler<BilibiliOptionsTypeGroup, BilibiliOptionsType> init = OptionFactory.init(BilibiliOptionsTypeGroup.class, BilibiliOptionsType.class);
        init.setCollection("tb_huahuo_category_info");
        init.when(BilibiliOptionsType.commercialOrderType, (doc, param) -> this.transferTopManCommercial(doc)).when(BilibiliOptionsType.liveType, (doc, param) -> this.transferLiveTopMan(doc)).when(BilibiliOptionsType.talentInfo, (doc, param) -> this.transferFansPortrait(doc, type)).when(BilibiliOptionsType.putInfo, (doc, param) -> this.transferFansPortrait(doc, type)).when(BilibiliOptionsType.otherFilter, (doc, param) -> this.transferOtherFilter(doc, type));
        return init.getResult(type, "1".equals(clearCache));
    }

    private List<TopManOptionsEntity.Tag> transferTopManCommercial(Document doc) {
        List docList = doc.getList((Object)"directory_json", Document.class);
        return docList.stream().map(h -> {
            TopManOptionsEntity.TagCopy tag = new TopManOptionsEntity.TagCopy();
            tag.setId(h.get((Object)"id").toString());
            tag.setLabel(h.get((Object)"label").toString());
            tag.setValue(h.get((Object)"value").toString());
            tag.setComponentType("RMultipleChoice");
            tag.setChildren(this.getParam((Document)h));
            return tag;
        }).collect(Collectors.toList());
    }

    private List<Object> getParam(Document document) {
        ArrayList<Object> tagCopyList = new ArrayList<Object>();
        List children = document.getList((Object)"children", Map.class);
        if (CollectionUtil.isNotEmpty((Collection)children)) {
            children.forEach(a -> {
                TopManOptionsEntity.TagCopy tagCopy = new TopManOptionsEntity.TagCopy();
                tagCopy.setId(a.get("id").toString());
                tagCopy.setLabel(a.get("label").toString());
                tagCopy.setValue(a.get("value").toString());
                List children1 = (List)a.get("children");
                if (CollectionUtil.isEmpty((Collection)children)) {
                    tagCopy.setChildren(null);
                } else {
                    ArrayList sonTagCopyList = new ArrayList();
                    children1.forEach(b -> {
                        TopManOptionsEntity.TagCopy sonTagCopy = new TopManOptionsEntity.TagCopy();
                        sonTagCopy.setId(b.get("id") == null ? null : a.get("id").toString());
                        sonTagCopy.setLabel(b.get("label").toString());
                        sonTagCopy.setValue(b.get("label").toString());
                        sonTagCopy.setChildren(null);
                        sonTagCopyList.add(sonTagCopy);
                    });
                    tagCopy.setChildren(sonTagCopyList);
                }
                tagCopyList.add(tagCopy);
            });
        }
        return tagCopyList;
    }

    private List<TopManOptionsEntity.Tag> transferLiveTopMan(Document doc) {
        List docList = doc.getList((Object)"directory_json", Document.class);
        return docList.stream().map(h -> {
            TopManOptionsEntity.TagCopy tag = new TopManOptionsEntity.TagCopy();
            tag.setId(h.get((Object)"id").toString());
            tag.setLabel(h.get((Object)"name").toString());
            tag.setValue(h.get((Object)"id").toString());
            tag.setComponentType("RMultipleChoice");
            tag.setChildren(this.getLiveParam((Document)h));
            return tag;
        }).collect(Collectors.toList());
    }

    private List<Object> getLiveParam(Document document) {
        ArrayList<Object> tagCopyList = new ArrayList<Object>();
        List children = document.getList((Object)"list", Map.class);
        children.forEach(a -> {
            TopManOptionsEntity.TagCopy tagCopy = new TopManOptionsEntity.TagCopy();
            tagCopy.setId(a.get("id").toString());
            tagCopy.setLabel(a.get("name").toString());
            tagCopy.setValue(a.get("name").toString());
            tagCopyList.add(tagCopy);
        });
        return tagCopyList;
    }

    private List<TopManOptionsEntity.Tag> transferFansPortrait(Document doc, String type) {
        List docList = doc.getList((Object)"directory_json", Document.class);
        String starTagNames = "\u662f\u5426\u7b7e\u7ea6";
        docList = docList.stream().filter(h -> !starTagNames.equals(h.getString((Object)"label"))).distinct().collect(Collectors.toList());
        return docList.stream().map(h -> this.transferSub((Document)h, type, h.get((Object)"label").toString())).collect(Collectors.toList());
    }

    private List<TopManOptionsEntity.Tag> transferOtherFilter(Document doc, String type) {
        List docList = doc.getList((Object)"directory_json", Document.class);
        String starTagNames = "\u8d1f\u8d23\u4eba";
        if ("myTopMan".equals(type)) {
            docList = docList.stream().filter(h -> !starTagNames.equals(h.getString((Object)"label"))).distinct().collect(Collectors.toList());
        }
        return docList.stream().map(h -> this.transferSub((Document)h, type, h.get((Object)"label").toString())).collect(Collectors.toList());
    }

    private TopManOptionsEntity.Tag transferSub(Document doc, String type, String label) {
        TopManOptionsEntity.TagCopy tag = new TopManOptionsEntity.TagCopy();
        tag.setId(doc.get((Object)"id").toString());
        tag.setLabel(doc.getString((Object)"label"));
        tag.setValue(doc.get((Object)"value").toString());
        tag.setComponentType(doc.getString((Object)"componentType"));
        if ("\u4eba\u8bbe\u6807\u7b7e".equals(label) || "\u65e5\u5e38\u804c\u4e1a".equals(label) || "\u8fbe\u4eba\u5730\u57df".equals(label)) {
            ArrayList tagCopyList = new ArrayList();
            List children = doc.getList((Object)"children", Map.class);
            children.forEach(a -> {
                TopManOptionsEntity.TagCopy tagCopy = new TopManOptionsEntity.TagCopy();
                tagCopy.setId(a.get("id").toString());
                tagCopy.setLabel(a.get("label").toString());
                tagCopy.setValue(a.get("label").toString());
                List children1 = (List)a.get("children");
                if (CollectionUtil.isEmpty((Collection)children1)) {
                    tagCopy.setChildren(null);
                } else {
                    ArrayList sonTagCopyList = new ArrayList();
                    children1.forEach(b -> {
                        TopManOptionsEntity.TagCopy sonTagCopy = new TopManOptionsEntity.TagCopy();
                        sonTagCopy.setId(b.get("id") == null ? null : a.get("id").toString());
                        sonTagCopy.setLabel(b.get("label").toString());
                        sonTagCopy.setValue(b.get("label").toString());
                        sonTagCopy.setChildren(null);
                        sonTagCopyList.add(sonTagCopy);
                    });
                    tagCopy.setChildren(sonTagCopyList);
                }
                tagCopyList.add(tagCopy);
            });
            tag.setChildren(tagCopyList);
        } else if ("allTopMan".equals(type) && "\u8d1f\u8d23\u4eba".equals(label)) {
            tag.setChildren(this.transferAllTopManLeader());
        } else {
            tag.setChildren(doc.getList((Object)"children", Object.class));
        }
        if ("\u76f4\u64ad\u6807\u7b7e".equals(label)) {
            return null;
        }
        return tag;
    }

    private List<Object> transferAllTopManLeader() {
        List allByAccount = this.accountRpcService.getAllByAccount(TenantContext.getTenant());
        ArrayList<Object> tags = new ArrayList<Object>(allByAccount.size() + 1);
        TopManOptionsEntity.TagCopy tag = new TopManOptionsEntity.TagCopy();
        tag.setId("");
        tag.setValue("");
        tag.setLabel("\u65e0");
        tags.add(tag);
        allByAccount.forEach(a -> {
            TopManOptionsEntity.TagCopy tag1 = new TopManOptionsEntity.TagCopy();
            tag1.setId(a.getSubAccount());
            tag1.setValue(a.getSubAccount());
            tag1.setLabel(a.getRealname());
            tags.add(tag1);
        });
        return tags;
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void collect(BilibiliTopManCollectDTO dto) {
        if (MarkYn.check(dto.getCollect())) {
            this.addMarkToSpider(dto);
        }
        this.collectHandle(dto);
        StringBuilder listRedisKey = new StringBuilder("bs").append(COLON).append(TenantContext.getTenant()).append(COLON).append("list");
        this.redisUtil.dels(listRedisKey.toString());
    }

    private void collectHandle(BilibiliTopManCollectDTO dto) {
        LoginUser loginUser = SysUtil.getLoginUser();
        String elsAccount = loginUser.getElsAccount();
        String subAccount = loginUser.getSubAccount();
        BilibiliTopManInformation entity = dto.getEntity();
        if (MarkYn.check(dto.getCollect())) {
            TopManCollectBean topManCollectBean = new TopManCollectBean();
            topManCollectBean.setTopmanId(entity.getBstationId());
            topManCollectBean.setPlatform("4");
            topManCollectBean.setElsAccount(elsAccount);
            topManCollectBean.setSubAccount(subAccount);
            this.topManCollectService.save((Object)topManCollectBean);
        } else {
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.lambda().eq(BaseEntity::getElsAccount, (Object)elsAccount);
            queryWrapper.lambda().eq(TopManCollectBean::getSubAccount, (Object)subAccount);
            queryWrapper.lambda().eq(TopManCollectBean::getPlatform, (Object)"4");
            queryWrapper.lambda().eq(TopManCollectBean::getTopmanId, (Object)entity.getBstationId());
            this.topManCollectService.remove((Wrapper)queryWrapper);
        }
    }

    @Override
    public void addMarkToSpider(BilibiliTopManCollectDTO dto) {
        this.saveRedBookSpiderTopMan(dto.getEntity());
        StringBuilder listRedisKey = new StringBuilder("bs").append(COLON).append(TenantContext.getTenant()).append(COLON).append("list");
        this.redisUtil.dels(listRedisKey.toString());
    }

    private void addMarkToMongo(BilibiliTopManCollectDTO dto) {
        BilibiliTopManInformation entity = dto.getEntity();
        String topManId = String.valueOf(entity.getTopmanId());
        MongoCollectionType collectMark = MongoCollectionType.TB_REDBOOK_ELS_TOPMAN;
        HashMap<String, String> param = new HashMap<String, String>(1);
        param.put("topManId", topManId);
        Map<String, TopManSpiderMark> data = this.handleMongo(collectMark, param, TopManSpiderMark.class);
        TopManSpiderMark topManSpiderMark = data.get(topManId);
        if (topManSpiderMark == null) {
            topManSpiderMark = new TopManSpiderMark();
            topManSpiderMark.setTopManId(topManId);
            topManSpiderMark.setTaskType(dto.getTaskType());
            topManSpiderMark.setCount(1);
            this.mongoTemplate.insert((Object)topManSpiderMark, collectMark.getCollectName());
        } else {
            Query query = new Query((CriteriaDefinition)Criteria.where((String)"topManId").is((Object)topManId));
            Update update = new Update().set("count", (Object)(topManSpiderMark.getCount() + 1));
            this.mongoTemplate.upsert(query, (UpdateDefinition)update, TopManSpiderMark.class, collectMark.getCollectName());
        }
    }

    private <T extends MongoEntityService> Map<String, T> handleMongo(MongoCollectionType collectionType, HashMap<String, String> param, Class<T> beanClass) {
        Document inquireDoc = new Document();
        for (Map.Entry<String, String> p : param.entrySet()) {
            inquireDoc.append(p.getKey(), (Object)p.getValue());
        }
        try (MongoCursor cursor = this.mongoTemplate.getCollection(collectionType.getCollectName()).find((Bson)inquireDoc).noCursorTimeout(true).cursor();){
            HashMap<String, MongoEntityService> map = new HashMap<String, MongoEntityService>(20);
            while (cursor.hasNext()) {
                Document coreData = (Document)cursor.next();
                String subKey = collectionType.getSubKey();
                if (subKey != null) {
                    List keyData = coreData.getList((Object)subKey, Document.class);
                    for (Document keyDatum : keyData) {
                        String s = keyDatum.toJson();
                        MongoEntityService t = (MongoEntityService)JSON.parseObject((String)s, beanClass);
                        map.put(t.getKeyId(), t);
                    }
                    continue;
                }
                String s = coreData.toJson();
                MongoEntityService t = (MongoEntityService)JSON.parseObject((String)s, beanClass);
                map.put(t.getKeyId(), t);
            }
            HashMap<String, MongoEntityService> hashMap = map;
            return hashMap;
        }
    }

    private void saveRedBookSpiderTopMan(BilibiliTopManInformation information) {
        QueryWrapper query = new QueryWrapper();
        query.lambda().eq(BilibiliTopManInformation::getBstationId, (Object)information.getBstationId());
        BilibiliTopManInformation bilibiliTopManInformation = (BilibiliTopManInformation)((Object)((BilibiliTopManInformationMapper)this.baseMapper).selectOne((Wrapper)query));
        if (bilibiliTopManInformation == null) {
            information.setPlatform("4");
            information.setId("");
            ((BilibiliTopManInformationMapper)this.baseMapper).insert((Object)information);
        } else {
            information.setPlatform("4");
            information.setId(bilibiliTopManInformation.getId());
            information.setUpdateBy(TenantContext.getTenant());
            information.setUpdateTime(new Date());
            ((BilibiliTopManInformationMapper)this.baseMapper).updateById((Object)information);
        }
    }
}

