/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.topman.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.els.common.annotation.ApiCallCount;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.util.RedisUtil;
import com.els.modules.industryInfo.api.dto.SimplePostRequestParam;
import com.els.modules.topman.dto.KsTopManCollectDTO;
import com.els.modules.topman.dto.KsTopManDetailDTO;
import com.els.modules.topman.dto.KsTopManInformationDTO;
import com.els.modules.topman.exception.TopManException;
import com.els.modules.topman.service.KuaiShouTopManInformationService;
import com.els.modules.topman.utils.spider.entity.KsTopManDetailBaseEntity;
import com.els.modules.topman.utils.spider.entity.KsTopManDetailFansEntity;
import com.els.modules.topman.utils.spider.entity.KsTopManDetailGoodsEntity;
import com.els.modules.topman.utils.spider.entity.KsTopManDetailGoodsItemEntity;
import com.els.modules.topman.utils.spider.entity.KsTopManDetailGoodsStoreEntity;
import com.els.modules.topman.utils.spider.entity.KsTopManDetailLiveAnalysisEntity;
import com.els.modules.topman.utils.spider.entity.KsTopManDetailLiveDataEntity;
import com.els.modules.topman.utils.spider.entity.KsTopManDetailLiveEntity;
import com.els.modules.topman.utils.spider.entity.KsTopManDetailVideoAnalysisEntity;
import com.els.modules.topman.utils.spider.entity.KsTopManDetailVideoEntity;
import com.els.modules.topman.utils.spider.entity.KsTopManDetailVideoInfoEntity;
import com.els.modules.topman.utils.spider.entity.KsTopManDetailVideoListEntity;
import com.els.modules.topman.utils.spider.vo.KsTopManDetailHeadContacrVO;
import com.els.modules.topman.utils.spider.vo.KsTopManDetailHeadVO;
import com.els.modules.topman.vo.KsTopManVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/ks/topMan"})
@Api(tags={"\u5feb\u624b\u8fbe\u4eba\u4fe1\u606f\u5e93"})
public class KuaiShouTopManController {
    @Autowired
    private KuaiShouTopManInformationService topManInformationService;
    @Autowired
    private RedisUtil redisUtil;

    @ApiOperation(value="\u5feb\u624b\u8fbe\u4eba\u5217\u8868\u5206\u7c7b\u67e5\u8be2", notes="\u5feb\u624b\u8fbe\u4eba\u5217\u8868\u5206\u7c7b\u67e5\u8be2")
    @GetMapping(value={"/category"})
    public Result<?> getCategoryData(@RequestParam(name="type", required=false, defaultValue="0") String type) {
        return Result.ok(this.topManInformationService.getCategoryData(type));
    }

    @ApiOperation(value="\u5feb\u624b\u8fbe\u4eba\u5217\u8868\u5206\u7c7b\u7f13\u5b58\u6e05\u9664", notes="\u5feb\u624b\u8fbe\u4eba\u5217\u8868\u5206\u7c7b\u7f13\u5b58\u6e05\u9664")
    @GetMapping(value={"/cleanCache"})
    public Result<?> cleanCache() {
        this.topManInformationService.cleanCache();
        return Result.ok();
    }

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @PostMapping(value={"/list"})
    @ApiCallCount(apiCode="industry_top_main_list_data")
    public Result<?> listAll(@RequestBody SimplePostRequestParam<KsTopManInformationDTO> topManDto) {
        try {
            IPage<KsTopManVO> pageList = this.topManInformationService.queryTopManList(topManDto);
            return Result.ok(pageList);
        }
        catch (Exception te) {
            te.printStackTrace();
            return Result.error((String)te.getMessage());
        }
    }

    @AutoLog(busModule="\u5feb\u624b\u8fbe\u4eba\u4fe1\u606f\u5e93", value="\u6536\u85cf\u8fbe\u4eba")
    @ApiOperation(value="\u6536\u85cf\u8fbe\u4eba", notes="\u6536\u85cf\u8fbe\u4eba")
    @PostMapping(value={"/collect"})
    public Result<?> collect(@RequestBody KsTopManCollectDTO ksTopManCollectDTO) {
        this.topManInformationService.collect(ksTopManCollectDTO);
        return Result.ok();
    }

    @AutoLog(busModule="\u5feb\u624b\u8fbe\u4eba\u4fe1\u606f\u5e93", value="\u6dfb\u52a0\u5165\u5e93")
    @ApiOperation(value="\u6dfb\u52a0\u5165\u5e93", notes="\u6dfb\u52a0\u5165\u5e93")
    @PostMapping(value={"/addMark"})
    public Result<?> addMarkToSpider(@RequestBody KsTopManCollectDTO ksTopManCollectDTO) {
        this.topManInformationService.addMarkToSpider(ksTopManCollectDTO);
        return Result.ok();
    }

    @ApiOperation(value="\u8fbe\u4eba\u8be6\u60c5", notes="\u8fbe\u4eba\u8be6\u60c5")
    @GetMapping(value={"/getByUserId"})
    public Result<?> getByUserId(@RequestParam(value="userId") String userId) {
        try {
            return Result.ok((Object)this.topManInformationService.getByUserId(userId));
        }
        catch (TopManException te) {
            return Result.error((String)te.getMessage());
        }
    }

    @ApiOperation(value="\u8be6\u60c5\u5934\u90e8-\u5934\u90e8\u6570\u636e\u3001\u6838\u5fc3\u6570\u636e(\u5f03\u7528)", notes="\u8be6\u60c5\u5934\u90e8-\u5934\u90e8\u6570\u636e\u3001\u6838\u5fc3\u6570\u636e")
    @PostMapping(value={"/detail/head"})
    @ApiCallCount(apiCode="industry_top_main_detail_data")
    public Result<?> getDetailHead(@RequestBody KsTopManDetailDTO param) {
        try {
            KsTopManDetailHeadVO detailHead = this.topManInformationService.getDetailHead(param);
            return Result.ok((Object)detailHead);
        }
        catch (TopManException te) {
            return Result.error((String)te.getMessage());
        }
    }

    @ApiOperation(value="\u8be6\u60c5\u5934\u90e8-\u5934\u90e8\u6570\u636e\u3001\u57fa\u7840\u6570\u636e\u3001\u76f4\u64ad\u6570\u636e\u3001\u89c6\u9891\u6570\u636e\uff08\u65b0\uff09", notes="\u8be6\u60c5\u5934\u90e8-\u5934\u90e8\u6570\u636e\u3001\u57fa\u7840\u6570\u636e\u3001\u76f4\u64ad\u6570\u636e\u3001\u89c6\u9891\u6570\u636e\uff08\u65b0\uff09")
    @PostMapping(value={"/detail/headNew"})
    @ApiCallCount(apiCode="industry_top_main_detail_data")
    public Result<?> getDetailHeadNew(@RequestBody KsTopManDetailDTO param) {
        try {
            KsTopManDetailHeadVO detailHead = this.topManInformationService.getDetailHeadNew(param);
            return Result.ok((Object)detailHead);
        }
        catch (TopManException te) {
            return Result.error((String)te.getMessage());
        }
    }

    @ApiOperation(value="\u8be6\u60c5-\u57fa\u7840\u6570\u636e-\u8fbe\u4eba\u7b80\u4ecb\uff08\u65b0\uff09", notes="\u8be6\u60c5-\u57fa\u7840\u6570\u636e-\u8fbe\u4eba\u7b80\u4ecb\uff08\u65b0\uff09")
    @PostMapping(value={"/detail/base"})
    public Result<?> getDetailBase(@RequestBody KsTopManDetailDTO param) {
        try {
            KsTopManDetailHeadVO detailHead = this.topManInformationService.getDetailBase(param);
            return Result.ok((Object)detailHead);
        }
        catch (TopManException te) {
            return Result.error((String)te.getMessage());
        }
    }

    @ApiOperation(value="\u8be6\u60c5-\u6838\u5fc3\u6570\u636e\uff08\u65b0\uff09", notes="\u8be6\u60c5-\u6838\u5fc3\u6570\u636e\uff08\u65b0\uff09")
    @PostMapping(value={"/detail/core"})
    public Result<?> getDetailCore(@RequestBody KsTopManDetailDTO param) {
        try {
            KsTopManDetailHeadVO detailHead = this.topManInformationService.getDetailCore(param);
            return Result.ok((Object)detailHead);
        }
        catch (TopManException te) {
            return Result.error((String)te.getMessage());
        }
    }

    @ApiOperation(value="\u8be6\u60c5\u5934\u90e8-\u8054\u7cfb\u65b9\u5f0f", notes="\u8be6\u60c5\u5934\u90e8-\u8054\u7cfb\u65b9\u5f0f")
    @PostMapping(value={"/detail/head/contacr"})
    public Result<?> getDetailHeadContacr(@RequestBody KsTopManDetailDTO param) {
        try {
            KsTopManDetailHeadContacrVO result = this.topManInformationService.getDetailHeadContacr(param);
            return Result.ok((Object)result);
        }
        catch (TopManException te) {
            return Result.error((String)te.getMessage());
        }
    }

    @ApiOperation(value="\u77ed\u4fe1\u9a8c\u8bc1\u7801\u6821\u9a8c", notes="\u77ed\u4fe1\u9a8c\u8bc1\u7801\u6821\u9a8c")
    @PostMapping(value={"/codeCheck"})
    public Result<?> codeCheck(@RequestBody KsTopManDetailDTO dto) {
        if (StringUtils.isBlank((CharSequence)dto.getContacrPhone())) {
            return Result.error((String)"\u624b\u673a\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isBlank((CharSequence)dto.getNoteCode())) {
            return Result.error((String)"\u624b\u673a\u6821\u9a8c\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        Object code = this.redisUtil.get(dto.getContacrPhone());
        if (!dto.getNoteCode().equals(code)) {
            return Result.error((String)"\u624b\u673a\u9a8c\u8bc1\u7801\u9519\u8bef\uff01");
        }
        return Result.ok();
    }

    @ApiOperation(value="\u8be6\u60c5-\u57fa\u7840\u5206\u6790", notes="\u8be6\u60c5-\u57fa\u7840\u5206\u6790")
    @PostMapping(value={"/detail/body/base"})
    public Result<?> getDetailBodyBase(@RequestBody KsTopManDetailDTO param) {
        try {
            KsTopManDetailBaseEntity bodyBase = this.topManInformationService.getDetailBodyBase(param);
            return Result.ok((Object)bodyBase);
        }
        catch (TopManException te) {
            return Result.error((String)te.getMessage());
        }
    }

    @ApiOperation(value="\u8be6\u60c5-\u76f4\u64ad\u5206\u6790-\u5934\u90e8\u4fe1\u606f", notes="\u8be6\u60c5-\u76f4\u64ad\u5206\u6790-\u5934\u90e8\u4fe1\u606f")
    @PostMapping(value={"/detail/body/liveNew"})
    public Result<?> getDetailBodyLiveNew(@RequestBody KsTopManDetailDTO param) {
        try {
            KsTopManDetailLiveAnalysisEntity entity = this.topManInformationService.getDetailBodyLiveNew(param);
            return Result.ok((Object)entity);
        }
        catch (TopManException te) {
            return Result.error((String)te.getMessage());
        }
    }

    @ApiOperation(value="\u8be6\u60c5-\u76f4\u64ad\u5206\u6790-\u76f4\u64ad\u5217\u8868", notes="\u8be6\u60c5-\u76f4\u64ad\u5206\u6790-\u76f4\u64ad\u5217\u8868")
    @PostMapping(value={"/detail/body/live"})
    public Result<?> getDetailBodyLive(@RequestBody KsTopManDetailDTO param) {
        try {
            KsTopManDetailLiveEntity bodyLive = this.topManInformationService.getDetailBodyLive(param);
            return Result.ok((Object)bodyLive);
        }
        catch (TopManException te) {
            return Result.error((String)te.getMessage());
        }
    }

    @ApiOperation(value="\u8be6\u60c5-\u76f4\u64ad\u5206\u6790-\u672c\u573a\u5e26\u8d27\u6570\u636e", notes="\u8be6\u60c5-\u76f4\u64ad\u5206\u6790-\u672c\u573a\u5e26\u8d27\u6570\u636e")
    @PostMapping(value={"/detail/body/liveData"})
    public Result<?> getDetailBodyLiveData(@RequestBody KsTopManDetailDTO param) {
        try {
            KsTopManDetailLiveDataEntity bodyLiveData = this.topManInformationService.getDetailBodyLiveData(param);
            return Result.ok((Object)bodyLiveData);
        }
        catch (TopManException te) {
            return Result.error((String)te.getMessage());
        }
    }

    @ApiOperation(value="\u8be6\u60c5-\u89c6\u9891\u5206\u6790-\u5934\u90e8\u4fe1\u606f", notes="\u8be6\u60c5-\u89c6\u9891\u5206\u6790-\u5934\u90e8\u4fe1\u606f")
    @PostMapping(value={"/detail/body/videoNew"})
    public Result<?> getDetailBodyVideoNew(@RequestBody KsTopManDetailDTO param) {
        try {
            KsTopManDetailVideoAnalysisEntity entity = this.topManInformationService.getDetailBodyVideoNew(param);
            return Result.ok((Object)entity);
        }
        catch (TopManException te) {
            return Result.error((String)te.getMessage());
        }
    }

    @ApiOperation(value="\u8be6\u60c5-\u89c6\u9891\u5206\u6790-\u5e26\u8d27\u6548\u679c", notes="\u8be6\u60c5-\u89c6\u9891\u5206\u6790-\u5e26\u8d27\u6548\u679c")
    @PostMapping(value={"/detail/body/videoInfo"})
    public Result<?> getDetailBodyVideoInfo(@RequestBody KsTopManDetailDTO param) {
        try {
            KsTopManDetailVideoInfoEntity entity = this.topManInformationService.getDetailBodyVideoInfo(param);
            return Result.ok((Object)entity);
        }
        catch (TopManException te) {
            return Result.error((String)te.getMessage());
        }
    }

    @ApiOperation(value="\u8be6\u60c5-\u89c6\u9891\u5206\u6790-\u89c6\u9891\u5217\u8868\uff08\u5f03\u7528\uff09", notes="\u8be6\u60c5-\u89c6\u9891\u5206\u6790-\u89c6\u9891\u5217\u8868")
    @PostMapping(value={"/detail/body/video"})
    public Result<?> getDetailBodyVideo(@RequestBody KsTopManDetailDTO param) {
        try {
            KsTopManDetailVideoEntity bodyVideo = this.topManInformationService.getDetailBodyVideo(param);
            return Result.ok((Object)bodyVideo);
        }
        catch (TopManException te) {
            return Result.error((String)te.getMessage());
        }
    }

    @ApiOperation(value="\u8be6\u60c5-\u89c6\u9891\u5206\u6790-\u89c6\u9891\u5217\u8868\uff08\u5feb\u5206\u9500\uff09", notes="\u8be6\u60c5-\u89c6\u9891\u5206\u6790-\u89c6\u9891\u5217\u8868")
    @PostMapping(value={"/detail/body/videoList"})
    public Result<?> getDetailBodyVideoList(@RequestBody KsTopManDetailDTO param) {
        try {
            KsTopManDetailVideoListEntity bodyVideo = this.topManInformationService.getDetailBodyVideoList(param);
            return Result.ok((Object)bodyVideo);
        }
        catch (TopManException te) {
            return Result.error((String)te.getMessage());
        }
    }

    @ApiOperation(value="\u8be6\u60c5-\u7c89\u4e1d\u5206\u6790", notes="\u8be6\u60c5-\u7c89\u4e1d\u5206\u6790")
    @PostMapping(value={"/detail/body/fans"})
    public Result<?> getDetailBodyFans(@RequestBody KsTopManDetailDTO param) {
        try {
            KsTopManDetailFansEntity bodyFans = this.topManInformationService.getDetailBodyFans(param);
            return Result.ok((Object)bodyFans);
        }
        catch (TopManException te) {
            return Result.error((String)te.getMessage());
        }
    }

    @ApiOperation(value="\u8be6\u60c5-\u5e26\u8d27\u5206\u6790-\u5e26\u8d27\u7c7b\u76ee", notes="\u8be6\u60c5-\u5e26\u8d27\u5206\u6790-\u5e26\u8d27\u7c7b\u76ee")
    @PostMapping(value={"/detail/body/goodsCategory"})
    public Result<?> getDetailBodyGoodsCategory(@RequestBody KsTopManDetailDTO param) {
        try {
            KsTopManDetailGoodsEntity goods = this.topManInformationService.getDetailBodyGoodsCategory(param);
            return Result.ok((Object)goods);
        }
        catch (TopManException te) {
            return Result.error((String)te.getMessage());
        }
    }

    @ApiOperation(value="\u8be6\u60c5-\u5e26\u8d27\u5206\u6790-\u6838\u5fc3\u6570\u636e", notes="\u8be6\u60c5-\u5e26\u8d27\u5206\u6790-\u6838\u5fc3\u6570\u636e")
    @PostMapping(value={"/detail/body/goods"})
    public Result<?> getDetailBodyGoods(@RequestBody KsTopManDetailDTO param) {
        try {
            KsTopManDetailGoodsEntity goods = this.topManInformationService.getDetailBodyGoods(param);
            return Result.ok((Object)goods);
        }
        catch (TopManException te) {
            return Result.error((String)te.getMessage());
        }
    }

    @ApiOperation(value="\u8be6\u60c5-\u5e26\u8d27\u5206\u6790-\u5546\u54c1\u5217\u8868", notes="\u8be6\u60c5-\u5e26\u8d27\u5206\u6790-\u5546\u54c1\u5217\u8868")
    @PostMapping(value={"/detail/body/goodsItem"})
    public Result<?> getDetailBodyGoodsItem(@RequestBody KsTopManDetailDTO param) {
        try {
            KsTopManDetailGoodsItemEntity goodsItem = this.topManInformationService.getDetailBodyGoodsItem(param);
            return Result.ok((Object)goodsItem);
        }
        catch (TopManException te) {
            return Result.error((String)te.getMessage());
        }
    }

    @ApiOperation(value="\u8be6\u60c5-\u5e26\u8d27\u5206\u6790-\u5e97\u94fa\u5217\u8868", notes="\u8be6\u60c5-\u5e26\u8d27\u5206\u6790-\u5e97\u94fa\u5217\u8868")
    @PostMapping(value={"/detail/body/goodsStore"})
    public Result<?> getDetailBodyGoodsStore(@RequestBody KsTopManDetailDTO param) {
        try {
            KsTopManDetailGoodsStoreEntity goodsStore = this.topManInformationService.getDetailBodyGoodsStore(param);
            return Result.ok((Object)goodsStore);
        }
        catch (TopManException te) {
            return Result.error((String)te.getMessage());
        }
    }

    @ApiOperation(value="\u8fbe\u4eba\u5730\u57df\u8f6c\u6362-\u8c03\u8bd5\u7528", notes="\u8fbe\u4eba\u5730\u57df\u8f6c\u6362-\u8c03\u8bd5\u7528")
    @GetMapping(value={"/getRegion"})
    public Result<?> getRegion(@RequestParam Integer provinceCode, @RequestParam Integer cityCode) {
        String region = this.topManInformationService.formatRegion(provinceCode, cityCode);
        return Result.ok((String)region);
    }
}

