/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.topman.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.lang.func.VoidFunc1;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.system.query.QueryGenerator;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.I18nUtil;
import com.els.common.util.RedisUtil;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.account.api.service.AccountRpcService;
import com.els.modules.industryInfo.api.dto.SimplePostRequestParam;
import com.els.modules.industryInfo.api.weboption.TopManOptionsEntity;
import com.els.modules.topman.dto.RedBookTopManCollectDTO;
import com.els.modules.topman.dto.RedBookTopManDetailDTO;
import com.els.modules.topman.dto.RedBookTopManInformationDTO;
import com.els.modules.topman.entity.RedBookTopManInformation;
import com.els.modules.topman.entity.TopManCollectBean;
import com.els.modules.topman.entity.TopManSpiderMark;
import com.els.modules.topman.enumerate.MarkYn;
import com.els.modules.topman.enumerate.MongoCollectionType;
import com.els.modules.topman.enumerate.RedBookOptionsType;
import com.els.modules.topman.enumerate.RedBookOptionsTypeGroup;
import com.els.modules.topman.mapper.RedBookTopManInformationMapper;
import com.els.modules.topman.service.MongoEntityService;
import com.els.modules.topman.service.RedBookTopManInformationService;
import com.els.modules.topman.service.TopManCollectService;
import com.els.modules.topman.utils.spider.dto.RedBookLiveTopManApiDTO;
import com.els.modules.topman.utils.spider.dto.RedBookNoteTopManApiDTO;
import com.els.modules.topman.utils.spider.dto.RedBookStarAccountApiDTO;
import com.els.modules.topman.utils.spider.properties.SpiderMethodType;
import com.els.modules.topman.utils.spider.spiderApi.SpiderApiUtil;
import com.els.modules.topman.utils.spider.vo.RedBookLiveTopManApiPage;
import com.els.modules.topman.utils.spider.vo.RedBookLiveTopManApiVO;
import com.els.modules.topman.utils.spider.vo.RedBookNoteTopManApiPage;
import com.els.modules.topman.utils.spider.vo.RedBookNoteTopManApiVO;
import com.els.modules.topman.utils.spider.vo.RedBookTopManDetailHeadVO;
import com.els.modules.topman.weboption.OptionFactory;
import com.els.modules.topman.weboption.function.DocHandler;
import com.mongodb.client.MongoCursor;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.data.mongodb.core.query.UpdateDefinition;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class RedBookTopManInformationServiceImpl
extends BaseServiceImpl<RedBookTopManInformationMapper, RedBookTopManInformation>
implements RedBookTopManInformationService {
    @Autowired
    private TopManCollectService topManCollectService;
    @Resource
    private MongoTemplate mongoTemplate;
    @Autowired
    private SpiderApiUtil spiderApiUtil;
    @Autowired
    private RedisUtil redisUtil;
    @Resource
    private AccountRpcService accountRpcService;

    @Override
    public IPage<RedBookTopManInformation> queryTopManList(SimplePostRequestParam<RedBookTopManInformationDTO> topManDto) {
        IPage<RedBookTopManInformation> page = new IPage<RedBookTopManInformation>((long)topManDto.getPageNo().intValue(), (long)topManDto.getPageSize().intValue());
        RedBookTopManInformationDTO filterInfo = (RedBookTopManInformationDTO)topManDto.getFilterInfo();
        String taskType = filterInfo.getTaskType();
        if (RedBookOptionsTypeGroup.noteTopMan.getName().equals(taskType)) {
            Map<?, ?> map = this.handleBodyNoteTopMan(topManDto);
            SpiderMethodType methodType = SpiderMethodType.RED_BOOK_BLOGGER_LIST;
            Class<RedBookNoteTopManApiPage> responseClass = RedBookNoteTopManApiPage.class;
            RedBookNoteTopManApiPage data = this.spiderApiUtil.postForEntity(methodType, map, responseClass);
            page.setTotal(data.getTotal());
            page.setRecords(this.handleResult(data, filterInfo.getPlatformType()));
        } else if (RedBookOptionsTypeGroup.liveTopMan.getName().equals(taskType)) {
            Map<?, ?> map = this.handleBodyLiveTopMan(topManDto);
            SpiderMethodType methodType = SpiderMethodType.RED_BOOK_EC_BLOGGER_LIST;
            Class<RedBookLiveTopManApiPage> responseClass = RedBookLiveTopManApiPage.class;
            RedBookLiveTopManApiPage data = this.spiderApiUtil.postForEntity(methodType, map, responseClass);
            page.setTotal(data.getTotal());
            page.setRecords(this.handleResultLiveTopMan(data, filterInfo.getPlatformType()));
        } else if (RedBookOptionsTypeGroup.starAccount.getName().equals(taskType)) {
            Map<?, ?> map = this.handleBodyStarAccount(topManDto);
            SpiderMethodType methodType = SpiderMethodType.RED_BOOK_STAR_LIST;
            Class<RedBookNoteTopManApiPage> responseClass = RedBookNoteTopManApiPage.class;
            RedBookNoteTopManApiPage data = this.spiderApiUtil.postForEntity(methodType, map, responseClass);
            page.setTotal(data.getTotal());
            page.setRecords(this.handleResult(data, filterInfo.getPlatformType()));
        } else {
            QueryWrapper<RedBookTopManInformation> queryWrapper = this.getQueryWrapper(topManDto);
            RedBookTopManInformationDTO.ScreenItem screenItem = ((RedBookTopManInformationDTO)topManDto.getFilterInfo()).getScreenItem();
            String contentType = "";
            String personalTag = "";
            String featureTag = "";
            if (screenItem != null) {
                contentType = this.handleContentTypes(topManDto);
                List<RedBookTopManInformationDTO.ScreenItemField> talentInfo = screenItem.getTalentInfo();
                List<String> personalTags = this.handleTagList(talentInfo, "\u535a\u4e3b\u4eba\u8bbe");
                personalTag = StringUtils.join(personalTags, (String)"|");
                List<RedBookTopManInformationDTO.ScreenItemField> contentForm = screenItem.getContentFeature();
                List<String> featureTags = this.handleTagList(contentForm, "\u5185\u5bb9\u7279\u5f81");
                featureTag = StringUtils.join(featureTags, (String)"|");
            }
            page = ((RedBookTopManInformationMapper)this.baseMapper).selectCollectTopMan(page, queryWrapper, SysUtil.getLoginUser(), contentType, personalTag, featureTag);
        }
        return page;
    }

    private List<RedBookTopManInformation> handleResult(RedBookNoteTopManApiPage data, String platform) {
        List<RedBookNoteTopManApiVO> starList = data.getList();
        if (CollectionUtil.isEmpty(starList)) {
            return new ArrayList<RedBookTopManInformation>(0);
        }
        List<String> topmanIds = starList.stream().map(RedBookNoteTopManApiVO::getUserId).distinct().collect(Collectors.toList());
        List<RedBookTopManInformation> addedAndCollects = ((RedBookTopManInformationMapper)this.baseMapper).checkAddedAndCollect(topmanIds, SysUtil.getLoginUser(), platform);
        Map<Object, Object> map = new HashMap();
        if (CollectionUtil.isNotEmpty(addedAndCollects)) {
            map = addedAndCollects.stream().collect(Collectors.toMap(RedBookTopManInformation::getTopmanId, h -> h, (k1, k2) -> k1));
        }
        ArrayList<RedBookTopManInformation> resultEntityList = new ArrayList<RedBookTopManInformation>(starList.size());
        for (RedBookNoteTopManApiVO topManInfo : starList) {
            RedBookTopManInformation info;
            RedBookTopManInformation rb = new RedBookTopManInformation();
            BeanUtils.copyProperties((Object)topManInfo, (Object)((Object)rb));
            rb.setTopmanId(topManInfo.getUserId());
            rb.setPlatform("3");
            rb.setPersonalTags(StringUtils.join(topManInfo.getPersonalTags(), (String)","));
            rb.setFeatureTags(StringUtils.join(topManInfo.getFeatureTags(), (String)","));
            List<RedBookNoteTopManApiVO.ContentTags> contentTags = topManInfo.getContentTags();
            if (CollectionUtil.isNotEmpty(contentTags)) {
                List collect = topManInfo.getContentTags().stream().map(RedBookNoteTopManApiVO.ContentTags::getTaxonomy1Tag).collect(Collectors.toList());
                rb.setContentType(StringUtils.join(collect, (String)","));
            }
            if ((info = (RedBookTopManInformation)((Object)map.get(topManInfo.getUserId()))) != null) {
                rb.setIsCollection(info.getIsCollection());
                rb.setIsAdded(info.getIsAdded());
            }
            resultEntityList.add(rb);
        }
        return resultEntityList;
    }

    private List<RedBookTopManInformation> handleResultLiveTopMan(RedBookLiveTopManApiPage data, String platform) {
        List<RedBookLiveTopManApiVO> starList = data.getList();
        if (CollectionUtil.isEmpty(starList)) {
            return new ArrayList<RedBookTopManInformation>(0);
        }
        List<String> topmanIds = starList.stream().map(RedBookLiveTopManApiVO::getDistributorId).distinct().collect(Collectors.toList());
        List<RedBookTopManInformation> addedAndCollects = ((RedBookTopManInformationMapper)this.baseMapper).checkAddedAndCollect(topmanIds, SysUtil.getLoginUser(), platform);
        Map<Object, Object> map = new HashMap();
        if (CollectionUtil.isNotEmpty(addedAndCollects)) {
            map = addedAndCollects.stream().collect(Collectors.toMap(RedBookTopManInformation::getTopmanId, h -> h, (k1, k2) -> k1));
        }
        ArrayList<RedBookTopManInformation> resultEntityList = new ArrayList<RedBookTopManInformation>(starList.size());
        for (RedBookLiveTopManApiVO topManInfo : starList) {
            RedBookTopManInformation info;
            RedBookTopManInformation rb = new RedBookTopManInformation();
            BeanUtils.copyProperties((Object)topManInfo, (Object)((Object)rb));
            rb.setTopmanId(topManInfo.getDistributorId());
            rb.setHeadPhoto(topManInfo.getAvatar());
            rb.setName(topManInfo.getDistributorName());
            rb.setGender(topManInfo.getSex());
            rb.setLocation(topManInfo.getCity());
            rb.setSpecialPrice(topManInfo.getSpecialPrice());
            rb.setMatchPrice(topManInfo.getMatchPrice());
            rb.setPlatform("3");
            List<RedBookLiveTopManApiVO.Tags> contentTags = topManInfo.getTags();
            if (CollectionUtil.isNotEmpty(contentTags)) {
                List collect = contentTags.stream().map(RedBookLiveTopManApiVO.Tags::getLevel1Tag).collect(Collectors.toList());
                rb.setContentType(StringUtils.join(collect, (String)","));
            }
            if ((info = (RedBookTopManInformation)((Object)map.get(topManInfo.getDistributorId()))) != null) {
                rb.setIsCollection(info.getIsCollection());
                rb.setIsAdded(info.getIsAdded());
            }
            resultEntityList.add(rb);
        }
        return resultEntityList;
    }

    private Map<?, ?> handleBodyNoteTopMan(SimplePostRequestParam<RedBookTopManInformationDTO> topManDto) {
        RedBookTopManInformationDTO.ScreenItem screenItem;
        RedBookNoteTopManApiDTO spiderApiDTO = new RedBookNoteTopManApiDTO(topManDto);
        String keyWord = topManDto.getKeyWord();
        if (keyWord != null && !"".equals(keyWord)) {
            spiderApiDTO.setKeyword(keyWord);
            spiderApiDTO.setSearchType("0");
        }
        if ((screenItem = ((RedBookTopManInformationDTO)topManDto.getFilterInfo()).getScreenItem()) != null) {
            List<RedBookTopManInformationDTO.ScreenItemField> contentType = screenItem.getContentType();
            if (CollectionUtil.isNotEmpty(contentType)) {
                List<String> collect = contentType.stream().map(RedBookTopManInformationDTO.ScreenItemField::getTitle).distinct().collect(Collectors.toList());
                spiderApiDTO.setContentTag(collect);
            }
            List<RedBookTopManInformationDTO.ScreenItemField> talentInfo = screenItem.getTalentInfo();
            spiderApiDTO.setPersonalTags(this.handleTagList(talentInfo, "\u535a\u4e3b\u4eba\u8bbe"));
            List<RedBookTopManInformationDTO.ScreenItemField> contentForm = screenItem.getContentFeature();
            spiderApiDTO.setFeatureTags(this.handleTagList(contentForm, "\u5185\u5bb9\u7279\u5f81"));
            List<RedBookTopManInformationDTO.ScreenItemField> talentInfo2 = screenItem.getTalentInfo();
            this.initScreenItemField(talentInfo2, spiderApiDTO, "\u535a\u4e3b\u4fe1\u606f");
            List<RedBookTopManInformationDTO.ScreenItemField> putInfo = screenItem.getPutInfo();
            this.initScreenItemField(putInfo, spiderApiDTO, "\u5408\u4f5c\u4fe1\u606f");
            List<RedBookTopManInformationDTO.ScreenItemField> fansPortrait = screenItem.getFansPortrait();
            this.initScreenItemField(fansPortrait, spiderApiDTO, "\u7c89\u4e1d\u753b\u50cf");
            List<RedBookTopManInformationDTO.ScreenItemField> other = screenItem.getOther();
            this.initScreenItemField(other, spiderApiDTO, "\u5176\u4ed6");
        }
        String json = JSON.toJSONString((Object)spiderApiDTO);
        return (Map)JSON.parseObject((String)json, Map.class);
    }

    private List<String> handleTagList(List<RedBookTopManInformationDTO.ScreenItemField> screenItemFields, String name) {
        if (screenItemFields == null || screenItemFields.size() == 0) {
            return null;
        }
        if ("\u535a\u4e3b\u4eba\u8bbe".equals(name)) {
            String[] titles = new String[]{"\u8eab\u4efd\u4fe1\u606f", "\u5bb6\u5ead\u89d2\u8272", "\u7279\u8272\u80cc\u666f"};
            screenItemFields = screenItemFields.stream().filter(h -> Arrays.asList(titles).contains(h.getTitle())).collect(Collectors.toList());
        }
        ArrayList<String> list = new ArrayList<String>();
        screenItemFields.forEach(h -> {
            List values = JSON.parseArray((String)h.getValue(), String.class);
            list.addAll(values);
        });
        return list;
    }

    private void initScreenItemField(List<RedBookTopManInformationDTO.ScreenItemField> screenItemFields, RedBookNoteTopManApiDTO apiDTO, String name) {
        String[] titles;
        if (screenItemFields == null || screenItemFields.size() == 0) {
            return;
        }
        if ("\u535a\u4e3b\u4fe1\u606f".equals(name)) {
            titles = new String[]{"\u7c89\u4e1d\u603b\u6570", "\u8fbe\u4eba\u5730\u57df", "\u8fbe\u4eba\u6027\u522b", "\u4f5c\u54c1\u7c7b\u578b"};
            screenItemFields = screenItemFields.stream().filter(h -> Arrays.asList(titles).contains(h.getTitle())).collect(Collectors.toList());
        }
        if ("\u5408\u4f5c\u4fe1\u606f".equals(name)) {
            titles = new String[]{"\u89c6\u9891\u63a8\u5e7f\u62a5\u4ef7", "\u56fe\u6587\u63a8\u5e7f\u62a5\u4ef7", "\u8fd1\u671f\u5408\u4f5c\u884c\u4e1a"};
            screenItemFields = screenItemFields.stream().filter(h -> Arrays.asList(titles).contains(h.getTitle())).collect(Collectors.toList());
        }
        if ("\u5176\u4ed6".equals(name)) {
            titles = new String[]{"\u8fd130\u65e5\u7c89\u4e1d\u6570\u4e0a\u5347", "\u65b0\u9510\u8fbe\u4eba", "\u5254\u9664\u4f4e\u6d3b\u8dc3\u535a\u4e3b"};
            screenItemFields = screenItemFields.stream().filter(h -> Arrays.asList(titles).contains(h.getTitle())).collect(Collectors.toList());
        }
        screenItemFields.forEach(h -> {
            String value = h.getValue();
            switch (h.getTitle()) {
                case "\u7c89\u4e1d\u603b\u6570": {
                    this.handleMinMaxInteger(value, (VoidFunc1<Integer>)((VoidFunc1 & Serializable)apiDTO::setFansNumberLower), (VoidFunc1<Integer>)((VoidFunc1 & Serializable)apiDTO::setFansNumberUpper));
                    break;
                }
                case "\u8fbe\u4eba\u5730\u57df": {
                    List strings = JSON.parseArray((String)value, String.class);
                    strings.add(0, "\u4e2d\u56fd");
                    ArrayList<String> location = new ArrayList<String>();
                    location.add(StringUtils.join((Iterable)strings, (String)" "));
                    apiDTO.setLocation(location);
                    break;
                }
                case "\u8fbe\u4eba\u6027\u522b": {
                    if ("\u4e0d\u9650".equals(value)) break;
                    apiDTO.setGender(value);
                    break;
                }
                case "\u4f5c\u54c1\u7c7b\u578b": {
                    apiDTO.setNoteType(Integer.parseInt(value));
                    break;
                }
                case "\u89c6\u9891\u63a8\u5e7f\u62a5\u4ef7": {
                    this.handleMinMaxBigDecimal(value, (VoidFunc1<BigDecimal>)((VoidFunc1 & Serializable)apiDTO::setVideoPriceLower), (VoidFunc1<BigDecimal>)((VoidFunc1 & Serializable)apiDTO::setVideoPriceUpper));
                    break;
                }
                case "\u56fe\u6587\u63a8\u5e7f\u62a5\u4ef7": {
                    this.handleMinMaxBigDecimal(value, (VoidFunc1<BigDecimal>)((VoidFunc1 & Serializable)apiDTO::setNotePriceLower), (VoidFunc1<BigDecimal>)((VoidFunc1 & Serializable)apiDTO::setNotePriceUpper));
                    break;
                }
                case "\u8fd1\u671f\u5408\u4f5c\u884c\u4e1a": {
                    if ("\u4e0d\u9650".equals(value)) break;
                    apiDTO.setTradeType(value);
                    break;
                }
                case "\u7c89\u4e1d\u6027\u522b": {
                    apiDTO.setFansGender(Integer.parseInt(value));
                    break;
                }
                case "\u7c89\u4e1d\u5e74\u9f84": {
                    apiDTO.setFansAge(Integer.parseInt(value));
                    break;
                }
                case "\u8fd130\u65e5\u7c89\u4e1d\u6570\u4e0a\u5347": {
                    apiDTO.setFansNumUp(1);
                    break;
                }
                case "\u65b0\u9510\u8fbe\u4eba": {
                    apiDTO.setNewHighQuality(1);
                    break;
                }
                case "\u5254\u9664\u4f4e\u6d3b\u8dc3\u535a\u4e3b": {
                    apiDTO.setExcludeLowActive(true);
                    break;
                }
                default: {
                    throw new RuntimeException(I18nUtil.translate((String)"", (String)"\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u53c2\u6570\u7c7b\u578b"));
                }
            }
        });
    }

    private void handleMinMaxInteger(String value, VoidFunc1<Integer> minField, VoidFunc1<Integer> maxField) {
        if (StringUtils.isBlank((CharSequence)value)) {
            return;
        }
        String[] split = value.split("-");
        switch (split.length) {
            case 0: {
                return;
            }
            case 2: {
                String max;
                String min = split[0];
                if (min != null && !"".equals(min)) {
                    minField.call((Object)Integer.parseInt(split[0]));
                }
                if ((max = split[1]) != null && !"".equals(max)) {
                    maxField.call((Object)Integer.parseInt(split[1]));
                }
                break;
            }
            case 1: {
                if (value.startsWith("-")) {
                    maxField.call((Object)Integer.parseInt(split[0]));
                    break;
                }
                minField.call((Object)Integer.parseInt(split[0]));
                break;
            }
            default: {
                throw new ELSBootException(I18nUtil.translate((String)"", (String)"{}\u914d\u7f6e\u7684\u6570\u636e\u503c\u6709\u8bef"));
            }
        }
    }

    private void handleMinMaxBigDecimal(String value, VoidFunc1<BigDecimal> minField, VoidFunc1<BigDecimal> maxField) {
        if (StringUtils.isBlank((CharSequence)value)) {
            return;
        }
        String[] split = value.split("-");
        switch (split.length) {
            case 0: {
                return;
            }
            case 2: {
                String max;
                String min = split[0];
                if (min != null && !"".equals(min)) {
                    minField.call((Object)new BigDecimal(split[0]));
                }
                if ((max = split[1]) != null && !"".equals(max)) {
                    maxField.call((Object)new BigDecimal(split[1]));
                }
                break;
            }
            case 1: {
                if (value.startsWith("-")) {
                    maxField.call((Object)new BigDecimal(split[0]));
                    break;
                }
                minField.call((Object)new BigDecimal(split[0]));
                break;
            }
            default: {
                throw new ELSBootException(I18nUtil.translate((String)"", (String)"{}\u914d\u7f6e\u7684\u6570\u636e\u503c\u6709\u8bef"));
            }
        }
    }

    private Map<?, ?> handleBodyLiveTopMan(SimplePostRequestParam<RedBookTopManInformationDTO> topManDto) {
        RedBookLiveTopManApiDTO spiderApiDTO = new RedBookLiveTopManApiDTO(topManDto);
        String keyWord = topManDto.getKeyWord();
        if (StringUtils.isNotBlank((CharSequence)keyWord)) {
            spiderApiDTO.setKeyword(keyWord);
        } else {
            spiderApiDTO.setSortType(1);
        }
        RedBookTopManInformationDTO.ScreenItem screenItem = ((RedBookTopManInformationDTO)topManDto.getFilterInfo()).getScreenItem();
        if (screenItem != null) {
            List<RedBookTopManInformationDTO.ScreenItemField> contentType = screenItem.getContentType();
            if (CollectionUtil.isNotEmpty(contentType)) {
                List collect = contentType.stream().map(RedBookTopManInformationDTO.ScreenItemField::getTitle).distinct().collect(Collectors.toList());
                spiderApiDTO.setFirstTag(StringUtils.join(collect, (String)","));
            }
            List<RedBookTopManInformationDTO.ScreenItemField> talentInfo = screenItem.getTalentInfo();
            this.initScreenItemFieldLiveTopMan(talentInfo, spiderApiDTO, "\u8fbe\u4eba\u4fe1\u606f");
            List<RedBookTopManInformationDTO.ScreenItemField> putInfo = screenItem.getPutInfo();
            this.initScreenItemFieldLiveTopMan(putInfo, spiderApiDTO, "\u6295\u653e\u4fe1\u606f");
        }
        String json = JSON.toJSONString((Object)spiderApiDTO);
        return (Map)JSON.parseObject((String)json, Map.class);
    }

    private void initScreenItemFieldLiveTopMan(List<RedBookTopManInformationDTO.ScreenItemField> screenItemFields, RedBookLiveTopManApiDTO apiDTO, String name) {
        String[] titles;
        if (screenItemFields == null || screenItemFields.size() == 0) {
            return;
        }
        if ("\u8fbe\u4eba\u4fe1\u606f".equals(name)) {
            titles = new String[]{"\u7c89\u4e1d\u603b\u6570", "\u8fbe\u4eba\u5730\u57df"};
            screenItemFields = screenItemFields.stream().filter(h -> Arrays.asList(titles).contains(h.getTitle())).collect(Collectors.toList());
        }
        if ("\u6295\u653e\u4fe1\u606f".equals(name)) {
            titles = new String[]{"\u4e13\u573a\u62a5\u4ef7", "\u62fc\u573a\u62a5\u4ef7"};
            screenItemFields = screenItemFields.stream().filter(h -> Arrays.asList(titles).contains(h.getTitle())).collect(Collectors.toList());
        }
        screenItemFields.forEach(h -> {
            String value = h.getValue();
            switch (h.getTitle()) {
                case "\u7c89\u4e1d\u603b\u6570": {
                    if ("0".equals(value)) break;
                    apiDTO.setFans(Integer.valueOf(value));
                    break;
                }
                case "\u8fbe\u4eba\u5730\u57df": {
                    List strings = JSON.parseArray((String)value, String.class);
                    apiDTO.setCity((String)strings.get(1));
                    break;
                }
                case "\u4e13\u573a\u62a5\u4ef7": {
                    if ("0".equals(value)) break;
                    apiDTO.setSpecialPrice(Integer.valueOf(value));
                    break;
                }
                case "\u62fc\u573a\u62a5\u4ef7": {
                    if ("0".equals(value)) break;
                    apiDTO.setMatchPrice(Integer.valueOf(value));
                    break;
                }
                default: {
                    throw new RuntimeException(I18nUtil.translate((String)"", (String)"\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u53c2\u6570\u7c7b\u578b"));
                }
            }
        });
    }

    private Map<?, ?> handleBodyStarAccount(SimplePostRequestParam<RedBookTopManInformationDTO> topManDto) {
        RedBookTopManInformationDTO.ScreenItem screenItem;
        RedBookStarAccountApiDTO spiderApiDTO = new RedBookStarAccountApiDTO(topManDto);
        String keyWord = topManDto.getKeyWord();
        if (keyWord != null && !"".equals(keyWord)) {
            spiderApiDTO.setKeyword(keyWord);
        }
        if ((screenItem = ((RedBookTopManInformationDTO)topManDto.getFilterInfo()).getScreenItem()) != null) {
            List<RedBookTopManInformationDTO.ScreenItemField> talentInfo = screenItem.getTalentInfo();
            this.handleTagListStarAccount(talentInfo, spiderApiDTO);
        }
        String json = JSON.toJSONString((Object)spiderApiDTO);
        return (Map)JSON.parseObject((String)json, Map.class);
    }

    private void handleTagListStarAccount(List<RedBookTopManInformationDTO.ScreenItemField> screenItemFields, RedBookStarAccountApiDTO apiDTO) {
        if (screenItemFields == null || screenItemFields.size() == 0) {
            return;
        }
        screenItemFields.forEach(h -> {
            String value = h.getValue();
            switch (h.getTitle()) {
                case "\u8fbe\u4eba\u5730\u57df": {
                    List strings = JSON.parseArray((String)h.getValue(), String.class);
                    apiDTO.setLocation((String)strings.get(1));
                    break;
                }
                case "\u7c89\u4e1d\u603b\u6570": {
                    this.handleMinMaxInteger(value, (VoidFunc1<Integer>)((VoidFunc1 & Serializable)apiDTO::setMinFans), (VoidFunc1<Integer>)((VoidFunc1 & Serializable)apiDTO::setMaxFans));
                    break;
                }
                default: {
                    throw new RuntimeException(I18nUtil.translate((String)"", (String)"\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u53c2\u6570\u7c7b\u578b"));
                }
            }
        });
    }

    private QueryWrapper<RedBookTopManInformation> getQueryWrapper(SimplePostRequestParam<RedBookTopManInformationDTO> topManDto) {
        String[] columns;
        String column;
        String string;
        List<RedBookTopManInformationDTO.ScreenItemField> list;
        List<RedBookTopManInformationDTO.ScreenItemField> putInfos;
        RedBookTopManInformationDTO filterInfo = (RedBookTopManInformationDTO)topManDto.getFilterInfo();
        RedBookTopManInformationDTO.ScreenItem screenItem = filterInfo.getScreenItem();
        QueryWrapper query = new QueryWrapper();
        List<RedBookTopManInformationDTO.ScreenItemField> talentInfos = screenItem.getTalentInfo();
        if (CollectionUtil.isNotEmpty(talentInfos)) {
            for (RedBookTopManInformationDTO.ScreenItemField screenItemField : talentInfos) {
                String string2 = screenItemField.getValue();
                switch (screenItemField.getTitle()) {
                    case "\u7c89\u4e1d\u603b\u6570": {
                        this.handleInteger(string2, (QueryWrapper<RedBookTopManInformation>)query, RedBookTopManInformation::getFansNum);
                        break;
                    }
                    case "\u8fbe\u4eba\u5730\u57df": {
                        List strings = JSON.parseArray((String)string2, String.class);
                        query.lambda().like(RedBookTopManInformation::getLocation, strings.get(strings.size() - 1));
                        break;
                    }
                    case "\u8fbe\u4eba\u6027\u522b": {
                        this.handleString(string2, (QueryWrapper<RedBookTopManInformation>)query, RedBookTopManInformation::getGender);
                    }
                }
            }
        }
        if (CollectionUtil.isNotEmpty(putInfos = screenItem.getPutInfo())) {
            block27: for (RedBookTopManInformationDTO.ScreenItemField screenItemField : putInfos) {
                String value = screenItemField.getValue();
                switch (screenItemField.getTitle()) {
                    case "\u89c6\u9891\u63a8\u5e7f\u62a5\u4ef7": {
                        this.handleBigDecimal(value, (QueryWrapper<RedBookTopManInformation>)query, RedBookTopManInformation::getVideoPrice);
                        continue block27;
                    }
                    case "\u56fe\u6587\u63a8\u5e7f\u62a5\u4ef7": {
                        this.handleBigDecimal(value, (QueryWrapper<RedBookTopManInformation>)query, RedBookTopManInformation::getPicturePrice);
                        continue block27;
                    }
                    case "\u8fd1\u671f\u5408\u4f5c\u884c\u4e1a": {
                        this.handleLikeString(value, (QueryWrapper<RedBookTopManInformation>)query, RedBookTopManInformation::getTradeType);
                        continue block27;
                    }
                }
                throw new RuntimeException(I18nUtil.translate((String)"", (String)"\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u53c2\u6570\u7c7b\u578b"));
            }
        }
        if (CollectionUtil.isNotEmpty(list = screenItem.getOther())) {
            block28: for (RedBookTopManInformationDTO.ScreenItemField screenItemField : list) {
                String value = screenItemField.getValue();
                switch (screenItemField.getTitle()) {
                    case "\u8fd130\u65e5\u7c89\u4e1d\u6570\u4e0a\u5347": {
                        query.lambda().gt(RedBookTopManInformation::getFans30GrowthRate, (Object)BigDecimal.ZERO);
                        continue block28;
                    }
                }
                throw new RuntimeException(I18nUtil.translate((String)"", (String)"\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u53c2\u6570\u7c7b\u578b"));
            }
        }
        if ((string = topManDto.getKeyWord()) != null && string.trim().length() > 0) {
            query.and(q -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)q.lambda().like(RedBookTopManInformation::getName, (Object)keyWord)).or(a -> {
                    LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)a.eq(RedBookTopManInformation::getTopmanId, (Object)keyWord);
                });
            });
        }
        if ((column = topManDto.getColumn()) != null && !"default".equals(column) && (columns = column.split(",")).length > 0) {
            final String order = topManDto.getOrder();
            QueryGenerator.doMultiFieldsOrder((QueryWrapper)query, (Map)new HashMap<String, String[]>(2){
                {
                    super(x0);
                    this.put("order", order == null ? new String[columns.length] : order.split(","));
                    this.put("column", columns);
                }
            }, (Object)((Object)new RedBookTopManInformation()));
        }
        return query;
    }

    private String handleContentTypes(SimplePostRequestParam<RedBookTopManInformationDTO> topManDto) {
        List<RedBookTopManInformationDTO.ScreenItemField> list = ((RedBookTopManInformationDTO)topManDto.getFilterInfo()).getScreenItem().getContentType();
        if (list == null || list.size() == 0) {
            return null;
        }
        if (list.size() == 1 && "\u5168\u90e8".equals(list.get(0).getTitle())) {
            return null;
        }
        List collect = list.stream().filter(h -> !"\u5168\u90e8".equals(h.getTitle())).map(RedBookTopManInformationDTO.ScreenItemField::getTitle).collect(Collectors.toList());
        return StringUtils.join(collect, (String)"|");
    }

    private void handleString(String value, QueryWrapper<RedBookTopManInformation> query, SFunction<RedBookTopManInformation, ?> field) {
        if (StringUtils.isBlank((CharSequence)value) || "\u5168\u90e8".equals(value) || "\u4e0d\u9650".equals(value)) {
            return;
        }
        query.lambda().eq(field, (Object)value);
    }

    private void handleLikeString(String value, QueryWrapper<RedBookTopManInformation> query, SFunction<RedBookTopManInformation, ?> field) {
        if (StringUtils.isBlank((CharSequence)value) || "\u5168\u90e8".equals(value) || "\u4e0d\u9650".equals(value)) {
            return;
        }
        query.lambda().like(field, (Object)value);
    }

    private void handleInteger(String value, QueryWrapper<RedBookTopManInformation> query, SFunction<RedBookTopManInformation, ?> field) {
        if (StringUtils.isBlank((CharSequence)value)) {
            return;
        }
        String[] split = value.split("-");
        switch (split.length) {
            case 0: {
                return;
            }
            case 2: {
                query.lambda().between(field, (Object)Integer.parseInt(split[0]), (Object)Integer.parseInt(split[1]));
                break;
            }
            case 1: {
                if (value.startsWith("-")) {
                    query.lambda().le(field, (Object)Integer.parseInt(split[0]));
                    break;
                }
                query.lambda().ge(field, (Object)Integer.parseInt(split[0]));
                break;
            }
            default: {
                throw new ELSBootException(I18nUtil.translate((String)"", (String)"{}\u914d\u7f6e\u7684\u6570\u636e\u503c\u6709\u8bef"));
            }
        }
    }

    private void handleBigDecimal(String value, QueryWrapper<RedBookTopManInformation> query, SFunction<RedBookTopManInformation, ?> field) {
        if (StringUtils.isBlank((CharSequence)value)) {
            return;
        }
        String[] split = value.split("-");
        switch (split.length) {
            case 0: {
                return;
            }
            case 2: {
                query.lambda().between(field, (Object)new BigDecimal(split[0]), (Object)new BigDecimal(split[1]));
                break;
            }
            case 1: {
                if (value.startsWith("-")) {
                    query.lambda().le(field, (Object)new BigDecimal(split[0]));
                    break;
                }
                query.lambda().ge(field, (Object)new BigDecimal(split[0]));
                break;
            }
            default: {
                throw new ELSBootException(I18nUtil.translate((String)"", (String)"{}\u914d\u7f6e\u7684\u6570\u636e\u503c\u6709\u8bef"));
            }
        }
    }

    @Override
    public List<TopManOptionsEntity> getOptions(String type, String clearCache) {
        OptionFactory.OptionHandler<RedBookOptionsTypeGroup, RedBookOptionsType> init = OptionFactory.init(RedBookOptionsTypeGroup.class, RedBookOptionsType.class);
        init.setCollection("tb_xiaohongshu_invite_topman_data_category");
        switch (type) {
            case "noteTopMan": {
                init.when(RedBookOptionsType.contentType, DocHandler.jsonTransferHandle(a -> a.setSubTags(null))).when(RedBookOptionsType.talentInfo, (doc, param) -> this.transferTopManInfo(doc, "noteTopMan")).when(RedBookOptionsType.contentFeature, DocHandler.jsonTransferHandle(this::stringToTag)).when(RedBookOptionsType.putInfo, (doc, param) -> this.transferPutInfo(doc, "noteTopMan")).when(RedBookOptionsType.fansPortrait, (doc, param) -> this.transferFansPortrait(doc, "noteTopMan")).when(RedBookOptionsType.other, (doc, param) -> this.transferOther(doc, "noteTopMan"));
                break;
            }
            case "liveTopMan": {
                init.when(RedBookOptionsType.contentType, DocHandler.jsonTransferHandle(a -> a.setSubTags(null))).when(RedBookOptionsType.talentInfo2, (doc, param) -> this.transferTopManInfo(doc, "liveTopMan")).when(RedBookOptionsType.putInfo, (doc, param) -> this.transferPutInfo(doc, "liveTopMan"));
                break;
            }
            case "starAccount": {
                init.when(RedBookOptionsType.talentInfo2, (doc, param) -> this.transferTopManInfo(doc, "starAccount"));
                break;
            }
            case "collectTopMan": {
                init.when(RedBookOptionsType.contentType, DocHandler.jsonTransferHandle(a -> a.setSubTags(null))).when(RedBookOptionsType.talentInfo, (doc, param) -> this.transferTopManInfo(doc, "collectTopMan")).when(RedBookOptionsType.contentFeature, DocHandler.jsonTransferHandle(this::stringToTag)).when(RedBookOptionsType.putInfo, (doc, param) -> this.transferPutInfo(doc, "collectTopMan")).when(RedBookOptionsType.other, (doc, param) -> this.transferOther(doc, "collectTopMan"));
                break;
            }
            case "allTopMan": {
                init.when(RedBookOptionsType.contentType, DocHandler.jsonTransferHandle(a -> a.setSubTags(null))).when(RedBookOptionsType.talentInfo, (doc, param) -> this.transferTopManInfo(doc, "allTopMan")).when(RedBookOptionsType.contentFeature, DocHandler.jsonTransferHandle(this::stringToTag)).when(RedBookOptionsType.putInfo, (doc, param) -> this.transferPutInfo(doc, "allTopMan")).when(RedBookOptionsType.other, (doc, param) -> this.transferOther(doc, "allTopMan"));
                break;
            }
            case "myTopMan": {
                init.when(RedBookOptionsType.contentType, DocHandler.jsonTransferHandle(a -> a.setSubTags(null))).when(RedBookOptionsType.talentInfo, (doc, param) -> this.transferTopManInfo(doc, "myTopMan")).when(RedBookOptionsType.contentFeature, DocHandler.jsonTransferHandle(this::stringToTag)).when(RedBookOptionsType.putInfo, (doc, param) -> this.transferPutInfo(doc, "myTopMan")).when(RedBookOptionsType.other, (doc, param) -> this.transferOther(doc, "myTopMan"));
                break;
            }
            default: {
                throw new ELSBootException(I18nUtil.translate((String)"", (String)"\u672a\u627e\u5230\u8be5\u8bf7\u6c42\u7c7b\u578b"));
            }
        }
        return init.getResult(type, "1".equals(clearCache));
    }

    private void stringToTag(TopManOptionsEntity.Tag bean) {
        bean.setSubTags(bean.getSubTags().stream().map(t1 -> {
            TopManOptionsEntity.Tag b = new TopManOptionsEntity.Tag();
            b.setStarTagName(String.valueOf(t1));
            b.setStarTagValue(String.valueOf(t1));
            return b;
        }).collect(Collectors.toList()));
    }

    private List<TopManOptionsEntity.Tag> transferTopManInfo(Document doc, String type) {
        String[] starTagNames;
        List docList = doc.getList((Object)"directory_json", Document.class);
        if ("liveTopMan".equals(type) || "starAccount".equals(type)) {
            starTagNames = new String[]{"\u7c89\u4e1d\u603b\u6570", "\u8fbe\u4eba\u5730\u57df"};
            docList = docList.stream().filter(h -> Arrays.asList(starTagNames).contains(h.getString((Object)"starTagName"))).distinct().collect(Collectors.toList());
        }
        if ("collectTopMan".equals(type)) {
            starTagNames = new String[]{"\u4f5c\u54c1\u7c7b\u578b"};
            docList = docList.stream().filter(h -> !Arrays.asList(starTagNames).contains(h.getString((Object)"starTagName"))).distinct().collect(Collectors.toList());
        }
        return docList.stream().map(h -> {
            TopManOptionsEntity.Tag tag = new TopManOptionsEntity.Tag();
            tag.setStarTagId(h.getInteger((Object)"starTagId").toString());
            tag.setStarTagName(h.getString((Object)"starTagName"));
            tag.setStarTagValue(h.getString((Object)"starTagName"));
            tag.setComponentType(h.getString((Object)"componentType"));
            if ("\u8fbe\u4eba\u5730\u57df".equals(tag.getStarTagName())) {
                List subTags = h.getList((Object)"subTags", Document.class);
                tag.setSubTags(subTags.stream().map(this::transferRegion).collect(Collectors.toList()));
            } else if ("liveTopMan".equals(type) && "\u7c89\u4e1d\u603b\u6570".equals(tag.getStarTagName())) {
                List subTags = h.getList((Object)"subTags", Document.class);
                tag.setSubTags(subTags.stream().map(this::transferLiveTopMan).collect(Collectors.toList()));
                tag.setComponentType("RSelect");
            } else {
                tag.setSubTags(h.getList((Object)"subTags", Object.class));
            }
            return tag;
        }).collect(Collectors.toList());
    }

    private TopManOptionsEntity.Tag transferLiveTopMan(Document doc) {
        TopManOptionsEntity.Tag tag = new TopManOptionsEntity.Tag();
        tag.setStarTagId(doc.getString((Object)"starTagId"));
        tag.setStarTagName(doc.getString((Object)"starTagName"));
        tag.setStarTagValue(doc.getString((Object)"starTagId"));
        return tag;
    }

    private TopManOptionsEntity.Tag transferRegion(Document doc) {
        TopManOptionsEntity.Tag tag = new TopManOptionsEntity.Tag();
        tag.setStarTagId(doc.getString((Object)"code"));
        tag.setStarTagName(doc.getString((Object)"name"));
        tag.setStarTagValue(doc.getString((Object)"code"));
        List children = doc.getList((Object)"children", Document.class);
        if (children != null) {
            tag.setLevel(doc.getInteger((Object)"level"));
            tag.setSubTags(children.stream().map(this::transferRegion).collect(Collectors.toList()));
        }
        return tag;
    }

    private List<TopManOptionsEntity.Tag> transferPutInfo(Document doc, String type) {
        List docList = doc.getList((Object)"directory_json", Document.class);
        String[] starTagNames = new String[]{"\u4e13\u573a\u62a5\u4ef7", "\u62fc\u573a\u62a5\u4ef7"};
        docList = "liveTopMan".equals(type) ? docList.stream().filter(h -> Arrays.asList(starTagNames).contains(h.getString((Object)"starTagName"))).distinct().collect(Collectors.toList()) : docList.stream().filter(h -> !Arrays.asList(starTagNames).contains(h.getString((Object)"starTagName"))).distinct().collect(Collectors.toList());
        return docList.stream().map(h -> this.transferSub((Document)h, type)).collect(Collectors.toList());
    }

    private List<TopManOptionsEntity.Tag> transferFansPortrait(Document doc, String type) {
        List docList = doc.getList((Object)"directory_json", Document.class);
        return docList.stream().map(h -> this.transferSub((Document)h, type)).collect(Collectors.toList());
    }

    private List<TopManOptionsEntity.Tag> transferOther(Document doc, String type) {
        List docList = doc.getList((Object)"directory_json", Document.class);
        String[] starTagNames = new String[]{"\u8fd130\u65e5\u7c89\u4e1d\u6570\u4e0a\u5347", "\u65b0\u9510\u8fbe\u4eba", "\u5254\u9664\u4f4e\u6d3b\u8dc3\u535a\u4e3b"};
        String[] starTagNames1 = new String[]{"\u573a\u5747\u9500\u552e\u989d\u533a\u95f4"};
        String[] starTagNames2 = new String[]{"\u8fd130\u65e5\u7c89\u4e1d\u6570\u4e0a\u5347"};
        String[] starTagNames3 = new String[]{"\u573a\u5747\u9500\u552e\u989d\u533a\u95f4", "\u65b0\u9510\u8fbe\u4eba"};
        String[] starTagNames4 = new String[]{"\u573a\u5747\u9500\u552e\u989d\u533a\u95f4", "\u65b0\u9510\u8fbe\u4eba", "\u8d1f\u8d23\u4eba"};
        if ("noteTopMan".equals(type)) {
            docList = docList.stream().filter(h -> Arrays.asList(starTagNames).contains(h.getString((Object)"starTagName"))).distinct().collect(Collectors.toList());
        } else if ("liveTopMan".equals(type)) {
            docList = docList.stream().filter(h -> Arrays.asList(starTagNames1).contains(h.getString((Object)"starTagName"))).distinct().collect(Collectors.toList());
        } else if ("collectTopMan".equals(type)) {
            docList = docList.stream().filter(h -> Arrays.asList(starTagNames2).contains(h.getString((Object)"starTagName"))).distinct().collect(Collectors.toList());
        } else if ("allTopMan".equals(type)) {
            docList = docList.stream().filter(h -> !Arrays.asList(starTagNames3).contains(h.getString((Object)"starTagName"))).distinct().collect(Collectors.toList());
        } else if ("myTopMan".equals(type)) {
            docList = docList.stream().filter(h -> !Arrays.asList(starTagNames4).contains(h.getString((Object)"starTagName"))).distinct().collect(Collectors.toList());
        }
        return docList.stream().map(h -> this.transferSub((Document)h, type)).collect(Collectors.toList());
    }

    private TopManOptionsEntity.Tag transferSub(Document doc, String type) {
        TopManOptionsEntity.Tag tag = new TopManOptionsEntity.Tag();
        tag.setStarTagId(doc.getInteger((Object)"starTagId").toString());
        tag.setStarTagName(doc.getString((Object)"starTagName"));
        tag.setStarTagValue(doc.getString((Object)"starTagName"));
        tag.setComponentType(doc.getString((Object)"componentType"));
        if ("liveTopMan".equals(type)) {
            List subTags = doc.getList((Object)"subTags", Document.class);
            tag.setSubTags(subTags.stream().map(this::transferLiveTopMan).collect(Collectors.toList()));
            tag.setComponentType("RSelect");
        } else if ("allTopMan".equals(type) && "\u8d1f\u8d23\u4eba".equals(tag.getStarTagName())) {
            tag.setSubTags(this.transferAllTopManLeader());
            tag.setComponentType("RSelect");
        } else {
            tag.setSubTags(doc.getList((Object)"subTags", Object.class));
        }
        return tag;
    }

    private List<Object> transferAllTopManLeader() {
        List allByAccount = this.accountRpcService.getAllByAccount(TenantContext.getTenant());
        ArrayList<Object> tags = new ArrayList<Object>(allByAccount.size() + 1);
        TopManOptionsEntity.Tag tag = new TopManOptionsEntity.Tag();
        tag.setStarTagId("");
        tag.setStarTagValue("");
        tag.setStarTagName("\u65e0");
        tags.add(tag);
        allByAccount.forEach(a -> {
            TopManOptionsEntity.Tag tag1 = new TopManOptionsEntity.Tag();
            tag1.setStarTagId(a.getSubAccount());
            tag1.setStarTagValue(a.getSubAccount());
            tag1.setStarTagName(a.getRealname());
            tags.add(tag1);
        });
        return tags;
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void collect(RedBookTopManCollectDTO dto) {
        if (MarkYn.check(dto.getCollect())) {
            this.addMarkToSpider(dto);
        }
        this.collectHandle(dto);
    }

    private void collectHandle(RedBookTopManCollectDTO dto) {
        LoginUser loginUser = SysUtil.getLoginUser();
        String elsAccount = loginUser.getElsAccount();
        String subAccount = loginUser.getSubAccount();
        RedBookTopManInformation entity = dto.getEntity();
        if (MarkYn.check(dto.getCollect())) {
            TopManCollectBean topManCollectBean = new TopManCollectBean();
            topManCollectBean.setTopmanId(entity.getTopmanId());
            topManCollectBean.setPlatform("3");
            topManCollectBean.setElsAccount(elsAccount);
            topManCollectBean.setSubAccount(subAccount);
            this.topManCollectService.save((Object)topManCollectBean);
        } else {
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.lambda().eq(BaseEntity::getElsAccount, (Object)elsAccount);
            queryWrapper.lambda().eq(TopManCollectBean::getSubAccount, (Object)subAccount);
            queryWrapper.lambda().eq(TopManCollectBean::getPlatform, (Object)"3");
            queryWrapper.lambda().eq(TopManCollectBean::getTopmanId, (Object)entity.getTopmanId());
            this.topManCollectService.remove((Wrapper)queryWrapper);
        }
    }

    @Override
    public void addMarkToSpider(RedBookTopManCollectDTO dto) {
        if (RedBookOptionsTypeGroup.liveTopMan.getName().equals(dto.getTaskType())) {
            RedBookTopManDetailDTO detailDTO = new RedBookTopManDetailDTO();
            detailDTO.setUserId(dto.getEntity().getTopmanId());
            detailDTO.setClearCache("1");
            RedBookTopManDetailHeadVO collectDetailHead = this.getCollectDetailHead(detailDTO);
            RedBookTopManDetailHeadVO.DetailHead detailHead = collectDetailHead.getDetailHead();
            RedBookTopManInformation entity = dto.getEntity();
            BeanUtils.copyProperties((Object)detailHead, (Object)((Object)entity));
            entity.setPersonalTags(StringUtils.join(detailHead.getPersonalTags(), (String)","));
            entity.setFeatureTags(StringUtils.join(detailHead.getFeatureTags(), (String)","));
            List<RedBookTopManDetailHeadVO.DetailHead.ContentTags> contentTags = detailHead.getContentTags();
            if (CollectionUtil.isNotEmpty(contentTags)) {
                List collect = contentTags.stream().map(RedBookTopManDetailHeadVO.DetailHead.ContentTags::getTaxonomy1Tag).collect(Collectors.toList());
                entity.setContentType(StringUtils.join(collect, (String)","));
            }
            dto.setEntity(entity);
        }
        this.saveRedBookSpiderTopMan(dto.getEntity());
    }

    private void addMarkToMongo(RedBookTopManCollectDTO dto) {
        RedBookTopManInformation entity = dto.getEntity();
        String topManId = String.valueOf(entity.getTopmanId());
        MongoCollectionType collectMark = MongoCollectionType.TB_REDBOOK_ELS_TOPMAN;
        HashMap<String, String> param = new HashMap<String, String>(1);
        param.put("topManId", topManId);
        Map<String, TopManSpiderMark> data = this.handleMongo(collectMark, param, TopManSpiderMark.class);
        TopManSpiderMark topManSpiderMark = data.get(topManId);
        if (topManSpiderMark == null) {
            topManSpiderMark = new TopManSpiderMark();
            topManSpiderMark.setTopManId(topManId);
            topManSpiderMark.setTaskType(dto.getTaskType());
            topManSpiderMark.setCount(1);
            this.mongoTemplate.insert((Object)topManSpiderMark, collectMark.getCollectName());
        } else {
            Query query = new Query((CriteriaDefinition)Criteria.where((String)"topManId").is((Object)topManId));
            Update update = new Update().set("count", (Object)(topManSpiderMark.getCount() + 1));
            this.mongoTemplate.upsert(query, (UpdateDefinition)update, TopManSpiderMark.class, collectMark.getCollectName());
        }
    }

    private <T extends MongoEntityService> Map<String, T> handleMongo(MongoCollectionType collectionType, HashMap<String, String> param, Class<T> beanClass) {
        Document inquireDoc = new Document();
        for (Map.Entry<String, String> p : param.entrySet()) {
            inquireDoc.append(p.getKey(), (Object)p.getValue());
        }
        try (MongoCursor cursor = this.mongoTemplate.getCollection(collectionType.getCollectName()).find((Bson)inquireDoc).noCursorTimeout(true).cursor();){
            HashMap<String, MongoEntityService> map = new HashMap<String, MongoEntityService>(20);
            while (cursor.hasNext()) {
                Document coreData = (Document)cursor.next();
                String subKey = collectionType.getSubKey();
                if (subKey != null) {
                    List keyData = coreData.getList((Object)subKey, Document.class);
                    for (Document keyDatum : keyData) {
                        String s = keyDatum.toJson();
                        MongoEntityService t = (MongoEntityService)JSON.parseObject((String)s, beanClass);
                        map.put(t.getKeyId(), t);
                    }
                    continue;
                }
                String s = coreData.toJson();
                MongoEntityService t = (MongoEntityService)JSON.parseObject((String)s, beanClass);
                map.put(t.getKeyId(), t);
            }
            HashMap<String, MongoEntityService> hashMap = map;
            return hashMap;
        }
    }

    private void saveRedBookSpiderTopMan(RedBookTopManInformation information) {
        QueryWrapper query = new QueryWrapper();
        query.lambda().eq(RedBookTopManInformation::getTopmanId, (Object)information.getTopmanId());
        RedBookTopManInformation info = (RedBookTopManInformation)((Object)((RedBookTopManInformationMapper)this.baseMapper).selectOne((Wrapper)query));
        if (info == null) {
            information.setSubAccount(SysUtil.getLoginUser().getSubAccount());
            information.setPlatform("3");
            information.setId("");
        } else {
            information.setSubAccount(SysUtil.getLoginUser().getSubAccount());
            information.setId(info.getId());
        }
        this.saveOrUpdate((Object)information);
    }

    private RedBookTopManDetailHeadVO getCollectDetailHead(RedBookTopManDetailDTO dto) {
        RedBookTopManDetailHeadVO result = null;
        String redisKey = "RedBookTopManDetail_" + dto.getUserId();
        if (!"1".equals(dto.getClearCache())) {
            result = (RedBookTopManDetailHeadVO)this.redisUtil.get(redisKey);
        }
        HashMap<String, Object> apiParam = new HashMap<String, Object>(1);
        apiParam.put("userId", dto.getUserId());
        if (result == null) {
            result = new RedBookTopManDetailHeadVO();
            RedBookTopManDetailHeadVO.DetailHead detailHead = this.spiderApiUtil.postForEntity(SpiderMethodType.RED_BOOK_BLOGGER_PROFILE, apiParam, RedBookTopManDetailHeadVO.DetailHead.class);
            result.setDetailHead(detailHead);
            this.redisUtil.set(redisKey, (Object)result, 14400L);
        } else {
            boolean check = this.spiderApiUtil.checkCache(SpiderMethodType.RED_BOOK_BLOGGER_PROFILE, apiParam);
            if (!check) {
                SpiderApiUtil.taskExecutor.execute(() -> {
                    dto.setClearCache("1");
                    this.getDetailHead(dto);
                });
            }
        }
        return result;
    }

    @Override
    public RedBookTopManDetailHeadVO getDetailHead(RedBookTopManDetailDTO dto) {
        RedBookTopManDetailHeadVO result = null;
        String redisKey = "RedBookTopManDetail_" + dto.getUserId();
        if (!"1".equals(dto.getClearCache())) {
            result = (RedBookTopManDetailHeadVO)this.redisUtil.get(redisKey);
        }
        HashMap<String, Object> apiParam = new HashMap<String, Object>(6);
        apiParam.put("userId", dto.getUserId());
        apiParam.put("advertiseSwitch", "1");
        apiParam.put("dateType", "2");
        apiParam.put("noteType", "3");
        apiParam.put("business", "0");
        apiParam.put("distributorId", dto.getUserId());
        if (result == null) {
            result = new RedBookTopManDetailHeadVO();
            RedBookTopManDetailHeadVO.DetailHead detailHead = this.spiderApiUtil.postForEntity(SpiderMethodType.RED_BOOK_BLOGGER_PROFILE, apiParam, RedBookTopManDetailHeadVO.DetailHead.class);
            RedBookTopManDetailHeadVO.CoreData coreData = this.spiderApiUtil.postForEntity(SpiderMethodType.RED_BOOK_BLOGGER_CORE, apiParam, RedBookTopManDetailHeadVO.CoreData.class);
            RedBookTopManDetailHeadVO.NotesData notesData = this.spiderApiUtil.postForEntity(SpiderMethodType.RED_BOOK_BLOGGER_NOTES, apiParam, RedBookTopManDetailHeadVO.NotesData.class);
            RedBookTopManDetailHeadVO.LivesData livesData = this.spiderApiUtil.postForEntity(SpiderMethodType.RED_BOOK_BLOGGER_LIVE, apiParam, RedBookTopManDetailHeadVO.LivesData.class);
            result.setDetailHead(detailHead);
            coreData.setTotalNoteCount(detailHead.getTotalNoteCount());
            coreData.setLikeCollectCountInfo(detailHead.getLikeCollectCountInfo());
            result.setCoreData(coreData);
            notesData.setBusinessNoteCount(detailHead.getBusinessNoteCount());
            result.setNotesData(notesData);
            result.setLivesData(livesData);
            this.redisUtil.set(redisKey, (Object)result, 14400L);
        } else {
            boolean check = this.spiderApiUtil.checkCache(SpiderMethodType.RED_BOOK_BLOGGER_PROFILE, apiParam);
            if (!check) {
                SpiderApiUtil.taskExecutor.execute(() -> {
                    dto.setClearCache("1");
                    this.getDetailHead(dto);
                });
            }
        }
        List<String> topmanIds = Collections.singletonList(dto.getUserId());
        List<RedBookTopManInformation> addedAndCollects = ((RedBookTopManInformationMapper)this.baseMapper).checkAddedAndCollect(topmanIds, SysUtil.getLoginUser(), dto.getPlatform());
        if (addedAndCollects != null && addedAndCollects.size() > 0) {
            RedBookTopManInformation information = addedAndCollects.get(0);
            result.setIsAdded(information.getIsAdded());
            result.setIsCollection(information.getIsCollection());
        }
        return result;
    }

    @Override
    public RedBookTopManDetailHeadVO getDetailAbout(RedBookTopManDetailDTO dto) {
        SpiderMethodType spiderMethodType = SpiderMethodType.RED_BOOK_USER_PROFILE;
        RedBookTopManDetailHeadVO result = null;
        String redisKey = "RedBookTopManDetailAbout_" + dto.getUserId();
        if (!"1".equals(dto.getClearCache())) {
            result = (RedBookTopManDetailHeadVO)this.redisUtil.get(redisKey);
        }
        HashMap<String, Object> apiParam = new HashMap<String, Object>(1);
        apiParam.put("userId", dto.getUserId());
        if (result == null) {
            result = new RedBookTopManDetailHeadVO();
            RedBookTopManDetailHeadVO.BaseData baseData = this.spiderApiUtil.postForEntity(spiderMethodType, apiParam, RedBookTopManDetailHeadVO.BaseData.class);
            if (baseData != null) {
                baseData.setHomeUrl("https://www.xiaohongshu.com/user/profile/" + dto.getUserId());
                result.setBaseData(baseData);
                this.redisUtil.set(redisKey, (Object)result, 14400L);
            }
        } else if (!this.spiderApiUtil.checkCache(spiderMethodType, apiParam)) {
            SpiderApiUtil.taskExecutor.execute(() -> {
                dto.setClearCache("1");
                this.getDetailAbout(dto);
            });
        }
        return result;
    }

    @Override
    public RedBookTopManDetailHeadVO getDetailFansSummary(RedBookTopManDetailDTO dto) {
        SpiderMethodType methodType = SpiderMethodType.RED_BOOK_BLOGGER_FANS_SUMMARY;
        RedBookTopManDetailHeadVO result = null;
        String redisKey = "RedBookTopManDetailFansSummary_" + dto.getUserId();
        if (!"1".equals(dto.getClearCache())) {
            result = (RedBookTopManDetailHeadVO)this.redisUtil.get(redisKey);
        }
        HashMap<String, Object> apiParam = new HashMap<String, Object>(1);
        apiParam.put("userId", dto.getUserId());
        if (result == null) {
            result = new RedBookTopManDetailHeadVO();
            RedBookTopManDetailHeadVO.FansSummary fansSummary = this.spiderApiUtil.postForEntity(methodType, apiParam, RedBookTopManDetailHeadVO.FansSummary.class);
            if (fansSummary != null) {
                result.setFansSummary(fansSummary);
                this.redisUtil.set(redisKey, (Object)result, 14400L);
            }
        } else if (!this.spiderApiUtil.checkCache(methodType, apiParam)) {
            SpiderApiUtil.taskExecutor.execute(() -> {
                dto.setClearCache("1");
                this.getDetailFansSummary(dto);
            });
        }
        return result;
    }

    @Override
    public RedBookTopManDetailHeadVO getDetailFans(RedBookTopManDetailDTO dto) {
        RedBookTopManDetailHeadVO result = null;
        String redisKey = "RedBookTopManDetailFans_" + dto.getUserId() + "_" + dto.getDateType();
        if (!"1".equals(dto.getClearCache())) {
            result = (RedBookTopManDetailHeadVO)this.redisUtil.get(redisKey);
        }
        HashMap<String, Object> apiParam = new HashMap<String, Object>(1);
        apiParam.put("distributorId", dto.getUserId());
        if (result == null) {
            HashMap<String, String> apiParam2 = new HashMap<String, String>(3);
            apiParam2.put("userId", dto.getUserId());
            apiParam2.put("dateType", dto.getDateType());
            apiParam2.put("increaseType", "1");
            HashMap<String, String> apiParam3 = new HashMap<String, String>(3);
            apiParam3.put("userId", dto.getUserId());
            apiParam3.put("dateType", dto.getDateType());
            apiParam3.put("increaseType", "2");
            result = new RedBookTopManDetailHeadVO();
            RedBookTopManDetailHeadVO.FansData fansData = this.spiderApiUtil.postForEntity(SpiderMethodType.RED_BOOK_EC_BLOGGER_FANS, apiParam, RedBookTopManDetailHeadVO.FansData.class);
            RedBookTopManDetailHeadVO.FansOverall fansOverall2 = this.spiderApiUtil.postForEntity(SpiderMethodType.RED_BOOK_BLOGGER_FANS_OVERALL, apiParam2, RedBookTopManDetailHeadVO.FansOverall.class);
            RedBookTopManDetailHeadVO.FansOverall fansOverall3 = this.spiderApiUtil.postForEntity(SpiderMethodType.RED_BOOK_BLOGGER_FANS_OVERALL, apiParam3, RedBookTopManDetailHeadVO.FansOverall.class);
            ArrayList<RedBookTopManDetailHeadVO.FansData.FansNumList> fansNumLists = new ArrayList<RedBookTopManDetailHeadVO.FansData.FansNumList>();
            if (fansOverall2 != null && fansOverall3 != null) {
                List<String> collect = fansOverall2.getList().stream().map(RedBookTopManDetailHeadVO.FansOverall.Overall::getDateKey).distinct().collect(Collectors.toList());
                Map<String, RedBookTopManDetailHeadVO.FansOverall.Overall> map2 = fansOverall2.getList().stream().collect(Collectors.toMap(RedBookTopManDetailHeadVO.FansOverall.Overall::getDateKey, j -> j, (k1, k2) -> k1));
                Map<String, RedBookTopManDetailHeadVO.FansOverall.Overall> map3 = fansOverall3.getList().stream().collect(Collectors.toMap(RedBookTopManDetailHeadVO.FansOverall.Overall::getDateKey, j -> j, (k1, k2) -> k1));
                collect.forEach(h -> {
                    RedBookTopManDetailHeadVO.FansData.FansNumList fansNumList = new RedBookTopManDetailHeadVO.FansData.FansNumList();
                    String[] split = h.split("-");
                    fansNumList.setDate(split[1] + "/" + split[2]);
                    fansNumList.setDetailDate((String)h);
                    fansNumList.setFansNum(map2.get(h) != null ? ((RedBookTopManDetailHeadVO.FansOverall.Overall)map2.get(h)).getNum() : 0);
                    fansNumList.setFansIncreaseNum(map3.get(h) != null ? ((RedBookTopManDetailHeadVO.FansOverall.Overall)map3.get(h)).getNum() : 0);
                    fansNumLists.add(fansNumList);
                });
            }
            fansData.setFansNumList(fansNumLists);
            result.setFansData(fansData);
            this.redisUtil.set(redisKey, (Object)result, 14400L);
        } else if (!this.spiderApiUtil.checkCache(SpiderMethodType.RED_BOOK_EC_BLOGGER_FANS, apiParam)) {
            SpiderApiUtil.taskExecutor.execute(() -> {
                dto.setClearCache("1");
                this.getDetailFans(dto);
            });
        }
        return result;
    }

    @Override
    public RedBookTopManDetailHeadVO getDetailNotesRate(RedBookTopManDetailDTO dto) {
        RedBookTopManDetailHeadVO result = null;
        String redisKey = "RedBookTopManDetailNotesRate_" + dto.getUserId() + "_" + dto.getDateType() + "_" + dto.getNoteType() + "_" + dto.getBusiness();
        if (!"1".equals(dto.getClearCache())) {
            result = (RedBookTopManDetailHeadVO)this.redisUtil.get(redisKey);
        }
        HashMap<String, Object> apiParam = new HashMap<String, Object>(5);
        apiParam.put("userId", dto.getUserId());
        apiParam.put("advertiseSwitch", dto.getAdvertiseSwitch());
        apiParam.put("dateType", dto.getDateType());
        apiParam.put("noteType", dto.getNoteType());
        apiParam.put("business", dto.getBusiness());
        if (result == null) {
            result = new RedBookTopManDetailHeadVO();
            RedBookTopManDetailHeadVO.NotesRate notesRate = this.spiderApiUtil.postForEntity(SpiderMethodType.RED_BOOK_BLOGGER_NOTES_RATE, apiParam, RedBookTopManDetailHeadVO.NotesRate.class);
            result.setNotesRate(notesRate);
            this.redisUtil.set(redisKey, (Object)result, 14400L);
        } else if (!this.spiderApiUtil.checkCache(SpiderMethodType.RED_BOOK_BLOGGER_NOTES_RATE, apiParam)) {
            SpiderApiUtil.taskExecutor.execute(() -> {
                dto.setClearCache("1");
                this.getDetailNotesRate(dto);
            });
        }
        return result;
    }

    @Override
    public RedBookTopManDetailHeadVO getDetailNotesList(RedBookTopManDetailDTO dto) {
        RedBookTopManDetailHeadVO result = null;
        if ("1".equals(dto.getBusiness())) {
            dto.setNoteType("3");
        }
        String redisKey = "RedBookTopManDetailNotesList_" + dto.getUserId() + "_" + dto.getNoteType() + "_" + dto.getOrderType();
        if (!"1".equals(dto.getClearCache())) {
            result = (RedBookTopManDetailHeadVO)this.redisUtil.get(redisKey);
        }
        HashMap<String, Object> apiParam = new HashMap<String, Object>(6);
        apiParam.put("userId", dto.getUserId());
        apiParam.put("advertiseSwitch", dto.getAdvertiseSwitch());
        apiParam.put("noteType", dto.getNoteType());
        apiParam.put("orderType", dto.getOrderType());
        apiParam.put("pageNumber", dto.getPageNumber());
        apiParam.put("pageSize", dto.getPageSize());
        if (result == null) {
            result = new RedBookTopManDetailHeadVO();
            RedBookTopManDetailHeadVO.NotesDetail notesDetail = this.spiderApiUtil.postForEntity(SpiderMethodType.RED_BOOK_BLOGGER_NOTES_DETAIL, apiParam, RedBookTopManDetailHeadVO.NotesDetail.class);
            result.setNotesDetail(notesDetail);
            this.redisUtil.set(redisKey, (Object)result, 14400L);
        } else if (!this.spiderApiUtil.checkCache(SpiderMethodType.RED_BOOK_BLOGGER_NOTES_DETAIL, apiParam)) {
            SpiderApiUtil.taskExecutor.execute(() -> {
                dto.setClearCache("1");
                this.getDetailNotesList(dto);
            });
        }
        return result;
    }

    @Override
    public RedBookTopManDetailHeadVO getDetailPromotion(RedBookTopManDetailDTO dto) {
        RedBookTopManDetailHeadVO result = null;
        String redisKey = "RedBookTopManDetailPromotion_" + dto.getUserId();
        if (!"1".equals(dto.getClearCache())) {
            result = (RedBookTopManDetailHeadVO)this.redisUtil.get(redisKey);
        }
        HashMap<String, Object> apiParam = new HashMap<String, Object>(1);
        apiParam.put("userId", dto.getUserId());
        if (result == null) {
            result = new RedBookTopManDetailHeadVO();
            RedBookTopManDetailHeadVO.Promotion promotion = this.spiderApiUtil.postForEntity(SpiderMethodType.RED_BOOK_BLOGGER_COST_EFFECTIVE, apiParam, RedBookTopManDetailHeadVO.Promotion.class);
            RedBookTopManDetailHeadVO.DetailHead detailHead = this.spiderApiUtil.postForEntity(SpiderMethodType.RED_BOOK_BLOGGER_PROFILE, apiParam, RedBookTopManDetailHeadVO.DetailHead.class);
            if (detailHead != null) {
                promotion.setPicturePrice(detailHead.getPicturePrice());
                promotion.setVideoPrice(detailHead.getVideoPrice());
            }
            result.setPromotion(promotion);
            this.redisUtil.set(redisKey, (Object)result, 14400L);
        } else if (!this.spiderApiUtil.checkCache(SpiderMethodType.RED_BOOK_BLOGGER_COST_EFFECTIVE, apiParam)) {
            SpiderApiUtil.taskExecutor.execute(() -> {
                dto.setClearCache("1");
                this.getDetailPromotion(dto);
            });
        }
        return result;
    }

    @Override
    public RedBookTopManDetailHeadVO getDetailLiveSales(RedBookTopManDetailDTO dto) {
        RedBookTopManDetailHeadVO result = null;
        String redisKey = "RedBookTopManDetailLiveSales_" + dto.getUserId();
        if (!"1".equals(dto.getClearCache())) {
            result = (RedBookTopManDetailHeadVO)this.redisUtil.get(redisKey);
        }
        HashMap<String, Object> apiParam = new HashMap<String, Object>(1);
        apiParam.put("distributorId", dto.getUserId());
        if (result == null) {
            result = new RedBookTopManDetailHeadVO();
            RedBookTopManDetailHeadVO.Lives lives = this.spiderApiUtil.postForEntity(SpiderMethodType.RED_BOOK_EC_BLOGGER_LIVE, apiParam, RedBookTopManDetailHeadVO.Lives.class);
            RedBookTopManDetailHeadVO.LivesPrices livesPrices = this.spiderApiUtil.postForEntity(SpiderMethodType.RED_BOOK_EC_BLOGGER_LIVE_PRICE, apiParam, RedBookTopManDetailHeadVO.LivesPrices.class);
            RedBookTopManDetailHeadVO.Sales sales = this.spiderApiUtil.postForEntity(SpiderMethodType.RED_BOOK_EC_BLOGGER_SALES, apiParam, RedBookTopManDetailHeadVO.Sales.class);
            if (CollectionUtil.isNotEmpty(livesPrices.getProducts())) {
                livesPrices.getProducts().forEach(h -> {
                    if (h.getCategoryId() == 1) {
                        lives.setMatchPrice(h.getPrice());
                    }
                    if (h.getCategoryId() == 2) {
                        lives.setSpecialPrice(h.getPrice());
                    }
                });
            }
            result.setLives(lives);
            result.setSales(sales);
            this.redisUtil.set(redisKey, (Object)result, 14400L);
        } else if (!this.spiderApiUtil.checkCache(SpiderMethodType.RED_BOOK_EC_BLOGGER_LIVE, apiParam)) {
            SpiderApiUtil.taskExecutor.execute(() -> {
                dto.setClearCache("1");
                this.getDetailPromotion(dto);
            });
        }
        return result;
    }
}

