/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.topman.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.els.common.annotation.ApiCallCount;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.system.base.controller.BaseController;
import com.els.modules.industryInfo.api.dto.SimplePostRequestParam;
import com.els.modules.topman.dto.RedBookTopManCollectDTO;
import com.els.modules.topman.dto.RedBookTopManDetailDTO;
import com.els.modules.topman.dto.RedBookTopManInformationDTO;
import com.els.modules.topman.entity.RedBookTopManInformation;
import com.els.modules.topman.service.RedBookTopManInformationService;
import com.els.modules.topman.utils.spider.vo.RedBookTopManDetailHeadVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/rb/topMan"})
@Api(tags={"\u5c0f\u7ea2\u4e66\u8fbe\u4eba\u4fe1\u606f\u5e93"})
public class RedBookTopManController
extends BaseController<RedBookTopManInformation, RedBookTopManInformationService> {
    @Autowired
    private RedBookTopManInformationService redBookTopManInformationService;

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @PostMapping(value={"/list"})
    @ApiCallCount(apiCode="industry_top_main_list_data")
    public Result<?> listAll(@RequestBody SimplePostRequestParam<RedBookTopManInformationDTO> topManDto) {
        IPage<RedBookTopManInformation> pageList = this.redBookTopManInformationService.queryTopManList(topManDto);
        return Result.ok(pageList);
    }

    @ApiOperation(value="\u7b5b\u9009\u9879", notes="\u7b5b\u9009\u9879")
    @GetMapping(value={"/options"})
    public Result<?> getOptions(@RequestParam(name="type", required=false, defaultValue="0") String type, @RequestParam(name="clearCache", required=false, defaultValue="0") String clearCache) {
        return Result.ok(this.redBookTopManInformationService.getOptions(type, clearCache));
    }

    @PostMapping(value={"/collect"})
    @AutoLog(busModule="\u5c0f\u7ea2\u4e66\u8fbe\u4eba\u4fe1\u606f\u5e93", value="\u6536\u85cf\u8fbe\u4eba")
    @ApiOperation(value="\u6536\u85cf\u8fbe\u4eba", notes="\u6536\u85cf\u8fbe\u4eba")
    public Result<?> collect(@RequestBody RedBookTopManCollectDTO dto) {
        this.redBookTopManInformationService.collect(dto);
        return Result.ok();
    }

    @PostMapping(value={"/addMark"})
    @AutoLog(busModule="\u5c0f\u7ea2\u4e66\u8fbe\u4eba\u4fe1\u606f\u5e93", value="\u8fbe\u4eba\u6536\u85cf\u64cd\u4f5c")
    @ApiOperation(value="\u8fbe\u4eba\u6536\u85cf\u64cd\u4f5c", notes="\u8fbe\u4eba\u6536\u85cf\u64cd\u4f5c")
    public Result<?> addMarkToSpider(@RequestBody RedBookTopManCollectDTO dto) {
        this.redBookTopManInformationService.addMarkToSpider(dto);
        return Result.ok();
    }

    @ApiOperation(value="\u8be6\u60c5-\u5934\u90e8\u4fe1\u606f", notes="\u8be6\u60c5-\u5934\u90e8\u4fe1\u606f")
    @PostMapping(value={"/detailHead"})
    @ApiCallCount(apiCode="industry_top_main_detail_data")
    public Result<?> getDetailHead(@RequestBody RedBookTopManDetailDTO dto) {
        RedBookTopManDetailHeadVO vo = this.redBookTopManInformationService.getDetailHead(dto);
        return Result.ok((Object)vo);
    }

    @ApiOperation(value="\u8be6\u60c5-\u8fbe\u4eba\u7b80\u4ecb", notes="\u8be6\u60c5-\u8fbe\u4eba\u7b80\u4ecb")
    @PostMapping(value={"/detailAbout"})
    public Result<?> getDetailAbout(@RequestBody RedBookTopManDetailDTO dto) {
        RedBookTopManDetailHeadVO vo = this.redBookTopManInformationService.getDetailAbout(dto);
        return Result.ok((Object)vo);
    }

    @ApiOperation(value="\u8be6\u60c5-\u7c89\u4e1d\u5206\u6790-\u7c89\u4e1d\u6982\u89c8", notes="\u8be6\u60c5-\u7c89\u4e1d\u5206\u6790-\u7c89\u4e1d\u6982\u89c8")
    @PostMapping(value={"/detailFansSummary"})
    public Result<?> getDetailFansSummary(@RequestBody RedBookTopManDetailDTO dto) {
        RedBookTopManDetailHeadVO vo = this.redBookTopManInformationService.getDetailFansSummary(dto);
        return Result.ok((Object)vo);
    }

    @ApiOperation(value="\u8be6\u60c5-\u7c89\u4e1d\u5206\u6790-\u7c89\u4e1d\u8d8b\u52bf\u3001\u7c89\u4e1d\u5206\u5e03", notes="\u8be6\u60c5-\u7c89\u4e1d\u5206\u6790-\u7c89\u4e1d\u8d8b\u52bf\u3001\u7c89\u4e1d\u5206\u5e03")
    @PostMapping(value={"/detailFans"})
    public Result<?> getDetailFans(@RequestBody RedBookTopManDetailDTO dto) {
        RedBookTopManDetailHeadVO vo = this.redBookTopManInformationService.getDetailFans(dto);
        return Result.ok((Object)vo);
    }

    @ApiOperation(value="\u8be6\u60c5-\u7b14\u8bb0\u5206\u6790\u603b\u89c8", notes="\u8be6\u60c5-\u7b14\u8bb0\u5206\u6790\u603b\u89c8")
    @PostMapping(value={"/detailNotesRate"})
    public Result<?> getDetailNotesRate(@RequestBody RedBookTopManDetailDTO dto) {
        RedBookTopManDetailHeadVO vo = this.redBookTopManInformationService.getDetailNotesRate(dto);
        return Result.ok((Object)vo);
    }

    @ApiOperation(value="\u8be6\u60c5-\u7b14\u8bb0\u5206\u6790\u5217\u8868", notes="\u8be6\u60c5-\u7b14\u8bb0\u5206\u6790\u5217\u8868")
    @PostMapping(value={"/detailNotesList"})
    public Result<?> getDetailNotesList(@RequestBody RedBookTopManDetailDTO dto) {
        RedBookTopManDetailHeadVO vo = this.redBookTopManInformationService.getDetailNotesList(dto);
        return Result.ok((Object)vo);
    }

    @ApiOperation(value="\u8be6\u60c5-\u63a8\u5e7f\u5206\u6790", notes="\u8be6\u60c5-\u63a8\u5e7f\u5206\u6790")
    @PostMapping(value={"/detailPromotion"})
    public Result<?> getDetailPromotion(@RequestBody RedBookTopManDetailDTO dto) {
        RedBookTopManDetailHeadVO vo = this.redBookTopManInformationService.getDetailPromotion(dto);
        return Result.ok((Object)vo);
    }

    @ApiOperation(value="\u8be6\u60c5-\u76f4\u64ad\u5e26\u8d27", notes="\u8be6\u60c5-\u76f4\u64ad\u5e26\u8d27")
    @PostMapping(value={"/detailLiveSales"})
    public Result<?> getDetailLiveSales(@RequestBody RedBookTopManDetailDTO dto) {
        RedBookTopManDetailHeadVO vo = this.redBookTopManInformationService.getDetailLiveSales(dto);
        return Result.ok((Object)vo);
    }
}

