/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.topman.controller;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.query.QueryGenerator;
import com.els.modules.topman.dto.TopManMsgCaptchaDto;
import com.els.modules.topman.dto.TopmanMsgTaskDto;
import com.els.modules.topman.entity.TopManMsgTask;
import com.els.modules.topman.service.TopManMsgTaskService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u8fbe\u4eba\u6d88\u606f\u4efb\u52a1"})
@RestController
@RequestMapping(value={"/msg/topManMsgTask"})
public class TopManMsgTaskController
extends BaseController<TopManMsgTask, TopManMsgTaskService> {
    private static final Logger log = LoggerFactory.getLogger(TopManMsgTaskController.class);
    @Autowired
    private TopManMsgTaskService topManMsgTaskService;

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    public Result<?> queryPageList(TopManMsgTask topManMsgTask, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)topManMsgTask), (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.topManMsgTaskService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @AutoLog(value="\u8fbe\u4eba\u6d88\u606f\u4efb\u52a1-\u6dfb\u52a0")
    @ApiOperation(value="\u6dfb\u52a0", notes="\u6dfb\u52a0")
    @PostMapping(value={"/saveBySubAccount/{type}"})
    public Result<?> saveBySubAccount(@RequestBody TopManMsgTask topManMsgTask, @PathVariable(value="type") String type) {
        this.topManMsgTaskService.saveBySubAccount(topManMsgTask, type);
        return Result.ok((Object)((Object)topManMsgTask));
    }

    @PostMapping(value={"/noToken/captcha"})
    public Result<?> noTokenCaptcha(@RequestBody TopManMsgCaptchaDto rq) {
        log.info("\u63a5\u6536\u5230py\u9a8c\u8bc1\u7801:{}", (Object)JSON.toJSONString((Object)rq));
        this.topManMsgTaskService.processCaptcha(rq);
        return Result.ok();
    }

    @PostMapping(value={"/captcha"})
    public Result<?> captcha(@RequestBody TopManMsgCaptchaDto rq) {
        TopManMsgCaptchaDto eq = this.topManMsgTaskService.getCaptcha(rq);
        return Result.ok((Object)eq);
    }

    @PostMapping(value={"/status"})
    public Result<?> status(@RequestBody TopManMsgCaptchaDto rq) {
        return Result.ok((Object)this.topManMsgTaskService.getOne((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(TopManMsgTask::getPlatform, (Object)rq.getType())).eq(TopManMsgTask::getPlatformAccount, (Object)rq.getUserName())));
    }

    @PostMapping(value={"/enterCaptcha"})
    public Result<?> enterCaptcha(@RequestBody TopManMsgCaptchaDto rq) {
        this.topManMsgTaskService.enterCaptcha(rq);
        return Result.ok();
    }

    @AutoLog(value="\u8fbe\u4eba\u6d88\u606f\u4efb\u52a1-\u7f16\u8f91")
    @ApiOperation(value="\u7f16\u8f91", notes="\u7f16\u8f91")
    @PostMapping(value={"/edit"})
    public Result<?> edit(@RequestBody TopManMsgTask topManMsgTask) {
        this.topManMsgTaskService.edit(topManMsgTask);
        return this.commonSuccessResult(3);
    }

    @GetMapping(value={"/getData"})
    public Result<?> getData(@RequestParam(value="platform") String platform) {
        return Result.ok((Object)((Object)this.topManMsgTaskService.getData(platform)));
    }

    @AutoLog(value="\u8fbe\u4eba\u6d88\u606f\u4efb\u52a1-\u901a\u8fc7id\u5220\u9664")
    @ApiOperation(value="\u901a\u8fc7id\u5220\u9664", notes="\u901a\u8fc7id\u5220\u9664")
    @GetMapping(value={"/delete"})
    public Result<?> delete(@RequestParam(name="id") String id) {
        this.topManMsgTaskService.delete(id);
        return this.commonSuccessResult(4);
    }

    @AutoLog(value="\u8fbe\u4eba\u6d88\u606f\u4efb\u52a1-\u6279\u91cf\u5220\u9664")
    @ApiOperation(value="\u6279\u91cf\u5220\u9664", notes="\u6279\u91cf\u5220\u9664")
    @GetMapping(value={"/deleteBatch"})
    public Result<?> deleteBatch(@RequestParam(name="ids") String ids) {
        List<String> idList = Arrays.asList(ids.split(","));
        this.topManMsgTaskService.deleteBatch(idList);
        return this.commonSuccessResult(4);
    }

    @ApiOperation(value="\u901a\u8fc7id\u67e5\u8be2", notes="\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    public Result<?> queryById(@RequestParam(name="id") String id) {
        TopManMsgTask topManMsgTask = (TopManMsgTask)((Object)this.topManMsgTaskService.getById((Serializable)((Object)id)));
        return Result.ok((Object)((Object)topManMsgTask));
    }

    @ApiOperation(value="\u542f\u52a8", notes="\u542f\u52a8")
    @GetMapping(value={"/startUp"})
    public Result<?> startUp(@RequestParam(name="platform") String platform) {
        return this.topManMsgTaskService.startUp(this.topManMsgTaskService.getOneByPlatform(platform));
    }

    @ApiOperation(value="\u6682\u505c", notes="\u6682\u505c")
    @GetMapping(value={"/stop"})
    public Result<?> stop(@RequestParam(name="platform") String platform) {
        this.topManMsgTaskService.stop(platform);
        return Result.ok();
    }

    @GetMapping(value={"/noToken/stop"})
    public Result<?> noTokenStop(@RequestBody TopManMsgTask topManMsgTask) {
        this.topManMsgTaskService.noTokenStop(topManMsgTask);
        return Result.ok();
    }

    @ApiOperation(value="\u83b7\u53d6\u56de\u590d", notes="\u83b7\u53d6\u56de\u590d")
    @GetMapping(value={"/getReply"})
    public Result<?> getReply(@RequestParam(name="platform") String platform) {
        return Result.ok((String)this.topManMsgTaskService.getReply(platform));
    }

    @PostMapping(value={"/noToken/notice"})
    public Result<?> receiveTaskStatus(@RequestBody TopmanMsgTaskDto topmanMsgTaskDto) {
        log.info("\u63a5\u6536\u5230python\u901a\u77e5:{}", (Object)JSON.toJSONString((Object)topmanMsgTaskDto));
        Assert.isTrue((boolean)ObjectUtil.isNotEmpty((Object)topmanMsgTaskDto), (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isTrue((boolean)StrUtil.isNotBlank((CharSequence)topmanMsgTaskDto.getType()), (String)"type\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isTrue((boolean)StrUtil.isNotBlank((CharSequence)topmanMsgTaskDto.getUserName()), (String)"userName\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isTrue((boolean)StrUtil.isNotBlank((CharSequence)topmanMsgTaskDto.getPlatform()), (String)"platform\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isTrue((boolean)StrUtil.isNotBlank((CharSequence)topmanMsgTaskDto.getOptType()), (String)"optType\u4e0d\u80fd\u4e3a\u7a7a");
        if ("1".equals(topmanMsgTaskDto.getOptType())) {
            Assert.isTrue((boolean)StrUtil.isNotBlank((CharSequence)topmanMsgTaskDto.getNeedCaptcha()), (String)"needCaptcha\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if ("2".equals(topmanMsgTaskDto.getOptType())) {
            Assert.isTrue((boolean)StrUtil.isNotBlank((CharSequence)topmanMsgTaskDto.getSuccess()), (String)"success\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.topManMsgTaskService.receiveTaskStatus(topmanMsgTaskDto);
        return Result.ok();
    }
}

