/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.topman.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.exception.ELSBootException;
import com.els.common.util.I18nUtil;
import com.els.common.util.RedisUtil;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.industryInfo.api.dto.SimplePostRequestParam;
import com.els.modules.industryInfo.api.weboption.TopManOptionsEntity;
import com.els.modules.topman.dto.BiliBiliTopManDetailDTO;
import com.els.modules.topman.entity.BStationTopManEntity;
import com.els.modules.topman.enumerate.BStationOptionsType;
import com.els.modules.topman.enumerate.BStationOptionsTypeGroup;
import com.els.modules.topman.mapper.BStationTopManMapper;
import com.els.modules.topman.service.BStationTopManService;
import com.els.modules.topman.utils.HttpRequestUtils;
import com.els.modules.topman.utils.spider.entity.BStationTopManAlbumListEntity;
import com.els.modules.topman.utils.spider.entity.BStationTopManBasicAnalysisEntity;
import com.els.modules.topman.utils.spider.entity.BStationTopManLatestTenVideoTrendsEntity;
import com.els.modules.topman.utils.spider.entity.BStationTopManLiveAnalysisEntity;
import com.els.modules.topman.utils.spider.entity.BStationTopManPromotionAnalysisEntity;
import com.els.modules.topman.utils.spider.entity.BStationTopManSpecialListEntity;
import com.els.modules.topman.utils.spider.entity.BStationTopManVideoListEntity;
import com.els.modules.topman.utils.spider.entity.BiliBiliTopManDetailsBasicDataEntity;
import com.els.modules.topman.utils.spider.entity.BiliBiliTopManDetailsFanTrendEntity;
import com.els.modules.topman.utils.spider.entity.BiliBiliTopManDetailsGwUpstatEntity;
import com.els.modules.topman.utils.spider.entity.BiliBiliTopManDetailsHeadLiveEntity;
import com.els.modules.topman.utils.spider.entity.BiliBiliTopManDetailsHeadVidioEntity;
import com.els.modules.topman.utils.spider.properties.SpiderBaseProperties;
import com.els.modules.topman.utils.spider.properties.SpiderMethodType;
import com.els.modules.topman.utils.spider.spiderApi.SpiderApiUtil;
import com.els.modules.topman.vo.BStationManInformationVO;
import com.els.modules.topman.vo.BStationRequestParamVO;
import com.els.modules.topman.vo.BStationTopManFanAnalysisVO;
import com.els.modules.topman.vo.BStationTopManTopDetailsVO;
import com.els.modules.topman.vo.BStationTopManWorkAnalysisVO;
import com.els.modules.topman.weboption.OptionFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.bson.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BStationTopManServiceImpl
implements BStationTopManService {
    private static final Logger log = LoggerFactory.getLogger(BStationTopManServiceImpl.class);
    private static final String TALENT_DETAILS = "bstation:talent:details:cache";
    private static final String COLON = ":";
    private static final String BS = "bs";
    @Autowired
    private SpiderBaseProperties spiderBaseProperties;
    @Autowired
    private BStationTopManMapper baseMapper;
    @Autowired
    private SpiderApiUtil spiderApiUtil;
    @Autowired
    private RedisUtil redisUtil;

    @Override
    public List<TopManOptionsEntity> getOptions(String type, String clearCache) {
        OptionFactory.OptionHandler<BStationOptionsTypeGroup, BStationOptionsType> init = OptionFactory.init(BStationOptionsTypeGroup.class, BStationOptionsType.class);
        init.setCollection("tb_huahuo_category");
        switch (type) {
            case "videoTopMan": {
                init.when(BStationOptionsType.commercialOrderType, (doc, param) -> this.transferTopManCommercial(doc, "videoTopMan")).when(BStationOptionsType.talentInfo, (doc, param) -> this.transferFansPortrait(doc, "videoTopMan")).when(BStationOptionsType.fansPortrait, (doc, param) -> this.transferFansPortrait(doc, "videoTopMan")).when(BStationOptionsType.putInfo, (doc, param) -> this.transferFansPortrait(doc, "videoTopMan")).when(BStationOptionsType.otherFilter, (doc, param) -> this.transferFansPortrait(doc, "videoTopMan"));
                break;
            }
            case "liveTopMan": {
                init.when(BStationOptionsType.liveType, (doc, param) -> this.transferLiveTopMan(doc, "liveTopMan")).when(BStationOptionsType.talentInfo, (doc, param) -> this.transferFansPortrait(doc, "liveTopMan")).when(BStationOptionsType.fansPortrait, (doc, param) -> this.transferFansPortrait(doc, "liveTopMan"));
                break;
            }
            case "collectTopMan": {
                init.when(BStationOptionsType.commercialOrderType, (doc, param) -> this.transferTopManCommercial(doc, "collectTopMan")).when(BStationOptionsType.liveType, (doc, param) -> this.transferLiveTopMan(doc, "collectTopMan")).when(BStationOptionsType.talentInfo, (doc, param) -> this.transferFansPortrait(doc, "collectTopMan")).when(BStationOptionsType.putInfo, (doc, param) -> this.transferFansPortrait(doc, "collectTopMan")).when(BStationOptionsType.otherFilter, (doc, param) -> this.transferFansPortrait(doc, "collectTopMan"));
                break;
            }
            default: {
                throw new ELSBootException(I18nUtil.translate((String)"", (String)"\u672a\u627e\u5230\u8be5\u8bf7\u6c42\u7c7b\u578b"));
            }
        }
        return init.getResult(type, "1".equals(clearCache));
    }

    @Override
    public IPage<BStationTopManEntity> queryTopManList(SimplePostRequestParam<BStationManInformationVO> topManDto) throws Exception {
        Page page;
        BStationManInformationVO filterInfo = (BStationManInformationVO)topManDto.getFilterInfo();
        String taskType = filterInfo.getTaskType();
        BStationTopManEntity bStationTopManInformation = new BStationTopManEntity();
        QueryWrapper queryWrapper = new QueryWrapper();
        StringBuilder redisKey = new StringBuilder(BS).append(COLON).append(TenantContext.getTenant()).append(COLON).append("list").append(COLON);
        String param = BStationTopManServiceImpl.apiGetList(taskType, topManDto, bStationTopManInformation, (QueryWrapper<BStationTopManEntity>)queryWrapper, redisKey);
        redisKey.append(taskType).append(COLON).append(topManDto.getPageNo()).append(COLON).append(topManDto.getPageSize());
        switch (taskType) {
            case "videoTopMan": {
                page = (Page)this.redisUtil.get(redisKey.toString());
                if (page != null) break;
                page = new Page((long)topManDto.getPageNo().intValue(), (long)topManDto.getPageSize().intValue());
                String urlVideo = this.spiderBaseProperties.getTopManUrl() + "/bilibili/content/cooperation/api/list";
                JSONObject jsonObjectVideo = HttpRequestUtils.doPost(urlVideo, param);
                if (jsonObjectVideo == null || jsonObjectVideo.size() == 0) {
                    return page;
                }
                JSONArray dataVideo = jsonObjectVideo.getJSONArray("data");
                List bStationManInformationVOVideo = dataVideo.toJavaList(BStationTopManEntity.class);
                page.setTotal((long)jsonObjectVideo.getInteger("total_count").intValue());
                this.handleResult(bStationManInformationVOVideo, filterInfo.getPlatformType());
                page.setRecords(bStationManInformationVOVideo);
                if (!CollectionUtils.isNotEmpty((Collection)bStationManInformationVOVideo)) break;
                this.redisUtil.set(redisKey.toString(), (Object)page, 9000L);
                break;
            }
            case "liveTopMan": {
                page = (IPage)this.redisUtil.get(redisKey.toString());
                if (page != null) break;
                page = new Page((long)topManDto.getPageNo().intValue(), (long)topManDto.getPageSize().intValue());
                String urlLive = this.spiderBaseProperties.getTopManUrl() + "/bilibili/live/cooperation/api/telent_live_data/list";
                JSONObject jsonObjectLive = HttpRequestUtils.doPost(urlLive, param);
                if (jsonObjectLive == null || jsonObjectLive.size() == 0) {
                    return page;
                }
                JSONArray dataLive = jsonObjectLive.getJSONArray("data");
                List bStationManInformationVOLive = dataLive.toJavaList(BStationTopManEntity.class);
                page.setTotal((long)jsonObjectLive.getInteger("total_count").intValue());
                this.handleResult(bStationManInformationVOLive, filterInfo.getPlatformType());
                page.setRecords(bStationManInformationVOLive);
                if (!CollectionUtils.isNotEmpty((Collection)bStationManInformationVOLive)) break;
                this.redisUtil.set(redisKey.toString(), (Object)page, 9000L);
                break;
            }
            case "collectTopMan": {
                page = new Page((long)topManDto.getPageNo().intValue(), (long)topManDto.getPageSize().intValue());
                page = this.baseMapper.selectCollectTopMan((IPage<BStationTopManEntity>)page, (Wrapper<BStationTopManEntity>)queryWrapper, SysUtil.getLoginUser(), bStationTopManInformation);
                break;
            }
            default: {
                throw new ELSBootException("\u8be5\u8bf7\u6c42\u4e0d\u5408\u6cd5");
            }
        }
        return page;
    }

    @Override
    public BStationTopManTopDetailsVO bStationTopManDetails(String bStationId, String topmanId) {
        StringBuilder redisKey = new StringBuilder(BS).append(COLON).append(TenantContext.getTenant()).append(COLON).append("list").append(COLON).append(TALENT_DETAILS).append(COLON).append(bStationId);
        BStationTopManTopDetailsVO bStationTopManInformationDetails = (BStationTopManTopDetailsVO)this.redisUtil.get(redisKey.toString());
        if (bStationTopManInformationDetails == null) {
            log.info("\u65e0\u8fbe\u4eba\u5934\u90e8\u8be6\u60c5\u7f13\u5b58\u7684\u65f6\u5019\u8c03\u7528\u8fd9\u91cc\uff01");
            HashMap<String, String> param = new HashMap<String, String>(2);
            param.put("upper_mid", bStationId);
            param.put("mcn_id", topmanId);
            String string = JSON.toJSONString(param);
            String urlDetails = this.spiderBaseProperties.getTopManUrl() + "/bilibili/content/cooperation/api/video/analysis/details";
            JSONObject jsonObject = HttpRequestUtils.doPost(urlDetails, string);
            if (jsonObject == null || jsonObject.size() == 0) {
                return new BStationTopManTopDetailsVO();
            }
            JSONArray data = jsonObject.getJSONArray("data");
            List topManInfos = data.toJavaList(BStationTopManTopDetailsVO.TopManInfo.class);
            List topManVideoData = data.toJavaList(BStationTopManTopDetailsVO.TopManVideoData.class);
            List topManLiveData = data.toJavaList(BStationTopManTopDetailsVO.TopManLiveData.class);
            List topManCoreData = data.toJavaList(BStationTopManTopDetailsVO.TopManCoreData.class);
            bStationTopManInformationDetails = new BStationTopManTopDetailsVO();
            bStationTopManInformationDetails.setTopManInfo((BStationTopManTopDetailsVO.TopManInfo)topManInfos.get(0));
            bStationTopManInformationDetails.setTopManCoreData((BStationTopManTopDetailsVO.TopManCoreData)topManCoreData.get(0));
            bStationTopManInformationDetails.setTopManLiveData((BStationTopManTopDetailsVO.TopManLiveData)topManLiveData.get(0));
            bStationTopManInformationDetails.setTopManVideoData((BStationTopManTopDetailsVO.TopManVideoData)topManVideoData.get(0));
            List<String> ids = Collections.singletonList(((BStationTopManTopDetailsVO.TopManInfo)topManInfos.get(0)).getBStationId());
            List<BStationTopManEntity> bStationTopManInformationEntities = this.baseMapper.checkAddedAndCollect(ids, SysUtil.getLoginUser(), "4");
            if (CollectionUtils.isNotEmpty(bStationTopManInformationEntities)) {
                bStationTopManInformationDetails.setIsAdded(bStationTopManInformationEntities.get(0).getIsAdded());
                bStationTopManInformationDetails.setIsCollection(bStationTopManInformationEntities.get(0).getIsCollection());
            }
            this.redisUtil.set(redisKey.toString(), (Object)bStationTopManInformationDetails, 14400L);
        }
        return bStationTopManInformationDetails;
    }

    @Override
    public BStationTopManTopDetailsVO topManDetails(BiliBiliTopManDetailDTO dto) {
        SpiderMethodType methodType = SpiderMethodType.BILI_BILI_PROFILE_DETAILS;
        BStationTopManTopDetailsVO result = null;
        String redisKey = "BiliBiliTopManDetail_" + dto.getStationId() + "_" + dto.getTopmanId();
        if (!"1".equals(dto.getClearCache())) {
            result = (BStationTopManTopDetailsVO)this.redisUtil.get(redisKey);
        }
        HashMap<String, Object> apiParam = new HashMap<String, Object>(2);
        apiParam.put("upper_mid", dto.getStationId());
        apiParam.put("mcn_id", dto.getTopmanId());
        if (result == null) {
            result = new BStationTopManTopDetailsVO();
            BiliBiliTopManDetailsHeadVidioEntity entity = this.spiderApiUtil.postForEntity(methodType, apiParam, BiliBiliTopManDetailsHeadVidioEntity.class);
            BiliBiliTopManDetailsGwUpstatEntity upstatEntity = null;
            try {
                HashMap<String, String> apiParam2 = new HashMap<String, String>(1);
                apiParam2.put("mid", dto.getStationId());
                upstatEntity = this.spiderApiUtil.postForEntity(SpiderMethodType.BILI_BILI_GW_UPSTAT, apiParam2, BiliBiliTopManDetailsGwUpstatEntity.class);
            }
            catch (Exception apiParam2) {
                // empty catch block
            }
            if (entity != null) {
                this.topManDetailsConverter(entity, upstatEntity, result);
            }
        } else if (!this.spiderApiUtil.checkCache(methodType, apiParam)) {
            SpiderApiUtil.taskExecutor.execute(() -> {
                dto.setClearCache("1");
                this.topManDetails(dto);
            });
        }
        BStationTopManTopDetailsVO.TopManInfo topManInfo = result.getTopManInfo();
        if (topManInfo == null) {
            return result;
        }
        List<String> ids = Collections.singletonList(topManInfo.getBStationId());
        List<BStationTopManEntity> bStationTopManInformationEntities = this.baseMapper.checkAddedAndCollect(ids, SysUtil.getLoginUser(), "4");
        if (CollectionUtils.isNotEmpty(bStationTopManInformationEntities)) {
            result.setIsAdded(bStationTopManInformationEntities.get(0).getIsAdded());
            result.setIsCollection(bStationTopManInformationEntities.get(0).getIsCollection());
        }
        return result;
    }

    private void topManDetailsConverter(BiliBiliTopManDetailsHeadVidioEntity entity, BiliBiliTopManDetailsGwUpstatEntity upstatEntity, BStationTopManTopDetailsVO result) {
        BStationTopManTopDetailsVO.TopManInfo topManInfo = new BStationTopManTopDetailsVO.TopManInfo();
        topManInfo.setTopmanAvatar(entity.getHeadImg());
        topManInfo.setTopmanName(entity.getNickname());
        topManInfo.setBStationId(entity.getUpperMid().toString());
        topManInfo.setTopmanId(entity.getMcnId().toString());
        topManInfo.setFanTotal(entity.getFansNum());
        topManInfo.setTopmanLevel(entity.getMagneticLevel().toString());
        topManInfo.setTopmanRegion(entity.getRegionDesc());
        topManInfo.setSex(entity.getGenderDesc());
        topManInfo.setMcnCompanyName(entity.getMcnCompanyName());
        topManInfo.setCategoryNames(CollectionUtil.isNotEmpty(entity.getCategoryNames()) ? StrUtil.join((CharSequence)"\u3001", entity.getCategoryNames()) : "");
        topManInfo.setOccupationTag(CollectionUtil.isNotEmpty(entity.getOccupationTag()) ? StrUtil.join((CharSequence)"\u3001", entity.getOccupationTag()) : "");
        topManInfo.setCharacterTag(CollectionUtil.isNotEmpty(entity.getCharacterTag()) ? StrUtil.join((CharSequence)"\u3001", entity.getCharacterTag()) : "");
        topManInfo.setSignature(entity.getSignature());
        topManInfo.setHomeUrl(StrUtil.format((CharSequence)"https://huahuo.bilibili.com/#/upper/page/{}?cn_id={}", (Object[])new Object[]{entity.getUpperMid(), entity.getMcnId()}));
        BStationTopManTopDetailsVO.TopManCoreData topManCoreData = new BStationTopManTopDetailsVO.TopManCoreData();
        topManCoreData.setVideoNum(entity.getVideoNum());
        topManCoreData.setLikeNum(entity.getFansLikeNum());
        if (upstatEntity != null) {
            topManCoreData.setPlayNum(upstatEntity.getArchive() != null ? upstatEntity.getArchive().getView() : 0);
            topManCoreData.setReadNum(upstatEntity.getArticle() != null ? upstatEntity.getArticle().getView() : 0);
        }
        BStationTopManTopDetailsVO.TopManVideoData topManVideoData = new BStationTopManTopDetailsVO.TopManVideoData();
        topManVideoData.setAvgPlay(entity.getAveragePlayCnt());
        topManVideoData.setAvgLike(entity.getAverageLikeCnt());
        topManVideoData.setAvgComments(entity.getAverageCommentCnt());
        topManVideoData.setAvgInteractionRate(entity.getAverageInteractiveRate());
        topManVideoData.setAvgProjectiles(entity.getAverageBarrageCnt());
        topManVideoData.setAvgCollections(entity.getAverageCollectCnt());
        result.setTopManInfo(topManInfo);
        result.setTopManCoreData(topManCoreData);
        result.setTopManVideoData(topManVideoData);
    }

    @Override
    public BStationTopManTopDetailsVO topManDetailsLiveInfo(BiliBiliTopManDetailDTO dto) {
        SpiderMethodType methodType = SpiderMethodType.BILI_BILI_LIVE_PROFILE_DETAILS;
        BStationTopManTopDetailsVO result = null;
        String redisKey = "BiliBiliTopManDetailLiveInfo_" + dto.getStationId() + "_" + dto.getTopmanId();
        if (!"1".equals(dto.getClearCache())) {
            result = (BStationTopManTopDetailsVO)this.redisUtil.get(redisKey);
        }
        HashMap<String, Object> apiParam = new HashMap<String, Object>(2);
        apiParam.put("upper_mid", dto.getStationId());
        apiParam.put("mcn_id", dto.getTopmanId());
        if (result == null) {
            result = new BStationTopManTopDetailsVO();
            BiliBiliTopManDetailsHeadLiveEntity entity = null;
            try {
                entity = this.spiderApiUtil.postForEntity(methodType, apiParam, BiliBiliTopManDetailsHeadLiveEntity.class);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (entity != null) {
                this.topManDetailsLiveConverter(entity, result);
            }
        } else if (!this.spiderApiUtil.checkCache(methodType, apiParam)) {
            SpiderApiUtil.taskExecutor.execute(() -> {
                dto.setClearCache("1");
                this.topManDetails(dto);
            });
        }
        return result;
    }

    private void topManDetailsLiveConverter(BiliBiliTopManDetailsHeadLiveEntity entity, BStationTopManTopDetailsVO result) {
        BStationTopManTopDetailsVO.TopManLiveData topManLiveData = new BStationTopManTopDetailsVO.TopManLiveData();
        topManLiveData.setTopmanLiveLevel(entity.getLevel());
        topManLiveData.setLivePopularityPeak(entity.getMaxOnline());
        topManLiveData.setLargeNum(entity.getGuardNum());
        topManLiveData.setFanMedal(entity.getFansMetal());
        topManLiveData.setAuthentication(entity.getOfficial() != null ? entity.getOfficial().getTitle() : "");
        result.setTopManLiveData(topManLiveData);
    }

    @Override
    public BiliBiliTopManDetailsBasicDataEntity topManBasicData(BiliBiliTopManDetailDTO dto) {
        SpiderMethodType methodType = SpiderMethodType.BILI_BILI_ARCHIVE_HIGHLIGHTS;
        BiliBiliTopManDetailsBasicDataEntity result = null;
        String redisKey = "BiliBiliTopManDetailBasicData_" + dto.getStationId() + "_" + dto.getDayRange();
        if (!"1".equals(dto.getClearCache())) {
            result = (BiliBiliTopManDetailsBasicDataEntity)this.redisUtil.get(redisKey);
        }
        HashMap<String, Object> apiParam = new HashMap<String, Object>(2);
        apiParam.put("upper_mid", dto.getStationId());
        apiParam.put("day_range", dto.getDayRange());
        if (result == null) {
            result = this.spiderApiUtil.postForEntity(methodType, apiParam, BiliBiliTopManDetailsBasicDataEntity.class);
        } else if (!this.spiderApiUtil.checkCache(methodType, apiParam)) {
            SpiderApiUtil.taskExecutor.execute(() -> {
                dto.setClearCache("1");
                this.topManBasicData(dto);
            });
        }
        return result;
    }

    @Override
    public IPage<BStationTopManBasicAnalysisEntity> bStationTopManFanBasicAnalysisList(String bStationId, String fanCode, int pageNO) {
        StringBuilder redisKey = new StringBuilder(BS).append(COLON).append(TenantContext.getTenant()).append(COLON).append("fan").append(COLON).append(bStationId).append(COLON).append(fanCode).append(COLON).append(pageNO);
        IPage page = (IPage)this.redisUtil.get(redisKey.toString());
        if (page == null) {
            HashMap<String, Object> param = new HashMap<String, Object>();
            param.put("upper_mid", bStationId);
            if (StringUtils.isNotEmpty((CharSequence)fanCode)) {
                param.put("fans_range", fanCode);
            }
            param.put("page", pageNO);
            String string = JSON.toJSONString(param);
            String urlDetails = this.spiderBaseProperties.getTopManUrl() + "/bilibili/content/cooperation/api/similar/fan/telent/list";
            JSONObject jsonObject = HttpRequestUtils.doPost(urlDetails, string);
            if (jsonObject == null || jsonObject.size() == 0) {
                return new Page();
            }
            JSONArray dataVideo = jsonObject.getJSONArray("data");
            List bStationTopManInformationBasicAnalysisEntities = dataVideo.toJavaList(BStationTopManBasicAnalysisEntity.class);
            Integer current = jsonObject.getInteger("page");
            Integer total = jsonObject.getInteger("total");
            page = new Page((long)current.intValue(), 9L, (long)total.intValue());
            page.setRecords(bStationTopManInformationBasicAnalysisEntities);
            if (CollectionUtils.isNotEmpty((Collection)bStationTopManInformationBasicAnalysisEntities)) {
                this.redisUtil.set(redisKey.toString(), (Object)page, 9000L);
            }
        }
        return page;
    }

    @Override
    public List<BStationTopManBasicAnalysisEntity.Screen> bStationTopManFanBasicAnalysisCategory() {
        StringBuilder redisKey = new StringBuilder(BS).append(COLON).append(TenantContext.getTenant()).append(COLON).append("category").append(COLON).append("screen");
        List bStationTopManInformationBasicAnalysisEntities = (List)this.redisUtil.get(redisKey.toString());
        if (bStationTopManInformationBasicAnalysisEntities == null) {
            HashMap param = new HashMap();
            String string = JSON.toJSONString(param);
            String urlDetails = this.spiderBaseProperties.getTopManUrl() + "/bilibili/content/cooperation/api/similar/fan/telent/category";
            JSONObject jsonObject = HttpRequestUtils.doPost(urlDetails, string);
            if (jsonObject == null || jsonObject.size() == 0) {
                return new ArrayList<BStationTopManBasicAnalysisEntity.Screen>();
            }
            JSONArray dataVideo = jsonObject.getJSONArray("data");
            bStationTopManInformationBasicAnalysisEntities = dataVideo.toJavaList(BStationTopManBasicAnalysisEntity.Screen.class);
            if (CollectionUtils.isNotEmpty((Collection)bStationTopManInformationBasicAnalysisEntities)) {
                this.redisUtil.set(redisKey.toString(), (Object)bStationTopManInformationBasicAnalysisEntities, 9000L);
            }
        }
        return bStationTopManInformationBasicAnalysisEntities;
    }

    @Override
    public List<BStationTopManBasicAnalysisEntity> bStationTopManContentBasicAnalysisList(String bStationId) {
        StringBuilder redisKey = new StringBuilder(BS).append(COLON).append(TenantContext.getTenant()).append(COLON).append("Similarfansoverlap").append(COLON).append(bStationId);
        List bStationTopManInformationBasicAnalysisEntities = (List)this.redisUtil.get(redisKey.toString());
        if (bStationTopManInformationBasicAnalysisEntities == null) {
            HashMap<String, String> param = new HashMap<String, String>();
            param.put("upper_mid", bStationId);
            String string = JSON.toJSONString(param);
            String urlDetails = this.spiderBaseProperties.getTopManUrl() + "/bilibili/content/cooperation/api/similar/content/telent/list";
            JSONObject jsonObject = HttpRequestUtils.doPost(urlDetails, string);
            if (jsonObject == null || jsonObject.size() == 0) {
                return new ArrayList<BStationTopManBasicAnalysisEntity>();
            }
            JSONArray dataVideo = jsonObject.getJSONArray("data");
            bStationTopManInformationBasicAnalysisEntities = dataVideo.toJavaList(BStationTopManBasicAnalysisEntity.class);
            if (CollectionUtils.isNotEmpty((Collection)bStationTopManInformationBasicAnalysisEntities)) {
                this.redisUtil.set(redisKey.toString(), (Object)bStationTopManInformationBasicAnalysisEntities, 9000L);
            }
        }
        return bStationTopManInformationBasicAnalysisEntities;
    }

    @Override
    public BStationTopManFanAnalysisVO topManFanAnalysisFanTrend(BiliBiliTopManDetailDTO dto) {
        SpiderMethodType methodType = SpiderMethodType.BILI_BILI_FANS_TREND;
        BStationTopManFanAnalysisVO result = null;
        String redisKey = "BiliBiliTopManFanAnalysisFanTrend_" + dto.getStationId();
        if (!"1".equals(dto.getClearCache())) {
            result = (BStationTopManFanAnalysisVO)this.redisUtil.get(redisKey);
        }
        HashMap<String, Object> apiParam = new HashMap<String, Object>(2);
        apiParam.put("upper_mid", dto.getStationId());
        apiParam.put("query_type", 1);
        HashMap<String, Object> apiParam2 = new HashMap<String, Object>(2);
        apiParam2.put("upper_mid", dto.getStationId());
        apiParam2.put("query_type", 2);
        if (result == null) {
            result = new BStationTopManFanAnalysisVO();
            BiliBiliTopManDetailsFanTrendEntity entity = this.spiderApiUtil.postForEntity(methodType, apiParam, BiliBiliTopManDetailsFanTrendEntity.class);
            BiliBiliTopManDetailsFanTrendEntity entity2 = this.spiderApiUtil.postForEntity(methodType, apiParam2, BiliBiliTopManDetailsFanTrendEntity.class);
            if (entity != null && entity2 != null) {
                this.topManFanAnalysisFanTrendConverter(entity, entity2, result);
            }
        } else if (!this.spiderApiUtil.checkCache(methodType, apiParam)) {
            SpiderApiUtil.taskExecutor.execute(() -> {
                dto.setClearCache("1");
                this.topManFanAnalysisFanTrend(dto);
            });
        }
        return result;
    }

    private void topManFanAnalysisFanTrendConverter(BiliBiliTopManDetailsFanTrendEntity entity, BiliBiliTopManDetailsFanTrendEntity entity2, BStationTopManFanAnalysisVO result) {
        List<BiliBiliTopManDetailsFanTrendEntity.DataStatistics> fanIncrementTrends;
        List<BiliBiliTopManDetailsFanTrendEntity.DataStatistics> fanTotalTrends = entity.getDataStatisticsByDayVos();
        if (CollectionUtil.isNotEmpty(fanTotalTrends)) {
            ArrayList<BStationTopManFanAnalysisVO.FanTrend> tags = new ArrayList<BStationTopManFanAnalysisVO.FanTrend>(fanTotalTrends.size());
            fanTotalTrends.forEach(h -> {
                BStationTopManFanAnalysisVO.FanTrend tag = new BStationTopManFanAnalysisVO.FanTrend();
                tag.setCount(h.getCount());
                tag.setDate(h.getDate());
                tags.add(tag);
            });
            result.setFanTotalTrends(tags);
        }
        if (CollectionUtil.isNotEmpty(fanIncrementTrends = entity2.getDataStatisticsByDayVos())) {
            ArrayList<BStationTopManFanAnalysisVO.FanTrend> tags = new ArrayList<BStationTopManFanAnalysisVO.FanTrend>(fanIncrementTrends.size());
            fanIncrementTrends.forEach(h -> {
                BStationTopManFanAnalysisVO.FanTrend tag = new BStationTopManFanAnalysisVO.FanTrend();
                tag.setCount(h.getCount());
                tag.setDate(h.getDate());
                tags.add(tag);
            });
            result.setFanIncrementTrends(tags);
        }
    }

    @Override
    public BStationTopManFanAnalysisVO topManFanAnalysisFanDetails(BiliBiliTopManDetailDTO dto) {
        SpiderMethodType methodType = SpiderMethodType.BILI_BILI_PROFILE_DETAILS;
        BStationTopManFanAnalysisVO result = null;
        String redisKey = "BiliBiliTopManFanAnalysisFanDetails_" + dto.getStationId() + "_" + dto.getTopmanId() + "_" + dto.getFansType();
        if (!"1".equals(dto.getClearCache())) {
            result = (BStationTopManFanAnalysisVO)this.redisUtil.get(redisKey);
        }
        HashMap<String, Object> apiParam = new HashMap<String, Object>(2);
        apiParam.put("upper_mid", dto.getStationId());
        apiParam.put("mcn_id", dto.getTopmanId());
        if (result == null) {
            result = new BStationTopManFanAnalysisVO();
            BiliBiliTopManDetailsHeadVidioEntity entity = this.spiderApiUtil.postForEntity(methodType, apiParam, BiliBiliTopManDetailsHeadVidioEntity.class);
            if (entity != null) {
                this.topManFanAnalysisFanDetailsConverter(entity, result, dto.getFansType());
            }
        } else if (!this.spiderApiUtil.checkCache(methodType, apiParam)) {
            SpiderApiUtil.taskExecutor.execute(() -> {
                dto.setClearCache("1");
                dto.setFansType(1);
                this.topManFanAnalysisFanDetails(dto);
            });
        }
        return result;
    }

    private void topManFanAnalysisFanDetailsConverter(BiliBiliTopManDetailsHeadVidioEntity entity, BStationTopManFanAnalysisVO result, Integer fansType) {
        List<String> secondCategories;
        List<BiliBiliTopManDetailsHeadVidioEntity.AgeDistributions> tagProfileList;
        List<BiliBiliTopManDetailsHeadVidioEntity.AgeDistributions> topRegionList;
        List<BiliBiliTopManDetailsHeadVidioEntity.AgeDistributions> deviceList;
        List<BiliBiliTopManDetailsHeadVidioEntity.AgeDistributions> ageList;
        List<BiliBiliTopManDetailsHeadVidioEntity.AgeDistributions> saxList;
        List<String> featureTags = entity.getAttentionUserFeatureTags();
        List<String> distributedTags = entity.getAttentionUserDistributedTags();
        if (CollectionUtil.isNotEmpty(featureTags) || CollectionUtil.isNotEmpty(distributedTags)) {
            ArrayList<String> tags = new ArrayList<String>(featureTags.size() + distributedTags.size());
            tags.addAll(featureTags);
            tags.addAll(distributedTags);
            result.setGenderMost(tags);
        }
        List<BiliBiliTopManDetailsHeadVidioEntity.AgeDistributions> list = saxList = fansType == 1 ? entity.getSaxDistributions() : entity.getSaxDistributionsAudience();
        if (CollectionUtil.isNotEmpty(saxList)) {
            ArrayList<BStationTopManFanAnalysisVO.GenderDistribution> tags = new ArrayList<BStationTopManFanAnalysisVO.GenderDistribution>(saxList.size());
            saxList.forEach(h -> {
                BStationTopManFanAnalysisVO.GenderDistribution tag = new BStationTopManFanAnalysisVO.GenderDistribution();
                tag.setCount(h.getCount());
                tag.setGender(h.getSectionDesc());
                tags.add(tag);
            });
            result.setGenderDistributions(tags);
        }
        List<BiliBiliTopManDetailsHeadVidioEntity.AgeDistributions> list2 = ageList = fansType == 1 ? entity.getAgeDistributions() : entity.getAgeDistributionsAudience();
        if (CollectionUtil.isNotEmpty(ageList)) {
            ArrayList<BStationTopManFanAnalysisVO.AgeDistribution> tags = new ArrayList<BStationTopManFanAnalysisVO.AgeDistribution>(ageList.size());
            ageList.forEach(h -> {
                BStationTopManFanAnalysisVO.AgeDistribution tag = new BStationTopManFanAnalysisVO.AgeDistribution();
                tag.setCount(h.getCount());
                tag.setAge(h.getSectionDesc());
                tags.add(tag);
            });
            result.setAgeDistributions(tags);
        }
        List<BiliBiliTopManDetailsHeadVidioEntity.AgeDistributions> list3 = deviceList = fansType == 1 ? entity.getDeviceDistributions() : entity.getDeviceDistributionsAudience();
        if (CollectionUtil.isNotEmpty(deviceList)) {
            ArrayList<BStationTopManFanAnalysisVO.EquipmentDistribution> tags = new ArrayList<BStationTopManFanAnalysisVO.EquipmentDistribution>(deviceList.size());
            deviceList.forEach(h -> {
                BStationTopManFanAnalysisVO.EquipmentDistribution tag = new BStationTopManFanAnalysisVO.EquipmentDistribution();
                tag.setCount(h.getCount());
                tag.setMobile(h.getSectionDesc());
                tags.add(tag);
            });
            result.setEquipmentDistributions(tags);
        }
        List<BiliBiliTopManDetailsHeadVidioEntity.AgeDistributions> list4 = topRegionList = fansType == 1 ? entity.getTopRegionDistributions() : entity.getTopRegionDistributionsAudience();
        if (CollectionUtil.isNotEmpty(topRegionList)) {
            ArrayList<BStationTopManFanAnalysisVO.RegionDistribution> tags = new ArrayList<BStationTopManFanAnalysisVO.RegionDistribution>(topRegionList.size());
            topRegionList.forEach(h -> {
                BStationTopManFanAnalysisVO.RegionDistribution tag = new BStationTopManFanAnalysisVO.RegionDistribution();
                tag.setCount(h.getCount());
                tag.setRegion(h.getSectionDesc());
                tags.add(tag);
            });
            result.setRegionDistributions(tags);
        }
        List<BiliBiliTopManDetailsHeadVidioEntity.AgeDistributions> list5 = tagProfileList = fansType == 1 ? entity.getTagProfile() : entity.getTagProfileAudience();
        if (CollectionUtil.isNotEmpty(tagProfileList)) {
            ArrayList<BStationTopManFanAnalysisVO.Distributions> tags = new ArrayList<BStationTopManFanAnalysisVO.Distributions>(tagProfileList.size());
            tagProfileList.forEach(h -> {
                BStationTopManFanAnalysisVO.Distributions tag = new BStationTopManFanAnalysisVO.Distributions();
                tag.setCount(h.getCount());
                tag.setSectionDesc(h.getSectionDesc());
                tags.add(tag);
            });
            result.setTagProfile(tags);
        }
        List<String> firstCategories = fansType == 1 ? entity.getFirstCategoriesProfile() : entity.getFirstCategoriesProfileAudience();
        List<String> list6 = secondCategories = fansType == 1 ? entity.getSecondCategoriesProfile() : entity.getSecondCategoriesProfileAudience();
        if (CollectionUtil.isNotEmpty(firstCategories) && CollectionUtil.isNotEmpty(secondCategories)) {
            ArrayList<BStationTopManFanAnalysisVO.CategoriesProfile> tags = new ArrayList<BStationTopManFanAnalysisVO.CategoriesProfile>(firstCategories.size());
            for (int i = 0; i < firstCategories.size(); ++i) {
                BStationTopManFanAnalysisVO.CategoriesProfile tag = new BStationTopManFanAnalysisVO.CategoriesProfile();
                tag.setFirstCategories(firstCategories.get(i));
                tag.setSecondCategories(secondCategories.get(i));
                tags.add(tag);
            }
            result.setCategoriesProfile(tags);
        }
    }

    @Override
    public BStationTopManFanAnalysisVO bStationTopManFanAnalysisDetails(String bStationId, String topmanId) {
        StringBuilder redisKey = new StringBuilder(BS).append(COLON).append(TenantContext.getTenant()).append(COLON).append("FanAnalysisEntity").append(COLON).append(bStationId).append(topmanId);
        BStationTopManFanAnalysisVO bStationTopManInformationFanAnalysis = (BStationTopManFanAnalysisVO)this.redisUtil.get(redisKey.toString());
        if (bStationTopManInformationFanAnalysis == null) {
            ArrayList<String> genderMosts = new ArrayList<String>();
            ArrayList<String> regionMosts = new ArrayList<String>();
            HashMap<String, String> param = new HashMap<String, String>();
            param.put("upper_mid", bStationId);
            param.put("mcn_id", topmanId);
            String string = JSON.toJSONString(param);
            String urlDetails = this.spiderBaseProperties.getTopManUrl() + "/bilibili/content/cooperation/api/fan_analysis/details";
            JSONObject jsonObject = HttpRequestUtils.doPost(urlDetails, string);
            if (jsonObject == null || jsonObject.size() == 0) {
                return new BStationTopManFanAnalysisVO();
            }
            JSONArray fanIncrementTrends = jsonObject.getJSONArray("fanIncrementTrends");
            List fanIncrements = fanIncrementTrends.toJavaList(BStationTopManFanAnalysisVO.FanTrend.class);
            JSONArray fanTotalTrends = jsonObject.getJSONArray("fanTotalTrends");
            List fanTotals = fanTotalTrends.toJavaList(BStationTopManFanAnalysisVO.FanTrend.class);
            JSONArray genderDistributions = jsonObject.getJSONArray("genderDistributions");
            List genders = genderDistributions.toJavaList(BStationTopManFanAnalysisVO.GenderDistribution.class);
            BStationTopManFanAnalysisVO.GenderDistribution gendersMax = genders.stream().max(Comparator.comparing(BStationTopManFanAnalysisVO.GenderDistribution::getCount)).get();
            genderMosts.add(gendersMax.getGender() + "\u5c45\u591a");
            JSONArray ageDistributions = jsonObject.getJSONArray("ageDistributions");
            List ages = ageDistributions.toJavaList(BStationTopManFanAnalysisVO.AgeDistribution.class);
            BStationTopManFanAnalysisVO.AgeDistribution ageMax = ages.stream().max(Comparator.comparing(BStationTopManFanAnalysisVO.AgeDistribution::getCount)).get();
            genderMosts.add(ageMax.getAge() + "\u5c45\u591a");
            JSONArray equipmentDistributions = jsonObject.getJSONArray("equipmentDistributions");
            List equipments = equipmentDistributions.toJavaList(BStationTopManFanAnalysisVO.EquipmentDistribution.class);
            BStationTopManFanAnalysisVO.EquipmentDistribution equipmentsMax = equipments.stream().max(Comparator.comparing(BStationTopManFanAnalysisVO.EquipmentDistribution::getCount)).get();
            genderMosts.add(equipmentsMax.getMobile() + "\u5c45\u591a");
            JSONArray regionDistributions = jsonObject.getJSONArray("regionDistributions");
            List regions = regionDistributions.toJavaList(BStationTopManFanAnalysisVO.RegionDistribution.class);
            JSONArray topTenRegionDistributions = jsonObject.getJSONArray("topTenRegionDistributions");
            List topTenRegion = topTenRegionDistributions.toJavaList(BStationTopManFanAnalysisVO.RegionDistribution.class);
            BStationTopManFanAnalysisVO.RegionDistribution topTenRegionMax = topTenRegion.stream().max(Comparator.comparing(BStationTopManFanAnalysisVO.RegionDistribution::getCount)).get();
            genderMosts.add(topTenRegionMax.getRegion() + "\u5c45\u591a");
            bStationTopManInformationFanAnalysis = new BStationTopManFanAnalysisVO();
            bStationTopManInformationFanAnalysis.setFanTotalTrends(fanTotals);
            bStationTopManInformationFanAnalysis.setFanIncrementTrends(fanIncrements);
            bStationTopManInformationFanAnalysis.setAgeDistributions(ages);
            bStationTopManInformationFanAnalysis.setEquipmentDistributions(equipments);
            bStationTopManInformationFanAnalysis.setGenderDistributions(genders);
            bStationTopManInformationFanAnalysis.setTopTenRegionDistributions(topTenRegion);
            bStationTopManInformationFanAnalysis.setRegionDistributions(regions);
            bStationTopManInformationFanAnalysis.setGenderMost(genderMosts);
            bStationTopManInformationFanAnalysis.setRegionMost(regionMosts);
            this.redisUtil.set(redisKey.toString(), (Object)bStationTopManInformationFanAnalysis, 9000L);
        }
        return bStationTopManInformationFanAnalysis;
    }

    @Override
    public List<BStationTopManPromotionAnalysisEntity> bStationTopManPromotionAnalysisDetails(String bStationId, String topmanId) {
        StringBuilder redisKey = new StringBuilder(BS).append(COLON).append("PromotionAnalysisEntity").append(COLON).append(TenantContext.getTenant()).append(COLON).append(bStationId).append(topmanId);
        List bStationTopManInformationPromotionAnalysisEntities = (List)this.redisUtil.get(redisKey.toString());
        if (bStationTopManInformationPromotionAnalysisEntities == null) {
            HashMap<String, String> param = new HashMap<String, String>();
            param.put("upper_mid", bStationId);
            param.put("mcn_id", topmanId);
            String string = JSON.toJSONString(param);
            String urlDetails = this.spiderBaseProperties.getTopManUrl() + "/bilibili/content/cooperation/api/promotion_analysis/details";
            JSONObject jsonObject = HttpRequestUtils.doPost(urlDetails, string);
            if (jsonObject == null || jsonObject.size() == 0) {
                return new ArrayList<BStationTopManPromotionAnalysisEntity>();
            }
            JSONArray data = jsonObject.getJSONArray("data");
            bStationTopManInformationPromotionAnalysisEntities = data.toJavaList(BStationTopManPromotionAnalysisEntity.class);
            if (CollectionUtils.isNotEmpty((Collection)bStationTopManInformationPromotionAnalysisEntities)) {
                this.redisUtil.set(redisKey.toString(), (Object)bStationTopManInformationPromotionAnalysisEntities, 9000L);
            }
        }
        return bStationTopManInformationPromotionAnalysisEntities;
    }

    @Override
    public BStationTopManWorkAnalysisVO bStationTopManWorkAnalysis(BiliBiliTopManDetailDTO dto) {
        SpiderMethodType methodType = SpiderMethodType.BILI_BILI_PROFILE_DETAILS;
        BStationTopManWorkAnalysisVO result = null;
        String redisKey = "BiliBiliTopManWorkAnalysis_" + dto.getStationId() + "_" + dto.getTopmanId();
        if (!"1".equals(dto.getClearCache())) {
            result = (BStationTopManWorkAnalysisVO)this.redisUtil.get(redisKey);
        }
        HashMap<String, Object> apiParam = new HashMap<String, Object>(2);
        apiParam.put("upper_mid", dto.getStationId());
        apiParam.put("mcn_id", dto.getTopmanId());
        if (result == null) {
            result = new BStationTopManWorkAnalysisVO();
            BiliBiliTopManDetailsHeadVidioEntity entity = this.spiderApiUtil.postForEntity(methodType, apiParam, BiliBiliTopManDetailsHeadVidioEntity.class);
            if (entity != null) {
                this.topManWorkAnalysisConverter(entity, result);
            }
        } else if (!this.spiderApiUtil.checkCache(methodType, apiParam)) {
            SpiderApiUtil.taskExecutor.execute(() -> {
                dto.setClearCache("1");
                this.bStationTopManWorkAnalysis(dto);
            });
        }
        return result;
    }

    private void topManWorkAnalysisConverter(BiliBiliTopManDetailsHeadVidioEntity entity, BStationTopManWorkAnalysisVO result) {
        List<BiliBiliTopManDetailsHeadVidioEntity.AgeDistributions> durationList;
        List<BiliBiliTopManDetailsHeadVidioEntity.AgeDistributions> tidList = entity.getUpTidDistributions();
        if (CollectionUtil.isNotEmpty(tidList)) {
            ArrayList<BStationTopManWorkAnalysisVO.Distributions> tags = new ArrayList<BStationTopManWorkAnalysisVO.Distributions>(tidList.size());
            tidList.forEach(h -> {
                BStationTopManWorkAnalysisVO.Distributions tag = new BStationTopManWorkAnalysisVO.Distributions();
                tag.setCount(h.getCount());
                tag.setSection(h.getSectionDesc());
                tags.add(tag);
            });
            result.setTidDistributions(tags);
        }
        if (CollectionUtil.isNotEmpty(durationList = entity.getUpDurationDistributions())) {
            ArrayList<BStationTopManWorkAnalysisVO.Distributions> tags = new ArrayList<BStationTopManWorkAnalysisVO.Distributions>(durationList.size());
            durationList.forEach(h -> {
                BStationTopManWorkAnalysisVO.Distributions tag = new BStationTopManWorkAnalysisVO.Distributions();
                tag.setCount(h.getCount());
                tag.setSection(h.getSectionDesc());
                tags.add(tag);
            });
            result.setDurationDistributions(tags);
        }
    }

    @Override
    public List<BStationTopManLatestTenVideoTrendsEntity> bStationTopManLatestTenVideoTrends(String bStationId, String type) {
        StringBuilder redisKey = new StringBuilder(BS).append(COLON).append(TenantContext.getTenant()).append(COLON).append("TenVideoTrendsEntity").append(COLON).append(bStationId).append(type);
        List latestTenVideoTrendsEntities = (List)this.redisUtil.get(redisKey.toString());
        if (latestTenVideoTrendsEntities == null) {
            HashMap<String, String> param = new HashMap<String, String>();
            param.put("upper_mid", bStationId);
            param.put("trend_type", type);
            String string = JSON.toJSONString(param);
            String urlDetails = this.spiderBaseProperties.getTopManUrl() + "/bilibili/content/cooperation/api/latest_10_video_trends/details";
            JSONObject jsonObject = HttpRequestUtils.doPost(urlDetails, string);
            if (jsonObject == null || jsonObject.size() == 0) {
                return new ArrayList<BStationTopManLatestTenVideoTrendsEntity>();
            }
            JSONArray jsonArray = jsonObject.getJSONArray("data");
            latestTenVideoTrendsEntities = jsonArray.toJavaList(BStationTopManLatestTenVideoTrendsEntity.class);
            if (CollectionUtils.isNotEmpty((Collection)latestTenVideoTrendsEntities)) {
                this.redisUtil.set(redisKey.toString(), (Object)latestTenVideoTrendsEntities, 9000L);
            }
        }
        return latestTenVideoTrendsEntities;
    }

    @Override
    public BStationTopManLiveAnalysisEntity bStationTopManLiveAnalysis(String bStationId, String topmanId) {
        StringBuilder redisKey = new StringBuilder(BS).append(COLON).append(TenantContext.getTenant()).append(COLON).append("LiveAnalysisEntity").append(COLON).append(bStationId).append(topmanId);
        BStationTopManLiveAnalysisEntity bStationTopManLiveAnalysisEntity = (BStationTopManLiveAnalysisEntity)this.redisUtil.get(redisKey.toString());
        if (bStationTopManLiveAnalysisEntity == null) {
            HashMap<String, String> param = new HashMap<String, String>();
            param.put("upper_mid", bStationId);
            param.put("mcn_id", topmanId);
            String string = JSON.toJSONString(param);
            String urlDetails = this.spiderBaseProperties.getTopManUrl() + "/bilibili/live/cooperation/api/telent_live_analysis/details";
            JSONObject jsonObject = HttpRequestUtils.doPost(urlDetails, string);
            if (jsonObject == null || jsonObject.size() == 0) {
                return new BStationTopManLiveAnalysisEntity();
            }
            bStationTopManLiveAnalysisEntity = (BStationTopManLiveAnalysisEntity)jsonObject.toJavaObject(BStationTopManLiveAnalysisEntity.class);
            this.redisUtil.set(redisKey.toString(), (Object)bStationTopManLiveAnalysisEntity, 9000L);
        }
        return bStationTopManLiveAnalysisEntity;
    }

    @Override
    public BStationTopManVideoListEntity bStationTopManVideoList(String bStationId, String categoryId, String page, String keyword) {
        StringBuilder redisKey = new StringBuilder(BS).append(COLON).append(TenantContext.getTenant()).append(COLON).append("VideoListEntity").append(COLON).append(bStationId).append(categoryId).append(COLON).append(page).append(COLON).append(keyword);
        BStationTopManVideoListEntity videoListEntity = (BStationTopManVideoListEntity)this.redisUtil.get(redisKey.toString());
        if (videoListEntity == null) {
            HashMap<String, String> param = new HashMap<String, String>();
            param.put("mid", bStationId);
            param.put("tid", categoryId);
            param.put("pn", page);
            param.put("ps", "30");
            param.put("keyword", keyword);
            param.put("order", "pubdate");
            param.put("jsonp", "jsonp");
            String string = JSON.toJSONString(param);
            String urlDetails = this.spiderBaseProperties.getTopManUrl() + "/bilibili/work/api/work_analysis_video/video_list";
            JSONObject jsonObject = HttpRequestUtils.doPost(urlDetails, string);
            if (jsonObject == null || jsonObject.size() == 0) {
                return new BStationTopManVideoListEntity();
            }
            JSONArray video = jsonObject.getJSONArray("video");
            List videoLists = video.toJavaList(BStationTopManVideoListEntity.VideoList.class);
            JSONArray catgory = jsonObject.getJSONArray("catgory");
            List videoCategories = catgory.toJavaList(BStationTopManVideoListEntity.VideoCategory.class);
            Collections.sort(videoCategories);
            videoListEntity = new BStationTopManVideoListEntity();
            videoListEntity.setVideo(videoLists);
            videoListEntity.setCategory(videoCategories);
            videoListEntity.setCurrent(jsonObject.getInteger("current"));
            videoListEntity.setSize(jsonObject.getInteger("size"));
            videoListEntity.setTotal(jsonObject.getInteger("total"));
            this.redisUtil.set(redisKey.toString(), (Object)videoListEntity, 9000L);
        }
        return videoListEntity;
    }

    @Override
    public IPage<BStationTopManSpecialListEntity> bStationTopManSpecialList(String bStationId, String pageNo) {
        StringBuilder redisKey = new StringBuilder(BS).append(COLON).append(TenantContext.getTenant()).append(COLON).append("SpecialListEntity").append(COLON).append(bStationId).append(pageNo);
        IPage page = (IPage)this.redisUtil.get(redisKey.toString());
        if (page == null) {
            HashMap<String, String> param = new HashMap<String, String>();
            param.put("mid", bStationId);
            param.put("pn", pageNo);
            param.put("ps", "12");
            param.put("sort", "publish_time");
            param.put("callback", "__jp3");
            param.put("jsonp", "jsonp");
            String string = JSON.toJSONString(param);
            String urlDetails = this.spiderBaseProperties.getTopManUrl() + "/bilibili/work/api/work_analysis_special/special_list";
            JSONObject jsonObject = HttpRequestUtils.doPost(urlDetails, string);
            if (jsonObject == null || jsonObject.size() == 0) {
                return new Page();
            }
            JSONArray data = jsonObject.getJSONArray("data");
            List bStationTopManInformationSpecialListEntities = data.toJavaList(BStationTopManSpecialListEntity.class);
            page = new Page((long)jsonObject.getInteger("current").intValue(), (long)jsonObject.getInteger("size").intValue(), (long)jsonObject.getInteger("total").intValue());
            page.setRecords(bStationTopManInformationSpecialListEntities);
            if (CollectionUtils.isNotEmpty((Collection)bStationTopManInformationSpecialListEntities)) {
                this.redisUtil.set(redisKey.toString(), (Object)page, 9000L);
            }
        }
        return page;
    }

    @Override
    public IPage<BStationTopManAlbumListEntity> bStationTopManAlbumList(String bStationId, String pageNo) {
        StringBuilder redisKey = new StringBuilder(BS).append(COLON).append(TenantContext.getTenant()).append(COLON).append("AlbumListEntity").append(COLON).append(bStationId).append(pageNo);
        IPage page = (IPage)this.redisUtil.get(redisKey.toString());
        if (page == null) {
            HashMap<String, String> param = new HashMap<String, String>();
            param.put("uid", bStationId);
            param.put("page_num", pageNo);
            param.put("page_size", "30");
            param.put("biz", "all");
            param.put("jsonp", "jsonp");
            String string = JSON.toJSONString(param);
            String urlDetails = this.spiderBaseProperties.getTopManUrl() + "/bilibili/work/api/work_analysis_album/album_list";
            JSONObject jsonObject = HttpRequestUtils.doPost(urlDetails, string);
            if (jsonObject == null || jsonObject.size() == 0) {
                return new Page();
            }
            JSONArray data = jsonObject.getJSONArray("data");
            List bStationTopManInformationAlbumListEntities = data.toJavaList(BStationTopManAlbumListEntity.class);
            page = new Page();
            page.setSize((long)jsonObject.getInteger("size").intValue());
            page.setTotal((long)jsonObject.getInteger("total").intValue());
            page.setRecords(bStationTopManInformationAlbumListEntities);
            if (CollectionUtils.isNotEmpty((Collection)bStationTopManInformationAlbumListEntities)) {
                this.redisUtil.set(redisKey.toString(), (Object)page, 9000L);
            }
        }
        return page;
    }

    @Override
    public void cleanCache(String cacheKey) {
        this.redisUtil.dels(cacheKey);
    }

    public static void sort(SimplePostRequestParam<BStationManInformationVO> topManDto, BStationRequestParamVO.Content ksSpiderApiIndexListVo, QueryWrapper<BStationTopManEntity> queryWrapper) {
        boolean order = false;
        if (StringUtils.isNotEmpty((CharSequence)topManDto.getColumn())) {
            String column = topManDto.getColumn();
            if (StringUtils.isNotEmpty((CharSequence)topManDto.getOrder()) && "asc".equals(topManDto.getOrder())) {
                order = true;
            }
            switch (column) {
                case "fanTotal": {
                    ksSpiderApiIndexListVo.setOrder_by("fans_num");
                    ksSpiderApiIndexListVo.setSort(topManDto.getOrder());
                    queryWrapper.orderBy(true, order, (Object[])new String[]{"fan_total"});
                    break;
                }
                case "avgPlay": {
                    ksSpiderApiIndexListVo.setOrder_by("last5_avg_play");
                    ksSpiderApiIndexListVo.setSort(topManDto.getOrder());
                    queryWrapper.orderBy(true, order, (Object[])new String[]{"avg_play"});
                    break;
                }
                case "interactionRate": {
                    ksSpiderApiIndexListVo.setOrder_by("last5_interaction_rate");
                    ksSpiderApiIndexListVo.setSort(topManDto.getOrder());
                    queryWrapper.orderBy(true, order, (Object[])new String[]{"interaction_rate"});
                    break;
                }
                case "topmanName": {
                    queryWrapper.orderBy(true, order, (Object[])new String[]{"topman_name"});
                    break;
                }
                case "topmanRegion": {
                    queryWrapper.orderBy(true, order, (Object[])new String[]{"topman_region"});
                    break;
                }
                case "topmanLevel": {
                    queryWrapper.orderBy(true, order, (Object[])new String[]{"topman_level"});
                    break;
                }
                case "commercialOrderType": {
                    queryWrapper.orderBy(true, order, (Object[])new String[]{"commercial_drder_type"});
                    break;
                }
                case "liveLabel": {
                    queryWrapper.orderBy(true, order, (Object[])new String[]{"livelabel"});
                    break;
                }
                case "liveCategory": {
                    queryWrapper.orderBy(true, order, (Object[])new String[]{"live_category"});
                    break;
                }
                default: {
                    BStationManInformationVO filterInfo = (BStationManInformationVO)topManDto.getFilterInfo();
                    if (!filterInfo.getTaskType().equals("liveTopMan")) break;
                    ksSpiderApiIndexListVo.setOrder_by("fans_num");
                    ksSpiderApiIndexListVo.setSort(topManDto.getOrder());
                }
            }
            if (column.equals("customVideoPrice") || column.equals("implantVideoPrice") || column.equals("directDynamicPrice") || column.equals("forwardDynamicPrice")) {
                ksSpiderApiIndexListVo.setOrder_by("price");
                ksSpiderApiIndexListVo.setSort(topManDto.getOrder());
                switch (column) {
                    case "customVideoPrice": {
                        queryWrapper.orderBy(true, order, (Object[])new String[]{"interaction_rate"});
                        break;
                    }
                    case "implantVideoPrice": {
                        queryWrapper.orderBy(true, order, (Object[])new String[]{"implant_video_price"});
                        break;
                    }
                    case "directDynamicPrice": {
                        queryWrapper.orderBy(true, order, (Object[])new String[]{"direct_dynamic_price"});
                        break;
                    }
                    case "forwardDynamicPrice": {
                        queryWrapper.orderBy(true, order, (Object[])new String[]{"forwarddynamic_price"});
                    }
                }
            }
        } else {
            queryWrapper.orderBy(true, order, (Object[])new String[]{"collect_update_time"});
        }
    }

    public static String camelToUnderline(String para) {
        if (para.length() < 3) {
            return para.toLowerCase();
        }
        StringBuilder sb = new StringBuilder(para);
        int temp = 0;
        for (int i = 2; i < para.length(); ++i) {
            if (!Character.isUpperCase(para.charAt(i))) continue;
            sb.insert(i + temp, "_");
            ++temp;
        }
        return sb.toString().toLowerCase();
    }

    private static String apiGetList(String taskType, SimplePostRequestParam<BStationManInformationVO> topManDto, BStationTopManEntity bStationTopManInformation, QueryWrapper<BStationTopManEntity> queryWrapper, StringBuilder cacheKey) throws Exception {
        BStationManInformationVO.ScreenItem screenItem;
        BStationManInformationVO filterInfo = (BStationManInformationVO)topManDto.getFilterInfo();
        BStationRequestParamVO.Content ksSpiderApiIndexListVo = BStationTopManServiceImpl.getRequestContent(taskType, topManDto);
        String keyWord = topManDto.getKeyWord();
        if (keyWord != null && !"".equals(keyWord)) {
            ksSpiderApiIndexListVo.setNickname_or_mid(keyWord.trim());
            queryWrapper.lambda().eq(BStationTopManEntity::getTopmanName, (Object)keyWord.trim());
            cacheKey.append(keyWord.trim()).append(COLON);
        }
        if ((screenItem = filterInfo.getScreenItem()) != null) {
            List<BStationManInformationVO.ScreenItemField> otherFilter;
            List<BStationManInformationVO.ScreenItemField> putInfo;
            List<BStationManInformationVO.ScreenItemField> fansPortrait;
            List<BStationManInformationVO.ScreenItemField> talentInfo;
            List<BStationManInformationVO.ScreenItemField> liveType;
            List<BStationManInformationVO.ScreenItemField> commercialOrderType = screenItem.getCommercialOrderType();
            if (CollectionUtils.isNotEmpty(commercialOrderType)) {
                Map<String, String> queryParam = BStationTopManServiceImpl.getQueryParam(commercialOrderType, cacheKey);
                ksSpiderApiIndexListVo.setCommercial_tag_id(queryParam.get("value"));
                bStationTopManInformation.setCommercialOrderType(queryParam.get("label"));
            }
            if (CollectionUtils.isNotEmpty(liveType = screenItem.getLiveType())) {
                Map<String, String> queryParam = BStationTopManServiceImpl.getQueryParam(liveType, cacheKey);
                ksSpiderApiIndexListVo.setArea_id(queryParam.get("value"));
                bStationTopManInformation.setLiveCategory(queryParam.get("label"));
            }
            if (CollectionUtils.isNotEmpty(talentInfo = screenItem.getTalentInfo())) {
                talentInfo.forEach(a -> {
                    switch (a.getTitle()) {
                        case "\u4eba\u8bbe\u6807\u7b7e": {
                            Map<String, String> telentInfoParam = BStationTopManServiceImpl.getTelentInfoParam(a.getValue(), cacheKey);
                            ksSpiderApiIndexListVo.setCharacter_tag_id(telentInfoParam.get("value"));
                            bStationTopManInformation.setHumanTag(telentInfoParam.get("label"));
                            break;
                        }
                        case "\u76f4\u64ad\u6807\u7b7e": {
                            Map<String, String> liveTag = BStationTopManServiceImpl.getTelentInfoParam(a.getValue(), cacheKey);
                            ksSpiderApiIndexListVo.setLive_parent_tag(liveTag.get("value"));
                            bStationTopManInformation.setLiveLabel(liveTag.get("label"));
                            break;
                        }
                        case "\u65e5\u5e38\u804c\u4e1a": {
                            Map<String, String> occupationTag = BStationTopManServiceImpl.getTelentInfoParam(a.getValue(), cacheKey);
                            ksSpiderApiIndexListVo.setOccupation_tag_id(occupationTag.get("value"));
                            bStationTopManInformation.setDailyOccupation(occupationTag.get("label"));
                            break;
                        }
                        case "\u7c89\u4e1d\u603b\u6570": {
                            BStationTopManServiceImpl.getParam(a.getValue().toString(), a.getTitle(), ksSpiderApiIndexListVo, queryWrapper, cacheKey);
                            break;
                        }
                        case "\u8fbe\u4eba\u6027\u522b": {
                            ksSpiderApiIndexListVo.setGender(a.getValue().toString());
                            queryWrapper.lambda().eq(BStationTopManEntity::getTopmanGender, (Object)a.getValue().toString());
                            cacheKey.append(a.getValue().toString()).append(COLON);
                            break;
                        }
                        case "\u8fbe\u4eba\u5730\u57df": {
                            BStationTopManServiceImpl.getRegion(a.getValue(), ksSpiderApiIndexListVo, bStationTopManInformation, cacheKey);
                            break;
                        }
                        case "\u662f\u5426\u7b7e\u7ea6": {
                            if (!a.getValue().toString().equals("true")) break;
                            ksSpiderApiIndexListVo.setOnly_contract("3");
                            queryWrapper.lambda().eq(BStationTopManEntity::getContract, (Object)"3");
                            cacheKey.append("3").append(COLON);
                            break;
                        }
                        default: {
                            throw new ELSBootException("\u6ca1\u6709\u627e\u5230\u8be5\u9009\u9879");
                        }
                    }
                });
            }
            if (CollectionUtils.isNotEmpty(fansPortrait = screenItem.getFansPortrait())) {
                fansPortrait.forEach(a -> {
                    switch (a.getTitle()) {
                        case "\u7c89\u4e1d\u6027\u522b": {
                            ksSpiderApiIndexListVo.setFans_gender_tag(a.getValue().toString());
                            cacheKey.append(a.getValue().toString()).append(COLON);
                            break;
                        }
                        case "\u7c89\u4e1d\u5e74\u9f84": {
                            ksSpiderApiIndexListVo.setFans_age_tag(a.getValue().toString());
                            cacheKey.append(a.getValue().toString()).append(COLON);
                            break;
                        }
                        case "\u7c89\u4e1d\u57ce\u5e02\u7ebf": {
                            ksSpiderApiIndexListVo.setFans_region_tag(a.getValue().toString());
                            cacheKey.append(a.getValue().toString()).append(COLON);
                            break;
                        }
                        default: {
                            throw new ELSBootException("\u6ca1\u6709\u627e\u5230\u8be5\u9009\u9879");
                        }
                    }
                });
            }
            if (CollectionUtils.isNotEmpty(putInfo = screenItem.getPutInfo())) {
                putInfo.forEach(a -> {
                    switch (a.getTitle()) {
                        case "\u5b9a\u5236\u89c6\u9891\u62a5\u4ef7": {
                            BStationTopManServiceImpl.getParam(a.getValue(), a.getTitle(), ksSpiderApiIndexListVo, queryWrapper, cacheKey);
                            break;
                        }
                        case "\u5408\u4f5c\u7c7b\u578b": {
                            ksSpiderApiIndexListVo.setCooperation_types(a.getValue().toString());
                            bStationTopManInformation.setCooperationType(BStationTopManServiceImpl.getCooperationType(a.getValue().toString()));
                            cacheKey.append(a.getValue().toString()).append(COLON);
                            break;
                        }
                        default: {
                            throw new ELSBootException("\u6ca1\u6709\u627e\u5230\u8be5\u9009\u9879");
                        }
                    }
                });
            }
            if (CollectionUtils.isNotEmpty(otherFilter = screenItem.getOtherFilter())) {
                StringBuilder sb = new StringBuilder();
                block12: for (BStationManInformationVO.ScreenItemField a2 : otherFilter) {
                    switch (a2.getTitle()) {
                        case "\u8fd1\u671f\u5165\u9a7b": {
                            BStationTopManServiceImpl.getRecentlySettled(a2.getValue(), ksSpiderApiIndexListVo, cacheKey);
                            continue block12;
                        }
                        case "\u5408\u4f5c\u4e30\u5bcc": {
                            sb = sb.append("cooperate,coo_frequent,coo_multi_industry").append(",");
                            continue block12;
                        }
                        case "\u7c89\u4e1d\u98d9\u5347": {
                            sb = sb.append("grow").append(",");
                            continue block12;
                        }
                        case "\u591a\u6b21\u70ed\u95e8": {
                            sb = sb.append("hot_frequent").append(",");
                            continue block12;
                        }
                    }
                    throw new ELSBootException("\u6ca1\u6709\u627e\u5230\u8be5\u9009\u9879");
                }
                if (StringUtils.isNotBlank((CharSequence)sb.toString())) {
                    sb = sb.delete(sb.length() - 1, sb.length());
                }
                ksSpiderApiIndexListVo.setSpark_tag(sb.toString());
                bStationTopManInformation.setSpark(sb.toString().replaceAll(",", "|"));
                cacheKey.append((CharSequence)sb).append(COLON);
            }
        }
        BStationTopManServiceImpl.sort(topManDto, ksSpiderApiIndexListVo, queryWrapper);
        String json = JSON.toJSONString((Object)ksSpiderApiIndexListVo);
        System.out.println("bbbbbbbbbbbbbbb=" + json);
        return json;
    }

    public static Map<String, String> getQueryParam(List<BStationManInformationVO.ScreenItemField> liveType, StringBuilder cacheKey) {
        StringBuilder sbValue = new StringBuilder();
        StringBuilder sbLabel = new StringBuilder();
        liveType.forEach(a -> {
            Object value = a.getValue();
            String string = JSON.toJSONString((Object)value);
            List maps = JSON.parseArray((String)string, Map.class);
            maps.forEach(b -> {
                sbValue.append(b.get("value")).append(",");
                sbLabel.append(b.get("label")).append("|");
            });
        });
        String strCount = sbValue.delete(sbValue.length() - 1, sbValue.length()).toString();
        String strName = sbLabel.delete(sbLabel.length() - 1, sbLabel.length()).toString();
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("value", strCount);
        param.put("label", strName);
        cacheKey.append(strCount).append(COLON);
        return param;
    }

    public static String getCooperationType(String value) {
        String str = "";
        switch (value) {
            case "1": {
                str = "\u690d\u5165\u89c6\u9891";
                break;
            }
            case "2": {
                str = "\u5b9a\u5236\u89c6\u9891";
                break;
            }
            case "3": {
                str = "\u76f4\u53d1\u52a8\u6001";
                break;
            }
            case "4": {
                str = "\u8f6c\u53d1\u52a8\u6001";
                break;
            }
            default: {
                throw new ELSBootException("\u6ca1\u6709\u627e\u5230\u8be5\u9009\u9879");
            }
        }
        return null;
    }

    public static Map<String, String> getTelentInfoParam(Object value, StringBuilder cacheKey) {
        StringBuilder sbValue = new StringBuilder();
        StringBuilder sbLabel = new StringBuilder();
        String string = JSON.toJSONString((Object)value);
        List maps = JSON.parseArray((String)string, Map.class);
        maps.forEach(b -> {
            sbValue.append(b.get("value")).append(",");
            sbLabel.append(b.get("label")).append("|");
        });
        String strCount = sbValue.delete(sbValue.length() - 1, sbValue.length()).toString();
        String strName = sbLabel.delete(sbLabel.length() - 1, sbLabel.length()).toString();
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("value", strCount);
        param.put("label", strName);
        cacheKey.append(strCount).append(COLON);
        return param;
    }

    public static BStationRequestParamVO.Content getRequestContent(String taskType, SimplePostRequestParam<BStationManInformationVO> topManDto) {
        BStationRequestParamVO.Content ksSpiderApiIndexListVo = new BStationRequestParamVO.Content();
        if (taskType.equals("liveTopMan")) {
            ksSpiderApiIndexListVo.setPage(topManDto.getPageNo());
            ksSpiderApiIndexListVo.setSize(topManDto.getPageSize());
            ksSpiderApiIndexListVo.setSort("desc");
            ksSpiderApiIndexListVo.setOrder_by("fans_num");
            ksSpiderApiIndexListVo.setIs_live("true");
            ksSpiderApiIndexListVo.setLive_parent_tag("");
            ksSpiderApiIndexListVo.setArea_id("");
            ksSpiderApiIndexListVo.setParent_area_id("");
        } else {
            ksSpiderApiIndexListVo.setPage(topManDto.getPageNo());
            ksSpiderApiIndexListVo.setSize(topManDto.getPageSize());
            ksSpiderApiIndexListVo.setSort("");
            ksSpiderApiIndexListVo.setOrder_by("");
            ksSpiderApiIndexListVo.setOnly_potential_upper("0");
            ksSpiderApiIndexListVo.setOccupation_tag_id("");
            ksSpiderApiIndexListVo.setCharacter_tag_id("");
            ksSpiderApiIndexListVo.setMin_task_price("");
            ksSpiderApiIndexListVo.setMax_task_price("");
            ksSpiderApiIndexListVo.setProvider_id("");
            ksSpiderApiIndexListVo.setSpark_tag("");
            ksSpiderApiIndexListVo.setCommercial_tag_id("");
            ksSpiderApiIndexListVo.setUpper_mid("");
            ksSpiderApiIndexListVo.setOnly_contract("0");
            ksSpiderApiIndexListVo.setGoods_permission("0");
            ksSpiderApiIndexListVo.setCooperation_types("");
            ksSpiderApiIndexListVo.setUse_dynamic_score("true");
            ksSpiderApiIndexListVo.setLast_7_days_set_price("0");
            ksSpiderApiIndexListVo.setLast_7_days_set_price("0");
            ksSpiderApiIndexListVo.setLast_14_days_set_price("0");
            ksSpiderApiIndexListVo.setLast_30_days_set_price("0");
            ksSpiderApiIndexListVo.setHas_condition("1");
            if (taskType.equals("collectTopMan")) {
                ksSpiderApiIndexListVo.setArea_id("");
            }
        }
        ksSpiderApiIndexListVo.setFans_region_tag("");
        ksSpiderApiIndexListVo.setFans_age_tag("");
        ksSpiderApiIndexListVo.setFans_gender_tag("");
        ksSpiderApiIndexListVo.setMax_fans_num("");
        ksSpiderApiIndexListVo.setMin_fans_num("");
        ksSpiderApiIndexListVo.setSecond_region_id("");
        ksSpiderApiIndexListVo.setRegion_id("");
        ksSpiderApiIndexListVo.setGender("");
        ksSpiderApiIndexListVo.setNickname_or_mid("");
        return ksSpiderApiIndexListVo;
    }

    public static void getRecentlySettled(Object str, BStationRequestParamVO.Content ksSpiderApiIndexListVo, StringBuilder cacheKey) {
        if (StringUtils.isNotEmpty((CharSequence)str.toString())) {
            switch (str.toString()) {
                case "\u8fd17\u5929\u65b0\u5165\u9a7b": {
                    ksSpiderApiIndexListVo.setLast_7_days_set_price("1");
                    cacheKey.append("7").append(COLON);
                    break;
                }
                case "\u8fd114\u5929\u65b0\u5165\u9a7b": {
                    ksSpiderApiIndexListVo.setLast_14_days_set_price("1");
                    cacheKey.append("14").append(COLON);
                    break;
                }
                case "\u8fd130\u5929\u65b0\u5165\u9a7b": {
                    ksSpiderApiIndexListVo.setLast_30_days_set_price("1");
                    cacheKey.append("30").append(COLON);
                    break;
                }
                default: {
                    new ELSBootException("\u627e\u4e0d\u5230\u6539\u7c7b\u578b\u7b5b\u9009\u6761\u4ef6");
                }
            }
        }
    }

    public static void getRegion(Object str, BStationRequestParamVO.Content ksSpiderApiIndexListVo, BStationTopManEntity bStationTopManInformation, StringBuilder cacheKey) {
        String string = JSON.toJSONString((Object)str);
        List maps = JSON.parseArray((String)string, Map.class);
        ksSpiderApiIndexListVo.setRegion_id(((Map)maps.get(0)).get("value").toString());
        bStationTopManInformation.setTopmanRegion(((Map)maps.get(0)).get("label").toString());
        cacheKey.append(((Map)maps.get(0)).get("value").toString()).append(COLON);
        if (((Map)maps.get(1)).size() > 0) {
            ksSpiderApiIndexListVo.setSecond_region_id(((Map)maps.get(1)).get("value").toString());
            bStationTopManInformation.setTopmanRegion(((Map)maps.get(0)).get("label").toString() + "|" + ((Map)maps.get(1)).get("value").toString());
            cacheKey.append(((Map)maps.get(0)).get("label").toString() + "|" + ((Map)maps.get(1)).get("value").toString()).append(COLON);
        }
    }

    public static void getParam(Object str, String type, BStationRequestParamVO.Content ksSpiderApiIndexListVo, QueryWrapper<BStationTopManEntity> queryWrapper, StringBuilder cacheKey) {
        String[] split;
        String value = str.toString();
        if (type.equals("\u7c89\u4e1d\u603b\u6570")) {
            if (value.startsWith("-")) {
                split = value.split("-");
                ksSpiderApiIndexListVo.setMax_fans_num(split[1]);
                queryWrapper.lambda().lt(BStationTopManEntity::getFanTotal, (Object)split[1]);
                cacheKey.append(split[1]).append(COLON);
            } else if (value.endsWith("-")) {
                split = value.split("-");
                ksSpiderApiIndexListVo.setMin_fans_num(split[0]);
                queryWrapper.lambda().gt(BStationTopManEntity::getFanTotal, (Object)split[0]);
                cacheKey.append(split[0]).append(COLON);
            } else {
                split = value.split("-");
                ksSpiderApiIndexListVo.setMin_fans_num(split[0]);
                ksSpiderApiIndexListVo.setMax_fans_num(split[1]);
                queryWrapper.lambda().between(BStationTopManEntity::getFanTotal, (Object)split[0], (Object)split[1]);
                cacheKey.append(split[0]).append(COLON).append(split[1]).append(COLON);
            }
        }
        if (type.equals("\u5b9a\u5236\u89c6\u9891\u62a5\u4ef7")) {
            if (value.startsWith("-")) {
                split = value.split("-");
                ksSpiderApiIndexListVo.setMax_task_price(split[1]);
                queryWrapper.lambda().lt(BStationTopManEntity::getCustomVideoPrice, (Object)split[1]);
                cacheKey.append(split[1]);
            } else if (value.endsWith("-")) {
                split = value.split("-");
                ksSpiderApiIndexListVo.setMin_task_price(split[0]);
                queryWrapper.lambda().gt(BStationTopManEntity::getCustomVideoPrice, (Object)split[0]);
                cacheKey.append(split[0]);
            } else {
                split = value.split("-");
                ksSpiderApiIndexListVo.setMin_task_price(split[0]);
                ksSpiderApiIndexListVo.setMax_task_price(split[1]);
                queryWrapper.lambda().between(BStationTopManEntity::getCustomVideoPrice, (Object)split[0], (Object)split[1]);
                cacheKey.append(split[0]).append(split[1]);
            }
        }
    }

    private void handleResult(List<BStationTopManEntity> data, String platform) {
        List<String> bStationId = data.stream().map(BStationTopManEntity::getBStationId).distinct().collect(Collectors.toList());
        List<BStationTopManEntity> addedAndCollects = this.baseMapper.checkAddedAndCollect(bStationId, SysUtil.getLoginUser(), platform);
        Map<Object, Object> map = new HashMap();
        if (CollectionUtil.isNotEmpty(addedAndCollects)) {
            map = addedAndCollects.stream().collect(Collectors.toMap(BStationTopManEntity::getBStationId, h -> h, (k1, k2) -> k1));
        }
        for (BStationTopManEntity topManInfo : data) {
            if (!map.containsKey(topManInfo.getBStationId())) continue;
            BStationTopManEntity info = (BStationTopManEntity)map.get(topManInfo.getBStationId());
            topManInfo.setIsCollection(info.getIsCollection());
            topManInfo.setIsAdded(info.getIsAdded());
        }
    }

    private List<TopManOptionsEntity.Tag> transferTopManCommercial(Document doc, String type) {
        List docList = doc.getList((Object)"directory_json", Document.class);
        return docList.stream().map(h -> {
            TopManOptionsEntity.TagCopy tag = new TopManOptionsEntity.TagCopy();
            tag.setId(h.get((Object)"id").toString());
            tag.setLabel(h.get((Object)"label").toString());
            tag.setValue(h.get((Object)"value").toString());
            tag.setComponentType("RMultipleChoice");
            tag.setChildren(this.getParam((Document)h, type));
            return tag;
        }).collect(Collectors.toList());
    }

    private List<Object> getParam(Document document, String type) {
        ArrayList<Object> tagCopyList = new ArrayList<Object>();
        List children = document.getList((Object)"children", Map.class);
        if (children.size() > 0) {
            children.forEach(a -> {
                TopManOptionsEntity.TagCopy tagCopy = new TopManOptionsEntity.TagCopy();
                tagCopy.setId(a.get("id").toString());
                tagCopy.setLabel(a.get("label").toString());
                tagCopy.setValue(a.get("value").toString());
                List children1 = (List)a.get("children");
                if (children1.size() < 0) {
                    tagCopy.setChildren(null);
                } else {
                    ArrayList sonTagCopyList = new ArrayList();
                    children1.forEach(b -> {
                        TopManOptionsEntity.TagCopy sonTagCopy = new TopManOptionsEntity.TagCopy();
                        sonTagCopy.setId(b.get("id") == null ? null : a.get("id").toString());
                        sonTagCopy.setLabel(b.get("label").toString());
                        sonTagCopy.setValue(b.get("value").toString());
                        sonTagCopy.setChildren(null);
                        sonTagCopyList.add(sonTagCopy);
                    });
                    tagCopy.setChildren(sonTagCopyList);
                }
                System.out.println(children1.getClass().getName());
                tagCopyList.add(tagCopy);
            });
        }
        return tagCopyList;
    }

    private List<TopManOptionsEntity.Tag> transferLiveTopMan(Document doc, String type) {
        List docList = doc.getList((Object)"directory_json", Document.class);
        return docList.stream().map(h -> {
            TopManOptionsEntity.TagCopy tag = new TopManOptionsEntity.TagCopy();
            tag.setId(h.get((Object)"id").toString());
            tag.setLabel(h.get((Object)"name").toString());
            tag.setValue(h.get((Object)"id").toString());
            tag.setComponentType("RMultipleChoice");
            tag.setChildren(this.getLiveParam((Document)h));
            return tag;
        }).collect(Collectors.toList());
    }

    private List<Object> getLiveParam(Document document) {
        ArrayList<Object> tagCopyList = new ArrayList<Object>();
        List children = document.getList((Object)"list", Map.class);
        children.forEach(a -> {
            TopManOptionsEntity.TagCopy tagCopy = new TopManOptionsEntity.TagCopy();
            tagCopy.setId(a.get("id").toString());
            tagCopy.setLabel(a.get("name").toString());
            tagCopy.setValue(a.get("id").toString());
            tagCopyList.add(tagCopy);
        });
        return tagCopyList;
    }

    private List<TopManOptionsEntity.Tag> transferFansPortrait(Document doc, String type) {
        List docList = doc.getList((Object)"directory_json", Document.class);
        return docList.stream().map(h -> this.transferSub((Document)h, type, h.get((Object)"label").toString())).collect(Collectors.toList());
    }

    private TopManOptionsEntity.TagCopy transferSub(Document doc, String type, String label) {
        TopManOptionsEntity.TagCopy tag = new TopManOptionsEntity.TagCopy();
        tag.setId(doc.get((Object)"id").toString());
        tag.setLabel(doc.getString((Object)"label"));
        tag.setValue(doc.get((Object)"value").toString());
        tag.setLevel(Integer.getInteger("id"));
        if (label.equals("\u4eba\u8bbe\u6807\u7b7e") || label.equals("\u65e5\u5e38\u804c\u4e1a") || label.equals("\u76f4\u64ad\u6807\u7b7e")) {
            tag.setComponentType("RMultipleChoice");
        } else if (label.equals("\u8fbe\u4eba\u6027\u522b") || label.equals("\u7c89\u4e1d\u6027\u522b") || label.equals("\u7c89\u4e1d\u5e74\u9f84") || label.equals("\u5408\u4f5c\u7c7b\u578b") || label.equals("\u8fd1\u671f\u5165\u9a7b") || label.equals("\u7c89\u4e1d\u57ce\u5e02\u7ebf")) {
            tag.setComponentType("RSelect");
        } else if (label.equals("\u662f\u5426\u7b7e\u7ea6") || label.equals("\u5408\u4f5c\u4e30\u5bcc") || label.equals("\u7c89\u4e1d\u98d9\u5347") || label.equals("\u591a\u6b21\u70ed\u95e8") || label.equals("\u5b9d\u85cf\u8fbe\u4eba")) {
            tag.setComponentType("RCheckbox");
        } else if (label.equals("\u7c89\u4e1d\u603b\u6570") || label.equals("\u5b9a\u5236\u89c6\u9891\u62a5\u4ef7") || label.equals("\u690d\u5165\u89c6\u9891\u62a5\u4ef7") || label.equals("\u76f4\u53d1\u89c6\u9891\u62a5\u4ef7") || label.equals("\u8f6c\u53d1\u89c6\u9891\u62a5\u4ef7")) {
            tag.setComponentType("RCustomSelect");
        } else if (label.equals("\u8fbe\u4eba\u5730\u57df")) {
            tag.setComponentType("RCascader");
        }
        if (label.equals("\u4eba\u8bbe\u6807\u7b7e") || label.equals("\u65e5\u5e38\u804c\u4e1a") || label.equals("\u8fbe\u4eba\u5730\u57df")) {
            ArrayList tagCopyList = new ArrayList();
            List children = doc.getList((Object)"children", Map.class);
            children.forEach(a -> {
                TopManOptionsEntity.TagCopy tagCopy = new TopManOptionsEntity.TagCopy();
                tagCopy.setId(a.get("id").toString());
                tagCopy.setLabel(a.get("label").toString());
                tagCopy.setValue(a.get("value").toString());
                List children1 = (List)a.get("children");
                if (children1.size() < 0) {
                    tagCopy.setChildren(null);
                } else {
                    ArrayList sonTagCopyList = new ArrayList();
                    children1.forEach(b -> {
                        TopManOptionsEntity.TagCopy sonTagCopy = new TopManOptionsEntity.TagCopy();
                        sonTagCopy.setId(b.get("id") == null ? null : a.get("id").toString());
                        sonTagCopy.setLabel(b.get("label").toString());
                        sonTagCopy.setValue(b.get("value").toString());
                        sonTagCopy.setChildren(null);
                        sonTagCopyList.add(sonTagCopy);
                    });
                    tagCopy.setChildren(sonTagCopyList);
                }
                tagCopyList.add(tagCopy);
            });
            tag.setChildren(tagCopyList);
        } else {
            tag.setChildren(doc.getList((Object)"children", Object.class));
        }
        if ((type.equals("videoTopMan") || type.equals("collectTopMan")) && label.equals("\u76f4\u64ad\u6807\u7b7e")) {
            return null;
        }
        if (type.equals("liveTopMan") && (label.equals("\u4eba\u8bbe\u6807\u7b7e") || label.equals("\u65e5\u5e38\u804c\u4e1a") || label.equals("\u662f\u5426\u7b7e\u7ea6"))) {
            return null;
        }
        if (type.equals("collectTopMan") && label.equals("\u8fd1\u671f\u5165\u9a7b")) {
            return null;
        }
        if (type.equals("videoTopMan") && (label.equals("\u690d\u5165\u89c6\u9891\u62a5\u4ef7") || label.equals("\u76f4\u53d1\u89c6\u9891\u62a5\u4ef7") || label.equals("\u8f6c\u53d1\u89c6\u9891\u62a5\u4ef7"))) {
            return null;
        }
        return tag;
    }
}

