/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.job;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.els.common.api.service.JobRpcService;
import com.els.modules.job.utils.DataFormatUtils;
import com.els.modules.topman.entity.DouYinTopManEntity;
import com.els.modules.topman.service.DouYinTopManService;
import com.els.modules.topman.utils.spider.entity.DouYinTopManInfoEntity;
import com.mongodb.client.MongoCursor;
import java.util.ArrayList;
import java.util.Date;
import javax.annotation.Resource;
import org.bson.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.stereotype.Component;

@Component
@EnableScheduling
public class DyTopManJob
implements JobRpcService {
    private static final Logger log = LoggerFactory.getLogger(DyTopManJob.class);
    @Resource
    private MongoTemplate mongoTemplate;
    @Resource
    private DouYinTopManService douYinTopManService;

    public void execute(String parameter) {
        log.info("------------start DyTopManJob-----------");
        int i = 0;
        try (MongoCursor cursor = this.mongoTemplate.getCollection("tb_douyin_els_topman_listDetail").find().noCursorTimeout(true).batchSize(500).cursor();){
            log.info("------------start TopManJob cursor -----------1");
            ArrayList<DouYinTopManEntity> updateList = new ArrayList<DouYinTopManEntity>(1000);
            ArrayList<DouYinTopManEntity> insertList = new ArrayList<DouYinTopManEntity>(1000);
            while (cursor.hasNext()) {
                Document doc = (Document)cursor.next();
                try {
                    QueryWrapper queryWrapper = new QueryWrapper();
                    String userId = DataFormatUtils.documentToString(doc.get((Object)"userId"));
                    ((LambdaQueryWrapper)queryWrapper.lambda().eq(DouYinTopManEntity::getTopmanId, (Object)userId)).eq(DouYinTopManEntity::getPlatform, (Object)"1");
                    DouYinTopManEntity one = (DouYinTopManEntity)((Object)this.douYinTopManService.getOne((Wrapper)queryWrapper));
                    if (one == null) {
                        one = new DouYinTopManEntity();
                        this.getSpiderMarkEntity(doc, one);
                        insertList.add(one);
                        if (insertList.size() != 1000 && cursor.hasNext()) continue;
                        this.douYinTopManService.insertBatch(insertList);
                        insertList = new ArrayList(1000);
                        continue;
                    }
                    this.getSpiderMarkEntity(doc, one);
                    updateList.add(one);
                    if (updateList.size() != 1000 && cursor.hasNext()) continue;
                    this.douYinTopManService.updateBatch(updateList);
                    updateList = new ArrayList(1000);
                }
                catch (Exception e) {
                    log.error("doc error {}", (Object)doc);
                    log.error("genTopMan error ", (Throwable)e);
                }
            }
            log.info("------------start DyTopManJob cursor -----------" + ++i);
        }
        catch (Exception e) {
            log.error("mongodb error", (Throwable)e);
        }
    }

    private void getSpiderMarkEntity(Document doc, DouYinTopManEntity douYinTopManEntity) {
        if (douYinTopManEntity.getId() == null) {
            douYinTopManEntity.setId(String.valueOf(doc.get((Object)"_id")));
        }
        DouYinTopManInfoEntity douYinTopManInfoEntity = (DouYinTopManInfoEntity)JSON.parseObject((String)doc.toJson(), DouYinTopManInfoEntity.class);
        this.douYinTopManService.transferBean(douYinTopManInfoEntity, douYinTopManEntity);
        if (douYinTopManEntity.getId() == null) {
            douYinTopManEntity.setCreateTime(new Date());
            douYinTopManEntity.setCreateBy("DyTopManJob");
        }
        douYinTopManEntity.setUpdateBy("DyTopManJob");
        douYinTopManEntity.setUpdateTime(new Date());
        douYinTopManEntity.setDeleted(0);
    }
}

