/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.job;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.els.common.api.service.JobRpcService;
import com.els.modules.job.utils.DataFormatUtils;
import com.els.modules.topman.entity.KuaiShouTopManEntity;
import com.els.modules.topman.service.KuaiShouSpiderTopManService;
import com.els.modules.topman.service.KuaiShouTopManService;
import com.mongodb.client.MongoCursor;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.bson.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.stereotype.Component;

@Component
@EnableScheduling
public class KsTopManJob
implements JobRpcService {
    private static final Logger log = LoggerFactory.getLogger(KsTopManJob.class);
    @Resource
    private MongoTemplate mongoTemplate;
    @Autowired
    private KuaiShouSpiderTopManService kuaiShouSpiderTopManService;
    @Autowired
    private KuaiShouTopManService ksTopManInformationService;

    public void execute(String parameter) {
        log.info("------------start KsTopManJob-----------");
        int i = 0;
        try (MongoCursor cursor = this.mongoTemplate.getCollection("tb_kuaishou_els_topman_listDetail").find().noCursorTimeout(true).batchSize(500).cursor();){
            log.info("------------start TopManJob cursor -----------1");
            ArrayList<KuaiShouTopManEntity> updateList = new ArrayList<KuaiShouTopManEntity>(1000);
            ArrayList<KuaiShouTopManEntity> insertList = new ArrayList<KuaiShouTopManEntity>(1000);
            while (cursor.hasNext()) {
                Document doc = (Document)cursor.next();
                try {
                    QueryWrapper queryWrapper = new QueryWrapper();
                    String userId = DataFormatUtils.documentToString(doc.get((Object)"userId"));
                    ((LambdaQueryWrapper)queryWrapper.lambda().eq(KuaiShouTopManEntity::getTopmanId, (Object)userId)).eq(KuaiShouTopManEntity::getPlatform, (Object)"2");
                    KuaiShouTopManEntity one = (KuaiShouTopManEntity)((Object)this.kuaiShouSpiderTopManService.getOne((Wrapper)queryWrapper));
                    if (one == null) {
                        one = new KuaiShouTopManEntity();
                        this.getSpiderMarkEntity(doc, one);
                        insertList.add(one);
                        if (insertList.size() != 1000 && cursor.hasNext()) continue;
                        this.kuaiShouSpiderTopManService.insertBatch(insertList);
                        insertList = new ArrayList(1000);
                        continue;
                    }
                    this.getSpiderMarkEntity(doc, one);
                    updateList.add(one);
                    if (updateList.size() != 1000 && cursor.hasNext()) continue;
                    this.kuaiShouSpiderTopManService.updateBatch(updateList);
                    updateList = new ArrayList(1000);
                }
                catch (Exception e) {
                    log.error("doc error {}", (Object)doc);
                    log.error("genTopMan error ", (Throwable)e);
                }
            }
            log.info("------------start KsTopManJob cursor -----------" + ++i);
        }
        catch (Exception e) {
            log.error("mongodb error", (Throwable)e);
        }
    }

    private void getSpiderMarkEntity(Document doc, KuaiShouTopManEntity kuaiShouTopManEntity) {
        if (kuaiShouTopManEntity.getId() == null) {
            kuaiShouTopManEntity.setId(String.valueOf(doc.get((Object)"_id")));
        }
        kuaiShouTopManEntity.setTopmanId(DataFormatUtils.numberToString(doc.get((Object)"userId")));
        kuaiShouTopManEntity.setTopmanName(doc.getString((Object)"name"));
        kuaiShouTopManEntity.setKwaiid(doc.getString((Object)"kwaiId"));
        kuaiShouTopManEntity.setStarId(DataFormatUtils.numberToString(doc.get((Object)"starId")));
        kuaiShouTopManEntity.setPlatform("2");
        kuaiShouTopManEntity.setTopmanAvatar(doc.getString((Object)"headUrl"));
        kuaiShouTopManEntity.setTopmanSource("1");
        kuaiShouTopManEntity.setLiveStatus(DataFormatUtils.numberToString(doc.get((Object)"liveStatus")));
        kuaiShouTopManEntity.setTopmanSex(doc.getString((Object)"gender"));
        kuaiShouTopManEntity.setProvinceCode(doc.getDouble((Object)"provinceCode").intValue());
        kuaiShouTopManEntity.setCityCode(doc.getDouble((Object)"cityCode").intValue());
        kuaiShouTopManEntity.setRegion(this.ksTopManInformationService.formatRegion(kuaiShouTopManEntity.getProvinceCode(), kuaiShouTopManEntity.getCityCode()));
        kuaiShouTopManEntity.setContentTypeName(doc.getString((Object)"starTagStr"));
        kuaiShouTopManEntity.setContentFormName(doc.getString((Object)"mmuStarTagStr"));
        kuaiShouTopManEntity.setIndustryName(doc.getString((Object)"industryTagStr"));
        List starTagIdsList = doc.getList((Object)"starTagIds", Object.class);
        if (starTagIdsList != null && starTagIdsList.size() > 0) {
            String starTagIds = starTagIdsList.stream().map(String::valueOf).collect(Collectors.joining());
            kuaiShouTopManEntity.setStarTagIds(starTagIds);
        }
        kuaiShouTopManEntity.setFansNum(DataFormatUtils.numberToBigDecimal(doc.get((Object)"fansNum")));
        kuaiShouTopManEntity.setFansIncreaseNum(DataFormatUtils.numberToBigDecimal(doc.get((Object)"fansIncreaseNum")));
        kuaiShouTopManEntity.setFansIncreaseRate(DataFormatUtils.numberToBigDecimal(doc.get((Object)"fansIncreaseRate")));
        kuaiShouTopManEntity.setLiveExpectCpm(DataFormatUtils.numberToBigDecimal(doc.get((Object)"liveExpectCpm")));
        kuaiShouTopManEntity.setLiveExpectViewer(DataFormatUtils.numberToBigDecimal(doc.get((Object)"liveExpectViewer")));
        kuaiShouTopManEntity.setLiveMaxViewer(DataFormatUtils.numberToBigDecimal(doc.get((Object)"liveMaxViewer")));
        kuaiShouTopManEntity.setPhotoExpectClick(DataFormatUtils.numberToBigDecimal(doc.get((Object)"photoExpectClick")));
        kuaiShouTopManEntity.setPhotoCompletePlayRate(DataFormatUtils.numberToBigDecimal(doc.get((Object)"photoCompletePlayRate")));
        kuaiShouTopManEntity.setPhotoExpectCpm(DataFormatUtils.numberToBigDecimal(doc.get((Object)"photoExpectCpm")));
        kuaiShouTopManEntity.setPhotoInteractionRate(DataFormatUtils.numberToBigDecimal(doc.get((Object)"photoInteractionRate")));
        Document liveQuotedInfo = (Document)doc.get((Object)"liveQuotedInfo", Document.class);
        kuaiShouTopManEntity.setQuoteOfLive(DataFormatUtils.numberToBigDecimal(liveQuotedInfo.get((Object)"perHour")));
        kuaiShouTopManEntity.setQuoteOfVideo(DataFormatUtils.numberToBigDecimal(doc.get((Object)"threeDaysOrderBid")));
        if (kuaiShouTopManEntity.getId() == null) {
            kuaiShouTopManEntity.setCreateTime(new Date());
            kuaiShouTopManEntity.setCreateBy("KsTopManJob");
        }
        kuaiShouTopManEntity.setUpdateBy("KsTopManJob");
        kuaiShouTopManEntity.setUpdateTime(new Date());
        kuaiShouTopManEntity.setDeleted(0);
    }
}

