/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.topman.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import com.els.common.exception.ELSBootException;
import com.els.common.util.I18nUtil;
import com.els.modules.topman.dto.BiliBiliTopManDetailDTO;
import com.els.modules.topman.dto.DouYinTopManDetailDTO;
import com.els.modules.topman.dto.KuaiShouTopManDetailDTO;
import com.els.modules.topman.dto.RedBookTopManDetailDTO;
import com.els.modules.topman.dto.TopManContrastDTO;
import com.els.modules.topman.dto.TopManContrastParamDTO;
import com.els.modules.topman.dto.ZhiHuTopManDetailDTO;
import com.els.modules.topman.enumerate.BlogTopmanGenderEnum;
import com.els.modules.topman.enumerate.BlogVerifiedTypeEnum;
import com.els.modules.topman.service.BilibiliTopManService;
import com.els.modules.topman.service.BlogTopManService;
import com.els.modules.topman.service.DouYinTopManService;
import com.els.modules.topman.service.KuaiShouTopManService;
import com.els.modules.topman.service.RedBookTopManService;
import com.els.modules.topman.service.TopManContrastService;
import com.els.modules.topman.service.ZhiHuTopManService;
import com.els.modules.topman.utils.spider.entity.BilibiliTopManPromotionAnalysisEntity;
import com.els.modules.topman.utils.spider.entity.BlogTopManFanAnalysisEntity;
import com.els.modules.topman.utils.spider.entity.BlogTopManPromotionAnalysisEntity;
import com.els.modules.topman.utils.spider.entity.BlogTopManTopDetailsEntity;
import com.els.modules.topman.utils.spider.entity.DouYinTopManFanAnalysisEntity;
import com.els.modules.topman.utils.spider.entity.DouYinTopManVideoDetailsAnalysisEntity;
import com.els.modules.topman.utils.spider.entity.KuaiShouTopManDetailBaseEntity;
import com.els.modules.topman.utils.spider.entity.KuaiShouTopManDetailFansEntity;
import com.els.modules.topman.utils.spider.entity.KuaiShouTopManDetailVideoAnalysisEntity;
import com.els.modules.topman.utils.spider.vo.KuaiShouTopManDetailHeadVO;
import com.els.modules.topman.utils.spider.vo.RedBookTopManDetailHeadVO;
import com.els.modules.topman.utils.spider.vo.TopManResultDetailBody;
import com.els.modules.topman.utils.spider.vo.TopManResultDetailBodyBase;
import com.els.modules.topman.utils.spider.vo.ZhiHuManDetailHeadVO;
import com.els.modules.topman.vo.BiliTopManContrastVO;
import com.els.modules.topman.vo.BilibiliTopManFanAnalysisVO;
import com.els.modules.topman.vo.BilibiliTopManTopDetailsVO;
import com.els.modules.topman.vo.BlogTopManContrastVO;
import com.els.modules.topman.vo.DouYinTopManContrastVO;
import com.els.modules.topman.vo.DouYinTopManFansDatasContrastVO;
import com.els.modules.topman.vo.DouYinTopManVO;
import com.els.modules.topman.vo.KuaiShouTopManContrastVO;
import com.els.modules.topman.vo.RedBookTopManContrastVO;
import com.els.modules.topman.vo.TopManContrastVO;
import com.els.modules.topman.vo.TopManDetailHeadVO;
import com.els.modules.topman.vo.ZhTopManContrastVO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TopManContrastServiceImpl
implements TopManContrastService {
    @Autowired
    private DouYinTopManService douYinTopManService;
    @Autowired
    private KuaiShouTopManService kuaiShouTopManService;
    @Autowired
    private RedBookTopManService redBookTopManService;
    @Autowired
    private BilibiliTopManService bilibiliTopManService;
    @Autowired
    private BlogTopManService blogTopManService;
    @Autowired
    private ZhiHuTopManService zhiHuTopManService;

    private DouYinTopManDetailDTO dyDtoTransfer(TopManContrastParamDTO dto) {
        DouYinTopManDetailDTO dyDTO = new DouYinTopManDetailDTO();
        dyDTO.setTopManId(dto.getTopManId());
        dyDTO.setTopManName(dto.getTopManName());
        dyDTO.setTopmanRegion(dto.getTopmanRegion());
        dyDTO.setAvatar(dto.getAvatar());
        return dyDTO;
    }

    private DouYinTopManDetailDTO dyDtoTransferNew(DouYinTopManVO dto) {
        DouYinTopManDetailDTO dyDTO = new DouYinTopManDetailDTO();
        dyDTO.setTopManId(dto.getUid());
        dyDTO.setTopManName(dto.getTopmanName());
        dyDTO.setTopmanRegion(dto.getTopmanRegion());
        dyDTO.setAvatar(dto.getAvatar());
        return dyDTO;
    }

    private KuaiShouTopManDetailDTO ksDtoTransfer(TopManContrastParamDTO dto) {
        KuaiShouTopManDetailDTO dyDTO = new KuaiShouTopManDetailDTO();
        dyDTO.setUserId(dto.getUserId());
        dyDTO.setStarId(dto.getStarId());
        dyDTO.setStarType(dto.getStarType());
        dyDTO.setTimeRangeType(1);
        return dyDTO;
    }

    private RedBookTopManDetailDTO rbDtoTransfer(TopManContrastParamDTO dto) {
        RedBookTopManDetailDTO rbDTO = new RedBookTopManDetailDTO();
        rbDTO.setUserId(dto.getTopManId());
        rbDTO.setDateType("1");
        return rbDTO;
    }

    private BiliBiliTopManDetailDTO biliDtoTransfer(TopManContrastParamDTO dto) {
        BiliBiliTopManDetailDTO biliDTO = new BiliBiliTopManDetailDTO();
        biliDTO.setStationId(dto.getStationId());
        biliDTO.setTopmanId(dto.getTopManId());
        biliDTO.setFansType(1);
        return biliDTO;
    }

    private ZhiHuTopManDetailDTO zhDtoTransfer(TopManContrastParamDTO dto) {
        ZhiHuTopManDetailDTO zhDTO = new ZhiHuTopManDetailDTO();
        zhDTO.setPlatform("6");
        zhDTO.setPuId(dto.getTopManId());
        return zhDTO;
    }

    @Override
    public TopManContrastVO dyTopManContrast(TopManContrastDTO dto) {
        DouYinTopManContrastVO vo = new DouYinTopManContrastVO();
        List<DouYinTopManVO> paramList = this.contrastDtoTransferDy(dto);
        switch (dto.getTaskType()) {
            case "baseData": {
                this.getDyBaseData(paramList, dto.getClearCache(), vo);
                break;
            }
            case "videoData": {
                this.getDyVideoData(paramList, dto.getClearCache(), vo);
                break;
            }
            case "fansDataOld": {
                this.getDyFansDataOld(paramList, dto.getClearCache(), vo);
                break;
            }
            case "fansData": {
                this.getDyFansData(paramList, dto.getClearCache(), vo);
                break;
            }
            case "goodsData": {
                this.getDyGoodsData(paramList, dto.getClearCache(), vo);
                break;
            }
            default: {
                throw new ELSBootException(I18nUtil.translate((String)"", (String)"\u672a\u627e\u5230\u8be5\u8bf7\u6c42\u7c7b\u578b"));
            }
        }
        return vo;
    }

    private void getDyGoodsData(List<DouYinTopManVO> paramList, String clearCache, DouYinTopManContrastVO vo) {
        ArrayList<TopManDetailHeadVO.TopManCoreData> goodsDatas = new ArrayList<TopManDetailHeadVO.TopManCoreData>(paramList.size());
        paramList.forEach(h -> {
            DouYinTopManDetailDTO dyDTO = this.dyDtoTransferNew((DouYinTopManVO)h);
            dyDTO.setClearCache(clearCache);
            TopManDetailHeadVO coreData = this.douYinTopManService.queryDetailHeadCore(dyDTO);
            if (coreData != null) {
                TopManDetailHeadVO.TopManCoreData topManCoreData = coreData.getTopManCoreData();
                dyDTO.setBodyType("base");
                dyDTO.setPopularizeType("1");
                dyDTO.setStatisticsDateType("30d");
                TopManResultDetailBody goodsData = this.douYinTopManService.queryDetailBody(dyDTO);
                if (topManCoreData != null && goodsData != null) {
                    TopManResultDetailBodyBase bodyBase = (TopManResultDetailBodyBase)goodsData;
                    List categoryNames = CollectionUtil.isNotEmpty(bodyBase.getCategoryAnalysisData()) ? bodyBase.getCategoryAnalysisData().stream().map(TopManResultDetailBodyBase.popularizeAnalysisEntity::getCategory).collect(Collectors.toList()) : null;
                    List brandNames = CollectionUtil.isNotEmpty(bodyBase.getBrandAnalysisData()) ? bodyBase.getBrandAnalysisData().stream().map(TopManResultDetailBodyBase.popularizeAnalysisEntity::getBrand).collect(Collectors.toList()) : null;
                    topManCoreData.setCategoryAnalysisData(CollectionUtil.isNotEmpty(categoryNames) ? StrUtil.join((CharSequence)"\u3001", categoryNames) : "-");
                    topManCoreData.setBrandAnalysisData(CollectionUtil.isNotEmpty(brandNames) ? StrUtil.join((CharSequence)"\u3001", brandNames) : "-");
                }
                if (topManCoreData != null) {
                    topManCoreData.setTopmanAvatar(h.getAvatar());
                    topManCoreData.setTopManName(h.getTopmanName());
                }
                goodsDatas.add(topManCoreData);
            }
        });
        vo.setGoodsDatas(goodsDatas);
    }

    private void getDyFansData(List<DouYinTopManVO> paramList, String clearCache, DouYinTopManContrastVO vo) {
        ArrayList<DouYinTopManFansDatasContrastVO> fansDatas = new ArrayList<DouYinTopManFansDatasContrastVO>(paramList.size());
        paramList.forEach(h -> {
            DouYinTopManDetailDTO dyDTO = this.dyDtoTransferNew((DouYinTopManVO)h);
            dyDTO.setClearCache(clearCache);
            DouYinTopManFanAnalysisEntity fansAnalysis = (DouYinTopManFanAnalysisEntity)this.douYinTopManService.queryDetailsFanAnalysis(dyDTO.getTopManId(), "0", "1");
            if (fansAnalysis != null) {
                DouYinTopManFansDatasContrastVO fansData = new DouYinTopManFansDatasContrastVO();
                List<DouYinTopManFansDatasContrastVO.Tag> gender = this.getDyFansDataTag(fansAnalysis.getGender());
                fansData.setGender(gender);
                List<DouYinTopManFansDatasContrastVO.Tag> age = this.getDyFansDataTag(fansAnalysis.getAge());
                fansData.setAge(age);
                List<DouYinTopManFansDatasContrastVO.Tag> activity = this.getDyFansDataTag(fansAnalysis.getActivity());
                fansData.setActivity(activity);
                List<DouYinTopManFansDatasContrastVO.Tag> cityLevel = this.getDyFansDataTag(fansAnalysis.getCityLevel());
                List<DouYinTopManFansDatasContrastVO.Tag> finalCityLevel = this.dataTagsSorted(cityLevel, true);
                fansData.setCityLevel(finalCityLevel);
                List<DouYinTopManFansDatasContrastVO.Tag> province = this.getDyFansDataProvinceTag(fansAnalysis.getProvince());
                fansData.setProvince(province);
                List<DouYinTopManFansDatasContrastVO.Tag> guestPrice = this.getDyFansDataTag(fansAnalysis.getGuestPrice());
                fansData.setGuestPrice(guestPrice);
                List<DouYinTopManFansDatasContrastVO.Tag> category = this.getDyFansDataTag(fansAnalysis.getCategory());
                List<DouYinTopManFansDatasContrastVO.Tag> finalCategory = this.dataTagsSorted(category, false);
                fansData.setCategory(finalCategory);
                fansData.setTopmanAvatar(h.getAvatar());
                fansData.setTopManName(h.getTopmanName());
                fansDatas.add(fansData);
            }
        });
        vo.setFansDatas(fansDatas);
    }

    private List<DouYinTopManFansDatasContrastVO.Tag> dataTagsSorted(List<DouYinTopManFansDatasContrastVO.Tag> list, boolean flag) {
        if (CollectionUtil.isEmpty(list)) {
            return list;
        }
        List<DouYinTopManFansDatasContrastVO.Tag> finalList = list.stream().sorted(Comparator.comparing(DouYinTopManFansDatasContrastVO.Tag::getY).reversed()).collect(Collectors.toList());
        if (flag && finalList.size() > 3) {
            finalList = finalList.subList(0, 3);
        }
        return finalList;
    }

    private List<DouYinTopManFansDatasContrastVO.Tag> getDyFansDataTag(DouYinTopManFanAnalysisEntity.FanCommonAttribute entity) {
        if (entity == null || CollectionUtil.isEmpty(entity.getX())) {
            return null;
        }
        List<String> x = entity.getX();
        ArrayList<DouYinTopManFansDatasContrastVO.Tag> tags = new ArrayList<DouYinTopManFansDatasContrastVO.Tag>(x.size());
        for (int i = 0; i < x.size(); ++i) {
            DouYinTopManFansDatasContrastVO.Tag tag = new DouYinTopManFansDatasContrastVO.Tag();
            tag.setX(x.get(i));
            tag.setY(entity.getY().get(i));
            tags.add(tag);
        }
        return tags;
    }

    private List<DouYinTopManFansDatasContrastVO.Tag> getDyFansDataProvinceTag(List<DouYinTopManFanAnalysisEntity.Region> list) {
        if (CollectionUtil.isEmpty(list)) {
            return null;
        }
        if (list.size() > 3) {
            list = list.subList(0, 3);
        }
        ArrayList<DouYinTopManFansDatasContrastVO.Tag> tags = new ArrayList<DouYinTopManFansDatasContrastVO.Tag>(list.size());
        list.forEach(h -> {
            DouYinTopManFansDatasContrastVO.Tag tag = new DouYinTopManFansDatasContrastVO.Tag();
            tag.setX(h.getX());
            tag.setY(h.getPercent());
            tags.add(tag);
        });
        return tags;
    }

    private void getDyFansDataOld(List<DouYinTopManVO> paramList, String clearCache, DouYinTopManContrastVO vo) {
        ArrayList<DouYinTopManFanAnalysisEntity> fansDatas = new ArrayList<DouYinTopManFanAnalysisEntity>(paramList.size());
        paramList.forEach(h -> {
            DouYinTopManDetailDTO dyDTO = this.dyDtoTransferNew((DouYinTopManVO)h);
            dyDTO.setClearCache(clearCache);
            DouYinTopManFanAnalysisEntity fansData = (DouYinTopManFanAnalysisEntity)this.douYinTopManService.queryDetailsFanAnalysis(dyDTO.getTopManId(), "0", "1");
            if (fansData != null) {
                fansData.setTopmanAvatar(h.getAvatar());
                fansData.setTopManName(h.getTopmanName());
                fansDatas.add(fansData);
            }
        });
        vo.setFansDatasOld(fansDatas);
    }

    private void getDyVideoData(List<DouYinTopManVO> paramList, String clearCache, DouYinTopManContrastVO vo) {
        ArrayList<TopManDetailHeadVO.TopManVideoData> videoDatas = new ArrayList<TopManDetailHeadVO.TopManVideoData>(paramList.size());
        ArrayList<TopManDetailHeadVO.TopManLiveData> liveDatas = new ArrayList<TopManDetailHeadVO.TopManLiveData>(paramList.size());
        for (DouYinTopManVO h : paramList) {
            DouYinTopManDetailDTO dyDTO = this.dyDtoTransferNew(h);
            dyDTO.setClearCache(clearCache);
            TopManDetailHeadVO headVO = this.douYinTopManService.queryDetailHeadCore(dyDTO);
            if (headVO == null) continue;
            TopManDetailHeadVO.TopManVideoData topManVideoData = headVO.getTopManVideoData();
            DouYinTopManVideoDetailsAnalysisEntity videoData = this.douYinTopManService.queryDetailsVideoAnalysis(dyDTO.getTopManId(), "true");
            if (topManVideoData != null) {
                DouYinTopManVideoDetailsAnalysisEntity.VideoDetails videoDetails;
                topManVideoData.setTopmanAvatar(h.getAvatar());
                topManVideoData.setTopManName(h.getTopmanName());
                topManVideoData.setVideoRate(topManVideoData.getVideoRate() != null ? topManVideoData.getVideoRate() : BigDecimal.ZERO);
                if (videoData != null && (videoDetails = videoData.getVideoDetails()) != null) {
                    topManVideoData.setCompletionRate(videoDetails.getCompletionRate() != null ? videoDetails.getCompletionRate() : BigDecimal.ZERO);
                    topManVideoData.setInteractRate(StringUtils.isNotBlank((CharSequence)videoDetails.getInteractRate()) ? videoDetails.getInteractRate() : "0");
                } else {
                    topManVideoData.setCompletionRate(BigDecimal.ZERO);
                    topManVideoData.setInteractRate("0");
                }
            }
            videoDatas.add(topManVideoData);
            TopManDetailHeadVO.TopManLiveData topManLiveData = headVO.getTopManLiveData();
            if (topManLiveData != null) {
                topManLiveData.setTopmanAvatar(h.getAvatar());
                topManLiveData.setTopManName(h.getTopmanName());
            }
            liveDatas.add(topManLiveData);
        }
        vo.setVideoDatas(videoDatas);
        vo.setLiveDatas(liveDatas);
    }

    private void getDyBaseData(List<DouYinTopManVO> paramList, String clearCache, DouYinTopManContrastVO vo) {
        ArrayList<TopManDetailHeadVO.TopManBaseData> baseDatas = new ArrayList<TopManDetailHeadVO.TopManBaseData>(paramList.size());
        paramList.forEach(h -> {
            DouYinTopManDetailDTO dyDTO = this.dyDtoTransferNew((DouYinTopManVO)h);
            dyDTO.setClearCache(clearCache);
            TopManDetailHeadVO detailHead = this.getDyHeadData(dyDTO);
            TopManDetailHeadVO.TopManBaseData topManBaseData = detailHead.getTopManBaseData();
            if (topManBaseData == null) {
                topManBaseData = new TopManDetailHeadVO.TopManBaseData();
            }
            this.topManBaseDataConverter((DouYinTopManVO)h, topManBaseData);
            topManBaseData.setGoodsWom(StringUtils.isNotBlank((CharSequence)topManBaseData.getGoodsWom()) ? topManBaseData.getGoodsWom() : "-");
            topManBaseData.setCreditScore(topManBaseData.getCreditScore() != null ? topManBaseData.getCreditScore() : BigDecimal.ZERO);
            topManBaseData.setAgency(StringUtils.isNotBlank((CharSequence)topManBaseData.getAgency()) ? topManBaseData.getAgency() : "\u672a\u7b7e\u7ea6");
            topManBaseData.setIntroduction(StringUtils.isNotBlank((CharSequence)topManBaseData.getIntroduction()) ? topManBaseData.getIntroduction() : "\u6682\u65e0");
            baseDatas.add(topManBaseData);
        });
        vo.setBaseDatas(baseDatas);
    }

    private void topManBaseDataConverter(DouYinTopManVO h, TopManDetailHeadVO.TopManBaseData topManBaseData) {
        topManBaseData.setTopManId(h.getTopManId());
        topManBaseData.setTopmanAvatar(h.getAvatar());
        topManBaseData.setTopManName(h.getTopmanName());
        topManBaseData.setTopManLevel(h.getTopmanLevel());
        topManBaseData.setTopManSex(h.getTopmanGender());
        topManBaseData.setTopManRegion(h.getTopmanRegion());
        topManBaseData.setFansNum(h.getFansNum().toPlainString());
    }

    private TopManDetailHeadVO getDyHeadData(DouYinTopManDetailDTO dyDTO) {
        try {
            TopManDetailHeadVO detailHead = this.douYinTopManService.detailHead(dyDTO);
            if (detailHead != null) {
                return detailHead;
            }
            return new TopManDetailHeadVO();
        }
        catch (Exception e) {
            return new TopManDetailHeadVO();
        }
    }

    @Override
    public TopManContrastVO ksTopManContrast(TopManContrastDTO dto) {
        KuaiShouTopManContrastVO vo = new KuaiShouTopManContrastVO();
        List<TopManContrastParamDTO> paramList = this.contrastDtoTransfer(dto);
        switch (dto.getTaskType()) {
            case "baseData": {
                this.getKsBaseData(paramList, dto.getClearCache(), vo);
                break;
            }
            case "videoData": {
                this.getKsVideoData(paramList, dto.getClearCache(), vo);
                break;
            }
            case "fansData": {
                this.getKsFansData(paramList, dto.getClearCache(), vo);
                break;
            }
            case "goodsData": {
                this.getKsGoodsData(paramList, dto.getClearCache(), vo);
                break;
            }
            default: {
                throw new ELSBootException(I18nUtil.translate((String)"", (String)"\u672a\u627e\u5230\u8be5\u8bf7\u6c42\u7c7b\u578b"));
            }
        }
        return vo;
    }

    private void getKsGoodsData(List<TopManContrastParamDTO> paramList, String clearCache, KuaiShouTopManContrastVO vo) {
        ArrayList<KuaiShouTopManDetailBaseEntity.KeyData> goodsDatas = new ArrayList<KuaiShouTopManDetailBaseEntity.KeyData>(paramList.size());
        for (TopManContrastParamDTO h : paramList) {
            KuaiShouTopManDetailDTO ksDTO = this.ksDtoTransfer(h);
            ksDTO.setClearCache(clearCache);
            KuaiShouTopManDetailHeadVO detailHead = this.getKsHeadData(ksDTO);
            KuaiShouTopManDetailBaseEntity goodsData = this.kuaiShouTopManService.getDetailBodyBase(ksDTO);
            if (goodsData == null) continue;
            KuaiShouTopManDetailBaseEntity.KeyData keyData = goodsData.getKeyData();
            KuaiShouTopManDetailBaseEntity.CommerceCapacity commerceCapacity = goodsData.getCommerceCapacity();
            if (keyData != null && commerceCapacity != null) {
                KuaiShouTopManDetailHeadVO.CoreData coreData;
                List channelNames = CollectionUtil.isNotEmpty(commerceCapacity.getHotSaleChannelInfo()) ? commerceCapacity.getHotSaleChannelInfo().stream().map(KuaiShouTopManDetailBaseEntity.HotSaleChannelInfo::getHotSaleChannelName).collect(Collectors.toList()) : null;
                List brandNames = CollectionUtil.isNotEmpty(commerceCapacity.getHotSaleBrandInfo()) ? commerceCapacity.getHotSaleBrandInfo().stream().map(KuaiShouTopManDetailBaseEntity.HotSaleBrandInfo::getHotSaleBrandTitle).collect(Collectors.toList()) : null;
                keyData.setHotSaleChannelInfo(CollectionUtil.isNotEmpty(channelNames) ? StrUtil.join((CharSequence)"\u3001", channelNames) : "-");
                keyData.setHotSaleBrandInfo(CollectionUtil.isNotEmpty(brandNames) ? StrUtil.join((CharSequence)"\u3001", brandNames) : "-");
                KuaiShouTopManDetailHeadVO.StarProfileDict starProfileDict = detailHead.getStarProfileDict();
                if (starProfileDict != null) {
                    keyData.setHeadUrl(starProfileDict.getHeadUrl());
                    keyData.setName(starProfileDict.getName());
                }
                if ((coreData = detailHead.getCoreData()) != null) {
                    keyData.setPromoteItemCount(coreData.getPromoteItemCount() != null ? coreData.getPromoteItemCount().toPlainString() : "-");
                }
            }
            goodsDatas.add(keyData);
        }
        vo.setGoodsDatas(goodsDatas);
    }

    private void getKsFansData(List<TopManContrastParamDTO> paramList, String clearCache, KuaiShouTopManContrastVO vo) {
        ArrayList<KuaiShouTopManDetailFansEntity> fansDatas = new ArrayList<KuaiShouTopManDetailFansEntity>(paramList.size());
        paramList.forEach(h -> {
            KuaiShouTopManDetailDTO ksDTO = this.ksDtoTransfer((TopManContrastParamDTO)h);
            ksDTO.setClearCache(clearCache);
            KuaiShouTopManDetailHeadVO detailHead = this.getKsHeadData(ksDTO);
            KuaiShouTopManDetailFansEntity fansData = this.kuaiShouTopManService.getDetailBodyFans(ksDTO);
            if (fansData != null) {
                KuaiShouTopManDetailHeadVO.StarProfileDict starProfileDict = detailHead.getStarProfileDict();
                if (starProfileDict != null) {
                    fansData.setHeadUrl(starProfileDict.getHeadUrl());
                    fansData.setName(starProfileDict.getName());
                }
                fansDatas.add(fansData);
            }
        });
        vo.setFansDatas(fansDatas);
    }

    private void getKsVideoData(List<TopManContrastParamDTO> paramList, String clearCache, KuaiShouTopManContrastVO vo) {
        ArrayList<KuaiShouTopManDetailHeadVO.VideoResponse> videoDatas = new ArrayList<KuaiShouTopManDetailHeadVO.VideoResponse>(paramList.size());
        ArrayList<KuaiShouTopManDetailHeadVO.LiveResponse> liveDatas = new ArrayList<KuaiShouTopManDetailHeadVO.LiveResponse>(paramList.size());
        paramList.forEach(h -> {
            KuaiShouTopManDetailHeadVO.StarProfileDict starProfileDict;
            KuaiShouTopManDetailDTO ksDTO = this.ksDtoTransfer((TopManContrastParamDTO)h);
            ksDTO.setClearCache(clearCache);
            KuaiShouTopManDetailHeadVO detailHead = this.getKsHeadData(ksDTO);
            KuaiShouTopManDetailVideoAnalysisEntity videoDataNew = this.kuaiShouTopManService.getDetailBodyVideoNew(ksDTO);
            if (videoDataNew != null) {
                KuaiShouTopManDetailHeadVO.VideoResponse videoResponse = detailHead.getVideoResponse();
                starProfileDict = detailHead.getStarProfileDict();
                KuaiShouTopManDetailVideoAnalysisEntity.StarWorkReport starWorkReport = videoDataNew.getStarWorkReport();
                if (videoResponse != null && starProfileDict != null) {
                    videoResponse.setExpectedCpe(starProfileDict.getExpectedCpe());
                    videoResponse.setHeadUrl(starProfileDict.getHeadUrl());
                    videoResponse.setName(starProfileDict.getName());
                }
                if (videoResponse != null && starWorkReport != null) {
                    videoResponse.setPphotoCntData(starWorkReport.getPphotoCntData().get("30"));
                    videoResponse.setPplayMedianData(starWorkReport.getPplayMedianData().get("30"));
                    videoResponse.setPcompletePlayRateData(starWorkReport.getPcompletePlayRateData().get("30"));
                    videoResponse.setPhotoInteractionRateData(starWorkReport.getPhotoInteractionRateData().get("30"));
                }
                videoDatas.add(videoResponse);
            }
            KuaiShouTopManDetailHeadVO.LiveResponse liveResponse = detailHead.getLiveResponse();
            starProfileDict = detailHead.getStarProfileDict();
            if (liveResponse != null && starProfileDict != null) {
                liveResponse.setHeadUrl(starProfileDict.getHeadUrl());
                liveResponse.setName(starProfileDict.getName());
            }
            liveDatas.add(liveResponse);
        });
        vo.setVideoDatas(videoDatas);
        vo.setLiveDatas(liveDatas);
    }

    private void getKsBaseData(List<TopManContrastParamDTO> paramList, String clearCache, KuaiShouTopManContrastVO vo) {
        ArrayList<KuaiShouTopManDetailHeadVO.StarProfileDict> baseDatas = new ArrayList<KuaiShouTopManDetailHeadVO.StarProfileDict>(paramList.size());
        paramList.forEach(h -> {
            KuaiShouTopManDetailDTO ksDTO = this.ksDtoTransfer((TopManContrastParamDTO)h);
            ksDTO.setClearCache(clearCache);
            KuaiShouTopManDetailHeadVO detailHead = this.getKsHeadData(ksDTO);
            KuaiShouTopManDetailHeadVO.StarProfileDict starProfileDict = detailHead.getStarProfileDict();
            if (starProfileDict != null) {
                starProfileDict.setGovName(StringUtils.isNotBlank((CharSequence)starProfileDict.getGovName()) ? starProfileDict.getGovName() : "\u672a\u7b7e\u7ea6");
                if (h.getStarType() == 4) {
                    String perHour = starProfileDict.getLiveQuotedInfo() != null ? starProfileDict.getLiveQuotedInfo().getPerHour().divide(new BigDecimal(1000), 4).toPlainString() : "-";
                    starProfileDict.setPromotionPrice("\u76f4\u64ad\u62a5\u4ef7\uff1a\uffe5" + perHour + "/\u5c0f\u65f6");
                } else {
                    String perHour = starProfileDict.getOrderBid() != null ? starProfileDict.getOrderBid().divide(new BigDecimal(1000), 4).toPlainString() : "-";
                    starProfileDict.setPromotionPrice("\u89c6\u9891\u62a5\u4ef7\uff1a\uffe5" + perHour + "/\u4e2a");
                }
                if (starProfileDict.getHidePrice().booleanValue()) {
                    starProfileDict.setPromotionPrice("\u6309\u534f\u8bae\u4ef7");
                }
            }
            baseDatas.add(starProfileDict);
        });
        vo.setBaseDatas(baseDatas);
    }

    private KuaiShouTopManDetailHeadVO getKsHeadData(KuaiShouTopManDetailDTO ksDTO) {
        KuaiShouTopManDetailHeadVO detailHead = this.kuaiShouTopManService.getDetailHeadNew(ksDTO);
        if (detailHead != null) {
            return detailHead;
        }
        return new KuaiShouTopManDetailHeadVO();
    }

    @Override
    public TopManContrastVO rbTopManContrast(TopManContrastDTO dto) {
        RedBookTopManContrastVO vo = new RedBookTopManContrastVO();
        List<TopManContrastParamDTO> paramList = this.contrastDtoTransfer(dto);
        switch (dto.getTaskType()) {
            case "baseData": {
                this.getRbBaseData(paramList, dto.getClearCache(), vo);
                break;
            }
            case "fansData": {
                this.getRbFansData(paramList, dto.getClearCache(), vo);
                break;
            }
            case "goodsData": {
                this.getRbGoodsData(paramList, dto.getClearCache(), vo);
                break;
            }
            default: {
                throw new ELSBootException(I18nUtil.translate((String)"", (String)"\u672a\u627e\u5230\u8be5\u8bf7\u6c42\u7c7b\u578b"));
            }
        }
        return vo;
    }

    private void getRbGoodsData(List<TopManContrastParamDTO> paramList, String clearCache, RedBookTopManContrastVO vo) {
        ArrayList<RedBookTopManDetailHeadVO.Sales> goodsDatas = new ArrayList<RedBookTopManDetailHeadVO.Sales>(paramList.size());
        paramList.forEach(h -> {
            RedBookTopManDetailDTO rbDTO = this.rbDtoTransfer((TopManContrastParamDTO)h);
            rbDTO.setClearCache(clearCache);
            RedBookTopManDetailHeadVO detailHead = this.getRbHeadData(rbDTO);
            RedBookTopManDetailHeadVO goodsData = this.redBookTopManService.getDetailLiveSales(rbDTO);
            if (goodsData != null) {
                RedBookTopManDetailHeadVO.Sales sales = goodsData.getSales();
                RedBookTopManDetailHeadVO.DetailHead baseData = detailHead.getDetailHead();
                List<RedBookTopManDetailHeadVO.Sales.Category> rgmvCategorys = sales.getRgmvCategory();
                if (CollectionUtil.isNotEmpty(rgmvCategorys)) {
                    rgmvCategorys = rgmvCategorys.size() > 3 ? rgmvCategorys.subList(0, 3) : rgmvCategorys;
                    List categoryNames = rgmvCategorys.stream().map(RedBookTopManDetailHeadVO.Sales.Category::getCategoryName).collect(Collectors.toList());
                    sales.setCategories(CollectionUtil.isNotEmpty(categoryNames) ? StrUtil.join((CharSequence)"\u3001", categoryNames) : "-");
                }
                if (baseData != null) {
                    sales.setHeadPhoto(baseData.getHeadPhoto());
                    sales.setName(baseData.getName());
                }
                goodsDatas.add(sales);
            }
        });
        vo.setGoodsDatas(goodsDatas);
    }

    private void getRbFansData(List<TopManContrastParamDTO> paramList, String clearCache, RedBookTopManContrastVO vo) {
        ArrayList<RedBookTopManDetailHeadVO.FansData> fansDatas = new ArrayList<RedBookTopManDetailHeadVO.FansData>(paramList.size());
        paramList.forEach(h -> {
            RedBookTopManDetailDTO rbDTO = this.rbDtoTransfer((TopManContrastParamDTO)h);
            rbDTO.setClearCache(clearCache);
            RedBookTopManDetailHeadVO detailHead = this.getRbHeadData(rbDTO);
            RedBookTopManDetailHeadVO fansData = this.redBookTopManService.getDetailFans(rbDTO);
            if (fansData != null) {
                RedBookTopManDetailHeadVO.FansData fans = fansData.getFansData();
                RedBookTopManDetailHeadVO.DetailHead baseData = detailHead.getDetailHead();
                if (fans != null && baseData != null) {
                    fans.setHeadPhoto(baseData.getHeadPhoto());
                    fans.setName(baseData.getName());
                }
                fansDatas.add(fans);
            }
        });
        vo.setFansDatas(fansDatas);
    }

    private void getRbBaseData(List<TopManContrastParamDTO> paramList, String clearCache, RedBookTopManContrastVO vo) {
        ArrayList<RedBookTopManDetailHeadVO.DetailHead> baseDatas = new ArrayList<RedBookTopManDetailHeadVO.DetailHead>(paramList.size());
        ArrayList<RedBookTopManDetailHeadVO.NotesData> noteDatas = new ArrayList<RedBookTopManDetailHeadVO.NotesData>(paramList.size());
        ArrayList<RedBookTopManDetailHeadVO.LivesData> liveDatas = new ArrayList<RedBookTopManDetailHeadVO.LivesData>(paramList.size());
        paramList.forEach(h -> {
            RedBookTopManDetailDTO rbDTO = this.rbDtoTransfer((TopManContrastParamDTO)h);
            rbDTO.setClearCache(clearCache);
            RedBookTopManDetailHeadVO detailHead = this.getRbHeadData(rbDTO);
            RedBookTopManDetailHeadVO.DetailHead baseData = detailHead.getDetailHead();
            RedBookTopManDetailHeadVO detailPromotion = this.redBookTopManService.getDetailPromotion(rbDTO);
            if (baseData != null && detailPromotion != null) {
                RedBookTopManDetailHeadVO.Promotion promotion = detailPromotion.getPromotion();
                baseData.setMcnName(baseData.getNoteSign() != null && StringUtils.isNotBlank((CharSequence)baseData.getNoteSign().getName()) ? baseData.getNoteSign().getName() : "\u672a\u7b7e\u7ea6");
                String picturePrice = StrUtil.format((CharSequence)"\u56fe\u6587\u7b14\u8bb0\uff1a{}\uff0c", (Object[])new Object[]{promotion.getPicturePrice() != null ? "\uffe5" + promotion.getPicturePrice() : "-"});
                String videoPrice = StrUtil.format((CharSequence)"\u89c6\u9891\u7b14\u8bb0\uff1a{}", (Object[])new Object[]{promotion.getVideoPrice() != null ? "\uffe5" + promotion.getVideoPrice() : "-"});
                baseData.setPromotionPrice(picturePrice + videoPrice);
                String pictureReadCost = StrUtil.format((CharSequence)"\u56fe\u6587\u7b14\u8bb0\uff1a{}\uff0c", (Object[])new Object[]{promotion.getPictureReadCost() != null ? StrUtil.format((CharSequence)"\uffe5{}/\u9605\u8bfb", (Object[])new Object[]{promotion.getPictureReadCost()}) : "-"});
                String videoReadCost = StrUtil.format((CharSequence)"\u89c6\u9891\u7b14\u8bb0\uff1a{}", (Object[])new Object[]{promotion.getVideoReadCost() != null ? StrUtil.format((CharSequence)"\uffe5{}/\u9605\u8bfb", (Object[])new Object[]{promotion.getVideoReadCost()}) : "-"});
                baseData.setPictureReadPrice(pictureReadCost + videoReadCost);
            }
            baseDatas.add(baseData);
            RedBookTopManDetailHeadVO.NotesData notesData = detailHead.getNotesData();
            RedBookTopManDetailHeadVO.CoreData coreData = detailHead.getCoreData();
            if (notesData != null && coreData != null) {
                notesData.setTotalNoteCount(coreData.getTotalNoteCount());
                notesData.setLikeCollectCountInfo(coreData.getLikeCollectCountInfo());
            }
            if (notesData != null && baseData != null) {
                notesData.setHeadPhoto(baseData.getHeadPhoto());
                notesData.setName(baseData.getName());
            }
            noteDatas.add(notesData);
            RedBookTopManDetailHeadVO.LivesData livesData = detailHead.getLivesData();
            if (livesData != null && baseData != null) {
                livesData.setHeadPhoto(baseData.getHeadPhoto());
                livesData.setName(baseData.getName());
            }
            liveDatas.add(livesData);
        });
        vo.setBaseDatas(baseDatas);
        vo.setNoteDatas(noteDatas);
        vo.setLiveDatas(liveDatas);
    }

    private RedBookTopManDetailHeadVO getRbHeadData(RedBookTopManDetailDTO rbDTO) {
        RedBookTopManDetailHeadVO detailHead = this.redBookTopManService.getDetailHead(rbDTO);
        if (detailHead != null) {
            return detailHead;
        }
        return new RedBookTopManDetailHeadVO();
    }

    @Override
    public TopManContrastVO biliTopManContrast(TopManContrastDTO dto) {
        BiliTopManContrastVO vo = new BiliTopManContrastVO();
        List<TopManContrastParamDTO> paramList = this.contrastDtoTransfer(dto);
        switch (dto.getTaskType()) {
            case "baseData": {
                this.getBiliBaseData(paramList, dto.getClearCache(), vo);
                break;
            }
            case "fansData": {
                this.getBiliFansData(paramList, dto.getClearCache(), vo);
                break;
            }
            default: {
                throw new ELSBootException(I18nUtil.translate((String)"", (String)"\u672a\u627e\u5230\u8be5\u8bf7\u6c42\u7c7b\u578b"));
            }
        }
        return vo;
    }

    private void getBiliFansData(List<TopManContrastParamDTO> paramList, String clearCache, BiliTopManContrastVO vo) {
        ArrayList<BilibiliTopManFanAnalysisVO> fansDatas = new ArrayList<BilibiliTopManFanAnalysisVO>(paramList.size());
        paramList.forEach(h -> {
            BiliBiliTopManDetailDTO biliDTO = this.biliDtoTransfer((TopManContrastParamDTO)h);
            biliDTO.setClearCache(clearCache);
            BilibiliTopManFanAnalysisVO fansData = this.bilibiliTopManService.topManFanAnalysisFanDetails(biliDTO);
            if (fansData != null) {
                BilibiliTopManTopDetailsVO baseData = this.bilibiliTopManService.topManDetails(biliDTO);
                if (baseData != null && baseData.getTopManInfo() != null) {
                    BilibiliTopManTopDetailsVO.TopManInfo topManInfo = baseData.getTopManInfo();
                    fansData.setTopmanAvatar(topManInfo.getTopmanAvatar());
                    fansData.setTopmanName(topManInfo.getTopmanName());
                }
                fansDatas.add(fansData);
            }
        });
        vo.setFansDatas(fansDatas);
    }

    private void getBiliBaseData(List<TopManContrastParamDTO> paramList, String clearCache, BiliTopManContrastVO vo) {
        ArrayList<BilibiliTopManTopDetailsVO.TopManInfo> baseDatas = new ArrayList<BilibiliTopManTopDetailsVO.TopManInfo>(paramList.size());
        ArrayList<BilibiliTopManTopDetailsVO.TopManVideoData> videoDatas = new ArrayList<BilibiliTopManTopDetailsVO.TopManVideoData>(paramList.size());
        ArrayList<BilibiliTopManTopDetailsVO.TopManLiveData> liveDatas = new ArrayList<BilibiliTopManTopDetailsVO.TopManLiveData>(paramList.size());
        paramList.forEach(h -> {
            BiliBiliTopManDetailDTO biliDTO = this.biliDtoTransfer((TopManContrastParamDTO)h);
            biliDTO.setClearCache(clearCache);
            BilibiliTopManTopDetailsVO baseData = this.bilibiliTopManService.topManDetails(biliDTO);
            BilibiliTopManTopDetailsVO liveInfo = this.bilibiliTopManService.topManDetailsLiveInfo(biliDTO);
            if (baseData != null) {
                BilibiliTopManTopDetailsVO.TopManInfo topManInfo = baseData.getTopManInfo();
                List<BilibiliTopManPromotionAnalysisEntity> promotions = this.bilibiliTopManService.bStationTopManPromotionAnalysisDetails(h.getStationId(), h.getTopManId());
                if (topManInfo != null && CollectionUtil.isNotEmpty(promotions)) {
                    List prices = promotions.stream().map(j -> StrUtil.format((CharSequence)"{}\uff1a\uffe5{}", (Object[])new Object[]{j.getQuotationType(), j.getPrice()})).collect(Collectors.toList());
                    String promotionPrice = StrUtil.join((CharSequence)"\uff0c", prices);
                    topManInfo.setPromotionPrice(promotionPrice);
                }
                if (topManInfo != null) {
                    topManInfo.setAuthentication(StringUtils.isNotBlank((CharSequence)topManInfo.getAuthentication()) ? topManInfo.getAuthentication() : "-");
                    topManInfo.setMcnCompanyName(StringUtils.isNotBlank((CharSequence)topManInfo.getMcnCompanyName()) ? topManInfo.getMcnCompanyName() : "-");
                }
                baseDatas.add(topManInfo);
                BilibiliTopManTopDetailsVO.TopManVideoData topManVideoData = baseData.getTopManVideoData();
                BilibiliTopManTopDetailsVO.TopManCoreData topManCoreData = baseData.getTopManCoreData();
                if (topManVideoData != null && topManCoreData != null) {
                    topManVideoData.setVideoNum(topManCoreData.getVideoNum());
                    topManVideoData.setLikeNum(topManCoreData.getLikeNum());
                    topManVideoData.setPlayNum(topManCoreData.getPlayNum());
                }
                if (topManVideoData != null && topManInfo != null) {
                    topManVideoData.setTopmanAvatar(topManInfo.getTopmanAvatar());
                    topManVideoData.setTopmanName(topManInfo.getTopmanName());
                }
                videoDatas.add(topManVideoData);
                if (liveInfo != null) {
                    BilibiliTopManTopDetailsVO.TopManLiveData topManLiveData = liveInfo.getTopManLiveData();
                    if (topManLiveData != null && topManInfo != null) {
                        topManLiveData.setTopmanAvatar(topManInfo.getTopmanAvatar());
                        topManLiveData.setTopmanName(topManInfo.getTopmanName());
                        topManInfo.setAuthentication(StringUtils.isNotBlank((CharSequence)topManInfo.getAuthentication()) ? topManInfo.getAuthentication() : "-");
                    }
                    liveDatas.add(topManLiveData);
                }
            }
        });
        vo.setBaseDatas(baseDatas);
        vo.setVideoDatas(videoDatas);
        vo.setLiveDatas(liveDatas);
    }

    @Override
    public TopManContrastVO blogTopManContrast(TopManContrastDTO dto) {
        BlogTopManContrastVO vo = new BlogTopManContrastVO();
        List<TopManContrastParamDTO> paramList = this.contrastDtoTransfer(dto);
        switch (dto.getTaskType()) {
            case "baseData": {
                this.getBlogBaseData(paramList, vo);
                break;
            }
            case "fansData": {
                this.getBlogFansData(paramList, vo);
                break;
            }
            default: {
                throw new ELSBootException(I18nUtil.translate((String)"", (String)"\u672a\u627e\u5230\u8be5\u8bf7\u6c42\u7c7b\u578b"));
            }
        }
        return vo;
    }

    private void getBlogFansData(List<TopManContrastParamDTO> paramList, BlogTopManContrastVO vo) {
        ArrayList<BlogTopManFanAnalysisEntity> fansDatas = new ArrayList<BlogTopManFanAnalysisEntity>(paramList.size());
        paramList.forEach(h -> {
            BlogTopManFanAnalysisEntity fansData = this.blogTopManService.blogTopManFanAnalysisDetails(h.getTopManId());
            if (fansData != null) {
                BlogTopManTopDetailsEntity baseData = this.blogTopManService.blogTopManDetails(h.getTopManId());
                if (baseData != null && baseData.getTopManInfo() != null) {
                    BlogTopManTopDetailsEntity.TopManInfo topManInfo = baseData.getTopManInfo();
                    fansData.setTopmanAvatar(topManInfo.getTopmanAvatar());
                    fansData.setTopmanName(topManInfo.getTopmanName());
                }
                fansDatas.add(fansData);
            }
        });
        vo.setFansDatas(fansDatas);
    }

    private void getBlogBaseData(List<TopManContrastParamDTO> paramList, BlogTopManContrastVO vo) {
        ArrayList<BlogTopManTopDetailsEntity.TopManInfo> baseDatas = new ArrayList<BlogTopManTopDetailsEntity.TopManInfo>(paramList.size());
        ArrayList<BlogTopManTopDetailsEntity.TopManCoreData> coreDatas = new ArrayList<BlogTopManTopDetailsEntity.TopManCoreData>(paramList.size());
        paramList.forEach(h -> {
            BlogTopManTopDetailsEntity baseData = this.blogTopManService.blogTopManDetails(h.getTopManId());
            if (baseData != null) {
                BlogTopManTopDetailsEntity.TopManInfo topManInfo = baseData.getTopManInfo();
                BlogTopManPromotionAnalysisEntity promotion = this.blogTopManService.blogTopManInformationPromotionAnalysis(h.getTopManId());
                if (topManInfo != null && promotion != null && CollectionUtil.isNotEmpty(promotion.getPrice())) {
                    List prices = promotion.getPrice().stream().map(j -> StrUtil.format((CharSequence)"{}\uff1a\uffe5{}", (Object[])new Object[]{j.getPriceType(), j.getPrice()})).collect(Collectors.toList());
                    topManInfo.setPromotionPrice(CollectionUtil.isNotEmpty(prices) ? StrUtil.join((CharSequence)"\uff0c", prices) : "-");
                }
                if (topManInfo != null) {
                    topManInfo.setTopmanGender(StringUtils.isNotEmpty((CharSequence)topManInfo.getTopmanGender()) ? BlogTopmanGenderEnum.getDesc(topManInfo.getTopmanGender()) : "-");
                    topManInfo.setVerifiedReason(StringUtils.isNotEmpty((CharSequence)topManInfo.getVerifiedReason()) ? topManInfo.getVerifiedReason() : "-");
                    topManInfo.setVerifiedType(StringUtils.isNotEmpty((CharSequence)topManInfo.getVerifiedTypeExt()) ? BlogVerifiedTypeEnum.getDesc(topManInfo.getVerifiedTypeExt()) : "-");
                    topManInfo.setPartner(StringUtils.isNotEmpty((CharSequence)topManInfo.getPartner()) ? BlogVerifiedTypeEnum.getDesc(topManInfo.getPartner()) : "\u672a\u7b7e\u7ea6");
                }
                baseDatas.add(baseData.getTopManInfo());
                BlogTopManTopDetailsEntity.TopManCoreData coreData = baseData.getTopManCoreData();
                if (coreData != null && topManInfo != null) {
                    coreData.setTopmanAvatar(topManInfo.getTopmanAvatar());
                    coreData.setTopmanName(topManInfo.getTopmanName());
                }
                coreDatas.add(coreData);
            }
        });
        vo.setBaseDatas(baseDatas);
        vo.setCoreDatas(coreDatas);
    }

    @Override
    public TopManContrastVO zhTopManContrast(TopManContrastDTO dto) {
        ZhTopManContrastVO vo = new ZhTopManContrastVO();
        List<TopManContrastParamDTO> paramList = this.contrastDtoTransfer(dto);
        ArrayList<ZhiHuManDetailHeadVO.DetailHead> baseDatas = new ArrayList<ZhiHuManDetailHeadVO.DetailHead>(dto.getParamList().size());
        ArrayList<ZhiHuManDetailHeadVO.CoreData> coreDatas = new ArrayList<ZhiHuManDetailHeadVO.CoreData>(dto.getParamList().size());
        ArrayList<ZhiHuManDetailHeadVO.FansData.PuFollower> fansDatas = new ArrayList<ZhiHuManDetailHeadVO.FansData.PuFollower>(dto.getParamList().size());
        for (TopManContrastParamDTO h : paramList) {
            ZhiHuTopManDetailDTO zhDTO = this.zhDtoTransfer(h);
            zhDTO.setClearCache(dto.getClearCache());
            ZhiHuManDetailHeadVO detailHead = this.zhiHuTopManService.getDetailHead(zhDTO);
            if (detailHead == null) {
                return vo;
            }
            ZhiHuManDetailHeadVO.DetailHead baseData = detailHead.getDetailHead();
            if (baseData != null) {
                List<String> promotionPrice = this.getZhPromotionPrice(detailHead.getPromotionData());
                baseData.setPromotionPrice(promotionPrice);
            }
            baseDatas.add(baseData);
            ZhiHuManDetailHeadVO.CoreData coreData = detailHead.getCoreData();
            if (coreData != null && baseData != null) {
                coreData.setAvatarPath(baseData.getAvatarPath());
                coreData.setName(baseData.getName());
            }
            coreDatas.add(coreData);
            ZhiHuManDetailHeadVO.FansData fansData = detailHead.getFansData();
            if (fansData == null || fansData.getPuFollower() == null) continue;
            ZhiHuManDetailHeadVO.FansData.PuFollower puFollower = fansData.getPuFollower();
            if (baseData != null) {
                puFollower.setAvatarPath(baseData.getAvatarPath());
                puFollower.setName(baseData.getName());
            }
            fansDatas.add(puFollower);
        }
        vo.setBaseDatas(baseDatas);
        vo.setCoreDatas(coreDatas);
        vo.setFansDatas(fansDatas);
        return vo;
    }

    private List<String> getZhPromotionPrice(ZhiHuManDetailHeadVO.PromotionData promotionData) {
        ArrayList<String> list = new ArrayList<String>(1);
        list.add("-");
        if (promotionData == null) {
            return list;
        }
        List<ZhiHuManDetailHeadVO.PromotionData.Offer> offers = promotionData.getOffer();
        if (CollectionUtil.isEmpty(offers) || offers.get(0) == null) {
            return list;
        }
        return offers.stream().map(this::promotionPriceConverter).collect(Collectors.toList());
    }

    private String promotionPriceConverter(ZhiHuManDetailHeadVO.PromotionData.Offer offer) {
        String promotionPrice = "";
        BigDecimal finalOrderPrice = null;
        Integer orderPrice = offer.getOrderPrice();
        if (orderPrice != null) {
            finalOrderPrice = new BigDecimal(orderPrice).divide(new BigDecimal(100), 2, 4);
        }
        if (offer.getOrderType() == 1) {
            promotionPrice = finalOrderPrice != null ? StrUtil.format((CharSequence)"\u56de\u7b54&\u6587\u7ae0\uff1a\uffe5{}", (Object[])new Object[]{finalOrderPrice}) : "";
        } else if (offer.getOrderSecondType() == 1) {
            promotionPrice = finalOrderPrice != null ? StrUtil.format((CharSequence)"\u89c6\u9891-\u811a\u672c\u64b0\u5199\uff1a\uffe5{}", (Object[])new Object[]{finalOrderPrice}) : "";
        } else {
            if (offer.getOrderThirdType() == 1) {
                String string = promotionPrice = finalOrderPrice != null ? StrUtil.format((CharSequence)"\u89c6\u9891-\u5168\u7247\u5b9a\u52361-3min\uff1a\uffe5{}", (Object[])new Object[]{finalOrderPrice}) : "";
            }
            if (offer.getOrderThirdType() == 2) {
                String string = promotionPrice = finalOrderPrice != null ? StrUtil.format((CharSequence)"\u89c6\u9891-\u5168\u7247\u5b9a\u52363-5min\uff1a\uffe5{}", (Object[])new Object[]{finalOrderPrice}) : "";
            }
            if (offer.getOrderThirdType() == 3) {
                String string = promotionPrice = finalOrderPrice != null ? StrUtil.format((CharSequence)"\u89c6\u9891-\u5168\u7247\u5b9a\u52365-10min\uff1a\uffe5{}", (Object[])new Object[]{finalOrderPrice}) : "";
            }
            if (offer.getOrderThirdType() == 4) {
                promotionPrice = finalOrderPrice != null ? StrUtil.format((CharSequence)"\u89c6\u9891-\u5168\u7247\u5b9a\u523610min\u4ee5\u4e0a\uff1a\uffe5{}", (Object[])new Object[]{finalOrderPrice}) : "";
            }
        }
        return promotionPrice;
    }

    private List<TopManContrastParamDTO> contrastDtoTransfer(TopManContrastDTO dto) {
        if (dto == null || CollectionUtil.isEmpty(dto.getParamList())) {
            throw new RuntimeException(I18nUtil.translate((String)"", (String)"\u53c2\u6570\u9519\u8bef"));
        }
        List<TopManContrastParamDTO> paramList = dto.getParamList();
        if (paramList.size() > 3) {
            paramList = paramList.subList(0, 3);
        }
        return paramList;
    }

    private List<DouYinTopManVO> contrastDtoTransferDy(TopManContrastDTO dto) {
        if (dto == null || CollectionUtil.isEmpty(dto.getDataList())) {
            throw new RuntimeException(I18nUtil.translate((String)"", (String)"\u53c2\u6570\u9519\u8bef"));
        }
        List<DouYinTopManVO> paramList = dto.getDataList();
        if (paramList.size() > 3) {
            paramList = paramList.subList(0, 3);
        }
        return paramList;
    }
}

