/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.topman.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.els.common.adapter.AdapterFactory;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.constant.CommonConstant;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.I18nUtil;
import com.els.common.util.RedisUtil;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.system.service.DictService;
import com.els.modules.topman.adapter.msg.ITopManMessageAdapter;
import com.els.modules.topman.dto.TopManMsgCaptchaDto;
import com.els.modules.topman.dto.TopmanMsgRqDto;
import com.els.modules.topman.dto.TopmanMsgTaskDto;
import com.els.modules.topman.entity.TopManMsgConfig;
import com.els.modules.topman.entity.TopManMsgRecord;
import com.els.modules.topman.entity.TopManMsgRecordHis;
import com.els.modules.topman.entity.TopManMsgTask;
import com.els.modules.topman.enumerate.MsgTopManSourceEnum;
import com.els.modules.topman.enumerate.MsgTypeEnum;
import com.els.modules.topman.mapper.TopManMsgTaskMapper;
import com.els.modules.topman.service.TopManMsgConfigService;
import com.els.modules.topman.service.TopManMsgRecordHisService;
import com.els.modules.topman.service.TopManMsgRecordService;
import com.els.modules.topman.service.TopManMsgTaskService;
import com.els.modules.topman.utils.RedissonUtil;
import com.els.modules.topman.utils.spider.entity.LoginRp;
import com.els.modules.topman.utils.spider.properties.SpiderMethodType;
import com.els.modules.topman.utils.spider.properties.TopManMsgProperties;
import com.els.modules.topman.utils.spider.spiderApi.SpiderApiUtil;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.compress.utils.Lists;
import org.redisson.api.RLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.data.mongodb.core.query.UpdateDefinition;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class TopManMsgTaskServiceImpl
extends BaseServiceImpl<TopManMsgTaskMapper, TopManMsgTask>
implements TopManMsgTaskService {
    private static final Logger log = LoggerFactory.getLogger(TopManMsgTaskServiceImpl.class);
    @Autowired
    @Lazy
    private TopManMsgRecordService topManMsgRecordService;
    @Autowired
    private SpiderApiUtil spiderApiUtil;
    @Lazy
    @Autowired
    private TopManMsgConfigService topManMsgConfigService;
    @Autowired
    private TopManMsgProperties topManMsgProperties;
    @Autowired
    private RedissonUtil redissonUtil;
    @Autowired
    private AdapterFactory adapterFactory;
    @Autowired
    private TopManMsgRecordHisService hisService;
    @Resource
    private MongoTemplate mongoTemplate;
    @Autowired
    private RedisUtil redisUtil;
    @Autowired
    private DictService dictService;

    @Override
    public TopManMsgTask getOneByPlatform(String platform) {
        LoginUser loginUser = SysUtil.getLoginUser();
        return (TopManMsgTask)((Object)this.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(TopManMsgTask::getSubAccount, (Object)loginUser.getSubAccount())).eq(BaseEntity::getElsAccount, (Object)loginUser.getElsAccount())).eq(TopManMsgTask::getPlatform, (Object)platform)).eq(BaseEntity::getDeleted, (Object)CommonConstant.STATUS_NO)));
    }

    @Override
    @SrmTransaction(rollbackFor={Exception.class})
    public void saveBySubAccount(TopManMsgTask topManMsgTask, String type) {
        LoginUser loginUser = SysUtil.getLoginUser();
        TopManMsgTask db = this.getOneByPlatform(topManMsgTask.getPlatform());
        if (ObjectUtil.isEmpty((Object)((Object)db))) {
            topManMsgTask.setSubAccount(loginUser.getSubAccount());
            topManMsgTask.setDeleted(CommonConstant.STATUS_NO);
            ((TopManMsgTaskMapper)this.baseMapper).insert((Object)topManMsgTask);
        } else {
            topManMsgTask.setId(db.getId());
        }
        UpdateWrapper updateWrapper = new UpdateWrapper();
        updateWrapper.eq((Object)"id", (Object)topManMsgTask.getId());
        switch (type) {
            case "1": {
                updateWrapper.set((Object)"filter_info_json", (Object)topManMsgTask.getFilterInfoJson());
                db.setFilterInfoJson(topManMsgTask.getFilterInfoJson());
                this.handleRecord(db);
                break;
            }
            case "2": {
                this.checkPsd(topManMsgTask);
                updateWrapper.set((Object)"platform_url", (Object)topManMsgTask.getPlatformUrl());
                updateWrapper.set((Object)"platform_account", (Object)topManMsgTask.getPlatformAccount());
                updateWrapper.set((Object)"platform_psd", (Object)topManMsgTask.getPlatformPsd());
                updateWrapper.set((Object)"is_auto_start", (Object)topManMsgTask.getAutoStart());
                updateWrapper.set((Object)"is_auto_reply", (Object)topManMsgTask.getAutoReply());
            }
        }
        this.update((Wrapper)updateWrapper);
    }

    private void handleRecord(TopManMsgTask topManMsgTask) {
        List<TopManMsgRecord> searchList;
        long count = this.topManMsgRecordService.count((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(TopManMsgRecord::getTaskId, (Object)topManMsgTask.getId())).eq(TopManMsgRecord::getSendStatus, (Object)"1"));
        ITopManMessageAdapter adapter = (ITopManMessageAdapter)this.adapterFactory.get(topManMsgTask.getPlatform(), ITopManMessageAdapter.class);
        int limitSize = this.topManMsgProperties.getLimit();
        if ((limitSize -= (int)count) <= 0) {
            return;
        }
        if (limitSize > 0 && StrUtil.isNotBlank((CharSequence)topManMsgTask.getFilterInfoJson()) && CollUtil.isNotEmpty(searchList = adapter.getSearchData(topManMsgTask.getFilterInfoJson(), topManMsgTask, limitSize))) {
            this.topManMsgRecordService.saveBatch(searchList);
        }
    }

    private void checkPsd(TopManMsgTask topManMsgTask) {
        HashMap params = Maps.newHashMap();
        params.put("userName", topManMsgTask.getPlatformAccount());
        params.put("userPwd", topManMsgTask.getPlatformPsd());
        LoginRp rp = this.spiderApiUtil.postForEntityMsg(SpiderMethodType.getMsgType(topManMsgTask.getPlatform(), "login_opt"), params, LoginRp.class);
        TopManMsgTask db = (TopManMsgTask)((Object)this.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(TopManMsgTask::getPlatform, (Object)topManMsgTask.getPlatform())).eq(TopManMsgTask::getPlatformAccount, (Object)topManMsgTask.getPlatformAccount())).ne(BaseEntity::getId, (Object)topManMsgTask.getId()), false));
        if (ObjectUtil.isNotEmpty((Object)((Object)db))) {
            Assert.isTrue((boolean)false, (String)("\u6b64IM\u8d26\u53f7\u5df2\u88ab" + db.getSubAccount() + "\u6240\u4f7f\u7528"));
        }
    }

    @Override
    public void edit(TopManMsgTask topManMsgTask) {
        int count = ((TopManMsgTaskMapper)this.baseMapper).updateById((Object)topManMsgTask);
        Assert.isTrue((count != 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
    }

    @Override
    public void delete(String id) {
        ((TopManMsgTaskMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    public void deleteBatch(List<String> idList) {
        ((TopManMsgTaskMapper)this.baseMapper).deleteBatchIds(idList);
    }

    private TopManMsgConfig getContent(List<TopManMsgConfig> list, Integer sortNum) {
        if (ObjectUtil.isNotNull((Object)sortNum)) {
            return list.stream().filter(x -> x.getSortNum().equals(sortNum)).findFirst().orElse(new TopManMsgConfig());
        }
        return list.get(0);
    }

    @Override
    @SrmTransaction(rollbackFor={Exception.class})
    public Result<?> startUp(TopManMsgTask topManMsgTask) {
        Assert.isTrue((boolean)ObjectUtil.isNotEmpty((Object)((Object)topManMsgTask)), (String)"\u8be5\u5b50\u8d26\u53f7\u4e0b\u8fd8\u672a\u8bbe\u7f6e\u8fbe\u4eba\u89e6\u8fbe\u6d88\u606f\u4efb\u52a1");
        Assert.isTrue((boolean)ObjectUtil.isNotEmpty((Object)topManMsgTask.getPlatformAccount()), (String)"\u8be5\u5b50\u8d26\u53f7\u4e0b\u8fd8\u672a\u8bbe\u7f6eIM\u8d26\u53f7");
        Assert.isTrue((boolean)ObjectUtil.isNotEmpty((Object)topManMsgTask.getPlatformPsd()), (String)"\u8be5\u5b50\u8d26\u53f7\u4e0b\u8fd8\u672a\u8bbe\u7f6eIM\u5bc6\u7801");
        List<TopManMsgConfig> msgConfigs = this.topManMsgConfigService.listBySubAccount(topManMsgTask.getElsAccount(), topManMsgTask.getSubAccount(), topManMsgTask.getPlatform());
        Assert.isTrue((boolean)CollUtil.isNotEmpty(msgConfigs), (String)"\u8be5\u5b50\u8d26\u53f7\u4e0b\u8fd8\u672a\u8bbe\u7f6e\u8fbe\u4eba\u6d88\u606f\u8bbe\u7f6e");
        try {
            List search;
            List lev2;
            Map<String, List<TopManMsgConfig>> msgMap = msgConfigs.stream().collect(Collectors.groupingBy(x -> x.getMsgType()));
            Map<String, TopManMsgConfig> msgIdMap = msgConfigs.stream().collect(Collectors.toMap(x -> x.getId(), y -> y));
            List<TopManMsgConfig> callMsgs = msgMap.get(MsgTypeEnum.CALL.getCode());
            Assert.isTrue((boolean)CollUtil.isNotEmpty(msgConfigs), (String)"\u8be5\u5b50\u8d26\u53f7\u4e0b\u8fd8\u672a\u8bbe\u7f6e\u8fbe\u4eba\u62db\u547c\u6d88\u606f\u8bbe\u7f6e");
            int limitSize = this.topManMsgProperties.getLimit();
            List sends = this.topManMsgRecordService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(BaseEntity::getElsAccount, (Object)topManMsgTask.getElsAccount())).eq(TopManMsgRecord::getSubAccount, (Object)topManMsgTask.getSubAccount())).eq(TopManMsgRecord::getSubAdd, (Object)MsgTopManSourceEnum.MANUALLY_ADDED.getCode())).eq(TopManMsgRecord::getPush, (Object)"0")).last("limit " + limitSize));
            if (CollUtil.isEmpty((Collection)sends)) {
                sends = Lists.newArrayList();
            }
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
            String now = simpleDateFormat.format(new Date()) + " 00:00:00";
            if ((limitSize -= sends.size()) > 0 && CollUtil.isNotEmpty((Collection)(lev2 = this.topManMsgRecordService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(TopManMsgRecord::getSendStatus, (Object)"1")).eq(TopManMsgRecord::getReplyStatus, (Object)"0")).eq(TopManMsgRecord::getTaskId, (Object)topManMsgTask.getId())).lt(BaseEntity::getUpdateTime, (Object)now)).orderByAsc(TopManMsgRecord::getSubAdd)).last("limit " + limitSize))))) {
                sends.addAll(lev2);
                limitSize -= sends.size();
            }
            List<TopManMsgConfig> chatMsgs = msgMap.get(MsgTypeEnum.CHAT.getCode());
            List calls = Lists.newArrayList();
            if (CollUtil.isNotEmpty(chatMsgs)) {
                calls = this.topManMsgRecordService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(TopManMsgRecord::getTaskId, (Object)topManMsgTask.getId())).eq(TopManMsgRecord::getSendStatus, (Object)"1")).eq(TopManMsgRecord::getReplyStatus, (Object)"1")).lt(BaseEntity::getUpdateTime, (Object)now)).orderByAsc(TopManMsgRecord::getSubAdd));
                calls.addAll(this.topManMsgRecordService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(TopManMsgRecord::getSubAccount, (Object)topManMsgTask.getSubAccount())).eq(BaseEntity::getElsAccount, (Object)topManMsgTask.getElsAccount())).in(TopManMsgRecord::getSubAdd, Arrays.asList(MsgTopManSourceEnum.PRO_CONTACTS.getCode(), MsgTopManSourceEnum.INITIATIVE_RETRIEVAL.getCode()))).lt(BaseEntity::getUpdateTime, (Object)now)));
            }
            if (limitSize > 0 && CollUtil.isNotEmpty((Collection)(search = this.topManMsgRecordService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(TopManMsgRecord::getSendStatus, (Object)"0")).eq(TopManMsgRecord::getSubAdd, (Object)MsgTopManSourceEnum.AUTO_RETRIEVAL.getCode())).eq(TopManMsgRecord::getTaskId, (Object)topManMsgTask.getId())).orderByAsc(TopManMsgRecord::getSubAdd)).last("limit " + limitSize))))) {
                sends.addAll(search);
                limitSize -= sends.size();
            }
            String filterInfoJson = topManMsgTask.getFilterInfoJson();
            ITopManMessageAdapter adapter = (ITopManMessageAdapter)this.adapterFactory.get(topManMsgTask.getPlatform(), ITopManMessageAdapter.class);
            if (limitSize > 0 && StrUtil.isNotBlank((CharSequence)filterInfoJson)) {
                try {
                    List<TopManMsgRecord> searchList = adapter.getSearchData(filterInfoJson, topManMsgTask, limitSize);
                    sends.addAll(searchList);
                }
                catch (Exception e) {
                    log.error("\u89e6\u8fbe\u65f6\u68c0\u7d22\u5f02\u5e38:", (Throwable)e);
                }
            }
            if (CollUtil.isNotEmpty((Collection)sends) || CollUtil.isNotEmpty((Collection)calls)) {
                List<TopManMsgRecord> finallys = this.handleMsgConfig(topManMsgTask, sends, calls, callMsgs, chatMsgs, limitSize);
                this.sensMsgAndSaveRecord(finallys, topManMsgTask, msgIdMap);
            } else {
                Assert.isTrue((boolean)false, (String)"\u672a\u627e\u5230\u53ef\u89e6\u8fbe\u7684\u8fbe\u4eba");
            }
            topManMsgTask.setNeedCaptcha(null);
            topManMsgTask.setStartStatus("0");
            this.updateById((Object)topManMsgTask);
            return Result.ok((Object)((Object)topManMsgTask));
        }
        catch (Exception e) {
            log.error("\u89e6\u8fbe\u5f00\u542f\u4efb\u52a1\u5931\u8d25", (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    private List<TopManMsgRecord> handleMsgConfig(TopManMsgTask task, List<TopManMsgRecord> sends, List<TopManMsgRecord> calls, List<TopManMsgConfig> callMsgs, List<TopManMsgConfig> chatMsgs, int limitSize) {
        TopManMsgConfig config;
        Map<Integer, TopManMsgConfig> call = callMsgs.stream().collect(Collectors.toMap(x -> x.getSortNum(), y -> y));
        Map<Object, Object> chat = Maps.newHashMap();
        if (ObjectUtil.isNotEmpty(chatMsgs)) {
            chat = chatMsgs.stream().collect(Collectors.toMap(x -> x.getSortNum(), y -> y));
        }
        ArrayList finallys = Lists.newArrayList();
        HashSet sendSet = Sets.newHashSet();
        for (TopManMsgRecord send : sends) {
            if (!sendSet.contains(send.getTopmanName())) {
                send.setTaskId(task.getId());
                if (send.getSendCount() == 0) {
                    config = call.get(1);
                    if (ObjectUtil.isEmpty((Object)((Object)config))) continue;
                    send.setMsgId(config.getId());
                    send.setMsgContent(config.getMsgContent());
                    finallys.add(send);
                    continue;
                }
                config = call.get(send.getSendCount() + 1);
                if (ObjectUtil.isEmpty((Object)((Object)config)) || !ObjectUtil.isNotEmpty((Object)((Object)config)) || this.hisService.count((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(TopManMsgRecordHis::getTaskId, (Object)send.getId())).eq(TopManMsgRecordHis::getSortNum, (Object)config.getSortNum())) != 0) continue;
                send.setMsgId(config.getId());
                send.setMsgContent(config.getMsgContent());
                finallys.add(send);
                continue;
            }
            sendSet.add(send.getTopmanName());
        }
        for (TopManMsgRecord reply : calls) {
            if (reply.getReplyCount() == 0) {
                config = (TopManMsgConfig)((Object)chat.get(1));
                if (ObjectUtil.isEmpty((Object)((Object)config))) continue;
                reply.setMsgId(config.getId());
                reply.setMsgContent(config.getMsgContent());
                finallys.add(reply);
                continue;
            }
            config = (TopManMsgConfig)((Object)chat.get(reply.getSendCount() + 1));
            if (ObjectUtil.isEmpty((Object)((Object)config)) || !ObjectUtil.isNotEmpty((Object)((Object)config)) || this.hisService.count((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(TopManMsgRecordHis::getTaskId, (Object)reply.getId())).eq(TopManMsgRecordHis::getSortNum, (Object)config.getSortNum())) != 0) continue;
            reply.setMsgId(config.getId());
            reply.setMsgContent(config.getMsgContent());
            finallys.add(reply);
        }
        return finallys;
    }

    private List<String> getMcnTopManName() {
        ArrayList mcnTopManName = Lists.newArrayList();
        mcnTopManName.add("\u535a\u96c5baby");
        mcnTopManName.add("\u96e8\u51dd\u7684\u5e97\u4e2a\u4f53\u5e97");
        mcnTopManName.add("\u5f20\u5927\u6811");
        return mcnTopManName;
    }

    private void sensMsgAndSaveRecord(List<TopManMsgRecord> finallys, TopManMsgTask topManMsgTask, Map<String, TopManMsgConfig> msgIdMap) {
        Map<String, List<TopManMsgRecord>> finalMap = finallys.stream().collect(Collectors.groupingBy(x -> x.getTopmanName()));
        HashMap params = Maps.newHashMap();
        params.put("userName", topManMsgTask.getPlatformAccount());
        params.put("userPwd", topManMsgTask.getPlatformPsd());
        ArrayList rqs = Lists.newArrayList();
        ArrayList records = Lists.newArrayList();
        ArrayList hisList = Lists.newArrayList();
        List dyLimit = this.dictService.queryDictItemsByCode("douYinTouchControl", TenantContext.getTenant());
        List<String> mcnTopManName = this.getMcnTopManName();
        finalMap.forEach((k, v) -> {
            TopmanMsgRqDto.Msg msg = new TopmanMsgRqDto.Msg();
            msg.setTopmanName((String)k);
            ArrayList contents = Lists.newArrayList();
            TopManMsgRecord record = (TopManMsgRecord)((Object)((Object)v.get(0)));
            msg.setTopmanId(record.getTopmanId());
            record.setPush("1");
            records.add(record);
            v.forEach(row -> {
                TopmanMsgRqDto.Msg.Content content = new TopmanMsgRqDto.Msg.Content();
                TopManMsgRecordHis his = new TopManMsgRecordHis();
                his.setTaskId(record.getId());
                his.setId(IdWorker.getIdStr());
                content.setTaskId(his.getId());
                content.setContent(row.getMsgContent());
                his.setSendMsgId(row.getMsgId());
                his.setSendMsgContent(row.getMsgContent());
                TopManMsgConfig config = (TopManMsgConfig)((Object)((Object)((Object)msgIdMap.get(row.getMsgId()))));
                his.setMsgType(config.getMsgType());
                his.setSortNum(config.getSortNum());
                his.setSubAccount(topManMsgTask.getSubAccount());
                hisList.add(his);
                contents.add(content);
                msg.getMsg().add(content);
            });
            if (CollUtil.isNotEmpty((Collection)dyLimit) && topManMsgTask.getPlatform().equals("1") && dyLimit.stream().filter(x -> x.getValue().equals(topManMsgTask.getPlatformAccount())).count() > 0L) {
                log.info("-----dyLimit is {} \u9650\u5236\u89e6\u8fbe\u8fbe\u4eba----", (Object)JSON.toJSONString((Object)dyLimit));
                if (CollUtil.isEmpty((Collection)mcnTopManName)) {
                    return;
                }
                msg.setTopmanName((String)mcnTopManName.get(0));
                mcnTopManName.remove(0);
            }
            rqs.add(msg);
        });
        params.put("topmanList", rqs);
        LoginRp rp = this.spiderApiUtil.postForEntityMsg(SpiderMethodType.getMsgType(topManMsgTask.getPlatform(), "send_opt"), params, LoginRp.class);
        this.topManMsgRecordService.saveOrUpdateBatch(records);
        this.hisService.saveBatch(hisList);
    }

    @Override
    @SrmTransaction(rollbackFor={Exception.class})
    public void stop(String platform) {
        TopManMsgTask topManMsgTask = this.getOneByPlatform(platform);
        this.handleTaskStop(topManMsgTask);
        String lockKey = "TOPMAN_MSG_" + topManMsgTask.getPlatformAccount() + "_" + topManMsgTask.getPlatform();
        long time = 120L;
        this.redissonUtil.lock(lockKey, (Long)time);
    }

    private void handleTaskStop(TopManMsgTask topManMsgTask) {
        HashMap params = Maps.newHashMap();
        params.put("userName", topManMsgTask.getPlatformAccount());
        this.spiderApiUtil.postForEntityMsg(SpiderMethodType.getMsgType(topManMsgTask.getPlatform(), "stop_opt"), params, LoginRp.class);
        topManMsgTask.setStatus("0");
        topManMsgTask.setNeedCaptcha(null);
        topManMsgTask.setStartStatus("0");
        this.updateById((Object)topManMsgTask);
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"task_id", (Object)topManMsgTask.getId());
        queryWrapper.eq((Object)"send_status", (Object)"0");
        queryWrapper.eq((Object)"is_added", (Object)"0");
        queryWrapper.eq((Object)"is_sub_add", (Object)MsgTopManSourceEnum.AUTO_RETRIEVAL.getCode());
        QueryWrapper queryWrapper1 = new QueryWrapper();
        queryWrapper1.eq((Object)"task_id", (Object)topManMsgTask.getId());
        queryWrapper1.eq((Object)"send_status", (Object)"0");
        queryWrapper1.in((Object)"is_sub_add", MsgTopManSourceEnum.getNotDelSource());
        List records = this.topManMsgRecordService.list((Wrapper)queryWrapper);
        records.addAll(this.topManMsgRecordService.list((Wrapper)queryWrapper1));
        if (CollUtil.isNotEmpty((Collection)records)) {
            this.hisService.remove((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(BaseEntity::getElsAccount, (Object)topManMsgTask.getElsAccount())).eq(TopManMsgRecordHis::getSubAccount, (Object)topManMsgTask.getSubAccount())).in(TopManMsgRecordHis::getMsgType, Arrays.asList("1", "2"))).isNull(TopManMsgRecordHis::getSendTime));
            this.topManMsgRecordService.remove((Wrapper)queryWrapper);
        }
        UpdateWrapper updateWrapper = new UpdateWrapper();
        updateWrapper.eq((Object)"task_id", (Object)topManMsgTask.getId());
        updateWrapper.eq((Object)"send_status", (Object)"0");
        updateWrapper.lambda().and(wrapper -> {
            LambdaUpdateWrapper cfr_ignored_0 = (LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)wrapper.eq(TopManMsgRecord::getIsAdded, (Object)"1")).or()).in(TopManMsgRecord::getSubAdd, MsgTopManSourceEnum.getNotDelSource());
        });
        updateWrapper.set((Object)"is_push", (Object)"0");
        this.topManMsgRecordService.update((Wrapper)updateWrapper);
    }

    @Override
    public TopManMsgTask getData(String platform) {
        TopManMsgTask db = this.getOneByPlatform(platform);
        return db;
    }

    @Override
    public void processCaptcha(TopManMsgCaptchaDto rq) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"id").is((Object)rq.getId()));
        TopManMsgCaptchaDto topManMsgCaptchaDto = (TopManMsgCaptchaDto)this.mongoTemplate.findOne(query, TopManMsgCaptchaDto.class);
        Assert.isTrue((boolean)ObjectUtil.isNotEmpty((Object)topManMsgCaptchaDto), (String)"\u672a\u83b7\u53d6\u5230\u6570\u636e!");
        if (ObjectUtil.isEmpty((Object)topManMsgCaptchaDto)) {
            topManMsgCaptchaDto = new TopManMsgCaptchaDto();
        }
        topManMsgCaptchaDto.setType(rq.getType());
        topManMsgCaptchaDto.setUserName(rq.getUserName());
        String key = "TOPMAN_MSG_CAPTCHA:" + rq.getType() + rq.getUserName();
        this.redisUtil.set(key, (Object)topManMsgCaptchaDto);
    }

    @Override
    public TopManMsgCaptchaDto getCaptcha(TopManMsgCaptchaDto rq) {
        String key = "TOPMAN_MSG_CAPTCHA:" + rq.getType() + rq.getUserName();
        if (this.redisUtil.hasKey(key)) {
            TopManMsgCaptchaDto dto = (TopManMsgCaptchaDto)this.redisUtil.get(key);
            this.redisUtil.del(new String[]{key});
            return dto;
        }
        return null;
    }

    @Override
    public void enterCaptcha(TopManMsgCaptchaDto rq) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"userName").is((Object)rq.getUserName()));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"type").is((Object)rq.getType()));
        Update update = new Update();
        update.set("captcha", (Object)rq.getCaptcha());
        update.set("timestamp", (Object)(System.currentTimeMillis() / 1000L));
        this.mongoTemplate.updateMulti(query, (UpdateDefinition)update, TopManMsgCaptchaDto.COLLECTION_NAME);
        UpdateWrapper updateWrapper = new UpdateWrapper();
        updateWrapper.eq((Object)"platform_account", (Object)rq.getUserName());
        updateWrapper.eq((Object)"platform", (Object)rq.getType());
        updateWrapper.set((Object)"verification_code", (Object)rq.getCaptcha());
        this.update((Wrapper)updateWrapper);
    }

    @Override
    public void noTokenStop(TopManMsgTask topManMsgTask) {
        Assert.isTrue((boolean)StrUtil.isNotBlank((CharSequence)topManMsgTask.getPlatformAccount()), (String)"\u7528\u6237\u8d26\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isTrue((boolean)StrUtil.isNotBlank((CharSequence)topManMsgTask.getPlatform()), (String)"\u5e73\u53f0\u4e0d\u80fd\u4e3a\u7a7a");
        TopManMsgTask dbTask = (TopManMsgTask)((Object)this.getOne((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(TopManMsgTask::getPlatformAccount, (Object)topManMsgTask.getPlatformAccount())).eq(TopManMsgTask::getPlatform, (Object)topManMsgTask.getPlatform())));
        Assert.isTrue((boolean)ObjectUtil.isNotEmpty((Object)((Object)dbTask)), (String)"\u4fe1\u606f\u5f02\u5e38");
        this.handleTaskStop(dbTask);
    }

    @Override
    public String getReply(String platform) {
        TopManMsgTask task = this.getOneByPlatform(platform);
        this.handleReply(task);
        return task.getPlatformAccount();
    }

    @Override
    @SrmTransaction(rollbackFor={Exception.class})
    public void handleReply(TopManMsgTask task) {
        long time;
        String lockKey = "TOPMAN_MSG_REPLY" + task.getPlatformAccount() + "_" + task.getPlatform();
        RLock lock = this.redissonUtil.lock(lockKey, (Long)(time = 60L));
        if (ObjectUtil.isNotEmpty((Object)lock)) {
            Assert.isTrue((boolean)ObjectUtil.isNotEmpty((Object)((Object)task)), (String)"\u672a\u5f00\u59cb\u89e6\u8fbe\u4efb\u52a1");
            HashMap params = Maps.newHashMap();
            params.put("userName", task.getPlatformAccount());
            params.put("userPwd", task.getPlatformPsd());
            this.spiderApiUtil.postForEntityMsg(SpiderMethodType.getMsgType(task.getPlatform(), "reply_opt"), params, LoginRp.class);
        }
        task.setNeedCaptcha(null);
        task.setReplyStatus(null);
        this.updateById((Object)task);
    }

    @Override
    public void receiveTaskStatus(TopmanMsgTaskDto topmanMsgTaskDto) {
        TopManMsgTask task = (TopManMsgTask)((Object)this.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(TopManMsgTask::getPlatformAccount, (Object)topmanMsgTaskDto.getUserName())).eq(TopManMsgTask::getPlatform, (Object)topmanMsgTaskDto.getPlatform())).eq(BaseEntity::getDeleted, (Object)CommonConstant.STATUS_NO)));
        if (ObjectUtil.isNotEmpty((Object)((Object)task))) {
            switch (topmanMsgTaskDto.getOptType()) {
                case "1": {
                    task.setNeedCaptcha(topmanMsgTaskDto.getNeedCaptcha());
                    this.updateById((Object)task);
                    break;
                }
                case "2": {
                    if ("1".equals(topmanMsgTaskDto.getType())) {
                        task.setStatus(topmanMsgTaskDto.getSuccess());
                    }
                    if ("2".equals(topmanMsgTaskDto.getType())) {
                        task.setReplyStatus(topmanMsgTaskDto.getSuccess());
                    }
                    this.updateById((Object)task);
                    break;
                }
            }
        }
    }
}

