/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.topman.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.I18nUtil;
import com.els.common.util.RedisUtil;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.industryInfo.api.dto.SimplePostRequestParam;
import com.els.modules.topman.dto.BlogTopManCollectDTO;
import com.els.modules.topman.entity.BlogTopManEntity;
import com.els.modules.topman.entity.TopManCollectEntity;
import com.els.modules.topman.enumerate.MarkYn;
import com.els.modules.topman.mapper.BlogTopManMapper;
import com.els.modules.topman.service.BlogTopManService;
import com.els.modules.topman.service.TopManCollectService;
import com.els.modules.topman.utils.HttpRequestUtils;
import com.els.modules.topman.utils.spider.entity.BlogTopManBasicAnalysisEntity;
import com.els.modules.topman.utils.spider.entity.BlogTopManFanAnalysisEntity;
import com.els.modules.topman.utils.spider.entity.BlogTopManFanTrendEntity;
import com.els.modules.topman.utils.spider.entity.BlogTopManMicroAnalysisEntity;
import com.els.modules.topman.utils.spider.entity.BlogTopManPromotionAnalysisEntity;
import com.els.modules.topman.utils.spider.entity.BlogTopManTopDetailsEntity;
import com.els.modules.topman.utils.spider.properties.SpiderBaseProperties;
import com.els.modules.topman.vo.BlogRequestParamVO;
import com.els.modules.topman.vo.BlogTopManInformationVO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.data.mongodb.core.query.UpdateDefinition;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
public class BlogTopManServiceImpl
implements BlogTopManService {
    private static final Logger log = LoggerFactory.getLogger(BlogTopManServiceImpl.class);
    private static final String COLON = ":";
    private static final String BLOG = "blog";
    private static final int SMS_VERIFY_CODE_LENGTH = 6;
    @Autowired
    private SpiderBaseProperties spiderBaseProperties;
    @Autowired
    private RedisUtil redisUtil;
    @Autowired
    private BlogTopManMapper baseMapper;
    @Autowired
    private TopManCollectService topManCollectService;
    @Resource
    private MongoTemplate mongoTemplate;

    @Override
    public Object getOptions(String type) {
        List categoryList = new ArrayList();
        switch (type) {
            case "allTopMan": {
                String urlCategory = this.spiderBaseProperties.getTopManUrl() + "/micro/blog/task/api/category";
                JSONObject allJsonObject = HttpRequestUtils.doPost(urlCategory, "");
                JSONArray allData = allJsonObject.getJSONArray("data");
                categoryList = allData.toJavaList(Object.class);
                break;
            }
            case "collectTopMan": {
                String collectCategory = this.spiderBaseProperties.getTopManUrl() + "/micro/blog/task/api/category";
                JSONObject collectJsonObject = HttpRequestUtils.doPost(collectCategory, "");
                JSONArray collectData = collectJsonObject.getJSONArray("data");
                categoryList = collectData.toJavaList(Object.class);
                break;
            }
            default: {
                throw new ELSBootException(I18nUtil.translate((String)"", (String)"\u672a\u627e\u5230\u8be5\u8bf7\u6c42\u7c7b\u578b"));
            }
        }
        return categoryList;
    }

    @Override
    public IPage<BlogTopManEntity> queryTopManList(SimplePostRequestParam<BlogTopManInformationVO> topManDto) throws Exception {
        Page page;
        BlogTopManInformationVO filterInfo = (BlogTopManInformationVO)topManDto.getFilterInfo();
        String taskType = filterInfo.getTaskType();
        BlogTopManEntity blogTopManInformation = new BlogTopManEntity();
        QueryWrapper queryWrapper = new QueryWrapper();
        StringBuilder redisKey = new StringBuilder(BLOG).append(COLON).append(TenantContext.getTenant()).append(COLON).append("list").append(COLON);
        String param = BlogTopManServiceImpl.apiGetList(taskType, topManDto, blogTopManInformation, (QueryWrapper<BlogTopManEntity>)queryWrapper, redisKey);
        redisKey.append(taskType).append(COLON).append(topManDto.getPageNo()).append(COLON).append(topManDto.getPageSize());
        switch (taskType) {
            case "allTopMan": {
                page = (Page)this.redisUtil.get(redisKey.toString());
                if (page != null) break;
                page = new Page((long)topManDto.getPageNo().intValue(), (long)topManDto.getPageSize().intValue());
                String urlVideo = this.spiderBaseProperties.getTopManUrl() + "/micro/blog/task/api/list";
                JSONObject jsonObjectVideo = HttpRequestUtils.doPost(urlVideo, param);
                if (jsonObjectVideo == null || jsonObjectVideo.size() == 0) {
                    return page;
                }
                JSONArray dataVideo = jsonObjectVideo.getJSONArray("data");
                List blogTopManEntityList = dataVideo.toJavaList(BlogTopManEntity.class);
                page.setTotal((long)jsonObjectVideo.getInteger("total").intValue());
                this.handleResult(blogTopManEntityList, filterInfo.getPlatformType());
                page.setRecords(blogTopManEntityList);
                if (!CollectionUtils.isNotEmpty((Collection)blogTopManEntityList)) break;
                this.redisUtil.set(redisKey.toString(), (Object)page, 9000L);
                break;
            }
            case "collectTopMan": {
                page = new Page((long)topManDto.getPageNo().intValue(), (long)topManDto.getPageSize().intValue());
                page = this.baseMapper.selectCollectTopMan((IPage<BlogTopManEntity>)page, (Wrapper<BlogTopManEntity>)queryWrapper, SysUtil.getLoginUser(), blogTopManInformation);
                break;
            }
            default: {
                throw new ELSBootException("\u8be5\u8bf7\u6c42\u4e0d\u5408\u6cd5");
            }
        }
        return page;
    }

    @Override
    public BlogTopManTopDetailsEntity blogTopManDetails(String topmanId) {
        HashMap<String, String> param = new HashMap<String, String>(2);
        param.put("c", "Kol.info");
        param.put("kol_uid", topmanId);
        String jsonString = JSON.toJSONString(param);
        String urlVideo = this.spiderBaseProperties.getTopManUrl() + "/micro/blog/task/api/top/core/details";
        JSONObject jsonObjectVideo = HttpRequestUtils.doPost(urlVideo, jsonString);
        BlogTopManTopDetailsEntity.TopManInfo topManInfo = (BlogTopManTopDetailsEntity.TopManInfo)jsonObjectVideo.toJavaObject(BlogTopManTopDetailsEntity.TopManInfo.class);
        BlogTopManTopDetailsEntity.TopManCoreData topManCoreData = (BlogTopManTopDetailsEntity.TopManCoreData)jsonObjectVideo.toJavaObject(BlogTopManTopDetailsEntity.TopManCoreData.class);
        BlogTopManTopDetailsEntity blogTopManInformationDetails = new BlogTopManTopDetailsEntity();
        topManInfo.setHomeUrl("https://weibo.com/u/" + topManInfo.getTopmanId());
        blogTopManInformationDetails.setTopManInfo(topManInfo);
        blogTopManInformationDetails.setTopManCoreData(topManCoreData);
        List<String> ids = Collections.singletonList(topManInfo.getTopmanId());
        List<BlogTopManEntity> blogTopManEntityList = this.baseMapper.checkAddedAndCollect(ids, SysUtil.getLoginUser(), "5");
        if (CollectionUtils.isNotEmpty(blogTopManEntityList)) {
            blogTopManInformationDetails.setIsAdded(blogTopManEntityList.get(0).getIsAdded());
            blogTopManInformationDetails.setIsCollection(blogTopManEntityList.get(0).getIsCollection());
        }
        return blogTopManInformationDetails;
    }

    @Override
    public BlogTopManBasicAnalysisEntity blogTopManBasicAnalysisChartEntity(String topmanId) {
        HashMap<String, String> param = new HashMap<String, String>(1);
        param.put("kol_uid", topmanId);
        String jsonString = JSON.toJSONString(param);
        String urlDetails = this.spiderBaseProperties.getTopManUrl() + "/micro/blog/task/api/base/analysis";
        JSONObject jsonObject = HttpRequestUtils.doPost(urlDetails, jsonString);
        JSONObject jsonComment = jsonObject.getJSONObject("comment");
        JSONArray commentPost = jsonComment.getJSONArray("post");
        List chartCommenPostList = commentPost.toJavaList(BlogTopManBasicAnalysisEntity.Chart.class);
        JSONArray commentForward = jsonComment.getJSONArray("forward");
        List chartCommenForwardList = commentForward.toJavaList(BlogTopManBasicAnalysisEntity.Chart.class);
        JSONObject jsonLike = jsonObject.getJSONObject("like");
        JSONArray likePost = jsonLike.getJSONArray("post");
        List chartLikePostList = likePost.toJavaList(BlogTopManBasicAnalysisEntity.Chart.class);
        JSONArray likeForward = jsonLike.getJSONArray("forward");
        List chartLikeForwardList = likeForward.toJavaList(BlogTopManBasicAnalysisEntity.Chart.class);
        JSONObject jsonRepost = jsonObject.getJSONObject("repost");
        JSONArray repostPost = jsonRepost.getJSONArray("post");
        List chartRepostPostList = repostPost.toJavaList(BlogTopManBasicAnalysisEntity.Chart.class);
        JSONArray repostForward = jsonRepost.getJSONArray("forward");
        List chartRepostForwardList = repostForward.toJavaList(BlogTopManBasicAnalysisEntity.Chart.class);
        BlogTopManBasicAnalysisEntity basicAnalysis = new BlogTopManBasicAnalysisEntity();
        basicAnalysis.setCommentPost(chartCommenPostList);
        basicAnalysis.setCommentForward(chartCommenForwardList);
        basicAnalysis.setLikePost(chartLikePostList);
        basicAnalysis.setLikeForward(chartLikeForwardList);
        basicAnalysis.setRepostPost(chartRepostPostList);
        basicAnalysis.setRepostForward(chartRepostForwardList);
        return basicAnalysis;
    }

    @Override
    public BlogTopManFanAnalysisEntity blogTopManFanAnalysisDetails(String topmanId) {
        HashMap<String, String> param = new HashMap<String, String>(1);
        param.put("kol_uid", topmanId);
        String jsonString = JSON.toJSONString(param);
        String urlDetails = this.spiderBaseProperties.getTopManUrl() + "/micro/blog/task/api/fan/portrait";
        JSONObject jsonObject = HttpRequestUtils.doPost(urlDetails, jsonString);
        ArrayList<String> fanOverview = new ArrayList<String>();
        BlogTopManFanAnalysisEntity.Gender gender = (BlogTopManFanAnalysisEntity.Gender)jsonObject.getObject("active_fans_gender", BlogTopManFanAnalysisEntity.Gender.class);
        int i = gender.getMale().compareTo(gender.getFemale());
        switch (i) {
            case 1: {
                fanOverview.add("\u7537\u6027 \u5c45\u591a");
                break;
            }
            case 0: {
                fanOverview.add("\u7537\u5973\u6027 \u6bd4\u4f8b\u76f8\u7b49");
                break;
            }
            case -1: {
                fanOverview.add("\u5973\u6027 \u5c45\u591a");
            }
        }
        JSONArray fanAge = jsonObject.getJSONArray("active_fans_age");
        List fanAgeList = fanAge.toJavaList(BlogTopManFanAnalysisEntity.Fan.class);
        BlogTopManFanAnalysisEntity.Fan fanAgeMany = fanAgeList.stream().max(Comparator.comparing(BlogTopManFanAnalysisEntity.Fan::getValue)).get();
        fanOverview.add(fanAgeMany.getName() + " \u5c81\u5c45\u591a");
        JSONArray fanRegion = jsonObject.getJSONArray("active_fans_area");
        List fanRegionList = fanRegion.toJavaList(BlogTopManFanAnalysisEntity.Fan.class);
        List fanRegionMany = fanRegionList.stream().sorted(Comparator.comparing(BlogTopManFanAnalysisEntity.Fan::getValue).reversed()).collect(Collectors.toList());
        List fanRegionTopThree = fanRegionMany.subList(0, 3);
        String nameString = fanRegionTopThree.stream().map(BlogTopManFanAnalysisEntity.Fan::getName).collect(Collectors.joining(" "));
        fanOverview.add(nameString + " \u7701\u4efd\u5c45\u591a");
        JSONArray fanInterest = jsonObject.getJSONArray("interest");
        List fanInterestList = fanInterest.toJavaList(BlogTopManFanAnalysisEntity.Fan.class);
        List fanInterestMany = fanInterestList.stream().sorted(Comparator.comparing(BlogTopManFanAnalysisEntity.Fan::getValue).reversed()).collect(Collectors.toList());
        List fanInterestTopThree = fanInterestMany.subList(0, 3);
        String region = fanInterestTopThree.stream().map(BlogTopManFanAnalysisEntity.Fan::getName).collect(Collectors.joining(" "));
        fanOverview.add(region + " \u7c7b\u578b\u504f\u597d\u5c45\u591a");
        BlogTopManFanAnalysisEntity blogTopManInformationFanAnalysis = new BlogTopManFanAnalysisEntity();
        blogTopManInformationFanAnalysis.setFanAge(fanAgeList);
        blogTopManInformationFanAnalysis.setFansRegoin(fanRegionList);
        blogTopManInformationFanAnalysis.setFanInterest(fanInterestList);
        blogTopManInformationFanAnalysis.setGender(gender);
        blogTopManInformationFanAnalysis.setFanOverview(fanOverview);
        return blogTopManInformationFanAnalysis;
    }

    @Override
    public BlogTopManFanTrendEntity blogTopManInformationFanTrend(String topmanId) {
        HashMap<String, String> param = new HashMap<String, String>(1);
        param.put("kol_uid", topmanId);
        String jsonString = JSON.toJSONString(param);
        String urlDetails = this.spiderBaseProperties.getTopManUrl() + "/micro/blog/task/api/fan/portrait/chart";
        JSONObject jsonObject = HttpRequestUtils.doPost(urlDetails, jsonString);
        JSONArray totalList = jsonObject.getJSONArray("total");
        List chartTotal = totalList.toJavaList(BlogTopManFanTrendEntity.Chart.class);
        JSONArray incrementList = jsonObject.getJSONArray("increment");
        List chartIncrement = incrementList.toJavaList(BlogTopManFanTrendEntity.Chart.class);
        BlogTopManFanTrendEntity blogTopManInformationFanTrend = new BlogTopManFanTrendEntity();
        blogTopManInformationFanTrend.setTotal(chartTotal);
        blogTopManInformationFanTrend.setIncrement(chartIncrement);
        return blogTopManInformationFanTrend;
    }

    @Override
    public List<BlogTopManMicroAnalysisEntity> blogTopManMicroOriginalAndHot(String topmanId, String pageNo, String type) {
        HashMap<String, String> param = new HashMap<String, String>(3);
        param.put("page", pageNo);
        param.put("uid", topmanId);
        String url = null;
        switch (type) {
            case "0": {
                param.put("feature", "0");
                url = "/micro/blog/task/api/original/analysis";
                break;
            }
            case "1": {
                param.put("feature", "1");
                url = "/micro/blog/task/api/original/analysis";
                break;
            }
            case "2": {
                param.put("feature", "2");
                url = "/micro/blog/task/api/hot/analysis";
                break;
            }
        }
        String jsonString = JSON.toJSONString(param);
        String urlDetails = this.spiderBaseProperties.getTopManUrl() + url;
        JSONObject jsonObject = HttpRequestUtils.doPost(urlDetails, jsonString);
        JSONArray data = jsonObject.getJSONArray("data");
        return data.toJavaList(BlogTopManMicroAnalysisEntity.class);
    }

    @Override
    public BlogTopManPromotionAnalysisEntity blogTopManInformationPromotionAnalysis(String topmanId) {
        HashMap<String, String> param = new HashMap<String, String>(2);
        param.put("c", "Kol.info");
        param.put("kol_uid", topmanId);
        String jsonString = JSON.toJSONString(param);
        String urlDetails = this.spiderBaseProperties.getTopManUrl() + "/micro/blog/task/api/promotion/analysis";
        JSONObject jsonObject = HttpRequestUtils.doPost(urlDetails, jsonString);
        JSONArray data = jsonObject.getJSONArray("price");
        List promotions = data.toJavaList(BlogTopManPromotionAnalysisEntity.Promotion.class);
        JSONArray putInfo = jsonObject.getJSONArray("putInfo");
        List strings = putInfo.toJavaList(String.class);
        BlogTopManPromotionAnalysisEntity blogTopManInformationPromotionAnalysis = new BlogTopManPromotionAnalysisEntity();
        blogTopManInformationPromotionAnalysis.setPrice(promotions);
        blogTopManInformationPromotionAnalysis.setPutInfo(strings);
        return blogTopManInformationPromotionAnalysis;
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void collect(BlogTopManCollectDTO dto) {
        BlogTopManEntity entity = dto.getEntity();
        if (MarkYn.check(dto.getCollect())) {
            QueryWrapper query = new QueryWrapper();
            query.lambda().eq(BlogTopManEntity::getTopmanId, (Object)entity.getTopmanId());
            BlogTopManEntity blogTopManInformation = (BlogTopManEntity)this.baseMapper.selectOne((Wrapper)query);
            if (blogTopManInformation == null) {
                entity.setPlatform("5");
                entity.setId("");
                this.baseMapper.insert(entity);
            } else {
                entity.setId(blogTopManInformation.getId());
                this.baseMapper.updateById(entity);
            }
        }
        LoginUser loginUser = SysUtil.getLoginUser();
        String elsAccount = loginUser.getElsAccount();
        String subAccount = loginUser.getSubAccount();
        if (MarkYn.check(dto.getCollect())) {
            TopManCollectEntity topManCollectEntity = new TopManCollectEntity();
            topManCollectEntity.setTopmanId(entity.getTopmanId());
            topManCollectEntity.setPlatform("5");
            topManCollectEntity.setElsAccount(elsAccount);
            topManCollectEntity.setSubAccount(subAccount);
            this.topManCollectService.save((Object)topManCollectEntity);
        } else {
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.lambda().eq(BaseEntity::getElsAccount, (Object)elsAccount);
            queryWrapper.lambda().eq(TopManCollectEntity::getSubAccount, (Object)subAccount);
            queryWrapper.lambda().eq(TopManCollectEntity::getPlatform, (Object)"5");
            queryWrapper.lambda().eq(TopManCollectEntity::getTopmanId, (Object)entity.getTopmanId());
            this.topManCollectService.remove((Wrapper)queryWrapper);
        }
        this.redisUtil.dels("blog:" + TenantContext.getTenant() + COLON + "list");
    }

    @Override
    public void addMarkToSpider(BlogTopManCollectDTO dto) {
        BlogTopManEntity entity = dto.getEntity();
        QueryWrapper query = new QueryWrapper();
        query.lambda().eq(BlogTopManEntity::getTopmanId, (Object)entity.getTopmanId());
        BlogTopManEntity blogTopManInformation = (BlogTopManEntity)this.baseMapper.selectOne((Wrapper)query);
        if (blogTopManInformation == null) {
            entity.setPlatform("5");
            entity.setId("");
            this.baseMapper.insert(entity);
        } else {
            entity.setId(blogTopManInformation.getId());
            this.baseMapper.updateById(entity);
        }
        this.redisUtil.dels("blog:" + TenantContext.getTenant() + COLON + "list");
    }

    @Override
    public void cleanCache(String cacheKey) {
        this.redisUtil.dels(cacheKey);
    }

    @Override
    public void getSms(HttpServletRequest httpServletRequest) {
        String content = httpServletRequest.getParameter("content");
        Assert.hasText((String)content, (String)I18nUtil.translate((String)"i18n_alert_ESWWxOLV_a67a232", (String)"\u77ed\u4fe1\u5185\u5bb9\u4e3a\u7a7a"));
        Pattern pattern = Pattern.compile("(?<![0-9])([0-9]{6})(?![0-9])");
        Matcher matcher = pattern.matcher(content);
        String smsVerifyCode = "";
        while (matcher.find()) {
            smsVerifyCode = matcher.group();
        }
        log.info("\u9a8c\u8bc1\u7801:" + smsVerifyCode);
        String regex = "1[35789]\\d{9}";
        Pattern p = Pattern.compile(regex);
        Matcher m = p.matcher(content);
        String phone = "";
        while (m.find()) {
            phone = m.group();
        }
        log.info("\u624b\u673a\u53f7\u7801:" + phone);
        ArrayList<Criteria> criteriaList = new ArrayList<Criteria>();
        criteriaList.add(Criteria.where((String)"status").is((Object)"1"));
        criteriaList.add(Criteria.where((String)"web_server").is((Object)"1"));
        criteriaList.add(Criteria.where((String)"type").in(new Object[]{"\u5fae\u535a\u5b98\u7f51", "\u5fae\u4efb\u52a1"}));
        Query query = new Query((CriteriaDefinition)new Criteria().andOperator(criteriaList.toArray(new Criteria[0])));
        Update update = Update.update((String)"user", (Object)phone).set("verify_num", (Object)smsVerifyCode).set("timestamp", (Object)System.currentTimeMillis());
        String tbDyLoginUser = "tb_dy_login_user";
        this.mongoTemplate.updateMulti(query, (UpdateDefinition)update, Map.class, tbDyLoginUser);
    }

    private void handleResult(List<BlogTopManEntity> data, String platform) {
        List<String> topmanId = data.stream().map(BlogTopManEntity::getTopmanId).distinct().collect(Collectors.toList());
        List<BlogTopManEntity> addedAndCollects = this.baseMapper.checkAddedAndCollect(topmanId, SysUtil.getLoginUser(), platform);
        Map<Object, Object> map = new HashMap();
        if (CollectionUtil.isNotEmpty(addedAndCollects)) {
            map = addedAndCollects.stream().collect(Collectors.toMap(BlogTopManEntity::getTopmanId, h -> h, (k1, k2) -> k1));
        }
        for (BlogTopManEntity topManInfo : data) {
            if (!map.containsKey(topManInfo.getTopmanId())) continue;
            BlogTopManEntity info = (BlogTopManEntity)map.get(topManInfo.getTopmanId());
            topManInfo.setIsCollection(info.getIsCollection());
            topManInfo.setIsAdded(info.getIsAdded());
        }
    }

    private static String apiGetList(String taskType, SimplePostRequestParam<BlogTopManInformationVO> topManDto, BlogTopManEntity blogTopManInformation, QueryWrapper<BlogTopManEntity> queryWrapper, StringBuilder cacheKey) throws Exception {
        BlogTopManInformationVO.ScreenItem screenItem;
        BlogTopManInformationVO filterInfo = (BlogTopManInformationVO)topManDto.getFilterInfo();
        BlogRequestParamVO blogRequestParamVO = new BlogRequestParamVO();
        blogRequestParamVO.setList_type("weibo");
        blogRequestParamVO.setPage(topManDto.getPageNo());
        blogRequestParamVO.setLimit(topManDto.getPageSize());
        String keyWord = topManDto.getKeyWord();
        if (StringUtils.isNotEmpty((CharSequence)keyWord)) {
            blogRequestParamVO.setNick(keyWord.trim());
            queryWrapper.lambda().eq(BlogTopManEntity::getTopmanName, (Object)keyWord.trim());
            cacheKey.append(keyWord.trim()).append(COLON);
        }
        if ((screenItem = filterInfo.getScreenItem()) != null) {
            List<BlogTopManInformationVO.ScreenItemField> putInfo;
            List<BlogTopManInformationVO.ScreenItemField> talentInfo;
            List<BlogTopManInformationVO.ScreenItemField> talentType = screenItem.getTalentType();
            if (CollectionUtils.isNotEmpty(talentType)) {
                String value = talentType.get(0).getId().toString();
                blogRequestParamVO.setAccount_type(value);
                blogTopManInformation.setTopmanType(talentType.get(0).getTitle().trim());
                cacheKey.append("talentType").append(COLON).append(value).append(COLON);
            }
            if (CollectionUtils.isNotEmpty(talentInfo = screenItem.getTalentInfo())) {
                talentInfo.forEach(a -> {
                    String title;
                    switch (title = a.getTitle()) {
                        case "\u7c89\u4e1d\u603b\u6570": {
                            BlogTopManServiceImpl.getFanParam(a.getValue().toString(), blogRequestParamVO, queryWrapper, cacheKey);
                            break;
                        }
                        case "\u5fae\u535a\u8ba4\u8bc1": {
                            String blogAuthentication = a.getValue().toString();
                            blogRequestParamVO.setAccount_vertify(a.getValue().toString());
                            queryWrapper.lambda().eq(BlogTopManEntity::getBlogAuthentication, (Object)blogAuthentication);
                            cacheKey.append("talentInfo").append(COLON).append(blogAuthentication).append(COLON);
                            break;
                        }
                        case "\u5fae\u535a\u5f71\u54cd\u529b": {
                            String blogInfluence = a.getValue().toString();
                            blogRequestParamVO.setInfluence(blogInfluence);
                            queryWrapper.lambda().eq(BlogTopManEntity::getBlogInfluence, (Object)blogInfluence);
                            cacheKey.append("talentInfo").append(COLON).append(blogInfluence).append(COLON);
                            break;
                        }
                        default: {
                            throw new ELSBootException("\u6ca1\u6709\u627e\u5230\u8be5\u9009\u9879");
                        }
                    }
                });
            }
            if (CollectionUtils.isNotEmpty(putInfo = screenItem.getPutInfo())) {
                putInfo.forEach(a -> {
                    String title;
                    switch (title = a.getTitle()) {
                        case "\u539f\u53d1\u62a5\u4ef7": {
                            BlogTopManServiceImpl.getPutParam(a.getValue().toString(), title, blogRequestParamVO, queryWrapper, cacheKey);
                            blogRequestParamVO.setSend_type("1");
                            break;
                        }
                        case "\u8f6c\u53d1\u62a5\u4ef7": {
                            BlogTopManServiceImpl.getPutParam(a.getValue().toString(), title, blogRequestParamVO, queryWrapper, cacheKey);
                            blogRequestParamVO.setSend_type("2");
                            break;
                        }
                        default: {
                            throw new ELSBootException("\u6ca1\u6709\u627e\u5230\u8be5\u9009\u9879");
                        }
                    }
                });
            }
        }
        BlogTopManServiceImpl.sort(topManDto, blogRequestParamVO, queryWrapper);
        String json = JSON.toJSONString((Object)blogRequestParamVO);
        log.info("\u5fae\u535a\u5165\u53c2aaaaaaaaaaaaaa=" + json);
        return json;
    }

    public static void getFanParam(Object str, BlogRequestParamVO blogRequestParamVO, QueryWrapper<BlogTopManEntity> queryWrapper, StringBuilder cacheKey) {
        String value = str.toString();
        if (value.startsWith("-")) {
            String[] split = value.split("-");
            blogRequestParamVO.setFans_count("0-" + split[1]);
            queryWrapper.lambda().lt(BlogTopManEntity::getFanTotal, (Object)split[1]);
            cacheKey.append("talentInfo").append(COLON).append(split[1]).append(COLON);
        } else if (value.endsWith("-")) {
            String[] split = value.split("-");
            blogRequestParamVO.setFans_count(split[0] + "-0");
            queryWrapper.lambda().gt(BlogTopManEntity::getFanTotal, (Object)split[0]);
            cacheKey.append("talentInfo").append(COLON).append(split[0]).append(COLON);
        } else {
            String[] split = value.split("-");
            blogRequestParamVO.setFans_count(value);
            queryWrapper.lambda().between(BlogTopManEntity::getFanTotal, (Object)split[0], (Object)split[1]);
            cacheKey.append("talentInfo").append(COLON).append(split[0]).append(COLON).append(split[1]).append(COLON);
        }
    }

    public static void getPutParam(Object str, String type, BlogRequestParamVO blogRequestParamVO, QueryWrapper<BlogTopManEntity> queryWrapper, StringBuilder cacheKey) {
        String value = str.toString();
        if (value.startsWith("-")) {
            String[] split = value.split("-");
            blogRequestParamVO.setSend_price("0-" + split[1]);
            queryWrapper.lt((Object)(type.equals("\u539f\u53d1\u62a5\u4ef7") ? "primary_price" : "forward_price"), (Object)split[1]);
            cacheKey.append("putInfo").append(COLON).append(split[1]).append(COLON);
        } else if (value.endsWith("-")) {
            String[] split = value.split("-");
            blogRequestParamVO.setSend_price(split[0] + "-0");
            queryWrapper.gt((Object)(type.equals("\u539f\u53d1\u62a5\u4ef7") ? "primary_price" : "forward_price"), (Object)split[0]);
            cacheKey.append("putInfo").append(COLON).append(split[0]).append(COLON);
        } else {
            String[] split = value.split("-");
            blogRequestParamVO.setSend_price(value);
            queryWrapper.between((Object)(type.equals("\u539f\u53d1\u62a5\u4ef7") ? "primary_price" : "forward_price"), (Object)split[0], (Object)split[1]);
            cacheKey.append("putInfo").append(COLON).append(split[0]).append(COLON).append(split[1]).append(COLON);
        }
    }

    public static void sort(SimplePostRequestParam<BlogTopManInformationVO> topManDto, BlogRequestParamVO blogRequestParamVO, QueryWrapper<BlogTopManEntity> queryWrapper) {
        boolean order = false;
        if (StringUtils.isNotEmpty((CharSequence)topManDto.getColumn()) && !"default".equals(topManDto.getColumn())) {
            String column = topManDto.getColumn();
            if (StringUtils.isNotEmpty((CharSequence)topManDto.getOrder()) && "asc".equals(topManDto.getOrder())) {
                order = true;
            }
            switch (column) {
                case "microTaskIndex": {
                    blogRequestParamVO.setWrw_index_order(order ? "asc" : "desc");
                    queryWrapper.orderBy(true, order, (Object[])new String[]{BlogTopManServiceImpl.camelToUnderline(column)});
                    break;
                }
                case "fanTotal": {
                    blogRequestParamVO.setFans_count_order(order ? "asc" : "desc");
                    queryWrapper.orderBy(true, order, (Object[])new String[]{BlogTopManServiceImpl.camelToUnderline(column)});
                    break;
                }
                default: {
                    queryWrapper.orderBy(true, order, (Object[])new String[]{BlogTopManServiceImpl.camelToUnderline(column)});
                    break;
                }
            }
        } else {
            queryWrapper.orderBy(true, order, (Object[])new String[]{"collect_update_time"});
        }
    }

    public static String camelToUnderline(String para) {
        if (para.length() < 3) {
            return para.toLowerCase();
        }
        StringBuilder sb = new StringBuilder(para);
        int temp = 0;
        for (int i = 2; i < para.length(); ++i) {
            if (!Character.isUpperCase(para.charAt(i))) continue;
            sb.insert(i + temp, "_");
            ++temp;
        }
        return sb.toString().toLowerCase();
    }
}

