/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.store.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.system.query.QueryGenerator;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.SysUtil;
import com.els.modules.common.spider.dto.ShopApiDTO;
import com.els.modules.common.spider.properties.SpiderMethodType;
import com.els.modules.common.spider.spiderApi.SpiderApiUtil;
import com.els.modules.common.spider.vo.ShopApiPage;
import com.els.modules.common.spider.vo.ShopApiVO;
import com.els.modules.common.weboption.OptionFactory;
import com.els.modules.industryInfo.api.dto.SimplePostRequestParam;
import com.els.modules.industryInfo.api.weboption.TopManOptionsEntity;
import com.els.modules.store.dto.ShopCollectDTO;
import com.els.modules.store.dto.ShopDTO;
import com.els.modules.store.entity.Shop;
import com.els.modules.store.entity.ShopCollect;
import com.els.modules.store.enumerate.ShopOptionsType;
import com.els.modules.store.enumerate.ShopOptionsTypeGroup;
import com.els.modules.store.mapper.ShopMapper;
import com.els.modules.store.service.ShopCollectService;
import com.els.modules.store.service.ShopService;
import com.els.modules.store.vo.ShopVO;
import com.els.modules.topman.entity.RedBookTopManEntity;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.bson.Document;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ShopServiceImpl
extends BaseServiceImpl<ShopMapper, Shop>
implements ShopService {
    @Autowired
    private ShopCollectService shopCollectService;
    @Autowired
    private SpiderApiUtil spiderApiUtil;

    @Override
    public List<TopManOptionsEntity> getOptions(String type, String clearCache) {
        OptionFactory.OptionHandler<ShopOptionsTypeGroup, ShopOptionsType> init = OptionFactory.init(ShopOptionsTypeGroup.class, ShopOptionsType.class);
        init.setCollection("tb_shop_category");
        switch (type) {
            case "all": {
                init.when(ShopOptionsType.category, (doc, param) -> this.optionsConverter(doc));
                init.when(ShopOptionsType.filter, (doc, param) -> this.optionsConverter(doc));
                break;
            }
            case "collect": {
                init.when(ShopOptionsType.category, (doc, param) -> this.optionsConverter(doc));
                init.when(ShopOptionsType.filter, (doc, param) -> this.optionsConverter(doc));
                break;
            }
            default: {
                throw new ELSBootException("\u672a\u627e\u5230\u8be5\u8bf7\u6c42\u7c7b\u578b");
            }
        }
        return init.getResult(type, "1".equals(clearCache));
    }

    private List<TopManOptionsEntity.Tag> optionsConverter(Document doc) {
        List docList = doc.getList((Object)"directory_json", Document.class);
        return docList.stream().map(h -> {
            TopManOptionsEntity.TagCopy tag = new TopManOptionsEntity.TagCopy();
            tag.setId(h.get((Object)"id").toString());
            tag.setLabel(h.get((Object)"label").toString());
            tag.setValue(h.get((Object)"value").toString());
            tag.setComponentType(h.get((Object)"componentType").toString());
            tag.setChildren(this.getParam((Document)h));
            return tag;
        }).collect(Collectors.toList());
    }

    private List<Object> getParam(Document document) {
        ArrayList<Object> tagCopyList = new ArrayList<Object>();
        List children = document.getList((Object)"children", Map.class);
        if (CollectionUtil.isNotEmpty((Collection)children)) {
            children.forEach(a -> {
                TopManOptionsEntity.TagCopy tagCopy = new TopManOptionsEntity.TagCopy();
                tagCopy.setId(a.get("id").toString());
                tagCopy.setLabel(a.get("label").toString());
                tagCopy.setValue(a.get("value").toString());
                List children1 = (List)a.get("children");
                if (CollectionUtil.isEmpty((Collection)children)) {
                    tagCopy.setChildren(null);
                } else {
                    ArrayList sonTagCopyList = new ArrayList();
                    children1.forEach(b -> {
                        TopManOptionsEntity.TagCopy sonTagCopy = new TopManOptionsEntity.TagCopy();
                        sonTagCopy.setId(b.get("id") == null ? null : a.get("id").toString());
                        sonTagCopy.setLabel(b.get("label").toString());
                        sonTagCopy.setValue(b.get("label").toString());
                        sonTagCopy.setChildren(null);
                        sonTagCopyList.add(sonTagCopy);
                    });
                    tagCopy.setChildren(sonTagCopyList);
                }
                tagCopyList.add(tagCopy);
            });
        }
        return tagCopyList;
    }

    @Override
    public IPage<ShopVO> queryPageList(SimplePostRequestParam<ShopDTO> param) {
        IPage<ShopVO> page = new IPage<ShopVO>((long)param.getPageNo().intValue(), (long)param.getPageSize().intValue());
        ShopDTO dto = (ShopDTO)param.getFilterInfo();
        String taskType = dto.getTaskType();
        if (ShopOptionsTypeGroup.all.getName().equals(taskType)) {
            Map<?, ?> map = this.handleBody(param);
            SpiderMethodType methodType = SpiderMethodType.SHOPS_LIST;
            ShopApiPage data = this.spiderApiUtil.postForEntity(methodType, map, ShopApiPage.class);
            page.setTotal((long)data.getTotal().intValue());
            page.setRecords(this.handleResult(data, dto.getPlatform()));
        } else {
            QueryWrapper<Shop> queryWrapper = this.getQueryWrapper(param);
            page = ((ShopMapper)this.baseMapper).queryPageList(page, queryWrapper, SysUtil.getLoginUser());
        }
        return page;
    }

    private Map<?, ?> handleBody(SimplePostRequestParam<ShopDTO> param) {
        List<ShopDTO.ScreenItemField> category;
        ShopApiDTO spiderApiDTO = new ShopApiDTO(param);
        spiderApiDTO.setKeyword(StringUtils.isNotBlank((CharSequence)param.getKeyWord()) ? param.getKeyWord() : "");
        ShopDTO.ScreenItem screenItem = ((ShopDTO)param.getFilterInfo()).getScreenItem();
        if (screenItem != null && CollectionUtil.isNotEmpty(category = screenItem.getCategory())) {
            List collect = category.stream().map(ShopDTO.ScreenItemField::getTitle).distinct().collect(Collectors.toList());
            spiderApiDTO.setCate0((String)collect.get(0));
        }
        String json = JSON.toJSONString((Object)spiderApiDTO);
        return (Map)JSON.parseObject((String)json, Map.class);
    }

    private List<ShopVO> handleResult(ShopApiPage data, Integer platform) {
        List<ShopApiVO> shopDatas = data.getShopDatas();
        if (CollectionUtil.isEmpty(shopDatas)) {
            return new ArrayList<ShopVO>(0);
        }
        List<String> shopIds = shopDatas.stream().map(ShopApiVO::getShopId).distinct().collect(Collectors.toList());
        List<ShopVO> collects = ((ShopMapper)this.baseMapper).checkCollect(shopIds, SysUtil.getLoginUser(), platform);
        Map<Object, Object> map = new HashMap(collects.size());
        if (CollectionUtil.isNotEmpty(collects)) {
            map = collects.stream().collect(Collectors.toMap(ShopVO::getShopId, h -> h, (k1, k2) -> k1));
        }
        ArrayList<ShopVO> list = new ArrayList<ShopVO>(shopDatas.size());
        for (ShopApiVO vo : shopDatas) {
            ShopVO shop = new ShopVO();
            BeanUtils.copyProperties((Object)vo, (Object)shop);
            shop.setPlatform(1);
            shop.setSalesNum(vo.getTotalOrderAccount30Day());
            shop.setSalesAmount(vo.getTotalPrices30Day());
            shop.setGoodsNum(vo.getProductCount());
            shop.setVideosNum(vo.getAwemes30Day());
            shop.setLivesNum(vo.getLives30Day());
            List<String> cateNames = vo.getCateNames();
            shop.setShopCategory(CollectionUtil.isNotEmpty(cateNames) ? StringUtils.join(cateNames, (String)",") : "");
            shop.setIsCollection(map.get(vo.getShopId()) != null ? ((ShopVO)map.get(vo.getShopId())).getIsCollection() : 0);
            list.add(shop);
        }
        return list;
    }

    private QueryWrapper<Shop> getQueryWrapper(SimplePostRequestParam<ShopDTO> param) {
        String[] columns;
        String column;
        String keyWord;
        List<ShopDTO.ScreenItemField> filters;
        ShopDTO dto = (ShopDTO)param.getFilterInfo();
        ShopDTO.ScreenItem screenItem = dto.getScreenItem();
        QueryWrapper query = new QueryWrapper();
        List<ShopDTO.ScreenItemField> categorys = screenItem.getCategory();
        if (CollectionUtil.isNotEmpty(categorys)) {
            String value = categorys.get(0).getValue();
            this.handlelikeString(value, (QueryWrapper<Shop>)query, Shop::getShopCategory);
        }
        if (CollectionUtil.isNotEmpty(filters = screenItem.getFilter())) {
            block18: for (ShopDTO.ScreenItemField screenItemField : filters) {
                String value = screenItemField.getValue();
                switch (screenItemField.getTitle()) {
                    case "\u5546\u54c1\u603b\u6570": {
                        this.handleEqString(value, (QueryWrapper<Shop>)query, Shop::getGoodsNum);
                        continue block18;
                    }
                    case "\u5173\u8054\u89c6\u9891\u6570": {
                        this.handleEqString(value, (QueryWrapper<Shop>)query, Shop::getVideosNum);
                        continue block18;
                    }
                    case "\u5173\u8054\u76f4\u64ad\u6570": {
                        this.handleEqString(value, (QueryWrapper<Shop>)query, Shop::getLivesNum);
                        continue block18;
                    }
                    case "\u9500\u91cf": {
                        this.handleEqString(value, (QueryWrapper<Shop>)query, Shop::getSalesNum);
                        continue block18;
                    }
                    case "\u9500\u552e\u989d": {
                        this.handleEqString(value, (QueryWrapper<Shop>)query, Shop::getSalesAmount);
                        continue block18;
                    }
                    case "\u76f4\u64ad\u5e26\u8d27": {
                        query.lambda().isNotNull(Shop::getLivesNum);
                        continue block18;
                    }
                    case "\u89c6\u9891\u5e26\u8d27": {
                        query.lambda().isNotNull(Shop::getVideosNum);
                        continue block18;
                    }
                }
                throw new ELSBootException("\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u53c2\u6570\u7c7b\u578b");
            }
        }
        if ((keyWord = param.getKeyWord()) != null && keyWord.trim().length() > 0) {
            query.and(q -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)q.lambda().like(Shop::getShopName, (Object)keyWord)).or(a -> {
                    LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)a.eq(Shop::getShopId, (Object)keyWord);
                });
            });
        }
        if ((column = param.getColumn()) != null && !"default".equals(column) && (columns = column.split(",")).length > 0) {
            final String order = param.getOrder();
            QueryGenerator.doMultiFieldsOrder((QueryWrapper)query, (Map)new HashMap<String, String[]>(2){
                {
                    super(x0);
                    this.put("order", order == null ? new String[columns.length] : order.split(","));
                    this.put("column", columns);
                }
            }, (Object)((Object)new RedBookTopManEntity()));
        }
        return query;
    }

    private void handlelikeString(String value, QueryWrapper<Shop> query, SFunction<Shop, ?> field) {
        if (StringUtils.isBlank((CharSequence)value) || "\u5168\u90e8".equals(value) || "\u4e0d\u9650".equals(value)) {
            return;
        }
        query.lambda().like(field, (Object)value);
    }

    private void handleEqString(String value, QueryWrapper<Shop> query, SFunction<Shop, ?> field) {
        if (StringUtils.isBlank((CharSequence)value) || "\u5168\u90e8".equals(value) || "\u4e0d\u9650".equals(value)) {
            return;
        }
        query.lambda().eq(field, (Object)value);
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void collect(ShopCollectDTO dto) {
        if (dto.getCollect() == 1) {
            this.addMarkToSpider(dto);
        }
        this.collectHandle(dto);
    }

    private void collectHandle(ShopCollectDTO dto) {
        LoginUser loginUser = SysUtil.getLoginUser();
        String elsAccount = loginUser.getElsAccount();
        String subAccount = loginUser.getSubAccount();
        ShopVO entity = dto.getEntity();
        if (dto.getCollect() == 1) {
            ShopCollect collect = new ShopCollect();
            collect.setShopId(entity.getShopId());
            collect.setPlatform(1);
            collect.setElsAccount(elsAccount);
            collect.setSubAccount(subAccount);
            this.shopCollectService.save((Object)collect);
        } else {
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.lambda().eq(BaseEntity::getElsAccount, (Object)elsAccount);
            queryWrapper.lambda().eq(ShopCollect::getSubAccount, (Object)subAccount);
            queryWrapper.lambda().eq(ShopCollect::getPlatform, (Object)"1");
            queryWrapper.lambda().eq(ShopCollect::getShopId, (Object)entity.getShopId());
            this.shopCollectService.remove((Wrapper)queryWrapper);
        }
    }

    public void addMarkToSpider(ShopCollectDTO dto) {
        this.saveRedBookSpiderTopMan(dto.getEntity());
    }

    private void saveRedBookSpiderTopMan(ShopVO vo) {
        Shop entity = new Shop();
        BeanUtils.copyProperties((Object)vo, (Object)((Object)entity));
        QueryWrapper query = new QueryWrapper();
        query.lambda().eq(Shop::getShopId, (Object)entity.getShopId());
        Shop info = (Shop)((Object)((ShopMapper)this.baseMapper).selectOne((Wrapper)query));
        if (info == null) {
            entity.setPlatform(1);
            entity.setId("");
        } else {
            entity.setId(info.getId());
        }
        this.saveOrUpdate((Object)entity);
    }
}

