/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.ranklist.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.RedisUtil;
import com.els.modules.common.weboption.OptionFactory;
import com.els.modules.industryInfo.api.dto.SimplePostRequestParam;
import com.els.modules.industryInfo.api.weboption.TopManOptionsEntity;
import com.els.modules.ranklist.dto.TopManRanklistDTO;
import com.els.modules.ranklist.entity.TopManRanklist;
import com.els.modules.ranklist.enumerate.TopManRanklistOptionsType;
import com.els.modules.ranklist.enumerate.TopManRanklistOptionsTypeGroup;
import com.els.modules.ranklist.mapper.TopManRanklistMapper;
import com.els.modules.ranklist.service.TopManRanklistService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.bson.Document;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.stereotype.Service;

@Service
public class TopManRanklistServiceImpl
extends BaseServiceImpl<TopManRanklistMapper, TopManRanklist>
implements TopManRanklistService {
    @Autowired
    private RedisUtil redisUtil;
    @Autowired
    private MongoTemplate mongoTemplate;

    @Override
    public List<TopManOptionsEntity> getOptions(String type, String listType, String clearCache) {
        OptionFactory.OptionHandler<TopManRanklistOptionsTypeGroup, TopManRanklistOptionsType> init = OptionFactory.init(TopManRanklistOptionsTypeGroup.class, TopManRanklistOptionsType.class);
        init.setCollection("tb_topman_ranklist_category");
        switch (type) {
            case "douYin": {
                if ("4".equals(listType) || "5".equals(listType)) {
                    init.when(TopManRanklistOptionsType.douYinCategory2, (doc, param) -> this.topmanCategoryConverter(doc));
                    break;
                }
                init.when(TopManRanklistOptionsType.douYinCategory, (doc, param) -> this.topmanCategoryConverter(doc));
                break;
            }
            case "kuaiShou": {
                init.when(TopManRanklistOptionsType.kuaiShouCategory, (doc, param) -> this.topmanCategoryConverter(doc));
                break;
            }
            case "redBook": {
                init.when(TopManRanklistOptionsType.redBookCategory, (doc, param) -> this.topmanCategoryConverter(doc));
                break;
            }
            case "biliBili": {
                init.when(TopManRanklistOptionsType.biliBiliCategory, (doc, param) -> this.topmanCategoryConverter(doc));
                break;
            }
            case "weiBo": {
                init.when(TopManRanklistOptionsType.weiBoCategory, (doc, param) -> this.topmanCategoryConverter(doc));
                break;
            }
            case "zhiHu": {
                init.when(TopManRanklistOptionsType.zhiHuCategory, (doc, param) -> this.topmanCategoryConverter(doc));
                break;
            }
            default: {
                throw new ELSBootException("\u672a\u627e\u5230\u8be5\u8bf7\u6c42\u7c7b\u578b");
            }
        }
        return init.getResult(type + "_" + listType, "1".equals(clearCache));
    }

    private List<TopManOptionsEntity.Tag> topmanCategoryConverter(Document doc) {
        List docList = doc.getList((Object)"directory_json", Document.class);
        return docList.stream().map(h -> {
            TopManOptionsEntity.TagCopy tag = new TopManOptionsEntity.TagCopy();
            tag.setId(h.get((Object)"id").toString());
            tag.setLabel(h.get((Object)"label").toString());
            tag.setValue(h.get((Object)"value").toString());
            tag.setComponentType(h.get((Object)"componentType").toString());
            tag.setChildren(this.getParam((Document)h));
            return tag;
        }).collect(Collectors.toList());
    }

    private List<Object> getParam(Document document) {
        ArrayList<Object> tagCopyList = new ArrayList<Object>();
        List children = document.getList((Object)"children", Map.class);
        if (CollectionUtil.isNotEmpty((Collection)children)) {
            children.forEach(a -> {
                TopManOptionsEntity.TagCopy tagCopy = new TopManOptionsEntity.TagCopy();
                tagCopy.setId(a.get("id").toString());
                tagCopy.setLabel(a.get("label").toString());
                tagCopy.setValue(a.get("value").toString());
                List children1 = (List)a.get("children");
                if (CollectionUtil.isEmpty((Collection)children)) {
                    tagCopy.setChildren(null);
                } else {
                    ArrayList sonTagCopyList = new ArrayList();
                    children1.forEach(b -> {
                        TopManOptionsEntity.TagCopy sonTagCopy = new TopManOptionsEntity.TagCopy();
                        sonTagCopy.setId(b.get("id") == null ? null : a.get("id").toString());
                        sonTagCopy.setLabel(b.get("label").toString());
                        sonTagCopy.setValue(b.get("label").toString());
                        sonTagCopy.setChildren(null);
                        sonTagCopyList.add(sonTagCopy);
                    });
                    tagCopy.setChildren(sonTagCopyList);
                }
                tagCopyList.add(tagCopy);
            });
        }
        return tagCopyList;
    }

    @Override
    public IPage<TopManRanklist> queryPageList(SimplePostRequestParam<TopManRanklistDTO> param) {
        Page page = new Page((long)param.getPageNo().intValue(), (long)param.getPageSize().intValue());
        QueryWrapper<TopManRanklist> queryWrapper = this.getQueryWrapper(param);
        return ((TopManRanklistMapper)this.baseMapper).queryPageList((IPage<TopManRanklist>)page, queryWrapper);
    }

    private QueryWrapper<TopManRanklist> getQueryWrapper(SimplePostRequestParam<TopManRanklistDTO> param) {
        TopManRanklistDTO.ScreenItem screenItem;
        TopManRanklistDTO dto = (TopManRanklistDTO)param.getFilterInfo();
        QueryWrapper query = new QueryWrapper();
        query.lambda().eq(TopManRanklist::getPlatform, (Object)dto.getPlatform());
        query.lambda().eq(TopManRanklist::getRankType, (Object)dto.getRankType());
        if (dto.getDateType() != null) {
            query.lambda().eq(TopManRanklist::getDateType, (Object)dto.getDateType());
            if (dto.getRankDate() != null) {
                query.lambda().eq(TopManRanklist::getRankDate, (Object)dto.getRankDate());
            }
        }
        if ((screenItem = dto.getScreenItem()) == null) {
            return query;
        }
        List<TopManRanklistDTO.ScreenItemField> talentInfos = screenItem.getDouYinCategory();
        if (CollectionUtil.isNotEmpty(talentInfos)) {
            TopManRanklistDTO.ScreenItemField screenItemField = talentInfos.get(0);
            query.lambda().like(TopManRanklist::getTopmanCategory, (Object)screenItemField.getTitle());
        }
        return query;
    }

    @Override
    public void cleanCache(String cacheKey) {
        this.redisUtil.dels(cacheKey);
    }

    @Override
    public void addCategory() {
    }
}

