/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.goods.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.SysUtil;
import com.els.modules.goods.dto.GoodsCollectDTO;
import com.els.modules.goods.entity.Goods;
import com.els.modules.goods.entity.GoodsCollect;
import com.els.modules.goods.entity.GoodsItems;
import com.els.modules.goods.mapper.GoodsCollectMapper;
import com.els.modules.goods.mapper.GoodsMapper;
import com.els.modules.goods.service.GoodsCollectService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class GoodsCollectServiceImpl
extends BaseServiceImpl<GoodsCollectMapper, GoodsCollect>
implements GoodsCollectService {
    @Autowired
    private GoodsMapper goodsMapper;

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void collect(GoodsCollectDTO dto) {
        if (dto.getCollect() == 1) {
            this.addMarkToSpider(dto);
        }
        this.collectHandle(dto);
    }

    private void collectHandle(GoodsCollectDTO dto) {
        LoginUser loginUser = SysUtil.getLoginUser();
        String elsAccount = loginUser.getElsAccount();
        String subAccount = loginUser.getSubAccount();
        GoodsItems entity = dto.getEntity();
        if (dto.getCollect() == 1) {
            GoodsCollect collect = new GoodsCollect();
            collect.setGoodsId(entity.getGid());
            collect.setPlatform(1);
            collect.setElsAccount(elsAccount);
            collect.setSubAccount(subAccount);
            this.save((Object)collect);
        } else {
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.lambda().eq(BaseEntity::getElsAccount, (Object)elsAccount);
            queryWrapper.lambda().eq(GoodsCollect::getSubAccount, (Object)subAccount);
            queryWrapper.lambda().eq(GoodsCollect::getPlatform, (Object)"1");
            queryWrapper.lambda().eq(GoodsCollect::getGoodsId, (Object)entity.getGid());
            this.remove((Wrapper)queryWrapper);
        }
    }

    private void addMarkToSpider(GoodsCollectDTO dto) {
        this.saveEntity(dto.getEntity());
    }

    private void saveEntity(GoodsItems vo) {
        Goods entity = new Goods();
        entity.setGoodsId(vo.getGid());
        entity.setImageUrl(vo.getImageUrl());
        entity.setTitle(vo.getTitle());
        entity.setPriceRange(vo.getPriceRange());
        entity.setCosRatio(vo.getCosRatio());
        entity.setTotalSales(vo.getTotalSales30Day());
        entity.setLivesSales(vo.getLiveSales30Day());
        entity.setVideosSales(vo.getAwemeSales30Day());
        entity.setLivesNum(vo.getLive30Day());
        entity.setVideosNum(vo.getAweme30Day());
        entity.setDetailUrl(vo.getDetailUrl());
        QueryWrapper query = new QueryWrapper();
        query.lambda().eq(Goods::getGoodsId, (Object)entity.getGoodsId());
        Goods info = (Goods)((Object)this.goodsMapper.selectOne((Wrapper)query));
        if (info == null) {
            entity.setPlatform(1);
            entity.setId("");
            this.goodsMapper.insert((Object)entity);
        } else {
            entity.setId(info.getId());
            this.goodsMapper.updateById((Object)entity);
        }
    }
}

