/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.goods.controller;

import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.modules.goods.service.GoodsService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/industryinfo/goods"})
@Api(tags={"\u5546\u54c1"})
public class GoodsController {
    private static final Logger log = LoggerFactory.getLogger(GoodsController.class);
    @Autowired
    private GoodsService goodsService;

    @GetMapping(value={"/searchItems"})
    public Result<?> searchItems() throws Exception {
        return Result.ok(this.goodsService.searchItems());
    }

    @AutoLog(value="\u5546\u54c1\u4fe1\u606f\u5e93-\u67e5\u8be2\u5546\u54c1\u5217\u8868\u4fe1\u606f")
    @ApiOperation(value="\u67e5\u8be2", notes="\u67e5\u8be2")
    @PostMapping(value={"/searchGoosList"})
    public Result<?> searchGoosList(@RequestBody Map query) throws Exception {
        return Result.ok(this.goodsService.searchPromotion(query));
    }

    @AutoLog(value="\u5546\u54c1\u4fe1\u606f\u5e93-\u67e5\u8be2\u5546\u54c1\u8be6\u7ec6\u4fe1\u606f")
    @ApiOperation(value="\u67e5\u8be2", notes="\u67e5\u8be2")
    @PostMapping(value={"/searchGoodsInfo"})
    public Result<?> searchGoodsInfo(@RequestBody Map goods) throws Exception {
        return Result.ok((Object)((Object)this.goodsService.searchGoodsDetails(goods)));
    }

    @AutoLog(value="\u5546\u54c1\u4fe1\u606f\u5e93-\u67e5\u8be2\u5546\u54c1\u76f4\u64ad\u4fe1\u606f")
    @ApiOperation(value="\u67e5\u8be2", notes="\u67e5\u8be2")
    @PostMapping(value={"/searchGoodsLive"})
    public Result<?> searchGoodsLive(@RequestBody Map goods) throws Exception {
        return Result.ok(this.goodsService.getGoodsLive(goods));
    }

    @AutoLog(value="\u5546\u54c1\u4fe1\u606f\u5e93-\u67e5\u8be2\u5546\u54c1\u89c6\u9891")
    @ApiOperation(value="\u67e5\u8be2", notes="\u67e5\u8be2")
    @PostMapping(value={"/searchGoodsAweme"})
    public Result<?> searchGoodsAweme(@RequestBody Map goods) throws Exception {
        return Result.ok(this.goodsService.getGoodsAweme(goods));
    }

    @AutoLog(value="\u5546\u54c1\u4fe1\u606f\u5e93-\u67e5\u8be2\u7b5b\u9009\u6807\u7b7e\u4e0e\u6392\u5e8f\u6761\u4ef6")
    @ApiOperation(value="\u67e5\u8be2", notes="\u67e5\u8be2")
    @PostMapping(value={"/searchGoodsTopManItem"})
    public Result<?> searchGoodsTopManItem(@RequestBody Map goods) throws Exception {
        return Result.ok((Object)this.goodsService.getGoodsTopManItem(goods));
    }

    @AutoLog(value="\u5546\u54c1\u4fe1\u606f\u5e93-\u67e5\u8be2\u7c7b\u578b\u4e0e\u54c1\u724c\u7c7b")
    @ApiOperation(value="\u67e5\u8be2", notes="\u67e5\u8be2")
    @PostMapping(value={"/searchAnalysisTypes"})
    public Result<?> searchAnalysisTypes(@RequestBody Map goods) throws Exception {
        return Result.ok((Object)this.goodsService.getAnalysisTypes(goods));
    }

    @AutoLog(value="\u5546\u54c1\u4fe1\u606f\u5e93-\u67e5\u8be2\u5546\u54c1\u8fbe\u4eba\u5206\u6790")
    @ApiOperation(value="\u67e5\u8be2", notes="\u67e5\u8be2")
    @PostMapping(value={"/searchGoodsTopManAnalysis"})
    public Result<?> searchGoodsTopManAnalysis(@RequestBody Map goods) throws Exception {
        return Result.ok(this.goodsService.getGoodsTopManAnalysis(goods));
    }

    @AutoLog(value="\u5546\u54c1\u4fe1\u606f\u5e93-\u67e5\u8be2\u5546\u54c1\u6bcf\u65e5\u8d8b\u52bf")
    @ApiOperation(value="\u67e5\u8be2", notes="\u67e5\u8be2")
    @PostMapping(value={"/searchGoodsTrend"})
    public Result<?> searchGoodsTrend(@RequestBody Map goods) throws Exception {
        return Result.ok((Object)this.goodsService.getGoodsOverviewTrend(goods));
    }
}

