/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.goods.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.util.RedisUtil;
import com.els.common.util.SysUtil;
import com.els.modules.common.spider.spiderApi.HttpClientResult;
import com.els.modules.common.spider.spiderApi.HttpClientUtils;
import com.els.modules.common.spider.spiderApi.JsonUtils;
import com.els.modules.common.spider.spiderApi.SpiderApiUtil;
import com.els.modules.goods.entity.GoodsAnalysisSearch;
import com.els.modules.goods.entity.GoodsAnalysisType;
import com.els.modules.goods.entity.GoodsAnalysisTypes;
import com.els.modules.goods.entity.GoodsAweme;
import com.els.modules.goods.entity.GoodsDetail;
import com.els.modules.goods.entity.GoodsLive;
import com.els.modules.goods.entity.GoodsOverview;
import com.els.modules.goods.entity.GoodsOverviewTrend;
import com.els.modules.goods.entity.GoodsTopManAnalysis;
import com.els.modules.goods.service.GoodsCollectService;
import com.els.modules.goods.service.GoodsService;
import com.els.modules.goods.vo.GoodsItems;
import com.els.modules.goods.vo.GoodsResultVO;
import com.els.modules.topman.utils.spider.entity.GoodsListPage;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class GoodsServiceImpl
implements GoodsService {
    @Autowired
    private GoodsCollectService goodsCollectService;
    @Value(value="${spider-api.topManUrl}")
    private String url;
    @Value(value="${spider-api.method.dou-yin.getGoodsList}")
    private String PromotionMethod;
    @Value(value="${spider-api.method.dou-yin.getGoodsItems}")
    private String itemdsMethod;
    @Value(value="${spider-api.method.dou-yin.getGoodsDetails}")
    private String detailMethod;
    @Value(value="${spider-api.method.dou-yin.getGoodsOverviewTrend}")
    private String goodsOverviewTrendMethod;
    @Value(value="${spider-api.method.dou-yin.getGoodsAweme}")
    private String getGoodsAwemeMethod;
    @Value(value="${spider-api.method.dou-yin.getGoodsLive}")
    private String getGoodsLiveMethod;
    @Value(value="${spider-api.method.dou-yin.getGoodsTopManItem}")
    private String getGoodsTopManItemMethod;
    @Value(value="${spider-api.method.dou-yin.getGoodsTopManTypes}")
    private String getGoodsTopManTypesMethod;
    @Value(value="${spider-api.method.dou-yin.getGoodsTopMan}")
    private String getGoodsTopManMethod;
    @Autowired
    private SpiderApiUtil spiderApiUtil;
    @Autowired
    private RedisUtil redisUtil;

    @Override
    public List<GoodsResultVO> searchItems() throws Exception {
        String method = this.url + this.itemdsMethod;
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/json");
        HashMap resutlMap = new HashMap();
        String jsonResult = "";
        HttpClientResult result = HttpClientUtils.doGet(method, headers, new HashMap<String, String>());
        if (result != null && 200 == result.getCode()) {
            jsonResult = result.getContent();
        }
        if (jsonResult == null || "".equals(jsonResult)) {
            return null;
        }
        JsonObject jsonObject = JsonUtils.parseJson(jsonResult);
        List<GoodsResultVO> list = this.json2GoodsResultVO((JsonObject)jsonObject.get("data"));
        return list;
    }

    private List<GoodsItems> json2goodsItem(JsonArray jsonArray) {
        ArrayList<GoodsItems> goodsItems = new ArrayList<GoodsItems>();
        if (jsonArray == null || jsonArray.isEmpty()) {
            return goodsItems;
        }
        for (int i = 0; i < jsonArray.size(); ++i) {
            JsonObject json = (JsonObject)jsonArray.get(i);
            GoodsItems item = new GoodsItems();
            HashMap map = new HashMap();
            Set entrySet = json.entrySet();
            for (Map.Entry entry : entrySet) {
                String key = (String)entry.getKey();
                Object value = entry.getValue();
                String text = "";
                if (!(value instanceof JsonArray)) {
                    text = (value + "").replace("\"", "");
                }
                switch (key) {
                    case "KeyInt": {
                        item.setKeyInt(text);
                        break;
                    }
                    case "Number": {
                        item.setNumber(text);
                        break;
                    }
                    case "Text": {
                        item.setText(text);
                        break;
                    }
                    case "Value": {
                        item.setValue(text);
                        break;
                    }
                    case "Value2": {
                        item.setValue2(text);
                        break;
                    }
                    case "SearchTwoLevelItemList": {
                        item.setChildren(this.json2goodsItem((JsonArray)value));
                        break;
                    }
                    case "SearchThreeLevelItemList": {
                        item.setChildren(this.json2goodsItem((JsonArray)value));
                        break;
                    }
                    case "SearchFourLevelItemList": {
                        item.setChildren(this.json2goodsItem((JsonArray)value));
                        break;
                    }
                    case "Expand": {
                        item.setChildren(this.json2goodsItem((JsonArray)value));
                    }
                }
            }
            goodsItems.add(item);
        }
        return goodsItems;
    }

    private List<GoodsResultVO> json2GoodsResultVO(JsonObject jsonObject) {
        ArrayList<GoodsResultVO> resultList = new ArrayList<GoodsResultVO>();
        GoodsResultVO cata = new GoodsResultVO();
        cata.setFieldName("categorys");
        cata.setSort(1);
        cata.setTitle("\u5546\u54c1\u5206\u7c7b");
        GoodsResultVO fiter = new GoodsResultVO();
        fiter.setFieldName("filter");
        fiter.setSort(2);
        fiter.setTitle("\u5546\u54c1\u4fe1\u606f");
        ArrayList<GoodsItems> fiterChren = new ArrayList<GoodsItems>();
        boolean sort = true;
        Set entrySet = jsonObject.entrySet();
        Iterator iter = entrySet.iterator();
        while (iter.hasNext()) {
            GoodsItems item = new GoodsItems();
            Map.Entry entry = (Map.Entry)iter.next();
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            JsonArray ja = new JsonArray();
            if (!(value instanceof JsonArray)) break;
            ja = (JsonArray)value;
            switch (key) {
                case "Ages": {
                    item.setText("\u5e74\u9f84");
                    item.setValue("\u5e74\u9f84");
                    item.setKeyInt("ages");
                    item.setComponentType("RSelect");
                    item.setChildren(this.json2goodsItem(ja));
                    break;
                }
                case "Categorys": {
                    cata.setChildren(this.json2goodsItem(ja));
                    break;
                }
                case "Commissions": {
                    item.setText("\u4f63\u91d1\u6bd4\u4f8b");
                    item.setValue("\u4f63\u91d1\u6bd4\u4f8b");
                    item.setKeyInt("Commissions");
                    item.setComponentType("RSelect");
                    item.setChildren(this.json2goodsItem(ja));
                    break;
                }
                case "Coupons": {
                    item.setText("\u4f18\u60e0\u5238");
                    item.setValue("\u4f18\u60e0\u5238");
                    item.setKeyInt("Coupons");
                    item.setComponentType("RSelect");
                    item.setChildren(this.json2goodsItem(ja));
                    break;
                }
                case "FirstTimes": {
                    item.setText("\u4e0a\u67b6\u65f6\u95f4");
                    item.setValue("\u4e0a\u67b6\u65f6\u95f4");
                    item.setKeyInt("FirstTimes");
                    item.setComponentType("RSelect");
                    item.setChildren(this.json2goodsItem(ja));
                    break;
                }
                case "Genders": {
                    item.setText("\u6027\u522b");
                    item.setValue("\u6027\u522b");
                    item.setKeyInt("Genders");
                    item.setComponentType("RSelect");
                    item.setChildren(this.json2goodsItem(ja));
                    break;
                }
                case "MainSalesModel": {
                    item.setChildren(this.json2goodsItem(ja));
                    break;
                }
                case "PraiseRates": {
                    item.setText("\u597d\u8bc4\u7387");
                    item.setValue("\u597d\u8bc4\u7387");
                    item.setKeyInt("PraiseRates");
                    item.setComponentType("RSelect");
                    item.setChildren(this.json2goodsItem(ja));
                    break;
                }
                case "ProportionGoods": {
                    break;
                }
                case "RecommendTags": {
                    break;
                }
                case "SendFroms": {
                    break;
                }
                case "ServiceTypes": {
                    break;
                }
                case "ShopScores": {
                    break;
                }
                case "Sorts": {
                    break;
                }
                case "SourceList": {
                    break;
                }
            }
            fiterChren.add(item);
        }
        fiter.setChildren(fiterChren);
        resultList.add(cata);
        resultList.add(fiter);
        return resultList;
    }

    @Override
    public IPage<com.els.modules.goods.entity.GoodsItems> searchPromotion(Map query) throws Exception {
        Page page = new Page(Long.parseLong(query.get("pageIndex") + ""), Long.parseLong(query.get("pageSize") + ""));
        String method = this.url + this.PromotionMethod;
        String jsonResult = this.getPostResult(method, query, true);
        if (jsonResult == null || "".equals(jsonResult)) {
            return page;
        }
        ArrayList goodsList = new ArrayList();
        ObjectMapper mapper = new ObjectMapper();
        JsonNode jsonNode = mapper.readTree(jsonResult);
        GoodsListPage goods = (GoodsListPage)((Object)mapper.convertValue((Object)jsonNode.get("data"), GoodsListPage.class));
        page.setTotal(goods.getTotal().longValue());
        page.setRecords(this.checkCollect(goods.getItems()));
        return page;
    }

    private List<com.els.modules.goods.entity.GoodsItems> checkCollect(List<com.els.modules.goods.entity.GoodsItems> list) {
        List<String> goodsIds = list.stream().map(com.els.modules.goods.entity.GoodsItems::getGid).distinct().collect(Collectors.toList());
        return this.goodsCollectService.checkCollectList(goodsIds, SysUtil.getLoginUser(), 1);
    }

    @Override
    public GoodsDetail searchGoodsDetails(Map goods) throws Exception {
        GoodsDetail detail = new GoodsDetail();
        String method = this.url + this.detailMethod;
        String jsonResult = this.getPostResult(method, goods, true);
        if (jsonResult == null || "".equals(jsonResult)) {
            return detail;
        }
        detail = this.buildDetail(jsonResult);
        this.checkDetailCollect(detail);
        return detail;
    }

    private void checkDetailCollect(GoodsDetail detail) {
        List<String> ids = Collections.singletonList(detail.getGid());
        List<com.els.modules.goods.entity.GoodsItems> checkCollects = this.goodsCollectService.checkCollectList(ids, SysUtil.getLoginUser(), 1);
        if (CollectionUtil.isNotEmpty(checkCollects)) {
            detail.setIsCollection(checkCollects.get(0).getIsCollection());
        }
    }

    private GoodsDetail buildDetail(String jsonResult) {
        Map<String, Object> detailObject = JsonUtils.jsontoMap(jsonResult);
        Map data = (Map)detailObject.get("data");
        GoodsDetail result = new GoodsDetail();
        result.setGid(data.get("Gid") + "");
        result.setTitle(data.get("Title") + "");
        result.setCateStr(data.get("CateStr") + "");
        result.setCosRatio(data.get("CosRatio") + "");
        result.setShopName(data.get("ShopName") + "");
        result.setShopId(data.get("ShopId") + "");
        result.setPrice(data.get("PriceRange") + "");
        result.setLiveCountDay(data.get("LiveCount_30Day") + "");
        result.setImageUrl(data.get("ImageUrl") + "");
        result.setVisitorCount(data.get("VisitorCount") + "");
        result.setTotalPV(data.get("TotalPV_30Day") + "");
        result.setPromUserAccount30Day(data.get("PromUserAccount_30Day") + "");
        result.setSalesCount30Day(data.get("SalesCount_30Day") + "");
        result.setAwemesDay(data.get("Awemes_30Day") + "");
        return result;
    }

    @Override
    public GoodsOverview getGoodsOverviewTrend(Map goods) throws Exception {
        GoodsOverview overiew = new GoodsOverview();
        String method = this.url + this.goodsOverviewTrendMethod;
        String jsonResult = this.getPostResult(method, goods, true);
        if (jsonResult == null || "".equals(jsonResult)) {
            return overiew;
        }
        overiew = this.buildTrend(jsonResult);
        return overiew;
    }

    private GoodsOverview buildTrend(String jsonResult) {
        GoodsOverview overiew = new GoodsOverview();
        ArrayList<GoodsOverviewTrend> trends = new ArrayList<GoodsOverviewTrend>();
        Map<String, Object> detailObject = JsonUtils.jsontoMap(jsonResult);
        Map data = (Map)detailObject.get("data");
        List list = (List)data.get("List");
        for (Map obj : list) {
            GoodsOverviewTrend trend = new GoodsOverviewTrend();
            trend.setDateyyyyMMdd(obj.get("DateyyyyMMdd") + "");
            trend.setPvStr(obj.get("PvStr") + "");
            trend.setAwemeCount(obj.get("AwemeCount") + "");
            trend.setBloggerCount(obj.get("BloggerCount") + "");
            trend.setLiveCount(obj.get("LiveCount") + "");
            trend.setTotalSaleCountStr(obj.get("TotalSaleCountStr") + "");
            trend.setTotalSalesStr(obj.get("TotalSalesStr") + "");
            trends.add(trend);
        }
        overiew.setTrends(trends);
        Map totalData = (Map)data.get("TotalData");
        overiew.setBloggerCount(totalData.get("BloggerCountStr") + "");
        overiew.setPvStr(totalData.get("PvStr") + "");
        overiew.setSalesCountStr(totalData.get("SalesCountStr") + "");
        overiew.setTotalSalesStr(totalData.get("TotalSalesStr") + "");
        return overiew;
    }

    private String getPostResult(String method, Map query, Boolean isJson) throws Exception {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/json");
        String jsonResult = "";
        HttpClientResult result = HttpClientUtils.doPost(method, headers, query, true);
        if (result != null && 200 == result.getCode()) {
            jsonResult = result.getContent();
        }
        return jsonResult;
    }

    @Override
    public IPage<GoodsAweme> getGoodsAweme(Map goods) throws Exception {
        Page page = new Page(Long.parseLong(goods.get("page") + ""), Long.parseLong(goods.get("pageSize") + ""));
        String method = this.url + this.getGoodsAwemeMethod;
        String jsonResult = this.getPostResult(method, goods, true);
        if (jsonResult == null || "".equals(jsonResult)) {
            return page;
        }
        ArrayList<GoodsAweme> awemes = new ArrayList<GoodsAweme>();
        long total = this.buildAweme(jsonResult, awemes);
        page.setTotal(total);
        page.setRecords(awemes);
        return page;
    }

    @Override
    public IPage<GoodsLive> getGoodsLive(Map goods) throws Exception {
        Page page = new Page(Long.parseLong(goods.get("page") + ""), Long.parseLong(goods.get("pageSize") + ""));
        String method = this.url + this.getGoodsLiveMethod;
        String jsonResult = this.getPostResult(method, goods, true);
        if (jsonResult == null || "".equals(jsonResult)) {
            return page;
        }
        ArrayList<GoodsLive> lives = new ArrayList<GoodsLive>();
        long total = this.buildLives(jsonResult, lives);
        page.setTotal(total);
        page.setRecords(lives);
        return page;
    }

    private long buildLives(String jsonResult, List<GoodsLive> lives) {
        Map<String, Object> detailObject = JsonUtils.jsontoMap(jsonResult);
        Map data = (Map)detailObject.get("data");
        List list = (List)data.get("Items");
        for (Map obj : list) {
            GoodsLive live = new GoodsLive();
            live.setRoomId(obj.get("AwemeDesc") + "");
            live.setRoomName(obj.get("RoomName") + "");
            live.setDateCode(obj.get("DateCode") + "");
            live.setLiveBeginTime(obj.get("LiveBeginTime") + "");
            live.setLiveEndTime(obj.get("LiveEndTime") + "");
            live.setPrice(obj.get("Price") + "");
            live.setMPlatformFans(obj.get("MPlatform_Fans") + "");
            live.setSaleCount(obj.get("SaleCount") + "");
            live.setTotalSales(obj.get("TotalSales") + "");
            live.setNickName(obj.get("NickName") + "");
            lives.add(live);
        }
        Long total = Long.parseLong(data.get("Total") + "");
        return total;
    }

    private long buildAweme(String jsonResult, List<GoodsAweme> awemes) {
        Map<String, Object> detailObject = JsonUtils.jsontoMap(jsonResult);
        Map data = (Map)detailObject.get("data");
        List list = (List)data.get("Items");
        for (Map obj : list) {
            GoodsAweme aweme = new GoodsAweme();
            aweme.setAwemeDesc(obj.get("AwemeDesc") + "");
            aweme.setAwemePubTime(obj.get("AwemePubTime") + "");
            aweme.setAwemeId(obj.get("AwemeId") + "");
            aweme.setAwemeOrderAccount(obj.get("AwemeOrderAccount") + "");
            aweme.setAwemeTotalSales(obj.get("AwemeTotalSales") + "");
            aweme.setBloggerName(obj.get("BloggerName") + "");
            aweme.setBloggerPlatform_Fans(obj.get("BloggerPlatform_Fans") + "");
            aweme.setLikeCount(obj.get("LikeCount") + "");
            aweme.setShareCount(obj.get("ShareCount") + "");
            aweme.setCommentCount(obj.get("CommentCount") + "");
            awemes.add(aweme);
        }
        Long total = Long.parseLong(data.get("Total") + "");
        return total;
    }

    @Override
    public GoodsAnalysisSearch getGoodsTopManItem(Map goods) throws Exception {
        String method = this.url + this.getGoodsTopManItemMethod;
        String jsonResult = this.getPostResult(method, goods, true);
        JsonObject jsonObject = JsonUtils.parseJson(jsonResult);
        JsonObject data = (JsonObject)jsonObject.get("data");
        GoodsAnalysisSearch search = this.json2GoodsAnalysisSearchVO(data);
        return search;
    }

    private GoodsAnalysisSearch json2GoodsAnalysisSearchVO(JsonObject jsonObject) {
        GoodsAnalysisSearch result = new GoodsAnalysisSearch();
        Set entrySet = jsonObject.entrySet();
        for (Map.Entry entry : entrySet) {
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            JsonArray ja = new JsonArray();
            if (!(value instanceof JsonArray)) break;
            ja = (JsonArray)value;
            switch (key) {
                case "Dates": {
                    result.setDates(this.json2goodsItem(ja));
                    break;
                }
                case "FansCounts": {
                    result.setFansCounts(this.json2goodsItem(ja));
                    break;
                }
                case "Tags": {
                    result.setTags(this.json2goodsItem(ja));
                    break;
                }
                case "Sorts": {
                    result.setSorts(this.json2goodsItem(ja));
                    break;
                }
            }
        }
        return result;
    }

    @Override
    public GoodsAnalysisTypes getAnalysisTypes(Map goods) throws Exception {
        String method = this.url + this.getGoodsTopManTypesMethod;
        String jsonResult = this.getPostResult(method, goods, true);
        GoodsAnalysisTypes types = new GoodsAnalysisTypes();
        JsonObject jsonObject = JsonUtils.parseJson(jsonResult);
        JsonObject data = (JsonObject)jsonObject.get("data");
        if (data == null) {
            return types;
        }
        types.setBrandDistributes(this.getGoodsAnalysisType((JsonArray)data.get("BrandDistributes")));
        types.setTypeDistributes(this.getGoodsAnalysisType((JsonArray)data.get("TypeDistributes")));
        return types;
    }

    private List<GoodsAnalysisType> getGoodsAnalysisType(JsonArray jsonArray) {
        ArrayList<GoodsAnalysisType> types = new ArrayList<GoodsAnalysisType>();
        if (jsonArray == null || jsonArray.isEmpty()) {
            return types;
        }
        for (int i = 0; i < jsonArray.size(); ++i) {
            JsonObject json = (JsonObject)jsonArray.get(i);
            GoodsAnalysisType item = new GoodsAnalysisType();
            HashMap map = new HashMap();
            Set entrySet = json.entrySet();
            for (Map.Entry entry : entrySet) {
                String key = (String)entry.getKey();
                Object value = entry.getValue();
                String text = "";
                if (!(value instanceof JsonArray)) {
                    text = (value + "").replace("\"", "");
                }
                switch (key) {
                    case "BloggerCount": {
                        item.setBloggerCount(text);
                        break;
                    }
                    case "BrandName": {
                        item.setBrandName(text);
                        break;
                    }
                    case "DouyinBrandId": {
                        item.setDouyinBrandId(text);
                        break;
                    }
                    case "TypeId": {
                        item.setTypeId(text);
                        break;
                    }
                    case "TypeName": {
                        item.setTypeName(text);
                        break;
                    }
                }
            }
            types.add(item);
        }
        return types;
    }

    @Override
    public IPage<GoodsTopManAnalysis> getGoodsTopManAnalysis(Map goods) throws Exception {
        String method = this.url + this.getGoodsTopManMethod;
        String jsonResult = this.getPostResult(method, goods, true);
        Page page = new Page(Long.parseLong(goods.get("page") + ""), Long.parseLong(goods.get("pageSize") + ""));
        if (jsonResult == null || "".equals(jsonResult)) {
            return page;
        }
        ArrayList<GoodsTopManAnalysis> goodsTopMans = new ArrayList<GoodsTopManAnalysis>();
        long total = this.buildGoodsTopManAnalysis(jsonResult, goodsTopMans);
        page.setTotal(total);
        page.setRecords(goodsTopMans);
        return page;
    }

    private long buildGoodsTopManAnalysis(String jsonResult, List<GoodsTopManAnalysis> goodsTopMans) {
        Map<String, Object> detailObject = JsonUtils.jsontoMap(jsonResult);
        Map data = (Map)detailObject.get("data");
        List list = (List)data.get("Items");
        for (Map obj : list) {
            GoodsTopManAnalysis topMan = new GoodsTopManAnalysis();
            topMan.setTags(obj.get("Tags") + "");
            topMan.setMPlatform_Fans(obj.get("MPlatform_Fans") + "");
            topMan.setLiveCount(obj.get("LiveCount") + "");
            topMan.setLiveSalesCount(obj.get("LiveSalesCount") + "");
            topMan.setAvatar(obj.get("Avatar") + "");
            topMan.setAwemeCount(obj.get("AwemeCount") + "");
            topMan.setNickName(obj.get("NickName") + "");
            topMan.setTotalSalesCount(obj.get("TotalSalesCount") + "");
            topMan.setAwemeSalesCount(obj.get("AwemeSalesCount") + "");
            goodsTopMans.add(topMan);
        }
        Long total = Long.parseLong(data.get("Total") + "");
        return total;
    }
}

