/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.job;

import com.els.common.api.service.JobRpcService;
import com.els.modules.common.utils.DataFormatUtils;
import com.els.modules.goods.entity.GoodsHead;
import com.els.modules.goods.entity.GoodsItem;
import com.els.modules.goods.service.GoodsHeadService;
import com.els.modules.goods.service.GoodsItemService;
import com.mongodb.client.MongoCursor;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.bson.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.stereotype.Component;

@Component
public class GoodsJob
implements JobRpcService {
    private static final Logger log = LoggerFactory.getLogger(GoodsJob.class);
    @Resource
    private GoodsHeadService goodsHeadService;
    @Resource
    private GoodsItemService goodsItemService;
    @Resource
    private MongoTemplate mongoTemplate;
    private final String GOODS_COLLECTION_NAME = "tb_doudian_shop_goods";
    private final int BATCH_SIZE = 5000;

    public void execute(String parameter) {
        log.info("------------start TopManJob-----------");
        int i = 0;
        try (MongoCursor cursor = this.mongoTemplate.getCollection("tb_doudian_shop_goods").find().noCursorTimeout(true).batchSize(5000).cursor();){
            ArrayList<GoodsHead> entityList = new ArrayList<GoodsHead>();
            ArrayList<GoodsItem> itemList = new ArrayList<GoodsItem>();
            log.info("------------start GoodsJob cursor -----------1");
            while (cursor.hasNext()) {
                ++i;
                Document doc = (Document)cursor.next();
                try {
                    GoodsHead goods = this.genGoods(doc);
                    entityList.add(goods);
                    itemList.addAll(this.genGoodsItems(doc, goods.getId(), goods.getGoodsId()));
                }
                catch (Exception e) {
                    log.error("GoodsJob error ", (Throwable)e);
                }
                if (i % 200 != 0) continue;
                log.info("------------start GoodsJob cursor -----------" + i);
                this.goodsHeadService.saveOrUpdateBatch(entityList);
                this.goodsItemService.saveOrUpdateBatch(itemList);
                entityList = new ArrayList();
            }
            log.info("------------start GoodsJob cursor -----------" + i);
            this.goodsHeadService.saveOrUpdateBatch(entityList);
            this.goodsItemService.saveOrUpdateBatch(itemList);
        }
        catch (Exception e) {
            log.error("mongodb error", (Throwable)e);
        }
    }

    private List<GoodsItem> genGoodsItems(Document doc, String headId, String goodsId) throws UnsupportedEncodingException, ParseException {
        ArrayList<GoodsItem> items = new ArrayList<GoodsItem>();
        Map sale = this.getSale(doc);
        Map pv = this.getPv(doc);
        Map topMan = this.getTopMan(doc);
        for (String key : sale.keySet()) {
            GoodsItem goodsItem = new GoodsItem();
            BigDecimal value = (BigDecimal)sale.get(key);
            String id = Base64.getEncoder().encodeToString((headId + key).getBytes("utf-8"));
            goodsItem.setId(id);
            goodsItem.setGoodsId(goodsId);
            goodsItem.setElsAccount("100000");
            goodsItem.setSaleDate(DataFormatUtils.stringToDateYYYYMMDD(key));
            goodsItem.setSalesNum(value);
            goodsItem.setBrowsesNum((BigDecimal)pv.get(key));
            goodsItem.setTopmanNum((BigDecimal)topMan.get(key));
            items.add(goodsItem);
        }
        return items;
    }

    private GoodsHead genGoods(Document doc) {
        GoodsHead goods = new GoodsHead();
        goods.setId(doc.getString((Object)"_id"));
        goods.setPicture(doc.getString((Object)"good_pic"));
        goods.setCategory(doc.getString((Object)"first_cate_name"));
        goods.setName(doc.getString((Object)"good_name"));
        goods.setShopId(doc.getString((Object)"shop_id"));
        goods.setSalesNum(DataFormatUtils.numberToBigDecimal(doc.get((Object)"good_sell_num")));
        goods.setPrice(DataFormatUtils.numberToBigDecimal(doc.get((Object)"good_promotion_price")));
        goods.setElsAccount("100000");
        goods.setPlatform("1");
        goods.setCommissionRate(DataFormatUtils.numberToBigDecimal(doc.get((Object)"commission_rate")));
        goods.setBrowsesNum(DataFormatUtils.numberToBigDecimal(doc.get((Object)"good_total_pv")));
        goods.setGoodsId(doc.getString((Object)"good_id"));
        return goods;
    }

    private Map getTopMan(Document doc) {
        HashMap<String, BigDecimal> topMan = new HashMap<String, BigDecimal>();
        Document goodMonthInfo = (Document)doc.get((Object)"good_month_info", Document.class);
        List topManDateList = goodMonthInfo.getList((Object)"product_sale_x", String.class);
        List topManNumList = (List)goodMonthInfo.get((Object)"product_sale_y", List.class);
        int cnt = 0;
        int countNum = topManNumList.size();
        for (String topManDate : topManDateList) {
            if (cnt >= countNum) break;
            BigDecimal saleNum = DataFormatUtils.numberToBigDecimal(topManNumList.get(cnt));
            topMan.put(topManDate, saleNum);
            ++cnt;
        }
        return topMan;
    }

    private Map getPv(Document doc) {
        HashMap<String, BigDecimal> pv = new HashMap<String, BigDecimal>();
        Document goodMonthInfo = (Document)doc.get((Object)"good_month_info", Document.class);
        List pvDateList = goodMonthInfo.getList((Object)"pv_x", String.class);
        List pvNumList = (List)goodMonthInfo.get((Object)"pv_y", List.class);
        int cnt = 0;
        int countNum = pvNumList.size();
        for (String pvDate : pvDateList) {
            if (cnt >= countNum) break;
            BigDecimal pvNum = DataFormatUtils.numberToBigDecimal(pvNumList.get(cnt));
            pv.put(pvDate, pvNum);
            ++cnt;
        }
        return pv;
    }

    private Map getSale(Document doc) {
        HashMap<String, BigDecimal> sale = new HashMap<String, BigDecimal>();
        Document goodMonthInfo = (Document)doc.get((Object)"good_month_info", Document.class);
        List saleDateList = goodMonthInfo.getList((Object)"product_sale_x", String.class);
        List saleNumList = (List)goodMonthInfo.get((Object)"product_sale_y", List.class);
        int cnt = 0;
        int countNum = saleNumList.size();
        for (String saleDate : saleDateList) {
            if (cnt >= countNum) break;
            BigDecimal saleNum = DataFormatUtils.numberToBigDecimal(saleNumList.get(cnt));
            sale.put(saleDate, saleNum);
            ++cnt;
        }
        return sale;
    }
}

