/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.goods.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.system.query.QueryGenerator;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.SysUtil;
import com.els.modules.common.weboption.OptionFactory;
import com.els.modules.goods.dto.GoodsCollectDTO;
import com.els.modules.goods.dto.GoodsDTO;
import com.els.modules.goods.entity.Goods;
import com.els.modules.goods.entity.GoodsCollect;
import com.els.modules.goods.entity.GoodsItems;
import com.els.modules.goods.enumerate.GoodsOptionsType;
import com.els.modules.goods.enumerate.GoodsOptionsTypeGroup;
import com.els.modules.goods.mapper.GoodsCollectMapper;
import com.els.modules.goods.mapper.GoodsMapper;
import com.els.modules.goods.service.GoodsCollectService;
import com.els.modules.industryInfo.api.dto.SimplePostRequestParam;
import com.els.modules.industryInfo.api.weboption.TopManOptionsEntity;
import com.els.modules.topman.entity.RedBookTopManEntity;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.bson.Document;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class GoodsCollectServiceImpl
extends BaseServiceImpl<GoodsCollectMapper, GoodsCollect>
implements GoodsCollectService {
    @Autowired
    private GoodsMapper goodsMapper;

    @Override
    public List<TopManOptionsEntity> getOptions(String clearCache) {
        OptionFactory.OptionHandler<GoodsOptionsTypeGroup, GoodsOptionsType> init = OptionFactory.init(GoodsOptionsTypeGroup.class, GoodsOptionsType.class);
        init.setCollection("tb_goods_category").when(GoodsOptionsType.goodsInfo, (doc, param) -> this.optionsConverter(doc)).when(GoodsOptionsType.promotional, (doc, param) -> this.optionsConverter(doc));
        return init.getResult("collect", "1".equals(clearCache));
    }

    private List<TopManOptionsEntity.Tag> optionsConverter(Document doc) {
        List docList = doc.getList((Object)"directory_json", Document.class);
        return docList.stream().map(h -> {
            TopManOptionsEntity.TagCopy tag = new TopManOptionsEntity.TagCopy();
            tag.setId(h.get((Object)"id").toString());
            tag.setLabel(h.get((Object)"label").toString());
            tag.setValue(h.get((Object)"value").toString());
            tag.setComponentType(h.get((Object)"componentType").toString());
            tag.setChildren(this.getChildren((Document)h));
            return tag;
        }).collect(Collectors.toList());
    }

    private List<Object> getChildren(Document document) {
        List children = document.getList((Object)"children", Map.class);
        ArrayList<Object> tagCopyList = new ArrayList<Object>(children.size());
        if (CollectionUtil.isNotEmpty((Collection)children)) {
            children.forEach(a -> {
                TopManOptionsEntity.TagCopy tagCopy = new TopManOptionsEntity.TagCopy();
                tagCopy.setId(a.get("id").toString());
                tagCopy.setLabel(a.get("label").toString());
                tagCopy.setValue(a.get("value").toString());
                List children1 = (List)a.get("children");
                if (CollectionUtil.isEmpty((Collection)children1)) {
                    tagCopy.setChildren(null);
                } else {
                    ArrayList sonTagCopyList = new ArrayList(children1.size());
                    children1.forEach(b -> {
                        TopManOptionsEntity.TagCopy sonTagCopy = new TopManOptionsEntity.TagCopy();
                        sonTagCopy.setId(b.get("id") == null ? null : a.get("id").toString());
                        sonTagCopy.setLabel(b.get("label").toString());
                        sonTagCopy.setValue(b.get("value").toString());
                        sonTagCopy.setChildren(null);
                        sonTagCopyList.add(sonTagCopy);
                    });
                    tagCopy.setChildren(sonTagCopyList);
                }
                tagCopyList.add(tagCopy);
            });
        }
        return tagCopyList;
    }

    @Override
    public IPage<GoodsItems> queryCollectList(SimplePostRequestParam<GoodsDTO> param) {
        Page page = new Page((long)param.getPageNo().intValue(), (long)param.getPageSize().intValue());
        QueryWrapper<Goods> queryWrapper = this.getQueryWrapper(param);
        return this.goodsMapper.queryPageList((IPage<GoodsItems>)page, queryWrapper, SysUtil.getLoginUser());
    }

    private QueryWrapper<Goods> getQueryWrapper(SimplePostRequestParam<GoodsDTO> param) {
        String[] columns;
        String column;
        String string;
        List<GoodsDTO.ScreenItemField> promotionals;
        GoodsDTO dto = (GoodsDTO)param.getFilterInfo();
        GoodsDTO.ScreenItem screenItem = dto.getScreenItem();
        QueryWrapper query = new QueryWrapper();
        List<GoodsDTO.ScreenItemField> goodsInfos = screenItem.getGoodsInfo();
        if (CollectionUtil.isNotEmpty(goodsInfos)) {
            block18: for (GoodsDTO.ScreenItemField screenItemField : goodsInfos) {
                String value = (String)screenItemField.getValue();
                switch (screenItemField.getTitle()) {
                    case "\u5546\u54c1\u4ef7\u683c": {
                        this.handleEqString(value, (QueryWrapper<Goods>)query, Goods::getPriceRange);
                        continue block18;
                    }
                    case "\u4f63\u91d1\u6bd4\u4f8b": {
                        this.handleEqString(value, (QueryWrapper<Goods>)query, Goods::getCosRatio);
                        continue block18;
                    }
                    case "\u5546\u54c1\u9500\u91cf": {
                        this.handleEqString(value, (QueryWrapper<Goods>)query, Goods::getTotalSales);
                        continue block18;
                    }
                }
                throw new ELSBootException("\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u53c2\u6570\u7c7b\u578b");
            }
        }
        if (CollectionUtil.isNotEmpty(promotionals = screenItem.getPromotional())) {
            block19: for (GoodsDTO.ScreenItemField screenItemField : promotionals) {
                switch (screenItemField.getTitle()) {
                    case "\u6709\u76f4\u64ad\u5e26\u8d27": {
                        query.lambda().isNotNull(Goods::getLivesNum);
                        continue block19;
                    }
                    case "\u6709\u89c6\u9891\u5e26\u8d27": {
                        query.lambda().isNotNull(Goods::getVideosNum);
                        continue block19;
                    }
                }
                throw new ELSBootException("\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u53c2\u6570\u7c7b\u578b");
            }
        }
        if ((string = param.getKeyWord()) != null && string.trim().length() > 0) {
            query.and(q -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)q.lambda().like(Goods::getTitle, (Object)keyWord)).or(a -> {
                    LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)a.eq(Goods::getGoodsId, (Object)keyWord);
                });
            });
        }
        if ((column = param.getColumn()) != null && !"default".equals(column) && (columns = column.split(",")).length > 0) {
            final String order = param.getOrder();
            QueryGenerator.doMultiFieldsOrder((QueryWrapper)query, (Map)new HashMap<String, String[]>(2){
                {
                    super(x0);
                    this.put("order", order == null ? new String[columns.length] : order.split(","));
                    this.put("column", columns);
                }
            }, (Object)((Object)new RedBookTopManEntity()));
        }
        return query;
    }

    private void handleEqString(String value, QueryWrapper<Goods> query, SFunction<Goods, ?> field) {
        if (StringUtils.isBlank((CharSequence)value) || "\u5168\u90e8".equals(value) || "\u4e0d\u9650".equals(value)) {
            return;
        }
        query.lambda().eq(field, (Object)value);
    }

    @Override
    public List<GoodsItems> checkCollectList(List<String> goodsIds, LoginUser loginUser, Integer platform) {
        List<GoodsItems> collects = this.goodsMapper.checkCollect(goodsIds, SysUtil.getLoginUser(), platform);
        if (CollectionUtil.isNotEmpty(collects)) {
            Map<String, GoodsItems> map = collects.stream().collect(Collectors.toMap(GoodsItems::getGid, h -> h, (k1, k2) -> k1));
            collects.forEach(h -> h.setIsCollection(map.get(h.getGid()) != null ? ((GoodsItems)map.get(h.getGid())).getIsCollection() : 0));
        }
        return collects;
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void collect(GoodsCollectDTO dto) {
        if (dto.getCollect() == 1) {
            this.addMarkToSpider(dto);
        }
        this.collectHandle(dto);
    }

    private void collectHandle(GoodsCollectDTO dto) {
        LoginUser loginUser = SysUtil.getLoginUser();
        String elsAccount = loginUser.getElsAccount();
        String subAccount = loginUser.getSubAccount();
        GoodsItems entity = dto.getEntity();
        if (dto.getCollect() == 1) {
            GoodsCollect collect = new GoodsCollect();
            collect.setGoodsId(entity.getGid());
            collect.setPlatform(1);
            collect.setElsAccount(elsAccount);
            collect.setSubAccount(subAccount);
            this.save((Object)collect);
        } else {
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.lambda().eq(BaseEntity::getElsAccount, (Object)elsAccount);
            queryWrapper.lambda().eq(GoodsCollect::getSubAccount, (Object)subAccount);
            queryWrapper.lambda().eq(GoodsCollect::getPlatform, (Object)1);
            queryWrapper.lambda().eq(GoodsCollect::getGoodsId, (Object)entity.getGid());
            this.remove((Wrapper)queryWrapper);
        }
    }

    private void addMarkToSpider(GoodsCollectDTO dto) {
        this.saveEntity(dto.getEntity());
    }

    private void saveEntity(GoodsItems vo) {
        Goods entity = new Goods();
        entity.setGoodsId(vo.getGid());
        entity.setImageUrl(vo.getImageUrl());
        entity.setTitle(vo.getTitle());
        entity.setPriceRange(vo.getPriceRange());
        entity.setCosRatio(vo.getCosRatio());
        entity.setTotalSales(vo.getTotalSales30Day());
        entity.setLivesSales(vo.getLiveSales30Day());
        entity.setVideosSales(vo.getAwemeSales30Day());
        entity.setLivesNum(vo.getLive30Day());
        entity.setVideosNum(vo.getAweme30Day());
        entity.setDetailUrl(vo.getDetailUrl());
        QueryWrapper query = new QueryWrapper();
        query.lambda().eq(Goods::getGoodsId, (Object)entity.getGoodsId());
        Goods info = (Goods)((Object)this.goodsMapper.selectOne((Wrapper)query));
        if (info == null) {
            entity.setPlatform(1);
            entity.setId("");
            this.goodsMapper.insert((Object)entity);
        } else {
            entity.setId(info.getId());
            this.goodsMapper.updateById((Object)entity);
        }
    }
}

