/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.store.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.modules.store.dto.StoreHeadQueryDTO;
import com.els.modules.store.entity.StoreItem;
import com.els.modules.store.mapper.StoreItemMapper;
import com.els.modules.store.service.StoreItemService;
import java.math.BigDecimal;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class StoreItemServiceImpl
extends BaseServiceImpl<StoreItemMapper, StoreItem>
implements StoreItemService {
    @Autowired
    private StoreItemMapper storeItemMapper;

    @Override
    public List<StoreItem> selectByMainId(String mainId) {
        return this.storeItemMapper.selectByMainId(mainId);
    }

    @Override
    public List<StoreItem> queryList(StoreHeadQueryDTO queryDTO) {
        QueryWrapper queryWrapper = new QueryWrapper();
        this.criteriaQuery((QueryWrapper<StoreItem>)queryWrapper, queryDTO);
        return ((StoreItemMapper)this.baseMapper).selectList((Wrapper)queryWrapper);
    }

    @Override
    public StoreItem queryStoreItem(String headId, String timeSelect) {
        LambdaQueryWrapper queryWrapper = new QueryWrapper().lambda();
        queryWrapper.eq(StoreItem::getHeadId, (Object)headId);
        if (StringUtils.isBlank((CharSequence)timeSelect)) {
            timeSelect = "30";
        }
        queryWrapper.eq(StoreItem::getQueryDay, (Object)timeSelect);
        return (StoreItem)((Object)((StoreItemMapper)this.baseMapper).selectOne((Wrapper)queryWrapper));
    }

    private QueryWrapper<StoreItem> criteriaQuery(QueryWrapper<StoreItem> queryWrapper, StoreHeadQueryDTO queryDTO) {
        Boolean goodsVideo;
        Boolean goodsLive;
        String salesAmount;
        String videosNum;
        String timeSelect = queryDTO.getTimeSelect();
        if (StringUtils.isBlank((CharSequence)timeSelect)) {
            timeSelect = "30";
        }
        queryWrapper.lambda().eq(StoreItem::getQueryDay, (Object)timeSelect);
        String topman = queryDTO.getStoreTopmanNum();
        if (StringUtils.isNotBlank((CharSequence)topman)) {
            String[] strings;
            if (topman.contains("-")) {
                strings = topman.split("-");
                queryWrapper.lambda().gt(StoreItem::getTopmanNum, (Object)new BigDecimal(strings[0]));
                queryWrapper.lambda().le(StoreItem::getTopmanNum, (Object)new BigDecimal(strings[1]));
            } else if (topman.contains(">")) {
                strings = topman.split(">");
                queryWrapper.lambda().gt(StoreItem::getTopmanNum, (Object)new BigDecimal(strings[1]));
            } else {
                queryWrapper.lambda().eq(StoreItem::getTopmanNum, (Object)topman);
            }
        }
        if (StringUtils.isNotBlank((CharSequence)(videosNum = queryDTO.getStoreVideosNum()))) {
            String[] strings;
            if (videosNum.contains("-")) {
                strings = videosNum.split("-");
                queryWrapper.lambda().gt(StoreItem::getVideosNum, (Object)new BigDecimal(strings[0]));
                queryWrapper.lambda().le(StoreItem::getVideosNum, (Object)new BigDecimal(strings[1]));
            }
            if (videosNum.contains(">")) {
                strings = videosNum.split(">");
                queryWrapper.lambda().gt(StoreItem::getVideosNum, (Object)new BigDecimal(strings[1]));
            }
        }
        if (StringUtils.isNotBlank((CharSequence)(salesAmount = queryDTO.getStoreSalesAmount()))) {
            String[] strings;
            if (salesAmount.contains("-")) {
                strings = salesAmount.split("-");
                queryWrapper.lambda().gt(StoreItem::getSalesAmountMax, (Object)new BigDecimal(strings[0]));
                queryWrapper.lambda().le(StoreItem::getSalesAmountMax, (Object)new BigDecimal(strings[1]));
            }
            if (salesAmount.contains(">")) {
                strings = salesAmount.split(">");
                queryWrapper.lambda().gt(StoreItem::getSalesAmountMax, (Object)new BigDecimal(strings[1]));
            }
        }
        if ((goodsLive = queryDTO.getGoodsLive()) != null && goodsLive.booleanValue()) {
            queryWrapper.lambda().gt(StoreItem::getLivesNum, (Object)BigDecimal.ZERO);
        }
        if ((goodsVideo = queryDTO.getGoodsVideo()) != null && goodsVideo.booleanValue()) {
            queryWrapper.lambda().gt(StoreItem::getVideosNum, (Object)BigDecimal.ZERO);
        }
        return queryWrapper;
    }

    @Override
    public void deleteByMainId(String headId) {
        if (!StringUtils.isNotBlank((CharSequence)headId)) {
            throw new ELSBootException("\u8be5\u8bb0\u5f55\u4e0d\u5b58\u5728");
        }
        ((StoreItemMapper)this.baseMapper).deleteByMainId(headId);
    }

    @Override
    public void deleteBatch(List<String> mainIds) {
        if (!CollectionUtil.isNotEmpty(mainIds)) {
            throw new ELSBootException("\u8be5\u8bb0\u5f55\u4e0d\u5b58\u5728");
        }
        ((StoreItemMapper)this.baseMapper).deleteBatch(mainIds);
    }
}

