/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.knowledge.controller;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.text.CharSequenceUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.aspect.annotation.BusinessModule;
import com.els.common.aspect.annotation.SrmValidated;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.event.AsyncEventNotifier;
import com.els.common.event.AsyncEventType;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.query.QueryGenerator;
import com.els.common.util.AdminFlagUtil;
import com.els.common.util.I18nUtil;
import com.els.common.util.SysUtil;
import com.els.common.vo.CountVO;
import com.els.config.mybatis.TenantContext;
import com.els.modules.account.api.dto.LoginUserDTO;
import com.els.modules.base.api.dto.DictDTO;
import com.els.modules.base.api.service.BaseRpcService;
import com.els.modules.knowledge.dto.KnowledgeCatalogueDTO;
import com.els.modules.knowledge.dto.KnowledgePermDTO;
import com.els.modules.knowledge.entity.KnowledgeBase;
import com.els.modules.knowledge.entity.KnowledgeBaseCatalogue;
import com.els.modules.knowledge.entity.KnowledgeComment;
import com.els.modules.knowledge.entity.KnowledgeLike;
import com.els.modules.knowledge.enumerate.KnowledgeClassificationStatus;
import com.els.modules.knowledge.enumerate.KnowledgeStatusEnum;
import com.els.modules.knowledge.event.SupplierAsyncEventType;
import com.els.modules.knowledge.excel.KnowledgeVisitorExportServiceImpl;
import com.els.modules.knowledge.excel.PurchaseKnowledgeCommentExportServiceImpl;
import com.els.modules.knowledge.service.KnowledgeAccountPermService;
import com.els.modules.knowledge.service.KnowledgeBaseCatalogueService;
import com.els.modules.knowledge.service.KnowledgeBaseService;
import com.els.modules.knowledge.service.KnowledgeCollectService;
import com.els.modules.knowledge.service.KnowledgeCommentService;
import com.els.modules.knowledge.service.KnowledgeLikeService;
import com.els.modules.knowledge.service.KnowledgeVisitorService;
import com.els.modules.knowledge.vo.KnowledgeBaseVo;
import com.els.modules.knowledge.vo.KnowledgeCommentVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.ModelAndView;

@BusinessModule(module="knowledgeBase")
@Api(tags={"\u91c7\u8d2d\u8d44\u6599\u5e93"})
@RestController
@RequestMapping(value={"/knowledge/purchaseKnowledgeBase"})
public class PurchaseKnowledgeBaseController
extends BaseController<KnowledgeBase, KnowledgeBaseService> {
    @Autowired
    private KnowledgeBaseService knowledgeBaseService;
    @Autowired
    private KnowledgeAccountPermService knowledgeAccountPermService;
    @Autowired
    private KnowledgeCommentService knowledgeCommentService;
    @Autowired
    private KnowledgeCollectService knowledgeCollectService;
    @Autowired
    private KnowledgeLikeService knowledgeLikeService;
    @Autowired
    private BaseRpcService baseRpcService;
    @Autowired
    private KnowledgeVisitorService knowledgeVisitorService;
    @Autowired
    private KnowledgeBaseCatalogueService knowledgeBaseCatalogueService;

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2\u91c7\u8d2d\u8d44\u6599\u5e93", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2\u91c7\u8d2d\u8d44\u6599\u5e93")
    @GetMapping(value={"/list"})
    @RequiresPermissions(value={"knowledgeBase#KnowledgeBase:list"})
    public Result<?> queryPurchasePageList(KnowledgeBase purchaseKnowledgeBase, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        String status = purchaseKnowledgeBase.getStatus();
        if ("stayClassify".equals(status) || "beenClassified".equals(status)) {
            purchaseKnowledgeBase.setStatus(null);
            purchaseKnowledgeBase.setSaleKnowledgeStatus(status);
        }
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)purchaseKnowledgeBase), (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        if (CharSequenceUtil.isNotEmpty((CharSequence)purchaseKnowledgeBase.getSaleKnowledgeStatus())) {
            queryWrapper.eq((Object)"sale_knowledge_status", (Object)purchaseKnowledgeBase.getSaleKnowledgeStatus());
        }
        IPage<KnowledgeBase> pageList = this.knowledgeBaseService.pagePurchaseBase((Page<KnowledgeBase>)page, (QueryWrapper<KnowledgeBase>)queryWrapper);
        for (KnowledgeBase base : page.getRecords()) {
            base.setOtherAccount(!SysUtil.getLoginUser().getElsAccount().equals(base.getElsAccount()));
            if (!SysUtil.getLoginUser().getElsAccount().equals(base.getElsAccount()) && "stayClassify".equals(base.getSaleKnowledgeStatus())) {
                base.setHasCreatePerm("1".equals(AdminFlagUtil.getAdminFlag()));
                continue;
            }
            if ("1".equals(AdminFlagUtil.getAdminFlag())) {
                base.setHasCreatePerm(true);
                continue;
            }
            base.setHasCreatePerm(CharSequenceUtil.isNotEmpty((CharSequence)base.getAdminUser()) && base.getAdminUser().contains(SysUtil.getLoginUser().getId()));
        }
        return Result.ok(pageList);
    }

    private void baseDataBuild(KnowledgeBase base) {
        if ("0".equals(base.getNeedAudit())) {
            base.setAuditStatus(AuditStatusEnum.NO_AUDIT_REQUIRED.getValue());
        } else {
            base.setNeedAudit("1");
            base.setAuditStatus(AuditStatusEnum.AUDIT_NEW.getValue());
        }
        base.setBusAccount(TenantContext.getTenant());
        base.setLocked(CharSequenceUtil.emptyToDefault((CharSequence)base.getLocked(), (String)"0"));
        base.setStared(CharSequenceUtil.emptyToDefault((CharSequence)base.getStared(), (String)"0"));
        base.setAllowDown(CharSequenceUtil.emptyToDefault((CharSequence)base.getAllowDown(), (String)"0"));
        base.setAllowComment(CharSequenceUtil.emptyToDefault((CharSequence)base.getAllowComment(), (String)"0"));
    }

    @SrmValidated
    @AutoLog(value="\u91c7\u8d2d\u8d44\u6599\u5e93-\u6dfb\u52a0", businessNumber="#id", operateType=2)
    @ApiOperation(value="\u6dfb\u52a0", notes="\u6dfb\u52a0")
    @PostMapping(value={"/add"})
    @RequiresPermissions(value={"knowledgeBase#KnowledgeBase:add"})
    public Result<?> add(@RequestBody KnowledgeBase base) {
        base.setStatus(KnowledgeStatusEnum.NEW.getValue());
        this.baseDataBuild(base);
        this.knowledgeBaseService.savePurchaseKnowledgeBase(base);
        return Result.ok((Object)((Object)base));
    }

    @SrmValidated
    @AutoLog(value="\u91c7\u8d2d\u8d44\u6599\u5e93-\u7f16\u8f91")
    @ApiOperation(value="\u7f16\u8f91", notes="\u7f16\u8f91")
    @PostMapping(value={"/edit"})
    @RequiresPermissions(value={"knowledgeBase#KnowledgeBase:edit"})
    public Result<?> edit(@RequestBody KnowledgeBase base) {
        base.setStatus(KnowledgeStatusEnum.NEW.getValue());
        this.baseDataBuild(base);
        this.knowledgeBaseService.updatePurchaseKnowledgeBase(base);
        String id = base.getId();
        return this.queryById(id);
    }

    @SrmValidated
    @AutoLog(value="\u91c7\u8d2d\u8d44\u6599\u5e93-\u53d1\u5e03")
    @ApiOperation(value="\u53d1\u5e03", notes="\u53d1\u5e03")
    @PostMapping(value={"/purchase-publish"})
    @RequiresPermissions(value={"knowledgeBase#KnowledgeBase:publish"})
    public Result<?> publish(@RequestBody KnowledgeBase base) {
        KnowledgeBase old = (KnowledgeBase)((Object)this.knowledgeBaseService.getById((Serializable)((Object)base.getId())));
        if (null == old) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_xMKrJL_611f80bd", (String)"\u4e0d\u5b58\u5728\u8be5\u8d44\u6599"));
        }
        if (KnowledgeStatusEnum.PUBLISH.getValue().equals(old.getStatus())) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APJLIOhx_b989105e", (String)"\u5f53\u524d\u8d44\u6599\u5df2\u7ecf\u53d1\u5e03"));
        }
        if ("1".equals(base.getNeedAudit()) && !AuditStatusEnum.AUDIT_FINISH.getValue().equals(base.getAuditStatus())) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APJLLeRUzWxiThx_f79e03aa", (String)"\u5f53\u524d\u8d44\u6599\u672a\u901a\u8fc7\u5ba1\u6279\uff0c\u4e0d\u5141\u8bb8\u53d1\u5e03"));
        }
        this.knowledgeBaseService.publish(base);
        return this.commonSuccessResult(3);
    }

    @AutoLog(value="\u91c7\u8d2d\u8d44\u6599\u5e93-\u901a\u8fc7id\u5220\u9664")
    @ApiOperation(value="\u901a\u8fc7id\u5220\u9664", notes="\u901a\u8fc7id\u5220\u9664")
    @GetMapping(value={"/delete"})
    @RequiresPermissions(value={"knowledgeBase#KnowledgeBase:delete"})
    public Result<?> delete(@RequestParam(name="id") String id) {
        this.knowledgeBaseService.delPurchaseKnowledgeBase(id);
        return Result.ok();
    }

    @AutoLog(value="\u91c7\u8d2d\u8d44\u6599\u5e93-\u901a\u8fc7id\u51bb\u7ed3")
    @ApiOperation(value="\u901a\u8fc7id\u51bb\u7ed3", notes="\u901a\u8fc7id\u51bb\u7ed3")
    @PostMapping(value={"/freeze/{id}"})
    @RequiresPermissions(value={"knowledgeBase#KnowledgeBase:freeze"})
    public Result<?> freeze(@PathVariable(value="id") String id) {
        this.knowledgeBaseService.freeze(id);
        return Result.ok();
    }

    @AutoLog(value="\u91c7\u8d2d\u8d44\u6599\u5e93-\u901a\u8fc7id\u89e3\u51bb")
    @ApiOperation(value="\u901a\u8fc7id\u89e3\u51bb", notes="\u901a\u8fc7id\u89e3\u51bb")
    @PostMapping(value={"/thaw/{id}"})
    @RequiresPermissions(value={"knowledgeBase#KnowledgeBase:thaw"})
    public Result<?> thaw(@PathVariable(value="id") String id) {
        this.knowledgeBaseService.thaw(id);
        return Result.ok();
    }

    @AutoLog(value="\u91c7\u8d2d\u8d44\u6599\u5e93-\u901a\u8fc7id\u4f5c\u5e9f")
    @ApiOperation(value="\u901a\u8fc7id\u4f5c\u5e9f", notes="\u901a\u8fc7id\u4f5c\u5e9f")
    @PostMapping(value={"/cancel/{id}"})
    @RequiresPermissions(value={"knowledgeBase#KnowledgeBase:cancel"})
    public Result<?> cancel(@PathVariable(value="id") String id) {
        this.knowledgeBaseService.cancel(id);
        return Result.ok();
    }

    @ApiOperation(value="\u901a\u8fc7id\u67e5\u8be2", notes="\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    @RequiresPermissions(value={"knowledgeBase#KnowledgeBase:view"})
    public Result<?> queryById(@RequestParam(name="id") String id) {
        KnowledgeBase purchaseKnowledgeBase = (KnowledgeBase)((Object)this.knowledgeBaseService.getOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"id", (Object)id)).eq((Object)"els_account", (Object)TenantContext.getTenant())));
        if (null == purchaseKnowledgeBase) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_xMKrJL_611f80bd", (String)"\u4e0d\u5b58\u5728\u8be5\u8d44\u6599"));
        }
        if (TenantContext.getTenant().equals(purchaseKnowledgeBase.getElsAccount())) {
            purchaseKnowledgeBase.setSaleKnowledgeStatus(KnowledgeClassificationStatus.BEEN_CLASSIFIED.getValue());
            purchaseKnowledgeBase.setClassificationTime(purchaseKnowledgeBase.getUpdateTime());
            purchaseKnowledgeBase.setClassificationBy(purchaseKnowledgeBase.getUpdateBy());
        } else {
            KnowledgeBaseCatalogue catalogue = this.knowledgeBaseCatalogueService.queryByKnowIdAndEslAccount(TenantContext.getTenant(), purchaseKnowledgeBase.getId());
            if (null == catalogue) {
                purchaseKnowledgeBase.setSaleKnowledgeStatus(KnowledgeClassificationStatus.STAY_CLASSIFY.getValue());
            } else {
                purchaseKnowledgeBase.setSaleKnowledgeStatus(catalogue.getSaleKnowledgeStatus());
                purchaseKnowledgeBase.setClassificationTime(catalogue.getClassificationTime());
                purchaseKnowledgeBase.setClassificationBy(catalogue.getClassificationBy());
                purchaseKnowledgeBase.setKnowledgeCatalogue(catalogue.getSaleKnowledgeCatalogue());
                purchaseKnowledgeBase.setKnowledgeCatalogue_dictText(catalogue.getKnowledgeCatalogue_dictText());
            }
        }
        List<String> elsSubAccountList = this.knowledgeAccountPermService.listAccount(id);
        purchaseKnowledgeBase.setVisitorPermElsAccount(elsSubAccountList);
        purchaseKnowledgeBase.setVisitorPermElsAccountString(CollUtil.join(elsSubAccountList, (CharSequence)","));
        List attachmentListByMainId = this.baseRpcService.getPurchaseAttachmentListByMainId(id);
        purchaseKnowledgeBase.setAttachmentList(attachmentListByMainId);
        return Result.ok((Object)((Object)purchaseKnowledgeBase));
    }

    @ApiOperation(value="\u901a\u8fc7id\u67e5\u8be2", notes="\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryDetailById"})
    @RequiresPermissions(value={"knowledgeBase#KnowledgeBase:view"})
    public Result<?> queryDetailById(@RequestParam(name="id") String id) {
        KnowledgeBase purchaseKnowledgeBase = (KnowledgeBase)((Object)this.knowledgeBaseService.getOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"id", (Object)id)).eq((Object)"els_account", (Object)TenantContext.getTenant())));
        if (null == purchaseKnowledgeBase) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_xMKrJL_611f80bd", (String)"\u4e0d\u5b58\u5728\u8be5\u8d44\u6599"));
        }
        if (TenantContext.getTenant().equals(purchaseKnowledgeBase.getElsAccount())) {
            purchaseKnowledgeBase.setSaleKnowledgeStatus(KnowledgeClassificationStatus.BEEN_CLASSIFIED.getValue());
            purchaseKnowledgeBase.setClassificationTime(purchaseKnowledgeBase.getUpdateTime());
            purchaseKnowledgeBase.setClassificationBy(purchaseKnowledgeBase.getUpdateBy());
        } else {
            KnowledgeBaseCatalogue catalogue = this.knowledgeBaseCatalogueService.queryByKnowIdAndEslAccount(TenantContext.getTenant(), purchaseKnowledgeBase.getId());
            if (null == catalogue) {
                purchaseKnowledgeBase.setSaleKnowledgeStatus(KnowledgeClassificationStatus.STAY_CLASSIFY.getValue());
            } else {
                purchaseKnowledgeBase.setSaleKnowledgeStatus(catalogue.getSaleKnowledgeStatus());
                purchaseKnowledgeBase.setClassificationTime(catalogue.getClassificationTime());
                purchaseKnowledgeBase.setClassificationBy(catalogue.getClassificationBy());
                purchaseKnowledgeBase.setKnowledgeCatalogue(catalogue.getSaleKnowledgeCatalogue());
                purchaseKnowledgeBase.setKnowledgeCatalogue_dictText(catalogue.getKnowledgeCatalogue_dictText());
            }
        }
        IPage<KnowledgeCommentVo> commentList = this.knowledgeCommentService.pageRootTreeCommentByKnowledgeId(id, (Page<KnowledgeComment>)new Page(0L, 10000L));
        KnowledgeBaseVo result = (KnowledgeBaseVo)((Object)Convert.convert(KnowledgeBaseVo.class, (Object)((Object)purchaseKnowledgeBase)));
        result.setCommentList(commentList);
        boolean collect = this.knowledgeCollectService.checkIfExists(id, SysUtil.getLoginUser().getId());
        result.setCollect(collect);
        boolean like = this.knowledgeLikeService.checkIfExists(id, SysUtil.getLoginUser().getId());
        result.setLike(like);
        this.knowledgeVisitorService.logVisitor(purchaseKnowledgeBase, SysUtil.getLoginUser().getId());
        List attachmentListByMainId = this.baseRpcService.getPurchaseAttachmentListByMainId(id);
        result.setAttachmentList(attachmentListByMainId);
        return Result.ok((Object)((Object)result));
    }

    @ApiOperation(value="\u901a\u8fc7id\u67e5\u8be2", notes="\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/look"})
    @RequiresPermissions(value={"knowledgeBase#KnowledgeBase:view"})
    public Result<?> look(@RequestParam(name="id") String id) {
        KnowledgeBase purchaseKnowledgeBase = (KnowledgeBase)((Object)this.knowledgeBaseService.getOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"id", (Object)id)).eq((Object)"els_account", (Object)TenantContext.getTenant())));
        if (null == purchaseKnowledgeBase) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_xMKrJL_611f80bd", (String)"\u4e0d\u5b58\u5728\u8be5\u8d44\u6599"));
        }
        this.knowledgeVisitorService.logVisitor(purchaseKnowledgeBase, SysUtil.getLoginUser().getId());
        return Result.ok();
    }

    @AutoLog(value="\u8d44\u6599\u7ba1\u7406-\u8bbe\u4e3a\u63a8\u8350\u6587\u6863")
    @ApiOperation(value="\u8bbe\u4e3a\u63a8\u8350\u6587\u6863", notes="\u8bbe\u4e3a\u63a8\u8350\u6587\u6863")
    @PostMapping(value={"/settingRecommend"})
    @RequiresPermissions(value={"knowledgeBase#KnowledgeBase:settingRecommend"})
    public Result<?> settingRecommend(@RequestBody List<String> ids) {
        LambdaUpdateWrapper wrapper = Wrappers.lambdaUpdate();
        ((LambdaUpdateWrapper)wrapper.eq(BaseEntity::getElsAccount, (Object)TenantContext.getTenant())).in(BaseEntity::getId, ids);
        wrapper.set(KnowledgeBase::getStared, (Object)"1");
        this.knowledgeBaseService.update((Wrapper)wrapper);
        return Result.ok();
    }

    @AutoLog(value="\u8d44\u6599\u7ba1\u7406-\u8bbe\u4e3a\u4e0b\u8f7d\u6743\u9650")
    @ApiOperation(value="\u8bbe\u7f6e\u4e0b\u8f7d\u6743\u9650", notes="\u8bbe\u7f6e\u4e0b\u8f7d\u6743\u9650")
    @PostMapping(value={"/settingDownPerm/{perm}"})
    @RequiresPermissions(value={"knowledgeBase#KnowledgeBase:settingDownPerm"})
    public Result<?> settingDownPerm(@RequestBody List<String> ids, @PathVariable(value="perm") String perm) {
        LambdaUpdateWrapper wrapper = Wrappers.lambdaUpdate();
        ((LambdaUpdateWrapper)wrapper.eq(BaseEntity::getElsAccount, (Object)TenantContext.getTenant())).in(BaseEntity::getId, ids);
        wrapper.set(KnowledgeBase::getAllowDown, (Object)("1".equals(perm) ? perm : "0"));
        this.knowledgeBaseService.update((Wrapper)wrapper);
        return Result.ok();
    }

    @AutoLog(value="\u8d44\u6599\u7ba1\u7406-\u8bbe\u7f6e\u8bbf\u95ee\u6743\u9650")
    @ApiOperation(value="\u8bbe\u7f6e\u8bbf\u95ee\u6743\u9650", notes="\u8bbe\u7f6e\u8bbf\u95ee\u6743\u9650")
    @PostMapping(value={"/settingVisitorPerm"})
    @RequiresPermissions(value={"knowledgeBase#KnowledgeBase:settingVisitorPerm"})
    public Result<?> settingVisitorPerm(@RequestBody KnowledgePermDTO permDTO) {
        this.knowledgeBaseService.settingVisitorPerm(permDTO);
        return Result.ok();
    }

    @AutoLog(value="\u8d44\u6599\u7ba1\u7406-\u8bbe\u7f6e\u5206\u7c7b\u76ee\u5f55")
    @ApiOperation(value="\u8bbe\u7f6e\u5206\u7c7b\u76ee\u5f55", notes="\u8bbe\u7f6e\u5206\u7c7b\u76ee\u5f55")
    @PostMapping(value={"/settingCatalogue"})
    @RequiresPermissions(value={"knowledgeBase#KnowledgeBase:settingCatalogue"})
    public Result<?> settingCatalogue(@RequestBody KnowledgeCatalogueDTO catalogueDTO) {
        this.knowledgeBaseService.settingCatalogue(catalogueDTO);
        return Result.ok();
    }

    @AutoLog(value="\u8d44\u6599\u7ba1\u7406-\u5bfc\u51fa\u8bbf\u95ee\u8bb0\u5f55")
    @ApiOperation(value="\u5bfc\u51fa\u8bbf\u95ee\u8bb0\u5f55", notes="\u5bfc\u51fa\u8bbf\u95ee\u8bb0\u5f55")
    @PostMapping(value={"/exportVisitorLog"})
    @RequiresPermissions(value={"knowledgeBase#KnowledgeBase:exportVisitorLog"})
    public ModelAndView exportVisitorLog(HttpServletRequest request, @RequestBody Map<String, Object> object) {
        return super.exportXls(request, object, KnowledgeVisitorExportServiceImpl.class);
    }

    @AutoLog(value="\u8d44\u6599\u7ba1\u7406-\u5bfc\u51fa\u8bc4\u8bba")
    @ApiOperation(value="\u5bfc\u51fa\u8bc4\u8bba", notes="\u5bfc\u51fa\u8bc4\u8bba")
    @PostMapping(value={"/exportComment"})
    @RequiresPermissions(value={"knowledgeBase#KnowledgeBase:exportComment"})
    public ModelAndView exportComment(HttpServletRequest request, @RequestBody Map<String, Object> object) {
        return super.exportXls(request, object, PurchaseKnowledgeCommentExportServiceImpl.class);
    }

    @AutoLog(value="\u8d44\u6599\u7ba1\u7406-\u70b9\u8d5e")
    @ApiOperation(value="\u70b9\u8d5e", notes="\u70b9\u8d5e")
    @PostMapping(value={"/like/{knowledgeId}"})
    @RequiresPermissions(value={"knowledgeBase#KnowledgeBase:settingDownPerm"})
    public Result<?> like(@PathVariable(value="knowledgeId") String knowledgeId) {
        KnowledgeBase base = (KnowledgeBase)((Object)this.knowledgeBaseService.getById((Serializable)((Object)knowledgeId)));
        if (null == base) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_xMKrJL_611f80bd", (String)"\u4e0d\u5b58\u5728\u8be5\u8d44\u6599"));
        }
        LoginUserDTO loginUser = SysUtil.getLoginUser();
        boolean exists = this.knowledgeLikeService.checkIfExists(knowledgeId, loginUser.getId());
        if (exists) {
            this.knowledgeLikeService.removeLike(knowledgeId, loginUser.getId());
            AsyncEventNotifier.notify((String)base.getId(), (AsyncEventType)SupplierAsyncEventType.KNOWLEDGE_VOLUME_REFRESH);
            return Result.ok();
        }
        KnowledgeLike like = new KnowledgeLike();
        like.setKnowledgeId(knowledgeId);
        like.setCreateTime(new Date());
        like.setKnowledgeTitle(base.getKnowledgeTitle());
        like.setAccountId(loginUser.getId());
        like.setCreateBy(loginUser.getElsAccount() + "_" + loginUser.getSubAccount());
        this.knowledgeLikeService.save(like);
        AsyncEventNotifier.notify((String)knowledgeId, (AsyncEventType)SupplierAsyncEventType.KNOWLEDGE_VOLUME_REFRESH);
        return Result.ok((String)like.getId());
    }

    @ApiOperation(value="\u901a\u8fc7\u5217\u8868\u9875\u9875\u7b7e\u6570\u91cf\u67e5\u8be2", notes="\u5217\u8868\u9875\u9875\u7b7e\u6570\u91cf\u67e5\u8be2")
    @GetMapping(value={"/counts"})
    @RequiresPermissions(value={"knowledgeBase#KnowledgeBase:list"})
    public Result<?> queryTabsCount(KnowledgeBase knowledgeBase, HttpServletRequest req) {
        Integer total;
        ArrayList<CountVO> result = new ArrayList<CountVO>();
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.select(new String[]{"status", "count(0) as participateQuantity"});
        queryWrapper.groupBy((Object)"status");
        List<KnowledgeBase> list = this.knowledgeBaseService.listPurchaseBaseToCount((QueryWrapper<KnowledgeBase>)queryWrapper);
        Map<String, Integer> countMap = list.stream().collect(Collectors.toMap(KnowledgeBase::getStatus, KnowledgeBase::getParticipateQuantity));
        Integer all = 0;
        for (Map.Entry<String, Integer> entry : countMap.entrySet()) {
            all = all + entry.getValue();
        }
        result.add(new CountVO(I18nUtil.translate((String)"i18n_title_all", (String)"\u5168\u90e8"), "status", null, all));
        List srmRectificationAppealStatus = this.baseRpcService.queryDictItemsByCode("knowledgeStatus", TenantContext.getTenant());
        for (DictDTO status : srmRectificationAppealStatus) {
            total = countMap.get(status.getValue()) == null ? 0 : countMap.get(status.getValue());
            result.add(new CountVO(I18nUtil.translate((String)status.getTextI18nKey(), (String)status.getText()), "status", status.getValue(), total));
        }
        queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)knowledgeBase), (Map)req.getParameterMap());
        queryWrapper.select(new String[]{"sale_knowledge_status", "count(0) as participateQuantity"});
        queryWrapper.groupBy((Object)"sale_knowledge_status");
        list = this.knowledgeBaseService.listPurchaseBaseToCount((QueryWrapper<KnowledgeBase>)queryWrapper);
        countMap = list.stream().collect(Collectors.toMap(KnowledgeBase::getSaleKnowledgeStatus, KnowledgeBase::getParticipateQuantity));
        srmRectificationAppealStatus = this.baseRpcService.queryDictItemsByCode("saleKnowledgeClassificationStatus", TenantContext.getTenant());
        for (DictDTO status : srmRectificationAppealStatus) {
            total = countMap.get(status.getValue()) == null ? 0 : countMap.get(status.getValue());
            result.add(new CountVO(I18nUtil.translate((String)status.getTextI18nKey(), (String)status.getText()), "status", status.getValue(), total));
        }
        return Result.ok(result);
    }
}

