/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.knowledge.controller;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.text.CharSequenceUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.aspect.annotation.BusinessModule;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.query.QueryGenerator;
import com.els.common.util.AdminFlagUtil;
import com.els.common.util.I18nUtil;
import com.els.common.util.SysUtil;
import com.els.common.vo.CountVO;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.DictDTO;
import com.els.modules.base.api.service.BaseRpcService;
import com.els.modules.knowledge.dto.KnowledgeCatalogueDTO;
import com.els.modules.knowledge.entity.KnowledgeBase;
import com.els.modules.knowledge.entity.KnowledgeBaseCatalogue;
import com.els.modules.knowledge.entity.KnowledgeComment;
import com.els.modules.knowledge.enumerate.KnowledgeClassificationStatus;
import com.els.modules.knowledge.excel.SaleKnowledgeCommentExportServiceImpl;
import com.els.modules.knowledge.excel.SaleKnowledgeVisitorExportServiceImpl;
import com.els.modules.knowledge.service.KnowledgeAccountPermService;
import com.els.modules.knowledge.service.KnowledgeBaseCatalogueService;
import com.els.modules.knowledge.service.KnowledgeBaseService;
import com.els.modules.knowledge.service.KnowledgeCollectService;
import com.els.modules.knowledge.service.KnowledgeCommentService;
import com.els.modules.knowledge.service.KnowledgeLikeService;
import com.els.modules.knowledge.service.KnowledgeVisitorService;
import com.els.modules.knowledge.vo.KnowledgeBaseVo;
import com.els.modules.knowledge.vo.KnowledgeCommentVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.ModelAndView;

@Api(tags={"\u91c7\u8d2d\u8d44\u6599\u5e93"})
@BusinessModule(module="knowledgeBase")
@RestController
@RequestMapping(value={"/knowledge/saleKnowledgeBase"})
public class SaleKnowledgeBaseController
extends BaseController<KnowledgeBase, KnowledgeBaseService> {
    @Autowired
    private KnowledgeBaseService knowledgeBaseService;
    @Autowired
    private KnowledgeCommentService knowledgeCommentService;
    @Autowired
    private KnowledgeCollectService knowledgeCollectService;
    @Autowired
    private KnowledgeVisitorService knowledgeVisitorService;
    @Autowired
    private KnowledgeAccountPermService knowledgeAccountPermService;
    @Autowired
    private KnowledgeBaseCatalogueService knowledgeBaseCatalogueService;
    @Autowired
    private KnowledgeLikeService knowledgeLikeService;
    @Autowired
    private BaseRpcService baseRpcService;

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2\u9500\u552e\u8d44\u6599", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2\u9500\u552e\u8d44\u6599")
    @GetMapping(value={"/list"})
    @RequiresPermissions(value={"knowledgeBase#SaleKnowledgeBase:list"})
    public Result<?> querySalePageList(KnowledgeBase purchaseKnowledgeBase, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        String status = purchaseKnowledgeBase.getStatus();
        if ("stayClassify".equals(status) || "beenClassified".equals(status)) {
            purchaseKnowledgeBase.setStatus(null);
            purchaseKnowledgeBase.setSaleKnowledgeStatus(status);
        }
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)purchaseKnowledgeBase), (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        if (CharSequenceUtil.isNotEmpty((CharSequence)purchaseKnowledgeBase.getSaleKnowledgeStatus())) {
            queryWrapper.eq((Object)"sale_knowledge_status", (Object)purchaseKnowledgeBase.getSaleKnowledgeStatus());
        }
        IPage<KnowledgeBase> pageList = this.knowledgeBaseService.pageSaleBase((Page<KnowledgeBase>)page, (QueryWrapper<KnowledgeBase>)queryWrapper);
        for (KnowledgeBase base : page.getRecords()) {
            if (!SysUtil.getLoginUser().getElsAccount().equals(base.getElsAccount()) && "stayClassify".equals(base.getSaleKnowledgeStatus())) {
                base.setHasCreatePerm("1".equals(AdminFlagUtil.getAdminFlag()));
                continue;
            }
            if ("1".equals(AdminFlagUtil.getAdminFlag())) {
                base.setHasCreatePerm(true);
                continue;
            }
            if (CharSequenceUtil.isNotEmpty((CharSequence)base.getAdminUser()) && base.getAdminUser().contains(SysUtil.getLoginUser().getId())) {
                base.setHasCreatePerm(true);
                continue;
            }
            base.setHasCreatePerm(false);
        }
        return Result.ok(pageList);
    }

    @ApiOperation(value="\u901a\u8fc7id\u67e5\u8be2", notes="\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryDetailById"})
    @RequiresPermissions(value={"knowledgeBase#SaleKnowledgeBase:view"})
    public Result<?> querySaleDetailById(@RequestParam(name="id") String id) {
        KnowledgeBase purchaseKnowledgeBase = (KnowledgeBase)((Object)this.knowledgeBaseService.getOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"id", (Object)id)).eq((Object)"els_account", (Object)TenantContext.getTenant())));
        if (null == purchaseKnowledgeBase) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_xMKrJL_611f80bd", (String)"\u4e0d\u5b58\u5728\u8be5\u8d44\u6599"));
        }
        if (TenantContext.getTenant().equals(purchaseKnowledgeBase.getElsAccount())) {
            purchaseKnowledgeBase.setSaleKnowledgeStatus(KnowledgeClassificationStatus.BEEN_CLASSIFIED.getValue());
            purchaseKnowledgeBase.setClassificationTime(purchaseKnowledgeBase.getUpdateTime());
            purchaseKnowledgeBase.setClassificationBy(purchaseKnowledgeBase.getUpdateBy());
        } else {
            KnowledgeBaseCatalogue catalogue = this.knowledgeBaseCatalogueService.queryByKnowIdAndEslAccount(TenantContext.getTenant(), purchaseKnowledgeBase.getId());
            if (null == catalogue) {
                purchaseKnowledgeBase.setSaleKnowledgeStatus(KnowledgeClassificationStatus.STAY_CLASSIFY.getValue());
            } else {
                purchaseKnowledgeBase.setSaleKnowledgeStatus(catalogue.getSaleKnowledgeStatus());
                purchaseKnowledgeBase.setClassificationTime(catalogue.getClassificationTime());
                purchaseKnowledgeBase.setClassificationBy(catalogue.getClassificationBy());
                purchaseKnowledgeBase.setKnowledgeCatalogue(catalogue.getSaleKnowledgeCatalogue());
                purchaseKnowledgeBase.setKnowledgeCatalogue_dictText(catalogue.getKnowledgeCatalogue_dictText());
            }
        }
        IPage<KnowledgeCommentVo> commentList = this.knowledgeCommentService.pageRootTreeCommentByKnowledgeId(id, (Page<KnowledgeComment>)new Page(0L, 10000L));
        KnowledgeBaseVo result = (KnowledgeBaseVo)((Object)Convert.convert(KnowledgeBaseVo.class, (Object)((Object)purchaseKnowledgeBase)));
        result.setCommentList(commentList);
        boolean collect = this.knowledgeCollectService.checkIfExists(id, SysUtil.getLoginUser().getId());
        result.setCollect(collect);
        boolean like = this.knowledgeLikeService.checkIfExists(id, SysUtil.getLoginUser().getId());
        result.setLike(like);
        this.knowledgeVisitorService.logVisitor(purchaseKnowledgeBase, SysUtil.getLoginUser().getId());
        List attachmentListByMainId = this.baseRpcService.getPurchaseAttachmentListByMainId(id);
        result.setAttachmentList(attachmentListByMainId);
        return Result.ok((Object)((Object)result));
    }

    @ApiOperation(value="\u901a\u8fc7id\u67e5\u8be2", notes="\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/look"})
    @RequiresPermissions(value={"knowledgeBase#SaleKnowledgeBase:view"})
    public Result<?> look(@RequestParam(name="id") String id) {
        KnowledgeBase purchaseKnowledgeBase = (KnowledgeBase)((Object)this.knowledgeBaseService.getOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"id", (Object)id)).eq((Object)"els_account", (Object)TenantContext.getTenant())));
        if (null == purchaseKnowledgeBase) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_xMKrJL_611f80bd", (String)"\u4e0d\u5b58\u5728\u8be5\u8d44\u6599"));
        }
        this.knowledgeVisitorService.logVisitor(purchaseKnowledgeBase, SysUtil.getLoginUser().getId());
        return Result.ok();
    }

    @ApiOperation(value="\u901a\u8fc7id\u67e5\u8be2", notes="\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    @RequiresPermissions(value={"knowledgeBase#SaleKnowledgeBase:view"})
    public Result<?> queryDetailById(@RequestParam(name="id") String id) {
        KnowledgeBase base = this.knowledgeBaseService.querySaleById(id);
        if (null == base) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_xMKrJL_611f80bd", (String)"\u4e0d\u5b58\u5728\u8be5\u8d44\u6599"));
        }
        IPage<KnowledgeCommentVo> commentList = this.knowledgeCommentService.pageRootTreeCommentByKnowledgeId(id, (Page<KnowledgeComment>)new Page(0L, 10L));
        KnowledgeBaseVo result = (KnowledgeBaseVo)((Object)Convert.convert(KnowledgeBaseVo.class, (Object)((Object)base)));
        result.setCommentList(commentList);
        result.setCollect(this.knowledgeCollectService.checkIfExists(id, SysUtil.getLoginUser().getId()));
        this.knowledgeVisitorService.logVisitor(base, SysUtil.getLoginUser().getId());
        List<String> elsSubAccountList = this.knowledgeAccountPermService.listAccount(id);
        result.setVisitorPermElsAccount(elsSubAccountList);
        result.setVisitorPermElsAccountString(CollUtil.join(elsSubAccountList, (CharSequence)","));
        List attachmentListByMainId = this.baseRpcService.getPurchaseAttachmentListByMainId(id);
        result.setAttachmentList(attachmentListByMainId);
        return Result.ok((Object)((Object)result));
    }

    @AutoLog(value="\u8d44\u6599\u7ba1\u7406-\u5bfc\u51fa\u8bbf\u95ee\u8bb0\u5f55")
    @ApiOperation(value="\u5bfc\u51fa\u8bbf\u95ee\u8bb0\u5f55", notes="\u5bfc\u51fa\u8bbf\u95ee\u8bb0\u5f55")
    @PostMapping(value={"/exportVisitorLog"})
    @RequiresPermissions(value={"knowledgeBase#SaleKnowledgeBase:exportVisitorLog"})
    public ModelAndView exportVisitorLog(HttpServletRequest request, @RequestBody Map<String, Object> object) {
        return super.exportXls(request, object, SaleKnowledgeVisitorExportServiceImpl.class);
    }

    @AutoLog(value="\u8d44\u6599\u7ba1\u7406-\u5bfc\u51fa\u8bc4\u8bba")
    @ApiOperation(value="\u5bfc\u51fa\u8bc4\u8bba", notes="\u5bfc\u51fa\u8bc4\u8bba")
    @PostMapping(value={"/exportComment"})
    @RequiresPermissions(value={"knowledgeBase#SaleKnowledgeBase:exportComment"})
    public ModelAndView exportComment(HttpServletRequest request, @RequestBody Map<String, Object> object) {
        return super.exportXls(request, object, SaleKnowledgeCommentExportServiceImpl.class);
    }

    @AutoLog(value="\u8d44\u6599\u7ba1\u7406-\u8bbe\u7f6e\u5206\u7c7b\u76ee\u5f55")
    @ApiOperation(value="\u8bbe\u7f6e\u5206\u7c7b\u76ee\u5f55", notes="\u8bbe\u7f6e\u5206\u7c7b\u76ee\u5f55")
    @PostMapping(value={"/settingCatalogue"})
    @RequiresPermissions(value={"knowledgeBase#SaleKnowledgeBase:settingCatalogue"})
    public Result<?> saleSettingCatalogue(@RequestBody KnowledgeCatalogueDTO catalogueDTO) {
        this.knowledgeBaseService.saleSettingCatalogue(catalogueDTO);
        return Result.ok();
    }

    @ApiOperation(value="\u901a\u8fc7\u5217\u8868\u9875\u9875\u7b7e\u6570\u91cf\u67e5\u8be2", notes="\u5217\u8868\u9875\u9875\u7b7e\u6570\u91cf\u67e5\u8be2")
    @GetMapping(value={"/counts"})
    @RequiresPermissions(value={"knowledgeBase#SaleKnowledgeBase:list"})
    public Result<?> queryTabsCount(KnowledgeBase knowledgeBase, HttpServletRequest req) {
        ArrayList<CountVO> result = new ArrayList<CountVO>();
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.select(new String[]{"sale_knowledge_status", "count(0) as participateQuantity"});
        queryWrapper.groupBy((Object)"sale_knowledge_status");
        List<KnowledgeBase> list = this.knowledgeBaseService.listSaleBaseToCount((QueryWrapper<KnowledgeBase>)queryWrapper);
        Map<String, Integer> countMap = list.stream().collect(Collectors.toMap(KnowledgeBase::getSaleKnowledgeStatus, KnowledgeBase::getParticipateQuantity));
        Integer all = 0;
        for (Map.Entry<String, Integer> entry : countMap.entrySet()) {
            all = all + entry.getValue();
        }
        result.add(new CountVO(I18nUtil.translate((String)"i18n_title_all", (String)"\u5168\u90e8"), "saleKnowledgeStatus", null, all));
        List srmRectificationAppealStatus = this.baseRpcService.queryDictItemsByCode("saleKnowledgeClassificationStatus", TenantContext.getTenant());
        for (DictDTO status : srmRectificationAppealStatus) {
            Integer total = countMap.get(status.getValue()) == null ? 0 : countMap.get(status.getValue());
            result.add(new CountVO(I18nUtil.translate((String)status.getTextI18nKey(), (String)status.getText()), "saleKnowledgeStatus", status.getValue(), total));
        }
        return Result.ok(result);
    }
}

