/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.knowledge.controller;

import cn.hutool.core.convert.Convert;
import cn.hutool.core.text.CharSequenceUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.aspect.annotation.SrmValidated;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.query.QueryGenerator;
import com.els.common.util.I18nUtil;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.knowledge.entity.KnowledgeQuestion;
import com.els.modules.knowledge.entity.KnowledgeQuestionAnswer;
import com.els.modules.knowledge.enumerate.KnowledgeQuestionVisitorPermEnum;
import com.els.modules.knowledge.enumerate.KnowledgeStatusEnum;
import com.els.modules.knowledge.service.KnowledgeQuestionAnswerService;
import com.els.modules.knowledge.service.KnowledgeQuestionService;
import com.els.modules.knowledge.vo.KnowledgeQuestionVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u8d44\u6599\u95ee\u9898"})
@RestController
@RequestMapping(value={"/knowledge/saleKnowledgeQuestion"})
public class SaleKnowledgeQuestionController
extends BaseController<KnowledgeQuestion, KnowledgeQuestionService> {
    @Autowired
    private KnowledgeQuestionService knowledgeQuestionService;
    @Autowired
    private KnowledgeQuestionAnswerService knowledgeQuestionAnswerService;

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2\u8d44\u6599\u95ee\u7b54", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2\u8d44\u6599\u95ee\u7b54")
    @GetMapping(value={"/list"})
    @RequiresPermissions(value={"knowledgeBase#SaleKnowledgeQuestion:list"})
    public Result<?> queryPageList(KnowledgeQuestion question, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)question), (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage<KnowledgeQuestion> pageList = this.knowledgeQuestionService.pageSaleQuestion((Page<KnowledgeQuestion>)page, (QueryWrapper<KnowledgeQuestion>)queryWrapper);
        return Result.ok(pageList);
    }

    @SrmValidated
    @AutoLog(value="\u8d44\u6599\u95ee\u7b54-\u6dfb\u52a0")
    @ApiOperation(value="\u6dfb\u52a0", notes="\u6dfb\u52a0")
    @PostMapping(value={"/add"})
    @RequiresPermissions(value={"knowledgeBase#SaleKnowledgeQuestion:add"})
    public Result<?> add(@RequestBody KnowledgeQuestion question) {
        question.setElsAccount(SysUtil.getLoginUser().getElsAccount());
        question.setStatus(KnowledgeStatusEnum.NEW.getValue());
        this.knowledgeQuestionService.saveKnowledgeQuestion(question);
        return Result.ok((Object)((Object)question));
    }

    @SrmValidated
    @AutoLog(value="\u8d44\u6599\u95ee\u7b54-\u7f16\u8f91")
    @ApiOperation(value="\u7f16\u8f91", notes="\u7f16\u8f91")
    @PostMapping(value={"/edit"})
    @RequiresPermissions(value={"knowledgeBase#SaleKnowledgeQuestion:edit"})
    public Result<?> edit(@RequestBody KnowledgeQuestion question) {
        question.setElsAccount(SysUtil.getLoginUser().getElsAccount());
        question.setStatus(KnowledgeStatusEnum.NEW.getValue());
        this.knowledgeQuestionService.updateKnowledgeQuestion(question);
        String id = question.getId();
        return this.queryById(id);
    }

    @SrmValidated
    @AutoLog(value="\u8d44\u6599\u95ee\u7b54-\u53d1\u5e03")
    @ApiOperation(value="\u53d1\u5e03", notes="\u53d1\u5e03")
    @PostMapping(value={"/publish"})
    @RequiresPermissions(value={"knowledgeBase#SaleKnowledgeQuestion:publish"})
    public Result<?> publish(@RequestBody KnowledgeQuestion question) {
        KnowledgeQuestionVisitorPermEnum permEnum = KnowledgeQuestionVisitorPermEnum.build(question.getQuestionPerm());
        if (null == permEnum) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_xMKAPJLmAbWR_2010dd9d", (String)"\u4e0d\u5b58\u5728\u5f53\u524d\u8d44\u6599\u67e5\u770b\u6743\u9650\u503c") + ":" + question.getQuestionPerm());
        }
        question.setElsAccount(TenantContext.getTenant());
        this.knowledgeQuestionService.publish(question);
        return this.commonSuccessResult(3);
    }

    @AutoLog(value="\u8d44\u6599\u95ee\u9898-\u901a\u8fc7id\u5220\u9664")
    @ApiOperation(value="\u901a\u8fc7id\u5220\u9664", notes="\u901a\u8fc7id\u5220\u9664")
    @GetMapping(value={"/delete"})
    @RequiresPermissions(value={"knowledgeBase#SaleKnowledgeQuestion:delete"})
    public Result<?> delete(@RequestParam(name="id") String id) {
        this.knowledgeQuestionService.delKnowledgeQuestion(id);
        return this.commonSuccessResult(4);
    }

    @ApiOperation(value="\u901a\u8fc7id\u67e5\u8be2\u95ee\u7b54\u8be6\u60c5", notes="\u901a\u8fc7id\u67e5\u8be2\u95ee\u7b54\u8be6\u60c5")
    @GetMapping(value={"/queryById"})
    @RequiresPermissions(value={"knowledgeBase#SaleKnowledgeQuestion:view"})
    public Result<?> queryById(@RequestParam(name="id") String id) {
        KnowledgeQuestion question = (KnowledgeQuestion)((Object)this.knowledgeQuestionService.getById((Serializable)((Object)id)));
        if (KnowledgeQuestionVisitorPermEnum.IN_ALL.getValue().equals(question.getQuestionPerm()) && !question.getElsAccount().equals(SysUtil.getLoginUser().getElsAccount())) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_SmAbW_cca0bf93", (String)"\u65e0\u67e5\u770b\u6743\u9650"));
        }
        List<KnowledgeQuestionAnswer> answerList = this.knowledgeQuestionAnswerService.listQuestionAnswerByQuestionId(id);
        KnowledgeQuestionVo result = (KnowledgeQuestionVo)((Object)Convert.convert(KnowledgeQuestionVo.class, (Object)((Object)question)));
        result.setAnswerList(answerList);
        return Result.ok((Object)((Object)question));
    }

    @SrmValidated
    @AutoLog(value="\u8d44\u6599\u95ee\u7b54-\u95ee\u7b54\u56de\u590d")
    @ApiOperation(value="\u95ee\u7b54\u56de\u590d", notes="\u95ee\u7b54\u56de\u590d")
    @PostMapping(value={"/reply"})
    @RequiresPermissions(value={"knowledgeBase#SaleKnowledgeQuestion:reply"})
    public Result<?> reply(@RequestBody KnowledgeQuestionAnswer answer) {
        if (CharSequenceUtil.isEmpty((CharSequence)answer.getParentId())) {
            answer.setParentId("0");
        }
        answer.setId(null);
        answer.setCreateBy(null);
        answer.setCreateTime(null);
        answer.setCreateBy(null);
        answer.setElsAccount(TenantContext.getTenant());
        this.knowledgeQuestionAnswerService.saveKnowledgeQuestionAnswer(answer);
        return Result.ok();
    }

    @AutoLog(value="\u8d44\u6599\u95ee\u7b54-\u5206\u9875\u67e5\u8be2\u95ee\u7b54\u56de\u590d")
    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u95ee\u7b54\u56de\u590d", notes="\u5206\u9875\u67e5\u8be2\u95ee\u7b54\u56de\u590d")
    @GetMapping(value={"/answerList"})
    @RequiresPermissions(value={"knowledgeBase#SaleKnowledgeQuestion:list"})
    public Result<?> answerList(KnowledgeQuestionAnswer answer, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)answer, (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.knowledgeQuestionAnswerService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }
}

