/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.knowledge.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.els.common.util.SysUtil;
import com.els.modules.knowledge.entity.KnowledgeCollect;
import com.els.modules.knowledge.entity.KnowledgeInteract;
import com.els.modules.knowledge.mapper.KnowledgeCollectMapper;
import com.els.modules.knowledge.service.KnowledgeCollectService;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;

@Service
public class KnowledgeCollectServiceImpl
extends ServiceImpl<KnowledgeCollectMapper, KnowledgeCollect>
implements KnowledgeCollectService {
    @Override
    public boolean checkIfExists(String knowledgeId, String accountId) {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)wrapper.eq(KnowledgeInteract::getAccountId, (Object)accountId)).eq(KnowledgeInteract::getKnowledgeId, (Object)knowledgeId);
        return ((KnowledgeCollectMapper)this.baseMapper).selectCount((Wrapper)wrapper) > 0;
    }

    @Override
    public Integer countKnowledge(String dataId) {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        wrapper.eq(KnowledgeInteract::getKnowledgeId, (Object)dataId);
        return ((KnowledgeCollectMapper)this.baseMapper).selectCount((Wrapper)wrapper);
    }

    @Override
    public List<String> check(List<String> ids) {
        if (CollectionUtil.isEmpty(ids)) {
            return Lists.newArrayList();
        }
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)wrapper.in(KnowledgeInteract::getKnowledgeId, ids)).eq(KnowledgeInteract::getAccountId, (Object)SysUtil.getLoginUser().getId());
        wrapper.select(new SFunction[]{KnowledgeInteract::getKnowledgeId});
        List list = ((KnowledgeCollectMapper)this.baseMapper).selectList((Wrapper)wrapper);
        return list.stream().map(KnowledgeInteract::getKnowledgeId).collect(Collectors.toList());
    }

    @Override
    public void removeCollect(String knowledgeId, String userId) {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)wrapper.eq(KnowledgeInteract::getKnowledgeId, (Object)knowledgeId)).eq(KnowledgeInteract::getAccountId, (Object)userId);
        ((KnowledgeCollectMapper)this.baseMapper).delete((Wrapper)wrapper);
    }

    @Override
    public IPage<KnowledgeCollect> collectPage(Page<KnowledgeCollect> page, QueryWrapper<KnowledgeCollect> queryWrapper, String userId) {
        return ((KnowledgeCollectMapper)this.baseMapper).collectPage(page, queryWrapper, userId);
    }
}

