/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.myschedule.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.aspect.annotation.SrmValidated;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.query.QueryGenerator;
import com.els.config.mybatis.TenantContext;
import com.els.modules.myschedule.entity.MySchedule;
import com.els.modules.myschedule.service.MyScheduleService;
import com.els.modules.myschedule.vo.CustomScheduleVO;
import com.els.modules.myschedule.vo.MyScheduleQueryVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u6211\u7684\u65e5\u7a0b"})
@RestController
@RequestMapping(value={"/supplier/mySchedule"})
public class MyScheduleController
extends BaseController<MySchedule, MyScheduleService> {
    @Autowired
    private MyScheduleService myScheduleService;

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    public Result<?> queryPageList(MySchedule mySchedule, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)mySchedule), (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.myScheduleService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @AutoLog(value="\u6211\u7684\u65e5\u7a0b-\u6dfb\u52a0")
    @ApiOperation(value="\u6dfb\u52a0", notes="\u6dfb\u52a0")
    @PostMapping(value={"/add"})
    public Result<?> add(@RequestBody MySchedule mySchedule) {
        this.myScheduleService.add(mySchedule);
        return Result.ok((Object)((Object)mySchedule));
    }

    @AutoLog(value="\u6211\u7684\u65e5\u7a0b-\u7f16\u8f91")
    @ApiOperation(value="\u7f16\u8f91", notes="\u7f16\u8f91")
    @PostMapping(value={"/edit"})
    public Result<?> edit(@RequestBody MySchedule mySchedule) {
        this.myScheduleService.edit(mySchedule);
        String id = mySchedule.getId();
        return this.queryById(id);
    }

    @AutoLog(value="\u6211\u7684\u65e5\u7a0b-\u901a\u8fc7id\u5220\u9664")
    @ApiOperation(value="\u901a\u8fc7id\u5220\u9664", notes="\u901a\u8fc7id\u5220\u9664")
    @GetMapping(value={"/delete"})
    public Result<?> delete(@RequestParam(name="id") String id) {
        this.myScheduleService.delete(id);
        return this.commonSuccessResult(4);
    }

    @AutoLog(value="\u6211\u7684\u65e5\u7a0b-\u6279\u91cf\u5220\u9664")
    @ApiOperation(value="\u6279\u91cf\u5220\u9664", notes="\u6279\u91cf\u5220\u9664")
    @GetMapping(value={"/deleteBatch"})
    public Result<?> deleteBatch(@RequestParam(name="ids") String ids) {
        List<String> idList = Arrays.asList(ids.split(","));
        this.myScheduleService.deleteBatch(idList);
        return this.commonSuccessResult(4);
    }

    @ApiOperation(value="\u901a\u8fc7id\u67e5\u8be2", notes="\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    public Result<?> queryById(@RequestParam(name="id") String id) {
        MySchedule mySchedule = (MySchedule)((Object)this.myScheduleService.getOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"id", (Object)id)).eq((Object)"els_account", (Object)TenantContext.getTenant())));
        return Result.ok((Object)((Object)mySchedule));
    }

    @ApiOperation(value="\u67e5\u8be2\u6307\u5b9a\u6708\u4efd\u7684\u65e5\u7a0b", notes="\u67e5\u8be2\u6307\u5b9a\u6708\u4efd\u7684\u65e5\u7a0b")
    @PostMapping(value={"/queryMySchedule"})
    public Result<?> queryMySchedule(@RequestBody MyScheduleQueryVO queryVO) {
        Map<String, List> stringListMap = this.myScheduleService.queryMySchedule(queryVO);
        return Result.ok(stringListMap);
    }

    @AutoLog(value="\u6211\u7684\u65e5\u7a0b-\u6dfb\u52a0\u81ea\u5b9a\u4e49\u65e5\u7a0b")
    @PostMapping(value={"/addCustomSchedule"})
    @SrmValidated
    public Result<?> addCustomSchedule(@RequestBody CustomScheduleVO customScheduleVO) {
        this.myScheduleService.addCustomSchedule(customScheduleVO);
        return Result.ok();
    }

    @AutoLog(value="\u6211\u7684\u65e5\u7a0b-\u5220\u9664\u81ea\u5b9a\u4e49\u65e5\u7a0b")
    @GetMapping(value={"/delCustomSchedule"})
    @SrmValidated
    public Result<?> delCustomSchedule(String currentDate) {
        this.myScheduleService.delCustomSchedule(currentDate);
        return Result.ok();
    }
}

