/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.performance.excel;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.els.common.aspect.annotation.RpcService;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.excel.service.ErrorExcelHandlerService;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.util.I18nUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.ExcelImportDTO;
import com.els.modules.base.api.dto.TemplateHeadDTO;
import com.els.modules.base.api.service.ExcelImportRpcService;
import com.els.modules.org.api.dto.PurchaseOrganizationInfoDTO;
import com.els.modules.performance.entity.PurchasePerformanceReportHead;
import com.els.modules.performance.entity.PurchasePerformanceTemplateHead;
import com.els.modules.performance.enumerate.PerformanceCreateTypeEnum;
import com.els.modules.performance.enumerate.PerformanceReportSendStatusEnum;
import com.els.modules.performance.enumerate.PerformanceReportStatusEnum;
import com.els.modules.performance.rpc.service.InvokeMainRpcService;
import com.els.modules.performance.service.PurchasePerformanceReportHeadService;
import com.els.modules.performance.service.PurchasePerformanceTemplateHeadService;
import com.els.modules.supplier.entity.SupplierMasterData;
import com.els.modules.supplier.service.SupplierMasterDataService;
import com.els.rpc.service.InvokeBaseRpcService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;

@RpcService(value="purchasePerformanceReportImportCallBackServiceImpl")
public class PurchasePerformanceReportImportServiceImpl
extends ErrorExcelHandlerService
implements ExcelImportRpcService {
    @Autowired
    private PurchasePerformanceReportHeadService purchasePerformanceReportHeadService;
    @Autowired
    private PurchasePerformanceTemplateHeadService purchasePerformanceTemplateHeadService;
    @Autowired
    private SupplierMasterDataService supplierMasterDataService;
    @Autowired
    private InvokeBaseRpcService invokeBaseRpcService;
    @Autowired
    private InvokeMainRpcService invokeMainRpcService;

    public List<Map<String, Object>> importExcel(ExcelImportDTO excelImportDTO) {
        List<PurchasePerformanceTemplateHead> templateHeadList;
        List dataList = excelImportDTO.getDataList();
        int totalCount = 0 == excelImportDTO.getTotalCount() ? dataList.size() : excelImportDTO.getTotalCount();
        List templateList = this.invokeBaseRpcService.getDefaultTemplateByType("performanceReport");
        Assert.notEmpty((Collection)templateList, (String)I18nUtil.translate((String)"i18n_alert_VWERtXsBESIr_eb54ee59", (String)"\u8bf7\u5148\u914d\u7f6e\u7ee9\u6548\u62a5\u8868\u4e1a\u52a1\u6a21\u677f"));
        ArrayList<PurchasePerformanceReportHead> entityList = new ArrayList<PurchasePerformanceReportHead>();
        for (Map data : dataList) {
            PurchasePerformanceReportHead entity = (PurchasePerformanceReportHead)((Object)JSON.parseObject((String)JSON.toJSONString((Object)data), PurchasePerformanceReportHead.class));
            entity.setElsAccount(TenantContext.getTenant());
            entity.setTemplateName(((TemplateHeadDTO)templateList.get(0)).getTemplateName());
            entity.setTemplateNumber(((TemplateHeadDTO)templateList.get(0)).getTemplateNumber());
            entity.setTemplateVersion(Integer.toString(((TemplateHeadDTO)templateList.get(0)).getTemplateVersion()));
            entity.setTemplateAccount(((TemplateHeadDTO)templateList.get(0)).getElsAccount());
            entity.setSendStatus(PerformanceReportSendStatusEnum.NOT_SENT_YET.getValue());
            entity.setAuditStatus(AuditStatusEnum.AUDIT_NEW.getValue());
            entity.setReportStatus(PerformanceReportStatusEnum.NEW.getValue());
            entity.setCreationMethod(PerformanceCreateTypeEnum.MANUAL.getValue());
            entity.setRequiredAudit("1");
            entity.setId(null);
            entity.setAssessmentTimeRange(null);
            entityList.add(entity);
        }
        if (CollUtil.isEmpty(entityList)) {
            return dataList;
        }
        PurchasePerformanceReportHead head = (PurchasePerformanceReportHead)((Object)entityList.get(0));
        long size = entityList.size();
        List nextCodes = this.invokeBaseRpcService.getNextCodes("srmPerformanceReportNumber", (Object)head, (int)size);
        int codeIndex = 0;
        for (PurchasePerformanceReportHead e : entityList) {
            e.setReportNumber((String)nextCodes.get(codeIndex++));
        }
        List<String> templateNumberList = entityList.stream().map(PurchasePerformanceReportHead::getPerformanceTemplateNumber).filter(CharSequenceUtil::isNotEmpty).collect(Collectors.toList());
        List<String> orgList = entityList.stream().filter(x -> StrUtil.isNotEmpty((CharSequence)x.getOrgType()) && StrUtil.isNotEmpty((CharSequence)x.getOrgCode())).map(x -> x.getOrgType() + "_" + x.getOrgCode()).distinct().collect(Collectors.toList());
        List<PurchaseOrganizationInfoDTO> purchaseOrganizationInfoDTOS = this.invokeMainRpcService.listOrganizationInfoByTypeAndCode(orgList);
        Map orgMap = purchaseOrganizationInfoDTOS.stream().collect(Collectors.toMap(x -> x.getOrgCategoryCode() + "_" + x.getOrgCode(), Function.identity(), (v1, v2) -> v2));
        for (PurchasePerformanceReportHead h : entityList) {
            if (StrUtil.isNotEmpty((CharSequence)h.getOrgType()) && StrUtil.isNotEmpty((CharSequence)h.getOrgCode())) {
                PurchaseOrganizationInfoDTO dto = (PurchaseOrganizationInfoDTO)orgMap.get(h.getOrgType() + "_" + h.getOrgCode());
                if (null != dto) {
                    h.setOrgType(dto.getOrgCategoryCode());
                    h.setOrgCode(dto.getOrgCode());
                    h.setOrgName(dto.getOrgName());
                    continue;
                }
                h.setOrgType(null);
            }
            h.setOrgCode(null);
            h.setOrgName(null);
        }
        List<String> elsAccountList = entityList.stream().map(PurchasePerformanceReportHead::getToElsAccount).filter(CharSequenceUtil::isNotEmpty).distinct().collect(Collectors.toList());
        List<SupplierMasterData> masterList = this.supplierMasterDataService.listByElsAccount(elsAccountList);
        if (CollUtil.isNotEmpty(masterList)) {
            Map masterMap = masterList.stream().collect(Collectors.toMap(BaseEntity::getElsAccount, Function.identity(), (v1, v2) -> v2));
            for (PurchasePerformanceReportHead h : entityList) {
                SupplierMasterData masterData;
                if (StrUtil.isNotEmpty((CharSequence)h.getToElsAccount()) && masterMap.containsKey(h.getToElsAccount()) && null != (masterData = (SupplierMasterData)((Object)masterMap.get(h.getElsAccount())))) {
                    h.setAccountGroup(masterData.getAccountGroup());
                    h.setSupplierCode(masterData.getSupplierCode());
                    h.setSupplierName(masterData.getSupplierName());
                    continue;
                }
                h.setAccountGroup(null);
                h.setSupplierCode(null);
                h.setSupplierName(null);
                h.setToElsAccount(null);
            }
        }
        if (CollUtil.isEmpty(templateHeadList = this.purchasePerformanceTemplateHeadService.listTemplateByTemplateNumber(templateNumberList))) {
            Map templateMap = templateHeadList.stream().collect(Collectors.toMap(PurchasePerformanceTemplateHead::getPerformanceTemplateNumber, Function.identity()));
            for (PurchasePerformanceReportHead h : entityList) {
                PurchasePerformanceTemplateHead templateHead;
                if (StrUtil.isNotEmpty((CharSequence)h.getPerformanceTemplateNumber()) && templateMap.containsKey(h.getPerformanceTemplateNumber()) && null != (templateHead = (PurchasePerformanceTemplateHead)((Object)templateMap.get(h.getPerformanceTemplateNumber())))) {
                    h.setPerformanceTemplateName(templateHead.getPerformanceTemplateName());
                    h.setPerformanceTemplateNumber(templateHead.getPerformanceTemplateNumber());
                    h.setPerformanceTemplateId(templateHead.getId());
                    if (StrUtil.isEmpty((CharSequence)h.getOrgType())) {
                        h.setOrgType(templateHead.getOrgType());
                        h.setOrgCode(templateHead.getOrgCode());
                        h.setOrgName(templateHead.getOrgName());
                    }
                    h.setAssessmentCycle(h.getAssessmentCycle());
                    h.setRequiredAudit(templateHead.getResultRequiredAudit());
                    h.setRequiredSend(templateHead.getResultRequiredSend());
                    if (!"0".equals(h.getRequiredAudit())) continue;
                    h.setAuditStatus(AuditStatusEnum.NO_AUDIT_REQUIRED.getValue());
                    continue;
                }
                h.setPerformanceTemplateName(null);
                h.setPerformanceTemplateNumber(null);
                h.setPerformanceTemplateId(null);
                h.setAssessmentCycle(null);
            }
        }
        this.purchasePerformanceReportHeadService.saveBatch(entityList);
        this.errorHandle(true, excelImportDTO, TenantContext.getTenant(), totalCount);
        return dataList;
    }
}

