/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.performance.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.util.I18nUtil;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.performance.entity.PurchasePerformanceNormFormula;
import com.els.modules.performance.entity.PurchasePerformanceNormGrad;
import com.els.modules.performance.entity.PurchasePerformanceNormHead;
import com.els.modules.performance.entity.PurchasePerformanceTemplateGrad;
import com.els.modules.performance.entity.PurchasePerformanceTemplateHead;
import com.els.modules.performance.entity.PurchasePerformanceTemplateItem;
import com.els.modules.performance.entity.PurchasePerformanceTemplateItemFormula;
import com.els.modules.performance.entity.PurchasePerformanceTemplateItemGrad;
import com.els.modules.performance.entity.PurchasePerformanceTemplateNormWeight;
import com.els.modules.performance.enumerate.PerformanceCreateTypeEnum;
import com.els.modules.performance.enumerate.PerformanceTemplateEffectiveStatusEnum;
import com.els.modules.performance.enumerate.PerformanceTemplateStatusEnum;
import com.els.modules.performance.mapper.PurchasePerformanceNormFormulaMapper;
import com.els.modules.performance.mapper.PurchasePerformanceNormGradMapper;
import com.els.modules.performance.mapper.PurchasePerformanceTemplateGradMapper;
import com.els.modules.performance.mapper.PurchasePerformanceTemplateHeadMapper;
import com.els.modules.performance.mapper.PurchasePerformanceTemplateItemFormulaMapper;
import com.els.modules.performance.mapper.PurchasePerformanceTemplateItemGradMapper;
import com.els.modules.performance.mapper.PurchasePerformanceTemplateItemMapper;
import com.els.modules.performance.mapper.PurchasePerformanceTemplateNormWeightMapper;
import com.els.modules.performance.service.PurchasePerformanceNormHeadService;
import com.els.modules.performance.service.PurchasePerformanceTemplateGradService;
import com.els.modules.performance.service.PurchasePerformanceTemplateHeadService;
import com.els.modules.performance.service.PurchasePerformanceTemplateItemFormulaService;
import com.els.modules.performance.service.PurchasePerformanceTemplateItemGradService;
import com.els.modules.performance.service.PurchasePerformanceTemplateItemService;
import com.els.modules.performance.service.PurchasePerformanceTemplateNormWeightService;
import com.els.rpc.service.InvokeBaseRpcService;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class PurchasePerformanceTemplateHeadServiceImpl
extends ServiceImpl<PurchasePerformanceTemplateHeadMapper, PurchasePerformanceTemplateHead>
implements PurchasePerformanceTemplateHeadService {
    @Resource
    private PurchasePerformanceTemplateHeadMapper purchasePerformanceTemplateHeadMapper;
    @Resource
    private PurchasePerformanceTemplateItemMapper purchasePerformanceTemplateItemMapper;
    @Resource
    private PurchasePerformanceTemplateNormWeightMapper purchasePerformanceTemplateNormWeightMapper;
    @Resource
    private PurchasePerformanceTemplateGradMapper purchasePerformanceTemplateGradMapper;
    @Resource
    private PurchasePerformanceNormGradMapper purchasePerformanceNormGradMapper;
    @Resource
    private PurchasePerformanceNormFormulaMapper purchasePerformanceNormFormulaMapper;
    @Resource
    private PurchasePerformanceTemplateItemGradMapper purchasePerformanceTemplateItemGradMapper;
    @Resource
    private PurchasePerformanceTemplateItemFormulaMapper purchasePerformanceTemplateItemFormulaMapper;
    @Autowired
    private InvokeBaseRpcService invokeBaseRpcService;
    @Autowired
    private PurchasePerformanceNormHeadService purchasePerformanceNormHeadService;

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void saveMain(PurchasePerformanceTemplateHead head, List<PurchasePerformanceTemplateItem> purchasePerformanceTemplateItemList, List<PurchasePerformanceTemplateNormWeight> purchasePerformanceTemplateNormWeightList, List<PurchasePerformanceTemplateGrad> purchasePerformanceTemplateGradList) {
        if (StrUtil.isBlank((CharSequence)head.getPerformanceTemplateNumber())) {
            head.setPerformanceTemplateNumber(this.invokeBaseRpcService.getNextCode("assessTemplateNumber", (Object)head));
        }
        head.setCreationMethod(CharSequenceUtil.blankToDefault((CharSequence)head.getCreationMethod(), (String)PerformanceCreateTypeEnum.MANUAL.getValue()));
        head.setPerformanceTemplateVersion("1");
        head.setPerformanceTemplateStatus(PerformanceTemplateStatusEnum.UNUSED.getValue());
        head.setEffectiveStatus(PerformanceTemplateEffectiveStatusEnum.UN_EFFECTIVE.getValue());
        head.setTemplateRequiredAudit(CharSequenceUtil.blankToDefault((CharSequence)head.getTemplateRequiredAudit(), (String)"1"));
        if ("1".equals(head.getTemplateRequiredAudit())) {
            head.setAuditStatus(AuditStatusEnum.AUDIT_NEW.getValue());
        } else {
            head.setAuditStatus(AuditStatusEnum.NO_AUDIT_REQUIRED.getValue());
        }
        if ("0".equals(head.getTemplateRequiredAudit())) {
            head.setAuditStatus(AuditStatusEnum.NO_AUDIT_REQUIRED.getValue());
            if (null != head.getEffectiveDate() && head.getEffectiveDate().before((Date)DateUtil.date()) && !PerformanceTemplateEffectiveStatusEnum.IN_EFFECTIVE.getValue().equals(head.getEffectiveStatus())) {
                head.setEffectiveStatus(PerformanceTemplateEffectiveStatusEnum.EFFECTIVE.getValue());
            } else {
                head.setEffectiveStatus(PerformanceTemplateEffectiveStatusEnum.UN_EFFECTIVE.getValue());
            }
        } else {
            head.setTemplateRequiredAudit("1");
            if (!PerformanceTemplateEffectiveStatusEnum.IN_EFFECTIVE.getValue().equals(head.getEffectiveStatus())) {
                head.setEffectiveStatus(PerformanceTemplateEffectiveStatusEnum.UN_EFFECTIVE.getValue());
            }
        }
        this.purchasePerformanceTemplateHeadMapper.insert((Object)head);
        this.insertData(head, purchasePerformanceTemplateItemList, purchasePerformanceTemplateNormWeightList, purchasePerformanceTemplateGradList);
        this.insertItemData(purchasePerformanceTemplateItemList);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void updateMain(PurchasePerformanceTemplateHead head, List<PurchasePerformanceTemplateItem> purchasePerformanceTemplateItemList, List<PurchasePerformanceTemplateNormWeight> purchasePerformanceTemplateNormWeightList, List<PurchasePerformanceTemplateGrad> purchasePerformanceTemplateGradList) {
        int count;
        Assert.isTrue((null != head.getEffectiveDate() ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_VWNbXBA_bdee358c", (String)"\u8bf7\u8f93\u5165\u751f\u6548\u65e5\u671f"));
        if (null != head.getEffectiveDate() && null != head.getExpiryDate()) {
            Assert.isTrue((boolean)head.getEffectiveDate().before(head.getExpiryDate()), (String)I18nUtil.translate((String)"i18n_alert_VWNiRjbXBAnKXBA_6bf21daa", (String)"\u8bf7\u8f93\u5165\u6b63\u786e\u7684\u751f\u6548\u65e5\u671f\u548c\u5931\u6548\u65e5\u671f"));
        }
        if ("0".equals(head.getTemplateRequiredAudit())) {
            head.setAuditStatus(AuditStatusEnum.NO_AUDIT_REQUIRED.getValue());
            if (null != head.getEffectiveDate() && head.getEffectiveDate().before((Date)DateUtil.date()) && !PerformanceTemplateEffectiveStatusEnum.IN_EFFECTIVE.getValue().equals(head.getEffectiveStatus())) {
                head.setEffectiveStatus(PerformanceTemplateEffectiveStatusEnum.EFFECTIVE.getValue());
            } else {
                head.setEffectiveStatus(PerformanceTemplateEffectiveStatusEnum.UN_EFFECTIVE.getValue());
            }
        } else {
            head.setTemplateRequiredAudit("1");
            if (!PerformanceTemplateEffectiveStatusEnum.IN_EFFECTIVE.getValue().equals(head.getEffectiveStatus())) {
                head.setEffectiveStatus(PerformanceTemplateEffectiveStatusEnum.UN_EFFECTIVE.getValue());
            }
        }
        if (StrUtil.isBlank((CharSequence)head.getTemplateNumber())) {
            head.setTemplateNumber(this.invokeBaseRpcService.getNextCode("assessTemplateNumber", (Object)head));
        }
        if ((count = this.purchasePerformanceTemplateHeadMapper.updateById((Object)head)) == 0) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
        }
        this.purchasePerformanceTemplateItemMapper.deleteByMainId(head.getId());
        this.purchasePerformanceTemplateNormWeightMapper.deleteByMainId(head.getId());
        this.purchasePerformanceTemplateGradMapper.deleteByMainId(head.getId());
        List<String> existItemIds = purchasePerformanceTemplateItemList.stream().map(BaseEntity::getId).filter(CharSequenceUtil::isNotBlank).collect(Collectors.toList());
        this.purchasePerformanceTemplateItemGradMapper.deleteByHeadIdAndItemId(head.getId(), existItemIds);
        this.purchasePerformanceTemplateItemFormulaMapper.deleteByHeadIdAndItemId(head.getId(), existItemIds);
        this.insertData(head, purchasePerformanceTemplateItemList, purchasePerformanceTemplateNormWeightList, purchasePerformanceTemplateGradList);
        purchasePerformanceTemplateItemList = purchasePerformanceTemplateItemList.stream().filter(x -> !existItemIds.contains(x.getId())).collect(Collectors.toList());
        this.insertItemData(purchasePerformanceTemplateItemList);
    }

    private void insertData(PurchasePerformanceTemplateHead head, List<PurchasePerformanceTemplateItem> iteList, List<PurchasePerformanceTemplateNormWeight> normWeightList, List<PurchasePerformanceTemplateGrad> gradList) {
        if (CollectionUtils.isNotEmpty(iteList)) {
            int itemNumber = 1;
            for (PurchasePerformanceTemplateItem entity : iteList) {
                entity.setHeadId(head.getId());
                entity.setItemNumber(String.valueOf(itemNumber++));
                PurchasePerformanceNormHead normHead = (PurchasePerformanceNormHead)((Object)this.purchasePerformanceNormHeadService.getById((Serializable)((Object)entity.getNormId())));
                normHead.setUseStatus("1");
                this.purchasePerformanceNormHeadService.updateById((Object)normHead);
                SysUtil.setSysParam((BaseEntity)entity, (BaseEntity)head);
            }
            ((PurchasePerformanceTemplateItemService)SpringContextUtils.getBean(PurchasePerformanceTemplateItemService.class)).saveBatch(iteList);
        }
        if (CollectionUtils.isNotEmpty(normWeightList)) {
            for (PurchasePerformanceTemplateNormWeight normWeight : normWeightList) {
                normWeight.setId(null);
                normWeight.setHeadId(head.getId());
                SysUtil.setSysParam((BaseEntity)normWeight, (BaseEntity)head);
            }
            ((PurchasePerformanceTemplateNormWeightService)SpringContextUtils.getBean(PurchasePerformanceTemplateNormWeightService.class)).saveBatch(normWeightList);
        }
        if (CollUtil.isNotEmpty(gradList)) {
            for (PurchasePerformanceTemplateGrad grad : gradList) {
                grad.setId(null);
                grad.setHeadId(head.getId());
                SysUtil.setSysParam((BaseEntity)grad, (BaseEntity)head);
            }
            ((PurchasePerformanceTemplateGradService)SpringContextUtils.getBean(PurchasePerformanceTemplateGradService.class)).saveBatch(gradList);
        }
    }

    private void insertItemData(List<PurchasePerformanceTemplateItem> itemList) {
        if (CollectionUtils.isEmpty(itemList)) {
            return;
        }
        List<String> normIds = itemList.stream().map(PurchasePerformanceTemplateItem::getNormId).collect(Collectors.toList());
        ArrayList<PurchasePerformanceTemplateItemGrad> gradList = new ArrayList<PurchasePerformanceTemplateItemGrad>();
        ArrayList<PurchasePerformanceTemplateItemFormula> formulaList = new ArrayList<PurchasePerformanceTemplateItemFormula>();
        Map<String, List<PurchasePerformanceNormGrad>> normGradMap = this.queryNormGradMap(normIds);
        Map<String, List<PurchasePerformanceNormFormula>> normFormulaMap = this.queryNormFormulaMap(normIds);
        for (PurchasePerformanceTemplateItem entity : itemList) {
            List<PurchasePerformanceNormFormula> formulas;
            List<PurchasePerformanceNormGrad> grads = normGradMap.get(entity.getNormId());
            if (CollUtil.isNotEmpty(grads)) {
                List<PurchasePerformanceTemplateItemGrad> itemGrads = this.convertToItemGrad(grads, entity);
                gradList.addAll(itemGrads);
            }
            if (!CollUtil.isNotEmpty(formulas = normFormulaMap.get(entity.getNormId()))) continue;
            List<PurchasePerformanceTemplateItemFormula> itemGrads = this.convertToItemFormula(formulas, entity);
            formulaList.addAll(itemGrads);
        }
        if (CollUtil.isNotEmpty(gradList)) {
            ((PurchasePerformanceTemplateItemGradService)SpringContextUtils.getBean(PurchasePerformanceTemplateItemGradService.class)).saveBatch(gradList);
        }
        if (CollUtil.isNotEmpty(formulaList)) {
            ((PurchasePerformanceTemplateItemFormulaService)SpringContextUtils.getBean(PurchasePerformanceTemplateItemFormulaService.class)).saveBatch(formulaList);
        }
    }

    private List<PurchasePerformanceTemplateItemGrad> convertToItemGrad(List<PurchasePerformanceNormGrad> grads, PurchasePerformanceTemplateItem item) {
        if (CollUtil.isEmpty(grads)) {
            return Lists.newArrayList();
        }
        ArrayList<PurchasePerformanceTemplateItemGrad> itemGradList = new ArrayList<PurchasePerformanceTemplateItemGrad>();
        for (PurchasePerformanceNormGrad grad : grads) {
            PurchasePerformanceTemplateItemGrad tem = (PurchasePerformanceTemplateItemGrad)((Object)Convert.convert(PurchasePerformanceTemplateItemGrad.class, (Object)((Object)grad)));
            tem.setPerformanceTemplateId(item.getHeadId());
            tem.setPerformanceTemplateItemId(item.getId());
            SysUtil.setSysParam((BaseEntity)grad, (BaseEntity)item);
            tem.setId(null);
            itemGradList.add(tem);
        }
        return itemGradList;
    }

    private List<PurchasePerformanceTemplateItemFormula> convertToItemFormula(List<PurchasePerformanceNormFormula> formulaList, PurchasePerformanceTemplateItem item) {
        if (CollUtil.isEmpty(formulaList)) {
            return Lists.newArrayList();
        }
        ArrayList<PurchasePerformanceTemplateItemFormula> itemFormulaList = new ArrayList<PurchasePerformanceTemplateItemFormula>();
        for (PurchasePerformanceNormFormula formula : formulaList) {
            PurchasePerformanceTemplateItemFormula tem = (PurchasePerformanceTemplateItemFormula)((Object)Convert.convert(PurchasePerformanceTemplateItemFormula.class, (Object)((Object)formula)));
            tem.setPerformanceTemplateId(item.getHeadId());
            tem.setPerformanceTemplateItemId(item.getId());
            SysUtil.setSysParam((BaseEntity)formula, (BaseEntity)item);
            tem.setId(null);
            itemFormulaList.add(tem);
        }
        return itemFormulaList;
    }

    private Map<String, List<PurchasePerformanceNormGrad>> queryNormGradMap(List<String> normIds) {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        wrapper.in(PurchasePerformanceNormGrad::getHeadId, normIds);
        List list = this.purchasePerformanceNormGradMapper.selectList((Wrapper)wrapper);
        return list.stream().collect(Collectors.groupingBy(PurchasePerformanceNormGrad::getHeadId));
    }

    private Map<String, List<PurchasePerformanceNormFormula>> queryNormFormulaMap(List<String> normIds) {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        wrapper.in(PurchasePerformanceNormFormula::getHeadId, normIds);
        List list = this.purchasePerformanceNormFormulaMapper.selectList((Wrapper)wrapper);
        return list.stream().collect(Collectors.groupingBy(PurchasePerformanceNormFormula::getHeadId));
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void delMain(String id) {
        this.purchasePerformanceTemplateItemMapper.deleteByMainId(id);
        this.purchasePerformanceTemplateHeadMapper.deleteById((Serializable)((Object)id));
        this.purchasePerformanceTemplateNormWeightMapper.deleteByMainId(id);
        this.purchasePerformanceTemplateGradMapper.deleteByMainId(id);
        this.purchasePerformanceTemplateItemGradMapper.deleteByMainId(id);
        this.purchasePerformanceTemplateItemFormulaMapper.deleteByMainId(id);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void delBatchMain(List<String> idList) {
        for (Serializable serializable : idList) {
            this.purchasePerformanceTemplateItemMapper.deleteByMainId(serializable.toString());
            this.purchasePerformanceTemplateHeadMapper.deleteById(serializable);
            this.purchasePerformanceTemplateNormWeightMapper.deleteByMainId(serializable.toString());
            this.purchasePerformanceTemplateGradMapper.deleteByMainId(serializable.toString());
            this.purchasePerformanceTemplateItemGradMapper.deleteByMainId(serializable.toString());
            this.purchasePerformanceTemplateItemFormulaMapper.deleteByMainId(serializable.toString());
        }
    }

    @Override
    public List<PurchasePerformanceTemplateHead> listTemplateByTemplateNumber(List<String> templateNumberList) {
        if (CollUtil.isEmpty(templateNumberList)) {
            return Lists.newArrayList();
        }
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.in(PurchasePerformanceTemplateHead::getPerformanceTemplateNumber, templateNumberList)).eq(BaseEntity::getElsAccount, (Object)TenantContext.getTenant())).in(PurchasePerformanceTemplateHead::getAuditStatus, (Collection)Lists.newArrayList((Object[])new String[]{AuditStatusEnum.NO_AUDIT_REQUIRED.getValue(), AuditStatusEnum.AUDIT_FINISH.getValue()}));
        return ((PurchasePerformanceTemplateHeadMapper)this.baseMapper).selectList((Wrapper)wrapper);
    }

    @Override
    public void changeStatusForJob() {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        wrapper.select(new SFunction[]{BaseEntity::getId});
        ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.lt(PurchasePerformanceTemplateHead::getEffectiveDate, (Object)DateUtil.date())).eq(PurchasePerformanceTemplateHead::getEffectiveStatus, (Object)PerformanceTemplateEffectiveStatusEnum.UN_EFFECTIVE.getValue())).in(PurchasePerformanceTemplateHead::getAuditStatus, (Collection)Lists.newArrayList((Object[])new String[]{AuditStatusEnum.NO_AUDIT_REQUIRED.getValue(), AuditStatusEnum.AUDIT_REJECT.getValue()}));
        HashMap<String, Object> param = new HashMap<String, Object>();
        DateTime date = DateUtil.date();
        param.put("nowDate", date);
        List<PurchasePerformanceTemplateHead> records = ((PurchasePerformanceTemplateHeadMapper)this.baseMapper).selectWithoutElsAccountToChangeStatus(param);
        ArrayList<PurchasePerformanceTemplateHead> updateRecords = new ArrayList<PurchasePerformanceTemplateHead>(records.size() / 2);
        for (PurchasePerformanceTemplateHead item : records) {
            if (null != item.getEffectiveDate() && item.getEffectiveDate().before((Date)date)) {
                item.setEffectiveStatus(PerformanceTemplateEffectiveStatusEnum.EFFECTIVE.getValue());
            }
            if (null != item.getExpiryDate() && item.getExpiryDate().before((Date)date)) {
                item.setEffectiveStatus(PerformanceTemplateEffectiveStatusEnum.IN_EFFECTIVE.getValue());
            }
            updateRecords.add(item);
        }
        this.updateBatchById(updateRecords);
    }

    @Override
    public PurchasePerformanceTemplateHead copy(String id) {
        PurchasePerformanceTemplateHead head = (PurchasePerformanceTemplateHead)((Object)((PurchasePerformanceTemplateHeadMapper)this.baseMapper).selectById((Serializable)((Object)id)));
        SysUtil.setNullCreate((BaseEntity)head);
        head.setId(IdWorker.getIdStr());
        head.setPerformanceTemplateNumber(this.invokeBaseRpcService.getNextCode("assessTemplateNumber", (Object)head));
        head.setCreationMethod(CharSequenceUtil.blankToDefault((CharSequence)head.getCreationMethod(), (String)PerformanceCreateTypeEnum.MANUAL.getValue()));
        head.setPerformanceTemplateVersion("1");
        head.setPerformanceTemplateStatus(PerformanceTemplateStatusEnum.UNUSED.getValue());
        head.setEffectiveStatus(PerformanceTemplateEffectiveStatusEnum.UN_EFFECTIVE.getValue());
        head.setExpiryDate(null);
        head.setEffectiveDate(null);
        head.setCreateBy(null);
        head.setCreateById(null);
        head.setCreateTime(null);
        head.setUpdateBy(null);
        head.setUpdateById(null);
        head.setUpdateTime(null);
        if ("1".equals(head.getTemplateRequiredAudit())) {
            head.setAuditStatus(AuditStatusEnum.AUDIT_NEW.getValue());
        } else {
            head.setAuditStatus(AuditStatusEnum.NO_AUDIT_REQUIRED.getValue());
        }
        if ("0".equals(head.getTemplateRequiredAudit())) {
            head.setAuditStatus(AuditStatusEnum.NO_AUDIT_REQUIRED.getValue());
            if (null != head.getEffectiveDate() && head.getEffectiveDate().before((Date)DateUtil.date()) && !PerformanceTemplateEffectiveStatusEnum.IN_EFFECTIVE.getValue().equals(head.getEffectiveStatus())) {
                head.setEffectiveStatus(PerformanceTemplateEffectiveStatusEnum.EFFECTIVE.getValue());
            } else {
                head.setEffectiveStatus(PerformanceTemplateEffectiveStatusEnum.UN_EFFECTIVE.getValue());
            }
        } else {
            head.setTemplateRequiredAudit("1");
            if (!PerformanceTemplateEffectiveStatusEnum.IN_EFFECTIVE.getValue().equals(head.getEffectiveStatus())) {
                head.setEffectiveStatus(PerformanceTemplateEffectiveStatusEnum.UN_EFFECTIVE.getValue());
            }
        }
        this.purchasePerformanceTemplateHeadMapper.insert((Object)head);
        List<PurchasePerformanceTemplateNormWeight> normWeightList = this.purchasePerformanceTemplateNormWeightMapper.selectByMainId(id);
        for (PurchasePerformanceTemplateNormWeight normWeight : normWeightList) {
            SysUtil.setNullCreate((BaseEntity)normWeight);
            normWeight.setHeadId(head.getId());
            normWeight.setId(IdWorker.getIdStr());
            normWeight.setCreateBy(null);
            normWeight.setCreateById(null);
            normWeight.setCreateTime(null);
            normWeight.setUpdateBy(null);
            normWeight.setUpdateById(null);
            normWeight.setUpdateTime(null);
        }
        HashMap<String, String> itemIdMap = new HashMap<String, String>();
        List<PurchasePerformanceTemplateItem> itemList = this.purchasePerformanceTemplateItemMapper.selectByMainId(id);
        for (PurchasePerformanceTemplateItem purchasePerformanceTemplateItem : itemList) {
            String string = IdWorker.getIdStr();
            itemIdMap.put(purchasePerformanceTemplateItem.getId(), string);
            SysUtil.setNullCreate((BaseEntity)purchasePerformanceTemplateItem);
            purchasePerformanceTemplateItem.setHeadId(head.getId());
            purchasePerformanceTemplateItem.setId(string);
            purchasePerformanceTemplateItem.setCreateBy(null);
            purchasePerformanceTemplateItem.setCreateById(null);
            purchasePerformanceTemplateItem.setCreateTime(null);
            purchasePerformanceTemplateItem.setUpdateBy(null);
            purchasePerformanceTemplateItem.setUpdateById(null);
            purchasePerformanceTemplateItem.setUpdateTime(null);
        }
        List<PurchasePerformanceTemplateGrad> templateGradList = this.purchasePerformanceTemplateGradMapper.selectByMainId(id);
        for (PurchasePerformanceTemplateGrad purchasePerformanceTemplateGrad : templateGradList) {
            SysUtil.setNullCreate((BaseEntity)purchasePerformanceTemplateGrad);
            purchasePerformanceTemplateGrad.setHeadId(head.getId());
            purchasePerformanceTemplateGrad.setId(IdWorker.getIdStr());
            purchasePerformanceTemplateGrad.setCreateBy(null);
            purchasePerformanceTemplateGrad.setCreateById(null);
            purchasePerformanceTemplateGrad.setCreateTime(null);
            purchasePerformanceTemplateGrad.setUpdateBy(null);
            purchasePerformanceTemplateGrad.setUpdateById(null);
            purchasePerformanceTemplateGrad.setUpdateTime(null);
        }
        List<PurchasePerformanceTemplateItemGrad> list = this.purchasePerformanceTemplateItemGradMapper.selectByMainId(id);
        for (PurchasePerformanceTemplateItemGrad grad : list) {
            SysUtil.setNullCreate((BaseEntity)grad);
            grad.setPerformanceTemplateId(head.getId());
            String itemId = (String)itemIdMap.get(grad.getPerformanceTemplateItemId());
            grad.setId(IdWorker.getIdStr());
            grad.setPerformanceTemplateItemId(itemId);
            grad.setCreateBy(null);
            grad.setCreateById(null);
            grad.setCreateTime(null);
            grad.setUpdateBy(null);
            grad.setUpdateById(null);
            grad.setUpdateTime(null);
        }
        List<PurchasePerformanceTemplateItemFormula> list2 = this.purchasePerformanceTemplateItemFormulaMapper.selectByMainId(id);
        for (PurchasePerformanceTemplateItemFormula formula : list2) {
            SysUtil.setNullCreate((BaseEntity)formula);
            formula.setPerformanceTemplateId(head.getId());
            String itemId = (String)itemIdMap.get(formula.getPerformanceTemplateItemId());
            formula.setId(IdWorker.getIdStr());
            formula.setPerformanceTemplateItemId(itemId);
            formula.setCreateBy(null);
            formula.setCreateById(null);
            formula.setCreateTime(null);
            formula.setUpdateBy(null);
            formula.setUpdateById(null);
            formula.setUpdateTime(null);
        }
        if (CollectionUtils.isNotEmpty(normWeightList)) {
            ((PurchasePerformanceTemplateNormWeightService)SpringContextUtils.getBean(PurchasePerformanceTemplateNormWeightService.class)).saveBatch(normWeightList);
        }
        if (CollectionUtils.isNotEmpty(list2)) {
            ((PurchasePerformanceTemplateItemFormulaService)SpringContextUtils.getBean(PurchasePerformanceTemplateItemFormulaService.class)).saveBatch(list2);
        }
        if (CollectionUtils.isNotEmpty(list)) {
            ((PurchasePerformanceTemplateItemGradService)SpringContextUtils.getBean(PurchasePerformanceTemplateItemGradService.class)).saveBatch(list);
        }
        if (CollectionUtils.isNotEmpty(itemList)) {
            ((PurchasePerformanceTemplateItemService)SpringContextUtils.getBean(PurchasePerformanceTemplateItemService.class)).saveBatch(itemList);
        }
        if (CollectionUtils.isNotEmpty(templateGradList)) {
            ((PurchasePerformanceTemplateGradService)SpringContextUtils.getBean(PurchasePerformanceTemplateGradService.class)).saveBatch(templateGradList);
        }
        return head;
    }
}

