/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.supplier.adapter;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.els.aspect.param.DictTranslateAspectParam;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.RpcService;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.exception.ELSBootException;
import com.els.common.service.DictTranslateService;
import com.els.common.system.vo.MsgParamsVO;
import com.els.common.util.I18nUtil;
import com.els.common.util.MqUtil;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.account.api.dto.ElsSubAccountDTO;
import com.els.modules.account.api.dto.LoginUserDTO;
import com.els.modules.supplier.entity.SupplierInfoChangeHead;
import com.els.modules.supplier.entity.SupplierInfoChangeItem;
import com.els.modules.supplier.entity.SupplierInfoChangeRejection;
import com.els.modules.supplier.entity.SupplierMasterData;
import com.els.modules.supplier.enumerate.SupplierInfoChangStatusEnum;
import com.els.modules.supplier.mapper.SupplierInfoChangeHeadMapper;
import com.els.modules.supplier.mapper.SupplierInfoChangeItemMapper;
import com.els.modules.supplier.mapper.SupplierInfoChangeRejectionMapper;
import com.els.modules.supplier.service.SupplierInfoChangeHeadService;
import com.els.modules.supplier.service.SupplierMasterDataService;
import com.els.modules.supplier.vo.SupplierMasterDataVO;
import com.els.modules.workflow.dto.AuditInputParamDTO;
import com.els.modules.workflow.dto.AuditOutputParamDTO;
import com.els.modules.workflow.enums.WorkFlowType;
import com.els.modules.workflow.rpc.service.AuditOptCallBackService;
import com.els.rpc.service.CoreInvokeSupplierRpcService;
import com.els.rpc.service.InvokeAccountRpcService;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@RpcService(value="supplierInfoChangRpcAdapter")
public class SupplierInfoChangAuditOptCallBackServiceImpl
implements AuditOptCallBackService {
    private static final Logger log = LoggerFactory.getLogger(SupplierInfoChangAuditOptCallBackServiceImpl.class);
    @Autowired
    private SupplierMasterDataService supplierMasterDataService;
    @Autowired
    private SupplierInfoChangeHeadService supplierInfoChangeHeadService;
    @Autowired
    private SupplierInfoChangeHeadMapper supplierInfoChangeHeadMapper;
    @Autowired
    private SupplierInfoChangeItemMapper supplierInfoChangeItemMapper;
    @Autowired
    private SupplierInfoChangeRejectionMapper supplierInfoChangeRejectionMapper;
    @Autowired
    private InvokeAccountRpcService invokeAccountRpcService;

    public void startCallBack(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO) {
        log.info("come in supplierInfoChangAuditOptCallBackServiceImpl to startCallBack\uff1a" + inputParamVO.getBusinessId());
        this.updateStatus(inputParamVO, outputParamVO);
        for (String account : outputParamVO.getNextAuditUserList()) {
            MsgParamsVO msgParamsVO = this.parameterAssemble(inputParamVO, outputParamVO, account);
            Object operataion = "submitAudit";
            if (WorkFlowType.BPMN.getValue().equals(outputParamVO.getBpmnType())) {
                operataion = outputParamVO.getBpmnType() + "_submitAudit";
            }
            MqUtil.sendBusMsg((String)TenantContext.getTenant(), (String)"SupplierInfoChange", (String)operataion, (MsgParamsVO)msgParamsVO);
        }
    }

    public void completeCallBack(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO) {
        if (AuditStatusEnum.AUDIT_FINISH.getValue().equals(outputParamVO.getAuditStatus())) {
            SupplierInfoChangeHead head = (SupplierInfoChangeHead)((Object)this.supplierInfoChangeHeadMapper.selectById((Serializable)((Object)inputParamVO.getBusinessId())));
            if (head != null && SupplierInfoChangStatusEnum.INVALID.getValue().equals(head.getStatus())) {
                throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_mtFIkuSTKUz_d471b090", (String)"\u6b64\u5355\u636e\u5df2\u4f5c\u5e9f\uff0c\u65e0\u9700\u518d\u5ba1\u6279\uff01"));
            }
            SupplierInfoChangeHead changeHead = new SupplierInfoChangeHead();
            changeHead.setId(inputParamVO.getBusinessId());
            changeHead.setAuditStatus(outputParamVO.getAuditStatus());
            changeHead.setFlowId(outputParamVO.getProcessRootId());
            changeHead.setWorkFlowType(outputParamVO.getBpmnType());
            changeHead.setStatus(SupplierInfoChangStatusEnum.EFFECTIVE.getValue());
            if (head != null && !head.getElsAccount().equals(head.getInitiatorElsAccount()) && SupplierInfoChangStatusEnum.WAIT_CONFIRM.getValue().equals(head.getStatus())) {
                changeHead.setStatus(SupplierInfoChangStatusEnum.CONFIRM.getValue());
            }
            changeHead.setDataVersion(head.getDataVersion());
            this.supplierInfoChangeHeadMapper.updateById((Object)changeHead);
            List<SupplierInfoChangeItem> changeItemList = this.supplierInfoChangeItemMapper.selectByMainId(changeHead.getId());
            SupplierInfoChangeItem infoChangeItem = changeItemList.get(0);
            String updateAfterData = infoChangeItem.getUpdateAfterData();
            SupplierMasterDataVO masterDataVO = (SupplierMasterDataVO)((Object)JSONObject.parseObject((String)updateAfterData, SupplierMasterDataVO.class));
            SupplierMasterData masterData = this.supplierMasterDataService.getByAccount(masterDataVO.getElsAccount(), masterDataVO.getToElsAccount());
            masterDataVO.setDataVersion(masterData != null ? masterData.getDataVersion() : masterDataVO.getDataVersion());
            this.supplierMasterDataService.updateMainNoAudit(masterDataVO);
            if (!head.getToElsAccount().equals(head.getInitiatorElsAccount())) {
                this.sendMessage(head.getElsAccount(), "SupplierInfoChange", "auditPass", changeHead.getId(), "supplierInfoChangeBusDataServiceImpl", Lists.newArrayList((Object[])new String[]{head.getElsAccount()}));
            }
        } else {
            for (String account : outputParamVO.getNextAuditUserList()) {
                MsgParamsVO msgParamsVO = this.parameterAssemble(inputParamVO, outputParamVO, account);
                Object operataion = "submitAudit";
                if (WorkFlowType.BPMN.getValue().equals(outputParamVO.getBpmnType())) {
                    operataion = outputParamVO.getBpmnType() + "_submitAudit";
                }
                MqUtil.sendBusMsg((String)TenantContext.getTenant(), (String)"SupplierInfoChange", (String)operataion, (MsgParamsVO)msgParamsVO);
            }
        }
    }

    public void rejectCallBack(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO) {
        this.updateStatus(inputParamVO, outputParamVO);
        MsgParamsVO msgParamsVO = this.parameterAssemble(inputParamVO, outputParamVO, outputParamVO.getSubmitUser());
        MqUtil.sendBusMsg((String)TenantContext.getTenant(), (String)"SupplierInfoChange", (String)"auditReject", (MsgParamsVO)msgParamsVO);
    }

    public void cancelCallBack(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO) {
        this.updateStatus(inputParamVO, outputParamVO);
    }

    public JSONObject getDataById(String id) {
        SupplierInfoChangeHead head = (SupplierInfoChangeHead)((Object)this.supplierInfoChangeHeadMapper.selectById((Serializable)((Object)id)));
        if (head != null) {
            Result result = Result.ok((Object)((Object)head));
            JSONObject jsonObject = ((DictTranslateService)SpringContextUtils.getBean(DictTranslateService.class)).parseJson((Object)head, new DictTranslateAspectParam());
            return jsonObject;
        }
        return null;
    }

    public void updateStatus(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO) {
        String param = StrUtil.isBlank((CharSequence)inputParamVO.getParams()) ? "{}" : inputParamVO.getParams();
        SupplierMasterDataVO dataVO = (SupplierMasterDataVO)((Object)JSONObject.parseObject((String)param, SupplierMasterDataVO.class));
        SupplierInfoChangeHead head = (SupplierInfoChangeHead)((Object)this.supplierInfoChangeHeadMapper.selectById((Serializable)((Object)inputParamVO.getBusinessId())));
        if (dataVO != null && StrUtil.isNotBlank((CharSequence)dataVO.getAuditChangeTypeCode())) {
            head.setAuditChangeTypeCode(dataVO.getAuditChangeTypeCode());
        }
        if (head != null && SupplierInfoChangStatusEnum.INVALID.getValue().equals(head.getStatus())) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_mtFIkuSTKUz_d471b090", (String)"\u6b64\u5355\u636e\u5df2\u4f5c\u5e9f\uff0c\u65e0\u9700\u518d\u5ba1\u6279\uff01"));
        }
        SupplierInfoChangeHead changeHead = new SupplierInfoChangeHead();
        changeHead.setId(inputParamVO.getBusinessId());
        changeHead.setNeedAudit("1");
        changeHead.setAuditStatus(outputParamVO.getAuditStatus());
        changeHead.setFlowId(outputParamVO.getProcessRootId());
        changeHead.setWorkFlowType(outputParamVO.getBpmnType());
        if (head != null && AuditStatusEnum.AUDIT_REJECT.getValue().equals(outputParamVO.getAuditStatus()) && SupplierInfoChangStatusEnum.WAIT_CONFIRM.getValue().equals(head.getStatus())) {
            changeHead.setStatus(SupplierInfoChangStatusEnum.BLACKLIST.getValue());
            changeHead.setRejectReason(outputParamVO.getOpinion());
            SupplierInfoChangeRejection rejection = new SupplierInfoChangeRejection();
            rejection.setHeadId(head.getId());
            rejection.setChangeNumber(head.getChangeNumber());
            rejection.setElsAccount(head.getElsAccount());
            rejection.setToElsAccount(head.getToElsAccount());
            rejection.setOpinion(outputParamVO.getOpinion());
            this.supplierInfoChangeRejectionMapper.insert((Object)rejection);
        }
        List<SupplierInfoChangeItem> changeItemList = this.supplierInfoChangeItemMapper.selectByMainId(changeHead.getId());
        SupplierInfoChangeItem infoChangeItem = changeItemList.get(0);
        String updateAfterData = infoChangeItem.getUpdateAfterData();
        SupplierMasterDataVO masterDataVO = (SupplierMasterDataVO)((Object)JSONObject.parseObject((String)updateAfterData, SupplierMasterDataVO.class));
        masterDataVO.setNeedAudit("1");
        masterDataVO.setAuditStatus(outputParamVO.getAuditStatus());
        masterDataVO.setSupplierInfoChangeId(changeHead.getId());
        masterDataVO.setSupplierInfoChangeDataVersion(changeHead.getDataVersion());
        if (dataVO != null && StrUtil.isNotBlank((CharSequence)dataVO.getAuditChangeTypeCode())) {
            masterDataVO.setAuditChangeTypeCode(dataVO.getAuditChangeTypeCode());
        }
        ((SupplierInfoChangeHeadService)SpringContextUtils.getBean(SupplierInfoChangeHeadService.class)).saveMain(masterDataVO);
        head = (SupplierInfoChangeHead)((Object)this.supplierInfoChangeHeadMapper.selectById((Serializable)((Object)inputParamVO.getBusinessId())));
        changeHead.setDataVersion(head.getDataVersion());
        this.supplierInfoChangeHeadMapper.updateById((Object)changeHead);
        if (head != null && AuditStatusEnum.AUDIT_REJECT.getValue().equals(outputParamVO.getAuditStatus()) && SupplierInfoChangStatusEnum.WAIT_CONFIRM.getValue().equals(head.getStatus())) {
            String url = "id=" + head.getId();
            this.sendMsg(head.getElsAccount(), Lists.newArrayList((Object[])new String[]{head.getToElsAccount()}), (Object)head, url, "SupplierInfoChange", "purchaseReject");
        }
    }

    private MsgParamsVO parameterAssemble(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO, String account) {
        MsgParamsVO msgParamsVO = new MsgParamsVO();
        ArrayList<ElsSubAccountDTO> accountList = new ArrayList<ElsSubAccountDTO>();
        HashMap<String, ArrayList<ElsSubAccountDTO>> receiverMap = new HashMap<String, ArrayList<ElsSubAccountDTO>>();
        ElsSubAccountDTO subAccount = this.invokeAccountRpcService.getAccount(TenantContext.getTenant(), account.split("_")[1]);
        accountList.add(subAccount);
        receiverMap.put(TenantContext.getTenant(), accountList);
        msgParamsVO.setReceiverMap(receiverMap);
        String outAuditPassUrl = SysUtil.getOutAuditPassUrl((ElsSubAccountDTO)subAccount, (String)outputParamVO.getProcessRootId(), (String)inputParamVO.getBusinessType(), (String)inputParamVO.getBusinessId());
        String outAuditRejectUrl = SysUtil.getOutAuditPassUrl((ElsSubAccountDTO)subAccount, (String)outputParamVO.getProcessRootId(), (String)inputParamVO.getBusinessType(), (String)inputParamVO.getBusinessId());
        String headId = inputParamVO.getBusinessId();
        SupplierInfoChangeHead head = (SupplierInfoChangeHead)((Object)this.supplierInfoChangeHeadMapper.selectById((Serializable)((Object)headId)));
        Result result = Result.ok((Object)((Object)head));
        JSONObject jsonObject = ((DictTranslateService)SpringContextUtils.getBean(DictTranslateService.class)).parseJson((Object)head, new DictTranslateAspectParam());
        Map paramMap = (Map)JSON.parse((String)jsonObject.toString());
        paramMap.put("outAuditPassUrl", outAuditPassUrl);
        paramMap.put("outAuditRejectUrl", outAuditRejectUrl);
        msgParamsVO.setParams((Object)paramMap);
        HashMap<String, JSONObject> receiveParamMap = new HashMap<String, JSONObject>();
        JSONObject paramObj = new JSONObject();
        if (AuditStatusEnum.AUDIT_DOING.getValue().equals(outputParamVO.getAuditStatus())) {
            paramObj.put("businessId", (Object)inputParamVO.getBusinessId());
            paramObj.put("businessType", (Object)inputParamVO.getBusinessType());
            if (account.split("_").length > 2) {
                paramObj.put("taskId", (Object)account.split("_")[2]);
            }
            if (account.split("_").length > 3) {
                paramObj.put("processInstanceId", (Object)account.split("_")[3]);
            }
        } else {
            paramObj.put("id", (Object)inputParamVO.getBusinessId());
        }
        receiveParamMap.put(TenantContext.getTenant(), paramObj);
        msgParamsVO.setReceiveParamMap(receiveParamMap);
        return msgParamsVO;
    }

    private void sendMsg(String purchaseElsAccount, List<String> toElsAccountList, Object object, String url, String businessType, String operateType) {
        try {
            LoginUserDTO loginUser = SysUtil.getLoginUser();
            CoreInvokeSupplierRpcService coreInvokeSupplierRpcService = (CoreInvokeSupplierRpcService)SpringContextUtils.getBean(CoreInvokeSupplierRpcService.class);
            Map receiverMap = coreInvokeSupplierRpcService.getSupplierContacts(purchaseElsAccount, toElsAccountList, businessType, operateType);
            JSONObject msgObj = new JSONObject();
            msgObj.put("msgKey", (Object)IdWorker.getIdStr());
            msgObj.put("busAccount", (Object)purchaseElsAccount);
            msgObj.put("businessType", (Object)businessType);
            msgObj.put("operateType", (Object)operateType);
            msgObj.put("businessObj", (Object)SysUtil.objectToJSON((Object)object));
            msgObj.put("sendObj", (Object)loginUser);
            JSONArray array = new JSONArray();
            for (String toElsAccount : receiverMap.keySet()) {
                JSONArray toSubAccountArray = JSONArray.parseArray((String)JSON.toJSONString(receiverMap.get(toElsAccount)));
                JSONObject receiveObj = new JSONObject();
                receiveObj.put("toElsAccount", (Object)toElsAccount);
                receiveObj.put("urlParam", (Object)url);
                receiveObj.put("toSubAccountList", (Object)toSubAccountArray);
                array.add((Object)receiveObj);
            }
            msgObj.put("receiveList", (Object)array);
            MqUtil.sendBusMsg((String)msgObj.toJSONString());
        }
        catch (Exception e) {
            log.error("sendMsg failed:", (Throwable)e);
        }
    }

    public void sendMessage(String busAccount, String businessType, String operateType, String businessId, String businessBean, List<String> toElsAccountList) {
        try {
            if (StrUtil.isBlank((CharSequence)busAccount) || toElsAccountList == null || toElsAccountList.isEmpty() || StrUtil.isBlank((CharSequence)businessId) || StrUtil.isBlank((CharSequence)businessBean) || StrUtil.isBlank((CharSequence)businessType) || StrUtil.isBlank((CharSequence)operateType)) {
                log.error("sendMessage_failed:\u7f3a\u5c11\u5fc5\u8981\u53c2\u6570\uff01");
                return;
            }
            JSONObject msgObj = new JSONObject();
            msgObj.put("msgId", (Object)IdWorker.getIdStr());
            msgObj.put("busAccount", (Object)busAccount);
            msgObj.put("elsAccount", (Object)TenantContext.getTenant());
            msgObj.put("businessType", (Object)businessType);
            msgObj.put("operateType", (Object)operateType);
            msgObj.put("businessId", (Object)businessId);
            msgObj.put("businessBean", (Object)businessBean);
            msgObj.put("sendObj", (Object)SysUtil.getLoginUser());
            msgObj.put("toElsAccountList", (Object)JSONArray.parseArray((String)JSON.toJSONString(toElsAccountList)));
            MqUtil.sendBusMsg((String)msgObj.toJSONString());
        }
        catch (Exception e) {
            log.error("sendMessage_failed:", (Throwable)e);
        }
    }
}

