/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.supplier.excel;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.IService;
import com.els.common.aspect.annotation.RpcService;
import com.els.common.excel.service.BaseExportService;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.util.PermissionDataQueryUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.service.ExportDataLoaderService;
import com.els.modules.supplier.entity.SupplierMasterData;
import com.els.modules.supplier.entity.SupplierMasterFrozen;
import com.els.modules.supplier.service.SupplierMasterDataService;
import com.els.modules.supplier.vo.SupplierMasterDataVO;
import com.els.rpc.service.InvokeBaseRpcService;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@RpcService(value="supplierMasterExportExcelDataBatchQueryLoader")
public class SupplierMasterDataExportServiceImpl
extends BaseExportService<SupplierMasterData, SupplierMasterDataVO, SupplierMasterData>
implements ExportDataLoaderService {
    private static final Logger log = LoggerFactory.getLogger(SupplierMasterDataExportServiceImpl.class);
    @Autowired
    private SupplierMasterDataService supplierMasterDataService;
    @Autowired
    private PermissionDataQueryUtil permissionDataQueryUtil;
    @Autowired
    private InvokeBaseRpcService invokeBaseRpcService;

    public List<SupplierMasterDataVO> queryExportData(QueryWrapper<SupplierMasterData> queryWrapper, SupplierMasterData param, Map<String, String[]> paramMap) {
        queryWrapper.lambda().eq(BaseEntity::getElsAccount, (Object)TenantContext.getTenant());
        List pageList = this.supplierMasterDataService.list((Wrapper)queryWrapper);
        List result = Convert.toList(SupplierMasterDataVO.class, (Object)pageList);
        if (CollUtil.isNotEmpty((Collection)result)) {
            List dictDTOS = this.invokeBaseRpcService.queryDictItemsByCode("srmFreezeFunction", TenantContext.getTenant());
            Map<String, String> dictMap = dictDTOS.stream().collect(Collectors.toMap(x -> x.getValue(), y -> y.getText()));
            for (SupplierMasterDataVO supplierMasterDataVO : result) {
                if (!StrUtil.isNotBlank((CharSequence)supplierMasterDataVO.getFrozenFunction())) continue;
                try {
                    List supplierMasterFrozens = JSONArray.parseArray((String)supplierMasterDataVO.getFrozenFunction(), SupplierMasterFrozen.class);
                    List frozenFunction = supplierMasterFrozens.stream().filter(x -> StrUtil.isNotBlank((CharSequence)x.getFrozenFunction()) && StrUtil.equals((CharSequence)"1", (CharSequence)x.getFrozenStatus()) && (StrUtil.equals((CharSequence)"0", (CharSequence)x.getIsInvalid()) || StrUtil.isEmpty((CharSequence)x.getIsInvalid()))).map(x -> x.getFrozenFunction()).distinct().collect(Collectors.toList());
                    supplierMasterDataVO.setFrozenFunction(frozenFunction.stream().map(x -> (String)dictMap.get(x)).distinct().collect(Collectors.joining(",")));
                }
                catch (Exception e) {
                    log.error("\u4f9b\u5e94\u5546\u5217\u8868\u5bfc\u51fa,\u4f9b\u5e94\u5546{}\u5904\u7406\u51bb\u7ed3\u6570\u636e\u5f02\u5e38", (Object)supplierMasterDataVO.getSupplierName(), (Object)e);
                }
            }
        }
        return result;
    }

    public long queryExportDataCount(QueryWrapper<SupplierMasterData> queryWrapper, SupplierMasterData map, Map<String, String[]> paramMap) {
        queryWrapper.lambda().eq(BaseEntity::getElsAccount, (Object)TenantContext.getTenant());
        return this.supplierMasterDataService.count((Wrapper)queryWrapper);
    }

    public String getBusinessType() {
        return "SupplierMasterList";
    }

    public String getBeanName() {
        return "supplierMasterExportExcelDataBatchQueryLoader";
    }

    public String loadData(Integer pageNumber, Integer pageSize, Map<String, Object> entityMap, Map<String, String[]> requestParamMap) {
        return this.builderWrapper(entityMap, requestParamMap, pageNumber, pageSize, (IService)this.supplierMasterDataService);
    }
}

