/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.supplier.service.impl;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.RedisUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.supplier.entity.EnterpriseCreditReport;
import com.els.modules.supplier.entity.SupplierMasterData;
import com.els.modules.supplier.enumerate.CreditReportSourceEnum;
import com.els.modules.supplier.mapper.EnterpriseCreditReportMapper;
import com.els.modules.supplier.mapper.SupplierMasterDataMapper;
import com.els.modules.supplier.rpc.service.SupplierInvokeBaseRpcService;
import com.els.modules.supplier.service.EnterpriseCreditReportService;
import com.els.rpc.service.InvokeBaseRpcService;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.HttpURLConnection;
import java.net.URL;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class EnterpriseCreditReportServiceImpl
extends BaseServiceImpl<EnterpriseCreditReportMapper, EnterpriseCreditReport>
implements EnterpriseCreditReportService {
    private static final String ENTERPRISE_CREDIT_REPORT_BASE = "0";
    @Value(value="${els.path.upload}")
    private String uploadpath;
    @Resource
    private SupplierInvokeBaseRpcService supplierinvokeBaseRpcService;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;
    @Resource
    private SupplierMasterDataMapper supplierMasterDataMapper;
    @Autowired
    private RedisUtil redisUtil;

    @Override
    public void saveEnterpriseCreditReport(EnterpriseCreditReport enterpriseCreditReport) {
        if (StrUtil.isBlank((CharSequence)enterpriseCreditReport.getEnterpriseName())) {
            throw new ELSBootException("\u4f01\u4e1a\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StrUtil.isBlank((CharSequence)enterpriseCreditReport.getReportType())) {
            enterpriseCreditReport.setReportType(ENTERPRISE_CREDIT_REPORT_BASE);
        }
        QueryWrapper wrapper = new QueryWrapper();
        String elsAccount = TenantContext.getTenant();
        wrapper.eq((Object)"els_account", (Object)elsAccount);
        wrapper.eq((Object)"enterprise_name", (Object)enterpriseCreditReport.getEnterpriseName());
        wrapper.eq((Object)"fbk2", (Object)CreditReportSourceEnum.TIANYANCHA.getValue());
        wrapper.eq((Object)"report_type", (Object)enterpriseCreditReport.getReportType());
        if (this.getOne((Wrapper)wrapper) != null) {
            String type = enterpriseCreditReport.getReportType().equals(ENTERPRISE_CREDIT_REPORT_BASE) ? "\uff08\u57fa\u7840\u7248\uff09" : "\uff08\u4e13\u4e1a\u7248\uff09";
            throw new ELSBootException("\u4f01\u4e1a\uff08" + enterpriseCreditReport.getEnterpriseName() + "\uff09\u7684" + type + "\u4fe1\u7528\u62a5\u544a\u5df2\u5b58\u5728\uff0c\u82e5\u9700\u8981\u5237\u65b0\uff0c\u53ef\u70b9\u51fb\u5237\u65b0\u6309\u94ae");
        }
        enterpriseCreditReport = this.handleEnterpriseCreditReport(enterpriseCreditReport, elsAccount);
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"els_account", (Object)elsAccount);
        queryWrapper.eq((Object)"supplier_name", (Object)enterpriseCreditReport.getEnterpriseName());
        List list = this.supplierMasterDataMapper.selectList((Wrapper)queryWrapper);
        if (!list.isEmpty()) {
            enterpriseCreditReport.setSupplierAccount(((SupplierMasterData)((Object)list.get(0))).getToElsAccount());
        }
        enterpriseCreditReport.setFbk2(CreditReportSourceEnum.TIANYANCHA.getValue());
        ((EnterpriseCreditReportMapper)this.baseMapper).insert((Object)enterpriseCreditReport);
    }

    public EnterpriseCreditReport handleEnterpriseCreditReport(EnterpriseCreditReport enterpriseCreditReport, String elsAccount) {
        String interfaceCode = ENTERPRISE_CREDIT_REPORT_BASE.equals(enterpriseCreditReport.getReportType()) ? this.invokeBaseRpcService.getIpaasInterfaceCode("enterprise_credit_report_base") : this.invokeBaseRpcService.getIpaasInterfaceCode("enterprise_credit_report_major");
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("name", (Object)enterpriseCreditReport.getEnterpriseName());
        String uuid = String.valueOf(UUID.randomUUID());
        if (!ENTERPRISE_CREDIT_REPORT_BASE.equals(enterpriseCreditReport.getReportStatus()) && StrUtil.isNotBlank((CharSequence)enterpriseCreditReport.getFbk1())) {
            jsonObject.put("uuid", (Object)enterpriseCreditReport.getFbk1());
        } else {
            jsonObject.put("uuid", (Object)uuid);
            enterpriseCreditReport.setFbk1(uuid);
        }
        JSONObject requestObject = new JSONObject();
        requestObject.put("base", (Object)jsonObject);
        JSONObject result = this.supplierinvokeBaseRpcService.callIPaasInterface(requestObject, "valueAddedApplication", interfaceCode);
        if (result.getBoolean("success").booleanValue()) {
            JSONObject object = result.getJSONObject("data");
            enterpriseCreditReport.setReportStatus(object.getString("error_code"));
            enterpriseCreditReport.setStatusDesc(object.getString("reason"));
            if (ENTERPRISE_CREDIT_REPORT_BASE.equals(object.getString("error_code"))) {
                enterpriseCreditReport.setReportLink(object.getString("result"));
                enterpriseCreditReport.setReportLink(enterpriseCreditReport.getReportLink().replace("https:", "http:"));
            }
        } else {
            throw new ELSBootException(result.getString("message"));
        }
        enterpriseCreditReport.setElsAccount(elsAccount);
        enterpriseCreditReport.setReportTime(new Date());
        return enterpriseCreditReport;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String downloadFile(String filePath, String fileName, String elsAccount) {
        InputStream inputStream = null;
        OutputStream os = null;
        LocalDateTime time = LocalDateTime.now();
        DateTimeFormatter dtf = DateTimeFormatter.ofPattern("yyyyMMdd");
        String nowDay = dtf.format(time);
        try {
            int len;
            URL url = new URL(filePath);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setReadTimeout(3000);
            connection.setRequestProperty("User-Agent", "Mozilla/4.e ( compatible;MSIE 5.0; windows NT; DigExt)");
            inputStream = connection.getInputStream();
            File file = new File(this.uploadpath + File.separator + File.separator + elsAccount + File.separator + nowDay + File.separator);
            if (!file.exists()) {
                file.mkdirs();
            }
            byte[] bs = new byte[1024];
            fileName = File.separator + System.currentTimeMillis() + "_" + (String)fileName;
            os = new FileOutputStream(file.getPath() + (String)fileName);
            while ((len = inputStream.read(bs)) != -1) {
                os.write(bs, 0, len);
            }
        }
        catch (IOException iOException) {
        }
        finally {
            try {
                if (os != null) {
                    os.close();
                }
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException iOException) {}
        }
        return File.separator + elsAccount + File.separator + nowDay + (String)fileName;
    }

    @Override
    public void updateEnterpriseCreditReport(EnterpriseCreditReport enterpriseCreditReport) {
        String elsAccount = TenantContext.getTenant();
        enterpriseCreditReport = this.handleEnterpriseCreditReport(enterpriseCreditReport, elsAccount);
        ((EnterpriseCreditReportMapper)this.baseMapper).updateById((Object)enterpriseCreditReport);
    }

    @Override
    public void delEnterpriseCreditReport(String id) {
        ((EnterpriseCreditReportMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    public void delBatchEnterpriseCreditReport(List<String> idList) {
        ((EnterpriseCreditReportMapper)this.baseMapper).deleteBatchIds(idList);
    }

    @Override
    public void saveCreditInChinaReport(EnterpriseCreditReport enterpriseCreditReport) {
        String elsAccount = TenantContext.getTenant();
        if (this.redisUtil.get(elsAccount + "_credit_in_china_" + enterpriseCreditReport.getEnterpriseName()) != null) {
            throw new ELSBootException(enterpriseCreditReport.getEnterpriseName() + " \u4f01\u4e1a\u4fe1\u7528\u62a5\u544a\u83b7\u53d6\u64cd\u4f5c\u6b63\u5728\u6267\u884c\uff0c\u8bf7\u52ff\u91cd\u590d\u64cd\u4f5c");
        }
        if (StrUtil.isBlank((CharSequence)enterpriseCreditReport.getEnterpriseName())) {
            throw new ELSBootException("\u4f01\u4e1a\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        this.redisUtil.set(elsAccount + "_credit_in_china_" + enterpriseCreditReport.getEnterpriseName(), (Object)enterpriseCreditReport.getFbk3());
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"els_account", (Object)elsAccount);
        wrapper.eq((Object)"enterprise_name", (Object)enterpriseCreditReport.getEnterpriseName());
        wrapper.eq((Object)"fbk2", (Object)CreditReportSourceEnum.CREDIT_IN_CHINA.getValue());
        if (this.getOne((Wrapper)wrapper) != null) {
            this.redisUtil.del(new String[]{elsAccount + "_credit_in_china_" + enterpriseCreditReport.getEnterpriseName()});
            throw new ELSBootException("\u4f01\u4e1a\uff08" + enterpriseCreditReport.getEnterpriseName() + "\uff09\u7684\u4fe1\u7528\u62a5\u544a\u5df2\u5b58\u5728\uff0c\u82e5\u9700\u8981\u66f4\u65b0\uff0c\u53ef\u70b9\u51fb\u5237\u65b0\u6309\u94ae");
        }
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("companyName", (Object)enterpriseCreditReport.getEnterpriseName());
        jsonObject.put("creditCode", (Object)enterpriseCreditReport.getFbk3());
        JSONObject result = this.supplierinvokeBaseRpcService.callIPaasInterface(jsonObject, "valueAddedApplication", this.invokeBaseRpcService.getIpaasInterfaceCode("credit_in_china_report"));
        if (result.getBoolean("success").booleanValue()) {
            JSONObject object = result.getJSONObject("data");
            if (StrUtil.isNotBlank((CharSequence)object.getString("url"))) {
                enterpriseCreditReport.setReportLink(object.getString("url"));
            }
        } else {
            this.redisUtil.del(new String[]{elsAccount + "_credit_in_china_" + enterpriseCreditReport.getEnterpriseName()});
            throw new ELSBootException(result.getString("message"));
        }
        this.redisUtil.del(new String[]{elsAccount + "_credit_in_china_" + enterpriseCreditReport.getEnterpriseName()});
        enterpriseCreditReport.setElsAccount(elsAccount);
        enterpriseCreditReport.setReportTime(new Date());
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"els_account", (Object)elsAccount);
        queryWrapper.eq((Object)"supplier_name", (Object)enterpriseCreditReport.getEnterpriseName());
        List list = this.supplierMasterDataMapper.selectList((Wrapper)queryWrapper);
        if (!list.isEmpty()) {
            enterpriseCreditReport.setSupplierAccount(((SupplierMasterData)((Object)list.get(0))).getToElsAccount());
        }
        enterpriseCreditReport.setFbk2(CreditReportSourceEnum.CREDIT_IN_CHINA.getValue());
        ((EnterpriseCreditReportMapper)this.baseMapper).insert((Object)enterpriseCreditReport);
    }

    @Override
    public void creditInChinaUpdate(EnterpriseCreditReport enterpriseCreditReport) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("companyName", (Object)enterpriseCreditReport.getEnterpriseName());
        jsonObject.put("creditCode", (Object)enterpriseCreditReport.getFbk3());
        JSONObject result = this.supplierinvokeBaseRpcService.callIPaasInterface(jsonObject, "valueAddedApplication", this.invokeBaseRpcService.getIpaasInterfaceCode("credit_in_china_report"));
        if (result.getBoolean("success").booleanValue()) {
            JSONObject object = result.getJSONObject("data");
            if (StrUtil.isNotBlank((CharSequence)object.getString("url"))) {
                enterpriseCreditReport.setReportLink(object.getString("url"));
            }
        } else {
            throw new ELSBootException(result.getString("message"));
        }
        enterpriseCreditReport.setReportTime(new Date());
        ((EnterpriseCreditReportMapper)this.baseMapper).updateById((Object)enterpriseCreditReport);
    }
}

