/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.supplier.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.els.api.dto.BaseDTO;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.constant.CommonConstant;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.util.I18nUtil;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.account.api.dto.LoginUserDTO;
import com.els.modules.base.api.dto.PurchaseAttachmentDTO;
import com.els.modules.base.api.dto.SaleAttachmentDTO;
import com.els.modules.enterprise.api.dto.ElsEnterpriseInfoDTO;
import com.els.modules.supplier.entity.PurchaseCertificatedInfo;
import com.els.modules.supplier.entity.PurchaseStandardHead;
import com.els.modules.supplier.entity.PurchaseStandardItem;
import com.els.modules.supplier.entity.SaleStandardHead;
import com.els.modules.supplier.entity.SaleStandardItem;
import com.els.modules.supplier.entity.SupplierStandardRegulationSelection;
import com.els.modules.supplier.enumerate.CertificatedSourceTypeEnum;
import com.els.modules.supplier.enumerate.ItemizedCheckStatusEnum;
import com.els.modules.supplier.enumerate.OperationEnum;
import com.els.modules.supplier.enumerate.QuestionTypesEnum;
import com.els.modules.supplier.mapper.PurchaseStandardHeadMapper;
import com.els.modules.supplier.mapper.PurchaseStandardItemMapper;
import com.els.modules.supplier.rpc.service.SupplierInvokeBaseRpcService;
import com.els.modules.supplier.rpc.service.SupplierInvokeEnterpriseRpcService;
import com.els.modules.supplier.service.PurchaseCertificatedInfoService;
import com.els.modules.supplier.service.PurchaseStandardHeadService;
import com.els.modules.supplier.service.PurchaseStandardItemService;
import com.els.modules.supplier.service.SaleStandardHeadService;
import com.els.modules.supplier.service.SaleStandardItemService;
import com.els.modules.supplier.service.SupplierStandardRegulationSelectionService;
import com.els.modules.supplier.vo.SaleStandardHeadVO;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.lang.invoke.CallSite;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PurchaseStandardHeadServiceImpl
extends ServiceImpl<PurchaseStandardHeadMapper, PurchaseStandardHead>
implements PurchaseStandardHeadService {
    @Autowired
    private PurchaseStandardHeadMapper purchaseStandardHeadMapper;
    @Autowired
    private PurchaseStandardItemMapper purchaseStandardItemMapper;
    @Autowired
    private PurchaseStandardItemService purchaseStandardItemService;
    @Autowired
    private SupplierInvokeBaseRpcService invokeBaseRpcService;
    @Autowired
    private SupplierInvokeEnterpriseRpcService invokeEnterpriseRpcService;
    @Autowired
    private SaleStandardHeadService saleStandardHeadService;
    @Autowired
    private SaleStandardItemService saleStandardItemService;
    @Autowired
    private SupplierStandardRegulationSelectionService supplierStandardRegulationSelectionService;
    @Autowired
    private PurchaseCertificatedInfoService purchaseCertificatedInfoService;

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void saveMain(PurchaseStandardHead purchaseStandardHead, List<PurchaseStandardItem> purchaseStandardItemList, List<PurchaseAttachmentDTO> attachmentList) {
        ElsEnterpriseInfoDTO info = this.invokeEnterpriseRpcService.getByElsAccount(TenantContext.getTenant());
        if (info != null) {
            purchaseStandardHead.setPurchaseName(info.getName());
        }
        purchaseStandardHead.setAuditStatus(AuditStatusEnum.AUDIT_NEW.getValue());
        purchaseStandardHead.setSendStatus("0");
        purchaseStandardHead.setStandardStatus(ItemizedCheckStatusEnum.NEW.getValue());
        purchaseStandardHead.setStandardNumber(this.invokeBaseRpcService.getNextCode("purchaseStandardNumber", (Object)purchaseStandardHead));
        if (purchaseStandardItemList != null && purchaseStandardItemList.size() > 0) {
            ArrayList<CallSite> respondentsListStr = new ArrayList<CallSite>();
            ArrayList<String> scoerListStr = new ArrayList<String>();
            String respondentsList = "";
            String scoerList = "";
            BigDecimal fullMark = BigDecimal.ZERO;
            for (PurchaseStandardItem item : purchaseStandardItemList) {
                if (item.getFullMark() != null) {
                    fullMark = fullMark.add(item.getFullMark());
                }
                respondentsListStr.add((CallSite)((Object)(item.getParticipants() + "_" + item.getRespondents())));
                scoerListStr.add(item.getScorer());
            }
            if (CollUtil.isNotEmpty(respondentsListStr)) {
                respondentsList = StrUtil.join((CharSequence)",", respondentsListStr);
            }
            if (CollUtil.isNotEmpty(scoerListStr)) {
                scoerList = StrUtil.join((CharSequence)",", scoerListStr);
            }
            purchaseStandardHead.setFullMark(fullMark);
            purchaseStandardHead.setRespondentsList(respondentsList);
            purchaseStandardHead.setScorerList(scoerList);
        }
        purchaseStandardHead.setBusAccount(purchaseStandardHead.getElsAccount());
        this.purchaseStandardHeadMapper.insert((Object)purchaseStandardHead);
        this.invokeBaseRpcService.deletePurchaseAttachment(purchaseStandardHead.getId());
        this.insertData(purchaseStandardHead, purchaseStandardItemList, attachmentList, OperationEnum.NEW_AND_EDIT.getValue());
    }

    @Override
    public void copyById(String id) {
        List<PurchaseAttachmentDTO> purchaseAttachmentList;
        PurchaseStandardHead purchaseStandardHead = (PurchaseStandardHead)((Object)this.getById((Serializable)((Object)id)));
        purchaseStandardHead.setId(null);
        purchaseStandardHead.setAuditStatus(null);
        purchaseStandardHead.setSendStatus(null);
        purchaseStandardHead.setStandardStatus(null);
        purchaseStandardHead.setStandardNumber(null);
        purchaseStandardHead.setBusAccount(null);
        purchaseStandardHead.setFlowId(null);
        purchaseStandardHead.setElsAccount(TenantContext.getTenant());
        purchaseStandardHead.setCreateBy(null);
        purchaseStandardHead.setCreateById(null);
        purchaseStandardHead.setCreateTime(null);
        purchaseStandardHead.setUpdateBy(null);
        purchaseStandardHead.setUpdateById(null);
        purchaseStandardHead.setUpdateTime(null);
        List<PurchaseStandardItem> purchaseStandardItemList = this.purchaseStandardItemService.selectByMainId(id);
        if (CollUtil.isNotEmpty(purchaseStandardItemList)) {
            purchaseStandardItemList.forEach(x -> {
                x.setId(null);
                x.setHeadId(null);
                x.setElsAccount(null);
                x.setCreateBy(null);
                x.setCreateById(null);
                x.setCreateTime(null);
                x.setUpdateBy(null);
                x.setUpdateById(null);
                x.setUpdateTime(null);
                x.setSelectAnswer(null);
                x.setScore(null);
                x.setAnswer(null);
            });
        }
        if (CollUtil.isNotEmpty(purchaseAttachmentList = this.invokeBaseRpcService.purcahseSelectByMainId(id))) {
            purchaseAttachmentList.forEach(x -> {
                x.setId(null);
                x.setHeadId(null);
                x.setElsAccount(null);
                x.setCreateBy(null);
                x.setCreateById(null);
                x.setCreateTime(null);
                x.setUpdateBy(null);
                x.setUpdateTime(null);
            });
        }
        this.saveMain(purchaseStandardHead, purchaseStandardItemList, purchaseAttachmentList);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void updateMain(PurchaseStandardHead purchaseStandardHead, List<PurchaseStandardItem> purchaseStandardItemList, List<PurchaseAttachmentDTO> attachmentList) {
        if (purchaseStandardItemList != null && purchaseStandardItemList.size() > 0) {
            ArrayList<CallSite> respondentsListStr = new ArrayList<CallSite>();
            ArrayList<String> scoerListStr = new ArrayList<String>();
            String respondentsList = "";
            String scoerList = "";
            BigDecimal fullMark = BigDecimal.ZERO;
            for (PurchaseStandardItem item : purchaseStandardItemList) {
                if (item.getFullMark() != null) {
                    fullMark = fullMark.add(item.getFullMark());
                }
                respondentsListStr.add((CallSite)((Object)(item.getParticipants() + "_" + item.getRespondents())));
                scoerListStr.add(item.getScorer());
            }
            if (CollUtil.isNotEmpty(respondentsListStr)) {
                respondentsList = StrUtil.join((CharSequence)",", respondentsListStr);
            }
            if (CollUtil.isNotEmpty(scoerListStr)) {
                scoerList = StrUtil.join((CharSequence)",", scoerListStr);
            }
            purchaseStandardHead.setFullMark(fullMark);
            purchaseStandardHead.setRespondentsList(respondentsList);
            purchaseStandardHead.setScorerList(scoerList);
        }
        this.purchaseStandardHeadMapper.updateById((Object)purchaseStandardHead);
        this.purchaseStandardItemMapper.deleteByMainId(purchaseStandardHead.getId());
        this.invokeBaseRpcService.deletePurchaseAttachment(purchaseStandardHead.getId());
        this.insertData(purchaseStandardHead, purchaseStandardItemList, attachmentList, OperationEnum.NEW_AND_EDIT.getValue());
    }

    @Override
    public void updateMainByCheck(PurchaseStandardHead purchaseStandardHead, List<PurchaseStandardItem> purchaseStandardItemList, List<PurchaseAttachmentDTO> attachmentList) {
        if (purchaseStandardItemList != null && purchaseStandardItemList.size() > 0) {
            ArrayList<CallSite> respondentsListStr = new ArrayList<CallSite>();
            ArrayList<String> scoerListStr = new ArrayList<String>();
            String respondentsList = "";
            String scoerList = "";
            BigDecimal fullMark = BigDecimal.ZERO;
            for (PurchaseStandardItem item : purchaseStandardItemList) {
                if (item.getFullMark() != null) {
                    fullMark = fullMark.add(item.getFullMark());
                }
                respondentsListStr.add((CallSite)((Object)(item.getParticipants() + "_" + item.getRespondents())));
                scoerListStr.add(item.getScorer());
            }
            if (CollUtil.isNotEmpty(respondentsListStr)) {
                respondentsList = StrUtil.join((CharSequence)",", respondentsListStr);
            }
            if (CollUtil.isNotEmpty(scoerListStr)) {
                scoerList = StrUtil.join((CharSequence)",", scoerListStr);
            }
            purchaseStandardHead.setFullMark(fullMark);
            purchaseStandardHead.setRespondentsList(respondentsList);
            purchaseStandardHead.setScorerList(scoerList);
        }
        this.purchaseStandardHeadMapper.updateById((Object)purchaseStandardHead);
        this.purchaseStandardItemMapper.deleteByMainId(purchaseStandardHead.getId());
        this.invokeBaseRpcService.deletePurchaseAttachment(purchaseStandardHead.getId());
        this.insertData(purchaseStandardHead, purchaseStandardItemList, attachmentList, "checkEdit");
    }

    private void rebuildHead(PurchaseStandardHead purchaseStandardHead, List<PurchaseStandardItem> purchaseStandardItemList, SaleStandardHeadVO headVO) {
        ArrayList<CallSite> respondentsListStr = new ArrayList<CallSite>();
        ArrayList<CallSite> scoerListStr = new ArrayList<CallSite>();
        String respondentsList = "";
        String scoerList = "";
        for (PurchaseStandardItem item : purchaseStandardItemList) {
            respondentsListStr.add((CallSite)((Object)(item.getParticipants() + "_" + item.getRespondents() + "_" + item.getItemStatus())));
            scoerListStr.add((CallSite)((Object)(item.getScorer() + "_" + item.getItemStatus())));
        }
        if (CollUtil.isNotEmpty(respondentsListStr)) {
            respondentsList = StrUtil.join((CharSequence)",", respondentsListStr);
        }
        if (CollUtil.isNotEmpty(scoerListStr)) {
            scoerList = StrUtil.join((CharSequence)",", scoerListStr);
        }
        purchaseStandardHead.setRespondentsList(respondentsList);
        purchaseStandardHead.setScorerList(scoerList);
        this.purchaseStandardHeadMapper.updateById((Object)purchaseStandardHead);
        if (null != headVO) {
            headVO.setRespondentsList(respondentsList);
            headVO.setScorerList(scoerList);
        }
    }

    private void insertData(PurchaseStandardHead purchaseStandardHead, List<PurchaseStandardItem> purchaseStandardItemList, List<PurchaseAttachmentDTO> attachmentList, String operation) {
        SaleStandardHead headVO = null;
        ArrayList<Object> saleStandardItems = null;
        BigDecimal saleFullMark = BigDecimal.ZERO;
        ArrayList<String> itemNumbers = null;
        int i = 1;
        int j = 1;
        HashMap<String, String> itemMap = new HashMap<String, String>();
        if (purchaseStandardItemList != null) {
            for (PurchaseStandardItem entity : purchaseStandardItemList) {
                entity.setElsAccount(purchaseStandardHead.getElsAccount());
                entity.setItemNumber(String.valueOf(i));
                entity.setHeadId(purchaseStandardHead.getId());
                if (operation.equals(OperationEnum.NEW_AND_EDIT.getValue())) {
                    entity.setAuditStatus(AuditStatusEnum.AUDIT_NEW.getValue());
                    entity.setItemStatus(ItemizedCheckStatusEnum.NEW.getValue());
                } else if (operation.equals("checkEdit")) {
                    entity.setAuditStatus(AuditStatusEnum.AUDIT_NEW.getValue());
                    if ("purchase".equals(entity.getParticipants()) && !ItemizedCheckStatusEnum.FINISH.getValue().equals(entity.getItemStatus()) && !ItemizedCheckStatusEnum.BE_EVALUATING.getValue().equals(entity.getItemStatus())) {
                        entity.setItemStatus(ItemizedCheckStatusEnum.ANSWER_IN.getValue());
                    }
                } else if (operation.equals(OperationEnum.SEND.getValue())) {
                    if ("purchase".equals(entity.getParticipants()) && !ItemizedCheckStatusEnum.FINISH.getValue().equals(entity.getItemStatus()) && !ItemizedCheckStatusEnum.BE_EVALUATING.getValue().equals(entity.getItemStatus())) {
                        entity.setItemStatus(ItemizedCheckStatusEnum.ANSWER_IN.getValue());
                    } else if ("sale".equals(entity.getParticipants())) {
                        if (itemNumbers == null) {
                            itemNumbers = new ArrayList<String>();
                        }
                        itemNumbers.add(entity.getItemNumber());
                        entity.setItemStatus(ItemizedCheckStatusEnum.ANSWER_IN.getValue());
                        SaleStandardItem saleStandardItem = new SaleStandardItem();
                        BeanUtils.copyProperties((Object)((Object)entity), saleStandardItem);
                        saleStandardItem.setElsAccount(entity.getToElsAccount());
                        saleStandardItem.setToElsAccount(entity.getElsAccount());
                        saleStandardItem.setRelationId(entity.getId());
                        if (headVO == null) {
                            headVO = new SaleStandardHeadVO();
                            BeanUtils.copyProperties((Object)((Object)purchaseStandardHead), (Object)((Object)headVO));
                            headVO.setElsAccount(purchaseStandardHead.getToElsAccount());
                            headVO.setToElsAccount(purchaseStandardHead.getElsAccount());
                            headVO.setRelationId(purchaseStandardHead.getId());
                            saleStandardItems = new ArrayList<Object>();
                        }
                        saleFullMark = saleFullMark.add(entity.getFullMark());
                        saleStandardItem.setItemNumber(String.valueOf(j));
                        saleStandardItems.add((Object)saleStandardItem);
                        itemMap.put(String.valueOf(i), String.valueOf(j));
                        ++j;
                    }
                }
                SysUtil.setSysParam((BaseEntity)entity, (BaseEntity)purchaseStandardHead);
                ++i;
            }
            if (!purchaseStandardItemList.isEmpty()) {
                this.rebuildHead(purchaseStandardHead, purchaseStandardItemList, (SaleStandardHeadVO)headVO);
                ((PurchaseStandardItemService)SpringContextUtils.getBean(PurchaseStandardItemService.class)).saveBatch(purchaseStandardItemList);
            }
            if (headVO != null) {
                headVO.setFullMark(saleFullMark);
                SaleStandardHead supplierStandardHead = new SaleStandardHead();
                BeanUtils.copyProperties((Object)((Object)headVO), (Object)((Object)supplierStandardHead));
                HashMap<String, String> map = new HashMap<String, String>();
                for (PurchaseStandardItem purchaseStandardItem : purchaseStandardItemList) {
                    map.put(purchaseStandardItem.getRegulationNumber(), purchaseStandardItem.getId());
                }
                for (SaleStandardItem saleStandardItem : saleStandardItems) {
                    saleStandardItem.setRelationId((String)map.get(saleStandardItem.getRegulationNumber()));
                }
                this.saleStandardHeadService.saveMain(supplierStandardHead, (List<SaleStandardItem>)saleStandardItems);
            }
        }
        ArrayList<SaleAttachmentDTO> saleAttachmentArrayList = new ArrayList<SaleAttachmentDTO>();
        if (CollectionUtil.isNotEmpty(attachmentList)) {
            for (PurchaseAttachmentDTO attachment : attachmentList) {
                attachment.setHeadId(purchaseStandardHead.getId());
                if (StrUtil.isBlank((CharSequence)attachment.getUploadElsAccount())) {
                    attachment.setUploadElsAccount(purchaseStandardHead.getElsAccount());
                }
                attachment.setBusinessType("purchase_standard");
                if (operation.equals(OperationEnum.SEND.getValue())) {
                    attachment.setSendStatus("1");
                } else {
                    attachment.setSendStatus("0");
                }
                SysUtil.setSysParam((BaseDTO)attachment, (BaseEntity)purchaseStandardHead);
                attachment.setId(null);
                if (headVO == null || itemNumbers == null || !itemNumbers.contains(attachment.getItemNumber())) continue;
                SaleAttachmentDTO saleAttachmentDTO = new SaleAttachmentDTO();
                BeanUtils.copyProperties((Object)attachment, (Object)saleAttachmentDTO);
                saleAttachmentDTO.setId(null);
                saleAttachmentDTO.setRelationId(attachment.getId());
                saleAttachmentDTO.setElsAccount(headVO.getElsAccount());
                saleAttachmentDTO.setHeadId(headVO.getId());
                saleAttachmentDTO.setDeleted(CommonConstant.DEL_FLAG_0);
                saleAttachmentDTO.setItemNumber((String)itemMap.get(saleAttachmentDTO.getItemNumber()));
                saleAttachmentArrayList.add(saleAttachmentDTO);
            }
            this.invokeBaseRpcService.insertPurchaseBatchSomeColumn(attachmentList);
        }
        if (saleAttachmentArrayList.size() > 0) {
            this.invokeBaseRpcService.insertSaleBatchSomeColumn(saleAttachmentArrayList);
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void delMain(String id) {
        this.purchaseStandardItemMapper.deleteByMainId(id);
        this.purchaseStandardHeadMapper.deleteById((Serializable)((Object)id));
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void delBatchMain(List<String> idList) {
        for (Serializable serializable : idList) {
            this.purchaseStandardItemMapper.deleteByMainId(serializable.toString());
            this.purchaseStandardHeadMapper.deleteById(serializable);
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void publish(PurchaseStandardHead purchaseStandardHead, List<PurchaseStandardItem> purchaseStandardItemList, List<PurchaseAttachmentDTO> attachmentList) {
        purchaseStandardHead.setApplyDate(new Date());
        purchaseStandardHead.setStandardStatus(ItemizedCheckStatusEnum.ANSWER_IN.getValue());
        purchaseStandardHead.setSendStatus("1");
        if (purchaseStandardItemList != null && purchaseStandardItemList.size() > 0) {
            ArrayList<CallSite> respondentsListStr = new ArrayList<CallSite>();
            ArrayList<String> scoerListStr = new ArrayList<String>();
            String respondentsList = "";
            String scoerList = "";
            BigDecimal fullMark = BigDecimal.ZERO;
            for (PurchaseStandardItem item : purchaseStandardItemList) {
                if (item.getFullMark() != null) {
                    fullMark = fullMark.add(item.getFullMark());
                }
                respondentsListStr.add((CallSite)((Object)(item.getParticipants() + "_" + item.getRespondents())));
                scoerListStr.add(item.getScorer());
            }
            if (CollUtil.isNotEmpty(respondentsListStr)) {
                respondentsList = StrUtil.join((CharSequence)",", respondentsListStr);
            }
            if (CollUtil.isNotEmpty(scoerListStr)) {
                scoerList = StrUtil.join((CharSequence)",", scoerListStr);
            }
            purchaseStandardHead.setFullMark(fullMark);
            purchaseStandardHead.setRespondentsList(respondentsList);
            purchaseStandardHead.setScorerList(scoerList);
        }
        this.purchaseStandardHeadMapper.updateById((Object)purchaseStandardHead);
        this.purchaseStandardItemMapper.deleteByMainId(purchaseStandardHead.getId());
        this.invokeBaseRpcService.deletePurchaseAttachment(purchaseStandardHead.getId());
        this.insertData(purchaseStandardHead, purchaseStandardItemList, attachmentList, OperationEnum.SEND.getValue());
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void submit(PurchaseStandardHead purchaseStandardHead, List<PurchaseStandardItem> purchaseStandardItemList, List<PurchaseAttachmentDTO> attachmentList) {
        boolean flag = true;
        if (purchaseStandardItemList != null) {
            LoginUserDTO loginUser = SysUtil.getLoginUser();
            for (PurchaseStandardItem entity : purchaseStandardItemList) {
                if ("purchase".equals(entity.getParticipants()) && loginUser.getSubAccount().equals(entity.getRespondents().split("_")[0])) {
                    if (!QuestionTypesEnum.SHORT_ANSWER.getValue().equals(entity.getInputType())) {
                        List<SupplierStandardRegulationSelection> regulations = this.supplierStandardRegulationSelectionService.selectByMainId(entity.getStandardId());
                        HashMap<String, BigDecimal> scoreMap = new HashMap<String, BigDecimal>();
                        for (SupplierStandardRegulationSelection selection : regulations) {
                            scoreMap.put(selection.getSelectName(), selection.getScore());
                        }
                        BigDecimal score = new BigDecimal(0);
                        if (entity.getAnswer() != null || entity.getSelectAnswer() != null) {
                            String[] answers;
                            for (String answer : answers = StrUtil.isNotBlank((CharSequence)entity.getAnswer()) ? entity.getAnswer().split(",") : entity.getSelectAnswer().split(",")) {
                                if (scoreMap.get(answer) == null) continue;
                                score = score.add((BigDecimal)scoreMap.get(answer));
                            }
                        }
                        entity.setScore(score);
                        entity.setItemStatus(ItemizedCheckStatusEnum.FINISH.getValue());
                    } else {
                        entity.setItemStatus(ItemizedCheckStatusEnum.BE_EVALUATING.getValue());
                    }
                }
                if (!"1".equals(entity.getMust()) || !ItemizedCheckStatusEnum.ANSWER_IN.getValue().equals(entity.getItemStatus())) continue;
                flag = false;
            }
            this.rebuildHead(purchaseStandardHead, purchaseStandardItemList, null);
            if (flag) {
                boolean finishFlag = true;
                BigDecimal scoreTotal = BigDecimal.ZERO;
                for (PurchaseStandardItem purchaseStandardItem : purchaseStandardItemList) {
                    if (purchaseStandardItem.getScore() != null) {
                        scoreTotal = scoreTotal.add(purchaseStandardItem.getScore());
                    }
                    if (!QuestionTypesEnum.SHORT_ANSWER.getValue().equals(purchaseStandardItem.getInputType()) || !ItemizedCheckStatusEnum.ANSWER_IN.getValue().equals(purchaseStandardHead.getStandardStatus())) continue;
                    finishFlag = false;
                }
                if (purchaseStandardHead.getFullMark() != null && BigDecimal.ZERO.compareTo(purchaseStandardHead.getFullMark()) != 0) {
                    scoreTotal = scoreTotal.multiply(BigDecimal.valueOf(100.0)).divide(purchaseStandardHead.getFullMark(), 2, 1);
                }
                purchaseStandardHead.setTotalScore(scoreTotal);
                purchaseStandardHead.setStandardStatus(ItemizedCheckStatusEnum.BE_EVALUATING.getValue());
                if (finishFlag) {
                    purchaseStandardHead.setStandardStatus(ItemizedCheckStatusEnum.FINISH.getValue());
                    for (PurchaseStandardItem entity : purchaseStandardItemList) {
                        if (!"purchase".equals(entity.getParticipants()) || !loginUser.getSubAccount().equals(entity.getRespondents().split("_")[0]) || !QuestionTypesEnum.SHORT_ANSWER.getValue().equals(entity.getInputType())) continue;
                        entity.setItemStatus(ItemizedCheckStatusEnum.FINISH.getValue());
                    }
                    if (!"1".equals(purchaseStandardHead.getAccessAuditBefore())) {
                        purchaseStandardHead.setFinish("1");
                    }
                }
            }
            this.purchaseStandardHeadMapper.updateById((Object)purchaseStandardHead);
            this.purchaseStandardItemService.updateBatchById(purchaseStandardItemList);
        }
        if (CollectionUtil.isNotEmpty(attachmentList)) {
            this.invokeBaseRpcService.deletePurchaseAttachment(purchaseStandardHead.getId());
            for (PurchaseAttachmentDTO attachment : attachmentList) {
                attachment.setHeadId(purchaseStandardHead.getId());
                if (StrUtil.isBlank((CharSequence)attachment.getUploadElsAccount())) {
                    attachment.setUploadElsAccount(purchaseStandardHead.getElsAccount());
                }
                attachment.setBusinessType("purchase_standard");
                attachment.setSendStatus("1");
                SysUtil.setSysParam((BaseDTO)attachment, (BaseEntity)purchaseStandardHead);
            }
            this.invokeBaseRpcService.insertPurchaseBatchSomeColumn(attachmentList);
        }
    }

    @Override
    public void grade(PurchaseStandardHead purchaseStandardHead, List<PurchaseStandardItem> purchaseStandardItemList) {
        boolean flag = false;
        boolean finishFlag = false;
        BigDecimal saleAddScore = BigDecimal.ZERO;
        if (purchaseStandardItemList != null) {
            ArrayList<PurchaseStandardItem> items = new ArrayList<PurchaseStandardItem>();
            ArrayList<Object> saleStandardItems = new ArrayList<Object>();
            LoginUserDTO loginUser = SysUtil.getLoginUser();
            List relationIds = purchaseStandardItemList.stream().map(PurchaseStandardItem::getRelationId).distinct().collect(Collectors.toList());
            List itemList = Lists.newArrayList();
            if (CollUtil.isNotEmpty(relationIds)) {
                itemList = this.saleStandardItemService.listByIds(relationIds);
            }
            Map itemMap = itemList.stream().collect(Collectors.toMap(BaseEntity::getId, Function.identity()));
            for (PurchaseStandardItem entity : purchaseStandardItemList) {
                if (ItemizedCheckStatusEnum.BE_EVALUATING.getValue().equals(entity.getItemStatus())) {
                    Object saleStandardItem;
                    if (loginUser.getSubAccount().equals(entity.getScorer().split("_")[0])) {
                        entity.setItemStatus(ItemizedCheckStatusEnum.FINISH.getValue());
                        items.add(entity);
                    }
                    if ("sale".equals(entity.getParticipants()) && (saleStandardItem = (SaleStandardItem)((Object)itemMap.get(entity.getRelationId()))) != null) {
                        ((SaleStandardItem)((Object)saleStandardItem)).setScore(entity.getScore());
                        ((SaleStandardItem)((Object)saleStandardItem)).setItemStatus(ItemizedCheckStatusEnum.FINISH.getValue());
                        saleStandardItems.add(saleStandardItem);
                        saleAddScore = saleAddScore.add(entity.getScore());
                    }
                }
                if ("1".equals(entity.getMust()) && ItemizedCheckStatusEnum.ANSWER_IN.getValue().equals(entity.getItemStatus())) {
                    flag = true;
                    continue;
                }
                if (!ItemizedCheckStatusEnum.BE_EVALUATING.getValue().equals(entity.getItemStatus()) && !ItemizedCheckStatusEnum.ANSWER_IN.getValue().equals(entity.getItemStatus())) continue;
                finishFlag = true;
            }
            SaleStandardHead saleHead = null;
            if (!flag) {
                if (!finishFlag) {
                    purchaseStandardHead.setStandardStatus(ItemizedCheckStatusEnum.FINISH.getValue());
                    if (!"1".equals(purchaseStandardHead.getAccessAuditBefore())) {
                        purchaseStandardHead.setFinish("1");
                    }
                    if ((saleHead = (SaleStandardHead)((Object)this.saleStandardHeadService.getById((Serializable)((Object)purchaseStandardHead.getRelationId())))) != null) {
                        saleHead.setStandardStatus(ItemizedCheckStatusEnum.FINISH.getValue());
                        if (!"1".equals(purchaseStandardHead.getAccessAuditBefore())) {
                            saleHead.setFinish("1");
                        }
                    }
                } else {
                    purchaseStandardHead.setStandardStatus(ItemizedCheckStatusEnum.BE_EVALUATING.getValue());
                }
            } else {
                purchaseStandardHead.setStandardStatus(ItemizedCheckStatusEnum.ANSWER_IN.getValue());
            }
            BigDecimal scoreTotal = BigDecimal.ZERO;
            for (PurchaseStandardItem purchaseStandardItem : purchaseStandardItemList) {
                if (purchaseStandardItem.getScore() == null) continue;
                scoreTotal = scoreTotal.add(purchaseStandardItem.getScore());
            }
            if (purchaseStandardHead.getFullMark() != null) {
                scoreTotal = scoreTotal.multiply(BigDecimal.valueOf(100.0)).divide(purchaseStandardHead.getFullMark(), 2, 1);
            }
            purchaseStandardHead.setTotalScore(scoreTotal);
            this.purchaseStandardHeadMapper.updateById((Object)purchaseStandardHead);
            this.purchaseStandardItemService.updateBatchById(purchaseStandardItemList);
            if (saleHead != null) {
                List<SaleStandardItem> items2 = this.saleStandardItemService.selectByMainId(saleHead.getId());
                for (SaleStandardItem saleStandardItem : items2) {
                    if (QuestionTypesEnum.SHORT_ANSWER.getValue().equals(saleStandardItem.getInputType()) || !ItemizedCheckStatusEnum.FINISH.getValue().equals(saleStandardItem.getItemStatus())) continue;
                    saleAddScore = saleAddScore.add(saleStandardItem.getScore());
                }
                if (saleHead.getFullMark() != null) {
                    saleAddScore = saleAddScore.multiply(BigDecimal.valueOf(100.0)).divide(saleHead.getFullMark(), 2, 1);
                }
                saleHead.setTotalScore(saleAddScore);
                this.saleStandardHeadService.updateById((Object)saleHead);
            }
            if (!saleStandardItems.isEmpty()) {
                for (SaleStandardItem saleStandardItem : saleStandardItems) {
                    this.saleStandardItemService.updateById((Object)saleStandardItem);
                }
            }
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public Result<?> shiftTo(String id, String templateNumber, String templateVersion, String templateName, String templateAccount) {
        PurchaseStandardHead head = (PurchaseStandardHead)((Object)this.getById((Serializable)((Object)id)));
        if ("1".equals(head.getShiftTo())) {
            return Result.error((String)I18nUtil.translate((String)"i18n_alert_rtIs_40dc6fca", (String)"\u8be5\u5355\u5df2\u8f6c"));
        }
        PurchaseCertificatedInfo certificatedInfo = new PurchaseCertificatedInfo();
        certificatedInfo.setElsAccount(TenantContext.getTenant());
        certificatedInfo.setPurchaseName(head.getPurchaseName());
        certificatedInfo.setToElsAccount(head.getToElsAccount());
        certificatedInfo.setSupplierName(head.getSupplierName());
        certificatedInfo.setCreateAccount(TenantContext.getTenant());
        certificatedInfo.setTemplateAccount(templateAccount);
        certificatedInfo.setTemplateName(templateName);
        certificatedInfo.setTemplateNumber(templateNumber);
        certificatedInfo.setTemplateVersion(templateVersion);
        certificatedInfo.setSourceType(CertificatedSourceTypeEnum.STANDARD.getValue());
        certificatedInfo.setShiftToId(id);
        List<PurchaseAttachmentDTO> attachments = this.invokeBaseRpcService.purcahseSelectByMainId(id);
        if (!attachments.isEmpty()) {
            for (PurchaseAttachmentDTO purchaseAttachment : attachments) {
                purchaseAttachment.setId(null);
                purchaseAttachment.setBusinessType("supplierCertificatedInfo");
            }
        }
        this.purchaseCertificatedInfoService.saveMain(certificatedInfo, attachments);
        head.setShiftTo("1");
        this.updateById((Object)head);
        return Result.ok((Object)((Object)certificatedInfo));
    }
}

