/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.supplier.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.constant.CommonConstant;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.org.api.dto.PurchaseOrganizationInfoDTO;
import com.els.modules.supplier.entity.SupplierAccessHead;
import com.els.modules.supplier.entity.SupplierAccessItem;
import com.els.modules.supplier.entity.SupplierMasterData;
import com.els.modules.supplier.entity.SupplierMasterDataAuditInfo;
import com.els.modules.supplier.entity.SupplierOrgInfo;
import com.els.modules.supplier.enumerate.SupplierAccessStatusEnum;
import com.els.modules.supplier.enumerate.SupplierStatusEnum;
import com.els.modules.supplier.mapper.SupplierAccessHeadMapper;
import com.els.modules.supplier.mapper.SupplierAccessItemMapper;
import com.els.modules.supplier.mapper.SupplierMasterDataAuditInfoMapper;
import com.els.modules.supplier.mapper.SupplierMasterDataMapper;
import com.els.modules.supplier.mapper.SupplierOrgInfoMapper;
import com.els.modules.supplier.rpc.service.SupplierInvokeBaseRpcService;
import com.els.modules.supplier.rpc.service.SupplierInvokeOrgRpcService;
import com.els.modules.supplier.service.SupplierAccessHeadService;
import com.els.modules.supplier.service.SupplierAccessItemService;
import java.io.Serializable;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SupplierAccessHeadServiceImpl
extends ServiceImpl<SupplierAccessHeadMapper, SupplierAccessHead>
implements SupplierAccessHeadService {
    @Autowired
    private SupplierAccessHeadMapper supplierAccessHeadMapper;
    @Autowired
    private SupplierAccessItemMapper supplierAccessItemMapper;
    @Autowired
    private SupplierInvokeBaseRpcService invokeBaseRpcService;
    @Autowired
    private SupplierMasterDataMapper supplierMasterDataMapper;
    @Autowired
    private SupplierMasterDataAuditInfoMapper supplierMasterDataAuditInfoMapper;
    @Autowired
    private SupplierOrgInfoMapper supplierOrgInfoMapper;
    @Resource
    private SupplierInvokeOrgRpcService supplierInvokeOrgRpcService;

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void saveMain(SupplierAccessHead supplierAccessHead, List<SupplierAccessItem> supplierAccessItemList) {
        if ("1".equals(supplierAccessHead.getRequiredAudit())) {
            supplierAccessHead.setAuditStatus(AuditStatusEnum.AUDIT_NEW.getValue());
        } else {
            supplierAccessHead.setAuditStatus(AuditStatusEnum.NO_AUDIT_REQUIRED.getValue());
        }
        supplierAccessHead.setAccessStatus(SupplierAccessStatusEnum.NEW.getValue());
        supplierAccessHead.setAccessNumber(this.invokeBaseRpcService.getNextCode("access", (Object)supplierAccessHead));
        supplierAccessHead.setDeleted(0);
        this.supplierAccessHeadMapper.insert((Object)supplierAccessHead);
        this.insertData(supplierAccessHead, supplierAccessItemList);
    }

    @Override
    public void copyById(String id) {
        SupplierAccessHead supplierAccessHead = (SupplierAccessHead)((Object)this.getById((Serializable)((Object)id)));
        supplierAccessHead.setId(null);
        supplierAccessHead.setAccessStatus(null);
        supplierAccessHead.setAccessNumber(null);
        supplierAccessHead.setFlowId(null);
        supplierAccessHead.setWorkFlowType(null);
        supplierAccessHead.setElsAccount(TenantContext.getTenant());
        supplierAccessHead.setCreateBy(null);
        supplierAccessHead.setCreateById(null);
        supplierAccessHead.setCreateTime(null);
        supplierAccessHead.setUpdateBy(null);
        supplierAccessHead.setUpdateById(null);
        supplierAccessHead.setUpdateTime(null);
        List<SupplierAccessItem> supplierAccessItemList = this.supplierAccessItemMapper.selectByMainId(id);
        if (CollUtil.isNotEmpty(supplierAccessItemList)) {
            supplierAccessItemList.forEach(x -> {
                x.setId(null);
                x.setHeadId(null);
                x.setElsAccount(null);
                x.setCreateBy(null);
                x.setCreateById(null);
                x.setCreateTime(null);
                x.setUpdateBy(null);
                x.setUpdateById(null);
                x.setUpdateTime(null);
            });
        }
        this.saveMain(supplierAccessHead, supplierAccessItemList);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void updateMain(SupplierAccessHead supplierAccessHead, List<SupplierAccessItem> supplierAccessItemList) {
        this.supplierAccessHeadMapper.updateById((Object)supplierAccessHead);
        this.supplierAccessItemMapper.deleteByMainId(supplierAccessHead.getId());
        this.insertData(supplierAccessHead, supplierAccessItemList);
        if (SupplierAccessStatusEnum.PUBLISH.getValue().equals(supplierAccessHead.getAccessStatus())) {
            this.updateSupplierMasterData(supplierAccessHead);
        }
    }

    private void insertData(SupplierAccessHead supplierAccessHead, List<SupplierAccessItem> supplierAccessItemList) {
        if (supplierAccessItemList != null) {
            for (SupplierAccessItem entity : supplierAccessItemList) {
                entity.setHeadId(supplierAccessHead.getId());
                SysUtil.setSysParam((BaseEntity)entity, (BaseEntity)supplierAccessHead);
                entity.setAccessName(supplierAccessHead.getAccessName());
                entity.setAccessNumber(supplierAccessHead.getAccessNumber());
            }
            if (!supplierAccessItemList.isEmpty()) {
                ((SupplierAccessItemService)SpringContextUtils.getBean(SupplierAccessItemService.class)).saveBatch(supplierAccessItemList);
            }
        }
    }

    private void updateSupplierMasterData(SupplierAccessHead accessHead) {
        SupplierMasterData masterData = this.supplierMasterDataMapper.getByAccount(accessHead.getElsAccount(), accessHead.getToElsAccount());
        if (masterData != null) {
            masterData.setSupplierStatus(SupplierStatusEnum.QUALIFIED_SUPPLIER.getValue());
            masterData.setAccessCategory((StrUtil.isBlank((CharSequence)masterData.getAccessCategory()) ? "" : masterData.getAccessCategory()) + ";" + accessHead.getCateCode() + "_" + accessHead.getCateName());
            this.supplierMasterDataMapper.updateById((Object)masterData);
            QueryWrapper wrapper = new QueryWrapper();
            wrapper.eq((Object)"relation_id", (Object)masterData.getId());
            wrapper.eq((Object)"audit_status", (Object)AuditStatusEnum.AUDIT_NEW.getValue());
            SupplierMasterDataAuditInfo oldInfo = (SupplierMasterDataAuditInfo)((Object)this.supplierMasterDataAuditInfoMapper.selectOne((Wrapper)wrapper));
            if (oldInfo != null) {
                oldInfo.setAccessCategory(masterData.getAccessCategory());
                this.supplierMasterDataAuditInfoMapper.updateById((Object)oldInfo);
            }
            SupplierOrgInfo info = new SupplierOrgInfo();
            info.setHeadId(masterData.getId());
            info.setElsAccount(masterData.getToElsAccount());
            info.setToElsAccount(masterData.getElsAccount());
            info.setOrgCode(accessHead.getPurchaseOrg());
            PurchaseOrganizationInfoDTO organizationInfo = this.supplierInvokeOrgRpcService.selectByElsAccountAndCode(masterData.getElsAccount(), "purchaseOrganization", accessHead.getPurchaseOrg());
            if (organizationInfo != null) {
                info.setOrgDesc(organizationInfo.getOrgDesc());
                info.setOrgId(organizationInfo.getId());
                info.setOrgCategoryId(organizationInfo.getOrgCategoryCode());
                info.setOrgCategoryDesc(organizationInfo.getOrgCategoryDesc());
                info.setOrgFullDesc(organizationInfo.getOrgDesc());
            }
            info.setFrozenFlag("0");
            info.setPrincipal(accessHead.getPrincipal());
            info.setDataSource(accessHead.getAccessNumber());
            info.setRegulationType(accessHead.getRegulationType());
            info.setDeleted(CommonConstant.DEL_FLAG_0);
            info.setAccessed("1");
            info.setAccessCategory(accessHead.getCateCode() + "_" + accessHead.getCateName());
            this.supplierOrgInfoMapper.insert((Object)info);
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void delMain(String id) {
        this.supplierAccessItemMapper.deleteByMainId(id);
        this.supplierAccessHeadMapper.deleteById((Serializable)((Object)id));
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void delBatchMain(List<String> idList) {
        for (Serializable serializable : idList) {
            this.supplierAccessItemMapper.deleteByMainId(serializable.toString());
            this.supplierAccessHeadMapper.deleteById(serializable);
        }
    }

    @Override
    public IPage<SupplierAccessHead> selectCustomPage(Page<SupplierAccessHead> page, QueryWrapper<SupplierAccessHead> queryWrapper) {
        return this.supplierAccessHeadMapper.selectCustomPage(page, queryWrapper);
    }
}

